# References

Linear Temporal Logic on finite traces (LTL<sub>f</sub>) and 
Pure-Past Linear Temporal Logic on finite traces (PLTL<sub>f</sub>) are two
compelling well-known logical formalisms employed in several contexts, such as:

- Reasoning about Actions and Planning
    - as a specification mechanism for temporally extended goals
    - as constraints on plans
    - as preferences and soft constraints
    - for specifying multi-agent systems
    - for specifying norms
- Business Process Specification and Verification
- Synthesis
- Reinforcement Learning
    - for specifying rewards

They are famous for their clarity and ease of use.
 
A list of recommended readings:

- [Giuseppe De Giacomo and Moshe Y. Vardi. "Linear Temporal Logic and Linear Dynamic Logic on Finite Traces." IJCAI (2013)](https://www.dis.uniroma1.it/~degiacom/papers/2013/IJCAI13dv.pdf) 
- [Giuseppe De Giacomo and Moshe Y. Vardi. "Synthesis for LTL and LDL on finite traces." IJCAI (2015)](https://www.ijcai.org/Proceedings/15/Papers/223.pdf)
- [Giuseppe De Giacomo and Moshe Y. Vardi. "LTLf and LDLf synthesis under partial observability." IJCAI (2016)](http://www.diag.uniroma1.it/~degiacom/papers/2016/IJCAI16dv.pdf)
- [Brafman Ronen, De Giacomo Giuseppe, and Patrizi Fabio. "LTLf/LDLf Non-Markovian Rewards" AAAI (2018)](https://pdfs.semanticscholar.org/914f/279742a9f509934a0959c080b08e9fad771e.pdf)
- [Giuseppe De Giacomo, Antonio Di Stasio, Francesco Fuggitti and Sasha Rubin]() 