'''
# cdk-amazon-chime-resources

![Experimental](https://img.shields.io/badge/experimental-important.svg?style=for-the-badge)

An AWS Cloud Development Kit (AWS CDK) construct library that allows you to provision Amazon Chime resources with npm and pypi.

## Background

Amazon Chime resources (Amazon Chime Messaging and Amazon Chime PSTN resources) are not natively available in AWS CloudFormation or AWS CDK. Therefore, in order to create these resources with AWS CDK, an AWS Lambda backed custom resource must be used. In an effort to simplify that process, this AWS CDK construct has been created. This AWS CDK construct will create a custom resource and associated Lambda and expose constructs that can be used to create corresponding resources. This construct includes resources for both Amazon Chime Messaging and Amazon Chime PSTN.

## Resources

* [Amazon Chime PSTN Resources](PSTNRESOURCES.MD)
* [Amazon Chime Messaging Resources](MESSAGINGRESOURCES.MD)

## Installing

To add to your AWS CDK package.json file:

```
yarn add cdk-amazon-chime-resources
```

## Version 2 Upgrade

Version 2.0 is a potentially breaking change that involves multiple upgrades and changes. The original version used Python for the Custom Resources. The upgrade to version 2.0 includes a migration to Typescript for the Custom Resources. This change allows for the use of updated AWS-SDK versions and more recent APIs including expanded region selection.

## Not Supported Yet

This is a work in progress.

Features that are not supported yet:

* [ ] Amazon Chime Voice Connector Groups
* ~~[X] Amazon Chime Voice Connector Logging~~
* [ ] Amazon Chime Voice Connector Emergency Calling
* [ ] Updates to created resources

## Contributing

See [CONTRIBUTING](CONTRIBUTING.md) for more information.

## License

This project is licensed under the Apache-2.0 License.
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import aws_cdk as _aws_cdk_ceddda9d
import aws_cdk.aws_lambda as _aws_cdk_aws_lambda_ceddda9d
import aws_cdk.custom_resources as _aws_cdk_custom_resources_ceddda9d
import constructs as _constructs_77d1e7e8


@jsii.enum(jsii_type="cdk-amazon-chime-resources.AlexaSkillStatus")
class AlexaSkillStatus(enum.Enum):
    ACTIVE = "ACTIVE"
    INACTIVE = "INACTIVE"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.AppInstanceAdminProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_instance_admin_arn": "appInstanceAdminArn",
        "app_instance_arn": "appInstanceArn",
    },
)
class AppInstanceAdminProps:
    def __init__(
        self,
        *,
        app_instance_admin_arn: builtins.str,
        app_instance_arn: builtins.str,
    ) -> None:
        '''Props for ``AppInstance``.

        :param app_instance_admin_arn: The name of the app instance. Default: - None
        :param app_instance_arn: The name of the app instance. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8613bd8924c62f360b8fd11191005b6b40de3e5805e2906daf559c0c4591022d)
            check_type(argname="argument app_instance_admin_arn", value=app_instance_admin_arn, expected_type=type_hints["app_instance_admin_arn"])
            check_type(argname="argument app_instance_arn", value=app_instance_arn, expected_type=type_hints["app_instance_arn"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_instance_admin_arn": app_instance_admin_arn,
            "app_instance_arn": app_instance_arn,
        }

    @builtins.property
    def app_instance_admin_arn(self) -> builtins.str:
        '''The name of the app instance.

        :default: - None
        '''
        result = self._values.get("app_instance_admin_arn")
        assert result is not None, "Required property 'app_instance_admin_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_instance_arn(self) -> builtins.str:
        '''The name of the app instance.

        :default: - None
        '''
        result = self._values.get("app_instance_arn")
        assert result is not None, "Required property 'app_instance_arn' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppInstanceAdminProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.AppInstanceDataType")
class AppInstanceDataType(enum.Enum):
    CHANNEL = "CHANNEL"
    CHANNELMESSAGE = "CHANNELMESSAGE"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.AppInstanceProps",
    jsii_struct_bases=[],
    name_mapping={
        "client_request_token": "clientRequestToken",
        "metadata": "metadata",
        "name": "name",
        "tags": "tags",
    },
)
class AppInstanceProps:
    def __init__(
        self,
        *,
        client_request_token: typing.Optional[builtins.str] = None,
        metadata: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union["AppInstanceTags", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Props for ``AppInstance``.

        :param client_request_token: The ClientRequestToken of the app instance. This field is autopopulated if not provided. Default: - None
        :param metadata: The metadata of the app instance. Limited to a 1KB string in UTF-8. Default: - None
        :param name: The name of the app instance. Default: - None
        :param tags: The tags for the creation request. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__99641216bdb1ac5ae72a17b34ac6ca8ff8cbb075d8ddc07e9db8b47a39a2e63c)
            check_type(argname="argument client_request_token", value=client_request_token, expected_type=type_hints["client_request_token"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if client_request_token is not None:
            self._values["client_request_token"] = client_request_token
        if metadata is not None:
            self._values["metadata"] = metadata
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def client_request_token(self) -> typing.Optional[builtins.str]:
        '''The ClientRequestToken of the app instance.

        This field is autopopulated if not provided.

        :default: - None
        '''
        result = self._values.get("client_request_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metadata(self) -> typing.Optional[builtins.str]:
        '''The metadata of the app instance.

        Limited to a 1KB string in UTF-8.

        :default: - None
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the app instance.

        :default: - None
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List["AppInstanceTags"]]:
        '''The tags for the creation request.

        :default: - None
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List["AppInstanceTags"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppInstanceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppInstanceStreamingConfigurations(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.AppInstanceStreamingConfigurations",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_instance_arn: builtins.str,
        streaming_configs: typing.Sequence[typing.Union["StreamingConfig", typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param app_instance_arn: The ARN of the App Instance. Default: - None
        :param streaming_configs: The AppInstanceStreamingConfigurations. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__a9b5592853474342b6381b5e6c00a9b05345b286c1268a4def64d116f5fc5143)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = StreamingConfigurationProps(
            app_instance_arn=app_instance_arn, streaming_configs=streaming_configs
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="streamingConfigs")
    def streaming_configs(self) -> typing.List["StreamingConfig"]:
        return typing.cast(typing.List["StreamingConfig"], jsii.get(self, "streamingConfigs"))


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.AppInstanceTags",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class AppInstanceTags:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: 
        :param value: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__34e7c2248211c91c5400947a073a327c5891999890c50d304103a4b2ede75eda)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppInstanceTags(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.AppInstanceUserProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_instance_arn": "appInstanceArn",
        "app_instance_user_id": "appInstanceUserId",
        "client_request_token": "clientRequestToken",
        "metadata": "metadata",
        "name": "name",
        "tags": "tags",
    },
)
class AppInstanceUserProps:
    def __init__(
        self,
        *,
        app_instance_arn: builtins.str,
        app_instance_user_id: builtins.str,
        client_request_token: typing.Optional[builtins.str] = None,
        metadata: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union["InstanceUserTags", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Props for ``AppInstance``.

        :param app_instance_arn: The name of the app instance. Default: - None
        :param app_instance_user_id: The name of the app instance. Default: - None
        :param client_request_token: The ClientRequestToken of the app instance. This field is autopopulated if not provided. Default: - None
        :param metadata: The metadata of the app instance. Limited to a 1KB string in UTF-8. Default: - None
        :param name: The name of the app instance. Default: - None
        :param tags: The tags for the creation request. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d7f1d2afec2a1ee54c9c8c65d06e6449432e7ccd47c39718154ace20f293608b)
            check_type(argname="argument app_instance_arn", value=app_instance_arn, expected_type=type_hints["app_instance_arn"])
            check_type(argname="argument app_instance_user_id", value=app_instance_user_id, expected_type=type_hints["app_instance_user_id"])
            check_type(argname="argument client_request_token", value=client_request_token, expected_type=type_hints["client_request_token"])
            check_type(argname="argument metadata", value=metadata, expected_type=type_hints["metadata"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_instance_arn": app_instance_arn,
            "app_instance_user_id": app_instance_user_id,
        }
        if client_request_token is not None:
            self._values["client_request_token"] = client_request_token
        if metadata is not None:
            self._values["metadata"] = metadata
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_instance_arn(self) -> builtins.str:
        '''The name of the app instance.

        :default: - None
        '''
        result = self._values.get("app_instance_arn")
        assert result is not None, "Required property 'app_instance_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def app_instance_user_id(self) -> builtins.str:
        '''The name of the app instance.

        :default: - None
        '''
        result = self._values.get("app_instance_user_id")
        assert result is not None, "Required property 'app_instance_user_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def client_request_token(self) -> typing.Optional[builtins.str]:
        '''The ClientRequestToken of the app instance.

        This field is autopopulated if not provided.

        :default: - None
        '''
        result = self._values.get("client_request_token")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def metadata(self) -> typing.Optional[builtins.str]:
        '''The metadata of the app instance.

        Limited to a 1KB string in UTF-8.

        :default: - None
        '''
        result = self._values.get("metadata")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the app instance.

        :default: - None
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List["InstanceUserTags"]]:
        '''The tags for the creation request.

        :default: - None
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List["InstanceUserTags"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppInstanceUserProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ChannelFlow(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.ChannelFlow",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_instance_arn: builtins.str,
        client_request_token: builtins.str,
        processors: typing.Sequence[typing.Union["Processors", typing.Dict[builtins.str, typing.Any]]],
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union["ChannelFlowTags", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param app_instance_arn: The ARN of the App Instance. Default: - None
        :param client_request_token: The client token for the request. An Idempotency token. Default: - None
        :param processors: Information about the processor Lambda functions. Default: - None
        :param name: The name of the channel flow. Default: - None
        :param tags: The tags for the creation request. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__80c12dc139a0c6c2028b7459eefbf26ae09174ec3a969cc2f61ac8d92aac274d)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ChannelFlowProps(
            app_instance_arn=app_instance_arn,
            client_request_token=client_request_token,
            processors=processors,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="channelFlowArn")
    def channel_flow_arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "channelFlowArn"))


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.ChannelFlowProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_instance_arn": "appInstanceArn",
        "client_request_token": "clientRequestToken",
        "processors": "processors",
        "name": "name",
        "tags": "tags",
    },
)
class ChannelFlowProps:
    def __init__(
        self,
        *,
        app_instance_arn: builtins.str,
        client_request_token: builtins.str,
        processors: typing.Sequence[typing.Union["Processors", typing.Dict[builtins.str, typing.Any]]],
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union["ChannelFlowTags", typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''Props for ``AppInstance``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_CreateChannelFlow.html

        :param app_instance_arn: The ARN of the App Instance. Default: - None
        :param client_request_token: The client token for the request. An Idempotency token. Default: - None
        :param processors: Information about the processor Lambda functions. Default: - None
        :param name: The name of the channel flow. Default: - None
        :param tags: The tags for the creation request. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4318c557157fab467f7f5003cd7f6be7ef8ee2b6efc6a633e86ac38c75fc6aaf)
            check_type(argname="argument app_instance_arn", value=app_instance_arn, expected_type=type_hints["app_instance_arn"])
            check_type(argname="argument client_request_token", value=client_request_token, expected_type=type_hints["client_request_token"])
            check_type(argname="argument processors", value=processors, expected_type=type_hints["processors"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument tags", value=tags, expected_type=type_hints["tags"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_instance_arn": app_instance_arn,
            "client_request_token": client_request_token,
            "processors": processors,
        }
        if name is not None:
            self._values["name"] = name
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def app_instance_arn(self) -> builtins.str:
        '''The ARN of the App Instance.

        :default: - None
        '''
        result = self._values.get("app_instance_arn")
        assert result is not None, "Required property 'app_instance_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def client_request_token(self) -> builtins.str:
        '''The client token for the request.

        An Idempotency token.

        :default: - None
        '''
        result = self._values.get("client_request_token")
        assert result is not None, "Required property 'client_request_token' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def processors(self) -> typing.List["Processors"]:
        '''Information about the processor Lambda functions.

        :default: - None
        '''
        result = self._values.get("processors")
        assert result is not None, "Required property 'processors' is missing"
        return typing.cast(typing.List["Processors"], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''The name of the channel flow.

        :default: - None
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def tags(self) -> typing.Optional[typing.List["ChannelFlowTags"]]:
        '''The tags for the creation request.

        :default: - None
        '''
        result = self._values.get("tags")
        return typing.cast(typing.Optional[typing.List["ChannelFlowTags"]], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ChannelFlowProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.ChannelFlowTags",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class ChannelFlowTags:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: 
        :param value: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__423e2b447054eb5049c198e4c2c919b7bcdaeb6ee0e8a7b3792d33ee6a0b1d7b)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ChannelFlowTags(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ChimePhoneNumber(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.ChimePhoneNumber",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        phone_product_type: "PhoneProductType",
        phone_area_code: typing.Optional[jsii.Number] = None,
        phone_city: typing.Optional[builtins.str] = None,
        phone_country: typing.Optional["PhoneCountry"] = None,
        phone_number_toll_free_prefix: typing.Optional[jsii.Number] = None,
        phone_number_type: typing.Optional["PhoneNumberType"] = None,
        phone_state: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param phone_product_type: Phone Product Type (required) - SipMediaApplicationDialIn or VoiceConnector. Default: - None
        :param phone_area_code: Area Code for phone number request (optional) - Usable only with US Country. Default: - None
        :param phone_city: City for phone number request (optional) - Usable only with US Country. Default: - None
        :param phone_country: Country for phone number request (optional) - See https://docs.aws.amazon.com/chime/latest/ag/phone-country-reqs.html for more details. Default: - US
        :param phone_number_toll_free_prefix: Toll Free Prefix for phone number request (optional). Default: - None
        :param phone_number_type: Phone Number Type for phone number request (optional) - Local or TollFree - Required with non-US country. Default: - None
        :param phone_state: State for phone number request (optional) - Usable only with US Country. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7115b79d2edc74ff917d518a81f7a6651e02418753fab2a2a35e2bff1587b5a7)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PhoneNumberProps(
            phone_product_type=phone_product_type,
            phone_area_code=phone_area_code,
            phone_city=phone_city,
            phone_country=phone_country,
            phone_number_toll_free_prefix=phone_number_toll_free_prefix,
            phone_number_type=phone_number_type,
            phone_state=phone_state,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="associateWithVoiceConnector")
    def associate_with_voice_connector(
        self,
        voice_connector_id: "ChimeVoiceConnector",
    ) -> "PhoneAssociation":
        '''
        :param voice_connector_id: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__113f835f1247755909e4fbd1d3eb6d53265ab846dcd51487ecbfc26db4f5e50b)
            check_type(argname="argument voice_connector_id", value=voice_connector_id, expected_type=type_hints["voice_connector_id"])
        return typing.cast("PhoneAssociation", jsii.invoke(self, "associateWithVoiceConnector", [voice_connector_id]))

    @builtins.property
    @jsii.member(jsii_name="phoneNumber")
    def phone_number(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "phoneNumber"))


class ChimeSipMediaApp(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.ChimeSipMediaApp",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        endpoint: builtins.str,
        name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param endpoint: endpoint for SipMediaApplication(required). Default: - none
        :param name: name for SipMediaApplication (optional). Default: - unique ID for resource
        :param region: region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler. Default: - same region as stack deployment
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e37db274aeecb4545734b8fe6863b37da6a06c91ab04fbd007ee1878c7cfc2cf)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SipMediaAppProps(endpoint=endpoint, name=name, region=region)

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="alexaSkill")
    def alexa_skill(
        self,
        *,
        alexa_skill_ids: typing.Sequence[builtins.str],
        alexa_skill_status: AlexaSkillStatus,
    ) -> _aws_cdk_ceddda9d.Reference:
        '''
        :param alexa_skill_ids: 
        :param alexa_skill_status: 
        '''
        sip_media_application_alexa_skill_configuration = SipMediaApplicationAlexaSkillConfiguration(
            alexa_skill_ids=alexa_skill_ids, alexa_skill_status=alexa_skill_status
        )

        return typing.cast(_aws_cdk_ceddda9d.Reference, jsii.invoke(self, "alexaSkill", [sip_media_application_alexa_skill_configuration]))

    @jsii.member(jsii_name="logging")
    def logging(
        self,
        *,
        enable_sip_media_application_message_logs: builtins.bool,
    ) -> "PSTNResources":
        '''
        :param enable_sip_media_application_message_logs: Enables message logging for the specified SIP media application.
        '''
        sip_media_application_logging_configuration = SipMediaApplicationLoggingConfiguration(
            enable_sip_media_application_message_logs=enable_sip_media_application_message_logs,
        )

        return typing.cast("PSTNResources", jsii.invoke(self, "logging", [sip_media_application_logging_configuration]))

    @builtins.property
    @jsii.member(jsii_name="sipMediaAppId")
    def sip_media_app_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sipMediaAppId"))


class ChimeSipRule(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.ChimeSipRule",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        target_applications: typing.Sequence[typing.Union["SipRuleTargetApplication", typing.Dict[builtins.str, typing.Any]]],
        trigger_type: "TriggerType",
        trigger_value: builtins.str,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param target_applications: 
        :param trigger_type: Trigger Type for SipRule (required) - TO_PHONE_NUMBER or REQUEST_URI_HOSTNAME. Default: - none
        :param trigger_value: Trigger Value for SipRule (required) - EE.164 Phone Number or Voice Connector URI. Default: - none
        :param name: name for SipRule (optional). Default: - unique ID for resource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__39a8ee26df03196f53b578da14beb4b9253b7c5e47bb51611c9cefd974b2996b)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = SipRuleProps(
            target_applications=target_applications,
            trigger_type=trigger_type,
            trigger_value=trigger_value,
            name=name,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="sipRuleId")
    def sip_rule_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "sipRuleId"))


class ChimeVoiceConnector(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.ChimeVoiceConnector",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        encryption: typing.Optional[builtins.bool] = None,
        logging_configuration: typing.Optional[typing.Union["VoiceConnectorLoggingConfiguration", typing.Dict[builtins.str, typing.Any]]] = None,
        name: typing.Optional[builtins.str] = None,
        origination: typing.Optional[typing.Sequence[typing.Union["Routes", typing.Dict[builtins.str, typing.Any]]]] = None,
        region: typing.Optional[builtins.str] = None,
        streaming: typing.Optional[typing.Union["Streaming", typing.Dict[builtins.str, typing.Any]]] = None,
        termination: typing.Optional[typing.Union["Termination", typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param encryption: Encryption boolean for VoiceConnector. Default: - False
        :param logging_configuration: 
        :param name: name for VoiceConnector. Default: - unique ID for resource
        :param origination: 
        :param region: region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler. Default: - same region as stack deployment
        :param streaming: 
        :param termination: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__3322e6fa91f7b318e813d5bf83683474955e25e8180642a7921f91e501c051de)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = VoiceConnectorProps(
            encryption=encryption,
            logging_configuration=logging_configuration,
            name=name,
            origination=origination,
            region=region,
            streaming=streaming,
            termination=termination,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="voiceConnectorId")
    def voice_connector_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "voiceConnectorId"))


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.Configuration",
    jsii_struct_bases=[],
    name_mapping={"lambda_": "lambda"},
)
class Configuration:
    def __init__(
        self,
        *,
        lambda_: typing.Union["Lambda", typing.Dict[builtins.str, typing.Any]],
    ) -> None:
        '''Props for ``Configuration``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_ProcessorConfiguration.html

        :param lambda_: Indicates that the processor is of type Lambda. Default: - None
        '''
        if isinstance(lambda_, dict):
            lambda_ = Lambda(**lambda_)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4571f43b9d6d9c78c9a4194cd81c8f6d0723c84dfad67e0dc37cee78b008d9b5)
            check_type(argname="argument lambda_", value=lambda_, expected_type=type_hints["lambda_"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "lambda_": lambda_,
        }

    @builtins.property
    def lambda_(self) -> "Lambda":
        '''Indicates that the processor is of type Lambda.

        :default: - None
        '''
        result = self._values.get("lambda_")
        assert result is not None, "Required property 'lambda_' is missing"
        return typing.cast("Lambda", result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Configuration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.FallbackAction")
class FallbackAction(enum.Enum):
    CONTINUE = "CONTINUE"
    ABORT = "ABORT"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.InstanceUserTags",
    jsii_struct_bases=[],
    name_mapping={"key": "key", "value": "value"},
)
class InstanceUserTags:
    def __init__(self, *, key: builtins.str, value: builtins.str) -> None:
        '''
        :param key: 
        :param value: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__73075b4d361aeb287fc052a39e6ab5aa8840b8d2c65afb20519d4ff51266dc64)
            check_type(argname="argument key", value=key, expected_type=type_hints["key"])
            check_type(argname="argument value", value=value, expected_type=type_hints["value"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "key": key,
            "value": value,
        }

    @builtins.property
    def key(self) -> builtins.str:
        result = self._values.get("key")
        assert result is not None, "Required property 'key' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def value(self) -> builtins.str:
        result = self._values.get("value")
        assert result is not None, "Required property 'value' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "InstanceUserTags(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.InvocationType")
class InvocationType(enum.Enum):
    ASYNC = "ASYNC"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.Lambda",
    jsii_struct_bases=[],
    name_mapping={"invocation_type": "invocationType", "resource_arn": "resourceArn"},
)
class Lambda:
    def __init__(
        self,
        *,
        invocation_type: InvocationType,
        resource_arn: builtins.str,
    ) -> None:
        '''Props for ``LambdaConfiguration``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_LambdaConfiguration.html

        :param invocation_type: Controls how the Lambda function is invoked. Default: - None
        :param resource_arn: The ARN of the Lambda message processing function. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__578b648f0cf5bcbae9bf298c3b4ec202747ea61fcc36e3c12421adbf714050a6)
            check_type(argname="argument invocation_type", value=invocation_type, expected_type=type_hints["invocation_type"])
            check_type(argname="argument resource_arn", value=resource_arn, expected_type=type_hints["resource_arn"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "invocation_type": invocation_type,
            "resource_arn": resource_arn,
        }

    @builtins.property
    def invocation_type(self) -> InvocationType:
        '''Controls how the Lambda function is invoked.

        :default: - None
        '''
        result = self._values.get("invocation_type")
        assert result is not None, "Required property 'invocation_type' is missing"
        return typing.cast(InvocationType, result)

    @builtins.property
    def resource_arn(self) -> builtins.str:
        '''The ARN of the Lambda message processing function.

        :default: - None
        '''
        result = self._values.get("resource_arn")
        assert result is not None, "Required property 'resource_arn' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Lambda(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MessagingAppInstance(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.MessagingAppInstance",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        client_request_token: typing.Optional[builtins.str] = None,
        metadata: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[AppInstanceTags, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param client_request_token: The ClientRequestToken of the app instance. This field is autopopulated if not provided. Default: - None
        :param metadata: The metadata of the app instance. Limited to a 1KB string in UTF-8. Default: - None
        :param name: The name of the app instance. Default: - None
        :param tags: The tags for the creation request. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__0a9f012fab9eb0d816a78f8f21fb2b6ca54774f162a1dd5769f1628ac6f2e8c9)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AppInstanceProps(
            client_request_token=client_request_token,
            metadata=metadata,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @jsii.member(jsii_name="retention")
    def retention(self, days: jsii.Number) -> "MessagingResources":
        '''
        :param days: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__da36a029e1afaaefc489c020934e45363195f10c5727d992a321c13b0043e2c0)
            check_type(argname="argument days", value=days, expected_type=type_hints["days"])
        return typing.cast("MessagingResources", jsii.invoke(self, "retention", [days]))

    @jsii.member(jsii_name="streaming")
    def streaming(
        self,
        streaming_configs: typing.Sequence[typing.Union["StreamingConfig", typing.Dict[builtins.str, typing.Any]]],
    ) -> "MessagingResources":
        '''
        :param streaming_configs: -
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e11016e616c0eecf971ad1b8d44cee41698040c9f7bb7fc2ef89c3f2b4668454)
            check_type(argname="argument streaming_configs", value=streaming_configs, expected_type=type_hints["streaming_configs"])
        return typing.cast("MessagingResources", jsii.invoke(self, "streaming", [streaming_configs]))

    @builtins.property
    @jsii.member(jsii_name="appInstanceArn")
    def app_instance_arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "appInstanceArn"))


class MessagingAppInstanceAdmin(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.MessagingAppInstanceAdmin",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_instance_admin_arn: builtins.str,
        app_instance_arn: builtins.str,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param app_instance_admin_arn: The name of the app instance. Default: - None
        :param app_instance_arn: The name of the app instance. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__40803d0180de29a1b7d03d21acba148c27c1a6eab510cd87e687d82d6108b3d5)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AppInstanceAdminProps(
            app_instance_admin_arn=app_instance_admin_arn,
            app_instance_arn=app_instance_arn,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="appInstanceAdminArn")
    def app_instance_admin_arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "appInstanceAdminArn"))

    @builtins.property
    @jsii.member(jsii_name="appInstanceAdminName")
    def app_instance_admin_name(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "appInstanceAdminName"))


class MessagingAppInstanceUser(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.MessagingAppInstanceUser",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        app_instance_arn: builtins.str,
        app_instance_user_id: builtins.str,
        client_request_token: typing.Optional[builtins.str] = None,
        metadata: typing.Optional[builtins.str] = None,
        name: typing.Optional[builtins.str] = None,
        tags: typing.Optional[typing.Sequence[typing.Union[InstanceUserTags, typing.Dict[builtins.str, typing.Any]]]] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param app_instance_arn: The name of the app instance. Default: - None
        :param app_instance_user_id: The name of the app instance. Default: - None
        :param client_request_token: The ClientRequestToken of the app instance. This field is autopopulated if not provided. Default: - None
        :param metadata: The metadata of the app instance. Limited to a 1KB string in UTF-8. Default: - None
        :param name: The name of the app instance. Default: - None
        :param tags: The tags for the creation request. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__301eef12c49f4f86623f7326244dcbc9fc1774d26e08b7f5e344906a9f195cba)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = AppInstanceUserProps(
            app_instance_arn=app_instance_arn,
            app_instance_user_id=app_instance_user_id,
            client_request_token=client_request_token,
            metadata=metadata,
            name=name,
            tags=tags,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="appInstanceUserArn")
    def app_instance_user_arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "appInstanceUserArn"))


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.MessagingResourceProps",
    jsii_struct_bases=[_aws_cdk_ceddda9d.ResourceProps],
    name_mapping={
        "account": "account",
        "environment_from_arn": "environmentFromArn",
        "physical_name": "physicalName",
        "region": "region",
        "properties": "properties",
        "resource_type": "resourceType",
        "uid": "uid",
    },
)
class MessagingResourceProps(_aws_cdk_ceddda9d.ResourceProps):
    def __init__(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        properties: typing.Mapping[builtins.str, typing.Any],
        resource_type: builtins.str,
        uid: builtins.str,
    ) -> None:
        '''
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        :param properties: 
        :param resource_type: 
        :param uid: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7688c29fcfcbe8ff3316837ef27d8a5c7629b1f3879e46ab246754bb9571664f)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument environment_from_arn", value=environment_from_arn, expected_type=type_hints["environment_from_arn"])
            check_type(argname="argument physical_name", value=physical_name, expected_type=type_hints["physical_name"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "properties": properties,
            "resource_type": resource_type,
            "uid": uid,
        }
        if account is not None:
            self._values["account"] = account
        if environment_from_arn is not None:
            self._values["environment_from_arn"] = environment_from_arn
        if physical_name is not None:
            self._values["physical_name"] = physical_name
        if region is not None:
            self._values["region"] = region

    @builtins.property
    def account(self) -> typing.Optional[builtins.str]:
        '''The AWS account ID this resource belongs to.

        :default: - the resource is in the same account as the stack it belongs to
        '''
        result = self._values.get("account")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def environment_from_arn(self) -> typing.Optional[builtins.str]:
        '''ARN to deduce region and account from.

        The ARN is parsed and the account and region are taken from the ARN.
        This should be used for imported resources.

        Cannot be supplied together with either ``account`` or ``region``.

        :default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        '''
        result = self._values.get("environment_from_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def physical_name(self) -> typing.Optional[builtins.str]:
        '''The value passed in by users to the physical name prop of the resource.

        - ``undefined`` implies that a physical name will be allocated by
          CloudFormation during deployment.
        - a concrete value implies a specific physical name
        - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated
          by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

        :default: - The physical name will be allocated by CloudFormation at deployment time
        '''
        result = self._values.get("physical_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''The AWS region this resource belongs to.

        :default: - the resource is in the same region as the stack it belongs to
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        result = self._values.get("properties")
        assert result is not None, "Required property 'properties' is missing"
        return typing.cast(typing.Mapping[builtins.str, typing.Any], result)

    @builtins.property
    def resource_type(self) -> builtins.str:
        result = self._values.get("resource_type")
        assert result is not None, "Required property 'resource_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def uid(self) -> builtins.str:
        result = self._values.get("uid")
        assert result is not None, "Required property 'uid' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "MessagingResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class MessagingResources(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.MessagingResources",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        properties: typing.Mapping[builtins.str, typing.Any],
        resource_type: builtins.str,
        uid: builtins.str,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param properties: 
        :param resource_type: 
        :param uid: 
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__e4c733c0cc8a171d0914be8696b8353206a7d5a17dbbdb5ab2171cdd3ffd266e)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = MessagingResourceProps(
            properties=properties,
            resource_type=resource_type,
            uid=uid,
            account=account,
            environment_from_arn=environment_from_arn,
            physical_name=physical_name,
            region=region,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="lambda")
    def lambda_(self) -> _aws_cdk_aws_lambda_ceddda9d.IFunction:
        return typing.cast(_aws_cdk_aws_lambda_ceddda9d.IFunction, jsii.get(self, "lambda"))

    @builtins.property
    @jsii.member(jsii_name="messagingCustomResource")
    def messaging_custom_resource(self) -> _aws_cdk_ceddda9d.CustomResource:
        return typing.cast(_aws_cdk_ceddda9d.CustomResource, jsii.get(self, "messagingCustomResource"))


@jsii.enum(jsii_type="cdk-amazon-chime-resources.NotificationTargetType")
class NotificationTargetType(enum.Enum):
    EVENTBRIDGE = "EVENTBRIDGE"
    SNS = "SNS"
    SQS = "SQS"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.PSTNResourceProps",
    jsii_struct_bases=[_aws_cdk_ceddda9d.ResourceProps],
    name_mapping={
        "account": "account",
        "environment_from_arn": "environmentFromArn",
        "physical_name": "physicalName",
        "region": "region",
        "properties": "properties",
        "resource_type": "resourceType",
        "uid": "uid",
    },
)
class PSTNResourceProps(_aws_cdk_ceddda9d.ResourceProps):
    def __init__(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        properties: typing.Mapping[builtins.str, typing.Any],
        resource_type: builtins.str,
        uid: builtins.str,
    ) -> None:
        '''
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        :param properties: 
        :param resource_type: 
        :param uid: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2e7326b3c0a86e27b49bf3d1d67d25db6fc4d4e818fb652a26c9b1a4959e1677)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument environment_from_arn", value=environment_from_arn, expected_type=type_hints["environment_from_arn"])
            check_type(argname="argument physical_name", value=physical_name, expected_type=type_hints["physical_name"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument properties", value=properties, expected_type=type_hints["properties"])
            check_type(argname="argument resource_type", value=resource_type, expected_type=type_hints["resource_type"])
            check_type(argname="argument uid", value=uid, expected_type=type_hints["uid"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "properties": properties,
            "resource_type": resource_type,
            "uid": uid,
        }
        if account is not None:
            self._values["account"] = account
        if environment_from_arn is not None:
            self._values["environment_from_arn"] = environment_from_arn
        if physical_name is not None:
            self._values["physical_name"] = physical_name
        if region is not None:
            self._values["region"] = region

    @builtins.property
    def account(self) -> typing.Optional[builtins.str]:
        '''The AWS account ID this resource belongs to.

        :default: - the resource is in the same account as the stack it belongs to
        '''
        result = self._values.get("account")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def environment_from_arn(self) -> typing.Optional[builtins.str]:
        '''ARN to deduce region and account from.

        The ARN is parsed and the account and region are taken from the ARN.
        This should be used for imported resources.

        Cannot be supplied together with either ``account`` or ``region``.

        :default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        '''
        result = self._values.get("environment_from_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def physical_name(self) -> typing.Optional[builtins.str]:
        '''The value passed in by users to the physical name prop of the resource.

        - ``undefined`` implies that a physical name will be allocated by
          CloudFormation during deployment.
        - a concrete value implies a specific physical name
        - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated
          by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

        :default: - The physical name will be allocated by CloudFormation at deployment time
        '''
        result = self._values.get("physical_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''The AWS region this resource belongs to.

        :default: - the resource is in the same region as the stack it belongs to
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def properties(self) -> typing.Mapping[builtins.str, typing.Any]:
        result = self._values.get("properties")
        assert result is not None, "Required property 'properties' is missing"
        return typing.cast(typing.Mapping[builtins.str, typing.Any], result)

    @builtins.property
    def resource_type(self) -> builtins.str:
        result = self._values.get("resource_type")
        assert result is not None, "Required property 'resource_type' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def uid(self) -> builtins.str:
        result = self._values.get("uid")
        assert result is not None, "Required property 'uid' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PSTNResourceProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class PSTNResources(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.PSTNResources",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        properties: typing.Mapping[builtins.str, typing.Any],
        resource_type: builtins.str,
        uid: builtins.str,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param properties: 
        :param resource_type: 
        :param uid: 
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__fd9372fb4e09a36da7cfd84d9bf339c9f4439d92326a5b861b6e029af5d9c892)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PSTNResourceProps(
            properties=properties,
            resource_type=resource_type,
            uid=uid,
            account=account,
            environment_from_arn=environment_from_arn,
            physical_name=physical_name,
            region=region,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="lambda")
    def lambda_(self) -> _aws_cdk_aws_lambda_ceddda9d.IFunction:
        return typing.cast(_aws_cdk_aws_lambda_ceddda9d.IFunction, jsii.get(self, "lambda"))

    @builtins.property
    @jsii.member(jsii_name="pstnCustomResource")
    def pstn_custom_resource(self) -> _aws_cdk_ceddda9d.CustomResource:
        return typing.cast(_aws_cdk_ceddda9d.CustomResource, jsii.get(self, "pstnCustomResource"))


class PhoneAssociation(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-amazon-chime-resources.PhoneAssociation",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        e164_phone_number: builtins.str,
        voice_connector_id: builtins.str,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param e164_phone_number: 
        :param voice_connector_id: 
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__993434bc6df235b1954fce1d9dfadb90733323d92c219dca67d88e83d8672f32)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = PhoneAssociationProps(
            e164_phone_number=e164_phone_number,
            voice_connector_id=voice_connector_id,
            account=account,
            environment_from_arn=environment_from_arn,
            physical_name=physical_name,
            region=region,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="phoneAssociationResource")
    def phone_association_resource(
        self,
    ) -> _aws_cdk_custom_resources_ceddda9d.AwsCustomResource:
        return typing.cast(_aws_cdk_custom_resources_ceddda9d.AwsCustomResource, jsii.get(self, "phoneAssociationResource"))


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.PhoneAssociationProps",
    jsii_struct_bases=[_aws_cdk_ceddda9d.ResourceProps],
    name_mapping={
        "account": "account",
        "environment_from_arn": "environmentFromArn",
        "physical_name": "physicalName",
        "region": "region",
        "e164_phone_number": "e164PhoneNumber",
        "voice_connector_id": "voiceConnectorId",
    },
)
class PhoneAssociationProps(_aws_cdk_ceddda9d.ResourceProps):
    def __init__(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        e164_phone_number: builtins.str,
        voice_connector_id: builtins.str,
    ) -> None:
        '''
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        :param e164_phone_number: 
        :param voice_connector_id: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__ffcf366f044deabea6d05ca3f221e34c0d86c933a08f738f6fbd42fce75b5d9a)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument environment_from_arn", value=environment_from_arn, expected_type=type_hints["environment_from_arn"])
            check_type(argname="argument physical_name", value=physical_name, expected_type=type_hints["physical_name"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument e164_phone_number", value=e164_phone_number, expected_type=type_hints["e164_phone_number"])
            check_type(argname="argument voice_connector_id", value=voice_connector_id, expected_type=type_hints["voice_connector_id"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "e164_phone_number": e164_phone_number,
            "voice_connector_id": voice_connector_id,
        }
        if account is not None:
            self._values["account"] = account
        if environment_from_arn is not None:
            self._values["environment_from_arn"] = environment_from_arn
        if physical_name is not None:
            self._values["physical_name"] = physical_name
        if region is not None:
            self._values["region"] = region

    @builtins.property
    def account(self) -> typing.Optional[builtins.str]:
        '''The AWS account ID this resource belongs to.

        :default: - the resource is in the same account as the stack it belongs to
        '''
        result = self._values.get("account")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def environment_from_arn(self) -> typing.Optional[builtins.str]:
        '''ARN to deduce region and account from.

        The ARN is parsed and the account and region are taken from the ARN.
        This should be used for imported resources.

        Cannot be supplied together with either ``account`` or ``region``.

        :default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        '''
        result = self._values.get("environment_from_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def physical_name(self) -> typing.Optional[builtins.str]:
        '''The value passed in by users to the physical name prop of the resource.

        - ``undefined`` implies that a physical name will be allocated by
          CloudFormation during deployment.
        - a concrete value implies a specific physical name
        - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated
          by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

        :default: - The physical name will be allocated by CloudFormation at deployment time
        '''
        result = self._values.get("physical_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''The AWS region this resource belongs to.

        :default: - the resource is in the same region as the stack it belongs to
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def e164_phone_number(self) -> builtins.str:
        result = self._values.get("e164_phone_number")
        assert result is not None, "Required property 'e164_phone_number' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def voice_connector_id(self) -> builtins.str:
        result = self._values.get("voice_connector_id")
        assert result is not None, "Required property 'voice_connector_id' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PhoneAssociationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.PhoneCountry")
class PhoneCountry(enum.Enum):
    AU = "AU"
    AT = "AT"
    CA = "CA"
    DK = "DK"
    DE = "DE"
    IE = "IE"
    IT = "IT"
    NZ = "NZ"
    NG = "NG"
    PR = "PR"
    KR = "KR"
    SE = "SE"
    CH = "CH"
    UK = "UK"
    US = "US"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.PhoneNumberProps",
    jsii_struct_bases=[],
    name_mapping={
        "phone_product_type": "phoneProductType",
        "phone_area_code": "phoneAreaCode",
        "phone_city": "phoneCity",
        "phone_country": "phoneCountry",
        "phone_number_toll_free_prefix": "phoneNumberTollFreePrefix",
        "phone_number_type": "phoneNumberType",
        "phone_state": "phoneState",
    },
)
class PhoneNumberProps:
    def __init__(
        self,
        *,
        phone_product_type: "PhoneProductType",
        phone_area_code: typing.Optional[jsii.Number] = None,
        phone_city: typing.Optional[builtins.str] = None,
        phone_country: typing.Optional[PhoneCountry] = None,
        phone_number_toll_free_prefix: typing.Optional[jsii.Number] = None,
        phone_number_type: typing.Optional["PhoneNumberType"] = None,
        phone_state: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Props for ``PhoneNumber``.

        :param phone_product_type: Phone Product Type (required) - SipMediaApplicationDialIn or VoiceConnector. Default: - None
        :param phone_area_code: Area Code for phone number request (optional) - Usable only with US Country. Default: - None
        :param phone_city: City for phone number request (optional) - Usable only with US Country. Default: - None
        :param phone_country: Country for phone number request (optional) - See https://docs.aws.amazon.com/chime/latest/ag/phone-country-reqs.html for more details. Default: - US
        :param phone_number_toll_free_prefix: Toll Free Prefix for phone number request (optional). Default: - None
        :param phone_number_type: Phone Number Type for phone number request (optional) - Local or TollFree - Required with non-US country. Default: - None
        :param phone_state: State for phone number request (optional) - Usable only with US Country. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__4c5b2ac2a9588b05b4d090bb324c4de18ab13008479ac747fb4c76d5aef2bc55)
            check_type(argname="argument phone_product_type", value=phone_product_type, expected_type=type_hints["phone_product_type"])
            check_type(argname="argument phone_area_code", value=phone_area_code, expected_type=type_hints["phone_area_code"])
            check_type(argname="argument phone_city", value=phone_city, expected_type=type_hints["phone_city"])
            check_type(argname="argument phone_country", value=phone_country, expected_type=type_hints["phone_country"])
            check_type(argname="argument phone_number_toll_free_prefix", value=phone_number_toll_free_prefix, expected_type=type_hints["phone_number_toll_free_prefix"])
            check_type(argname="argument phone_number_type", value=phone_number_type, expected_type=type_hints["phone_number_type"])
            check_type(argname="argument phone_state", value=phone_state, expected_type=type_hints["phone_state"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "phone_product_type": phone_product_type,
        }
        if phone_area_code is not None:
            self._values["phone_area_code"] = phone_area_code
        if phone_city is not None:
            self._values["phone_city"] = phone_city
        if phone_country is not None:
            self._values["phone_country"] = phone_country
        if phone_number_toll_free_prefix is not None:
            self._values["phone_number_toll_free_prefix"] = phone_number_toll_free_prefix
        if phone_number_type is not None:
            self._values["phone_number_type"] = phone_number_type
        if phone_state is not None:
            self._values["phone_state"] = phone_state

    @builtins.property
    def phone_product_type(self) -> "PhoneProductType":
        '''Phone Product Type (required) - SipMediaApplicationDialIn or VoiceConnector.

        :default: - None
        '''
        result = self._values.get("phone_product_type")
        assert result is not None, "Required property 'phone_product_type' is missing"
        return typing.cast("PhoneProductType", result)

    @builtins.property
    def phone_area_code(self) -> typing.Optional[jsii.Number]:
        '''Area Code for phone number request (optional)  - Usable only with US Country.

        :default: - None
        '''
        result = self._values.get("phone_area_code")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def phone_city(self) -> typing.Optional[builtins.str]:
        '''City for phone number request (optional) - Usable only with US Country.

        :default: - None
        '''
        result = self._values.get("phone_city")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def phone_country(self) -> typing.Optional[PhoneCountry]:
        '''Country for phone number request (optional) - See https://docs.aws.amazon.com/chime/latest/ag/phone-country-reqs.html for more details.

        :default: - US
        '''
        result = self._values.get("phone_country")
        return typing.cast(typing.Optional[PhoneCountry], result)

    @builtins.property
    def phone_number_toll_free_prefix(self) -> typing.Optional[jsii.Number]:
        '''Toll Free Prefix for phone number request (optional).

        :default: - None
        '''
        result = self._values.get("phone_number_toll_free_prefix")
        return typing.cast(typing.Optional[jsii.Number], result)

    @builtins.property
    def phone_number_type(self) -> typing.Optional["PhoneNumberType"]:
        '''Phone Number Type for phone number request (optional) - Local or TollFree - Required with non-US country.

        :default: - None
        '''
        result = self._values.get("phone_number_type")
        return typing.cast(typing.Optional["PhoneNumberType"], result)

    @builtins.property
    def phone_state(self) -> typing.Optional[builtins.str]:
        '''State for phone number request (optional) - Usable only with US Country.

        :default: - None
        '''
        result = self._values.get("phone_state")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "PhoneNumberProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.PhoneNumberType")
class PhoneNumberType(enum.Enum):
    LOCAL = "LOCAL"
    TOLLFREE = "TOLLFREE"


@jsii.enum(jsii_type="cdk-amazon-chime-resources.PhoneProductType")
class PhoneProductType(enum.Enum):
    SMA = "SMA"
    VC = "VC"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.Processors",
    jsii_struct_bases=[],
    name_mapping={
        "configuration": "configuration",
        "execution_order": "executionOrder",
        "fallback_action": "fallbackAction",
        "name": "name",
    },
)
class Processors:
    def __init__(
        self,
        *,
        configuration: typing.Union[Configuration, typing.Dict[builtins.str, typing.Any]],
        execution_order: jsii.Number,
        fallback_action: FallbackAction,
        name: builtins.str,
    ) -> None:
        '''Props for ``Processors``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_messaging-chime_Processor.html

        :param configuration: The information about the type of processor and its identifier. Default: - None
        :param execution_order: The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence. At this point, we support only 1 processor within a flow. Default: - None
        :param fallback_action: Determines whether to continue with message processing or stop it in cases where communication with a processor fails. If a processor has a fallback action of ABORT and communication with it fails, the processor sets the message status to FAILED and does not send the message to any recipients. Note that if the last processor in the channel flow sequence has a fallback action of CONTINUE and communication with the processor fails, then the message is considered processed and sent to recipients of the channel. Default: - None
        :param name: The name of the Channel Flow Processor. Default: - None
        '''
        if isinstance(configuration, dict):
            configuration = Configuration(**configuration)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__26ddb27d8877eb97beb38e78204072b302c0a15e44306cc7d732983b023c5ee5)
            check_type(argname="argument configuration", value=configuration, expected_type=type_hints["configuration"])
            check_type(argname="argument execution_order", value=execution_order, expected_type=type_hints["execution_order"])
            check_type(argname="argument fallback_action", value=fallback_action, expected_type=type_hints["fallback_action"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "configuration": configuration,
            "execution_order": execution_order,
            "fallback_action": fallback_action,
            "name": name,
        }

    @builtins.property
    def configuration(self) -> Configuration:
        '''The information about the type of processor and its identifier.

        :default: - None
        '''
        result = self._values.get("configuration")
        assert result is not None, "Required property 'configuration' is missing"
        return typing.cast(Configuration, result)

    @builtins.property
    def execution_order(self) -> jsii.Number:
        '''The sequence in which processors run.

        If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence. At this point, we support only 1 processor within a flow.

        :default: - None
        '''
        result = self._values.get("execution_order")
        assert result is not None, "Required property 'execution_order' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def fallback_action(self) -> FallbackAction:
        '''Determines whether to continue with message processing or stop it in cases where communication with a processor fails.

        If a processor has a fallback action of ABORT and communication with it fails, the processor sets the message status to FAILED and does not send the message to any recipients. Note that if the last processor in the channel flow sequence has a fallback action of CONTINUE and communication with the processor fails, then the message is considered processed and sent to recipients of the channel.

        :default: - None
        '''
        result = self._values.get("fallback_action")
        assert result is not None, "Required property 'fallback_action' is missing"
        return typing.cast(FallbackAction, result)

    @builtins.property
    def name(self) -> builtins.str:
        '''The name of the Channel Flow Processor.

        :default: - None
        '''
        result = self._values.get("name")
        assert result is not None, "Required property 'name' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Processors(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.Protocol")
class Protocol(enum.Enum):
    TCP = "TCP"
    UDP = "UDP"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.Routes",
    jsii_struct_bases=[],
    name_mapping={
        "host": "host",
        "port": "port",
        "priority": "priority",
        "protocol": "protocol",
        "weight": "weight",
    },
)
class Routes:
    def __init__(
        self,
        *,
        host: builtins.str,
        port: jsii.Number,
        priority: jsii.Number,
        protocol: Protocol,
        weight: jsii.Number,
    ) -> None:
        '''
        :param host: 
        :param port: 
        :param priority: 
        :param protocol: 
        :param weight: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__cb30c4d59c6038c4d49567f143b8a4b4b5355d6c06cc090d64ec9ceaf4ae31ca)
            check_type(argname="argument host", value=host, expected_type=type_hints["host"])
            check_type(argname="argument port", value=port, expected_type=type_hints["port"])
            check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
            check_type(argname="argument protocol", value=protocol, expected_type=type_hints["protocol"])
            check_type(argname="argument weight", value=weight, expected_type=type_hints["weight"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "host": host,
            "port": port,
            "priority": priority,
            "protocol": protocol,
            "weight": weight,
        }

    @builtins.property
    def host(self) -> builtins.str:
        result = self._values.get("host")
        assert result is not None, "Required property 'host' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def port(self) -> jsii.Number:
        result = self._values.get("port")
        assert result is not None, "Required property 'port' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def priority(self) -> jsii.Number:
        result = self._values.get("priority")
        assert result is not None, "Required property 'priority' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def protocol(self) -> Protocol:
        result = self._values.get("protocol")
        assert result is not None, "Required property 'protocol' is missing"
        return typing.cast(Protocol, result)

    @builtins.property
    def weight(self) -> jsii.Number:
        result = self._values.get("weight")
        assert result is not None, "Required property 'weight' is missing"
        return typing.cast(jsii.Number, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Routes(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.SipMediaAppProps",
    jsii_struct_bases=[],
    name_mapping={"endpoint": "endpoint", "name": "name", "region": "region"},
)
class SipMediaAppProps:
    def __init__(
        self,
        *,
        endpoint: builtins.str,
        name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Props for ``SipMediaApplication``.

        :param endpoint: endpoint for SipMediaApplication(required). Default: - none
        :param name: name for SipMediaApplication (optional). Default: - unique ID for resource
        :param region: region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler. Default: - same region as stack deployment
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__1800988fcf2743216f6eab079fae412c1cc4d1fd0a60c264fb6dab0dec2bd5b7)
            check_type(argname="argument endpoint", value=endpoint, expected_type=type_hints["endpoint"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "endpoint": endpoint,
        }
        if name is not None:
            self._values["name"] = name
        if region is not None:
            self._values["region"] = region

    @builtins.property
    def endpoint(self) -> builtins.str:
        '''endpoint for SipMediaApplication(required).

        :default: - none
        '''
        result = self._values.get("endpoint")
        assert result is not None, "Required property 'endpoint' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''name for SipMediaApplication (optional).

        :default: - unique ID for resource
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler.

        :default: - same region as stack deployment
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SipMediaAppProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.SipMediaApplicationAlexaSkillConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "alexa_skill_ids": "alexaSkillIds",
        "alexa_skill_status": "alexaSkillStatus",
    },
)
class SipMediaApplicationAlexaSkillConfiguration:
    def __init__(
        self,
        *,
        alexa_skill_ids: typing.Sequence[builtins.str],
        alexa_skill_status: AlexaSkillStatus,
    ) -> None:
        '''
        :param alexa_skill_ids: 
        :param alexa_skill_status: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__5c9e16054c1863d170b9b208caa0ba2aa47e20d82abe3bd3841cd27e3c34f30f)
            check_type(argname="argument alexa_skill_ids", value=alexa_skill_ids, expected_type=type_hints["alexa_skill_ids"])
            check_type(argname="argument alexa_skill_status", value=alexa_skill_status, expected_type=type_hints["alexa_skill_status"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "alexa_skill_ids": alexa_skill_ids,
            "alexa_skill_status": alexa_skill_status,
        }

    @builtins.property
    def alexa_skill_ids(self) -> typing.List[builtins.str]:
        result = self._values.get("alexa_skill_ids")
        assert result is not None, "Required property 'alexa_skill_ids' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def alexa_skill_status(self) -> AlexaSkillStatus:
        result = self._values.get("alexa_skill_status")
        assert result is not None, "Required property 'alexa_skill_status' is missing"
        return typing.cast(AlexaSkillStatus, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SipMediaApplicationAlexaSkillConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.SipMediaApplicationLoggingConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "enable_sip_media_application_message_logs": "enableSipMediaApplicationMessageLogs",
    },
)
class SipMediaApplicationLoggingConfiguration:
    def __init__(
        self,
        *,
        enable_sip_media_application_message_logs: builtins.bool,
    ) -> None:
        '''Props for ``AppInstanceStreamingConfiguration``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_AppInstanceStreamingConfiguration.html

        :param enable_sip_media_application_message_logs: Enables message logging for the specified SIP media application.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__d62db8768173128e1b08db50f094542e716a3b570d3b88e9b91b7ceafc9474b6)
            check_type(argname="argument enable_sip_media_application_message_logs", value=enable_sip_media_application_message_logs, expected_type=type_hints["enable_sip_media_application_message_logs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "enable_sip_media_application_message_logs": enable_sip_media_application_message_logs,
        }

    @builtins.property
    def enable_sip_media_application_message_logs(self) -> builtins.bool:
        '''Enables message logging for the specified SIP media application.'''
        result = self._values.get("enable_sip_media_application_message_logs")
        assert result is not None, "Required property 'enable_sip_media_application_message_logs' is missing"
        return typing.cast(builtins.bool, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SipMediaApplicationLoggingConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.SipRuleProps",
    jsii_struct_bases=[],
    name_mapping={
        "target_applications": "targetApplications",
        "trigger_type": "triggerType",
        "trigger_value": "triggerValue",
        "name": "name",
    },
)
class SipRuleProps:
    def __init__(
        self,
        *,
        target_applications: typing.Sequence[typing.Union["SipRuleTargetApplication", typing.Dict[builtins.str, typing.Any]]],
        trigger_type: "TriggerType",
        trigger_value: builtins.str,
        name: typing.Optional[builtins.str] = None,
    ) -> None:
        '''Props for ``SipRule``.

        :param target_applications: 
        :param trigger_type: Trigger Type for SipRule (required) - TO_PHONE_NUMBER or REQUEST_URI_HOSTNAME. Default: - none
        :param trigger_value: Trigger Value for SipRule (required) - EE.164 Phone Number or Voice Connector URI. Default: - none
        :param name: name for SipRule (optional). Default: - unique ID for resource
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__89736ac741fdf808dcb095891a5694b63dd4f0371e5bbc368635a3e619ce1010)
            check_type(argname="argument target_applications", value=target_applications, expected_type=type_hints["target_applications"])
            check_type(argname="argument trigger_type", value=trigger_type, expected_type=type_hints["trigger_type"])
            check_type(argname="argument trigger_value", value=trigger_value, expected_type=type_hints["trigger_value"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "target_applications": target_applications,
            "trigger_type": trigger_type,
            "trigger_value": trigger_value,
        }
        if name is not None:
            self._values["name"] = name

    @builtins.property
    def target_applications(self) -> typing.List["SipRuleTargetApplication"]:
        result = self._values.get("target_applications")
        assert result is not None, "Required property 'target_applications' is missing"
        return typing.cast(typing.List["SipRuleTargetApplication"], result)

    @builtins.property
    def trigger_type(self) -> "TriggerType":
        '''Trigger Type for SipRule (required) - TO_PHONE_NUMBER or REQUEST_URI_HOSTNAME.

        :default: - none
        '''
        result = self._values.get("trigger_type")
        assert result is not None, "Required property 'trigger_type' is missing"
        return typing.cast("TriggerType", result)

    @builtins.property
    def trigger_value(self) -> builtins.str:
        '''Trigger Value for SipRule (required) - EE.164 Phone Number or Voice Connector URI.

        :default: - none
        '''
        result = self._values.get("trigger_value")
        assert result is not None, "Required property 'trigger_value' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''name for SipRule (optional).

        :default: - unique ID for resource
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SipRuleProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.SipRuleTargetApplication",
    jsii_struct_bases=[],
    name_mapping={
        "priority": "priority",
        "sip_media_application_id": "sipMediaApplicationId",
        "region": "region",
    },
)
class SipRuleTargetApplication:
    def __init__(
        self,
        *,
        priority: jsii.Number,
        sip_media_application_id: builtins.str,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param priority: Priority for SipRule (required) - 1 to 25. Default: - none
        :param sip_media_application_id: SipMediaApplicationId for SipRule (required). Default: - none
        :param region: Region for SipRule (optional). Default: - same region as stack deployment
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__2c5b839d48377f54265f9cfec24ede27aa6a8c4343f3a3c72630e8aea5ca8635)
            check_type(argname="argument priority", value=priority, expected_type=type_hints["priority"])
            check_type(argname="argument sip_media_application_id", value=sip_media_application_id, expected_type=type_hints["sip_media_application_id"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "priority": priority,
            "sip_media_application_id": sip_media_application_id,
        }
        if region is not None:
            self._values["region"] = region

    @builtins.property
    def priority(self) -> jsii.Number:
        '''Priority for SipRule (required) - 1 to 25.

        :default: - none
        '''
        result = self._values.get("priority")
        assert result is not None, "Required property 'priority' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def sip_media_application_id(self) -> builtins.str:
        '''SipMediaApplicationId for SipRule (required).

        :default: - none
        '''
        result = self._values.get("sip_media_application_id")
        assert result is not None, "Required property 'sip_media_application_id' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''Region for SipRule (optional).

        :default: - same region as stack deployment
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "SipRuleTargetApplication(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.Streaming",
    jsii_struct_bases=[],
    name_mapping={
        "data_retention": "dataRetention",
        "enabled": "enabled",
        "notification_targets": "notificationTargets",
    },
)
class Streaming:
    def __init__(
        self,
        *,
        data_retention: jsii.Number,
        enabled: builtins.bool,
        notification_targets: typing.Sequence[NotificationTargetType],
    ) -> None:
        '''
        :param data_retention: Streaming data retention for VoiceConnector. Default: - 0
        :param enabled: 
        :param notification_targets: Streaming data retention for VoiceConnector. Default: - 0
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__7f414427bb66a4ab1b46218b712d0b4741f86dc6c403c4d7db1728d66c225e03)
            check_type(argname="argument data_retention", value=data_retention, expected_type=type_hints["data_retention"])
            check_type(argname="argument enabled", value=enabled, expected_type=type_hints["enabled"])
            check_type(argname="argument notification_targets", value=notification_targets, expected_type=type_hints["notification_targets"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "data_retention": data_retention,
            "enabled": enabled,
            "notification_targets": notification_targets,
        }

    @builtins.property
    def data_retention(self) -> jsii.Number:
        '''Streaming data retention for VoiceConnector.

        :default: - 0
        '''
        result = self._values.get("data_retention")
        assert result is not None, "Required property 'data_retention' is missing"
        return typing.cast(jsii.Number, result)

    @builtins.property
    def enabled(self) -> builtins.bool:
        result = self._values.get("enabled")
        assert result is not None, "Required property 'enabled' is missing"
        return typing.cast(builtins.bool, result)

    @builtins.property
    def notification_targets(self) -> typing.List[NotificationTargetType]:
        '''Streaming data retention for VoiceConnector.

        :default: - 0
        '''
        result = self._values.get("notification_targets")
        assert result is not None, "Required property 'notification_targets' is missing"
        return typing.cast(typing.List[NotificationTargetType], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Streaming(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.StreamingConfig",
    jsii_struct_bases=[],
    name_mapping={
        "app_instance_data_type": "appInstanceDataType",
        "resource_arn": "resourceArn",
    },
)
class StreamingConfig:
    def __init__(
        self,
        *,
        app_instance_data_type: AppInstanceDataType,
        resource_arn: builtins.str,
    ) -> None:
        '''Props for ``AppInstanceStreamingConfiguration``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_AppInstanceStreamingConfiguration.html

        :param app_instance_data_type: The type of data to be streamed.
        :param resource_arn: The resource ARN of a Kinesis Stream.
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__13050f73faf4d4a7fa215575da8c79326b0e11ea10cfce2fa2d2ccede60fbeba)
            check_type(argname="argument app_instance_data_type", value=app_instance_data_type, expected_type=type_hints["app_instance_data_type"])
            check_type(argname="argument resource_arn", value=resource_arn, expected_type=type_hints["resource_arn"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_instance_data_type": app_instance_data_type,
            "resource_arn": resource_arn,
        }

    @builtins.property
    def app_instance_data_type(self) -> AppInstanceDataType:
        '''The type of data to be streamed.'''
        result = self._values.get("app_instance_data_type")
        assert result is not None, "Required property 'app_instance_data_type' is missing"
        return typing.cast(AppInstanceDataType, result)

    @builtins.property
    def resource_arn(self) -> builtins.str:
        '''The resource ARN of a Kinesis Stream.'''
        result = self._values.get("resource_arn")
        assert result is not None, "Required property 'resource_arn' is missing"
        return typing.cast(builtins.str, result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StreamingConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.StreamingConfigurationProps",
    jsii_struct_bases=[],
    name_mapping={
        "app_instance_arn": "appInstanceArn",
        "streaming_configs": "streamingConfigs",
    },
)
class StreamingConfigurationProps:
    def __init__(
        self,
        *,
        app_instance_arn: builtins.str,
        streaming_configs: typing.Sequence[typing.Union[StreamingConfig, typing.Dict[builtins.str, typing.Any]]],
    ) -> None:
        '''Props for ``PutAppInstanceStreamingConfigurations``.

        See: https://docs.aws.amazon.com/chime-sdk/latest/APIReference/API_PutAppInstanceStreamingConfigurations.html

        :param app_instance_arn: The ARN of the App Instance. Default: - None
        :param streaming_configs: The AppInstanceStreamingConfigurations. Default: - None
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__61924b4976b5e1dcb35eac5d1cdef7ed3590982687eeca03b8b56f49eaac377d)
            check_type(argname="argument app_instance_arn", value=app_instance_arn, expected_type=type_hints["app_instance_arn"])
            check_type(argname="argument streaming_configs", value=streaming_configs, expected_type=type_hints["streaming_configs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "app_instance_arn": app_instance_arn,
            "streaming_configs": streaming_configs,
        }

    @builtins.property
    def app_instance_arn(self) -> builtins.str:
        '''The ARN of the App Instance.

        :default: - None
        '''
        result = self._values.get("app_instance_arn")
        assert result is not None, "Required property 'app_instance_arn' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def streaming_configs(self) -> typing.List[StreamingConfig]:
        '''The AppInstanceStreamingConfigurations.

        :default: - None
        '''
        result = self._values.get("streaming_configs")
        assert result is not None, "Required property 'streaming_configs' is missing"
        return typing.cast(typing.List[StreamingConfig], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "StreamingConfigurationProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.Termination",
    jsii_struct_bases=[],
    name_mapping={
        "calling_regions": "callingRegions",
        "termination_cidrs": "terminationCidrs",
        "cps": "cps",
    },
)
class Termination:
    def __init__(
        self,
        *,
        calling_regions: typing.Sequence[builtins.str],
        termination_cidrs: typing.Sequence[builtins.str],
        cps: typing.Optional[jsii.Number] = None,
    ) -> None:
        '''
        :param calling_regions: Calling Regions for VoiceConnector (optional). Default: - ['US']
        :param termination_cidrs: termination IP for VoiceConnector (optional). Default: - none
        :param cps: CPS Limit. Default: - 1
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__6a9d582d2bde3fddff4ca587aa794f60b27efc8129a4781deadd46f0bbf95df8)
            check_type(argname="argument calling_regions", value=calling_regions, expected_type=type_hints["calling_regions"])
            check_type(argname="argument termination_cidrs", value=termination_cidrs, expected_type=type_hints["termination_cidrs"])
            check_type(argname="argument cps", value=cps, expected_type=type_hints["cps"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "calling_regions": calling_regions,
            "termination_cidrs": termination_cidrs,
        }
        if cps is not None:
            self._values["cps"] = cps

    @builtins.property
    def calling_regions(self) -> typing.List[builtins.str]:
        '''Calling Regions for VoiceConnector (optional).

        :default: - ['US']
        '''
        result = self._values.get("calling_regions")
        assert result is not None, "Required property 'calling_regions' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def termination_cidrs(self) -> typing.List[builtins.str]:
        '''termination IP for VoiceConnector (optional).

        :default: - none
        '''
        result = self._values.get("termination_cidrs")
        assert result is not None, "Required property 'termination_cidrs' is missing"
        return typing.cast(typing.List[builtins.str], result)

    @builtins.property
    def cps(self) -> typing.Optional[jsii.Number]:
        '''CPS Limit.

        :default: - 1
        '''
        result = self._values.get("cps")
        return typing.cast(typing.Optional[jsii.Number], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Termination(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.enum(jsii_type="cdk-amazon-chime-resources.TriggerType")
class TriggerType(enum.Enum):
    TO_PHONE_NUMBER = "TO_PHONE_NUMBER"
    REQUEST_URI_HOSTNAME = "REQUEST_URI_HOSTNAME"


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.VoiceConnectorLoggingConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "enable_media_metric_logs": "enableMediaMetricLogs",
        "enable_sip_logs": "enableSIPLogs",
    },
)
class VoiceConnectorLoggingConfiguration:
    def __init__(
        self,
        *,
        enable_media_metric_logs: typing.Optional[builtins.bool] = None,
        enable_sip_logs: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param enable_media_metric_logs: 
        :param enable_sip_logs: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__64dcb7922680bc224be519c5e7594b88e1acabe4f72e4d0658c8c3fb4f94e571)
            check_type(argname="argument enable_media_metric_logs", value=enable_media_metric_logs, expected_type=type_hints["enable_media_metric_logs"])
            check_type(argname="argument enable_sip_logs", value=enable_sip_logs, expected_type=type_hints["enable_sip_logs"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if enable_media_metric_logs is not None:
            self._values["enable_media_metric_logs"] = enable_media_metric_logs
        if enable_sip_logs is not None:
            self._values["enable_sip_logs"] = enable_sip_logs

    @builtins.property
    def enable_media_metric_logs(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_media_metric_logs")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def enable_sip_logs(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("enable_sip_logs")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VoiceConnectorLoggingConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="cdk-amazon-chime-resources.VoiceConnectorProps",
    jsii_struct_bases=[],
    name_mapping={
        "encryption": "encryption",
        "logging_configuration": "loggingConfiguration",
        "name": "name",
        "origination": "origination",
        "region": "region",
        "streaming": "streaming",
        "termination": "termination",
    },
)
class VoiceConnectorProps:
    def __init__(
        self,
        *,
        encryption: typing.Optional[builtins.bool] = None,
        logging_configuration: typing.Optional[typing.Union[VoiceConnectorLoggingConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
        name: typing.Optional[builtins.str] = None,
        origination: typing.Optional[typing.Sequence[typing.Union[Routes, typing.Dict[builtins.str, typing.Any]]]] = None,
        region: typing.Optional[builtins.str] = None,
        streaming: typing.Optional[typing.Union[Streaming, typing.Dict[builtins.str, typing.Any]]] = None,
        termination: typing.Optional[typing.Union[Termination, typing.Dict[builtins.str, typing.Any]]] = None,
    ) -> None:
        '''Props for ``SipMediaApplication``.

        :param encryption: Encryption boolean for VoiceConnector. Default: - False
        :param logging_configuration: 
        :param name: name for VoiceConnector. Default: - unique ID for resource
        :param origination: 
        :param region: region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler. Default: - same region as stack deployment
        :param streaming: 
        :param termination: 
        '''
        if isinstance(logging_configuration, dict):
            logging_configuration = VoiceConnectorLoggingConfiguration(**logging_configuration)
        if isinstance(streaming, dict):
            streaming = Streaming(**streaming)
        if isinstance(termination, dict):
            termination = Termination(**termination)
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__8bd8e893e1094d68d415fe31b0a78a4d8ce0fb810ef4ab5d04d380bec83b608a)
            check_type(argname="argument encryption", value=encryption, expected_type=type_hints["encryption"])
            check_type(argname="argument logging_configuration", value=logging_configuration, expected_type=type_hints["logging_configuration"])
            check_type(argname="argument name", value=name, expected_type=type_hints["name"])
            check_type(argname="argument origination", value=origination, expected_type=type_hints["origination"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument streaming", value=streaming, expected_type=type_hints["streaming"])
            check_type(argname="argument termination", value=termination, expected_type=type_hints["termination"])
        self._values: typing.Dict[builtins.str, typing.Any] = {}
        if encryption is not None:
            self._values["encryption"] = encryption
        if logging_configuration is not None:
            self._values["logging_configuration"] = logging_configuration
        if name is not None:
            self._values["name"] = name
        if origination is not None:
            self._values["origination"] = origination
        if region is not None:
            self._values["region"] = region
        if streaming is not None:
            self._values["streaming"] = streaming
        if termination is not None:
            self._values["termination"] = termination

    @builtins.property
    def encryption(self) -> typing.Optional[builtins.bool]:
        '''Encryption boolean for VoiceConnector.

        :default: - False
        '''
        result = self._values.get("encryption")
        return typing.cast(typing.Optional[builtins.bool], result)

    @builtins.property
    def logging_configuration(
        self,
    ) -> typing.Optional[VoiceConnectorLoggingConfiguration]:
        result = self._values.get("logging_configuration")
        return typing.cast(typing.Optional[VoiceConnectorLoggingConfiguration], result)

    @builtins.property
    def name(self) -> typing.Optional[builtins.str]:
        '''name for VoiceConnector.

        :default: - unique ID for resource
        '''
        result = self._values.get("name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def origination(self) -> typing.Optional[typing.List[Routes]]:
        result = self._values.get("origination")
        return typing.cast(typing.Optional[typing.List[Routes]], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler.

        :default: - same region as stack deployment
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def streaming(self) -> typing.Optional[Streaming]:
        result = self._values.get("streaming")
        return typing.cast(typing.Optional[Streaming], result)

    @builtins.property
    def termination(self) -> typing.Optional[Termination]:
        result = self._values.get("termination")
        return typing.cast(typing.Optional[Termination], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "VoiceConnectorProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "AlexaSkillStatus",
    "AppInstanceAdminProps",
    "AppInstanceDataType",
    "AppInstanceProps",
    "AppInstanceStreamingConfigurations",
    "AppInstanceTags",
    "AppInstanceUserProps",
    "ChannelFlow",
    "ChannelFlowProps",
    "ChannelFlowTags",
    "ChimePhoneNumber",
    "ChimeSipMediaApp",
    "ChimeSipRule",
    "ChimeVoiceConnector",
    "Configuration",
    "FallbackAction",
    "InstanceUserTags",
    "InvocationType",
    "Lambda",
    "MessagingAppInstance",
    "MessagingAppInstanceAdmin",
    "MessagingAppInstanceUser",
    "MessagingResourceProps",
    "MessagingResources",
    "NotificationTargetType",
    "PSTNResourceProps",
    "PSTNResources",
    "PhoneAssociation",
    "PhoneAssociationProps",
    "PhoneCountry",
    "PhoneNumberProps",
    "PhoneNumberType",
    "PhoneProductType",
    "Processors",
    "Protocol",
    "Routes",
    "SipMediaAppProps",
    "SipMediaApplicationAlexaSkillConfiguration",
    "SipMediaApplicationLoggingConfiguration",
    "SipRuleProps",
    "SipRuleTargetApplication",
    "Streaming",
    "StreamingConfig",
    "StreamingConfigurationProps",
    "Termination",
    "TriggerType",
    "VoiceConnectorLoggingConfiguration",
    "VoiceConnectorProps",
]

publication.publish()

def _typecheckingstub__8613bd8924c62f360b8fd11191005b6b40de3e5805e2906daf559c0c4591022d(
    *,
    app_instance_admin_arn: builtins.str,
    app_instance_arn: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__99641216bdb1ac5ae72a17b34ac6ca8ff8cbb075d8ddc07e9db8b47a39a2e63c(
    *,
    client_request_token: typing.Optional[builtins.str] = None,
    metadata: typing.Optional[builtins.str] = None,
    name: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[AppInstanceTags, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__a9b5592853474342b6381b5e6c00a9b05345b286c1268a4def64d116f5fc5143(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    app_instance_arn: builtins.str,
    streaming_configs: typing.Sequence[typing.Union[StreamingConfig, typing.Dict[builtins.str, typing.Any]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__34e7c2248211c91c5400947a073a327c5891999890c50d304103a4b2ede75eda(
    *,
    key: builtins.str,
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d7f1d2afec2a1ee54c9c8c65d06e6449432e7ccd47c39718154ace20f293608b(
    *,
    app_instance_arn: builtins.str,
    app_instance_user_id: builtins.str,
    client_request_token: typing.Optional[builtins.str] = None,
    metadata: typing.Optional[builtins.str] = None,
    name: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[InstanceUserTags, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__80c12dc139a0c6c2028b7459eefbf26ae09174ec3a969cc2f61ac8d92aac274d(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    app_instance_arn: builtins.str,
    client_request_token: builtins.str,
    processors: typing.Sequence[typing.Union[Processors, typing.Dict[builtins.str, typing.Any]]],
    name: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[ChannelFlowTags, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4318c557157fab467f7f5003cd7f6be7ef8ee2b6efc6a633e86ac38c75fc6aaf(
    *,
    app_instance_arn: builtins.str,
    client_request_token: builtins.str,
    processors: typing.Sequence[typing.Union[Processors, typing.Dict[builtins.str, typing.Any]]],
    name: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[ChannelFlowTags, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__423e2b447054eb5049c198e4c2c919b7bcdaeb6ee0e8a7b3792d33ee6a0b1d7b(
    *,
    key: builtins.str,
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7115b79d2edc74ff917d518a81f7a6651e02418753fab2a2a35e2bff1587b5a7(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    phone_product_type: PhoneProductType,
    phone_area_code: typing.Optional[jsii.Number] = None,
    phone_city: typing.Optional[builtins.str] = None,
    phone_country: typing.Optional[PhoneCountry] = None,
    phone_number_toll_free_prefix: typing.Optional[jsii.Number] = None,
    phone_number_type: typing.Optional[PhoneNumberType] = None,
    phone_state: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__113f835f1247755909e4fbd1d3eb6d53265ab846dcd51487ecbfc26db4f5e50b(
    voice_connector_id: ChimeVoiceConnector,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e37db274aeecb4545734b8fe6863b37da6a06c91ab04fbd007ee1878c7cfc2cf(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    endpoint: builtins.str,
    name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__39a8ee26df03196f53b578da14beb4b9253b7c5e47bb51611c9cefd974b2996b(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    target_applications: typing.Sequence[typing.Union[SipRuleTargetApplication, typing.Dict[builtins.str, typing.Any]]],
    trigger_type: TriggerType,
    trigger_value: builtins.str,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__3322e6fa91f7b318e813d5bf83683474955e25e8180642a7921f91e501c051de(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    encryption: typing.Optional[builtins.bool] = None,
    logging_configuration: typing.Optional[typing.Union[VoiceConnectorLoggingConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
    name: typing.Optional[builtins.str] = None,
    origination: typing.Optional[typing.Sequence[typing.Union[Routes, typing.Dict[builtins.str, typing.Any]]]] = None,
    region: typing.Optional[builtins.str] = None,
    streaming: typing.Optional[typing.Union[Streaming, typing.Dict[builtins.str, typing.Any]]] = None,
    termination: typing.Optional[typing.Union[Termination, typing.Dict[builtins.str, typing.Any]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4571f43b9d6d9c78c9a4194cd81c8f6d0723c84dfad67e0dc37cee78b008d9b5(
    *,
    lambda_: typing.Union[Lambda, typing.Dict[builtins.str, typing.Any]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__73075b4d361aeb287fc052a39e6ab5aa8840b8d2c65afb20519d4ff51266dc64(
    *,
    key: builtins.str,
    value: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__578b648f0cf5bcbae9bf298c3b4ec202747ea61fcc36e3c12421adbf714050a6(
    *,
    invocation_type: InvocationType,
    resource_arn: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__0a9f012fab9eb0d816a78f8f21fb2b6ca54774f162a1dd5769f1628ac6f2e8c9(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    client_request_token: typing.Optional[builtins.str] = None,
    metadata: typing.Optional[builtins.str] = None,
    name: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[AppInstanceTags, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__da36a029e1afaaefc489c020934e45363195f10c5727d992a321c13b0043e2c0(
    days: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e11016e616c0eecf971ad1b8d44cee41698040c9f7bb7fc2ef89c3f2b4668454(
    streaming_configs: typing.Sequence[typing.Union[StreamingConfig, typing.Dict[builtins.str, typing.Any]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__40803d0180de29a1b7d03d21acba148c27c1a6eab510cd87e687d82d6108b3d5(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    app_instance_admin_arn: builtins.str,
    app_instance_arn: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__301eef12c49f4f86623f7326244dcbc9fc1774d26e08b7f5e344906a9f195cba(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    app_instance_arn: builtins.str,
    app_instance_user_id: builtins.str,
    client_request_token: typing.Optional[builtins.str] = None,
    metadata: typing.Optional[builtins.str] = None,
    name: typing.Optional[builtins.str] = None,
    tags: typing.Optional[typing.Sequence[typing.Union[InstanceUserTags, typing.Dict[builtins.str, typing.Any]]]] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7688c29fcfcbe8ff3316837ef27d8a5c7629b1f3879e46ab246754bb9571664f(
    *,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
    properties: typing.Mapping[builtins.str, typing.Any],
    resource_type: builtins.str,
    uid: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__e4c733c0cc8a171d0914be8696b8353206a7d5a17dbbdb5ab2171cdd3ffd266e(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    properties: typing.Mapping[builtins.str, typing.Any],
    resource_type: builtins.str,
    uid: builtins.str,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2e7326b3c0a86e27b49bf3d1d67d25db6fc4d4e818fb652a26c9b1a4959e1677(
    *,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
    properties: typing.Mapping[builtins.str, typing.Any],
    resource_type: builtins.str,
    uid: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__fd9372fb4e09a36da7cfd84d9bf339c9f4439d92326a5b861b6e029af5d9c892(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    properties: typing.Mapping[builtins.str, typing.Any],
    resource_type: builtins.str,
    uid: builtins.str,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__993434bc6df235b1954fce1d9dfadb90733323d92c219dca67d88e83d8672f32(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    e164_phone_number: builtins.str,
    voice_connector_id: builtins.str,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__ffcf366f044deabea6d05ca3f221e34c0d86c933a08f738f6fbd42fce75b5d9a(
    *,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
    e164_phone_number: builtins.str,
    voice_connector_id: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__4c5b2ac2a9588b05b4d090bb324c4de18ab13008479ac747fb4c76d5aef2bc55(
    *,
    phone_product_type: PhoneProductType,
    phone_area_code: typing.Optional[jsii.Number] = None,
    phone_city: typing.Optional[builtins.str] = None,
    phone_country: typing.Optional[PhoneCountry] = None,
    phone_number_toll_free_prefix: typing.Optional[jsii.Number] = None,
    phone_number_type: typing.Optional[PhoneNumberType] = None,
    phone_state: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__26ddb27d8877eb97beb38e78204072b302c0a15e44306cc7d732983b023c5ee5(
    *,
    configuration: typing.Union[Configuration, typing.Dict[builtins.str, typing.Any]],
    execution_order: jsii.Number,
    fallback_action: FallbackAction,
    name: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__cb30c4d59c6038c4d49567f143b8a4b4b5355d6c06cc090d64ec9ceaf4ae31ca(
    *,
    host: builtins.str,
    port: jsii.Number,
    priority: jsii.Number,
    protocol: Protocol,
    weight: jsii.Number,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__1800988fcf2743216f6eab079fae412c1cc4d1fd0a60c264fb6dab0dec2bd5b7(
    *,
    endpoint: builtins.str,
    name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__5c9e16054c1863d170b9b208caa0ba2aa47e20d82abe3bd3841cd27e3c34f30f(
    *,
    alexa_skill_ids: typing.Sequence[builtins.str],
    alexa_skill_status: AlexaSkillStatus,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__d62db8768173128e1b08db50f094542e716a3b570d3b88e9b91b7ceafc9474b6(
    *,
    enable_sip_media_application_message_logs: builtins.bool,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__89736ac741fdf808dcb095891a5694b63dd4f0371e5bbc368635a3e619ce1010(
    *,
    target_applications: typing.Sequence[typing.Union[SipRuleTargetApplication, typing.Dict[builtins.str, typing.Any]]],
    trigger_type: TriggerType,
    trigger_value: builtins.str,
    name: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__2c5b839d48377f54265f9cfec24ede27aa6a8c4343f3a3c72630e8aea5ca8635(
    *,
    priority: jsii.Number,
    sip_media_application_id: builtins.str,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__7f414427bb66a4ab1b46218b712d0b4741f86dc6c403c4d7db1728d66c225e03(
    *,
    data_retention: jsii.Number,
    enabled: builtins.bool,
    notification_targets: typing.Sequence[NotificationTargetType],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__13050f73faf4d4a7fa215575da8c79326b0e11ea10cfce2fa2d2ccede60fbeba(
    *,
    app_instance_data_type: AppInstanceDataType,
    resource_arn: builtins.str,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__61924b4976b5e1dcb35eac5d1cdef7ed3590982687eeca03b8b56f49eaac377d(
    *,
    app_instance_arn: builtins.str,
    streaming_configs: typing.Sequence[typing.Union[StreamingConfig, typing.Dict[builtins.str, typing.Any]]],
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__6a9d582d2bde3fddff4ca587aa794f60b27efc8129a4781deadd46f0bbf95df8(
    *,
    calling_regions: typing.Sequence[builtins.str],
    termination_cidrs: typing.Sequence[builtins.str],
    cps: typing.Optional[jsii.Number] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__64dcb7922680bc224be519c5e7594b88e1acabe4f72e4d0658c8c3fb4f94e571(
    *,
    enable_media_metric_logs: typing.Optional[builtins.bool] = None,
    enable_sip_logs: typing.Optional[builtins.bool] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__8bd8e893e1094d68d415fe31b0a78a4d8ce0fb810ef4ab5d04d380bec83b608a(
    *,
    encryption: typing.Optional[builtins.bool] = None,
    logging_configuration: typing.Optional[typing.Union[VoiceConnectorLoggingConfiguration, typing.Dict[builtins.str, typing.Any]]] = None,
    name: typing.Optional[builtins.str] = None,
    origination: typing.Optional[typing.Sequence[typing.Union[Routes, typing.Dict[builtins.str, typing.Any]]]] = None,
    region: typing.Optional[builtins.str] = None,
    streaming: typing.Optional[typing.Union[Streaming, typing.Dict[builtins.str, typing.Any]]] = None,
    termination: typing.Optional[typing.Union[Termination, typing.Dict[builtins.str, typing.Any]]] = None,
) -> None:
    """Type checking stubs"""
    pass
