"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeSipMediaApp = exports.AlexaSkillStatus = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const sipMediaApplicationValidator_1 = require("./sipMediaApplicationValidator");
var AlexaSkillStatus;
(function (AlexaSkillStatus) {
    AlexaSkillStatus["ACTIVE"] = "ACTIVE";
    AlexaSkillStatus["INACTIVE"] = "INACTIVE";
})(AlexaSkillStatus = exports.AlexaSkillStatus || (exports.AlexaSkillStatus = {}));
class ChimeSipMediaApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, endpoint, region } = props;
        sipMediaApplicationValidator_1.sipMediaApplicationValidator(props);
        const sipMediaAppRequest = new pstnCustomResources_1.PSTNResources(this, 'sipMediaAppRequest', {
            resourceType: 'SMA',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name ?? uid,
                endpoint: endpoint,
            },
        });
        this.sipMediaAppId =
            sipMediaAppRequest.pstnCustomResource.getAttString('sipMediaAppId');
    }
    logging(sipMediaApplicationLoggingConfiguration) {
        const uid = cdk.Names.uniqueId(this);
        sipMediaApplicationValidator_1.loggingValidator(sipMediaApplicationLoggingConfiguration);
        const result = new pstnCustomResources_1.PSTNResources(this, 'SMALogging', {
            resourceType: 'SMALogging',
            uid: uid,
            properties: {
                sipMediaApplicationLoggingConfiguration: sipMediaApplicationLoggingConfiguration,
                sipMediaAppId: this.sipMediaAppId,
            },
        });
        return result;
    }
    alexaSkill(sipMediaApplicationAlexaSkillConfiguration) {
        const uid = cdk.Names.uniqueId(this);
        sipMediaApplicationValidator_1.alexaSkillConfigurationValidator(sipMediaApplicationAlexaSkillConfiguration);
        const result = new pstnCustomResources_1.PSTNResources(this, 'SMAAlexaSkill', {
            resourceType: 'SMAAlexaSkill',
            uid: uid,
            properties: {
                sipMediaAppId: this.sipMediaAppId,
                sipMediaApplicationAlexaSkillConfiguration: sipMediaApplicationAlexaSkillConfiguration,
            },
        });
        return result.pstnCustomResource.getAtt('putSipMediaApplicationAlexaSkillConfiguration');
    }
}
exports.ChimeSipMediaApp = ChimeSipMediaApp;
_a = JSII_RTTI_SYMBOL_1;
ChimeSipMediaApp[_a] = { fqn: "cdk-amazon-chime-resources.ChimeSipMediaApp", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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