export declare enum InvocationType {
    ASYNC = "ASYNC"
}
export declare enum FallbackAction {
    CONTINUE = "CONTINUE",
    ABORT = "ABORT"
}
interface Tags {
    key: string;
    value: string;
}
interface ConfigurationProps {
    lambda: {
        resourceArn: string;
        invocationType: InvocationType;
    };
}
interface ProcessorProps {
    configuration: ConfigurationProps;
    executionOrder: string;
    fallbackAction: FallbackAction;
    name: string;
}
interface CreateChannelFlowProps {
    name?: string;
    clientRequestToken?: string;
    appInstanceArn?: string;
    tags?: Tags[];
    processors?: ProcessorProps[];
}
export declare const CreateChannelFlow: (uid: string, props: CreateChannelFlowProps) => Promise<{
    channelFlowArn: string | undefined;
}>;
export declare const DeleteChannelFlow: (uid: string) => Promise<void>;
export {};
