"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const phoneNumber_1 = require("./phoneNumber");
const sipMediaApp_1 = require("./sipMediaApp");
const sipRule_1 = require("./sipRule");
const voiceConnector_1 = require("./voiceConnector");
const response = {};
let resourcePropertiesUid;
let requestProperties;
exports.handler = async (event, context) => {
    console.info('event: ', event);
    const resourceType = event.ResourceProperties.resourceType;
    const requestType = event.RequestType;
    resourcePropertiesUid = event.ResourceProperties.uid;
    requestProperties = event.ResourceProperties.properties;
    response.StackId = event.StackId;
    response.RequestId = event.RequestId;
    response.LogicalResourceId = event.LogicalResourceId;
    response.PhysicalResourceId = context.logGroupName;
    switch (resourceType) {
        case 'PhoneNumber':
            switch (requestType) {
                case 'Create':
                    response.Data = await phoneNumber_1.CreatePhoneNumber(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreatePhoneNumber successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await phoneNumber_1.DeletePhoneNumber(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeletePhoneNumber successful';
                    break;
            }
            break;
        case 'SMARule':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipRule_1.CreateSIPRule(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'CreateSMARule successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await sipRule_1.DeleteSIPRule(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'DeleteSMARule successful';
                    break;
            }
            break;
        case 'SMA':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.CreateSipMediaApplication(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create SMA successful';
                    break;
                case 'Update':
                    response.Status = 'SUCCESS';
                    break;
                case 'Delete':
                    await sipMediaApp_1.DeleteSipMediaApplication(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete SMA successful';
                    break;
            }
            break;
        case 'SMALogging':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationLogging(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging successful';
                    break;
                case 'Update':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationLogging(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging successful';
                    break;
                case 'Delete':
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationLogging Delete NoOP';
                    break;
            }
            break;
        case 'SMAAlexaSkill':
            switch (requestType) {
                case 'Create':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationAlexaSkill(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill successful';
                    break;
                case 'Update':
                    response.Data = await sipMediaApp_1.PutSipMediaApplicationAlexaSkill(requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill successful';
                    break;
                case 'Delete':
                    response.Status = 'SUCCESS';
                    response.Reason = 'PutSipMediaApplicationAlexaSkill Delete NoOP';
                    break;
            }
            break;
        case 'VoiceConnector':
            switch (requestType) {
                case 'Create':
                    response.Data = await voiceConnector_1.CreateVoiceConnector(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Create VC successful';
                    break;
                case 'Update':
                    response.Data = await voiceConnector_1.UpdateVoiceConnector(resourcePropertiesUid, requestProperties);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Update VC successful';
                    break;
                case 'Delete':
                    await voiceConnector_1.DeleteVoiceConnector(resourcePropertiesUid);
                    response.Status = 'SUCCESS';
                    response.Reason = 'Delete VC successful';
                    break;
            }
            break;
    }
    console.log(`Response: ${JSON.stringify(response)}`);
    return response;
};
//# sourceMappingURL=data:application/json;base64,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