"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteSIPRule = exports.CreateSIPRule = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const client_chime_sdk_voice_1 = require("@aws-sdk/client-chime-sdk-voice");
const client_ssm_1 = require("@aws-sdk/client-ssm");
const chimeSDKVoiceClient = new client_chime_sdk_voice_1.ChimeSDKVoiceClient({
    region: process.env.AWS_REGION,
});
const ssmClient = new client_ssm_1.SSMClient({ region: process.env.AWS_REGION });
let createSipRuleParams;
let createSipRuleResponse;
let getParameterCommandOutput;
let sipRuleToDelete;
let sipRuleTargetApplications;
exports.CreateSIPRule = async (uid, props) => {
    console.log(`Creating SIP media application rule: ${uid}`);
    console.log(`Create SIP media application rule props: ${JSON.stringify(props)}`);
    sipRuleTargetApplications = [];
    props.targetApplications?.forEach((targetApplication) => {
        sipRuleTargetApplications.push({
            AwsRegion: targetApplication.region,
            SipMediaApplicationId: targetApplication.sipMediaApplicationId,
            Priority: parseInt(targetApplication.priority),
        });
    });
    createSipRuleParams = {
        Name: props.name,
        TriggerType: props.triggerType,
        TriggerValue: props.triggerValue,
        TargetApplications: sipRuleTargetApplications,
    };
    console.log(`Create SIP media application rule params: ${JSON.stringify(createSipRuleParams)}`);
    try {
        createSipRuleResponse = await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.CreateSipRuleCommand(createSipRuleParams));
        console.log(createSipRuleResponse);
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await ssmClient.send(new client_ssm_1.PutParameterCommand({
            Name: '/chime/sipRule' + uid,
            Value: createSipRuleResponse.SipRule?.SipRuleId,
            Description: 'SIP Rule ID',
            Overwrite: true,
            Type: 'String',
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    return {
        sipRuleId: createSipRuleResponse.SipRule?.SipRuleId,
    };
};
exports.DeleteSIPRule = async (uid) => {
    try {
        getParameterCommandOutput = await ssmClient.send(new client_ssm_1.GetParameterCommand({ Name: '/chime/sipRule' + uid }));
        if (getParameterCommandOutput.Parameter &&
            getParameterCommandOutput.Parameter.Value) {
            sipRuleToDelete = getParameterCommandOutput.Parameter.Value;
        }
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.UpdateSipRuleCommand({
            SipRuleId: sipRuleToDelete,
            Name: uid,
            Disabled: true,
        }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
    let getSipRuleCommandCount = 0;
    while (!(await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.GetSipRuleCommand({ SipRuleId: sipRuleToDelete })))) {
        getSipRuleCommandCount++;
        if (getSipRuleCommandCount > 15) {
            throw new Error('Could not disable SIP rule');
        }
        await sleep(5000);
    }
    try {
        await chimeSDKVoiceClient.send(new client_chime_sdk_voice_1.DeleteSipRuleCommand({
            SipRuleId: sipRuleToDelete,
        }));
        await ssmClient.send(new client_ssm_1.DeleteParameterCommand({ Name: '/chime/sipRule' + uid }));
    }
    catch (error) {
        if (error instanceof Error) {
            console.error(error);
            throw error;
        }
    }
};
const sleep = (ms) => new Promise((r) => setTimeout(r, ms));
//# sourceMappingURL=data:application/json;base64,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