import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  ChimeClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../ChimeClient";
import {
  UpdateAccountSettingsRequest,
  UpdateAccountSettingsResponse,
} from "../models/models_1";
export interface UpdateAccountSettingsCommandInput
  extends UpdateAccountSettingsRequest {}
export interface UpdateAccountSettingsCommandOutput
  extends UpdateAccountSettingsResponse,
    __MetadataBearer {}
export declare class UpdateAccountSettingsCommand extends $Command<
  UpdateAccountSettingsCommandInput,
  UpdateAccountSettingsCommandOutput,
  ChimeClientResolvedConfig
> {
  readonly input: UpdateAccountSettingsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: UpdateAccountSettingsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: ChimeClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    UpdateAccountSettingsCommandInput,
    UpdateAccountSettingsCommandOutput
  >;
  private serialize;
  private deserialize;
}
