import os
import csv
from datetime import datetime
from colorama import Fore, Back, Style
import sys
from ValiotWorker.Logging import (log, LogLevel)

def silent_removefile(filename):
  try:
    os.remove(filename)
  except OSError:
    pass

def query_yes_no(question, default="yes", level=LogLevel.INFO):
  """Ask a yes/no question via raw_input() and return their answer.

  "question" is a string that is presented to the user.
  "default" is the presumed answer if the user just hits <Enter>.
      It must be "yes" (the default), "no" or None (meaning
      an answer is required of the user).

  The "answer" return value is True for "yes" or False for "no".
  """
  valid = {
    "yes": True,
    "y": True,
    "ye": True,
    "no": False,
    "n": False
  }
  if default is None:
    prompt = " [y/n] "
  elif default == "yes":
    prompt = " [Y/n] "
  elif default == "no":
    prompt = " [y/N] "
  else:
    raise ValueError("invalid default answer: '%s'" % default)

  while True:
    log(level, question + prompt)
    choice = input().lower()
    if default is not None and choice == '':
      return valid[default]
    elif choice in valid:
      return valid[choice]
    else:
      log(LogLevel.WARNING, "Please respond with (yes/no) or (y/n).")
