# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class AccountTeamProject(pulumi.CustomResource):
    account_id: pulumi.Output[str]
    """
    Account id
    """
    project_name: pulumi.Output[str]
    """
    Account team project name
    """
    team_id: pulumi.Output[str]
    """
    Account team id
    """
    team_type: pulumi.Output[str]
    """
    Account team project type, can one of the following values: admin, developer, operator and read_only
    """
    def __init__(__self__, resource_name, opts=None, account_id=None, project_name=None, team_id=None, team_type=None, __props__=None, __name__=None, __opts__=None):
        """
        The account team project is intended to link and existing project to the existing account team. It is important to note 
        that the project should have an `account_id` property set and equal to account team you are trying to link this project.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        project1 = aiven.Project("project1",
            account_id=aiven_account_team["developers"]["account_id"],
            project="project-1")
        account_team_project1 = aiven.AccountTeamProject("accountTeamProject1",
            account_id=aiven_account_team["developers"]["account_id"],
            project_name=project1.project,
            team_id=aiven_account_team["developers"]["team_id"],
            team_type="admin")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] project_name: Account team project name
        :param pulumi.Input[str] team_id: Account team id
        :param pulumi.Input[str] team_type: Account team project type, can one of the following values: admin, developer, operator and read_only
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if account_id is None:
                raise TypeError("Missing required property 'account_id'")
            __props__['account_id'] = account_id
            __props__['project_name'] = project_name
            if team_id is None:
                raise TypeError("Missing required property 'team_id'")
            __props__['team_id'] = team_id
            __props__['team_type'] = team_type
        super(AccountTeamProject, __self__).__init__(
            'aiven:index/accountTeamProject:AccountTeamProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, account_id=None, project_name=None, team_id=None, team_type=None):
        """
        Get an existing AccountTeamProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: Account id
        :param pulumi.Input[str] project_name: Account team project name
        :param pulumi.Input[str] team_id: Account team id
        :param pulumi.Input[str] team_type: Account team project type, can one of the following values: admin, developer, operator and read_only
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_id"] = account_id
        __props__["project_name"] = project_name
        __props__["team_id"] = team_id
        __props__["team_type"] = team_type
        return AccountTeamProject(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

