# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Database(pulumi.CustomResource):
    database_name: pulumi.Output[str]
    """
    Service database name
    """
    lc_collate: pulumi.Output[str]
    """
    Default string sort order (LC_COLLATE) of the database. Default value: en_US.UTF-8
    """
    lc_ctype: pulumi.Output[str]
    """
    Default character classification (LC_CTYPE) of the database. Default value: en_US.UTF-8
    """
    project: pulumi.Output[str]
    """
    Project to link the database to
    """
    service_name: pulumi.Output[str]
    """
    Service to link the database to
    """
    termination_protection: pulumi.Output[bool]
    """
    It is a Terraform client-side deletion protections, which prevents the database from being deleted by Terraform. It is
    recommended to enable this for any production databases containing critical data.
    """
    def __init__(__self__, resource_name, opts=None, database_name=None, lc_collate=None, lc_ctype=None, project=None, service_name=None, termination_protection=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        mydatabase = aiven.Database("mydatabase",
            database_name="<DATABASE_NAME>",
            project=aiven_project["myproject"]["project"],
            service_name=aiven_service["myservice"]["service_name"])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: Service database name
        :param pulumi.Input[str] lc_collate: Default string sort order (LC_COLLATE) of the database. Default value: en_US.UTF-8
        :param pulumi.Input[str] lc_ctype: Default character classification (LC_CTYPE) of the database. Default value: en_US.UTF-8
        :param pulumi.Input[str] project: Project to link the database to
        :param pulumi.Input[str] service_name: Service to link the database to
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protections, which prevents the database from being deleted by Terraform. It is
               recommended to enable this for any production databases containing critical data.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if database_name is None:
                raise TypeError("Missing required property 'database_name'")
            __props__['database_name'] = database_name
            __props__['lc_collate'] = lc_collate
            __props__['lc_ctype'] = lc_ctype
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            __props__['termination_protection'] = termination_protection
        super(Database, __self__).__init__(
            'aiven:index/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, database_name=None, lc_collate=None, lc_ctype=None, project=None, service_name=None, termination_protection=None):
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] database_name: Service database name
        :param pulumi.Input[str] lc_collate: Default string sort order (LC_COLLATE) of the database. Default value: en_US.UTF-8
        :param pulumi.Input[str] lc_ctype: Default character classification (LC_CTYPE) of the database. Default value: en_US.UTF-8
        :param pulumi.Input[str] project: Project to link the database to
        :param pulumi.Input[str] service_name: Service to link the database to
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protections, which prevents the database from being deleted by Terraform. It is
               recommended to enable this for any production databases containing critical data.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["database_name"] = database_name
        __props__["lc_collate"] = lc_collate
        __props__["lc_ctype"] = lc_ctype
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["termination_protection"] = termination_protection
        return Database(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

