# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class KafkaConnector(pulumi.CustomResource):
    config: pulumi.Output[dict]
    """
    Kafka Connector configuration parameters
    """
    connector_name: pulumi.Output[str]
    """
    Kafka connector name
    """
    plugin_author: pulumi.Output[str]
    """
    Kafka connector author
    """
    plugin_class: pulumi.Output[str]
    """
    Kafka connector Java class
    """
    plugin_doc_url: pulumi.Output[str]
    """
    Kafka connector documentation URL
    """
    plugin_title: pulumi.Output[str]
    """
    Kafka connector title
    """
    plugin_type: pulumi.Output[str]
    """
    Kafka connector type
    """
    plugin_version: pulumi.Output[str]
    """
    Kafka connector version
    """
    project: pulumi.Output[str]
    """
    Project to link the kafka connector to
    """
    service_name: pulumi.Output[str]
    """
    Service to link the kafka connector to
    """
    tasks: pulumi.Output[list]
    """
    List of tasks of a connector

      * `connector` (`str`)
      * `task` (`float`)
    """
    def __init__(__self__, resource_name, opts=None, config=None, connector_name=None, project=None, service_name=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a KafkaConnector resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] config: Kafka Connector configuration parameters
        :param pulumi.Input[str] connector_name: Kafka connector name
        :param pulumi.Input[str] project: Project to link the kafka connector to
        :param pulumi.Input[str] service_name: Service to link the kafka connector to
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if config is None:
                raise TypeError("Missing required property 'config'")
            __props__['config'] = config
            if connector_name is None:
                raise TypeError("Missing required property 'connector_name'")
            __props__['connector_name'] = connector_name
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            __props__['plugin_author'] = None
            __props__['plugin_class'] = None
            __props__['plugin_doc_url'] = None
            __props__['plugin_title'] = None
            __props__['plugin_type'] = None
            __props__['plugin_version'] = None
            __props__['tasks'] = None
        super(KafkaConnector, __self__).__init__(
            'aiven:index/kafkaConnector:KafkaConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, config=None, connector_name=None, plugin_author=None, plugin_class=None, plugin_doc_url=None, plugin_title=None, plugin_type=None, plugin_version=None, project=None, service_name=None, tasks=None):
        """
        Get an existing KafkaConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] config: Kafka Connector configuration parameters
        :param pulumi.Input[str] connector_name: Kafka connector name
        :param pulumi.Input[str] plugin_author: Kafka connector author
        :param pulumi.Input[str] plugin_class: Kafka connector Java class
        :param pulumi.Input[str] plugin_doc_url: Kafka connector documentation URL
        :param pulumi.Input[str] plugin_title: Kafka connector title
        :param pulumi.Input[str] plugin_type: Kafka connector type
        :param pulumi.Input[str] plugin_version: Kafka connector version
        :param pulumi.Input[str] project: Project to link the kafka connector to
        :param pulumi.Input[str] service_name: Service to link the kafka connector to
        :param pulumi.Input[list] tasks: List of tasks of a connector

        The **tasks** object supports the following:

          * `connector` (`pulumi.Input[str]`)
          * `task` (`pulumi.Input[float]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["config"] = config
        __props__["connector_name"] = connector_name
        __props__["plugin_author"] = plugin_author
        __props__["plugin_class"] = plugin_class
        __props__["plugin_doc_url"] = plugin_doc_url
        __props__["plugin_title"] = plugin_title
        __props__["plugin_type"] = plugin_type
        __props__["plugin_version"] = plugin_version
        __props__["project"] = project
        __props__["service_name"] = service_name
        __props__["tasks"] = tasks
        return KafkaConnector(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

