# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class KafkaTopic(pulumi.CustomResource):
    cleanup_policy: pulumi.Output[str]
    """
    Topic cleanup policy. Allowed values: delete, compact
    """
    client_timeout: pulumi.Output[dict]
    """
    Custom Terraform Client timeouts

      * `create` (`str`)
      * `read` (`str`)
    """
    minimum_in_sync_replicas: pulumi.Output[float]
    """
    Minimum required nodes in-sync replicas (ISR) to produce to a partition
    """
    partitions: pulumi.Output[float]
    """
    Number of partitions to create in the topic
    """
    project: pulumi.Output[str]
    """
    Project to link the kafka topic to
    """
    replication: pulumi.Output[float]
    """
    Replication factor for the topic
    """
    retention_bytes: pulumi.Output[float]
    """
    Retention bytes
    """
    retention_hours: pulumi.Output[float]
    """
    Retention period (hours)
    """
    service_name: pulumi.Output[str]
    """
    Service to link the kafka topic to
    """
    termination_protection: pulumi.Output[bool]
    """
    It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
    enable this for any production Kafka topic containing critical data.
    """
    topic_name: pulumi.Output[str]
    """
    Topic name
    """
    def __init__(__self__, resource_name, opts=None, cleanup_policy=None, client_timeout=None, minimum_in_sync_replicas=None, partitions=None, project=None, replication=None, retention_bytes=None, retention_hours=None, service_name=None, termination_protection=None, topic_name=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        mytesttopic = aiven.KafkaTopic("mytesttopic",
            cleanup_policy="delete",
            minimum_in_sync_replicas=2,
            partitions=5,
            project=aiven_project["myproject"]["project"],
            replication=3,
            retention_bytes=-1,
            retention_hours=72,
            service_name=aiven_service["myservice"]["service_name"],
            topic_name="<TOPIC_NAME>")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cleanup_policy: Topic cleanup policy. Allowed values: delete, compact
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[float] minimum_in_sync_replicas: Minimum required nodes in-sync replicas (ISR) to produce to a partition
        :param pulumi.Input[float] partitions: Number of partitions to create in the topic
        :param pulumi.Input[str] project: Project to link the kafka topic to
        :param pulumi.Input[float] replication: Replication factor for the topic
        :param pulumi.Input[float] retention_bytes: Retention bytes
        :param pulumi.Input[float] retention_hours: Retention period (hours)
        :param pulumi.Input[str] service_name: Service to link the kafka topic to
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: Topic name

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
          * `read` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cleanup_policy'] = cleanup_policy
            if client_timeout is not None:
                warnings.warn("use timeouts instead", DeprecationWarning)
                pulumi.log.warn("client_timeout is deprecated: use timeouts instead")
            __props__['client_timeout'] = client_timeout
            __props__['minimum_in_sync_replicas'] = minimum_in_sync_replicas
            if partitions is None:
                raise TypeError("Missing required property 'partitions'")
            __props__['partitions'] = partitions
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if replication is None:
                raise TypeError("Missing required property 'replication'")
            __props__['replication'] = replication
            __props__['retention_bytes'] = retention_bytes
            __props__['retention_hours'] = retention_hours
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            __props__['termination_protection'] = termination_protection
            if topic_name is None:
                raise TypeError("Missing required property 'topic_name'")
            __props__['topic_name'] = topic_name
        super(KafkaTopic, __self__).__init__(
            'aiven:index/kafkaTopic:KafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, cleanup_policy=None, client_timeout=None, minimum_in_sync_replicas=None, partitions=None, project=None, replication=None, retention_bytes=None, retention_hours=None, service_name=None, termination_protection=None, topic_name=None):
        """
        Get an existing KafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cleanup_policy: Topic cleanup policy. Allowed values: delete, compact
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[float] minimum_in_sync_replicas: Minimum required nodes in-sync replicas (ISR) to produce to a partition
        :param pulumi.Input[float] partitions: Number of partitions to create in the topic
        :param pulumi.Input[str] project: Project to link the kafka topic to
        :param pulumi.Input[float] replication: Replication factor for the topic
        :param pulumi.Input[float] retention_bytes: Retention bytes
        :param pulumi.Input[float] retention_hours: Retention period (hours)
        :param pulumi.Input[str] service_name: Service to link the kafka topic to
        :param pulumi.Input[bool] termination_protection: It is a Terraform client-side deletion protection, which prevents a Kafka topic from being deleted. It is recommended to
               enable this for any production Kafka topic containing critical data.
        :param pulumi.Input[str] topic_name: Topic name

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
          * `read` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cleanup_policy"] = cleanup_policy
        __props__["client_timeout"] = client_timeout
        __props__["minimum_in_sync_replicas"] = minimum_in_sync_replicas
        __props__["partitions"] = partitions
        __props__["project"] = project
        __props__["replication"] = replication
        __props__["retention_bytes"] = retention_bytes
        __props__["retention_hours"] = retention_hours
        __props__["service_name"] = service_name
        __props__["termination_protection"] = termination_protection
        __props__["topic_name"] = topic_name
        return KafkaTopic(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

