# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ProjectVpc(pulumi.CustomResource):
    client_timeout: pulumi.Output[dict]
    """
    Custom Terraform Client timeouts

      * `create` (`str`)
      * `delete` (`str`)
    """
    cloud_name: pulumi.Output[str]
    """
    Cloud the VPC is in
    """
    network_cidr: pulumi.Output[str]
    """
    Network address range used by the VPC like 192.168.0.0/24
    """
    project: pulumi.Output[str]
    """
    The project the VPC belongs to
    """
    state: pulumi.Output[str]
    """
    State of the VPC (APPROVED, ACTIVE, DELETING, DELETED)
    """
    def __init__(__self__, resource_name, opts=None, client_timeout=None, cloud_name=None, network_cidr=None, project=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        myvpc = aiven.ProjectVpc("myvpc",
            cloud_name="google-europe-west1",
            network_cidr="192.168.0.1/24",
            project=aiven_project["myproject"]["project"])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[str] cloud_name: Cloud the VPC is in
        :param pulumi.Input[str] network_cidr: Network address range used by the VPC like 192.168.0.0/24
        :param pulumi.Input[str] project: The project the VPC belongs to

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
          * `delete` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if client_timeout is not None:
                warnings.warn("use timeouts instead", DeprecationWarning)
                pulumi.log.warn("client_timeout is deprecated: use timeouts instead")
            __props__['client_timeout'] = client_timeout
            if cloud_name is None:
                raise TypeError("Missing required property 'cloud_name'")
            __props__['cloud_name'] = cloud_name
            if network_cidr is None:
                raise TypeError("Missing required property 'network_cidr'")
            __props__['network_cidr'] = network_cidr
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['state'] = None
        super(ProjectVpc, __self__).__init__(
            'aiven:index/projectVpc:ProjectVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, client_timeout=None, cloud_name=None, network_cidr=None, project=None, state=None):
        """
        Get an existing ProjectVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[str] cloud_name: Cloud the VPC is in
        :param pulumi.Input[str] network_cidr: Network address range used by the VPC like 192.168.0.0/24
        :param pulumi.Input[str] project: The project the VPC belongs to
        :param pulumi.Input[str] state: State of the VPC (APPROVED, ACTIVE, DELETING, DELETED)

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
          * `delete` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["client_timeout"] = client_timeout
        __props__["cloud_name"] = cloud_name
        __props__["network_cidr"] = network_cidr
        __props__["project"] = project
        __props__["state"] = state
        return ProjectVpc(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

