# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Service(pulumi.CustomResource):
    cassandra: pulumi.Output[dict]
    """
    Cassandra specific server provided values
    """
    cassandra_user_config: pulumi.Output[dict]
    """
    Cassandra specific user configurable settings

      * `ipFilters` (`list`)
      * `migrateSstableloader` (`str`)
      * `privateAccess` (`dict`)
        * `prometheus` (`str`)

      * `publicAccess` (`dict`)
        * `prometheus` (`str`)

      * `serviceToForkFrom` (`str`)
    """
    client_timeout: pulumi.Output[dict]
    """
    Custom Terraform Client timeouts

      * `create` (`str`)
      * `update` (`str`)
    """
    cloud_name: pulumi.Output[str]
    """
    Cloud the service runs in
    """
    components: pulumi.Output[list]
    """
    Service component information objects

      * `component` (`str`)
      * `host` (`str`)
      * `kafkaAuthenticationMethod` (`str`)
      * `port` (`float`)
      * `route` (`str`)
      * `ssl` (`bool`)
      * `usage` (`str`)
    """
    elasticsearch: pulumi.Output[dict]
    """
    Elasticsearch specific server provided values

      * `kibanaUri` (`str`)
    """
    elasticsearch_user_config: pulumi.Output[dict]
    """
    Elasticsearch specific user configurable settings

      * `customDomain` (`str`)
      * `disableReplicationFactorAdjustment` (`str`)
      * `elasticsearch` (`dict`)
        * `actionAutoCreateIndexEnabled` (`str`)
        * `actionDestructiveRequiresName` (`str`)
        * `httpMaxContentLength` (`str`)
        * `httpMaxHeaderSize` (`str`)
        * `httpMaxInitialLineLength` (`str`)
        * `indicesFielddataCacheSize` (`str`)
        * `indicesMemoryIndexBufferSize` (`str`)
        * `indicesQueriesCacheSize` (`str`)
        * `indicesQueryBoolMaxClauseCount` (`str`)
        * `reindexRemoteWhitelists` (`list`)
        * `threadPoolAnalyzeQueueSize` (`str`)
        * `threadPoolAnalyzeSize` (`str`)
        * `threadPoolForceMergeSize` (`str`)
        * `threadPoolGetQueueSize` (`str`)
        * `threadPoolGetSize` (`str`)
        * `threadPoolIndexQueueSize` (`str`)
        * `threadPoolIndexSize` (`str`)
        * `threadPoolSearchQueueSize` (`str`)
        * `threadPoolSearchSize` (`str`)
        * `threadPoolSearchThrottledQueueSize` (`str`)
        * `threadPoolSearchThrottledSize` (`str`)
        * `threadPoolWriteQueueSize` (`str`)
        * `threadPoolWriteSize` (`str`)

      * `elasticsearchVersion` (`str`)
      * `indexPatterns` (`list`)
        * `maxIndexCount` (`str`)
        * `pattern` (`str`)

      * `ipFilters` (`list`)
      * `kibana` (`dict`)
        * `elasticsearchRequestTimeout` (`str`)
        * `enabled` (`str`)
        * `maxOldSpaceSize` (`str`)

      * `maxIndexCount` (`str`)
      * `privateAccess` (`dict`)
        * `elasticsearch` (`str`)
        * `kibana` (`str`)
        * `prometheus` (`str`)

      * `publicAccess` (`dict`)
        * `elasticsearch` (`str`)
        * `kibana` (`str`)
        * `prometheus` (`str`)

      * `recoveryBasebackupName` (`str`)
      * `serviceToForkFrom` (`str`)
    """
    grafana: pulumi.Output[dict]
    """
    Grafana specific server provided values
    """
    grafana_user_config: pulumi.Output[dict]
    """
    Grafana specific user configurable settings

      * `alertingEnabled` (`str`)
      * `alertingErrorOrTimeout` (`str`)
      * `alertingNodataOrNullvalues` (`str`)
      * `allowEmbedding` (`str`)
      * `authBasicEnabled` (`str`)
      * `authGenericOauth` (`dict`)
        * `allowSignUp` (`str`)
        * `allowedDomains` (`list`)
        * `allowedOrganizations` (`list`)
        * `apiUrl` (`str`)
        * `authUrl` (`str`)
        * `clientId` (`str`)
        * `clientSecret` (`str`)
        * `name` (`str`)
        * `scopes` (`list`)
        * `tokenUrl` (`str`)

      * `authGithub` (`dict`)
        * `allowSignUp` (`str`)
        * `allowedOrganizations` (`list`)
        * `clientId` (`str`)
        * `clientSecret` (`str`)
        * `teamIds` (`list`)

      * `authGitlab` (`dict`)
        * `allowSignUp` (`str`)
        * `allowedGroups` (`list`)
        * `apiUrl` (`str`)
        * `authUrl` (`str`)
        * `clientId` (`str`)
        * `clientSecret` (`str`)
        * `tokenUrl` (`str`)

      * `authGoogle` (`dict`)
        * `allowSignUp` (`str`)
        * `allowedDomains` (`list`)
        * `clientId` (`str`)
        * `clientSecret` (`str`)

      * `cookieSamesite` (`str`)
      * `customDomain` (`str`)
      * `dashboardsVersionsToKeep` (`str`)
      * `dataproxySendUserHeader` (`str`)
      * `dataproxyTimeout` (`str`)
      * `disableGravatar` (`str`)
      * `editorsCanAdmin` (`str`)
      * `externalImageStorage` (`dict`)
        * `access_key` (`str`)
        * `bucketUrl` (`str`)
        * `provider` (`str`)
        * `secretKey` (`str`)

      * `googleAnalyticsUaId` (`str`)
      * `ipFilters` (`list`)
      * `metricsEnabled` (`str`)
      * `privateAccess` (`dict`)
        * `grafana` (`str`)

      * `publicAccess` (`dict`)
        * `grafana` (`str`)

      * `smtpServer` (`dict`)
        * `fromAddress` (`str`)
        * `fromName` (`str`)
        * `host` (`str`)
        * `password` (`str`)
        * `port` (`str`)
        * `skipVerify` (`str`)
        * `username` (`str`)

      * `userAutoAssignOrg` (`str`)
      * `userAutoAssignOrgRole` (`str`)
      * `viewersCanEdit` (`str`)
    """
    influxdb: pulumi.Output[dict]
    """
    InfluxDB specific server provided values

      * `database_name` (`str`)
    """
    influxdb_user_config: pulumi.Output[dict]
    """
    InfluxDB specific user configurable settings

      * `customDomain` (`str`)
      * `ipFilters` (`list`)
      * `privateAccess` (`dict`)
        * `influxdb` (`str`)

      * `publicAccess` (`dict`)
        * `influxdb` (`str`)

      * `serviceToForkFrom` (`str`)
    """
    kafka: pulumi.Output[dict]
    """
    Kafka specific server provided values

      * `access_cert` (`str`)
      * `access_key` (`str`)
      * `connectUri` (`str`)
      * `restUri` (`str`)
      * `schemaRegistryUri` (`str`)
    """
    kafka_connect: pulumi.Output[dict]
    """
    Kafka Connect specific server provided values
    """
    kafka_connect_user_config: pulumi.Output[dict]
    """
    Kafka Connect specific user configurable settings

      * `ipFilters` (`list`)
      * `kafka_connect` (`dict`)
        * `consumerIsolationLevel` (`str`)
        * `consumerMaxPollRecords` (`str`)
        * `offsetFlushIntervalMs` (`str`)

      * `privateAccess` (`dict`)
        * `kafka_connect` (`str`)
        * `prometheus` (`str`)

      * `publicAccess` (`dict`)
        * `kafka_connect` (`str`)
        * `prometheus` (`str`)
    """
    kafka_mirrormaker: pulumi.Output[dict]
    """
    Kafka MirrorMaker 2 specific server provided values
    """
    kafka_mirrormaker_user_config: pulumi.Output[dict]
    """
    Kafka MirrorMaker 2 specific user configurable settings

      * `ipFilters` (`list`)
      * `kafka_mirrormaker` (`dict`)
        * `refreshGroupsEnabled` (`str`)
        * `refreshGroupsIntervalSeconds` (`str`)
        * `refreshTopicsEnabled` (`str`)
        * `refreshTopicsIntervalSeconds` (`str`)
    """
    kafka_user_config: pulumi.Output[dict]
    """
    Kafka specific user configurable settings

      * `customDomain` (`str`)
      * `ipFilters` (`list`)
      * `kafka` (`dict`)
        * `autoCreateTopicsEnable` (`str`)
        * `compressionType` (`str`)
        * `connectionsMaxIdleMs` (`str`)
        * `defaultReplicationFactor` (`str`)
        * `groupMaxSessionTimeoutMs` (`str`)
        * `groupMinSessionTimeoutMs` (`str`)
        * `logCleanerMaxCompactionLagMs` (`str`)
        * `logCleanerMinCleanableRatio` (`str`)
        * `logCleanerMinCompactionLagMs` (`str`)
        * `logCleanupPolicy` (`str`)
        * `logMessageTimestampDifferenceMaxMs` (`str`)
        * `logMessageTimestampType` (`str`)
        * `logRetentionBytes` (`str`)
        * `logRetentionHours` (`str`)
        * `logSegmentBytes` (`str`)
        * `maxConnectionsPerIp` (`str`)
        * `messageMaxBytes` (`str`)
        * `numPartitions` (`str`)
        * `offsetsRetentionMinutes` (`str`)
        * `producerPurgatoryPurgeIntervalRequests` (`str`)
        * `replicaFetchMaxBytes` (`str`)
        * `replicaFetchResponseMaxBytes` (`str`)
        * `socketRequestMaxBytes` (`str`)

      * `kafkaAuthenticationMethods` (`dict`)
        * `certificate` (`str`)
        * `sasl` (`str`)

      * `kafka_connect` (`str`)
      * `kafkaConnectConfig` (`dict`)
        * `consumerIsolationLevel` (`str`)
        * `consumerMaxPollRecords` (`str`)
        * `offsetFlushIntervalMs` (`str`)

      * `kafkaRest` (`str`)
      * `kafkaRestConfig` (`dict`)
        * `consumerEnableAutoCommit` (`str`)
        * `consumerRequestMaxBytes` (`str`)
        * `consumerRequestTimeoutMs` (`str`)
        * `producerAcks` (`str`)
        * `producerLingerMs` (`str`)
        * `simpleconsumerPoolSizeMax` (`str`)

      * `kafkaVersion` (`str`)
      * `privateAccess` (`dict`)
        * `prometheus` (`str`)

      * `publicAccess` (`dict`)
        * `kafka` (`str`)
        * `kafka_connect` (`str`)
        * `kafkaRest` (`str`)
        * `prometheus` (`str`)
        * `schemaRegistry` (`str`)

      * `schemaRegistry` (`str`)
    """
    maintenance_window_dow: pulumi.Output[str]
    """
    Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
    """
    maintenance_window_time: pulumi.Output[str]
    """
    Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
    """
    mysql: pulumi.Output[dict]
    """
    MySQL specific server provided values
    """
    mysql_user_config: pulumi.Output[dict]
    """
    MySQL specific user configurable settings

      * `adminPassword` (`str`)
      * `adminUsername` (`str`)
      * `backupHour` (`str`)
      * `backupMinute` (`str`)
      * `ipFilters` (`list`)
      * `mysql` (`dict`)
        * `connectTimeout` (`str`)
        * `defaultTimeZone` (`str`)
        * `groupConcatMaxLen` (`str`)
        * `informationSchemaStatsExpiry` (`str`)
        * `innodbFtMinTokenSize` (`str`)
        * `innodbFtServerStopwordTable` (`str`)
        * `innodbLockWaitTimeout` (`str`)
        * `innodbLogBufferSize` (`str`)
        * `innodbOnlineAlterLogMaxSize` (`str`)
        * `innodbRollbackOnTimeout` (`str`)
        * `interactiveTimeout` (`str`)
        * `maxAllowedPacket` (`str`)
        * `maxHeapTableSize` (`str`)
        * `netReadTimeout` (`str`)
        * `netWriteTimeout` (`str`)
        * `sortBufferSize` (`str`)
        * `sqlMode` (`str`)
        * `sqlRequirePrimaryKey` (`str`)
        * `tmpTableSize` (`str`)
        * `waitTimeout` (`str`)

      * `mysqlVersion` (`str`)
      * `privateAccess` (`dict`)
        * `mysql` (`str`)
        * `prometheus` (`str`)

      * `publicAccess` (`dict`)
        * `mysql` (`str`)
        * `prometheus` (`str`)

      * `recoveryTargetTime` (`str`)
      * `serviceToForkFrom` (`str`)
    """
    pg: pulumi.Output[dict]
    """
    PostgreSQL specific server provided values

      * `dbname` (`str`)
      * `host` (`str`)
      * `password` (`str`)
      * `port` (`float`)
      * `replicaUri` (`str`)
      * `sslmode` (`str`)
      * `uri` (`str`)
      * `user` (`str`)
    """
    pg_user_config: pulumi.Output[dict]
    """
    PostgreSQL specific user configurable settings

      * `adminPassword` (`str`)
      * `adminUsername` (`str`)
      * `backupHour` (`str`)
      * `backupMinute` (`str`)
      * `ipFilters` (`list`)
      * `pg` (`dict`)
        * `autovacuumAnalyzeScaleFactor` (`str`)
        * `autovacuumAnalyzeThreshold` (`str`)
        * `autovacuumFreezeMaxAge` (`str`)
        * `autovacuumMaxWorkers` (`str`)
        * `autovacuumNaptime` (`str`)
        * `autovacuumVacuumCostDelay` (`str`)
        * `autovacuumVacuumCostLimit` (`str`)
        * `autovacuumVacuumScaleFactor` (`str`)
        * `autovacuumVacuumThreshold` (`str`)
        * `deadlockTimeout` (`str`)
        * `idleInTransactionSessionTimeout` (`str`)
        * `jit` (`str`)
        * `logAutovacuumMinDuration` (`str`)
        * `logErrorVerbosity` (`str`)
        * `logMinDurationStatement` (`str`)
        * `maxLocksPerTransaction` (`str`)
        * `maxParallelWorkers` (`str`)
        * `maxParallelWorkersPerGather` (`str`)
        * `maxPredLocksPerTransaction` (`str`)
        * `maxPreparedTransactions` (`str`)
        * `maxStackDepth` (`str`)
        * `maxStandbyArchiveDelay` (`str`)
        * `maxStandbyStreamingDelay` (`str`)
        * `maxWorkerProcesses` (`str`)
        * `pgStatStatementsTrack` (`str`)
        * `tempFileLimit` (`str`)
        * `timezone` (`str`)
        * `trackActivityQuerySize` (`str`)
        * `trackCommitTimestamp` (`str`)
        * `trackFunctions` (`str`)
        * `walSenderTimeout` (`str`)
        * `walWriterDelay` (`str`)

      * `pgReadReplica` (`str`)
      * `pgServiceToForkFrom` (`str`)
      * `pgVersion` (`str`)
      * `pgbouncer` (`dict`)
        * `ignoreStartupParameters` (`list`)
        * `serverResetQueryAlways` (`str`)

      * `pglookout` (`dict`)
        * `maxFailoverReplicationTimeLag` (`str`)

      * `privateAccess` (`dict`)
        * `pg` (`str`)
        * `pgbouncer` (`str`)
        * `prometheus` (`str`)

      * `publicAccess` (`dict`)
        * `pg` (`str`)
        * `pgbouncer` (`str`)
        * `prometheus` (`str`)

      * `recoveryTargetTime` (`str`)
      * `serviceToForkFrom` (`str`)
      * `synchronousReplication` (`str`)
      * `timescaledb` (`dict`)
        * `maxBackgroundWorkers` (`str`)

      * `variant` (`str`)
    """
    plan: pulumi.Output[str]
    """
    Subscription plan
    """
    project: pulumi.Output[str]
    """
    Target project
    """
    project_vpc_id: pulumi.Output[str]
    """
    Identifier of the VPC the service should be in, if any
    """
    redis: pulumi.Output[dict]
    """
    Redis specific server provided values
    """
    redis_user_config: pulumi.Output[dict]
    """
    Redis specific user configurable settings

      * `ipFilters` (`list`)
      * `migration` (`dict`)
        * `host` (`str`)
        * `password` (`str`)
        * `port` (`str`)
        * `ssl` (`str`)
        * `username` (`str`)

      * `privateAccess` (`dict`)
        * `prometheus` (`str`)
        * `redis` (`str`)

      * `publicAccess` (`dict`)
        * `prometheus` (`str`)
        * `redis` (`str`)

      * `redisLfuDecayTime` (`str`)
      * `redisLfuLogFactor` (`str`)
      * `redisMaxmemoryPolicy` (`str`)
      * `redisNotifyKeyspaceEvents` (`str`)
      * `redisSsl` (`str`)
      * `redisTimeout` (`str`)
    """
    service_host: pulumi.Output[str]
    """
    Service hostname
    """
    service_integrations: pulumi.Output[list]
    """
    Service integrations to specify when creating a service. Not applied after initial service creation

      * `integration_type` (`str`)
      * `source_service_name` (`str`)
    """
    service_name: pulumi.Output[str]
    """
    Service name
    """
    service_password: pulumi.Output[str]
    """
    Password used for connecting to the service, if applicable
    """
    service_port: pulumi.Output[float]
    """
    Service port
    """
    service_type: pulumi.Output[str]
    """
    Service type code
    """
    service_uri: pulumi.Output[str]
    """
    URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
    """
    service_username: pulumi.Output[str]
    """
    Username used for connecting to the service, if applicable
    """
    state: pulumi.Output[str]
    """
    Service state
    """
    termination_protection: pulumi.Output[bool]
    """
    Prevent service from being deleted. It is recommended to have this enabled for all services.
    """
    def __init__(__self__, resource_name, opts=None, cassandra=None, cassandra_user_config=None, client_timeout=None, cloud_name=None, elasticsearch=None, elasticsearch_user_config=None, grafana=None, grafana_user_config=None, influxdb=None, influxdb_user_config=None, kafka=None, kafka_connect=None, kafka_connect_user_config=None, kafka_mirrormaker=None, kafka_mirrormaker_user_config=None, kafka_user_config=None, maintenance_window_dow=None, maintenance_window_time=None, mysql=None, mysql_user_config=None, pg=None, pg_user_config=None, plan=None, project=None, project_vpc_id=None, redis=None, redis_user_config=None, service_integrations=None, service_name=None, service_type=None, termination_protection=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        myservice = aiven.Service("myservice",
            cloud_name="google-europe-west1",
            pg_user_config={
                "ipFilter": ["0.0.0.0/0"],
                "pgVersion": "10",
            },
            plan="business-8",
            project=aiven_project["myproject"]["project"],
            project_vpc_id=aiven_project_vpc["vpc_gcp_europe_west1"]["id"],
            service_name="<SERVICE_NAME>",
            service_type="pg",
            termination_protection=True)
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] cassandra: Cassandra specific server provided values
        :param pulumi.Input[dict] cassandra_user_config: Cassandra specific user configurable settings
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[dict] elasticsearch: Elasticsearch specific server provided values
        :param pulumi.Input[dict] elasticsearch_user_config: Elasticsearch specific user configurable settings
        :param pulumi.Input[dict] grafana: Grafana specific server provided values
        :param pulumi.Input[dict] grafana_user_config: Grafana specific user configurable settings
        :param pulumi.Input[dict] influxdb: InfluxDB specific server provided values
        :param pulumi.Input[dict] influxdb_user_config: InfluxDB specific user configurable settings
        :param pulumi.Input[dict] kafka: Kafka specific server provided values
        :param pulumi.Input[dict] kafka_connect: Kafka Connect specific server provided values
        :param pulumi.Input[dict] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[dict] kafka_mirrormaker: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input[dict] kafka_mirrormaker_user_config: Kafka MirrorMaker 2 specific user configurable settings
        :param pulumi.Input[dict] kafka_user_config: Kafka specific user configurable settings
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[dict] mysql: MySQL specific server provided values
        :param pulumi.Input[dict] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input[dict] pg: PostgreSQL specific server provided values
        :param pulumi.Input[dict] pg_user_config: PostgreSQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[dict] redis: Redis specific server provided values
        :param pulumi.Input[dict] redis_user_config: Redis specific user configurable settings
        :param pulumi.Input[list] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.

        The **cassandra_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `migrateSstableloader` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
          * `update` (`pulumi.Input[str]`)

        The **elasticsearch** object supports the following:

          * `kibanaUri` (`pulumi.Input[str]`)

        The **elasticsearch_user_config** object supports the following:

          * `customDomain` (`pulumi.Input[str]`)
          * `disableReplicationFactorAdjustment` (`pulumi.Input[str]`)
          * `elasticsearch` (`pulumi.Input[dict]`)
            * `actionAutoCreateIndexEnabled` (`pulumi.Input[str]`)
            * `actionDestructiveRequiresName` (`pulumi.Input[str]`)
            * `httpMaxContentLength` (`pulumi.Input[str]`)
            * `httpMaxHeaderSize` (`pulumi.Input[str]`)
            * `httpMaxInitialLineLength` (`pulumi.Input[str]`)
            * `indicesFielddataCacheSize` (`pulumi.Input[str]`)
            * `indicesMemoryIndexBufferSize` (`pulumi.Input[str]`)
            * `indicesQueriesCacheSize` (`pulumi.Input[str]`)
            * `indicesQueryBoolMaxClauseCount` (`pulumi.Input[str]`)
            * `reindexRemoteWhitelists` (`pulumi.Input[list]`)
            * `threadPoolAnalyzeQueueSize` (`pulumi.Input[str]`)
            * `threadPoolAnalyzeSize` (`pulumi.Input[str]`)
            * `threadPoolForceMergeSize` (`pulumi.Input[str]`)
            * `threadPoolGetQueueSize` (`pulumi.Input[str]`)
            * `threadPoolGetSize` (`pulumi.Input[str]`)
            * `threadPoolIndexQueueSize` (`pulumi.Input[str]`)
            * `threadPoolIndexSize` (`pulumi.Input[str]`)
            * `threadPoolSearchQueueSize` (`pulumi.Input[str]`)
            * `threadPoolSearchSize` (`pulumi.Input[str]`)
            * `threadPoolSearchThrottledQueueSize` (`pulumi.Input[str]`)
            * `threadPoolSearchThrottledSize` (`pulumi.Input[str]`)
            * `threadPoolWriteQueueSize` (`pulumi.Input[str]`)
            * `threadPoolWriteSize` (`pulumi.Input[str]`)

          * `elasticsearchVersion` (`pulumi.Input[str]`)
          * `indexPatterns` (`pulumi.Input[list]`)
            * `maxIndexCount` (`pulumi.Input[str]`)
            * `pattern` (`pulumi.Input[str]`)

          * `ipFilters` (`pulumi.Input[list]`)
          * `kibana` (`pulumi.Input[dict]`)
            * `elasticsearchRequestTimeout` (`pulumi.Input[str]`)
            * `enabled` (`pulumi.Input[str]`)
            * `maxOldSpaceSize` (`pulumi.Input[str]`)

          * `maxIndexCount` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `elasticsearch` (`pulumi.Input[str]`)
            * `kibana` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `elasticsearch` (`pulumi.Input[str]`)
            * `kibana` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `recoveryBasebackupName` (`pulumi.Input[str]`)
          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **grafana_user_config** object supports the following:

          * `alertingEnabled` (`pulumi.Input[str]`)
          * `alertingErrorOrTimeout` (`pulumi.Input[str]`)
          * `alertingNodataOrNullvalues` (`pulumi.Input[str]`)
          * `allowEmbedding` (`pulumi.Input[str]`)
          * `authBasicEnabled` (`pulumi.Input[str]`)
          * `authGenericOauth` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedDomains` (`pulumi.Input[list]`)
            * `allowedOrganizations` (`pulumi.Input[list]`)
            * `apiUrl` (`pulumi.Input[str]`)
            * `authUrl` (`pulumi.Input[str]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)
            * `name` (`pulumi.Input[str]`)
            * `scopes` (`pulumi.Input[list]`)
            * `tokenUrl` (`pulumi.Input[str]`)

          * `authGithub` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedOrganizations` (`pulumi.Input[list]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)
            * `teamIds` (`pulumi.Input[list]`)

          * `authGitlab` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedGroups` (`pulumi.Input[list]`)
            * `apiUrl` (`pulumi.Input[str]`)
            * `authUrl` (`pulumi.Input[str]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)
            * `tokenUrl` (`pulumi.Input[str]`)

          * `authGoogle` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedDomains` (`pulumi.Input[list]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)

          * `cookieSamesite` (`pulumi.Input[str]`)
          * `customDomain` (`pulumi.Input[str]`)
          * `dashboardsVersionsToKeep` (`pulumi.Input[str]`)
          * `dataproxySendUserHeader` (`pulumi.Input[str]`)
          * `dataproxyTimeout` (`pulumi.Input[str]`)
          * `disableGravatar` (`pulumi.Input[str]`)
          * `editorsCanAdmin` (`pulumi.Input[str]`)
          * `externalImageStorage` (`pulumi.Input[dict]`)
            * `access_key` (`pulumi.Input[str]`)
            * `bucketUrl` (`pulumi.Input[str]`)
            * `provider` (`pulumi.Input[str]`)
            * `secretKey` (`pulumi.Input[str]`)

          * `googleAnalyticsUaId` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `metricsEnabled` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `grafana` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `grafana` (`pulumi.Input[str]`)

          * `smtpServer` (`pulumi.Input[dict]`)
            * `fromAddress` (`pulumi.Input[str]`)
            * `fromName` (`pulumi.Input[str]`)
            * `host` (`pulumi.Input[str]`)
            * `password` (`pulumi.Input[str]`)
            * `port` (`pulumi.Input[str]`)
            * `skipVerify` (`pulumi.Input[str]`)
            * `username` (`pulumi.Input[str]`)

          * `userAutoAssignOrg` (`pulumi.Input[str]`)
          * `userAutoAssignOrgRole` (`pulumi.Input[str]`)
          * `viewersCanEdit` (`pulumi.Input[str]`)

        The **influxdb** object supports the following:

          * `database_name` (`pulumi.Input[str]`)

        The **influxdb_user_config** object supports the following:

          * `customDomain` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `influxdb` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `influxdb` (`pulumi.Input[str]`)

          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **kafka** object supports the following:

          * `access_cert` (`pulumi.Input[str]`)
          * `access_key` (`pulumi.Input[str]`)
          * `connectUri` (`pulumi.Input[str]`)
          * `restUri` (`pulumi.Input[str]`)
          * `schemaRegistryUri` (`pulumi.Input[str]`)

        The **kafka_connect_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `kafka_connect` (`pulumi.Input[dict]`)
            * `consumerIsolationLevel` (`pulumi.Input[str]`)
            * `consumerMaxPollRecords` (`pulumi.Input[str]`)
            * `offsetFlushIntervalMs` (`pulumi.Input[str]`)

          * `privateAccess` (`pulumi.Input[dict]`)
            * `kafka_connect` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `kafka_connect` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

        The **kafka_mirrormaker_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `kafka_mirrormaker` (`pulumi.Input[dict]`)
            * `refreshGroupsEnabled` (`pulumi.Input[str]`)
            * `refreshGroupsIntervalSeconds` (`pulumi.Input[str]`)
            * `refreshTopicsEnabled` (`pulumi.Input[str]`)
            * `refreshTopicsIntervalSeconds` (`pulumi.Input[str]`)

        The **kafka_user_config** object supports the following:

          * `customDomain` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `kafka` (`pulumi.Input[dict]`)
            * `autoCreateTopicsEnable` (`pulumi.Input[str]`)
            * `compressionType` (`pulumi.Input[str]`)
            * `connectionsMaxIdleMs` (`pulumi.Input[str]`)
            * `defaultReplicationFactor` (`pulumi.Input[str]`)
            * `groupMaxSessionTimeoutMs` (`pulumi.Input[str]`)
            * `groupMinSessionTimeoutMs` (`pulumi.Input[str]`)
            * `logCleanerMaxCompactionLagMs` (`pulumi.Input[str]`)
            * `logCleanerMinCleanableRatio` (`pulumi.Input[str]`)
            * `logCleanerMinCompactionLagMs` (`pulumi.Input[str]`)
            * `logCleanupPolicy` (`pulumi.Input[str]`)
            * `logMessageTimestampDifferenceMaxMs` (`pulumi.Input[str]`)
            * `logMessageTimestampType` (`pulumi.Input[str]`)
            * `logRetentionBytes` (`pulumi.Input[str]`)
            * `logRetentionHours` (`pulumi.Input[str]`)
            * `logSegmentBytes` (`pulumi.Input[str]`)
            * `maxConnectionsPerIp` (`pulumi.Input[str]`)
            * `messageMaxBytes` (`pulumi.Input[str]`)
            * `numPartitions` (`pulumi.Input[str]`)
            * `offsetsRetentionMinutes` (`pulumi.Input[str]`)
            * `producerPurgatoryPurgeIntervalRequests` (`pulumi.Input[str]`)
            * `replicaFetchMaxBytes` (`pulumi.Input[str]`)
            * `replicaFetchResponseMaxBytes` (`pulumi.Input[str]`)
            * `socketRequestMaxBytes` (`pulumi.Input[str]`)

          * `kafkaAuthenticationMethods` (`pulumi.Input[dict]`)
            * `certificate` (`pulumi.Input[str]`)
            * `sasl` (`pulumi.Input[str]`)

          * `kafka_connect` (`pulumi.Input[str]`)
          * `kafkaConnectConfig` (`pulumi.Input[dict]`)
            * `consumerIsolationLevel` (`pulumi.Input[str]`)
            * `consumerMaxPollRecords` (`pulumi.Input[str]`)
            * `offsetFlushIntervalMs` (`pulumi.Input[str]`)

          * `kafkaRest` (`pulumi.Input[str]`)
          * `kafkaRestConfig` (`pulumi.Input[dict]`)
            * `consumerEnableAutoCommit` (`pulumi.Input[str]`)
            * `consumerRequestMaxBytes` (`pulumi.Input[str]`)
            * `consumerRequestTimeoutMs` (`pulumi.Input[str]`)
            * `producerAcks` (`pulumi.Input[str]`)
            * `producerLingerMs` (`pulumi.Input[str]`)
            * `simpleconsumerPoolSizeMax` (`pulumi.Input[str]`)

          * `kafkaVersion` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `kafka` (`pulumi.Input[str]`)
            * `kafka_connect` (`pulumi.Input[str]`)
            * `kafkaRest` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)
            * `schemaRegistry` (`pulumi.Input[str]`)

          * `schemaRegistry` (`pulumi.Input[str]`)

        The **mysql_user_config** object supports the following:

          * `adminPassword` (`pulumi.Input[str]`)
          * `adminUsername` (`pulumi.Input[str]`)
          * `backupHour` (`pulumi.Input[str]`)
          * `backupMinute` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `mysql` (`pulumi.Input[dict]`)
            * `connectTimeout` (`pulumi.Input[str]`)
            * `defaultTimeZone` (`pulumi.Input[str]`)
            * `groupConcatMaxLen` (`pulumi.Input[str]`)
            * `informationSchemaStatsExpiry` (`pulumi.Input[str]`)
            * `innodbFtMinTokenSize` (`pulumi.Input[str]`)
            * `innodbFtServerStopwordTable` (`pulumi.Input[str]`)
            * `innodbLockWaitTimeout` (`pulumi.Input[str]`)
            * `innodbLogBufferSize` (`pulumi.Input[str]`)
            * `innodbOnlineAlterLogMaxSize` (`pulumi.Input[str]`)
            * `innodbRollbackOnTimeout` (`pulumi.Input[str]`)
            * `interactiveTimeout` (`pulumi.Input[str]`)
            * `maxAllowedPacket` (`pulumi.Input[str]`)
            * `maxHeapTableSize` (`pulumi.Input[str]`)
            * `netReadTimeout` (`pulumi.Input[str]`)
            * `netWriteTimeout` (`pulumi.Input[str]`)
            * `sortBufferSize` (`pulumi.Input[str]`)
            * `sqlMode` (`pulumi.Input[str]`)
            * `sqlRequirePrimaryKey` (`pulumi.Input[str]`)
            * `tmpTableSize` (`pulumi.Input[str]`)
            * `waitTimeout` (`pulumi.Input[str]`)

          * `mysqlVersion` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `mysql` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `mysql` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `recoveryTargetTime` (`pulumi.Input[str]`)
          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **pg** object supports the following:

          * `dbname` (`pulumi.Input[str]`)
          * `host` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `replicaUri` (`pulumi.Input[str]`)
          * `sslmode` (`pulumi.Input[str]`)
          * `uri` (`pulumi.Input[str]`)
          * `user` (`pulumi.Input[str]`)

        The **pg_user_config** object supports the following:

          * `adminPassword` (`pulumi.Input[str]`)
          * `adminUsername` (`pulumi.Input[str]`)
          * `backupHour` (`pulumi.Input[str]`)
          * `backupMinute` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `pg` (`pulumi.Input[dict]`)
            * `autovacuumAnalyzeScaleFactor` (`pulumi.Input[str]`)
            * `autovacuumAnalyzeThreshold` (`pulumi.Input[str]`)
            * `autovacuumFreezeMaxAge` (`pulumi.Input[str]`)
            * `autovacuumMaxWorkers` (`pulumi.Input[str]`)
            * `autovacuumNaptime` (`pulumi.Input[str]`)
            * `autovacuumVacuumCostDelay` (`pulumi.Input[str]`)
            * `autovacuumVacuumCostLimit` (`pulumi.Input[str]`)
            * `autovacuumVacuumScaleFactor` (`pulumi.Input[str]`)
            * `autovacuumVacuumThreshold` (`pulumi.Input[str]`)
            * `deadlockTimeout` (`pulumi.Input[str]`)
            * `idleInTransactionSessionTimeout` (`pulumi.Input[str]`)
            * `jit` (`pulumi.Input[str]`)
            * `logAutovacuumMinDuration` (`pulumi.Input[str]`)
            * `logErrorVerbosity` (`pulumi.Input[str]`)
            * `logMinDurationStatement` (`pulumi.Input[str]`)
            * `maxLocksPerTransaction` (`pulumi.Input[str]`)
            * `maxParallelWorkers` (`pulumi.Input[str]`)
            * `maxParallelWorkersPerGather` (`pulumi.Input[str]`)
            * `maxPredLocksPerTransaction` (`pulumi.Input[str]`)
            * `maxPreparedTransactions` (`pulumi.Input[str]`)
            * `maxStackDepth` (`pulumi.Input[str]`)
            * `maxStandbyArchiveDelay` (`pulumi.Input[str]`)
            * `maxStandbyStreamingDelay` (`pulumi.Input[str]`)
            * `maxWorkerProcesses` (`pulumi.Input[str]`)
            * `pgStatStatementsTrack` (`pulumi.Input[str]`)
            * `tempFileLimit` (`pulumi.Input[str]`)
            * `timezone` (`pulumi.Input[str]`)
            * `trackActivityQuerySize` (`pulumi.Input[str]`)
            * `trackCommitTimestamp` (`pulumi.Input[str]`)
            * `trackFunctions` (`pulumi.Input[str]`)
            * `walSenderTimeout` (`pulumi.Input[str]`)
            * `walWriterDelay` (`pulumi.Input[str]`)

          * `pgReadReplica` (`pulumi.Input[str]`)
          * `pgServiceToForkFrom` (`pulumi.Input[str]`)
          * `pgVersion` (`pulumi.Input[str]`)
          * `pgbouncer` (`pulumi.Input[dict]`)
            * `ignoreStartupParameters` (`pulumi.Input[list]`)
            * `serverResetQueryAlways` (`pulumi.Input[str]`)

          * `pglookout` (`pulumi.Input[dict]`)
            * `maxFailoverReplicationTimeLag` (`pulumi.Input[str]`)

          * `privateAccess` (`pulumi.Input[dict]`)
            * `pg` (`pulumi.Input[str]`)
            * `pgbouncer` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `pg` (`pulumi.Input[str]`)
            * `pgbouncer` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `recoveryTargetTime` (`pulumi.Input[str]`)
          * `serviceToForkFrom` (`pulumi.Input[str]`)
          * `synchronousReplication` (`pulumi.Input[str]`)
          * `timescaledb` (`pulumi.Input[dict]`)
            * `maxBackgroundWorkers` (`pulumi.Input[str]`)

          * `variant` (`pulumi.Input[str]`)

        The **redis_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `migration` (`pulumi.Input[dict]`)
            * `host` (`pulumi.Input[str]`)
            * `password` (`pulumi.Input[str]`)
            * `port` (`pulumi.Input[str]`)
            * `ssl` (`pulumi.Input[str]`)
            * `username` (`pulumi.Input[str]`)

          * `privateAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)
            * `redis` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)
            * `redis` (`pulumi.Input[str]`)

          * `redisLfuDecayTime` (`pulumi.Input[str]`)
          * `redisLfuLogFactor` (`pulumi.Input[str]`)
          * `redisMaxmemoryPolicy` (`pulumi.Input[str]`)
          * `redisNotifyKeyspaceEvents` (`pulumi.Input[str]`)
          * `redisSsl` (`pulumi.Input[str]`)
          * `redisTimeout` (`pulumi.Input[str]`)

        The **service_integrations** object supports the following:

          * `integration_type` (`pulumi.Input[str]`)
          * `source_service_name` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['cassandra'] = cassandra
            __props__['cassandra_user_config'] = cassandra_user_config
            if client_timeout is not None:
                warnings.warn("use timeouts instead", DeprecationWarning)
                pulumi.log.warn("client_timeout is deprecated: use timeouts instead")
            __props__['client_timeout'] = client_timeout
            __props__['cloud_name'] = cloud_name
            __props__['elasticsearch'] = elasticsearch
            __props__['elasticsearch_user_config'] = elasticsearch_user_config
            __props__['grafana'] = grafana
            __props__['grafana_user_config'] = grafana_user_config
            __props__['influxdb'] = influxdb
            __props__['influxdb_user_config'] = influxdb_user_config
            __props__['kafka'] = kafka
            __props__['kafka_connect'] = kafka_connect
            __props__['kafka_connect_user_config'] = kafka_connect_user_config
            __props__['kafka_mirrormaker'] = kafka_mirrormaker
            __props__['kafka_mirrormaker_user_config'] = kafka_mirrormaker_user_config
            __props__['kafka_user_config'] = kafka_user_config
            __props__['maintenance_window_dow'] = maintenance_window_dow
            __props__['maintenance_window_time'] = maintenance_window_time
            __props__['mysql'] = mysql
            __props__['mysql_user_config'] = mysql_user_config
            __props__['pg'] = pg
            __props__['pg_user_config'] = pg_user_config
            __props__['plan'] = plan
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['project_vpc_id'] = project_vpc_id
            __props__['redis'] = redis
            __props__['redis_user_config'] = redis_user_config
            __props__['service_integrations'] = service_integrations
            if service_name is None:
                raise TypeError("Missing required property 'service_name'")
            __props__['service_name'] = service_name
            if service_type is None:
                raise TypeError("Missing required property 'service_type'")
            __props__['service_type'] = service_type
            __props__['termination_protection'] = termination_protection
            __props__['components'] = None
            __props__['service_host'] = None
            __props__['service_password'] = None
            __props__['service_port'] = None
            __props__['service_uri'] = None
            __props__['service_username'] = None
            __props__['state'] = None
        super(Service, __self__).__init__(
            'aiven:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, cassandra=None, cassandra_user_config=None, client_timeout=None, cloud_name=None, components=None, elasticsearch=None, elasticsearch_user_config=None, grafana=None, grafana_user_config=None, influxdb=None, influxdb_user_config=None, kafka=None, kafka_connect=None, kafka_connect_user_config=None, kafka_mirrormaker=None, kafka_mirrormaker_user_config=None, kafka_user_config=None, maintenance_window_dow=None, maintenance_window_time=None, mysql=None, mysql_user_config=None, pg=None, pg_user_config=None, plan=None, project=None, project_vpc_id=None, redis=None, redis_user_config=None, service_host=None, service_integrations=None, service_name=None, service_password=None, service_port=None, service_type=None, service_uri=None, service_username=None, state=None, termination_protection=None):
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] cassandra: Cassandra specific server provided values
        :param pulumi.Input[dict] cassandra_user_config: Cassandra specific user configurable settings
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[list] components: Service component information objects
        :param pulumi.Input[dict] elasticsearch: Elasticsearch specific server provided values
        :param pulumi.Input[dict] elasticsearch_user_config: Elasticsearch specific user configurable settings
        :param pulumi.Input[dict] grafana: Grafana specific server provided values
        :param pulumi.Input[dict] grafana_user_config: Grafana specific user configurable settings
        :param pulumi.Input[dict] influxdb: InfluxDB specific server provided values
        :param pulumi.Input[dict] influxdb_user_config: InfluxDB specific user configurable settings
        :param pulumi.Input[dict] kafka: Kafka specific server provided values
        :param pulumi.Input[dict] kafka_connect: Kafka Connect specific server provided values
        :param pulumi.Input[dict] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[dict] kafka_mirrormaker: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input[dict] kafka_mirrormaker_user_config: Kafka MirrorMaker 2 specific user configurable settings
        :param pulumi.Input[dict] kafka_user_config: Kafka specific user configurable settings
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[dict] mysql: MySQL specific server provided values
        :param pulumi.Input[dict] mysql_user_config: MySQL specific user configurable settings
        :param pulumi.Input[dict] pg: PostgreSQL specific server provided values
        :param pulumi.Input[dict] pg_user_config: PostgreSQL specific user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[dict] redis: Redis specific server provided values
        :param pulumi.Input[dict] redis_user_config: Redis specific user configurable settings
        :param pulumi.Input[str] service_host: Service hostname
        :param pulumi.Input[list] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[float] service_port: Service port
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.

        The **cassandra_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `migrateSstableloader` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
          * `update` (`pulumi.Input[str]`)

        The **components** object supports the following:

          * `component` (`pulumi.Input[str]`)
          * `host` (`pulumi.Input[str]`)
          * `kafkaAuthenticationMethod` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `route` (`pulumi.Input[str]`)
          * `ssl` (`pulumi.Input[bool]`)
          * `usage` (`pulumi.Input[str]`)

        The **elasticsearch** object supports the following:

          * `kibanaUri` (`pulumi.Input[str]`)

        The **elasticsearch_user_config** object supports the following:

          * `customDomain` (`pulumi.Input[str]`)
          * `disableReplicationFactorAdjustment` (`pulumi.Input[str]`)
          * `elasticsearch` (`pulumi.Input[dict]`)
            * `actionAutoCreateIndexEnabled` (`pulumi.Input[str]`)
            * `actionDestructiveRequiresName` (`pulumi.Input[str]`)
            * `httpMaxContentLength` (`pulumi.Input[str]`)
            * `httpMaxHeaderSize` (`pulumi.Input[str]`)
            * `httpMaxInitialLineLength` (`pulumi.Input[str]`)
            * `indicesFielddataCacheSize` (`pulumi.Input[str]`)
            * `indicesMemoryIndexBufferSize` (`pulumi.Input[str]`)
            * `indicesQueriesCacheSize` (`pulumi.Input[str]`)
            * `indicesQueryBoolMaxClauseCount` (`pulumi.Input[str]`)
            * `reindexRemoteWhitelists` (`pulumi.Input[list]`)
            * `threadPoolAnalyzeQueueSize` (`pulumi.Input[str]`)
            * `threadPoolAnalyzeSize` (`pulumi.Input[str]`)
            * `threadPoolForceMergeSize` (`pulumi.Input[str]`)
            * `threadPoolGetQueueSize` (`pulumi.Input[str]`)
            * `threadPoolGetSize` (`pulumi.Input[str]`)
            * `threadPoolIndexQueueSize` (`pulumi.Input[str]`)
            * `threadPoolIndexSize` (`pulumi.Input[str]`)
            * `threadPoolSearchQueueSize` (`pulumi.Input[str]`)
            * `threadPoolSearchSize` (`pulumi.Input[str]`)
            * `threadPoolSearchThrottledQueueSize` (`pulumi.Input[str]`)
            * `threadPoolSearchThrottledSize` (`pulumi.Input[str]`)
            * `threadPoolWriteQueueSize` (`pulumi.Input[str]`)
            * `threadPoolWriteSize` (`pulumi.Input[str]`)

          * `elasticsearchVersion` (`pulumi.Input[str]`)
          * `indexPatterns` (`pulumi.Input[list]`)
            * `maxIndexCount` (`pulumi.Input[str]`)
            * `pattern` (`pulumi.Input[str]`)

          * `ipFilters` (`pulumi.Input[list]`)
          * `kibana` (`pulumi.Input[dict]`)
            * `elasticsearchRequestTimeout` (`pulumi.Input[str]`)
            * `enabled` (`pulumi.Input[str]`)
            * `maxOldSpaceSize` (`pulumi.Input[str]`)

          * `maxIndexCount` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `elasticsearch` (`pulumi.Input[str]`)
            * `kibana` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `elasticsearch` (`pulumi.Input[str]`)
            * `kibana` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `recoveryBasebackupName` (`pulumi.Input[str]`)
          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **grafana_user_config** object supports the following:

          * `alertingEnabled` (`pulumi.Input[str]`)
          * `alertingErrorOrTimeout` (`pulumi.Input[str]`)
          * `alertingNodataOrNullvalues` (`pulumi.Input[str]`)
          * `allowEmbedding` (`pulumi.Input[str]`)
          * `authBasicEnabled` (`pulumi.Input[str]`)
          * `authGenericOauth` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedDomains` (`pulumi.Input[list]`)
            * `allowedOrganizations` (`pulumi.Input[list]`)
            * `apiUrl` (`pulumi.Input[str]`)
            * `authUrl` (`pulumi.Input[str]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)
            * `name` (`pulumi.Input[str]`)
            * `scopes` (`pulumi.Input[list]`)
            * `tokenUrl` (`pulumi.Input[str]`)

          * `authGithub` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedOrganizations` (`pulumi.Input[list]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)
            * `teamIds` (`pulumi.Input[list]`)

          * `authGitlab` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedGroups` (`pulumi.Input[list]`)
            * `apiUrl` (`pulumi.Input[str]`)
            * `authUrl` (`pulumi.Input[str]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)
            * `tokenUrl` (`pulumi.Input[str]`)

          * `authGoogle` (`pulumi.Input[dict]`)
            * `allowSignUp` (`pulumi.Input[str]`)
            * `allowedDomains` (`pulumi.Input[list]`)
            * `clientId` (`pulumi.Input[str]`)
            * `clientSecret` (`pulumi.Input[str]`)

          * `cookieSamesite` (`pulumi.Input[str]`)
          * `customDomain` (`pulumi.Input[str]`)
          * `dashboardsVersionsToKeep` (`pulumi.Input[str]`)
          * `dataproxySendUserHeader` (`pulumi.Input[str]`)
          * `dataproxyTimeout` (`pulumi.Input[str]`)
          * `disableGravatar` (`pulumi.Input[str]`)
          * `editorsCanAdmin` (`pulumi.Input[str]`)
          * `externalImageStorage` (`pulumi.Input[dict]`)
            * `access_key` (`pulumi.Input[str]`)
            * `bucketUrl` (`pulumi.Input[str]`)
            * `provider` (`pulumi.Input[str]`)
            * `secretKey` (`pulumi.Input[str]`)

          * `googleAnalyticsUaId` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `metricsEnabled` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `grafana` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `grafana` (`pulumi.Input[str]`)

          * `smtpServer` (`pulumi.Input[dict]`)
            * `fromAddress` (`pulumi.Input[str]`)
            * `fromName` (`pulumi.Input[str]`)
            * `host` (`pulumi.Input[str]`)
            * `password` (`pulumi.Input[str]`)
            * `port` (`pulumi.Input[str]`)
            * `skipVerify` (`pulumi.Input[str]`)
            * `username` (`pulumi.Input[str]`)

          * `userAutoAssignOrg` (`pulumi.Input[str]`)
          * `userAutoAssignOrgRole` (`pulumi.Input[str]`)
          * `viewersCanEdit` (`pulumi.Input[str]`)

        The **influxdb** object supports the following:

          * `database_name` (`pulumi.Input[str]`)

        The **influxdb_user_config** object supports the following:

          * `customDomain` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `influxdb` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `influxdb` (`pulumi.Input[str]`)

          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **kafka** object supports the following:

          * `access_cert` (`pulumi.Input[str]`)
          * `access_key` (`pulumi.Input[str]`)
          * `connectUri` (`pulumi.Input[str]`)
          * `restUri` (`pulumi.Input[str]`)
          * `schemaRegistryUri` (`pulumi.Input[str]`)

        The **kafka_connect_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `kafka_connect` (`pulumi.Input[dict]`)
            * `consumerIsolationLevel` (`pulumi.Input[str]`)
            * `consumerMaxPollRecords` (`pulumi.Input[str]`)
            * `offsetFlushIntervalMs` (`pulumi.Input[str]`)

          * `privateAccess` (`pulumi.Input[dict]`)
            * `kafka_connect` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `kafka_connect` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

        The **kafka_mirrormaker_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `kafka_mirrormaker` (`pulumi.Input[dict]`)
            * `refreshGroupsEnabled` (`pulumi.Input[str]`)
            * `refreshGroupsIntervalSeconds` (`pulumi.Input[str]`)
            * `refreshTopicsEnabled` (`pulumi.Input[str]`)
            * `refreshTopicsIntervalSeconds` (`pulumi.Input[str]`)

        The **kafka_user_config** object supports the following:

          * `customDomain` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `kafka` (`pulumi.Input[dict]`)
            * `autoCreateTopicsEnable` (`pulumi.Input[str]`)
            * `compressionType` (`pulumi.Input[str]`)
            * `connectionsMaxIdleMs` (`pulumi.Input[str]`)
            * `defaultReplicationFactor` (`pulumi.Input[str]`)
            * `groupMaxSessionTimeoutMs` (`pulumi.Input[str]`)
            * `groupMinSessionTimeoutMs` (`pulumi.Input[str]`)
            * `logCleanerMaxCompactionLagMs` (`pulumi.Input[str]`)
            * `logCleanerMinCleanableRatio` (`pulumi.Input[str]`)
            * `logCleanerMinCompactionLagMs` (`pulumi.Input[str]`)
            * `logCleanupPolicy` (`pulumi.Input[str]`)
            * `logMessageTimestampDifferenceMaxMs` (`pulumi.Input[str]`)
            * `logMessageTimestampType` (`pulumi.Input[str]`)
            * `logRetentionBytes` (`pulumi.Input[str]`)
            * `logRetentionHours` (`pulumi.Input[str]`)
            * `logSegmentBytes` (`pulumi.Input[str]`)
            * `maxConnectionsPerIp` (`pulumi.Input[str]`)
            * `messageMaxBytes` (`pulumi.Input[str]`)
            * `numPartitions` (`pulumi.Input[str]`)
            * `offsetsRetentionMinutes` (`pulumi.Input[str]`)
            * `producerPurgatoryPurgeIntervalRequests` (`pulumi.Input[str]`)
            * `replicaFetchMaxBytes` (`pulumi.Input[str]`)
            * `replicaFetchResponseMaxBytes` (`pulumi.Input[str]`)
            * `socketRequestMaxBytes` (`pulumi.Input[str]`)

          * `kafkaAuthenticationMethods` (`pulumi.Input[dict]`)
            * `certificate` (`pulumi.Input[str]`)
            * `sasl` (`pulumi.Input[str]`)

          * `kafka_connect` (`pulumi.Input[str]`)
          * `kafkaConnectConfig` (`pulumi.Input[dict]`)
            * `consumerIsolationLevel` (`pulumi.Input[str]`)
            * `consumerMaxPollRecords` (`pulumi.Input[str]`)
            * `offsetFlushIntervalMs` (`pulumi.Input[str]`)

          * `kafkaRest` (`pulumi.Input[str]`)
          * `kafkaRestConfig` (`pulumi.Input[dict]`)
            * `consumerEnableAutoCommit` (`pulumi.Input[str]`)
            * `consumerRequestMaxBytes` (`pulumi.Input[str]`)
            * `consumerRequestTimeoutMs` (`pulumi.Input[str]`)
            * `producerAcks` (`pulumi.Input[str]`)
            * `producerLingerMs` (`pulumi.Input[str]`)
            * `simpleconsumerPoolSizeMax` (`pulumi.Input[str]`)

          * `kafkaVersion` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `kafka` (`pulumi.Input[str]`)
            * `kafka_connect` (`pulumi.Input[str]`)
            * `kafkaRest` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)
            * `schemaRegistry` (`pulumi.Input[str]`)

          * `schemaRegistry` (`pulumi.Input[str]`)

        The **mysql_user_config** object supports the following:

          * `adminPassword` (`pulumi.Input[str]`)
          * `adminUsername` (`pulumi.Input[str]`)
          * `backupHour` (`pulumi.Input[str]`)
          * `backupMinute` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `mysql` (`pulumi.Input[dict]`)
            * `connectTimeout` (`pulumi.Input[str]`)
            * `defaultTimeZone` (`pulumi.Input[str]`)
            * `groupConcatMaxLen` (`pulumi.Input[str]`)
            * `informationSchemaStatsExpiry` (`pulumi.Input[str]`)
            * `innodbFtMinTokenSize` (`pulumi.Input[str]`)
            * `innodbFtServerStopwordTable` (`pulumi.Input[str]`)
            * `innodbLockWaitTimeout` (`pulumi.Input[str]`)
            * `innodbLogBufferSize` (`pulumi.Input[str]`)
            * `innodbOnlineAlterLogMaxSize` (`pulumi.Input[str]`)
            * `innodbRollbackOnTimeout` (`pulumi.Input[str]`)
            * `interactiveTimeout` (`pulumi.Input[str]`)
            * `maxAllowedPacket` (`pulumi.Input[str]`)
            * `maxHeapTableSize` (`pulumi.Input[str]`)
            * `netReadTimeout` (`pulumi.Input[str]`)
            * `netWriteTimeout` (`pulumi.Input[str]`)
            * `sortBufferSize` (`pulumi.Input[str]`)
            * `sqlMode` (`pulumi.Input[str]`)
            * `sqlRequirePrimaryKey` (`pulumi.Input[str]`)
            * `tmpTableSize` (`pulumi.Input[str]`)
            * `waitTimeout` (`pulumi.Input[str]`)

          * `mysqlVersion` (`pulumi.Input[str]`)
          * `privateAccess` (`pulumi.Input[dict]`)
            * `mysql` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `mysql` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `recoveryTargetTime` (`pulumi.Input[str]`)
          * `serviceToForkFrom` (`pulumi.Input[str]`)

        The **pg** object supports the following:

          * `dbname` (`pulumi.Input[str]`)
          * `host` (`pulumi.Input[str]`)
          * `password` (`pulumi.Input[str]`)
          * `port` (`pulumi.Input[float]`)
          * `replicaUri` (`pulumi.Input[str]`)
          * `sslmode` (`pulumi.Input[str]`)
          * `uri` (`pulumi.Input[str]`)
          * `user` (`pulumi.Input[str]`)

        The **pg_user_config** object supports the following:

          * `adminPassword` (`pulumi.Input[str]`)
          * `adminUsername` (`pulumi.Input[str]`)
          * `backupHour` (`pulumi.Input[str]`)
          * `backupMinute` (`pulumi.Input[str]`)
          * `ipFilters` (`pulumi.Input[list]`)
          * `pg` (`pulumi.Input[dict]`)
            * `autovacuumAnalyzeScaleFactor` (`pulumi.Input[str]`)
            * `autovacuumAnalyzeThreshold` (`pulumi.Input[str]`)
            * `autovacuumFreezeMaxAge` (`pulumi.Input[str]`)
            * `autovacuumMaxWorkers` (`pulumi.Input[str]`)
            * `autovacuumNaptime` (`pulumi.Input[str]`)
            * `autovacuumVacuumCostDelay` (`pulumi.Input[str]`)
            * `autovacuumVacuumCostLimit` (`pulumi.Input[str]`)
            * `autovacuumVacuumScaleFactor` (`pulumi.Input[str]`)
            * `autovacuumVacuumThreshold` (`pulumi.Input[str]`)
            * `deadlockTimeout` (`pulumi.Input[str]`)
            * `idleInTransactionSessionTimeout` (`pulumi.Input[str]`)
            * `jit` (`pulumi.Input[str]`)
            * `logAutovacuumMinDuration` (`pulumi.Input[str]`)
            * `logErrorVerbosity` (`pulumi.Input[str]`)
            * `logMinDurationStatement` (`pulumi.Input[str]`)
            * `maxLocksPerTransaction` (`pulumi.Input[str]`)
            * `maxParallelWorkers` (`pulumi.Input[str]`)
            * `maxParallelWorkersPerGather` (`pulumi.Input[str]`)
            * `maxPredLocksPerTransaction` (`pulumi.Input[str]`)
            * `maxPreparedTransactions` (`pulumi.Input[str]`)
            * `maxStackDepth` (`pulumi.Input[str]`)
            * `maxStandbyArchiveDelay` (`pulumi.Input[str]`)
            * `maxStandbyStreamingDelay` (`pulumi.Input[str]`)
            * `maxWorkerProcesses` (`pulumi.Input[str]`)
            * `pgStatStatementsTrack` (`pulumi.Input[str]`)
            * `tempFileLimit` (`pulumi.Input[str]`)
            * `timezone` (`pulumi.Input[str]`)
            * `trackActivityQuerySize` (`pulumi.Input[str]`)
            * `trackCommitTimestamp` (`pulumi.Input[str]`)
            * `trackFunctions` (`pulumi.Input[str]`)
            * `walSenderTimeout` (`pulumi.Input[str]`)
            * `walWriterDelay` (`pulumi.Input[str]`)

          * `pgReadReplica` (`pulumi.Input[str]`)
          * `pgServiceToForkFrom` (`pulumi.Input[str]`)
          * `pgVersion` (`pulumi.Input[str]`)
          * `pgbouncer` (`pulumi.Input[dict]`)
            * `ignoreStartupParameters` (`pulumi.Input[list]`)
            * `serverResetQueryAlways` (`pulumi.Input[str]`)

          * `pglookout` (`pulumi.Input[dict]`)
            * `maxFailoverReplicationTimeLag` (`pulumi.Input[str]`)

          * `privateAccess` (`pulumi.Input[dict]`)
            * `pg` (`pulumi.Input[str]`)
            * `pgbouncer` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `pg` (`pulumi.Input[str]`)
            * `pgbouncer` (`pulumi.Input[str]`)
            * `prometheus` (`pulumi.Input[str]`)

          * `recoveryTargetTime` (`pulumi.Input[str]`)
          * `serviceToForkFrom` (`pulumi.Input[str]`)
          * `synchronousReplication` (`pulumi.Input[str]`)
          * `timescaledb` (`pulumi.Input[dict]`)
            * `maxBackgroundWorkers` (`pulumi.Input[str]`)

          * `variant` (`pulumi.Input[str]`)

        The **redis_user_config** object supports the following:

          * `ipFilters` (`pulumi.Input[list]`)
          * `migration` (`pulumi.Input[dict]`)
            * `host` (`pulumi.Input[str]`)
            * `password` (`pulumi.Input[str]`)
            * `port` (`pulumi.Input[str]`)
            * `ssl` (`pulumi.Input[str]`)
            * `username` (`pulumi.Input[str]`)

          * `privateAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)
            * `redis` (`pulumi.Input[str]`)

          * `publicAccess` (`pulumi.Input[dict]`)
            * `prometheus` (`pulumi.Input[str]`)
            * `redis` (`pulumi.Input[str]`)

          * `redisLfuDecayTime` (`pulumi.Input[str]`)
          * `redisLfuLogFactor` (`pulumi.Input[str]`)
          * `redisMaxmemoryPolicy` (`pulumi.Input[str]`)
          * `redisNotifyKeyspaceEvents` (`pulumi.Input[str]`)
          * `redisSsl` (`pulumi.Input[str]`)
          * `redisTimeout` (`pulumi.Input[str]`)

        The **service_integrations** object supports the following:

          * `integration_type` (`pulumi.Input[str]`)
          * `source_service_name` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["cassandra"] = cassandra
        __props__["cassandra_user_config"] = cassandra_user_config
        __props__["client_timeout"] = client_timeout
        __props__["cloud_name"] = cloud_name
        __props__["components"] = components
        __props__["elasticsearch"] = elasticsearch
        __props__["elasticsearch_user_config"] = elasticsearch_user_config
        __props__["grafana"] = grafana
        __props__["grafana_user_config"] = grafana_user_config
        __props__["influxdb"] = influxdb
        __props__["influxdb_user_config"] = influxdb_user_config
        __props__["kafka"] = kafka
        __props__["kafka_connect"] = kafka_connect
        __props__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__["kafka_mirrormaker"] = kafka_mirrormaker
        __props__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__["kafka_user_config"] = kafka_user_config
        __props__["maintenance_window_dow"] = maintenance_window_dow
        __props__["maintenance_window_time"] = maintenance_window_time
        __props__["mysql"] = mysql
        __props__["mysql_user_config"] = mysql_user_config
        __props__["pg"] = pg
        __props__["pg_user_config"] = pg_user_config
        __props__["plan"] = plan
        __props__["project"] = project
        __props__["project_vpc_id"] = project_vpc_id
        __props__["redis"] = redis
        __props__["redis_user_config"] = redis_user_config
        __props__["service_host"] = service_host
        __props__["service_integrations"] = service_integrations
        __props__["service_name"] = service_name
        __props__["service_password"] = service_password
        __props__["service_port"] = service_port
        __props__["service_type"] = service_type
        __props__["service_uri"] = service_uri
        __props__["service_username"] = service_username
        __props__["state"] = state
        __props__["termination_protection"] = termination_protection
        return Service(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

