# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class ServiceIntegration(pulumi.CustomResource):
    destination_endpoint_id: pulumi.Output[str]
    """
    Destination endpoint for the integration (if any)
    """
    destination_service_name: pulumi.Output[str]
    """
    Destination service for the integration (if any)
    """
    integration_type: pulumi.Output[str]
    """
    Type of the service integration
    """
    kafka_connect_user_config: pulumi.Output[dict]
    """
    Kafka Connect specific user configurable settings

      * `kafka_connect` (`dict`)
        * `configStorageTopic` (`str`)
        * `groupId` (`str`)
        * `offsetStorageTopic` (`str`)
        * `statusStorageTopic` (`str`)
    """
    kafka_mirrormaker_user_config: pulumi.Output[dict]
    """
    Mirrormaker 2 integration specific user configurable settings

      * `clusterAlias` (`str`)
    """
    logs_user_config: pulumi.Output[dict]
    """
    Log integration specific user configurable settings

      * `elasticsearchIndexDaysMax` (`str`)
      * `elasticsearchIndexPrefix` (`str`)
    """
    mirrormaker_user_config: pulumi.Output[dict]
    """
    Mirrormaker 1 integration specific user configurable settings

      * `mirrormakerWhitelist` (`str`)
    """
    project: pulumi.Output[str]
    """
    Project the integration belongs to
    """
    source_endpoint_id: pulumi.Output[str]
    """
    Source endpoint for the integration (if any)
    """
    source_service_name: pulumi.Output[str]
    """
    Source service for the integration (if any)
    """
    def __init__(__self__, resource_name, opts=None, destination_endpoint_id=None, destination_service_name=None, integration_type=None, kafka_connect_user_config=None, kafka_mirrormaker_user_config=None, logs_user_config=None, mirrormaker_user_config=None, project=None, source_endpoint_id=None, source_service_name=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        myintegration = aiven.ServiceIntegration("myintegration",
            destination_endpoint_id=aiven_service_integration_endpoint["myendpoint"]["id"],
            destination_service_name="",
            integration_type="datadog",
            project=aiven_project["myproject"]["project"],
            source_endpoint_id="",
            source_service_name=aiven_service["testkafka"]["service_name"])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_endpoint_id: Destination endpoint for the integration (if any)
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_type: Type of the service integration
        :param pulumi.Input[dict] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[dict] kafka_mirrormaker_user_config: Mirrormaker 2 integration specific user configurable settings
        :param pulumi.Input[dict] logs_user_config: Log integration specific user configurable settings
        :param pulumi.Input[dict] mirrormaker_user_config: Mirrormaker 1 integration specific user configurable settings
        :param pulumi.Input[str] project: Project the integration belongs to
        :param pulumi.Input[str] source_endpoint_id: Source endpoint for the integration (if any)
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)

        The **kafka_connect_user_config** object supports the following:

          * `kafka_connect` (`pulumi.Input[dict]`)
            * `configStorageTopic` (`pulumi.Input[str]`)
            * `groupId` (`pulumi.Input[str]`)
            * `offsetStorageTopic` (`pulumi.Input[str]`)
            * `statusStorageTopic` (`pulumi.Input[str]`)

        The **kafka_mirrormaker_user_config** object supports the following:

          * `clusterAlias` (`pulumi.Input[str]`)

        The **logs_user_config** object supports the following:

          * `elasticsearchIndexDaysMax` (`pulumi.Input[str]`)
          * `elasticsearchIndexPrefix` (`pulumi.Input[str]`)

        The **mirrormaker_user_config** object supports the following:

          * `mirrormakerWhitelist` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['destination_endpoint_id'] = destination_endpoint_id
            __props__['destination_service_name'] = destination_service_name
            if integration_type is None:
                raise TypeError("Missing required property 'integration_type'")
            __props__['integration_type'] = integration_type
            __props__['kafka_connect_user_config'] = kafka_connect_user_config
            __props__['kafka_mirrormaker_user_config'] = kafka_mirrormaker_user_config
            __props__['logs_user_config'] = logs_user_config
            __props__['mirrormaker_user_config'] = mirrormaker_user_config
            if project is None:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['source_endpoint_id'] = source_endpoint_id
            __props__['source_service_name'] = source_service_name
        super(ServiceIntegration, __self__).__init__(
            'aiven:index/serviceIntegration:ServiceIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, destination_endpoint_id=None, destination_service_name=None, integration_type=None, kafka_connect_user_config=None, kafka_mirrormaker_user_config=None, logs_user_config=None, mirrormaker_user_config=None, project=None, source_endpoint_id=None, source_service_name=None):
        """
        Get an existing ServiceIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination_endpoint_id: Destination endpoint for the integration (if any)
        :param pulumi.Input[str] destination_service_name: Destination service for the integration (if any)
        :param pulumi.Input[str] integration_type: Type of the service integration
        :param pulumi.Input[dict] kafka_connect_user_config: Kafka Connect specific user configurable settings
        :param pulumi.Input[dict] kafka_mirrormaker_user_config: Mirrormaker 2 integration specific user configurable settings
        :param pulumi.Input[dict] logs_user_config: Log integration specific user configurable settings
        :param pulumi.Input[dict] mirrormaker_user_config: Mirrormaker 1 integration specific user configurable settings
        :param pulumi.Input[str] project: Project the integration belongs to
        :param pulumi.Input[str] source_endpoint_id: Source endpoint for the integration (if any)
        :param pulumi.Input[str] source_service_name: Source service for the integration (if any)

        The **kafka_connect_user_config** object supports the following:

          * `kafka_connect` (`pulumi.Input[dict]`)
            * `configStorageTopic` (`pulumi.Input[str]`)
            * `groupId` (`pulumi.Input[str]`)
            * `offsetStorageTopic` (`pulumi.Input[str]`)
            * `statusStorageTopic` (`pulumi.Input[str]`)

        The **kafka_mirrormaker_user_config** object supports the following:

          * `clusterAlias` (`pulumi.Input[str]`)

        The **logs_user_config** object supports the following:

          * `elasticsearchIndexDaysMax` (`pulumi.Input[str]`)
          * `elasticsearchIndexPrefix` (`pulumi.Input[str]`)

        The **mirrormaker_user_config** object supports the following:

          * `mirrormakerWhitelist` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["destination_endpoint_id"] = destination_endpoint_id
        __props__["destination_service_name"] = destination_service_name
        __props__["integration_type"] = integration_type
        __props__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__["logs_user_config"] = logs_user_config
        __props__["mirrormaker_user_config"] = mirrormaker_user_config
        __props__["project"] = project
        __props__["source_endpoint_id"] = source_endpoint_id
        __props__["source_service_name"] = source_service_name
        return ServiceIntegration(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

