# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class VpcPeeringConnection(pulumi.CustomResource):
    client_timeout: pulumi.Output[dict]
    """
    Custom Terraform Client timeouts

      * `create` (`str`)
    """
    peer_cloud_account: pulumi.Output[str]
    """
    AWS account ID or GCP project ID of the peered VPC
    """
    peer_region: pulumi.Output[str]
    """
    AWS region of the peered VPC (if not in the same region as Aiven VPC)
    """
    peer_vpc: pulumi.Output[str]
    """
    AWS VPC ID or GCP VPC network name of the peered VPC
    """
    peering_connection_id: pulumi.Output[str]
    """
    Cloud provider identifier for the peering connection if available
    """
    state: pulumi.Output[str]
    """
    State of the peering connection
    """
    state_info: pulumi.Output[dict]
    """
    State-specific help or error information
    """
    vpc_id: pulumi.Output[str]
    """
    The VPC the peering connection belongs to
    """
    def __init__(__self__, resource_name, opts=None, client_timeout=None, peer_cloud_account=None, peer_region=None, peer_vpc=None, vpc_id=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage



        ```python
        import pulumi
        import pulumi_aiven as aiven

        mypeeringconnection = aiven.VpcPeeringConnection("mypeeringconnection",
            peer_cloud_account="<PEER_ACCOUNT_ID>",
            peer_region="<PEER_REGION>",
            peer_vpc="<PEER_VPC_ID/NAME>",
            vpc_id=aiven_project_vpc["myvpc"]["id"])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[str] peer_cloud_account: AWS account ID or GCP project ID of the peered VPC
        :param pulumi.Input[str] peer_region: AWS region of the peered VPC (if not in the same region as Aiven VPC)
        :param pulumi.Input[str] peer_vpc: AWS VPC ID or GCP VPC network name of the peered VPC
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if client_timeout is not None:
                warnings.warn("use timeouts instead", DeprecationWarning)
                pulumi.log.warn("client_timeout is deprecated: use timeouts instead")
            __props__['client_timeout'] = client_timeout
            if peer_cloud_account is None:
                raise TypeError("Missing required property 'peer_cloud_account'")
            __props__['peer_cloud_account'] = peer_cloud_account
            __props__['peer_region'] = peer_region
            if peer_vpc is None:
                raise TypeError("Missing required property 'peer_vpc'")
            __props__['peer_vpc'] = peer_vpc
            if vpc_id is None:
                raise TypeError("Missing required property 'vpc_id'")
            __props__['vpc_id'] = vpc_id
            __props__['peering_connection_id'] = None
            __props__['state'] = None
            __props__['state_info'] = None
        super(VpcPeeringConnection, __self__).__init__(
            'aiven:index/vpcPeeringConnection:VpcPeeringConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, client_timeout=None, peer_cloud_account=None, peer_region=None, peer_vpc=None, peering_connection_id=None, state=None, state_info=None, vpc_id=None):
        """
        Get an existing VpcPeeringConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] client_timeout: Custom Terraform Client timeouts
        :param pulumi.Input[str] peer_cloud_account: AWS account ID or GCP project ID of the peered VPC
        :param pulumi.Input[str] peer_region: AWS region of the peered VPC (if not in the same region as Aiven VPC)
        :param pulumi.Input[str] peer_vpc: AWS VPC ID or GCP VPC network name of the peered VPC
        :param pulumi.Input[str] peering_connection_id: Cloud provider identifier for the peering connection if available
        :param pulumi.Input[str] state: State of the peering connection
        :param pulumi.Input[dict] state_info: State-specific help or error information
        :param pulumi.Input[str] vpc_id: The VPC the peering connection belongs to

        The **client_timeout** object supports the following:

          * `create` (`pulumi.Input[str]`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["client_timeout"] = client_timeout
        __props__["peer_cloud_account"] = peer_cloud_account
        __props__["peer_region"] = peer_region
        __props__["peer_vpc"] = peer_vpc
        __props__["peering_connection_id"] = peering_connection_id
        __props__["state"] = state
        __props__["state_info"] = state_info
        __props__["vpc_id"] = vpc_id
        return VpcPeeringConnection(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

