# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tada', 'tada.util']

package_data = \
{'': ['*']}

install_requires = \
['colorama',
 'hypothesis',
 'hypothesis-jsonschema',
 'matplotlib>=3.3.0,<4.0.0',
 'pandas',
 'ptable',
 'pyperf']

entry_points = \
{'console_scripts': ['tada = tada:main']}

setup_kwargs = {
    'name': 'tada-predict',
    'version': '1.0.0',
    'description': 'Predict the likely worst-case order-of-growth function for an arbitrary Python function.',
    'long_description': '# Tada!: auTomAtic orDer-of-growth Analysis\n\n[![Build Status](https://api.travis-ci.org/Tada-Project/tada.svg?branch=master)](https://travis-ci.org/Tada-Project/tada) [![codecov.io](https://codecov.io/github/Tada-Project/tada/coverage.svg?branch=master)](http://codecov.io/github/Tada-Project/tada?branch=master) [![made-with-python](https://img.shields.io/badge/Made%20with-Python-orange.svg)](https://www.python.org/)\n\nThis repository contains the source code and usage instructions for a tool\ncalled "Tada: auTomAtic orDer-of-growth Analysis" that is implemented in the\nPython 3 language. The tool systematically runs a doubling experiment to\nascertain the likely worst-case order-of-growth function for an arbitrary Python\nfunction. This documentation provides a brief overview about how to run the\ntool, its provided test suite, and more.\n\n## Install Tada\n\n- Operating system: Unix/Linux · macOS/OS X · Windows\n- Dependency Management: [Pipenv](https://github.com/pypa/pipenv) · [Poetry](https://github.com/python-poetry/poetry)\n\n### Pipenv\n\nIf you haven\'t done so already, you can run the following command to install\n`pipenv` on your local machine:\n\n```bash\npip install pipenv\n```\n\nOnce you have installed `pipenv`, you can then run the test suite for Tada\'s\nfunctions by typing the following in your terminal window:\n\n- `pipenv install`\n\nYou can also activate the `pipenv` shell by running this command: `pipenv shell`\n\n### Poetry\n\nSimilarly, you can run the following command to install `poetry` on your local\nmachine:\n\n```bash\npip install poetry\n```\n\nTo install dependencies with `poetry`, you can just run:\n\n```bash\npoetry install --no-dev\n```\n\nYou can activate the `poetry` shell with this command:\n\n```bash\npoetry shell\n```\n\n### Run Command\n\nThere are multiple ways to use either `pipenv` or `poetry` to run and test\nTada. You can have `pipenv run` or `poetry run` followed by the command like\nthis:\n\n```bash\npipenv run python\npoetry run python\n```\n\nYou can also just spawn a shell with the virtualenv activated by either `pipenv`\nor `poetry`. For ease of reading, the commands provided in the documentation will\njust be the ones that you would run in the shell.\n\n## Use Tada\n\n### Checks\n\nTada is currently under continuous development, it is not yet feature\ncomplete. However, the documentation here and in\n[Speed-Surprises](https://github.com/Tada-Project/speed-surprises) have featured\nsome examples on how to run the tool to automatically suggest the likely\nworst-case order-of-growth function for various types of provided Python function.\n\nIf you want to run the tool, then you can run:\n\n```bash\npython tada_a_bigoh.py [-h] --directory DIRECTORY --module MODULE --function FUNCTION --types TYPES [TYPES ...]\n```\n\nYou can learn about Tada\'s checks and defaults by typing\n`python tada_a_bigoh.py -h` in your terminal window and then\nreviewing the following output.\n\n```\nusage: tada_a_bigoh.py [-h] --directory DIRECTORY [DIRECTORY ...] --module\n                       MODULE [MODULE ...] --function FUNCTION [FUNCTION ...]\n                       --types TYPES [TYPES ...]\n                       [--data_directory DATA_DIRECTORY]\n                       [--data_module DATA_MODULE]\n                       [--data_function DATA_FUNCTION] [--schema SCHEMA]\n                       [--startsize STARTSIZE] [--steps STEPS]\n                       [--runningtime RUNNINGTIME] [--expect EXPECT]\n                       [--backfill] [--indicator INDICATOR]\n                       [--maxsize MAXSIZE] [--sorted] [--log] [--md]\n                       [--contrast] [--level LEVEL]\n                       [--position POSITION [POSITION ...]]\n\noptional arguments:\n  -h, --help            show this help message and exit\n  --directory DIRECTORY [DIRECTORY ...]\n                        Path to the package directory with functions to\n                        analyze (default: None)\n  --module MODULE [MODULE ...]\n                        Module name with functions to analyze (default: None)\n  --function FUNCTION [FUNCTION ...]\n                        Name of the function to analyze (default: None)\n  --types TYPES [TYPES ...]\n                        Data generation type: hypothesis or parameter types of\n                        the function (default: None)\n  --data_directory DATA_DIRECTORY\n                        Path to the package directory with function to\n                        generate data (default: None)\n  --data_module DATA_MODULE\n                        Module name with functions to generate data (default:\n                        None)\n  --data_function DATA_FUNCTION\n                        Name of the data generation function (default: None)\n  --schema SCHEMA       The path to the JSON schema that describes the data\n                        format (default: None)\n  --startsize STARTSIZE\n                        Starting size of the doubling experiment (default: 1)\n  --steps STEPS         Maximum rounds of the doubling experiment (default:\n                        10)\n  --runningtime RUNNINGTIME\n                        Maximum running time of the doubling experiment\n                        (default: 200)\n  --expect EXPECT       Expected Growth Ratio: O(1) | O(logn) | O(n) |\n                        O(nlogn) | O(n^2) | O(n^3) | O(c^n). By using this\n                        argument, the experiment result will be stored in a\n                        csv file (default: None)\n  --backfill            Enable backfill to shrink experiments size according\n                        to the Predicted True Value (default: False)\n  --indicator INDICATOR\n                        Indicator value (default: 0.1)\n  --maxsize MAXSIZE     Maximum size of the doubling experiment (default:\n                        1500)\n  --sorted              Enable input data to be sorted (default: False)\n  --log                 Show log/debug/diagnostic output (default: False)\n  --md                  Show results table in markdown format (default: False)\n  --contrast            Show contrast result table. Only works with multiple\n                        experiments (default: False)\n  --viz                 Visualize a simple graph for the result (default:\n                        False)\n  --level LEVEL         The level of nested data structure to apply doubling\n                        experiment (default: 1)\n  --position POSITION [POSITION ...]\n                        The position of input data to double in the\n                        multivariable doubling experiment. Must be the last\n                        argument (default: [0])\n\nSample usage: python tada_a_bigoh.py --directory\n/Users/myname/projectdirectory --module modulename.file --function\nfunction_name --types hypothesis\n```\n\nIt is worth noting that when the provided function is relied on an external Python\nlibrary, it is likely that Tada might not have this dependency, and thus, it might\ncause an error when running the experiment. You can simply resolve this issue\nby installing the required dependencies.\n\nType in this command if you are using `pipenv`:\n\n```bash\npipenv install <library-name>\n```\n\nor this command if you are using `poetry`:\n\n```bash\npoetry add <library-name>\n```\n\nOtherwise, type in the installation command that is appropriate for your own\nchosen installation method.\n\n### Data Generation\n\nTada adopts `Hypothesis` and `Hypothesis-jsonschema` to generate random data for the\nprovided Python function. Therefore, we encourage you to create a file of\na JSON array that contains JSON schemas of each parameter passed into the provided\nfunction. Tada also supports data generation through our built-in\n[data generation functions](https://github.com/Tada-Project/tada/blob/master/tada/util/generate.py)\nincluding these following types:\n`int, int_list, char, char_list, boolean, string, float, bitdepth`\n\nTo specify the data generation strategy, we encourage you to set argument\n`--types TYPES [TYPES ...]` with `hypothesis` or one of the aforementioned\ngeneration types. When using `hypothesis` to generate experiment data, you can\nsimply set the `maxItems` and `minItems` in the json schema to zero. The size\ndoubling will be enabled through the command line check `--startsize STARTSIZE`,\nwhich will be the starting size of the doubling experiment.\n\nFor further usage of JSON schemas and how to write them for various data types:\nplease refer to [JSON schema](https://json-schema.org/understanding-json-schema/reference/type.html)\nand\n[sample JSON schemas](https://github.com/Tada-Project/speed-surprises/tree/master/speedsurprises/jsonschema).\n\nWhen completed, Tada will be used to estimate the worst-case time complexity for\nPython functions.\n\n### Speed-Surprises\n\nWe have provided an extensive library of functions and sample JSON schemas in\n[Speed-Surprises repository](https://github.com/Tada-Project/speed-surprises).\nYou can use or test Tada in conjunction with functions in this repository.\n\n### Sample Output\n\n```bash\n$ python tada_a_bigoh.py --directory ../speed-surprises/ --module speedsurprises.lists.sorting --function insertion_sort --types hypothesis --schema ../speed-surprises/speedsurprises/jsonschema/single_int_list.json --startsize 50\n\n      Tada!: auTomAtic orDer-of-growth Analysis!\n        https://github.com/Tada-Project/tada/\n    For Help Information Type: python tada_a_bigoh.py -h\n\nStart running experiment for size 50 →\n\n\n→ Done running experiment for size 50\n.\n.\n.\n→ Done running experiment for size 800\n\n+-----------------------------------------------------------------------------+\n|             insertion_sort: O(n) linear or O(nlogn) linearithmic            |\n+------+------------------------+------------------------+--------------------+\n| Size |          Mean          |         Median         |       Ratio        |\n+------+------------------------+------------------------+--------------------+\n|  50  | 5.254574352518718e-06  | 5.080362350463869e-06  |         0          |\n| 100  | 1.013776767171224e-05  | 1.0109862487792971e-05 | 1.929322337375019  |\n| 200  | 2.041813344523112e-05  | 1.9827050170898433e-05 | 2.0140660258179457 |\n| 400  | 4.1289982617187504e-05 | 4.0720488891601556e-05 | 2.0222212146836194 |\n| 800  | 9.176736091308593e-05  | 9.089502807617187e-05  |  2.22250907111999  |\n+------+------------------------+------------------------+--------------------+\nO(n) linear or O(nlogn) linearithmic\n```\n\n#### Compare two algorithms\' performance with Tada\n\nIf you would like to run Tada to compare the performance of two functions, you\nwill just need to specify the additional function with it\'s directory and module\n(if it\'s different from the first function) like this:\n\n```bash\n$ python tada_a_bigoh.py --directory ../speed-surprises/ --module speedsurprises.lists.sorting --function insertion_sort bubble_sort --types hypothesis --schema ../speed-surprises/speedsurprises/jsonschema/single_int_list.json --startsize 25\n\n      Tada!: auTomAtic orDer-of-growth Analysis!\n        https://github.com/Tada-Project/tada/\n    For Help Information Type: python tada_a_bigoh.py -h\n\nStart running experiment insertion_sort for size 25 →\n.\n.\n.\n→ Done running experiment bubble_sort for size 800\n\n+-----------------------------------------------------------------------------+\n|             insertion_sort: O(n) linear or O(nlogn) linearithmic            |\n+------+------------------------+------------------------+--------------------+\n| Size |          Mean          |         Median         |       Ratio        |\n+------+------------------------+------------------------+--------------------+\n|  25  | 3.644364811706543e-06  | 3.498709533691405e-06  |         0          |\n|  50  | 6.535123836263021e-06  | 6.483351989746092e-06  | 1.793213405878218  |\n| 100  | 1.2902192108154296e-05 | 1.2540842590332028e-05 | 1.9742842571032526 |\n| 200  | 2.5023900944010416e-05 | 2.4608139038085928e-05 | 1.9395077002608803 |\n| 400  | 5.526396857910156e-05  | 5.3515207031250005e-05 | 2.2084473840729952 |\n| 800  | 0.00011801120257161459 |  0.00011251379296875   | 2.1354094829925283 |\n+------+------------------------+------------------------+--------------------+\n+-----------------------------------------------------------------------------+\n|                        bubble_sort: O(n^2) quadratic                        |\n+------+------------------------+------------------------+--------------------+\n| Size |          Mean          |         Median         |       Ratio        |\n+------+------------------------+------------------------+--------------------+\n|  25  | 2.8776128824869792e-05 | 2.846207250976562e-05  |         0          |\n|  50  | 0.00010703222574869792 | 0.00010308191601562499 | 3.7194796562140504 |\n| 100  | 0.0004109644687825521  | 0.00039437410449218743 | 3.8396330255474633 |\n| 200  |   0.0015730586140625   | 0.0015326660937500002  | 3.8277241308051635 |\n| 400  |    0.00632440301875    |  0.006229572156249999  | 4.020449690947576  |\n| 800  |  0.029292134683333335  |  0.028519337000000006  | 4.631604690038055  |\n+------+------------------------+------------------------+--------------------+\n\nAt the greatest common size 800:\nMean: insertion_sort is 99.60% faster than bubble_sort\nMedian: insertion_sort is 99.61% faster than bubble_sort\n```\n\n##### Contrast result tables of two algorithms\' performance with Tada\n\nIf you would like to contrast run time of two different algorithms where the run\ntime of one might be included in another, you can use the `--contrast` feature\nto get the result table generated based on the subtraction of the two algorithms\nwith the growth ratio analysis of the run time difference:\n\n```bash\n$ python tada_a_bigoh.py --directory ../speed-surprises/ --module=speedsurprises.graph.graph_gen --function graph_gen graph_gen_BFS --types hypothesis --schema=../speed-surprises/speedsurprises/jsonschema/int_and_int.json --startsize=50  --max=1000 --position 0 --contrast\n\n      Tada!: auTomAtic orDer-of-growth Analysis!\n        https://github.com/Tada-Project/tada/\n    For Help Information Type: python tada_a_bigoh.py -h\n\nStart running experiment graph_gen for size 25 →\n.\n.\n.\n→ Done running experiment graph_gen_BFS for size 800\n\n+-----------------------------------------------------------------------------+\n|               graph_gen: O(n) linear or O(nlogn) linearithmic               |\n+------+------------------------+------------------------+--------------------+\n| Size |          Mean          |         Median         |       Ratio        |\n+------+------------------------+------------------------+--------------------+\n|  50  |  9.94538065592448e-06  | 9.501693725585938e-06  |         0          |\n| 100  | 1.8558588460286458e-05 | 1.8363348388671875e-05 | 1.8660510947090876 |\n| 200  | 3.7122855631510415e-05 | 3.560983886718751e-05  | 2.000305988300223  |\n| 400  | 7.208413248697916e-05  | 7.197658691406252e-05  | 1.9417722925871337 |\n| 800  | 0.00015173049479166666 | 0.00014575283203125002 | 2.104908383534675  |\n+------+------------------------+------------------------+--------------------+\n+-------------------------------------------------------------------------+\n|                     graph_gen_BFS: O(n^2) quadratic                     |\n+------+-----------------------+---------------------+--------------------+\n| Size |          Mean         |        Median       |       Ratio        |\n+------+-----------------------+---------------------+--------------------+\n|  50  |   0.0010322848828125  |  0.000936182421875  |         0          |\n| 100  | 0.0037961446354166668 |   0.0036485609375   | 3.6774195753733445 |\n| 200  |  0.014912410624999999 |    0.01433645625    | 3.928304123576473  |\n| 400  |  0.06095087833333333  | 0.05791582499999999 | 4.087258583877236  |\n| 800  |      0.252504645      | 0.23859980000000003 | 4.1427564606875915 |\n+------+-----------------------+---------------------+--------------------+\n\nAt the greatest common size 800:\nMean: graph_gen is 99.94% faster than graph_gen_BFS\nMedian: graph_gen is 99.94% faster than graph_gen_BFS\n\n+----------------------------------------------------------------------------------------+\n|               Contrast for graph_gen and graph_gen_BFS: O(n^2) quadratic               |\n+-------+---------------------------+---------------------------+------------------------+\n|  Size |            Mean           |           Median          |         Ratio          |\n+-------+---------------------------+---------------------------+------------------------+\n|   50  |   0.0010223395021565756   |   0.0009266807281494141   |           0            |\n|  100  |   0.0037775860469563805   |    0.003630197589111328   |   3.6950406777667753   |\n|  200  |    0.014875287769368488   |    0.014300846411132813   |   3.9377760253412575   |\n|  400  |    0.06087879420084635    |    0.05784384841308593    |   4.092612872082332    |\n|  800  |    0.25235291450520836    |    0.23845404716796878    |   4.145169394660909    |\n+-------+---------------------------+---------------------------+------------------------+\n```\n\n#### Debug output with `--log`\n\n```bash\n$ python tada_a_bigoh.py --directory ../speed-surprises/ --module speedsurprises.lists.sorting --function insertion_sort --types hypothesis --schema ../speed-surprises/speedsurprises/jsonschema/single_int_list.json --startsize 50 --log\n\n      Tada!: auTomAtic orDer-of-growth Analysis!\n        https://github.com/Tada-Project/tada/\n    For Help Information Type: python tada_a_bigoh.py -h\n\nStart running experiment for size 50 →\n\n.....................\ntada_speedsurpriseslistssorting_insertionsort_50: Mean +- std dev: 6.76 us +- 0.38 us\n\nMean 6.756377457682293e-06\nMedian 6.655228393554689e-06\ncurrent indicator: 0.1\nexpected end time: 6.756377457682293e-06\n\n→ Done running experiment for size 50\n\nend time rate: 1\nlast end time rate: 1\n\nStart running experiment for size 100 →\n.\n.\n.\n→ Done running experiment for size 800\n\nend time rate: 1.0977868448462222\nlast end time rate: 1.0104045516442501\n\nQuit due to reaching max size: 1500\n+-----------------------------------------------------------------------------+\n|             insertion_sort: O(n) linear or O(nlogn) linearithmic            |\n+------+------------------------+------------------------+--------------------+\n| Size |          Mean          |         Median         |       Ratio        |\n+------+------------------------+------------------------+--------------------+\n|  50  | 5.108458277893066e-06  | 4.995336715698241e-06  |         0          |\n| 100  | 9.719848541259765e-06  | 9.592753784179686e-06  | 1.9026970589781584 |\n| 200  | 1.9103883695475262e-05 | 1.881045025634766e-05  | 1.9654507592768782 |\n| 400  | 4.1088669527180994e-05 | 4.0323755249023436e-05 | 2.1508019092951667 |\n| 800  |    8.721809375e-05     | 8.493975268554687e-05  | 2.1226799201250226 |\n+------+------------------------+------------------------+--------------------+\n```\n\n### Tada-Generate-Functions\n\nWe have provided an extensive library of data generation functions in\n[Tada-Generate-Functions repository](https://github.com/Tada-Project/Tada-Generate-Functions).\nYou can use or test Tada in conjunction with generation functions in this\nrepository by using the `--types custom` argument followed by `--data_directory`,\n`--data_module`, and `--data_function`:\n\n```bash\npython tada_a_bigoh.py --directory ../speed-surprises/ --module speedsurprises.lists.python_basic --function list_copy --types custom --data_directory ../Tada-Generate-Functions/ --data_module generatefunctions.generate_lists  --data_function generate_single_int_list --startsize 25 --maxsize 1000\n```\n\n### Record Tada Experiment Result(s)\n\nIf you would like to record the results of the doubling experiment, you can use\nthe command line argument `--expect` by specifying with a string of the expected\nBig-Oh growth ratio of the provided function (e.g. `"O(1)"`, `"O(n^2)"`). The\nfollowing variables will be stored and exported to `experiment_data.csv`. :\n\n- `EXPERIMENT_RELIABILITY`:  dummy variable := 1 if the result provided by tada tool is\n  what user expected.\n- `CPU_TYPE`: string := type information of CPU.\n- `CPU_TEMP`: string := temperature information of CPU.\n- `CPU_COUNT`: int := the number of physical CPUs.\n- `TOTAL_RUNNING_TIME`: int := total time spent on running experiment.\n- `QUIT_BY_MAX_RUNTIME`: dummy variable := 1 if the tool exits by reaching the\n  max_runtime.\n- `QUIT_BY_INDICATOR`: dummy variable := 1 if the tool exits by having indicator larger\n  than the indicator bound.\n- `QUIT_BY_BACKFILL`: dummy variable := 1 if the tool exits by having multiple times of backfills\n- `QUIT_BY_MAX_SIZE`: dummy variable := 1 if the tool exits by reaching the max_size\n  back-filling.\n- `MEM_MAX_RSS`: int := track of current machine memory usage.\n- `MEM_PEAK_PAGEFILE_USAGE`: int := track of current machine memory usage (windows).\n- `OS`: string := information of current operating system.\n- `INDICATOR_VALUE`: int := the value of the indicator boundary user set.\n- `BACKFILL_TIMES`: int := the value of the back-fill time boundary user set.\n- `PYPERF_AVG_EXPERIMENT_ROUNDS`: int := the average loops of all benchmarks in the\n  experiment, the measurement of difficulty for PyPerf to analyze the target algorithm.\n- `PYPERF_LAST_TWO_EXPERIMENT_ROUNDS_RATIO`: int := the growth ratio of the total loops\n  in the last two benchmarks, the total loops is usually decreasing when the input get\n  larger, the measurement of reliability of the experiment analysis.\n- `NAME_OF_EXPERIMENT`: string := experiment information.\n- `PYTHON_VERSION`: string := current version of Python.\n- `DATA_GEN_STRATEGY`: string := the chosen data generation strategy\n- `START_SIZE`: int := initial size of the doubling experiment\n- `ARGUMENTS`: string := input argument to run the doubling experiment\n\nTo run with experiment data collected, add `expect` into the command like this:\n\n```bash\npython tada_a_bigoh.py --directory ../speed-surprises/ --module speedsurprises.lists.sorting --function insertion_sort --types hypothesis --schema ../speed-surprises/speedsurprises/jsonschema/single_int_list.json --startsize 50 --expect "O(n)"\n```\n\n## Add New Features to Tada\n\nYou can follow these steps to add a new feature if you are already a\ncollaborator on the project. First, you should type the following\ncommand, substituting the name of your feature for the word `feature-name`.\n\n- `git checkout -b feature-name`\n- `git checkout master`\n- `git push -u origin feature-name`\n\nTo install development dependencies, type the following commands in the terminal:\n\n```bash\npipenv install --dev\n```\n\nor\n\n```bash\npoetry install\n```\n\nFinally, you should open a pull request on the GitHub repository for the new\nbranch that you have created. This pull request should describe the new feature\nthat you are adding and give examples of how to run it on the command line.\nOf course, if you are not a collaborator on this project, then you will need to\nfork the repository, add your new feature, document and test it as appropriate,\nand then create a pull request similarily.\n\nWe highly recommend you to provide tests along with the feature that you\nimplemented and you should not break the existing test cases or features.\n\n### Test Tada\n\nTo run the test suite for Tada\'s functions by typing the following in your\nterminal window:\n\n```bash\npytest\n```\n\nIf you want to collect the coverage of the provided test suite, then you can\nrun:\n\n```bash\npytest --cov-config pytest.cov --cov\n```\n\nIf you want to collect the coverage of the provided test suite and see what\nlines of code are not covered, then you can run:\n\n```bash\npytest --cov-config pytest.cov --cov --cov-report term-missing\n```\n\n## Future Works\n\n- Further verification of the accuracy and efficiency of the tool\n\n## Problems or Praise\n\nIf you have any problems with installing or using the Tada or its provided test\nsuite, then please create an issue associated with this Git repository using the\n"Issues" link at the top of this site. The contributors to Tada will do all that\nthey can to resolve your issue and ensure that all of its features and the test\nsuite work well in your development environment.\n',
    'author': 'enpuyou',
    'author_email': 'youe2@allegheny.edu',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://tada-predict.netlify.app',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
