class VaspValence:
    """Setup dependent number of valence electrons for each element, 
    used to compute the number of bands in VASP calculation
    """
    H = {'s': 1}
    He = {'s': 2}
    Li = {'s': 1, '_sv': 3}
    Be = {'s': 2, 'sv': 4}
    B = {'s': 3}
    C = {'s': 4}
    N = {'s': 5}
    O = {'s': 6}
    F = {'s': 7}
    Ne = {'s': 8}
    Na = {'s': 7, '_pv': 7, '_sv': 9}
    Mg = {'s': 2, '_pv': 8, '_sv': 10}
    Al = {'s': 3}
    Si = {'s': 4}
    P = {'s': 5}
    S = {'s': 6}
    Cl = {'s': 7}
    Ar = {'s': 8}
    K = {'_pv': 7, '_sv': 9}
    Ca = {'_pv': 8, '_sv': 10}
    Sc = {'s': 3, '_sv': 11}
    Ti = {'s': 4, '_pv': 10, '_sv': 12}
    V = {'s': 5, '_pv': 11, '_sv': 13}
    La = {'s': 11}
    Cr = {'s': 6, '_pv': 12, '_sv': 14}
    Mn = {'s': 7, '_pv': 13, '_sv': 15}
    Fe = {'s': 8, '_pv': 14, '_sv': 16}
    Co = {'s': 9, '_pv': 15, '_sv': 17}
    Ni = {'s': 10, '_pv': 16}
    Cu = {'s': 11, '_pv': 17}
    Zn = {'s': 12}
    Ga = {'s': 3, '_d': 13}
    Ge = {'s': 4, '_d': 14}
    As = {'s': 5, '_d': 15}
    Se = {'s': 6}
    Br = {'s': 7}
    Kr = {'s': 8}
    Rb = {'s_pv': 7, '_sv': 9}
    Sr = {'_sv': 10}
    Y = {'_sv': 11}
    Zr = {'_sv': 12}
    Nb = {'_pv': 11, '_sv': 13}
    Mo = {'s': 6, '_pv': 12, '_sv': 14}
    Tc = {'s': 7, '_pv': 13, '_sv': 15}
    Ru = {'s': 8, '_pv': 14, '_sv': 16}
    Rh = {'s': 9, '_pv': 15}
    Pd = {'s': 10, '_pv': 16}
    Ag = {'s': 11, '_pv': 17}
    Cd = {'s': 12}
    In = {'s': 3, '_d': 13}
    Sn = {'s': 4, '_d': 14}
    Sb = {'s': 5}
    Te = {'s': 6}
    I = {'s': 7}
    Xe = {'s': 8}
    Ba = {'_sv'}
    Hf = {'s': 4, '_pv': 10, '_sv': 12}
    Ta = {'s': 5, '_pv': 11}
    W = {'s': 6, '_pv': 12}
    Re = {'s': 7, '_pv': 13}
    Os = {'s': 8, '_pv': 14}
    Ir = {'s': 9}
    Pt = {'s': 10, '_pv': 16}
    Au = {'s': 11}
    Hg = {'s': 12}
    Tl = {'s': 3, '_d': 13}
    Pb = {'s': 4, '_d': 14}
    Bi = {'s': 5, '_d': 15}
    Po = {'s': 6, '_pv': 16}
    At = {'s': 7, '_pv': 17}
    Rn = {'s': 8}
    Ra = {'_sv': 10}
