# Xpra Documentation Index


## [Usage](./Usage/README.md)

[Simple examples](./Usage/README.md) to get started.

### Starting a session
* [Seamless Session](./Usage/Seamless.md) : individual windows
* [Desktop Session](./Usage/Start-Desktop.md) : a full desktop session
* [Shadow Session](./Usage/Shadow-Server.md) : view an existing display

### Configuration
* [Authentication modules](./Usage/Authentication.md) to secure access to sessions
* [Options](./Usage/Configuration.md) to configure xpra

### Advanced Topics
* [proxy server](./Usage/Proxy-Server.md) to manage access
* [system service](./Usage/Service.md) to start on boot
* [picture encodings](./Usage/Encodings.md) : quality and performance
* [OpenGL applications](./Usage/OpenGL.md) : server-side GPU acceleration
* [Client OpenGL acceleration](./Usage/Client-OpenGL.md)
* [Xdummy](./Usage/Xdummy.md) : alternative to `Xvfb`


---


## [Features](./Features/README.md)
### Device Forwarding
* [Audio](./Features/Audio.md) : speaker and microphone
* [Printers](./Features/Printing.md)
* [Webcams](./Features/Webcam.md)
* [Keyboard](./Features/Keyboard.md)
### Data Synchronization
* [Clipboard](./Features/Clipboard.md)
* [File transfers](./Features/File-Transfers.md)
* [System tray](./Features/System-Tray.md)
* [Notifications](./Features/Notifications.md)
### Display Characteristics
* [Image Depth](./Features/Image-Depth.md)
* [DPI](./Features/DPI.md)


---


## [Network](./Network/README.md)
### [Encryption](./Network/Encryption.md)
* [AES](./Network/AES.md)
* [SSL](./Network/SSL.md)
* [SSH](./Network/SSH.md)
### [Multicast DNS](./Network/Multicast-DNS.md)


---


## [Build](./Build/README.md)
For developers:
### [Generic list of dependencies](./Build/Dependencies.md)

### Platform specific build instructions
* [Fedora / RedHat](./Build/RPM.md)
* [Debian](./Build/Debian.md)
* [MS Windows](./Build/MSWindows.md)
* [MacOS](./Build/MacOS.md)
* [Other](./Build/Other.md)

