from typing import Tuple, Set, Iterable, List


class AppearanceSettings:
    def DefaultPaintColor(whichColor: PaintColor) -> Color: ...
    @property
    def CommandPromptBackgroundColor() -> Color: ...
    @property
    def CommandPromptFontSize() -> int: ...
    @property
    def CommandPromptHypertextColor() -> Color: ...
    @property
    def CommandPromptPosition() -> CommandPromptPosition: ...
    @property
    def CommandPromptTextColor() -> Color: ...
    @property
    def CrosshairColor() -> Color: ...
    @property
    def CurrentLayerBackgroundColor() -> Color: ...
    @property
    def DefaultFontFaceName() -> str: ...
    @property
    def DefaultLayerColor() -> Color: ...
    @property
    def DefaultObjectColor() -> Color: ...
    @property
    def EchoCommandsToHistoryWindow() -> bool: ...
    @property
    def EchoPromptsToHistoryWindow() -> bool: ...
    @property
    def EditCandidateColor() -> Color: ...
    @property
    def FeedbackColor() -> Color: ...
    @property
    def FrameBackgroundColor() -> Color: ...
    @property
    def GridThickLineColor() -> Color: ...
    @property
    def GridThinLineColor() -> Color: ...
    @property
    def GridXAxisLineColor() -> Color: ...
    @property
    def GridYAxisLineColor() -> Color: ...
    @property
    def GridZAxisLineColor() -> Color: ...
    @property
    def LanguageIdentifier() -> int: ...
    @property
    def LockedObjectColor() -> Color: ...
    @property
    def MenuVisible() -> bool: ...
    @property
    def PageviewPaperColor() -> Color: ...
    @property
    def PreviousLanguageIdentifier() -> int: ...
    @property
    def SelectedObjectColor() -> Color: ...
    @property
    def SelectionWindowCrossingFillColor() -> Color: ...
    @property
    def SelectionWindowCrossingStrokeColor() -> Color: ...
    @property
    def SelectionWindowFillColor() -> Color: ...
    @property
    def SelectionWindowStrokeColor() -> Color: ...
    @property
    def ShowCrosshairs() -> bool: ...
    @property
    def ShowFullPathInTitleBar() -> bool: ...
    @property
    def ShowOsnapBar() -> bool: ...
    @property
    def ShowSideBar() -> bool: ...
    @property
    def ShowStatusBar() -> bool: ...
    @property
    def TrackingColor() -> Color: ...
    @property
    def UsePaintColors() -> bool: ...
    @property
    def ViewportBackgroundColor() -> Color: ...
    @property
    def WorldCoordIconXAxisColor() -> Color: ...
    @property
    def WorldCoordIconYAxisColor() -> Color: ...
    @property
    def WorldCoordIconZAxisColor() -> Color: ...
    def GetCurrentState() -> AppearanceSettingsState: ...
    def GetDefaultState() -> AppearanceSettingsState: ...
    @overload
    def GetPaintColor(whichColor: PaintColor) -> Color: ...
    @overload
    def GetPaintColor(whichColor: PaintColor, compute: bool) -> Color: ...
    def GetWidgetColor(whichColor: WidgetColor) -> Color: ...
    def InitialMainWindowPosition() -> Tuple[bool, Rectangle]: ...
    def RestoreDefaults() -> None: ...
    @CommandPromptBackgroundColor.setter
    def CommandPromptBackgroundColor(value: Color) -> None: ...
    @CommandPromptFontSize.setter
    def CommandPromptFontSize(value: int) -> None: ...
    @CommandPromptHypertextColor.setter
    def CommandPromptHypertextColor(value: Color) -> None: ...
    @CommandPromptPosition.setter
    def CommandPromptPosition(value: CommandPromptPosition) -> None: ...
    @CommandPromptTextColor.setter
    def CommandPromptTextColor(value: Color) -> None: ...
    @CrosshairColor.setter
    def CrosshairColor(value: Color) -> None: ...
    @CurrentLayerBackgroundColor.setter
    def CurrentLayerBackgroundColor(value: Color) -> None: ...
    @DefaultLayerColor.setter
    def DefaultLayerColor(value: Color) -> None: ...
    @DefaultObjectColor.setter
    def DefaultObjectColor(value: Color) -> None: ...
    @EchoCommandsToHistoryWindow.setter
    def EchoCommandsToHistoryWindow(value: bool) -> None: ...
    @EchoPromptsToHistoryWindow.setter
    def EchoPromptsToHistoryWindow(value: bool) -> None: ...
    @EditCandidateColor.setter
    def EditCandidateColor(value: Color) -> None: ...
    @FeedbackColor.setter
    def FeedbackColor(value: Color) -> None: ...
    @FrameBackgroundColor.setter
    def FrameBackgroundColor(value: Color) -> None: ...
    @GridThickLineColor.setter
    def GridThickLineColor(value: Color) -> None: ...
    @GridThinLineColor.setter
    def GridThinLineColor(value: Color) -> None: ...
    @GridXAxisLineColor.setter
    def GridXAxisLineColor(value: Color) -> None: ...
    @GridYAxisLineColor.setter
    def GridYAxisLineColor(value: Color) -> None: ...
    @GridZAxisLineColor.setter
    def GridZAxisLineColor(value: Color) -> None: ...
    @LanguageIdentifier.setter
    def LanguageIdentifier(value: int) -> None: ...
    @LockedObjectColor.setter
    def LockedObjectColor(value: Color) -> None: ...
    @MenuVisible.setter
    def MenuVisible(value: bool) -> None: ...
    @PageviewPaperColor.setter
    def PageviewPaperColor(value: Color) -> None: ...
    @PreviousLanguageIdentifier.setter
    def PreviousLanguageIdentifier(value: int) -> None: ...
    @SelectedObjectColor.setter
    def SelectedObjectColor(value: Color) -> None: ...
    @SelectionWindowCrossingFillColor.setter
    def SelectionWindowCrossingFillColor(value: Color) -> None: ...
    @SelectionWindowCrossingStrokeColor.setter
    def SelectionWindowCrossingStrokeColor(value: Color) -> None: ...
    @SelectionWindowFillColor.setter
    def SelectionWindowFillColor(value: Color) -> None: ...
    @SelectionWindowStrokeColor.setter
    def SelectionWindowStrokeColor(value: Color) -> None: ...
    @ShowCrosshairs.setter
    def ShowCrosshairs(value: bool) -> None: ...
    @ShowFullPathInTitleBar.setter
    def ShowFullPathInTitleBar(value: bool) -> None: ...
    @ShowOsnapBar.setter
    def ShowOsnapBar(value: bool) -> None: ...
    @ShowSideBar.setter
    def ShowSideBar(value: bool) -> None: ...
    @ShowStatusBar.setter
    def ShowStatusBar(value: bool) -> None: ...
    @TrackingColor.setter
    def TrackingColor(value: Color) -> None: ...
    @ViewportBackgroundColor.setter
    def ViewportBackgroundColor(value: Color) -> None: ...
    @WorldCoordIconXAxisColor.setter
    def WorldCoordIconXAxisColor(value: Color) -> None: ...
    @WorldCoordIconYAxisColor.setter
    def WorldCoordIconYAxisColor(value: Color) -> None: ...
    @WorldCoordIconZAxisColor.setter
    def WorldCoordIconZAxisColor(value: Color) -> None: ...
    @overload
    def SetPaintColor(whichColor: PaintColor, c: Color) -> None: ...
    @overload
    def SetPaintColor(whichColor: PaintColor, c: Color, forceUiUpdate: bool) -> None: ...
    @overload
    def SetWidgetColor(whichColor: WidgetColor, c: Color) -> None: ...
    @overload
    def SetWidgetColor(whichColor: WidgetColor, c: Color, forceUiUpdate: bool) -> None: ...
    def UpdateFromState(state: AppearanceSettingsState) -> None: ...


class AppearanceSettingsState:
    @property
    def CommandPromptBackgroundColor(self) -> Color: ...
    @property
    def CommandPromptFontSize(self) -> int: ...
    @property
    def CommandPromptHypertextColor(self) -> Color: ...
    @property
    def CommandPromptTextColor(self) -> Color: ...
    @property
    def CrosshairColor(self) -> Color: ...
    @property
    def CurrentLayerBackgroundColor(self) -> Color: ...
    @property
    def DefaultFontFaceName(self) -> str: ...
    @property
    def DefaultLayerColor(self) -> Color: ...
    @property
    def DefaultObjectColor(self) -> Color: ...
    @property
    def EchoCommandsToHistoryWindow(self) -> bool: ...
    @property
    def EchoPromptsToHistoryWindow(self) -> bool: ...
    @property
    def EditCandidateColor(self) -> Color: ...
    @property
    def FeedbackColor(self) -> Color: ...
    @property
    def FrameBackgroundColor(self) -> Color: ...
    @property
    def GridThickLineColor(self) -> Color: ...
    @property
    def GridThinLineColor(self) -> Color: ...
    @property
    def GridXAxisLineColor(self) -> Color: ...
    @property
    def GridYAxisLineColor(self) -> Color: ...
    @property
    def GridZAxisLineColor(self) -> Color: ...
    @property
    def LockedObjectColor(self) -> Color: ...
    @property
    def PageviewPaperColor(self) -> Color: ...
    @property
    def SelectedObjectColor(self) -> Color: ...
    @property
    def SelectionWindowCrossingFillColor(self) -> Color: ...
    @property
    def SelectionWindowCrossingStrokeColor(self) -> Color: ...
    @property
    def SelectionWindowFillColor(self) -> Color: ...
    @property
    def SelectionWindowStrokeColor(self) -> Color: ...
    @property
    def ShowCrosshairs(self) -> bool: ...
    @property
    def ShowFullPathInTitleBar(self) -> bool: ...
    @property
    def TrackingColor(self) -> Color: ...
    @property
    def ViewportBackgroundColor(self) -> Color: ...
    @property
    def WorldCoordIconXAxisColor(self) -> Color: ...
    @property
    def WorldCoordIconYAxisColor(self) -> Color: ...
    @property
    def WorldCoordIconZAxisColor(self) -> Color: ...
    @CommandPromptBackgroundColor.setter
    def CommandPromptBackgroundColor(self, value: Color) -> None: ...
    @CommandPromptFontSize.setter
    def CommandPromptFontSize(self, value: int) -> None: ...
    @CommandPromptHypertextColor.setter
    def CommandPromptHypertextColor(self, value: Color) -> None: ...
    @CommandPromptTextColor.setter
    def CommandPromptTextColor(self, value: Color) -> None: ...
    @CrosshairColor.setter
    def CrosshairColor(self, value: Color) -> None: ...
    @CurrentLayerBackgroundColor.setter
    def CurrentLayerBackgroundColor(self, value: Color) -> None: ...
    @DefaultFontFaceName.setter
    def DefaultFontFaceName(self, value: str) -> None: ...
    @DefaultLayerColor.setter
    def DefaultLayerColor(self, value: Color) -> None: ...
    @DefaultObjectColor.setter
    def DefaultObjectColor(self, value: Color) -> None: ...
    @EchoCommandsToHistoryWindow.setter
    def EchoCommandsToHistoryWindow(self, value: bool) -> None: ...
    @EchoPromptsToHistoryWindow.setter
    def EchoPromptsToHistoryWindow(self, value: bool) -> None: ...
    @EditCandidateColor.setter
    def EditCandidateColor(self, value: Color) -> None: ...
    @FeedbackColor.setter
    def FeedbackColor(self, value: Color) -> None: ...
    @FrameBackgroundColor.setter
    def FrameBackgroundColor(self, value: Color) -> None: ...
    @GridThickLineColor.setter
    def GridThickLineColor(self, value: Color) -> None: ...
    @GridThinLineColor.setter
    def GridThinLineColor(self, value: Color) -> None: ...
    @GridXAxisLineColor.setter
    def GridXAxisLineColor(self, value: Color) -> None: ...
    @GridYAxisLineColor.setter
    def GridYAxisLineColor(self, value: Color) -> None: ...
    @GridZAxisLineColor.setter
    def GridZAxisLineColor(self, value: Color) -> None: ...
    @LockedObjectColor.setter
    def LockedObjectColor(self, value: Color) -> None: ...
    @PageviewPaperColor.setter
    def PageviewPaperColor(self, value: Color) -> None: ...
    @SelectedObjectColor.setter
    def SelectedObjectColor(self, value: Color) -> None: ...
    @SelectionWindowCrossingFillColor.setter
    def SelectionWindowCrossingFillColor(self, value: Color) -> None: ...
    @SelectionWindowCrossingStrokeColor.setter
    def SelectionWindowCrossingStrokeColor(self, value: Color) -> None: ...
    @SelectionWindowFillColor.setter
    def SelectionWindowFillColor(self, value: Color) -> None: ...
    @SelectionWindowStrokeColor.setter
    def SelectionWindowStrokeColor(self, value: Color) -> None: ...
    @ShowCrosshairs.setter
    def ShowCrosshairs(self, value: bool) -> None: ...
    @ShowFullPathInTitleBar.setter
    def ShowFullPathInTitleBar(self, value: bool) -> None: ...
    @TrackingColor.setter
    def TrackingColor(self, value: Color) -> None: ...
    @ViewportBackgroundColor.setter
    def ViewportBackgroundColor(self, value: Color) -> None: ...
    @WorldCoordIconXAxisColor.setter
    def WorldCoordIconXAxisColor(self, value: Color) -> None: ...
    @WorldCoordIconYAxisColor.setter
    def WorldCoordIconYAxisColor(self, value: Color) -> None: ...
    @WorldCoordIconZAxisColor.setter
    def WorldCoordIconZAxisColor(self, value: Color) -> None: ...


class ClipboardState:
    KeepData = 0
    DeleteData = 1
    PromptWhenBig = 2


class CommandAliasList:
    def Add(alias: str, macro: str) -> bool: ...
    def Clear() -> None: ...
    def Delete(alias: str) -> bool: ...
    @property
    def Count() -> int: ...
    def GetDefaults() -> Dictionary: ...
    def GetMacro(alias: str) -> str: ...
    def GetNames() -> Set(str): ...
    def IsAlias(alias: str) -> bool: ...
    def IsDefault() -> bool: ...
    def SetMacro(alias: str, macro: str) -> bool: ...
    def ToDictionary() -> Dictionary: ...


class CommandPromptPosition:
    Top = 0
    Bottom = 1
    Floating = 2
    Hidden = 3


class CursorMode:
    #None = 0
    BlackOnWhite = 1
    WhiteOnBlack = 2


class CursorTooltipSettings:
    @property
    def AutoSuppress() -> bool: ...
    @property
    def BackgroundColor() -> Color: ...
    @property
    def CommandPromptPane() -> bool: ...
    @property
    def DistancePane() -> bool: ...
    @property
    def Offset() -> Point: ...
    @property
    def OsnapPane() -> bool: ...
    @property
    def PointPane() -> bool: ...
    @property
    def RelativePointPane() -> bool: ...
    @property
    def TextColor() -> Color: ...
    @property
    def TooltipsEnabled() -> bool: ...
    def GetCurrentState() -> CursorTooltipSettingsState: ...
    def GetDefaultState() -> CursorTooltipSettingsState: ...
    @AutoSuppress.setter
    def AutoSuppress(value: bool) -> None: ...
    @BackgroundColor.setter
    def BackgroundColor(value: Color) -> None: ...
    @CommandPromptPane.setter
    def CommandPromptPane(value: bool) -> None: ...
    @DistancePane.setter
    def DistancePane(value: bool) -> None: ...
    @Offset.setter
    def Offset(value: Point) -> None: ...
    @OsnapPane.setter
    def OsnapPane(value: bool) -> None: ...
    @PointPane.setter
    def PointPane(value: bool) -> None: ...
    @RelativePointPane.setter
    def RelativePointPane(value: bool) -> None: ...
    @TextColor.setter
    def TextColor(value: Color) -> None: ...
    @TooltipsEnabled.setter
    def TooltipsEnabled(value: bool) -> None: ...


class CursorTooltipSettingsState:
    def __init__(self): ...
    @property
    def AutoSuppress(self) -> bool: ...
    @property
    def BackgroundColor(self) -> Color: ...
    @property
    def CommandPromptPane(self) -> bool: ...
    @property
    def DistancePane(self) -> bool: ...
    @property
    def Offset(self) -> Point: ...
    @property
    def OsnapPane(self) -> bool: ...
    @property
    def PointPane(self) -> bool: ...
    @property
    def RelativePointPane(self) -> bool: ...
    @property
    def TextColor(self) -> Color: ...
    @property
    def TooltipsEnabled(self) -> bool: ...
    @AutoSuppress.setter
    def AutoSuppress(self, value: bool) -> None: ...
    @BackgroundColor.setter
    def BackgroundColor(self, value: Color) -> None: ...
    @CommandPromptPane.setter
    def CommandPromptPane(self, value: bool) -> None: ...
    @DistancePane.setter
    def DistancePane(self, value: bool) -> None: ...
    @Offset.setter
    def Offset(self, value: Point) -> None: ...
    @OsnapPane.setter
    def OsnapPane(self, value: bool) -> None: ...
    @PointPane.setter
    def PointPane(self, value: bool) -> None: ...
    @RelativePointPane.setter
    def RelativePointPane(self, value: bool) -> None: ...
    @TextColor.setter
    def TextColor(self, value: Color) -> None: ...
    @TooltipsEnabled.setter
    def TooltipsEnabled(self, value: bool) -> None: ...


class CurvatureAnalysisSettings:
    def CalculateCurvatureAutoRange(meshes: Iterable[Mesh], settings: CurvatureAnalysisSettingsState) -> Tuple[bool, CurvatureAnalysisSettingsState]: ...
    @property
    def GaussRange() -> Interval: ...
    @property
    def MaxRadiusRange() -> Interval: ...
    @property
    def MeanRange() -> Interval: ...
    @property
    def MinRadiusRange() -> Interval: ...
    @property
    def Style() -> CurvatureStyle: ...
    def GetCurrentState() -> CurvatureAnalysisSettingsState: ...
    def GetDefaultState() -> CurvatureAnalysisSettingsState: ...
    def RestoreDefaults() -> None: ...
    @GaussRange.setter
    def GaussRange(value: Interval) -> None: ...
    @MaxRadiusRange.setter
    def MaxRadiusRange(value: Interval) -> None: ...
    @MeanRange.setter
    def MeanRange(value: Interval) -> None: ...
    @MinRadiusRange.setter
    def MinRadiusRange(value: Interval) -> None: ...
    @Style.setter
    def Style(value: CurvatureStyle) -> None: ...
    def UpdateFromState(state: CurvatureAnalysisSettingsState) -> None: ...


class CurvatureAnalysisSettingsState:
    @property
    def GaussRange(self) -> Interval: ...
    @property
    def MaxRadiusRange(self) -> Interval: ...
    @property
    def MeanRange(self) -> Interval: ...
    @property
    def MinRadiusRange(self) -> Interval: ...
    @property
    def Style(self) -> CurvatureStyle: ...
    @GaussRange.setter
    def GaussRange(self, value: Interval) -> None: ...
    @MaxRadiusRange.setter
    def MaxRadiusRange(self, value: Interval) -> None: ...
    @MeanRange.setter
    def MeanRange(self, value: Interval) -> None: ...
    @MinRadiusRange.setter
    def MinRadiusRange(self, value: Interval) -> None: ...
    @Style.setter
    def Style(self, value: CurvatureStyle) -> None: ...


class CurvatureStyle:
    Gaussian = 0
    Mean = 1
    MinRadius = 2
    MaxRadius = 3


class DraftAngleAnalysisSettings:
    @property
    def AngleRange() -> Interval: ...
    @property
    def ShowIsoCurves() -> bool: ...
    @property
    def UpDirection() -> Vector3d: ...
    def GetCurrentState() -> DraftAngleAnalysisSettingsState: ...
    def GetDefaultState() -> DraftAngleAnalysisSettingsState: ...
    def RestoreDefaults() -> None: ...
    @AngleRange.setter
    def AngleRange(value: Interval) -> None: ...
    @ShowIsoCurves.setter
    def ShowIsoCurves(value: bool) -> None: ...
    @UpDirection.setter
    def UpDirection(value: Vector3d) -> None: ...
    def UpdateFromState(state: DraftAngleAnalysisSettingsState) -> None: ...


class DraftAngleAnalysisSettingsState:
    @property
    def AngleRange(self) -> Interval: ...
    @property
    def ShowIsoCurves(self) -> bool: ...
    @property
    def UpDirection(self) -> Vector3d: ...
    @AngleRange.setter
    def AngleRange(self, value: Interval) -> None: ...
    @ShowIsoCurves.setter
    def ShowIsoCurves(self, value: bool) -> None: ...
    @UpDirection.setter
    def UpDirection(self, value: Vector3d) -> None: ...


class EdgeAnalysisSettings:
    @property
    def ShowEdgeColor() -> Color: ...
    @property
    def ShowEdges() -> int: ...
    def GetCurrentState() -> EdgeAnalysisSettingsState: ...
    def GetDefaultState() -> EdgeAnalysisSettingsState: ...
    def RestoreDefaults() -> None: ...
    @ShowEdgeColor.setter
    def ShowEdgeColor(value: Color) -> None: ...
    @ShowEdges.setter
    def ShowEdges(value: int) -> None: ...
    def UpdateFromState(state: EdgeAnalysisSettingsState) -> None: ...


class EdgeAnalysisSettingsState:
    @property
    def ShowEdgeColor(self) -> Color: ...
    @property
    def ShowEdges(self) -> int: ...
    @ShowEdgeColor.setter
    def ShowEdgeColor(self, value: Color) -> None: ...
    @ShowEdges.setter
    def ShowEdges(self, value: int) -> None: ...


class FileSettings:
    def AddSearchPath(folder: str, index: int) -> int: ...
    def AutoSaveBeforeCommands() -> Set(str): ...
    def DeleteSearchPath(folder: str) -> bool: ...
    def FindFile(fileName: str) -> str: ...
    @property
    def AutoSaveEnabled() -> bool: ...
    @property
    def AutoSaveFile() -> str: ...
    @property
    def AutoSaveInterval() -> TimeSpan: ...
    @property
    def AutoSaveMeshes() -> bool: ...
    @property
    def ClipboardCopyToPreviousRhinoVersion() -> bool: ...
    @property
    def ClipboardOnExit() -> ClipboardState: ...
    @property
    def CreateBackupFiles() -> bool: ...
    @property
    def DefaultRuiFile() -> str: ...
    @property
    def ExecutableFolder() -> str: ...
    @property
    def FileLockingEnabled() -> bool: ...
    @property
    def FileLockingOpenWarning() -> bool: ...
    @property
    def HelpFilePath() -> str: ...
    @property
    def InstallFolder() -> DirectoryInfo: ...
    @property
    def LocalProfileDataFolder() -> str: ...
    @property
    def SaveViewChanges() -> bool: ...
    @property
    def SearchPathCount() -> int: ...
    @property
    def TemplateFile() -> str: ...
    @property
    def TemplateFolder() -> str: ...
    @property
    def WorkingFolder() -> str: ...
    def GetCurrentState() -> FileSettingsState: ...
    def GetDataFolder(currentUser: bool) -> str: ...
    def GetDefaultState() -> FileSettingsState: ...
    def GetSearchPaths() -> Set(str): ...
    def RecentlyOpenedFiles() -> Set(str): ...
    @AutoSaveEnabled.setter
    def AutoSaveEnabled(value: bool) -> None: ...
    @AutoSaveFile.setter
    def AutoSaveFile(value: str) -> None: ...
    @AutoSaveInterval.setter
    def AutoSaveInterval(value: TimeSpan) -> None: ...
    @AutoSaveMeshes.setter
    def AutoSaveMeshes(value: bool) -> None: ...
    @ClipboardCopyToPreviousRhinoVersion.setter
    def ClipboardCopyToPreviousRhinoVersion(value: bool) -> None: ...
    @ClipboardOnExit.setter
    def ClipboardOnExit(value: ClipboardState) -> None: ...
    @CreateBackupFiles.setter
    def CreateBackupFiles(value: bool) -> None: ...
    @FileLockingEnabled.setter
    def FileLockingEnabled(value: bool) -> None: ...
    @FileLockingOpenWarning.setter
    def FileLockingOpenWarning(value: bool) -> None: ...
    @SaveViewChanges.setter
    def SaveViewChanges(value: bool) -> None: ...
    @TemplateFile.setter
    def TemplateFile(value: str) -> None: ...
    @TemplateFolder.setter
    def TemplateFolder(value: str) -> None: ...
    @WorkingFolder.setter
    def WorkingFolder(value: str) -> None: ...
    def SetAutoSaveBeforeCommands(commands: Set(str)) -> None: ...


class FileSettingsState:
    @property
    def AutoSaveEnabled(self) -> bool: ...
    @property
    def AutoSaveInterval(self) -> TimeSpan: ...
    @property
    def AutoSaveMeshes(self) -> bool: ...
    @property
    def ClipboardCopyToPreviousRhinoVersion(self) -> bool: ...
    @property
    def ClipboardOnExit(self) -> ClipboardState: ...
    @property
    def CreateBackupFiles(self) -> bool: ...
    @property
    def FileLockingEnabled(self) -> bool: ...
    @property
    def FileLockingOpenWarning(self) -> bool: ...
    @property
    def SaveViewChanges(self) -> bool: ...
    @AutoSaveEnabled.setter
    def AutoSaveEnabled(self, value: bool) -> None: ...
    @AutoSaveInterval.setter
    def AutoSaveInterval(self, value: TimeSpan) -> None: ...
    @AutoSaveMeshes.setter
    def AutoSaveMeshes(self, value: bool) -> None: ...
    @ClipboardCopyToPreviousRhinoVersion.setter
    def ClipboardCopyToPreviousRhinoVersion(self, value: bool) -> None: ...
    @ClipboardOnExit.setter
    def ClipboardOnExit(self, value: ClipboardState) -> None: ...
    @CreateBackupFiles.setter
    def CreateBackupFiles(self, value: bool) -> None: ...
    @FileLockingEnabled.setter
    def FileLockingEnabled(self, value: bool) -> None: ...
    @FileLockingOpenWarning.setter
    def FileLockingOpenWarning(self, value: bool) -> None: ...
    @SaveViewChanges.setter
    def SaveViewChanges(self, value: bool) -> None: ...


class GeneralSettings:
    @property
    def AutoUpdateCommandHelp() -> bool: ...
    @property
    def ContextMenuDelay() -> TimeSpan: ...
    @property
    def EnableContextMenu() -> bool: ...
    @property
    def MaximumPopupMenuLines() -> int: ...
    @property
    def MaximumUndoMemoryMb() -> int: ...
    @property
    def MiddleMouseMacro() -> str: ...
    @property
    def MiddleMouseMode() -> MiddleMouseMode: ...
    @property
    def MiddleMousePopupToolbar() -> str: ...
    @property
    def MinimumUndoSteps() -> int: ...
    @property
    def MouseSelectMode() -> MouseSelectMode: ...
    @property
    def NewObjectIsoparmCount() -> int: ...
    @property
    def UseExtrusions() -> bool: ...
    def GetCurrentState() -> GeneralSettingsState: ...
    def GetDefaultState() -> GeneralSettingsState: ...
    @AutoUpdateCommandHelp.setter
    def AutoUpdateCommandHelp(value: bool) -> None: ...
    @ContextMenuDelay.setter
    def ContextMenuDelay(value: TimeSpan) -> None: ...
    @EnableContextMenu.setter
    def EnableContextMenu(value: bool) -> None: ...
    @MaximumPopupMenuLines.setter
    def MaximumPopupMenuLines(value: int) -> None: ...
    @MaximumUndoMemoryMb.setter
    def MaximumUndoMemoryMb(value: int) -> None: ...
    @MiddleMouseMacro.setter
    def MiddleMouseMacro(value: str) -> None: ...
    @MiddleMouseMode.setter
    def MiddleMouseMode(value: MiddleMouseMode) -> None: ...
    @MiddleMousePopupToolbar.setter
    def MiddleMousePopupToolbar(value: str) -> None: ...
    @MinimumUndoSteps.setter
    def MinimumUndoSteps(value: int) -> None: ...
    @MouseSelectMode.setter
    def MouseSelectMode(value: MouseSelectMode) -> None: ...
    @NewObjectIsoparmCount.setter
    def NewObjectIsoparmCount(value: int) -> None: ...


class GeneralSettingsState:
    @property
    def AutoUpdateCommandHelp(self) -> bool: ...
    @property
    def ContextMenuDelay(self) -> TimeSpan: ...
    @property
    def EnableContextMenu(self) -> bool: ...
    @property
    def MaximumPopupMenuLines(self) -> int: ...
    @property
    def MaximumUndoMemoryMb(self) -> int: ...
    @property
    def MiddleMouseMacro(self) -> str: ...
    @property
    def MiddleMouseMode(self) -> MiddleMouseMode: ...
    @property
    def MiddleMousePopupToolbar(self) -> str: ...
    @property
    def MinimumUndoSteps(self) -> int: ...
    @property
    def MouseSelectMode(self) -> MouseSelectMode: ...
    @property
    def NewObjectIsoparmCount(self) -> int: ...
    @AutoUpdateCommandHelp.setter
    def AutoUpdateCommandHelp(self, value: bool) -> None: ...
    @ContextMenuDelay.setter
    def ContextMenuDelay(self, value: TimeSpan) -> None: ...
    @EnableContextMenu.setter
    def EnableContextMenu(self, value: bool) -> None: ...
    @MaximumPopupMenuLines.setter
    def MaximumPopupMenuLines(self, value: int) -> None: ...
    @MaximumUndoMemoryMb.setter
    def MaximumUndoMemoryMb(self, value: int) -> None: ...
    @MiddleMouseMacro.setter
    def MiddleMouseMacro(self, value: str) -> None: ...
    @MiddleMouseMode.setter
    def MiddleMouseMode(self, value: MiddleMouseMode) -> None: ...
    @MiddleMousePopupToolbar.setter
    def MiddleMousePopupToolbar(self, value: str) -> None: ...
    @MinimumUndoSteps.setter
    def MinimumUndoSteps(self, value: int) -> None: ...
    @MouseSelectMode.setter
    def MouseSelectMode(self, value: MouseSelectMode) -> None: ...
    @NewObjectIsoparmCount.setter
    def NewObjectIsoparmCount(self, value: int) -> None: ...


class HistorySettings:
    @property
    def BrokenRecordWarningEnabled() -> bool: ...
    @property
    def ObjectLockingEnabled() -> bool: ...
    @property
    def RecordingEnabled() -> bool: ...
    @property
    def UpdateEnabled() -> bool: ...
    @BrokenRecordWarningEnabled.setter
    def BrokenRecordWarningEnabled(value: bool) -> None: ...
    @ObjectLockingEnabled.setter
    def ObjectLockingEnabled(value: bool) -> None: ...
    @RecordingEnabled.setter
    def RecordingEnabled(value: bool) -> None: ...
    @UpdateEnabled.setter
    def UpdateEnabled(value: bool) -> None: ...


class Installation:
    Undefined = 0
    Commercial = 1
    Educational = 2
    EducationalLab = 3
    NotForResale = 4
    NotForResaleLab = 5
    Beta = 6
    BetaLab = 7
    Evaluation = 8
    Corporate = 9
    EvaluationTimed = 10


class LicenseNode:
    Standalone = 0
    Network = 1
    NetworkCheckedOut = 2


class MiddleMouseMode:
    PopupMenu = 0
    PopupToolbar = 1
    RunMacro = 2


class ModelAidSettings:
    @property
    def AltPlusArrow() -> bool: ...
    @property
    def AutoGumballEnabled() -> bool: ...
    @property
    def ControlPolygonDisplayDensity() -> int: ...
    @property
    def CtrlNudgeKeyStep() -> float: ...
    @property
    def DisplayControlPolygon() -> bool: ...
    @property
    def ExtendToApparentIntersection() -> bool: ...
    @property
    def ExtendTrimLines() -> bool: ...
    @property
    def GridSnap() -> bool: ...
    @property
    def HighlightControlPolygon() -> bool: ...
    @property
    def MousePickboxRadius() -> int: ...
    @property
    def NudgeKeyStep() -> float: ...
    @property
    def NudgeMode() -> int: ...
    @property
    def Ortho() -> bool: ...
    @property
    def OrthoAngle() -> float: ...
    @property
    def Osnap() -> bool: ...
    @property
    def OsnapCursorMode() -> CursorMode: ...
    @property
    def OsnapModes() -> OsnapModes: ...
    @property
    def OsnapPickboxRadius() -> int: ...
    @property
    def Planar() -> bool: ...
    @property
    def PointDisplay() -> PointDisplayMode: ...
    @property
    def ProjectSnapToCPlane() -> bool: ...
    @property
    def ShiftNudgeKeyStep() -> float: ...
    @property
    def SnappyGumballEnabled() -> bool: ...
    @property
    def SnapToLocked() -> bool: ...
    @property
    def UniversalConstructionPlaneMode() -> bool: ...
    @property
    def UseHorizontalDialog() -> bool: ...
    def GetCurrentState() -> ModelAidSettingsState: ...
    def GetDefaultState() -> ModelAidSettingsState: ...
    @AltPlusArrow.setter
    def AltPlusArrow(value: bool) -> None: ...
    @AutoGumballEnabled.setter
    def AutoGumballEnabled(value: bool) -> None: ...
    @ControlPolygonDisplayDensity.setter
    def ControlPolygonDisplayDensity(value: int) -> None: ...
    @CtrlNudgeKeyStep.setter
    def CtrlNudgeKeyStep(value: float) -> None: ...
    @DisplayControlPolygon.setter
    def DisplayControlPolygon(value: bool) -> None: ...
    @ExtendToApparentIntersection.setter
    def ExtendToApparentIntersection(value: bool) -> None: ...
    @ExtendTrimLines.setter
    def ExtendTrimLines(value: bool) -> None: ...
    @GridSnap.setter
    def GridSnap(value: bool) -> None: ...
    @HighlightControlPolygon.setter
    def HighlightControlPolygon(value: bool) -> None: ...
    @MousePickboxRadius.setter
    def MousePickboxRadius(value: int) -> None: ...
    @NudgeKeyStep.setter
    def NudgeKeyStep(value: float) -> None: ...
    @NudgeMode.setter
    def NudgeMode(value: int) -> None: ...
    @Ortho.setter
    def Ortho(value: bool) -> None: ...
    @OrthoAngle.setter
    def OrthoAngle(value: float) -> None: ...
    @Osnap.setter
    def Osnap(value: bool) -> None: ...
    @OsnapCursorMode.setter
    def OsnapCursorMode(value: CursorMode) -> None: ...
    @OsnapModes.setter
    def OsnapModes(value: OsnapModes) -> None: ...
    @OsnapPickboxRadius.setter
    def OsnapPickboxRadius(value: int) -> None: ...
    @Planar.setter
    def Planar(value: bool) -> None: ...
    @PointDisplay.setter
    def PointDisplay(value: PointDisplayMode) -> None: ...
    @ProjectSnapToCPlane.setter
    def ProjectSnapToCPlane(value: bool) -> None: ...
    @ShiftNudgeKeyStep.setter
    def ShiftNudgeKeyStep(value: float) -> None: ...
    @SnappyGumballEnabled.setter
    def SnappyGumballEnabled(value: bool) -> None: ...
    @SnapToLocked.setter
    def SnapToLocked(value: bool) -> None: ...
    @UniversalConstructionPlaneMode.setter
    def UniversalConstructionPlaneMode(value: bool) -> None: ...
    @UseHorizontalDialog.setter
    def UseHorizontalDialog(value: bool) -> None: ...
    def UpdateFromState(state: ModelAidSettingsState) -> None: ...


class ModelAidSettingsState:
    @property
    def AltPlusArrow(self) -> bool: ...
    @property
    def ControlPolygonDisplayDensity(self) -> int: ...
    @property
    def CtrlNudgeKeyStep(self) -> float: ...
    @property
    def DisplayControlPolygon(self) -> bool: ...
    @property
    def ExtendToApparentIntersection(self) -> bool: ...
    @property
    def ExtendTrimLines(self) -> bool: ...
    @property
    def GridSnap(self) -> bool: ...
    @property
    def HighlightControlPolygon(self) -> bool: ...
    @property
    def MousePickboxRadius(self) -> int: ...
    @property
    def NudgeKeyStep(self) -> float: ...
    @property
    def NudgeMode(self) -> int: ...
    @property
    def Ortho(self) -> bool: ...
    @property
    def OrthoAngle(self) -> float: ...
    @property
    def Osnap(self) -> bool: ...
    @property
    def OsnapCursorMode(self) -> CursorMode: ...
    @property
    def OsnapModes(self) -> OsnapModes: ...
    @property
    def OsnapPickboxRadius(self) -> int: ...
    @property
    def Planar(self) -> bool: ...
    @property
    def PointDisplay(self) -> PointDisplayMode: ...
    @property
    def ProjectSnapToCPlane(self) -> bool: ...
    @property
    def ShiftNudgeKeyStep(self) -> float: ...
    @property
    def SnapToLocked(self) -> bool: ...
    @property
    def UniversalConstructionPlaneMode(self) -> bool: ...
    @property
    def UseHorizontalDialog(self) -> bool: ...
    @AltPlusArrow.setter
    def AltPlusArrow(self, value: bool) -> None: ...
    @ControlPolygonDisplayDensity.setter
    def ControlPolygonDisplayDensity(self, value: int) -> None: ...
    @CtrlNudgeKeyStep.setter
    def CtrlNudgeKeyStep(self, value: float) -> None: ...
    @DisplayControlPolygon.setter
    def DisplayControlPolygon(self, value: bool) -> None: ...
    @ExtendToApparentIntersection.setter
    def ExtendToApparentIntersection(self, value: bool) -> None: ...
    @ExtendTrimLines.setter
    def ExtendTrimLines(self, value: bool) -> None: ...
    @GridSnap.setter
    def GridSnap(self, value: bool) -> None: ...
    @HighlightControlPolygon.setter
    def HighlightControlPolygon(self, value: bool) -> None: ...
    @MousePickboxRadius.setter
    def MousePickboxRadius(self, value: int) -> None: ...
    @NudgeKeyStep.setter
    def NudgeKeyStep(self, value: float) -> None: ...
    @NudgeMode.setter
    def NudgeMode(self, value: int) -> None: ...
    @Ortho.setter
    def Ortho(self, value: bool) -> None: ...
    @OrthoAngle.setter
    def OrthoAngle(self, value: float) -> None: ...
    @Osnap.setter
    def Osnap(self, value: bool) -> None: ...
    @OsnapCursorMode.setter
    def OsnapCursorMode(self, value: CursorMode) -> None: ...
    @OsnapModes.setter
    def OsnapModes(self, value: OsnapModes) -> None: ...
    @OsnapPickboxRadius.setter
    def OsnapPickboxRadius(self, value: int) -> None: ...
    @Planar.setter
    def Planar(self, value: bool) -> None: ...
    @PointDisplay.setter
    def PointDisplay(self, value: PointDisplayMode) -> None: ...
    @ProjectSnapToCPlane.setter
    def ProjectSnapToCPlane(self, value: bool) -> None: ...
    @ShiftNudgeKeyStep.setter
    def ShiftNudgeKeyStep(self, value: float) -> None: ...
    @SnapToLocked.setter
    def SnapToLocked(self, value: bool) -> None: ...
    @UniversalConstructionPlaneMode.setter
    def UniversalConstructionPlaneMode(self, value: bool) -> None: ...
    @UseHorizontalDialog.setter
    def UseHorizontalDialog(self, value: bool) -> None: ...


class MouseSelectMode:
    Crossing = 0
    Window = 1
    Combo = 2


class NeverRepeatList:
    def CommandNames() -> Set(str): ...
    @property
    def UseNeverRepeatList() -> bool: ...
    def SetList(commandNames: Set(str)) -> int: ...


class OpenGLSettings:
    def __init__(self): ...
    @property
    def AntialiasLevel() -> AntialiasLevel: ...
    def GetCurrentState() -> OpenGLSettingsState: ...
    def GetDefaultState() -> OpenGLSettingsState: ...
    def RestoreDefaults() -> None: ...
    @AntialiasLevel.setter
    def AntialiasLevel(value: AntialiasLevel) -> None: ...
    def UpdateFromState(state: OpenGLSettingsState) -> None: ...


class OpenGLSettingsState:
    @property
    def AntialiasLevel(self) -> AntialiasLevel: ...
    @AntialiasLevel.setter
    def AntialiasLevel(self, value: AntialiasLevel) -> None: ...


class OsnapModes:
    #None = 0
    Near = 2
    Focus = 8
    Center = 32
    Vertex = 64
    Knot = 128
    Quadrant = 512
    Midpoint = 2048
    Intersection = 8192
    End = 131072
    Perpendicular = 524288
    Tangent = 2097152
    Point = 134217728


class PackageManagerSettings:
    @property
    def Sources() -> str: ...
    @Sources.setter
    def Sources(value: str) -> None: ...


class PaintColor:
    NormalStart = 0
    NormalEnd = 1
    NormalBorder = 2
    HotStart = 3
    HotEnd = 4
    HotBorder = 5
    PressedStart = 6
    PressedEnd = 7
    PressedBorder = 8
    TextEnabled = 9
    TextDisabled = 10
    MouseOverControlStart = 11
    MouseOverControlEnd = 12
    MouseOverControlBorder = 13
    ActiveCaption = 14
    InactiveCaption = 15
    PanelBackground = 16
    ActiveViewportTitle = 17
    InactiveViewportTitle = 18
    ModifiedValueControlColor = 19
    EditBoxBackground = 20
    GridLinesOnPanelBackground = 21
    GridLinesOnEditBoxBackground = 22
    InactiveTabBackground = 23


class PointDisplayMode:
    WorldPoint = 0
    CplanePoint = 1


class SelectionFilterSettings:
    @property
    def Enabled() -> bool: ...
    @property
    def GlobalGeometryFilter() -> ObjectType: ...
    @property
    def OneShotGeometryFilter() -> ObjectType: ...
    @property
    def SubObjectSelect() -> bool: ...
    def GetCurrentState() -> SelectionFilterSettingsState: ...
    def GetDefaultState() -> SelectionFilterSettingsState: ...
    def RestoreDefaults() -> None: ...
    @Enabled.setter
    def Enabled(value: bool) -> None: ...
    @GlobalGeometryFilter.setter
    def GlobalGeometryFilter(value: ObjectType) -> None: ...
    @OneShotGeometryFilter.setter
    def OneShotGeometryFilter(value: ObjectType) -> None: ...
    @SubObjectSelect.setter
    def SubObjectSelect(value: bool) -> None: ...
    def UpdateFromState(state: SelectionFilterSettingsState) -> None: ...


class SelectionFilterSettingsState:
    @property
    def Enabled(self) -> bool: ...
    @property
    def GlobalGeometryFilter(self) -> ObjectType: ...
    @property
    def OneShotGeometryFilter(self) -> ObjectType: ...
    @property
    def SubObjectSelect(self) -> bool: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @GlobalGeometryFilter.setter
    def GlobalGeometryFilter(self, value: ObjectType) -> None: ...
    @OneShotGeometryFilter.setter
    def OneShotGeometryFilter(self, value: ObjectType) -> None: ...
    @SubObjectSelect.setter
    def SubObjectSelect(self, value: bool) -> None: ...


class ShortcutKey:
    F1 = 0
    F2 = 1
    F3 = 2
    F4 = 3
    F5 = 4
    F6 = 5
    F7 = 6
    F8 = 7
    F9 = 8
    F10 = 9
    F11 = 10
    F12 = 11
    CtrlF1 = 12
    CtrlF2 = 13
    CtrlF3 = 14
    CtrlF4 = 15
    CtrlF5 = 16
    CtrlF6 = 17
    CtrlF7 = 18
    CtrlF8 = 19
    CtrlF9 = 20
    CtrlF10 = 21
    CtrlF11 = 22
    CtrlF12 = 23
    ShiftCtrlF1 = 24
    ShiftCtrlF2 = 25
    ShiftCtrlF3 = 26
    ShiftCtrlF4 = 27
    ShiftCtrlF5 = 28
    ShiftCtrlF6 = 29
    ShiftCtrlF7 = 30
    ShiftCtrlF8 = 31
    ShiftCtrlF9 = 32
    ShiftCtrlF10 = 33
    ShiftCtrlF11 = 34
    ShiftCtrlF12 = 35
    AltCtrlF1 = 36
    AltCtrlF2 = 37
    AltCtrlF3 = 38
    AltCtrlF4 = 39
    AltCtrlF5 = 40
    AltCtrlF6 = 41
    AltCtrlF7 = 42
    AltCtrlF8 = 43
    AltCtrlF9 = 44
    AltCtrlF10 = 45
    AltCtrlF11 = 46
    AltCtrlF12 = 47
    CtrlA = 48
    CtrlB = 49
    CtrlC = 50
    CtrlD = 51
    CtrlE = 52
    CtrlF = 53
    CtrlG = 54
    CtrlH = 55
    CtrlI = 56
    CtrlJ = 57
    CtrlK = 58
    CtrlL = 59
    CtrlM = 60
    CtrlN = 61
    CtrlO = 62
    CtrlP = 63
    CtrlQ = 64
    CtrlR = 65
    CtrlS = 66
    CtrlT = 67
    CtrlU = 68
    CtrlV = 69
    CtrlW = 70
    CtrlX = 71
    CtrlY = 72
    CtrlZ = 73
    ShiftCtrlA = 74
    ShiftCtrlB = 75
    ShiftCtrlC = 76
    ShiftCtrlD = 77
    ShiftCtrlE = 78
    ShiftCtrlF = 79
    ShiftCtrlG = 80
    ShiftCtrlH = 81
    ShiftCtrlI = 82
    ShiftCtrlJ = 83
    ShiftCtrlK = 84
    ShiftCtrlL = 85
    ShiftCtrlM = 86
    ShiftCtrlN = 87
    ShiftCtrlO = 88
    ShiftCtrlP = 89
    ShiftCtrlQ = 90
    ShiftCtrlR = 91
    ShiftCtrlS = 92
    ShiftCtrlT = 93
    ShiftCtrlU = 94
    ShiftCtrlV = 95
    ShiftCtrlW = 96
    ShiftCtrlX = 97
    ShiftCtrlY = 98
    ShiftCtrlZ = 99
    AltCtrlA = 100
    AltCtrlB = 101
    AltCtrlC = 102
    AltCtrlD = 103
    AltCtrlE = 104
    AltCtrlF = 105
    AltCtrlG = 106
    AltCtrlH = 107
    AltCtrlI = 108
    AltCtrlJ = 109
    AltCtrlK = 110
    AltCtrlL = 111
    AltCtrlM = 112
    AltCtrlN = 113
    AltCtrlO = 114
    AltCtrlP = 115
    AltCtrlQ = 116
    AltCtrlR = 117
    AltCtrlS = 118
    AltCtrlT = 119
    AltCtrlU = 120
    AltCtrlV = 121
    AltCtrlW = 122
    AltCtrlX = 123
    AltCtrlY = 124
    AltCtrlZ = 125
    Ctrl0 = 126
    Ctrl1 = 127
    Ctrl2 = 128
    Ctrl3 = 129
    Ctrl4 = 130
    Ctrl5 = 131
    Ctrl6 = 132
    Ctrl7 = 133
    Ctrl8 = 134
    Ctrl9 = 135
    ShiftCtrl0 = 136
    ShiftCtrl1 = 137
    ShiftCtrl2 = 138
    ShiftCtrl3 = 139
    ShiftCtrl4 = 140
    ShiftCtrl5 = 141
    ShiftCtrl6 = 142
    ShiftCtrl7 = 143
    ShiftCtrl8 = 144
    ShiftCtrl9 = 145
    AltCtrl0 = 146
    AltCtrl1 = 147
    AltCtrl2 = 148
    AltCtrl3 = 149
    AltCtrl4 = 150
    AltCtrl5 = 151
    AltCtrl6 = 152
    AltCtrl7 = 153
    AltCtrl8 = 154
    AltCtrl9 = 155
    Home = 156
    End = 157
    CtrlHome = 158
    CtrlEnd = 159
    ShiftHome = 160
    ShiftEnd = 161
    ShiftCtrlHome = 162
    ShiftCtrlEnd = 163
    AltCtrlHome = 164
    AltCtrlEnd = 165
    PageUp = 166
    PageDown = 167
    ShiftPageUp = 168
    ShiftPageDown = 169
    CtrlPageUp = 170
    CtrlPageDown = 171
    ShiftCtrlPageUp = 172
    ShiftCtrlPageDown = 173
    AltCtrlPageUp = 174
    AltCtrlPageDown = 175


class ShortcutKeySettings:
    def GetMacro(key: ShortcutKey) -> str: ...
    def SetMacro(key: ShortcutKey, macro: str) -> None: ...


class SmartTrackSettings:
    @property
    def ActivationDelayMilliseconds() -> int: ...
    @property
    def ActivePointColor() -> Color: ...
    @property
    def LineColor() -> Color: ...
    @property
    def MaxSmartPoints() -> int: ...
    @property
    def PointColor() -> Color: ...
    @property
    def SmartOrtho() -> bool: ...
    @property
    def SmartTangents() -> bool: ...
    @property
    def TanPerpLineColor() -> Color: ...
    @property
    def UseDottedLines() -> bool: ...
    @property
    def UseSmartTrack() -> bool: ...
    def GetCurrentState() -> SmartTrackSettingsState: ...
    def GetDefaultState() -> SmartTrackSettingsState: ...
    @ActivationDelayMilliseconds.setter
    def ActivationDelayMilliseconds(value: int) -> None: ...
    @ActivePointColor.setter
    def ActivePointColor(value: Color) -> None: ...
    @LineColor.setter
    def LineColor(value: Color) -> None: ...
    @MaxSmartPoints.setter
    def MaxSmartPoints(value: int) -> None: ...
    @PointColor.setter
    def PointColor(value: Color) -> None: ...
    @SmartOrtho.setter
    def SmartOrtho(value: bool) -> None: ...
    @SmartTangents.setter
    def SmartTangents(value: bool) -> None: ...
    @TanPerpLineColor.setter
    def TanPerpLineColor(value: Color) -> None: ...
    @UseDottedLines.setter
    def UseDottedLines(value: bool) -> None: ...
    @UseSmartTrack.setter
    def UseSmartTrack(value: bool) -> None: ...
    def UpdateFromState(state: SmartTrackSettingsState) -> None: ...


class SmartTrackSettingsState:
    @property
    def ActivationDelayMilliseconds(self) -> int: ...
    @property
    def ActivePointColor(self) -> Color: ...
    @property
    def LineColor(self) -> Color: ...
    @property
    def MaxSmartPoints() -> int: ...
    @property
    def PointColor(self) -> Color: ...
    @property
    def SmartOrtho(self) -> bool: ...
    @property
    def SmartTangents(self) -> bool: ...
    @property
    def TanPerpLineColor(self) -> Color: ...
    @property
    def UseDottedLines(self) -> bool: ...
    @property
    def UseSmartTrack(self) -> bool: ...
    @ActivationDelayMilliseconds.setter
    def ActivationDelayMilliseconds(self, value: int) -> None: ...
    @ActivePointColor.setter
    def ActivePointColor(self, value: Color) -> None: ...
    @LineColor.setter
    def LineColor(self, value: Color) -> None: ...
    @MaxSmartPoints.setter
    def MaxSmartPoints(value: int) -> None: ...
    @PointColor.setter
    def PointColor(self, value: Color) -> None: ...
    @SmartOrtho.setter
    def SmartOrtho(self, value: bool) -> None: ...
    @SmartTangents.setter
    def SmartTangents(self, value: bool) -> None: ...
    @TanPerpLineColor.setter
    def TanPerpLineColor(self, value: Color) -> None: ...
    @UseDottedLines.setter
    def UseDottedLines(self, value: bool) -> None: ...
    @UseSmartTrack.setter
    def UseSmartTrack(self, value: bool) -> None: ...


class ViewSettings:
    @property
    def AlwaysPanParallelViews() -> bool: ...
    @property
    def DefinedViewSetCPlane() -> bool: ...
    @property
    def DefinedViewSetProjection() -> bool: ...
    @property
    def LinkedViewports() -> bool: ...
    @property
    def PanReverseKeyboardAction() -> bool: ...
    @property
    def PanScreenFraction() -> float: ...
    @property
    def RotateCircleIncrement() -> int: ...
    @property
    def RotateReverseKeyboard() -> bool: ...
    @property
    def RotateToView() -> bool: ...
    @property
    def SingleClickMaximize() -> bool: ...
    @property
    def ZoomExtentsParallelViewBorder() -> float: ...
    @property
    def ZoomExtentsPerspectiveViewBorder() -> float: ...
    @property
    def ZoomScale() -> float: ...
    def GetCurrentState() -> ViewSettingsState: ...
    def GetDefaultState() -> ViewSettingsState: ...
    def RestoreDefaults() -> None: ...
    @AlwaysPanParallelViews.setter
    def AlwaysPanParallelViews(value: bool) -> None: ...
    @DefinedViewSetCPlane.setter
    def DefinedViewSetCPlane(value: bool) -> None: ...
    @DefinedViewSetProjection.setter
    def DefinedViewSetProjection(value: bool) -> None: ...
    @LinkedViewports.setter
    def LinkedViewports(value: bool) -> None: ...
    @PanReverseKeyboardAction.setter
    def PanReverseKeyboardAction(value: bool) -> None: ...
    @PanScreenFraction.setter
    def PanScreenFraction(value: float) -> None: ...
    @RotateCircleIncrement.setter
    def RotateCircleIncrement(value: int) -> None: ...
    @RotateReverseKeyboard.setter
    def RotateReverseKeyboard(value: bool) -> None: ...
    @RotateToView.setter
    def RotateToView(value: bool) -> None: ...
    @SingleClickMaximize.setter
    def SingleClickMaximize(value: bool) -> None: ...
    @ZoomExtentsParallelViewBorder.setter
    def ZoomExtentsParallelViewBorder(value: float) -> None: ...
    @ZoomExtentsPerspectiveViewBorder.setter
    def ZoomExtentsPerspectiveViewBorder(value: float) -> None: ...
    @ZoomScale.setter
    def ZoomScale(value: float) -> None: ...
    def UpdateFromState(state: ViewSettingsState) -> None: ...


class ViewSettingsState:
    @property
    def AlwaysPanParallelViews(self) -> bool: ...
    @property
    def DefinedViewSetCPlane(self) -> bool: ...
    @property
    def DefinedViewSetProjection(self) -> bool: ...
    @property
    def LinkedViewports(self) -> bool: ...
    @property
    def PanReverseKeyboardAction(self) -> bool: ...
    @property
    def PanScreenFraction(self) -> float: ...
    @property
    def RotateCircleIncrement(self) -> int: ...
    @property
    def RotateReverseKeyboard(self) -> bool: ...
    @property
    def RotateToView(self) -> bool: ...
    @property
    def SingleClickMaximize(self) -> bool: ...
    @property
    def ZoomExtentsParallelViewBorder(self) -> float: ...
    @property
    def ZoomExtentsPerspectiveViewBorder(self) -> float: ...
    @property
    def ZoomScale(self) -> float: ...
    @AlwaysPanParallelViews.setter
    def AlwaysPanParallelViews(self, value: bool) -> None: ...
    @DefinedViewSetCPlane.setter
    def DefinedViewSetCPlane(self, value: bool) -> None: ...
    @DefinedViewSetProjection.setter
    def DefinedViewSetProjection(self, value: bool) -> None: ...
    @LinkedViewports.setter
    def LinkedViewports(self, value: bool) -> None: ...
    @PanReverseKeyboardAction.setter
    def PanReverseKeyboardAction(self, value: bool) -> None: ...
    @PanScreenFraction.setter
    def PanScreenFraction(self, value: float) -> None: ...
    @RotateCircleIncrement.setter
    def RotateCircleIncrement(self, value: int) -> None: ...
    @RotateReverseKeyboard.setter
    def RotateReverseKeyboard(self, value: bool) -> None: ...
    @RotateToView.setter
    def RotateToView(self, value: bool) -> None: ...
    @SingleClickMaximize.setter
    def SingleClickMaximize(self, value: bool) -> None: ...
    @ZoomExtentsParallelViewBorder.setter
    def ZoomExtentsParallelViewBorder(self, value: float) -> None: ...
    @ZoomExtentsPerspectiveViewBorder.setter
    def ZoomExtentsPerspectiveViewBorder(self, value: float) -> None: ...
    @ZoomScale.setter
    def ZoomScale(self, value: float) -> None: ...


class WidgetColor:
    UAxisColor = 0
    VAxisColor = 1
    WAxisColor = 2
