from typing import Tuple, Set, Iterable, List


class ArchivableDictionary:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, parentUserData: UserData): ...
    @overload
    def __init__(self, version: int): ...
    @overload
    def __init__(self, version: int, name: str): ...
    def AddContentsFrom(self, source: ArchivableDictionary) -> bool: ...
    def Clear(self) -> None: ...
    def Clone(self) -> ArchivableDictionary: ...
    def ContainsKey(self, key: str) -> bool: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, key: str) -> Object: ...
    @property
    def Keys(self) -> Set(str): ...
    @property
    def Name(self) -> str: ...
    @property
    def ParentUserData(self) -> UserData: ...
    @property
    def Values(self) -> Set(Object): ...
    @property
    def Version(self) -> int: ...
    @overload
    def GetBool(self, key: str) -> bool: ...
    @overload
    def GetBool(self, key: str, defaultValue: bool) -> bool: ...
    @overload
    def GetBytes(self, key: str) -> Set(Byte): ...
    @overload
    def GetBytes(self, key: str, defaultValue: Set(Byte)) -> Set(Byte): ...
    @overload
    def GetDictionary(self, key: str) -> ArchivableDictionary: ...
    @overload
    def GetDictionary(self, key: str, defaultValue: ArchivableDictionary) -> ArchivableDictionary: ...
    @overload
    def GetDouble(self, key: str) -> float: ...
    @overload
    def GetDouble(self, key: str, defaultValue: float) -> float: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def GetEnumValue(self) -> T: ...
    @overload
    def GetEnumValue(self, key: str) -> T: ...
    @overload
    def GetFloat(self, key: str) -> Single: ...
    @overload
    def GetFloat(self, key: str, defaultValue: Single) -> Single: ...
    @overload
    def GetGuid(self, key: str) -> Guid: ...
    @overload
    def GetGuid(self, key: str, defaultValue: Guid) -> Guid: ...
    def Getint(self, key: str, defaultValue: int) -> int: ...
    @overload
    def GetInteger(self, key: str) -> int: ...
    @overload
    def GetInteger(self, key: str, defaultValue: int) -> int: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    @overload
    def GetPlane(self, key: str) -> Plane: ...
    @overload
    def GetPlane(self, key: str, defaultValue: Plane) -> Plane: ...
    @overload
    def GetPoint3d(self, key: str) -> Point3d: ...
    @overload
    def GetPoint3d(self, key: str, defaultValue: Point3d) -> Point3d: ...
    @overload
    def GetPoint3f(self, key: str) -> Point3f: ...
    @overload
    def GetPoint3f(self, key: str, defaultValue: Point3f) -> Point3f: ...
    @overload
    def GetString(self, key: str) -> str: ...
    @overload
    def GetString(self, key: str, defaultValue: str) -> str: ...
    @overload
    def GetVector3d(self, key: str) -> Vector3d: ...
    @overload
    def GetVector3d(self, key: str, defaultValue: Vector3d) -> Vector3d: ...
    def Remove(self, key: str) -> bool: ...
    def RemoveEnumValue(self) -> bool: ...
    def ReplaceContentsWith(self, source: ArchivableDictionary) -> bool: ...
    @Item.setter
    def Item(self, key: str, value: Object) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @overload
    def Set(self, key: str, val: Point2d) -> bool: ...
    @overload
    def Set(self, key: str, val: Interval) -> bool: ...
    @overload
    def Set(self, key: str, val: Point3d) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[ObjRef]) -> bool: ...
    @overload
    def Set(self, key: str, val: SizeF) -> bool: ...
    @overload
    def Set(self, key: str, val: Point4d) -> bool: ...
    @overload
    def Set(self, key: str, val: Size) -> bool: ...
    @overload
    def Set(self, key: str, val: RectangleF) -> bool: ...
    @overload
    def Set(self, key: str, val: Rectangle) -> bool: ...
    @overload
    def Set(self, key: str, val: PointF) -> bool: ...
    @overload
    def Set(self, key: str, val: Point) -> bool: ...
    @overload
    def Set(self, key: str, val: Font) -> bool: ...
    @overload
    def Set(self, key: str, val: Vector2d) -> bool: ...
    @overload
    def Set(self, key: str, val: Line) -> bool: ...
    @overload
    def Set(self, key: str, val: BoundingBox) -> bool: ...
    @overload
    def Set(self, key: str, val: Ray3d) -> bool: ...
    @overload
    def Set(self, key: str, val: Transform) -> bool: ...
    @overload
    def Set(self, key: str, val: Plane) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[GeometryBase]) -> bool: ...
    @overload
    def Set(self, key: str, val: Point3f) -> bool: ...
    @overload
    def Set(self, key: str, val: Vector3f) -> bool: ...
    @overload
    def Set(self, key: str, val: ArchivableDictionary) -> bool: ...
    @overload
    def Set(self, key: str, val: MeshingParameters) -> bool: ...
    @overload
    def Set(self, key: str, val: GeometryBase) -> bool: ...
    @overload
    def Set(self, key: str, val: Color) -> bool: ...
    @overload
    def Set(self, key: str, val: ObjRef) -> bool: ...
    @overload
    def Set(self, key: str, val: Vector3d) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[str]) -> bool: ...
    @overload
    def Set(self, key: str, val: bool) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[float]) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[Guid]) -> bool: ...
    @overload
    def Set(self, key: str, val: Byte) -> bool: ...
    @overload
    def Set(self, key: str, val: SByte) -> bool: ...
    @overload
    def Set(self, key: str, val: Int16) -> bool: ...
    @overload
    def Set(self, key: str, val: UInt16) -> bool: ...
    @overload
    def Set(self, key: str, val: int) -> bool: ...
    @overload
    def Set(self, key: str, val: UInt32) -> bool: ...
    @overload
    def Set(self, key: str, val: Int64) -> bool: ...
    @overload
    def Set(self, key: str, val: Single) -> bool: ...
    @overload
    def Set(self, key: str, val: Guid) -> bool: ...
    @overload
    def Set(self, key: str, val: str) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[bool]) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[Byte]) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[SByte]) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[Int16]) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[int]) -> bool: ...
    @overload
    def Set(self, key: str, val: Iterable[Single]) -> bool: ...
    @overload
    def Set(self, key: str, val: float) -> bool: ...
    @Version.setter
    def Version(self, value: int) -> None: ...
    @overload
    def SetEnumValue(self, enumValue: T) -> bool: ...
    @overload
    def SetEnumValue(self, key: str, enumValue: T) -> bool: ...
    def TryGetBool(self, key: str) -> Tuple[bool, bool]: ...
    def TryGetBytes(self, key: str) -> Tuple[bool, Set(Byte)]: ...
    def TryGetDictionary(self, key: str) -> Tuple[bool, ArchivableDictionary]: ...
    def TryGetDouble(self, key: str) -> Tuple[bool, float]: ...
    def TryGetEnumValue(self, key: str) -> Tuple[bool, T]: ...
    def TryGetFloat(self, key: str) -> Tuple[bool, Single]: ...
    def TryGetGuid(self, key: str) -> Tuple[bool, Guid]: ...
    def TryGetInteger(self, key: str) -> Tuple[bool, int]: ...
    def TryGetPlane(self, key: str) -> Tuple[bool, Plane]: ...
    def TryGetPoint3d(self, key: str) -> Tuple[bool, Point3d]: ...
    def TryGetPoint3f(self, key: str) -> Tuple[bool, Point3f]: ...
    def TryGetString(self, key: str) -> Tuple[bool, str]: ...
    def TryGetValue(self, key: str) -> Tuple[bool, Object]: ...
    def TryGetVector3d(self, key: str) -> Tuple[bool, Vector3d]: ...


class CurveList:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initialCapacity: int): ...
    @overload
    def __init__(self, collection: Iterable[Curve]): ...
    @overload
    def Add(self, line: Line) -> None: ...
    @overload
    def Add(self, circle: Circle) -> None: ...
    @overload
    def Add(self, arc: Arc) -> None: ...
    @overload
    def Add(self, polyline: Iterable[Point3d]) -> None: ...
    @overload
    def Add(self, ellipse: Ellipse) -> None: ...
    @overload
    def Insert(self, index: int, arc: Arc) -> None: ...
    @overload
    def Insert(self, index: int, circle: Circle) -> None: ...
    @overload
    def Insert(self, index: int, polyline: Iterable[Point3d]) -> None: ...
    @overload
    def Insert(self, index: int, ellipse: Ellipse) -> None: ...
    @overload
    def Insert(self, index: int, line: Line) -> None: ...
    def Transform(self, xform: Transform) -> bool: ...




class Point3dList:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initialCapacity: int): ...
    @overload
    def __init__(self, collection: Iterable[Point3d]): ...
    @overload
    def __init__(self, initialPoints: Set(Point3d)): ...
    @overload
    def Add(self, x: float, y: float, z: float) -> None: ...
    def ClosestIndex(self, testPoint: Point3d) -> int: ...
    def ClosestIndexInList(list: List[Point3d], testPoint: Point3d) -> int: ...
    def ClosestPointInList(list: List[Point3d], testPoint: Point3d) -> Point3d: ...
    @overload
    def Duplicate(self) -> Point3dList: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, other: Point3dList) -> bool: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def X(self) -> XAccess: ...
    @property
    def Y(self) -> YAccess: ...
    @property
    def Z(self) -> ZAccess: ...
    def GetHashCode(self) -> int: ...
    def SetAllX(self, xValue: float) -> None: ...
    def SetAllY(self, yValue: float) -> None: ...
    def SetAllZ(self, zValue: float) -> None: ...
    def Transform(self, xform: Transform) -> None: ...


class RhinoList:
    def Point2dKNeighbors(hayPoints: Iterable[Point2d], needlePoints: Iterable[Point2d], amount: int) -> Iterable[Set(int)]: ...
    def Point2fKNeighbors(hayPoints: Iterable[Point2f], needlePoints: Iterable[Point2f], amount: int) -> Iterable[Set(int)]: ...
    def Point3dKNeighbors(hayPoints: Iterable[Point3d], needlePoints: Iterable[Point3d], amount: int) -> Iterable[Set(int)]: ...
    def Point3fKNeighbors(hayPoints: Iterable[Point3f], needlePoints: Iterable[Point3f], amount: int) -> Iterable[Set(int)]: ...
    def PointCloudKNeighbors(pointcloud: PointCloud, needlePoints: Iterable[Point3d], amount: int) -> Iterable[Set(int)]: ...




class TransformObjectList:
    def __init__(self): ...
    @overload
    def Add(self, rhinoObject: RhinoObject) -> None: ...
    @overload
    def Add(self, objref: ObjRef) -> None: ...
    def AddObjects(self, go: GetObject, allowGrips: bool) -> int: ...
    def Clear(self) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def DisplayFeedbackEnabled(self) -> bool: ...
    @property
    def GripCount(self) -> int: ...
    @property
    def GripOwnerCount(self) -> int: ...
    def GetBoundingBox(self, regularObjects: bool, grips: bool) -> BoundingBox: ...
    def GripArray(self) -> Set(GripObject): ...
    def GripOwnerArray(self) -> Set(RhinoObject): ...
    def ObjectArray(self) -> Set(RhinoObject): ...
    @DisplayFeedbackEnabled.setter
    def DisplayFeedbackEnabled(self, value: bool) -> None: ...
    def UpdateDisplayFeedbackTransform(self, xform: Transform) -> bool: ...


class XAccess:
    @property
    def Item(self, index: int) -> float: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...


class YAccess:
    @property
    def Item(self, index: int) -> float: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...


class ZAccess:
    @property
    def Item(self, index: int) -> float: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...
