from typing import Tuple, Set, Iterable, List


class Command:
    def add_BeginCommand(value: EventHandler) -> None: ...
    def add_EndCommand(value: EventHandler) -> None: ...
    def add_UndoRedo(value: EventHandler) -> None: ...
    def DisplayHelp(commandId: Guid) -> None: ...
    @property
    def EnglishName(self) -> str: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def LastCommandId() -> Guid: ...
    @property
    def LastCommandResult() -> Result: ...
    @property
    def LocalName(self) -> str: ...
    @property
    def PlugIn(self) -> PlugIn: ...
    @property
    def Settings(self) -> PersistentSettings: ...
    def GetCommandNames(english: bool, loaded: bool) -> Set(str): ...
    def GetCommandStack() -> Set(Guid): ...
    def GetMostRecentCommands() -> Set(MostRecentCommandDescription): ...
    def InCommand() -> bool: ...
    def InScriptRunnerCommand() -> bool: ...
    def IsCommand(name: str) -> bool: ...
    def IsValidCommandName(name: str) -> bool: ...
    def LookupCommandId(name: str, searchForEnglishName: bool) -> Guid: ...
    def LookupCommandName(commandId: Guid, englishName: bool) -> str: ...
    def remove_BeginCommand(value: EventHandler) -> None: ...
    def remove_EndCommand(value: EventHandler) -> None: ...
    def remove_UndoRedo(value: EventHandler) -> None: ...
    def RunProxyCommand(commandCallback: RunCommandDelegate, doc: RhinoDoc, data: Object) -> None: ...


class CommandEventArgs:
    @property
    def CommandEnglishName(self) -> str: ...
    @property
    def CommandId(self) -> Guid: ...
    @property
    def CommandLocalName(self) -> str: ...
    @property
    def CommandPluginName(self) -> str: ...
    @property
    def CommandResult(self) -> Result: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def DocumentRuntimeSerialNumber(self) -> UInt32: ...


class CommandStyleAttribute:
    def __init__(self, styles: Style): ...
    @property
    def Styles(self) -> Style: ...


class CustomUndoEventArgs:
    @property
    def ActionDescription(self) -> str: ...
    @property
    def CommandId(self) -> Guid: ...
    @property
    def CreatedByRedo(self) -> bool: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Tag(self) -> Object: ...
    @property
    def UndoSerialNumber(self) -> UInt32: ...


class MostRecentCommandDescription:
    def __init__(self): ...
    @property
    def DisplayString(self) -> str: ...
    @property
    def Macro(self) -> str: ...
    @DisplayString.setter
    def DisplayString(self, value: str) -> None: ...
    @Macro.setter
    def Macro(self, value: str) -> None: ...


class Result:
    Success = 0
    Cancel = 1
    Nothing = 2
    Failure = 3
    UnknownCommand = 4
    CancelModelessDialog = 5
    ExitRhino = 268435455


class RunCommandDelegate:
    def __init__(self, object: Object, method: IntPtr): ...
    def BeginInvoke(self, doc: RhinoDoc, mode: RunMode, data: Object, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> Result: ...
    def Invoke(self, doc: RhinoDoc, mode: RunMode, data: Object) -> Result: ...


class RunMode:
    Interactive = 0
    Scripted = 1


class SelCommand(Command):
    @property
    def BeQuiet(self) -> bool: ...
    @property
    def TestGrips(self) -> bool: ...
    @property
    def TestLights(self) -> bool: ...
    @BeQuiet.setter
    def BeQuiet(self, value: bool) -> None: ...
    @TestGrips.setter
    def TestGrips(self, value: bool) -> None: ...
    @TestLights.setter
    def TestLights(self, value: bool) -> None: ...


class Style:
    #None = 0
    Hidden = 1
    ScriptRunner = 2
    Transparent = 4
    DoNotRepeat = 8
    NotUndoable = 16


class TransformCommand(Command):
    pass


class UndoRedoEventArgs:
    @property
    def CommandId(self) -> Guid: ...
    @property
    def IsBeginRecording(self) -> bool: ...
    @property
    def IsBeginRedo(self) -> bool: ...
    @property
    def IsBeginUndo(self) -> bool: ...
    @property
    def IsEndRecording(self) -> bool: ...
    @property
    def IsEndRedo(self) -> bool: ...
    @property
    def IsEndUndo(self) -> bool: ...
    @property
    def IsPurgeRecord(self) -> bool: ...
    @property
    def UndoSerialNumber(self) -> UInt32: ...
