from typing import Tuple, Set, Iterable, List


class AnalysisStyle:
    Wireframe = 1
    Texture = 2
    FalseColor = 4


class AnchorLocation:
    LowerLeft = 0
    UpperLeft = 1
    LowerRight = 2
    UpperRight = 3
    Center = 4


class BackgroundStyle:
    SolidColor = 0
    WallpaperImage = 1
    Gradient = 2
    Environment = 3


class BlendMode:
    Zero = 0
    One = 1
    SourceColor = 768
    OneMinusSourceColor = 769
    SourceAlpha = 770
    OneMinusSourceAlpha = 771
    DestinationAlpha = 772
    OneMinusDestinationAlpha = 773
    DestinationColor = 774
    OneMinusDestinationColor = 775
    SourceAlphaSaturate = 776


class BoundingBoxDisplayMode:
    #None = 0
    OnAlways = 1
    OnDuringDynamicDisplay = 2


class CalculateBoundingBoxEventArgs(DrawEventArgs):
    @property
    def BoundingBox(self) -> BoundingBox: ...
    def IncludeBoundingBox(self, box: BoundingBox) -> None: ...


class Color4f:
    @overload
    def __init__(self, color: Color): ...
    @overload
    def __init__(self, color: Color4f): ...
    @overload
    def __init__(self, argb: int): ...
    @overload
    def __init__(self, red: Single, green: Single, blue: Single, alpha: Single): ...
    def ApplyGamma(col: Color4f, gamma: Single) -> Color4f: ...
    def AsSystemColor(self) -> Color: ...
    def BlendTo(self, t: Single, col: Color4f) -> Color4f: ...
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def FromArgb(a: Single, color: Color4f) -> Color4f: ...
    @overload
    def FromArgb(a: Single, r: Single, g: Single, b: Single) -> Color4f: ...
    @property
    def A(self) -> Single: ...
    @property
    def B(self) -> Single: ...
    @property
    def Black() -> Color4f: ...
    @property
    def Empty() -> Color4f: ...
    @property
    def G(self) -> Single: ...
    @property
    def L(self) -> Single: ...
    @property
    def R(self) -> Single: ...
    @property
    def White() -> Color4f: ...
    def GetHashCode(self) -> int: ...
    def op_Equality(a: Color4f, b: Color4f) -> bool: ...
    def op_Inequality(a: Color4f, b: Color4f) -> bool: ...


class ColorCMYK:
    @overload
    def __init__(self, rgb: Color): ...
    @overload
    def __init__(self, cyan: float, magenta: float, yellow: float): ...
    @overload
    def __init__(self, cyan: float, magenta: float, yellow: float, key: float): ...
    @overload
    def __init__(self, alpha: float, cyan: float, magenta: float, yellow: float, key: float): ...
    def CreateFromHSL(hsl: ColorHSL) -> ColorCMYK: ...
    def CreateFromHSV(hsv: ColorHSV) -> ColorCMYK: ...
    def CreateFromLAB(lab: ColorLAB) -> ColorCMYK: ...
    def CreateFromLCH(lch: ColorLCH) -> ColorCMYK: ...
    def CreateFromRGBA(rgba: ColorRGBA) -> ColorCMYK: ...
    def CreateFromXYZ(xyz: ColorXYZ) -> ColorCMYK: ...
    @property
    def A(self) -> float: ...
    @property
    def C(self) -> float: ...
    @property
    def K(self) -> float: ...
    @property
    def M(self) -> float: ...
    @property
    def Y(self) -> float: ...
    def op_Implicit(cmyk: ColorCMYK) -> Color: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @C.setter
    def C(self, value: float) -> None: ...
    @K.setter
    def K(self, value: float) -> None: ...
    @M.setter
    def M(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...


class ColorGradient:
    def __init__(self): ...
    @property
    def EndPoint(self) -> Point3d: ...
    @property
    def GradientType(self) -> GradientType: ...
    @property
    def Repeat(self) -> float: ...
    @property
    def StartPoint(self) -> Point3d: ...
    def GetColorStops(self) -> Set(ColorStop): ...
    @EndPoint.setter
    def EndPoint(self, value: Point3d) -> None: ...
    @GradientType.setter
    def GradientType(self, value: GradientType) -> None: ...
    @Repeat.setter
    def Repeat(self, value: float) -> None: ...
    @StartPoint.setter
    def StartPoint(self, value: Point3d) -> None: ...
    def SetColorStops(self, stops: Iterable[ColorStop]) -> None: ...


class ColorHSL:
    @overload
    def __init__(self, rgb: Color): ...
    @overload
    def __init__(self, hue: float, saturation: float, luminance: float): ...
    @overload
    def __init__(self, alpha: float, hue: float, saturation: float, luminance: float): ...
    def CreateFromCMYK(cmyk: ColorCMYK) -> ColorHSL: ...
    def CreateFromHSV(hsv: ColorHSV) -> ColorHSL: ...
    def CreateFromLAB(lab: ColorLAB) -> ColorHSL: ...
    def CreateFromLCH(lch: ColorLCH) -> ColorHSL: ...
    def CreateFromRGBA(rgba: ColorRGBA) -> ColorHSL: ...
    def CreateFromXYZ(xyz: ColorXYZ) -> ColorHSL: ...
    @property
    def A(self) -> float: ...
    @property
    def H(self) -> float: ...
    @property
    def L(self) -> float: ...
    @property
    def S(self) -> float: ...
    def op_Implicit(hsl: ColorHSL) -> Color: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @H.setter
    def H(self, value: float) -> None: ...
    @L.setter
    def L(self, value: float) -> None: ...
    @S.setter
    def S(self, value: float) -> None: ...
    def ToArgbColor(self) -> Color: ...


class ColorHSV:
    @overload
    def __init__(self, rgb: Color): ...
    @overload
    def __init__(self, hue: float, saturation: float, value: float): ...
    @overload
    def __init__(self, alpha: float, hue: float, saturation: float, value: float): ...
    def CreateFromCMYK(cmyk: ColorCMYK) -> ColorHSV: ...
    def CreateFromHSL(hsl: ColorHSL) -> ColorHSV: ...
    def CreateFromLAB(lab: ColorLAB) -> ColorHSV: ...
    def CreateFromLCH(lch: ColorLCH) -> ColorHSV: ...
    def CreateFromRGBA(rgba: ColorRGBA) -> ColorHSV: ...
    def CreateFromXYZ(xyz: ColorXYZ) -> ColorHSV: ...
    @property
    def A(self) -> float: ...
    @property
    def H(self) -> float: ...
    @property
    def S(self) -> float: ...
    @property
    def V(self) -> float: ...
    def op_Implicit(hsv: ColorHSV) -> Color: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @H.setter
    def H(self, value: float) -> None: ...
    @S.setter
    def S(self, value: float) -> None: ...
    @V.setter
    def V(self, value: float) -> None: ...
    def ToArgbColor(self) -> Color: ...


class ColorLAB:
    @overload
    def __init__(self, rgb: Color): ...
    @overload
    def __init__(self, lightness: float, a: float, b: float): ...
    @overload
    def __init__(self, alpha: float, lightness: float, a: float, b: float): ...
    def CreateFromCMYK(cmyk: ColorCMYK) -> ColorLAB: ...
    def CreateFromHSL(hsl: ColorHSL) -> ColorLAB: ...
    def CreateFromHSV(hsv: ColorHSV) -> ColorLAB: ...
    def CreateFromLCH(lch: ColorLCH) -> ColorLAB: ...
    def CreateFromRGBA(rgb: ColorRGBA) -> ColorLAB: ...
    def CreateFromXYZ(xyz: ColorXYZ) -> ColorLAB: ...
    @property
    def A(self) -> float: ...
    @property
    def Alpha(self) -> float: ...
    @property
    def B(self) -> float: ...
    @property
    def L(self) -> float: ...
    def op_Implicit(lab: ColorLAB) -> Color: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @L.setter
    def L(self, value: float) -> None: ...


class ColorLCH:
    @overload
    def __init__(self, rgb: Color): ...
    @overload
    def __init__(self, lightness: float, chroma: float, hue: float): ...
    @overload
    def __init__(self, alpha: float, lightness: float, chroma: float, hue: float): ...
    def CreateFromCMYK(cmyk: ColorCMYK) -> ColorLCH: ...
    def CreateFromHSL(hsl: ColorHSL) -> ColorLCH: ...
    def CreateFromLAB(lab: ColorLAB) -> ColorLCH: ...
    def CreateFromRGBA(rgb: ColorRGBA) -> ColorLCH: ...
    def CreateFromXYZ(xyz: ColorXYZ) -> ColorLCH: ...
    @property
    def A(self) -> float: ...
    @property
    def C(self) -> float: ...
    @property
    def H(self) -> float: ...
    @property
    def L(self) -> float: ...
    def MakePositive(self) -> None: ...
    def op_Implicit(lch: ColorLCH) -> Color: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @C.setter
    def C(self, value: float) -> None: ...
    @H.setter
    def H(self, value: float) -> None: ...
    @L.setter
    def L(self, value: float) -> None: ...


class ColorMode:
    DisplayColor = 0
    PrintColor = 1
    BlackAndWhite = 2


class ColorRGBA:
    @overload
    def __init__(self, color: ColorRGBA): ...
    @overload
    def __init__(self, color: Color): ...
    @overload
    def __init__(self, argb: int): ...
    @overload
    def __init__(self, red: float, green: float, blue: float): ...
    @overload
    def __init__(self, red: float, green: float, blue: float, alpha: float): ...
    def ApplyGamma(col: ColorRGBA, gamma: float) -> ColorRGBA: ...
    def BlendTo(self, col: ColorRGBA, coefficient: float) -> ColorRGBA: ...
    def CompareTo(self, other: ColorRGBA) -> int: ...
    def CreateFromCMYK(cmyk: ColorCMYK) -> ColorRGBA: ...
    def CreateFromHSL(hsl: ColorHSL) -> ColorRGBA: ...
    def CreateFromHSV(hsv: ColorHSV) -> ColorRGBA: ...
    def CreateFromLAB(lab: ColorLAB) -> ColorRGBA: ...
    def CreateFromLCH(lch: ColorLCH) -> ColorRGBA: ...
    def CreateFromXYZ(xyz: ColorXYZ) -> ColorRGBA: ...
    def EpsilonEquals(self, other: ColorRGBA, epsilon: float) -> bool: ...
    @overload
    def Equals(self, other: ColorRGBA) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def A(self) -> float: ...
    @property
    def B(self) -> float: ...
    @property
    def Black() -> ColorRGBA: ...
    @property
    def Blue() -> ColorRGBA: ...
    @property
    def G(self) -> float: ...
    @property
    def Green() -> ColorRGBA: ...
    @property
    def R(self) -> float: ...
    @property
    def Red() -> ColorRGBA: ...
    @property
    def White() -> ColorRGBA: ...
    def GetHashCode(self) -> int: ...
    def op_Equality(a: ColorRGBA, b: ColorRGBA) -> bool: ...
    def op_Explicit(value: ColorRGBA) -> Color: ...
    def op_Implicit(value: Color) -> ColorRGBA: ...
    def op_Inequality(a: ColorRGBA, b: ColorRGBA) -> bool: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @G.setter
    def G(self, value: float) -> None: ...
    @R.setter
    def R(self, value: float) -> None: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...


class ColorStop:
    def __init__(self, color: Color, t: float): ...
    @property
    def Color(self) -> Color: ...
    @property
    def Position(self) -> float: ...
    @Color.setter
    def Color(self, value: Color) -> None: ...
    @Position.setter
    def Position(self, value: float) -> None: ...


class ColorXYZ:
    @overload
    def __init__(self, rgb: Color): ...
    @overload
    def __init__(self, x: float, y: float, z: float): ...
    @overload
    def __init__(self, alpha: float, x: float, y: float, z: float): ...
    def CreateFromCMYK(cmyk: ColorCMYK) -> ColorXYZ: ...
    def CreateFromHSL(hsl: ColorHSL) -> ColorXYZ: ...
    def CreateFromHSV(hsv: ColorHSV) -> ColorXYZ: ...
    def CreateFromLAB(lab: ColorLAB) -> ColorXYZ: ...
    def CreateFromLCH(lch: ColorLCH) -> ColorXYZ: ...
    def CreateFromRGBA(rgba: ColorRGBA) -> ColorXYZ: ...
    @property
    def A(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    def op_Implicit(xyz: ColorXYZ) -> Color: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...


class ContextsForDraw:
    Unset = 0
    FilePreview = 1
    ViewCapture = 2
    Printing = 3
    UIPreview = 4
    Mask = 5
    RenderOverlays = 6


class CullFaceMode:
    DrawFrontAndBack = 0
    DrawFrontFaces = 1
    DrawBackFaces = 2


class CullObjectEventArgs(DrawEventArgs):
    @property
    def CullObject(self) -> bool: ...
    @property
    def RhinoObject(self) -> RhinoObject: ...
    @property
    def RhinoObjectSerialNumber(self) -> UInt32: ...
    @CullObject.setter
    def CullObject(self, value: bool) -> None: ...


class CustomDisplay:
    def __init__(self, enable: bool): ...
    @overload
    def AddArc(self, arc: Arc) -> None: ...
    @overload
    def AddArc(self, arc: Arc, color: Color) -> None: ...
    @overload
    def AddArc(self, arc: Arc, color: Color, thickness: int) -> None: ...
    @overload
    def AddCircle(self, circle: Circle) -> None: ...
    @overload
    def AddCircle(self, circle: Circle, color: Color) -> None: ...
    @overload
    def AddCircle(self, circle: Circle, color: Color, thickness: int) -> None: ...
    @overload
    def AddCurve(self, curve: Curve) -> None: ...
    @overload
    def AddCurve(self, curve: Curve, color: Color) -> None: ...
    @overload
    def AddCurve(self, curve: Curve, color: Color, thickness: int) -> None: ...
    @overload
    def AddLine(self, line: Line) -> None: ...
    @overload
    def AddLine(self, line: Line, color: Color) -> None: ...
    @overload
    def AddLine(self, line: Line, color: Color, thickness: int) -> None: ...
    @overload
    def AddPoint(self, point: Point3d) -> None: ...
    @overload
    def AddPoint(self, point: Point3d, color: Color) -> None: ...
    @overload
    def AddPoint(self, point: Point3d, color: Color, style: PointStyle, radius: int) -> None: ...
    @overload
    def AddPoints(self, points: Iterable[Point3d]) -> None: ...
    @overload
    def AddPoints(self, points: Iterable[Point3d], color: Color) -> None: ...
    @overload
    def AddPoints(self, points: Iterable[Point3d], color: Color, style: PointStyle, radius: int) -> None: ...
    def AddPolygon(self, polygon: Iterable[Point3d], fillColor: Color, edgeColor: Color, drawFill: bool, drawEdge: bool) -> None: ...
    @overload
    def AddText(self, text: Text3d, color: Color) -> None: ...
    @overload
    def AddText(self, text: str, plane: Plane, size: float) -> None: ...
    @overload
    def AddText(self, text: str, plane: Plane, size: float, color: Color) -> None: ...
    @overload
    def AddVector(self, anchor: Point3d, span: Vector3d) -> None: ...
    @overload
    def AddVector(self, anchor: Point3d, span: Vector3d, color: Color) -> None: ...
    @overload
    def AddVector(self, anchor: Point3d, span: Vector3d, color: Color, drawAnchor: bool) -> None: ...
    def Clear(self) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def ClippingBox(self) -> BoundingBox: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def IsDisposed(self) -> bool: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...


class DefinedViewportProjection:
    #None = 0
    Top = 1
    Bottom = 2
    Left = 3
    Right = 4
    Front = 5
    Back = 6
    Perspective = 7
    TwoPointPerspective = 8


class DepthMode:
    Neutral = 0
    AlwaysInFront = 1
    AlwaysInBack = 2


class DisplayBitmap:
    def __init__(self, bitmap: Bitmap): ...
    def Dispose(self) -> None: ...
    @property
    def Size(self) -> Size: ...
    def GetBlendModes(self) -> Tuple[BlendMode, BlendMode]: ...
    def Load(path: str) -> DisplayBitmap: ...
    def SetBlendFunction(self, source: BlendMode, destination: BlendMode) -> None: ...


class DisplayBitmapDrawList:
    def __init__(self): ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def MaximumCachedSortLists(self) -> int: ...
    @property
    def SortAngleTolerance(self) -> float: ...
    @MaximumCachedSortLists.setter
    def MaximumCachedSortLists(self, value: int) -> None: ...
    @SortAngleTolerance.setter
    def SortAngleTolerance(self, value: float) -> None: ...
    @overload
    def SetPoints(self, points: Iterable[Point3d]) -> None: ...
    @overload
    def SetPoints(self, points: Iterable[Point3d], blendColor: Color) -> None: ...
    @overload
    def SetPoints(self, points: Iterable[Point3d], colors: Iterable[Color]) -> None: ...
    def Sort(self, cameraDirection: Vector3d) -> Set(int): ...


class DisplayConduit:
    @property
    def Enabled(self) -> bool: ...
    @property
    def GeometryFilter(self) -> ObjectType: ...
    @property
    def SpaceFilter(self) -> ActiveSpace: ...
    def GetSelectionFilter(self) -> Tuple[bool, bool]: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @GeometryFilter.setter
    def GeometryFilter(self, value: ObjectType) -> None: ...
    @SpaceFilter.setter
    def SpaceFilter(self, value: ActiveSpace) -> None: ...
    @overload
    def SetObjectIdFilter(self, id: Guid) -> None: ...
    @overload
    def SetObjectIdFilter(self, ids: Iterable[Guid]) -> None: ...
    def SetSelectionFilter(self, on: bool, checkSubObjects: bool) -> None: ...


class DisplayEngine:
    def Dispose(self) -> None: ...


class DisplayMaterial:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: DisplayMaterial): ...
    @overload
    def __init__(self, material: Material): ...
    @overload
    def __init__(self, diffuse: Color): ...
    @overload
    def __init__(self, diffuse: Color, transparency: float): ...
    @overload
    def __init__(self, diffuse: Color, specular: Color, ambient: Color, emission: Color, shine: float, transparency: float): ...
    def Dispose(self) -> None: ...
    @property
    def Ambient(self) -> Color: ...
    @property
    def BackAmbient(self) -> Color: ...
    @property
    def BackDiffuse(self) -> Color: ...
    @property
    def BackEmission(self) -> Color: ...
    @property
    def BackShine(self) -> float: ...
    @property
    def BackSpecular(self) -> Color: ...
    @property
    def BackTransparency(self) -> float: ...
    @property
    def Diffuse(self) -> Color: ...
    @property
    def Emission(self) -> Color: ...
    @property
    def IsTwoSided(self) -> bool: ...
    @property
    def Shine(self) -> float: ...
    @property
    def Specular(self) -> Color: ...
    @property
    def Transparency(self) -> float: ...
    def GetBitmapTexture(self, front: bool) -> Texture: ...
    def GetBumpTexture(self, front: bool) -> Texture: ...
    def GetEnvironmentTexture(self, front: bool) -> Texture: ...
    def GetTransparencyTexture(self, front: bool) -> Texture: ...
    @Ambient.setter
    def Ambient(self, value: Color) -> None: ...
    @BackAmbient.setter
    def BackAmbient(self, value: Color) -> None: ...
    @BackDiffuse.setter
    def BackDiffuse(self, value: Color) -> None: ...
    @BackEmission.setter
    def BackEmission(self, value: Color) -> None: ...
    @BackShine.setter
    def BackShine(self, value: float) -> None: ...
    @BackSpecular.setter
    def BackSpecular(self, value: Color) -> None: ...
    @BackTransparency.setter
    def BackTransparency(self, value: float) -> None: ...
    @Diffuse.setter
    def Diffuse(self, value: Color) -> None: ...
    @Emission.setter
    def Emission(self, value: Color) -> None: ...
    @IsTwoSided.setter
    def IsTwoSided(self, value: bool) -> None: ...
    @Shine.setter
    def Shine(self, value: float) -> None: ...
    @Specular.setter
    def Specular(self, value: Color) -> None: ...
    @Transparency.setter
    def Transparency(self, value: float) -> None: ...
    @overload
    def SetBitmapTexture(self, filename: str, front: bool) -> bool: ...
    @overload
    def SetBitmapTexture(self, texture: Texture, front: bool) -> bool: ...
    @overload
    def SetBumpTexture(self, texture: Texture, front: bool) -> bool: ...
    @overload
    def SetBumpTexture(self, filename: str, front: bool) -> bool: ...
    @overload
    def SetEnvironmentTexture(self, texture: Texture, front: bool) -> bool: ...
    @overload
    def SetEnvironmentTexture(self, filename: str, front: bool) -> bool: ...
    @overload
    def SetTransparencyTexture(self, filename: str, front: bool) -> bool: ...
    @overload
    def SetTransparencyTexture(self, texture: Texture, front: bool) -> bool: ...


class DisplayModeChangedEventArgs:
    @property
    def ChangedDisplayModeId(self) -> Guid: ...
    @property
    def OldDisplayModeId(self) -> Guid: ...
    @property
    def RhinoDoc(self) -> RhinoDoc: ...
    @property
    def Viewport(self) -> RhinoViewport: ...


class DisplayModeDescription:
    @overload
    def AddDisplayMode(displayMode: DisplayModeDescription) -> Guid: ...
    @overload
    def AddDisplayMode(name: str) -> Guid: ...
    def CopyDisplayMode(id: Guid, name: str) -> Guid: ...
    def DeleteDisplayMode(id: Guid) -> bool: ...
    def Dispose(self) -> None: ...
    def ExportToFile(displayMode: DisplayModeDescription, filename: str) -> bool: ...
    def FindByName(englishName: str) -> DisplayModeDescription: ...
    @property
    def AllowObjectAssignment(self) -> bool: ...
    @property
    def AmbientOcclusionId() -> Guid: ...
    @property
    def ArtisticId() -> Guid: ...
    @property
    def DisplayAttributes(self) -> DisplayPipelineAttributes: ...
    @property
    def EnglishName(self) -> str: ...
    @property
    def GhostedId() -> Guid: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def InMenu(self) -> bool: ...
    @property
    def LocalName(self) -> str: ...
    @property
    def PenId() -> Guid: ...
    @property
    def PipelineLocked(self) -> bool: ...
    @property
    def RaytracedId() -> Guid: ...
    @property
    def RenderedId() -> Guid: ...
    @property
    def RenderedShadowsId() -> Guid: ...
    @property
    def ShadedId() -> Guid: ...
    @property
    def ShadedPipelineRequired(self) -> bool: ...
    @property
    def SupportsShadeCommand(self) -> bool: ...
    @property
    def SupportsShading(self) -> bool: ...
    @property
    def TechId() -> Guid: ...
    @property
    def WireframeId() -> Guid: ...
    @property
    def WireframePipelineRequired(self) -> bool: ...
    @property
    def XRayId() -> Guid: ...
    def GetDisplayMode(id: Guid) -> DisplayModeDescription: ...
    def GetDisplayModes() -> Set(DisplayModeDescription): ...
    def ImportFromFile(filename: str) -> Guid: ...
    @AllowObjectAssignment.setter
    def AllowObjectAssignment(self, value: bool) -> None: ...
    @EnglishName.setter
    def EnglishName(self, value: str) -> None: ...
    @InMenu.setter
    def InMenu(self, value: bool) -> None: ...
    @PipelineLocked.setter
    def PipelineLocked(self, value: bool) -> None: ...
    @ShadedPipelineRequired.setter
    def ShadedPipelineRequired(self, value: bool) -> None: ...
    @SupportsShadeCommand.setter
    def SupportsShadeCommand(self, value: bool) -> None: ...
    @SupportsShading.setter
    def SupportsShading(self, value: bool) -> None: ...
    @WireframePipelineRequired.setter
    def WireframePipelineRequired(self, value: bool) -> None: ...
    def UpdateDisplayMode(displayMode: DisplayModeDescription) -> bool: ...


class DisplayPipeline:
    def add_CalculateBoundingBox(value: EventHandler) -> None: ...
    def add_CalculateBoundingBoxZoomExtents(value: EventHandler) -> None: ...
    def add_DisplayModeChanged(value: EventHandler) -> None: ...
    def add_DrawForeground(value: EventHandler) -> None: ...
    def add_DrawOverlay(value: EventHandler) -> None: ...
    def add_InitFrameBuffer(value: EventHandler) -> None: ...
    def add_ObjectCulling(value: EventHandler) -> None: ...
    def add_PostDrawObject(value: EventHandler) -> None: ...
    def add_PostDrawObjects(value: EventHandler) -> None: ...
    def add_PreDrawObject(value: EventHandler) -> None: ...
    def add_PreDrawObjects(value: EventHandler) -> None: ...
    def add_PreDrawTransparentObjects(value: EventHandler) -> None: ...
    def add_ViewportProjectionChanged(value: EventHandler) -> None: ...
    def AddClippingPlane(self, point: Point3d, normal: Vector3d) -> int: ...
    def AvailableOpenGLVersion() -> Tuple[UInt32, bool]: ...
    def Clone(self, viewport: RhinoViewport) -> DisplayPipeline: ...
    def Close(self) -> bool: ...
    def CullControlPolygon() -> bool: ...
    @overload
    def Draw2dLine(self, from_: Point, to: Point, color: Color, thickness: Single) -> None: ...
    @overload
    def Draw2dLine(self, from_: PointF, to: PointF, color: Color, thickness: Single) -> None: ...
    def Draw2dRectangle(self, rectangle: Rectangle, strokeColor: Color, thickness: int, fillColor: Color) -> None: ...
    @overload
    def Draw2dText(self, text: str, color: Color, worldCoordinate: Point3d, middleJustified: bool) -> None: ...
    @overload
    def Draw2dText(self, text: str, color: Color, screenCoordinate: Point2d, middleJustified: bool) -> None: ...
    @overload
    def Draw2dText(self, text: str, color: Color, screenCoordinate: Point2d, middleJustified: bool, height: int) -> None: ...
    @overload
    def Draw2dText(self, text: str, color: Color, worldCoordinate: Point3d, middleJustified: bool, height: int) -> None: ...
    @overload
    def Draw2dText(self, text: str, color: Color, worldCoordinate: Point3d, middleJustified: bool, height: int, fontface: str) -> None: ...
    @overload
    def Draw2dText(self, text: str, color: Color, screenCoordinate: Point2d, middleJustified: bool, height: int, fontface: str) -> None: ...
    @overload
    def Draw3dText(self, text: Text3d, color: Color) -> None: ...
    @overload
    def Draw3dText(self, text: Text3d, color: Color, textPlaneOrigin: Point3d) -> None: ...
    @overload
    def Draw3dText(self, text: Text3d, color: Color, textPlane: Plane) -> None: ...
    @overload
    def Draw3dText(self, text: str, color: Color, textPlane: Plane, height: float, fontface: str) -> None: ...
    @overload
    def Draw3dText(self, text: str, color: Color, textPlane: Plane, height: float, fontface: str, bold: bool, italic: bool) -> None: ...
    @overload
    def Draw3dText(self, text: str, color: Color, textPlane: Plane, height: float, fontface: str, bold: bool, italic: bool, horizontalAlignment: TextHorizontalAlignment, verticalAlignment: TextVerticalAlignment) -> None: ...
    def DrawActivePoint(self, point: Point3d) -> None: ...
    def DrawAnnotation(self, annotation: AnnotationBase, color: Color) -> None: ...
    def DrawAnnotationArrowhead(self, arrowhead: Arrowhead, xform: Transform, color: Color) -> None: ...
    @overload
    def DrawArc(self, arc: Arc, color: Color) -> None: ...
    @overload
    def DrawArc(self, arc: Arc, color: Color, thickness: int) -> None: ...
    @overload
    def DrawArrow(self, line: Line, color: Color) -> None: ...
    @overload
    def DrawArrow(self, line: Line, color: Color, screenSize: float, relativeSize: float) -> None: ...
    def DrawArrowHead(self, tip: Point3d, direction: Vector3d, color: Color, screenSize: float, worldSize: float) -> None: ...
    @overload
    def DrawArrows(self, lines: Set(Line), color: Color) -> None: ...
    @overload
    def DrawArrows(self, lines: Iterable[Line], color: Color) -> None: ...
    def DrawBitmap(self, bitmap: DisplayBitmap, left: int, top: int) -> None: ...
    @overload
    def DrawBox(self, box: BoundingBox, color: Color) -> None: ...
    @overload
    def DrawBox(self, box: Box, color: Color) -> None: ...
    @overload
    def DrawBox(self, box: Box, color: Color, thickness: int) -> None: ...
    @overload
    def DrawBox(self, box: BoundingBox, color: Color, thickness: int) -> None: ...
    @overload
    def DrawBoxCorners(self, box: BoundingBox, color: Color) -> None: ...
    @overload
    def DrawBoxCorners(self, box: BoundingBox, color: Color, size: float) -> None: ...
    @overload
    def DrawBoxCorners(self, box: BoundingBox, color: Color, size: float, thickness: int) -> None: ...
    def DrawBrepShaded(self, brep: Brep, material: DisplayMaterial) -> None: ...
    @overload
    def DrawBrepWires(self, brep: Brep, color: Color) -> None: ...
    @overload
    def DrawBrepWires(self, brep: Brep, color: Color, wireDensity: int) -> None: ...
    @overload
    def DrawCircle(self, circle: Circle, color: Color) -> None: ...
    @overload
    def DrawCircle(self, circle: Circle, color: Color, thickness: int) -> None: ...
    @overload
    def DrawCone(self, cone: Cone, color: Color) -> None: ...
    @overload
    def DrawCone(self, cone: Cone, color: Color, thickness: int) -> None: ...
    def DrawConstructionPlane(self, constructionPlane: ConstructionPlane) -> None: ...
    @overload
    def DrawCurvatureGraph(self, curve: Curve, color: Color) -> None: ...
    @overload
    def DrawCurvatureGraph(self, curve: Curve, color: Color, hairScale: int) -> None: ...
    @overload
    def DrawCurvatureGraph(self, curve: Curve, color: Color, hairScale: int, hairDensity: int, sampleDensity: int) -> None: ...
    @overload
    def DrawCurve(self, curve: Curve, color: Color) -> None: ...
    @overload
    def DrawCurve(self, curve: Curve, color: Color, thickness: int) -> None: ...
    @overload
    def DrawCylinder(self, cylinder: Cylinder, color: Color) -> None: ...
    @overload
    def DrawCylinder(self, cylinder: Cylinder, color: Color, thickness: int) -> None: ...
    def DrawDirectionArrow(self, location: Point3d, direction: Vector3d, color: Color) -> None: ...
    @overload
    def DrawDot(self, worldPosition: Point3d, text: str) -> None: ...
    @overload
    def DrawDot(self, screenX: Single, screenY: Single, text: str) -> None: ...
    @overload
    def DrawDot(self, worldPosition: Point3d, text: str, dotColor: Color, textColor: Color) -> None: ...
    @overload
    def DrawDot(self, dot: TextDot, fillColor: Color, textColor: Color, borderColor: Color) -> None: ...
    @overload
    def DrawDot(self, screenX: Single, screenY: Single, text: str, dotColor: Color, textColor: Color) -> None: ...
    @overload
    def DrawDottedLine(self, line: Line, color: Color) -> None: ...
    @overload
    def DrawDottedLine(self, from_: Point3d, to: Point3d, color: Color) -> None: ...
    def DrawDottedPolyline(self, points: Iterable[Point3d], color: Color, close: bool) -> None: ...
    @overload
    def DrawExtrusionWires(self, extrusion: Extrusion, color: Color) -> None: ...
    @overload
    def DrawExtrusionWires(self, extrusion: Extrusion, color: Color, wireDensity: int) -> None: ...
    @overload
    def DrawGradientHatch(self, hatch: Hatch, stops: Iterable[ColorStop], point1: Point3d, point2: Point3d, linearGradient: bool, repeat: Single, boundaryThickness: Single, boundaryColor: Color) -> None: ...
    @overload
    def DrawGradientHatch(self, hatch: Hatch, color1: Color, color2: Color, point1: Point3d, point2: Point3d, linearGradient: bool, boundaryThickness: Single, boundaryColor: Color) -> None: ...
    def DrawGradientLines(self, lines: Iterable[Line], strokeWidth: Single, stops: Iterable[ColorStop], point1: Point3d, point2: Point3d, linearGradient: bool, repeat: Single) -> None: ...
    def DrawGradientMesh(self, mesh: Mesh, stops: Iterable[ColorStop], point1: Point3d, point2: Point3d, linearGradient: bool, repeat: Single) -> None: ...
    def DrawHatch(self, hatch: Hatch, hatchColor: Color, boundaryColor: Color) -> None: ...
    @overload
    def DrawLine(self, line: Line, color: Color) -> None: ...
    @overload
    def DrawLine(self, line: Line, color: Color, thickness: int) -> None: ...
    @overload
    def DrawLine(self, from_: Point3d, to: Point3d, color: Color) -> None: ...
    @overload
    def DrawLine(self, from_: Point3d, to: Point3d, color: Color, thickness: int) -> None: ...
    def DrawLineArrow(self, line: Line, color: Color, thickness: int, size: float) -> None: ...
    def DrawLineNoClip(self, from_: Point3d, to: Point3d, color: Color, thickness: int) -> None: ...
    @overload
    def DrawLines(self, lines: Iterable[Line], color: Color) -> None: ...
    @overload
    def DrawLines(self, lines: Iterable[Line], color: Color, thickness: int) -> None: ...
    @overload
    def DrawMarker(self, tip: Point3d, direction: Vector3d, color: Color) -> None: ...
    @overload
    def DrawMarker(self, tip: Point3d, direction: Vector3d, color: Color, thickness: int) -> None: ...
    @overload
    def DrawMarker(self, tip: Point3d, direction: Vector3d, color: Color, thickness: int, size: float) -> None: ...
    @overload
    def DrawMarker(self, tip: Point3d, direction: Vector3d, color: Color, thickness: int, size: float, rotation: float) -> None: ...
    def DrawMeshFalseColors(self, mesh: Mesh) -> None: ...
    @overload
    def DrawMeshShaded(self, mesh: Mesh, material: DisplayMaterial) -> None: ...
    @overload
    def DrawMeshShaded(self, mesh: Mesh, material: DisplayMaterial, faceIndices: Set(int)) -> None: ...
    def DrawMeshVertices(self, mesh: Mesh, color: Color) -> None: ...
    @overload
    def DrawMeshWires(self, mesh: Mesh, color: Color) -> None: ...
    @overload
    def DrawMeshWires(self, mesh: Mesh, color: Color, thickness: int) -> None: ...
    @overload
    def DrawObject(self, rhinoObject: RhinoObject) -> None: ...
    @overload
    def DrawObject(self, rhinoObject: RhinoObject, xform: Transform) -> None: ...
    @overload
    def DrawParticles(self, particles: ParticleSystem) -> None: ...
    @overload
    def DrawParticles(self, particles: ParticleSystem, bitmap: DisplayBitmap) -> None: ...
    @overload
    def DrawParticles(self, particles: ParticleSystem, bitmaps: Set(DisplayBitmap)) -> None: ...
    @overload
    def DrawPatternedLine(self, line: Line, color: Color, pattern: int, thickness: int) -> None: ...
    @overload
    def DrawPatternedLine(self, from_: Point3d, to: Point3d, color: Color, pattern: int, thickness: int) -> None: ...
    def DrawPatternedPolyline(self, points: Iterable[Point3d], color: Color, pattern: int, thickness: int, close: bool) -> None: ...
    @overload
    def DrawPoint(self, point: Point3d) -> None: ...
    @overload
    def DrawPoint(self, point: Point3d, color: Color) -> None: ...
    @overload
    def DrawPoint(self, point: Point3d, style: PointStyle, radius: Single, color: Color) -> None: ...
    @overload
    def DrawPoint(self, point: Point3d, style: PointStyle, radius: int, color: Color) -> None: ...
    @overload
    def DrawPoint(self, point: Point3d, style: PointStyle, strokeColor: Color, fillColor: Color, radius: Single, strokeWidth: Single, secondarySize: Single, rotationRadians: Single, diameterIsInPixels: bool, autoScaleForDpi: bool) -> None: ...
    @overload
    def DrawPointCloud(self, cloud: PointCloud, size: int) -> None: ...
    @overload
    def DrawPointCloud(self, cloud: PointCloud, size: Single) -> None: ...
    @overload
    def DrawPointCloud(self, cloud: PointCloud, size: Single, color: Color) -> None: ...
    @overload
    def DrawPointCloud(self, cloud: PointCloud, size: int, color: Color) -> None: ...
    @overload
    def DrawPoints(self, points: Iterable[Point3d], style: PointStyle, radius: Single, color: Color) -> None: ...
    @overload
    def DrawPoints(self, points: Iterable[Point3d], style: PointStyle, radius: int, color: Color) -> None: ...
    @overload
    def DrawPoints(self, points: Iterable[Point3d], style: PointStyle, strokeColor: Color, fillColor: Color, radius: Single, strokeWidth: Single, secondarySize: Single, rotationRadians: Single, diameterIsInPixels: bool, autoScaleForDpi: bool) -> None: ...
    def DrawPolygon(self, points: Iterable[Point3d], color: Color, filled: bool) -> None: ...
    @overload
    def DrawPolyline(self, polyline: Iterable[Point3d], color: Color) -> None: ...
    @overload
    def DrawPolyline(self, polyline: Iterable[Point3d], color: Color, thickness: int) -> None: ...
    def DrawRoundedRectangle(self, center: PointF, pixelWidth: Single, pixelHeight: Single, cornerRadius: Single, strokeColor: Color, strokeWidth: Single, fillColor: Color) -> None: ...
    @overload
    def DrawSphere(self, sphere: Sphere, color: Color) -> None: ...
    @overload
    def DrawSphere(self, sphere: Sphere, color: Color, thickness: int) -> None: ...
    @overload
    def DrawSprite(self, bitmap: DisplayBitmap, screenLocation: Point2d, size: Single) -> None: ...
    @overload
    def DrawSprite(self, bitmap: DisplayBitmap, worldLocation: Point3d, size: Single, sizeInWorldSpace: bool) -> None: ...
    @overload
    def DrawSprite(self, bitmap: DisplayBitmap, screenLocation: Point2d, size: Single, blendColor: Color) -> None: ...
    @overload
    def DrawSprite(self, bitmap: DisplayBitmap, screenLocation: Point2d, width: Single, height: Single) -> None: ...
    @overload
    def DrawSprite(self, bitmap: DisplayBitmap, worldLocation: Point3d, size: Single, blendColor: Color, sizeInWorldSpace: bool) -> None: ...
    @overload
    def DrawSprites(self, bitmap: DisplayBitmap, items: DisplayBitmapDrawList, size: Single, sizeInWorldSpace: bool) -> None: ...
    @overload
    def DrawSprites(self, bitmap: DisplayBitmap, items: DisplayBitmapDrawList, size: Single, translation: Vector3d, sizeInWorldSpace: bool) -> None: ...
    def DrawStereoFrameBuffer(self, viewportLeft: ViewportInfo, viewportRight: ViewportInfo) -> Tuple[bool, UInt32, UInt32]: ...
    def DrawSubDShaded(self, subd: SubD, material: DisplayMaterial) -> None: ...
    def DrawSubDWires(self, subd: SubD, color: Color, thickness: Single) -> None: ...
    def DrawSurface(self, surface: Surface, wireColor: Color, wireDensity: int) -> None: ...
    @overload
    def DrawText(self, text: TextEntity, color: Color) -> None: ...
    @overload
    def DrawText(self, text: TextEntity, color: Color, scale: float) -> None: ...
    @overload
    def DrawText(self, text: TextEntity, color: Color, xform: Transform) -> None: ...
    def DrawToBitmap(viewport: RhinoViewport, width: int, height: int) -> Bitmap: ...
    @overload
    def DrawTorus(self, torus: Torus, color: Color) -> None: ...
    @overload
    def DrawTorus(self, torus: Torus, color: Color, thickness: int) -> None: ...
    @overload
    def DrawZebraPreview(self, brep: Brep, color: Color) -> None: ...
    @overload
    def DrawZebraPreview(self, mesh: Mesh, color: Color) -> None: ...
    def EnableClippingPlanes(self, enable: bool) -> None: ...
    def EnableColorWriting(self, enable: bool) -> None: ...
    def EnableDepthTesting(self, enable: bool) -> None: ...
    def EnableDepthWriting(self, enable: bool) -> None: ...
    def EnableLighting(self, enable: bool) -> None: ...
    def Flush(self) -> None: ...
    @property
    def ActiveObject(self) -> RhinoObject: ...
    @property
    def ActiveObjectNestingLevel(self) -> int: ...
    @property
    def ActiveObjectNestingStack(self) -> Set(RhinoObject): ...
    @property
    def ActiveTopLevelObject(self) -> RhinoObject: ...
    @property
    def DefaultCurveThickness(self) -> int: ...
    @property
    def DepthMode(self) -> DepthMode: ...
    @property
    def DisplayPipelineAttributes(self) -> DisplayPipelineAttributes: ...
    @property
    def DpiScale(self) -> Single: ...
    @property
    def DrawingGrips(self) -> bool: ...
    @property
    def DrawingSurfaces(self) -> bool: ...
    @property
    def DrawingWires(self) -> bool: ...
    @property
    def FrameBuffer(self) -> Bitmap: ...
    @property
    def FrameSize(self) -> Size: ...
    @property
    def IsDynamicDisplay(self) -> bool: ...
    @property
    def IsInViewCapture(self) -> bool: ...
    @property
    def IsOpen(self) -> bool: ...
    @property
    def IsOpenGL(self) -> bool: ...
    @property
    def IsPrinting(self) -> bool: ...
    @property
    def IsStereoMode(self) -> bool: ...
    @property
    def ModelTransform(self) -> Transform: ...
    @property
    def ModelTransformIsIdentity(self) -> bool: ...
    @property
    def NestLevel(self) -> int: ...
    @property
    def RenderPass(self) -> int: ...
    @property
    def ShadingRequired(self) -> bool: ...
    @property
    def StereoProjection(self) -> int: ...
    @property
    def SupportsShading(self) -> bool: ...
    @property
    def Viewport(self) -> RhinoViewport: ...
    @property
    def ZBiasMode(self) -> ZBiasMode: ...
    def GetDrawListSerialNumbers() -> Tuple[UInt32, UInt32]: ...
    def GetLights(self) -> Set(Light): ...
    def GetOpenGLCameraToClip(self) -> Set(Single): ...
    def GetOpenGLWorldToCamera(self, includeModelTransform: bool) -> Set(Single): ...
    def GetOpenGLWorldToClip(self, includeModelTransform: bool) -> Set(Single): ...
    def InterruptDrawing(self) -> bool: ...
    def IsActive(self, rhinoObject: RhinoObject) -> bool: ...
    @overload
    def IsVisible(self, bbox: BoundingBox) -> bool: ...
    @overload
    def IsVisible(self, rhinoObject: RhinoObject) -> bool: ...
    @overload
    def IsVisible(self, worldCoordinate: Point3d) -> bool: ...
    def MakeDefaultOpenGLContextCurrent() -> bool: ...
    def Measure2dText(self, text: str, definitionPoint: Point2d, middleJustified: bool, rotationRadians: float, height: int, fontFace: str) -> Rectangle: ...
    def Open(self) -> bool: ...
    def PopCullFaceMode(self) -> None: ...
    def PopDepthTesting(self) -> None: ...
    def PopDepthWriting(self) -> None: ...
    def PopModelTransform(self) -> None: ...
    def PushCullFaceMode(self, mode: CullFaceMode) -> None: ...
    def PushDepthTesting(self, enable: bool) -> None: ...
    def PushDepthWriting(self, enable: bool) -> None: ...
    def PushModelTransform(self, xform: Transform) -> None: ...
    def remove_CalculateBoundingBox(value: EventHandler) -> None: ...
    def remove_CalculateBoundingBoxZoomExtents(value: EventHandler) -> None: ...
    def remove_DisplayModeChanged(value: EventHandler) -> None: ...
    def remove_DrawForeground(value: EventHandler) -> None: ...
    def remove_DrawOverlay(value: EventHandler) -> None: ...
    def remove_InitFrameBuffer(value: EventHandler) -> None: ...
    def remove_ObjectCulling(value: EventHandler) -> None: ...
    def remove_PostDrawObject(value: EventHandler) -> None: ...
    def remove_PostDrawObjects(value: EventHandler) -> None: ...
    def remove_PreDrawObject(value: EventHandler) -> None: ...
    def remove_PreDrawObjects(value: EventHandler) -> None: ...
    def remove_PreDrawTransparentObjects(value: EventHandler) -> None: ...
    def remove_ViewportProjectionChanged(value: EventHandler) -> None: ...
    def RemoveClippingPlane(self, index: int) -> None: ...
    @DepthMode.setter
    def DepthMode(self, value: DepthMode) -> None: ...
    @ModelTransform.setter
    def ModelTransform(self, value: Transform) -> None: ...
    @ShadingRequired.setter
    def ShadingRequired(self, value: bool) -> None: ...
    @ZBiasMode.setter
    def ZBiasMode(self, value: ZBiasMode) -> None: ...


class DisplayPipelineAttributes:
    def Dispose(self) -> None: ...
    @property
    def AmbientLightingColor(self) -> Color: ...
    @property
    def BoundingBoxMode(self) -> BoundingBoxDisplayMode: ...
    @property
    def CastShadows(self) -> bool: ...
    @property
    def ContextForDraw(self) -> ContextsForDraw: ...
    @property
    def CurveColor(self) -> Color: ...
    @property
    def CurveThickness(self) -> int: ...
    @property
    def DisableConduits(self) -> bool: ...
    @property
    def DisableTransparency(self) -> bool: ...
    @property
    def EnglishName(self) -> str: ...
    @property
    def FillMode(self) -> FrameBufferFillMode: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IgnoreHighlights(self) -> bool: ...
    @property
    def LocalName(self) -> str: ...
    @property
    def LockedObjectsDrawBehindOthers(self) -> bool: ...
    @property
    def MeshSpecificAttributes(self) -> MeshDisplayAttributes: ...
    @property
    def ObjectColor(self) -> Color: ...
    @property
    def PointRadius(self) -> Single: ...
    @property
    def PointStyle(self) -> PointStyle: ...
    @property
    def RealtimeDisplayId(self) -> Guid: ...
    @property
    def RealtimeRenderPasses(self) -> int: ...
    @property
    def ShadeVertexColors(self) -> bool: ...
    @property
    def ShadingEnabled(self) -> bool: ...
    @property
    def ShadowColor(self) -> Color: ...
    @property
    def ShowAnnotations(self) -> bool: ...
    @property
    def ShowClippingPlanes(self) -> bool: ...
    @property
    def ShowCurves(self) -> bool: ...
    @property
    def ShowGrips(self) -> bool: ...
    @property
    def ShowIsoCurves(self) -> bool: ...
    @property
    def ShowLights(self) -> bool: ...
    @property
    def ShowPointClouds(self) -> bool: ...
    @property
    def ShowPoints(self) -> bool: ...
    @property
    def ShowRealtimeRenderProgressBar(self) -> bool: ...
    @property
    def ShowSurfaceEdges(self) -> bool: ...
    @property
    def ShowTangentEdges(self) -> bool: ...
    @property
    def ShowTangentSeams(self) -> bool: ...
    @property
    def ShowText(self) -> bool: ...
    @property
    def StereoContext(self) -> StereoContext: ...
    @property
    def SurfaceEdgeThickness(self) -> int: ...
    @property
    def UseAssignedObjectMaterial(self) -> bool: ...
    @property
    def UseCustomObjectColor(self) -> bool: ...
    @property
    def UseCustomObjectColorBackfaces(self) -> bool: ...
    @property
    def UseCustomObjectMaterial(self) -> bool: ...
    @property
    def UseCustomObjectMaterialBackfaces(self) -> bool: ...
    @property
    def UseSingleCurveColor(self) -> bool: ...
    @property
    def ViewSpecificAttributes(self) -> ViewDisplayAttributes: ...
    @property
    def XrayAllObjects(self) -> bool: ...
    def GetFill(self) -> Tuple[Color, Color, Color, Color]: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    @AmbientLightingColor.setter
    def AmbientLightingColor(self, value: Color) -> None: ...
    @BoundingBoxMode.setter
    def BoundingBoxMode(self, value: BoundingBoxDisplayMode) -> None: ...
    @CastShadows.setter
    def CastShadows(self, value: bool) -> None: ...
    @CurveColor.setter
    def CurveColor(self, value: Color) -> None: ...
    @CurveThickness.setter
    def CurveThickness(self, value: int) -> None: ...
    @DisableConduits.setter
    def DisableConduits(self, value: bool) -> None: ...
    @DisableTransparency.setter
    def DisableTransparency(self, value: bool) -> None: ...
    @EnglishName.setter
    def EnglishName(self, value: str) -> None: ...
    @FillMode.setter
    def FillMode(self, value: FrameBufferFillMode) -> None: ...
    @IgnoreHighlights.setter
    def IgnoreHighlights(self, value: bool) -> None: ...
    @LockedObjectsDrawBehindOthers.setter
    def LockedObjectsDrawBehindOthers(self, value: bool) -> None: ...
    @ObjectColor.setter
    def ObjectColor(self, value: Color) -> None: ...
    @PointRadius.setter
    def PointRadius(self, value: Single) -> None: ...
    @PointStyle.setter
    def PointStyle(self, value: PointStyle) -> None: ...
    @RealtimeRenderPasses.setter
    def RealtimeRenderPasses(self, value: int) -> None: ...
    @ShadeVertexColors.setter
    def ShadeVertexColors(self, value: bool) -> None: ...
    @ShadingEnabled.setter
    def ShadingEnabled(self, value: bool) -> None: ...
    @ShadowColor.setter
    def ShadowColor(self, value: Color) -> None: ...
    @ShowAnnotations.setter
    def ShowAnnotations(self, value: bool) -> None: ...
    @ShowClippingPlanes.setter
    def ShowClippingPlanes(self, value: bool) -> None: ...
    @ShowCurves.setter
    def ShowCurves(self, value: bool) -> None: ...
    @ShowGrips.setter
    def ShowGrips(self, value: bool) -> None: ...
    @ShowIsoCurves.setter
    def ShowIsoCurves(self, value: bool) -> None: ...
    @ShowLights.setter
    def ShowLights(self, value: bool) -> None: ...
    @ShowPointClouds.setter
    def ShowPointClouds(self, value: bool) -> None: ...
    @ShowPoints.setter
    def ShowPoints(self, value: bool) -> None: ...
    @ShowRealtimeRenderProgressBar.setter
    def ShowRealtimeRenderProgressBar(self, value: bool) -> None: ...
    @ShowSurfaceEdges.setter
    def ShowSurfaceEdges(self, value: bool) -> None: ...
    @ShowTangentEdges.setter
    def ShowTangentEdges(self, value: bool) -> None: ...
    @ShowTangentSeams.setter
    def ShowTangentSeams(self, value: bool) -> None: ...
    @ShowText.setter
    def ShowText(self, value: bool) -> None: ...
    @StereoContext.setter
    def StereoContext(self, value: StereoContext) -> None: ...
    @SurfaceEdgeThickness.setter
    def SurfaceEdgeThickness(self, value: int) -> None: ...
    @UseAssignedObjectMaterial.setter
    def UseAssignedObjectMaterial(self, value: bool) -> None: ...
    @UseCustomObjectColor.setter
    def UseCustomObjectColor(self, value: bool) -> None: ...
    @UseCustomObjectColorBackfaces.setter
    def UseCustomObjectColorBackfaces(self, value: bool) -> None: ...
    @UseCustomObjectMaterial.setter
    def UseCustomObjectMaterial(self, value: bool) -> None: ...
    @UseCustomObjectMaterialBackfaces.setter
    def UseCustomObjectMaterialBackfaces(self, value: bool) -> None: ...
    @UseSingleCurveColor.setter
    def UseSingleCurveColor(self, value: bool) -> None: ...
    @XrayAllObjects.setter
    def XrayAllObjects(self, value: bool) -> None: ...
    @overload
    def SetFill(self, singleColor: Color) -> None: ...
    @overload
    def SetFill(self, gradientTop: Color, gradientBottom: Color) -> None: ...
    @overload
    def SetFill(self, gradientTopLeft: Color, gradientBottomLeft: Color, gradientTopRight: Color, gradientBottomRight: Color) -> None: ...


class DisplayTechnology:
    #None = 0
    OpenGL = 1
    Metal = 2
    DirectX = 3
    Software = 4
    Vulkan = 5


class DrawEventArgs:
    @property
    def Display(self) -> DisplayPipeline: ...
    @property
    def RhinoDoc(self) -> RhinoDoc: ...
    @property
    def Viewport(self) -> RhinoViewport: ...


class DrawForegroundEventArgs(DrawEventArgs):
    @property
    def DrawWorldAxes(self) -> bool: ...
    @property
    def WorldAxesDrawn(self) -> bool: ...
    @DrawWorldAxes.setter
    def DrawWorldAxes(self, value: bool) -> None: ...
    @WorldAxesDrawn.setter
    def WorldAxesDrawn(self, value: bool) -> None: ...


class DrawFrameStages:
    InitializeFrameBuffer = 1
    SetupFrustum = 2
    ObjectCulling = 4
    CalculateBoundingBox = 8
    CalculateClippingPlanes = 16
    SetupLighting = 32
    DrawBackground = 64
    PreDrawObjects = 128
    DrawObject = 256
    PostDrawObjects = 512
    DrawMiddleGround = 896
    DrawForeGround = 1024
    DrawOverlay = 2048
    PostProcessFrameBuffer = 4096
    MeshingParameters = 8192
    ObjectDisplayAttributes = 16384
    PreObjectDraw = 32768
    PostObjectDraw = 65536
    ObjectBasedChannel = 114948
    ViewExtents = 131072
    All = 4294836223


class DrawObjectEventArgs(DrawEventArgs):
    @property
    def DrawObject(self) -> bool: ...
    @property
    def RhinoObject(self) -> RhinoObject: ...
    @DrawObject.setter
    def DrawObject(self, value: bool) -> None: ...


class EdgeContinuityMode:
    Distance = 0
    Tangency = 1
    Curvature = 2


class FrameBufferFillMode:
    DefaultColor = 1
    SolidColor = 2
    Gradient2Color = 3
    Gradient4Color = 4
    Bitmap = 5
    Renderer = 6
    Transparent = 7


class GradientType:
    #None = 0
    Linear = 1
    Radial = 2
    LinearDisabled = 3
    RadialDisabled = 4


class InitFrameBufferEventArgs:
    @overload
    def SetFill(self, color: Color) -> None: ...
    @overload
    def SetFill(self, top: Color, bottom: Color) -> None: ...
    @overload
    def SetFill(self, topLeft: Color, bottomLeft: Color, topRight: Color, bottomRight: Color) -> None: ...


class MeshDisplayAttributes:
    @property
    def AllMeshWiresColor(self) -> Color: ...
    @property
    def HighlightMeshes(self) -> bool: ...
    @property
    def MeshWireThickness(self) -> int: ...
    @property
    def ShowMeshVertices(self) -> bool: ...
    @property
    def ShowMeshWires(self) -> bool: ...
    @AllMeshWiresColor.setter
    def AllMeshWiresColor(self, value: Color) -> None: ...
    @HighlightMeshes.setter
    def HighlightMeshes(self, value: bool) -> None: ...
    @MeshWireThickness.setter
    def MeshWireThickness(self, value: int) -> None: ...
    @ShowMeshVertices.setter
    def ShowMeshVertices(self, value: bool) -> None: ...
    @ShowMeshWires.setter
    def ShowMeshWires(self, value: bool) -> None: ...


class PageViewSpaceChangeEventArgs:
    @property
    def NewActiveDetailId(self) -> Guid: ...
    @property
    def OldActiveDetailId(self) -> Guid: ...
    @property
    def PageView(self) -> RhinoPageView: ...


class PointStyle:
    Square = 0
    Simple = 0
    ControlPoint = 1
    ActivePoint = 2
    X = 3
    RoundSimple = 4
    Circle = 4
    RoundControlPoint = 5
    RoundActivePoint = 6
    Triangle = 7
    Heart = 8
    Chevron = 9
    Clover = 10
    Tag = 11
    Asterisk = 12
    Pin = 13
    ArrowTail = 14
    ArrowTip = 15


class RhinoPageView(RhinoView):
    def add_PageViewSpaceChange(value: EventHandler) -> None: ...
    def AddDetailView(self, title: str, corner0: Point2d, corner1: Point2d, initialProjection: DefinedViewportProjection) -> DetailViewObject: ...
    def Duplicate(self, duplicatePageGeometry: bool) -> RhinoPageView: ...
    @property
    def ActiveDetail(self) -> DetailViewObject: ...
    @property
    def ActiveDetailId(self) -> Guid: ...
    @property
    def ActiveViewport(self) -> RhinoViewport: ...
    @property
    def PageHeight(self) -> float: ...
    @property
    def PageIsActive(self) -> bool: ...
    @property
    def PageName(self) -> str: ...
    @property
    def PageNumber(self) -> int: ...
    @property
    def PageWidth(self) -> float: ...
    @property
    def PaperName(self) -> str: ...
    @property
    def PrinterName(self) -> str: ...
    def GetDetailViews(self) -> Set(DetailViewObject): ...
    def GetPreviewImage(self, size: Size, grayScale: bool) -> Bitmap: ...
    def remove_PageViewSpaceChange(value: EventHandler) -> None: ...
    @PageHeight.setter
    def PageHeight(self, value: float) -> None: ...
    @PageName.setter
    def PageName(self, value: str) -> None: ...
    @PageNumber.setter
    def PageNumber(self, value: int) -> None: ...
    @PageWidth.setter
    def PageWidth(self, value: float) -> None: ...
    @overload
    def SetActiveDetail(self, detailId: Guid) -> bool: ...
    @overload
    def SetActiveDetail(self, detailName: str, compareCase: bool) -> bool: ...
    def SetPageAsActive(self) -> None: ...


class RhinoView:
    def add_Create(value: EventHandler) -> None: ...
    def add_Destroy(value: EventHandler) -> None: ...
    def add_Modified(value: EventHandler) -> None: ...
    def add_Rename(value: EventHandler) -> None: ...
    def add_SetActive(value: EventHandler) -> None: ...
    @overload
    def CaptureToBitmap(self) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, size: Size) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, attributes: DisplayPipelineAttributes) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, mode: DisplayModeDescription) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, size: Size, mode: DisplayModeDescription) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, size: Size, attributes: DisplayPipelineAttributes) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, grid: bool, worldAxes: bool, cplaneAxes: bool) -> Bitmap: ...
    @overload
    def CaptureToBitmap(self, size: Size, grid: bool, worldAxes: bool, cplaneAxes: bool) -> Bitmap: ...
    @overload
    def ClientToScreen(self, clientPoint: Point) -> Point: ...
    @overload
    def ClientToScreen(self, clientPoint: Point2d) -> Point2d: ...
    def Close(self) -> bool: ...
    def CreateShadedPreviewImage(self, imagePath: str, size: Size, ignoreHighlights: bool, drawConstructionPlane: bool, useGhostedShading: bool) -> bool: ...
    def CreateWireframePreviewImage(self, imagePath: str, size: Size, ignoreHighlights: bool, drawConstructionPlane: bool) -> bool: ...
    def Equals(self, obj: Object) -> bool: ...
    def FromRuntimeSerialNumber(serialNumber: UInt32) -> RhinoView: ...
    @property
    def ActiveViewport(self) -> RhinoViewport: ...
    @property
    def ActiveViewportID(self) -> Guid: ...
    @property
    def Bounds(self) -> Rectangle: ...
    @property
    def ClientRectangle(self) -> Rectangle: ...
    @property
    def DisplayPipeline(self) -> DisplayPipeline: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EnableDrawing() -> bool: ...
    @property
    def Floating(self) -> bool: ...
    @property
    def Handle(self) -> IntPtr: ...
    @property
    def MainViewport(self) -> RhinoViewport: ...
    @property
    def Maximized(self) -> bool: ...
    @property
    def RealtimeDisplayMode(self) -> RealtimeDisplayMode: ...
    @property
    def RuntimeSerialNumber(self) -> UInt32: ...
    @property
    def ScreenRectangle(self) -> Rectangle: ...
    @property
    def Size(self) -> Size: ...
    @property
    def TitleVisible(self) -> bool: ...
    def GetHashCode(self) -> int: ...
    def MouseCaptured(self, bIncludeMovement: bool) -> bool: ...
    def Redraw(self) -> None: ...
    def remove_Create(value: EventHandler) -> None: ...
    def remove_Destroy(value: EventHandler) -> None: ...
    def remove_Modified(value: EventHandler) -> None: ...
    def remove_Rename(value: EventHandler) -> None: ...
    def remove_SetActive(value: EventHandler) -> None: ...
    @overload
    def ScreenToClient(self, screenPoint: Point) -> Point: ...
    @overload
    def ScreenToClient(self, screenPoint: Point2d) -> Point2d: ...
    @EnableDrawing.setter
    def EnableDrawing(value: bool) -> None: ...
    @Floating.setter
    def Floating(self, value: bool) -> None: ...
    @Maximized.setter
    def Maximized(self, value: bool) -> None: ...
    @Size.setter
    def Size(self, value: Size) -> None: ...
    @TitleVisible.setter
    def TitleVisible(self, value: bool) -> None: ...
    def SpeedTest(self, frameCount: int, freezeDrawList: bool, direction: int, angleDeltaRadians: float) -> float: ...


class RhinoViewport:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: RhinoViewport): ...
    def ChangeToParallelProjection(self, symmetricFrustum: bool) -> bool: ...
    @overload
    def ChangeToPerspectiveProjection(self, symmetricFrustum: bool, lensLength: float) -> bool: ...
    @overload
    def ChangeToPerspectiveProjection(self, targetDistance: float, symmetricFrustum: bool, lensLength: float) -> bool: ...
    @overload
    def ChangeToTwoPointPerspectiveProjection(self, lensLength: float) -> bool: ...
    @overload
    def ChangeToTwoPointPerspectiveProjection(self, targetDistance: float, up: Vector3d, lensLength: float) -> bool: ...
    def ClearTraceImage(self) -> None: ...
    @overload
    def ClientToScreen(self, clientPoint: Point) -> Point: ...
    @overload
    def ClientToScreen(self, clientPoint: Point2d) -> Point: ...
    @overload
    def ClientToWorld(self, clientPoint: Point2d) -> Line: ...
    @overload
    def ClientToWorld(self, clientPoint: Point) -> Line: ...
    def ConstructionPlane(self) -> Plane: ...
    def DeleteAllUserStrings(self) -> None: ...
    def DeleteUserString(self, key: str) -> bool: ...
    def Dispose(self) -> None: ...
    def FromId(id: Guid) -> RhinoViewport: ...
    @property
    def Bounds(self) -> Rectangle: ...
    @property
    def Camera35mmLensLength(self) -> float: ...
    @property
    def CameraDirection(self) -> Vector3d: ...
    @property
    def CameraLocation(self) -> Point3d: ...
    @property
    def CameraTarget(self) -> Point3d: ...
    @property
    def CameraUp(self) -> Vector3d: ...
    @property
    def CameraX(self) -> Vector3d: ...
    @property
    def CameraY(self) -> Vector3d: ...
    @property
    def CameraZ(self) -> Vector3d: ...
    @property
    def ChangeCounter(self) -> UInt32: ...
    @property
    def ConstructionAxesVisible(self) -> bool: ...
    @property
    def ConstructionGridVisible(self) -> bool: ...
    @property
    def DisplayMode(self) -> DisplayModeDescription: ...
    @property
    def FrustumAspect(self) -> float: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IsParallelProjection(self) -> bool: ...
    @property
    def IsPerspectiveProjection(self) -> bool: ...
    @property
    def IsPlanView(self) -> bool: ...
    @property
    def IsTwoPointPerspectiveProjection(self) -> bool: ...
    @property
    def IsValidCamera(self) -> bool: ...
    @property
    def IsValidFrustum(self) -> bool: ...
    @property
    def Name(self) -> str: ...
    @property
    def ParentView(self) -> RhinoView: ...
    @property
    def ScreenPortAspect(self) -> float: ...
    @property
    def Size(self) -> Size: ...
    @property
    def UserStringCount(self) -> int: ...
    @property
    def ViewportType(self) -> ViewportType: ...
    @property
    def WallpaperFilename(self) -> str: ...
    @property
    def WallpaperGrayscale(self) -> bool: ...
    @property
    def WallpaperVisible(self) -> bool: ...
    @property
    def WorldAxesVisible(self) -> bool: ...
    def GetCameraAngle(self) -> Tuple[bool, float, float, float]: ...
    def GetCameraExtents(self, points: Iterable[Point3d]) -> BoundingBox: ...
    def GetCameraFrame(self) -> Tuple[bool, Plane]: ...
    def GetConstructionPlane(self) -> ConstructionPlane: ...
    @overload
    def GetDepth(self, point: Point3d) -> Tuple[bool, float]: ...
    @overload
    def GetDepth(self, bbox: BoundingBox) -> Tuple[bool, float, float]: ...
    @overload
    def GetDepth(self, sphere: Sphere) -> Tuple[bool, float, float]: ...
    def GetFarRect(self) -> Set(Point3d): ...
    def GetFrustum(self) -> Tuple[bool, float, float, float, float, float, float]: ...
    def GetFrustumBottomPlane(self) -> Tuple[bool, Plane]: ...
    def GetFrustumBoundingBox(self) -> BoundingBox: ...
    def GetFrustumCenter(self) -> Tuple[bool, Point3d]: ...
    def GetFrustumFarPlane(self) -> Tuple[bool, Plane]: ...
    def GetFrustumLeftPlane(self) -> Tuple[bool, Plane]: ...
    def GetFrustumLine(self, screenX: float, screenY: float) -> Tuple[bool, Line]: ...
    def GetFrustumNearPlane(self) -> Tuple[bool, Plane]: ...
    def GetFrustumRightPlane(self) -> Tuple[bool, Plane]: ...
    def GetFrustumTopPlane(self) -> Tuple[bool, Plane]: ...
    def GetNearRect(self) -> Set(Point3d): ...
    @overload
    def GetPickTransform(self, clientPoint: Point) -> Transform: ...
    @overload
    def GetPickTransform(self, clientRectangle: Rectangle) -> Transform: ...
    @overload
    def GetPickTransform(self, clientX: int, clientY: int) -> Transform: ...
    def GetScreenPort(self) -> Tuple[bool, int, int, int, int, int, int]: ...
    def GetTransform(self, sourceSystem: CoordinateSystem, destinationSystem: CoordinateSystem) -> Transform: ...
    def GetUserString(self, key: str) -> str: ...
    def GetUserStrings(self) -> NameValueCollection: ...
    def GetWorldToScreenScale(self, pointInFrustum: Point3d) -> Tuple[bool, float]: ...
    @overload
    def IsVisible(self, bbox: BoundingBox) -> bool: ...
    @overload
    def IsVisible(self, point: Point3d) -> bool: ...
    def KeyboardDolly(self, leftRight: bool, amount: float) -> bool: ...
    def KeyboardDollyInOut(self, amount: float) -> bool: ...
    def KeyboardRotate(self, leftRight: bool, angleRadians: float) -> bool: ...
    @overload
    def Magnify(self, magnificationFactor: float, mode: bool) -> bool: ...
    @overload
    def Magnify(self, magnificationFactor: float, mode: bool, fixedScreenPoint: Point) -> bool: ...
    def MouseAdjustLensLength(self, mousePreviousPoint: Point, mouseCurrentPoint: Point, moveTarget: bool) -> bool: ...
    def MouseDollyZoom(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def MouseInOutDolly(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def MouseLateralDolly(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def MouseMagnify(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def MouseRotateAroundTarget(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def MouseRotateCamera(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def MouseTilt(self, mousePreviousPoint: Point, mouseCurrentPoint: Point) -> bool: ...
    def NextConstructionPlane(self) -> bool: ...
    def NextViewProjection(self) -> bool: ...
    def PopConstructionPlane(self) -> bool: ...
    def PopViewProjection(self) -> bool: ...
    def PreviousConstructionPlane(self) -> bool: ...
    def PreviousViewProjection(self) -> bool: ...
    def PushConstructionPlane(self, cplane: ConstructionPlane) -> None: ...
    def PushViewInfo(self, viewinfo: ViewInfo, includeTraceImage: bool) -> bool: ...
    def PushViewProjection(self) -> None: ...
    def Rotate(self, angleRadians: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> bool: ...
    def ScreenToClient(self, screenPoint: Point) -> Point: ...
    @Camera35mmLensLength.setter
    def Camera35mmLensLength(self, value: float) -> None: ...
    @CameraUp.setter
    def CameraUp(self, value: Vector3d) -> None: ...
    @ConstructionAxesVisible.setter
    def ConstructionAxesVisible(self, value: bool) -> None: ...
    @ConstructionGridVisible.setter
    def ConstructionGridVisible(self, value: bool) -> None: ...
    @DisplayMode.setter
    def DisplayMode(self, value: DisplayModeDescription) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @Size.setter
    def Size(self, value: Size) -> None: ...
    @WorldAxesVisible.setter
    def WorldAxesVisible(self, value: bool) -> None: ...
    def SetCameraDirection(self, cameraDirection: Vector3d, updateTargetLocation: bool) -> None: ...
    def SetCameraLocation(self, cameraLocation: Point3d, updateTargetLocation: bool) -> None: ...
    def SetCameraLocations(self, targetLocation: Point3d, cameraLocation: Point3d) -> None: ...
    def SetCameraTarget(self, targetLocation: Point3d, updateCameraLocation: bool) -> None: ...
    def SetClippingPlanes(self, box: BoundingBox) -> None: ...
    @overload
    def SetConstructionPlane(self, plane: Plane) -> None: ...
    @overload
    def SetConstructionPlane(self, cplane: ConstructionPlane) -> None: ...
    def SetProjection(self, projection: DefinedViewportProjection, viewName: str, updateConstructionPlane: bool) -> bool: ...
    def SetToPlanView(self, planeOrigin: Point3d, planeXaxis: Vector3d, planeYaxis: Vector3d, setConstructionPlane: bool) -> bool: ...
    def SetTraceImage(self, bitmapFileName: str, plane: Plane, width: float, height: float, grayscale: bool, filtered: bool) -> bool: ...
    def SetUserString(self, key: str, value: str) -> bool: ...
    def SetViewProjection(self, projection: ViewportInfo, updateTargetLocation: bool) -> bool: ...
    @overload
    def SetWallpaper(self, imageFilename: str, grayscale: bool) -> bool: ...
    @overload
    def SetWallpaper(self, imageFilename: str, grayscale: bool, visible: bool) -> bool: ...
    def WorldToClient(self, worldPoint: Point3d) -> Point2d: ...
    def ZoomBoundingBox(self, box: BoundingBox) -> bool: ...
    def ZoomExtents(self) -> bool: ...
    def ZoomExtentsSelected(self) -> bool: ...


class ShaderLanguage:
    GLSL_ES100 = 1
    GLSL_ES300 = 2
    GLSL_ES310 = 3
    GLSL_120 = 4
    GLSL_130 = 5
    GLSL_140 = 6
    GLSL_150 = 7
    GLSL_330 = 8
    GLSL_400 = 9
    GLSL_410 = 10
    GLSL_420 = 11
    GLSL_430 = 12
    GLSL_440 = 13
    Metal = 14


class StereoContext:
    #None = 0
    LeftEye = 1
    RightEye = 2
    BothEyes = 3


class Text3d:
    @overload
    def __init__(self, text: str): ...
    @overload
    def __init__(self, text: str, plane: Plane, height: float): ...
    def Dispose(self) -> None: ...
    @property
    def Bold(self) -> bool: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def FontFace(self) -> str: ...
    @property
    def Height(self) -> float: ...
    @property
    def HorizontalAlignment(self) -> TextHorizontalAlignment: ...
    @property
    def Italic(self) -> bool: ...
    @property
    def Text(self) -> str: ...
    @property
    def TextPlane(self) -> Plane: ...
    @property
    def VerticalAlignment(self) -> TextVerticalAlignment: ...
    @Bold.setter
    def Bold(self, value: bool) -> None: ...
    @FontFace.setter
    def FontFace(self, value: str) -> None: ...
    @Height.setter
    def Height(self, value: float) -> None: ...
    @HorizontalAlignment.setter
    def HorizontalAlignment(self, value: TextHorizontalAlignment) -> None: ...
    @Italic.setter
    def Italic(self, value: bool) -> None: ...
    @Text.setter
    def Text(self, value: str) -> None: ...
    @TextPlane.setter
    def TextPlane(self, value: Plane) -> None: ...
    @VerticalAlignment.setter
    def VerticalAlignment(self, value: TextVerticalAlignment) -> None: ...


class ViewAreaMapping:
    View = 0
    Extents = 1
    Window = 2


class ViewCapture:
    def __init__(self): ...
    @overload
    def CaptureToBitmap(self, sourceView: RhinoView) -> Bitmap: ...
    @overload
    def CaptureToBitmap(settings: ViewCaptureSettings) -> Bitmap: ...
    def CaptureToSvg(settings: ViewCaptureSettings) -> XmlDocument: ...
    @property
    def DrawAxes(self) -> bool: ...
    @property
    def DrawGrid(self) -> bool: ...
    @property
    def DrawGridAxes(self) -> bool: ...
    @property
    def Height(self) -> int: ...
    @property
    def Preview(self) -> bool: ...
    @property
    def RealtimeRenderPasses(self) -> int: ...
    @property
    def ScaleScreenItems(self) -> bool: ...
    @property
    def TransparentBackground(self) -> bool: ...
    @property
    def Width(self) -> int: ...
    @DrawAxes.setter
    def DrawAxes(self, value: bool) -> None: ...
    @DrawGrid.setter
    def DrawGrid(self, value: bool) -> None: ...
    @DrawGridAxes.setter
    def DrawGridAxes(self, value: bool) -> None: ...
    @Height.setter
    def Height(self, value: int) -> None: ...
    @Preview.setter
    def Preview(self, value: bool) -> None: ...
    @RealtimeRenderPasses.setter
    def RealtimeRenderPasses(self, value: int) -> None: ...
    @ScaleScreenItems.setter
    def ScaleScreenItems(self, value: bool) -> None: ...
    @TransparentBackground.setter
    def TransparentBackground(self, value: bool) -> None: ...
    @Width.setter
    def Width(self, value: int) -> None: ...


class ViewCaptureSettings:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, sourcePageView: RhinoPageView, dpi: float): ...
    @overload
    def __init__(self, sourceView: RhinoView, mediaSize: Size, dpi: float): ...
    def Dispose(self) -> None: ...
    @property
    def ArrowheadSizeMillimeters(self) -> float: ...
    @property
    def CropRectangle(self) -> Rectangle: ...
    @property
    def DefaultPrintWidthMillimeters(self) -> float: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def DrawAxis(self) -> bool: ...
    @property
    def DrawBackground(self) -> bool: ...
    @property
    def DrawBackgroundBitmap(self) -> bool: ...
    @property
    def DrawClippingPlanes(self) -> bool: ...
    @property
    def DrawGrid(self) -> bool: ...
    @property
    def DrawLights(self) -> bool: ...
    @property
    def DrawLockedObjects(self) -> bool: ...
    @property
    def DrawMargins(self) -> bool: ...
    @property
    def DrawSelectedObjectsOnly(self) -> bool: ...
    @property
    def DrawWallpaper(self) -> bool: ...
    @property
    def FooterText(self) -> str: ...
    @property
    def HeaderText(self) -> str: ...
    @property
    def IsScaleToFit(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def MatchLinetypePatternDefinition(self) -> bool: ...
    @property
    def MediaSize(self) -> Size: ...
    @property
    def ModelScaleType(self) -> int: ...
    @property
    def OffsetAnchor(self) -> AnchorLocation: ...
    @property
    def OutputColor(self) -> ColorMode: ...
    @property
    def PointSizeMillimeters(self) -> float: ...
    @property
    def RasterMode(self) -> bool: ...
    @property
    def Resolution(self) -> float: ...
    @property
    def UsePrintWidths(self) -> bool: ...
    @property
    def ViewArea(self) -> ViewAreaMapping: ...
    @property
    def WireThicknessScale(self) -> float: ...
    def GetMargins(self, lengthUnits: UnitSystem) -> Tuple[bool, float, float, float, float]: ...
    def GetModelScale(self, pageUnits: UnitSystem, modelUnits: UnitSystem) -> float: ...
    def GetOffset(self, lengthUnits: UnitSystem) -> Tuple[bool, float, float]: ...
    @ArrowheadSizeMillimeters.setter
    def ArrowheadSizeMillimeters(self, value: float) -> None: ...
    @DefaultPrintWidthMillimeters.setter
    def DefaultPrintWidthMillimeters(self, value: float) -> None: ...
    @Document.setter
    def Document(self, value: RhinoDoc) -> None: ...
    @DrawAxis.setter
    def DrawAxis(self, value: bool) -> None: ...
    @DrawBackground.setter
    def DrawBackground(self, value: bool) -> None: ...
    @DrawBackgroundBitmap.setter
    def DrawBackgroundBitmap(self, value: bool) -> None: ...
    @DrawClippingPlanes.setter
    def DrawClippingPlanes(self, value: bool) -> None: ...
    @DrawGrid.setter
    def DrawGrid(self, value: bool) -> None: ...
    @DrawLights.setter
    def DrawLights(self, value: bool) -> None: ...
    @DrawLockedObjects.setter
    def DrawLockedObjects(self, value: bool) -> None: ...
    @DrawMargins.setter
    def DrawMargins(self, value: bool) -> None: ...
    @DrawSelectedObjectsOnly.setter
    def DrawSelectedObjectsOnly(self, value: bool) -> None: ...
    @DrawWallpaper.setter
    def DrawWallpaper(self, value: bool) -> None: ...
    @FooterText.setter
    def FooterText(self, value: str) -> None: ...
    @HeaderText.setter
    def HeaderText(self, value: str) -> None: ...
    @MatchLinetypePatternDefinition.setter
    def MatchLinetypePatternDefinition(self, value: bool) -> None: ...
    @ModelScaleType.setter
    def ModelScaleType(self, value: int) -> None: ...
    @OffsetAnchor.setter
    def OffsetAnchor(self, value: AnchorLocation) -> None: ...
    @OutputColor.setter
    def OutputColor(self, value: ColorMode) -> None: ...
    @PointSizeMillimeters.setter
    def PointSizeMillimeters(self, value: float) -> None: ...
    @RasterMode.setter
    def RasterMode(self, value: bool) -> None: ...
    @Resolution.setter
    def Resolution(self, value: float) -> None: ...
    @UsePrintWidths.setter
    def UsePrintWidths(self, value: bool) -> None: ...
    @ViewArea.setter
    def ViewArea(self, value: ViewAreaMapping) -> None: ...
    @WireThicknessScale.setter
    def WireThicknessScale(self, value: float) -> None: ...
    def SetLayout(self, mediaSize: Size, cropRectangle: Rectangle) -> None: ...
    def SetMargins(self, lengthUnits: UnitSystem, left: float, top: float, right: float, bottom: float) -> bool: ...
    def SetModelScaleToFit(self, promptOnChange: bool) -> None: ...
    def SetModelScaleToValue(self, scale: float) -> None: ...
    def SetOffset(self, lengthUnits: UnitSystem, fromMargin: bool, x: float, y: float) -> None: ...
    def SetViewport(self, viewport: RhinoViewport) -> None: ...
    @overload
    def SetWindowRect(self, screenPoint1: Point2d, screenPoint2: Point2d) -> None: ...
    @overload
    def SetWindowRect(self, worldPoint1: Point3d, worldPoint2: Point3d) -> None: ...


class ViewDisplayAttributes:
    @property
    def BlendGrid(self) -> bool: ...
    @property
    def DrawGrid(self) -> bool: ...
    @property
    def DrawGridAxes(self) -> bool: ...
    @property
    def DrawTransparentGridPlane(self) -> bool: ...
    @property
    def DrawWorldAxes(self) -> bool: ...
    @property
    def DrawZAxis(self) -> bool: ...
    @property
    def HorizontalViewportScale(self) -> float: ...
    @property
    def ShowGridOnTop(self) -> bool: ...
    @property
    def UseDocumentGrid(self) -> bool: ...
    @property
    def VerticalViewportScale(self) -> float: ...
    @property
    def WorldAxisColorX(self) -> Color: ...
    @property
    def WorldAxisColorY(self) -> Color: ...
    @property
    def WorldAxisColorZ(self) -> Color: ...
    @BlendGrid.setter
    def BlendGrid(self, value: bool) -> None: ...
    @DrawGrid.setter
    def DrawGrid(self, value: bool) -> None: ...
    @DrawGridAxes.setter
    def DrawGridAxes(self, value: bool) -> None: ...
    @DrawTransparentGridPlane.setter
    def DrawTransparentGridPlane(self, value: bool) -> None: ...
    @DrawWorldAxes.setter
    def DrawWorldAxes(self, value: bool) -> None: ...
    @DrawZAxis.setter
    def DrawZAxis(self, value: bool) -> None: ...
    @HorizontalViewportScale.setter
    def HorizontalViewportScale(self, value: float) -> None: ...
    @ShowGridOnTop.setter
    def ShowGridOnTop(self, value: bool) -> None: ...
    @UseDocumentGrid.setter
    def UseDocumentGrid(self, value: bool) -> None: ...
    @VerticalViewportScale.setter
    def VerticalViewportScale(self, value: float) -> None: ...
    @WorldAxisColorX.setter
    def WorldAxisColorX(self, value: Color) -> None: ...
    @WorldAxisColorY.setter
    def WorldAxisColorY(self, value: Color) -> None: ...
    @WorldAxisColorZ.setter
    def WorldAxisColorZ(self, value: Color) -> None: ...


class ViewEventArgs:
    @property
    def View(self) -> RhinoView: ...


class ViewportType:
    StandardModelingViewport = 0
    PageViewMainViewport = 1
    DetailViewport = 2


class VisualAnalysisMode:
    def AdjustAnalysisMeshes(doc: RhinoDoc, analysisModeId: Guid) -> bool: ...
    def EnableUserInterface(self, on: bool) -> None: ...
    @overload
    def Find(id: Guid) -> VisualAnalysisMode: ...
    @overload
    def Find(t: Type) -> VisualAnalysisMode: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def Name(self) -> str: ...
    @property
    def RhinoCurvatureColorAnalyisModeId() -> Guid: ...
    @property
    def RhinoCurvatureGraphAnalysisModeId() -> Guid: ...
    @property
    def RhinoDraftAngleAnalysisModeId() -> Guid: ...
    @property
    def RhinoEdgeAnalysisModeId() -> Guid: ...
    @property
    def RhinoEdgeContinuityAlalysisModeId() -> Guid: ...
    @property
    def RhinoEmapAnalysisModeId() -> Guid: ...
    @property
    def RhinoThicknessAnalysisModeId() -> Guid: ...
    @property
    def RhinoZebraStripeAnalysisModeId() -> Guid: ...
    @property
    def ShowIsoCurves(self) -> bool: ...
    @property
    def Style(self) -> AnalysisStyle: ...
    def ObjectSupportsAnalysisMode(self, obj: RhinoObject) -> bool: ...
    def Register(customAnalysisModeType: Type) -> VisualAnalysisMode: ...


class ZBiasMode:
    Neutral = 0
    TowardsCamera = 1
    AwayFromCamera = 2


class ZBufferCapture:
    def __init__(self, viewport: RhinoViewport): ...
    def Dispose(self) -> None: ...
    def GrayscaleDib(self) -> Bitmap: ...
    def HitCount(self) -> int: ...
    def MaxZ(self) -> Single: ...
    def MinZ(self) -> Single: ...
    def SetDisplayMode(self, modeId: Guid) -> None: ...
    def ShowAnnotations(self, on: bool) -> None: ...
    def ShowCurves(self, on: bool) -> None: ...
    def ShowIsocurves(self, on: bool) -> None: ...
    def ShowLights(self, on: bool) -> None: ...
    def ShowMeshWires(self, on: bool) -> None: ...
    def ShowPoints(self, on: bool) -> None: ...
    def ShowText(self, on: bool) -> None: ...
    def WorldPointAt(self, x: int, y: int) -> Point3d: ...
    def ZValueAt(self, x: int, y: int) -> Single: ...
