from typing import Tuple, Set, Iterable, List


class SnapShotsClient:
    def __init__(self): ...
    def AnimateDocument(self, doc: RhinoDoc, dPos: float, archive_start: BinaryArchiveReader, archive_stop: BinaryArchiveReader) -> bool: ...
    def AnimateObject(self, doc: RhinoDoc, doc_object: RhinoObject, transform: Transform, dPos: float, archive_start: BinaryArchiveReader, archive_stop: BinaryArchiveReader) -> Tuple[bool, Transform]: ...
    def AnimationStart(self, doc: RhinoDoc, iFrames: int) -> None: ...
    def AnimationStop(self, doc: RhinoDoc) -> bool: ...
    def ApplicationCategory() -> str: ...
    def Category(self) -> str: ...
    def ClientId(self) -> Guid: ...
    def Dispose(self) -> None: ...
    def DocumentCategory() -> str: ...
    def ExtendBoundingBoxForDocumentAnimation(self, doc: RhinoDoc, archive_start: BinaryArchiveReader, archive_stop: BinaryArchiveReader, bbox: BoundingBox) -> Tuple[BoundingBox]: ...
    def ExtendBoundingBoxForObjectAnimation(self, doc: RhinoDoc, doc_object: RhinoObject, transform: Transform, archive_start: BinaryArchiveReader, archive_stop: BinaryArchiveReader, bbox: BoundingBox) -> Tuple[Transform, BoundingBox]: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    @property
    def SerialNumber(self) -> int: ...
    @overload
    def IsCurrentModelStateInAnySnapshot(self, doc: RhinoDoc, archive: BinaryArchiveReader, archive_array: SimpleArrayBinaryArchiveReader, text_log: TextLog) -> bool: ...
    @overload
    def IsCurrentModelStateInAnySnapshot(self, doc: RhinoDoc, doc_object: RhinoObject, archive: BinaryArchiveReader, archive_array: SimpleArrayBinaryArchiveReader, text_log: TextLog) -> bool: ...
    def LayersCategory() -> str: ...
    def LightsCategory() -> str: ...
    def Name(self) -> str: ...
    def ObjectsCategory() -> str: ...
    def ObjectTransformNotification(self, doc: RhinoDoc, doc_object: RhinoObject, transform: Transform, archive: BinaryArchiveReader) -> Tuple[bool, Transform]: ...
    def PlugInId(self) -> Guid: ...
    def PrepareForDocumentAnimation(self, doc: RhinoDoc, archive_start: BinaryArchiveReader, archive_stop: BinaryArchiveReader) -> bool: ...
    def PrepareForObjectAnimation(self, doc: RhinoDoc, doc_object: RhinoObject, transform: Transform, archive_start: BinaryArchiveReader, archive_stop: BinaryArchiveReader) -> Tuple[bool, Transform]: ...
    def RegisterSnapShotClient(client: SnapShotsClient) -> bool: ...
    def RenderingCategory() -> str: ...
    def RestoreDocument(self, doc: RhinoDoc, archive: BinaryArchiveReader) -> bool: ...
    def RestoreObject(self, doc: RhinoDoc, doc_object: RhinoObject, transform: Transform, archive: BinaryArchiveReader) -> Tuple[bool, Transform]: ...
    def SaveDocument(self, doc: RhinoDoc, archive: BinaryArchiveWriter) -> bool: ...
    def SaveObject(self, doc: RhinoDoc, doc_object: RhinoObject, transform: Transform, archive: BinaryArchiveWriter) -> Tuple[bool, Transform]: ...
    @SerialNumber.setter
    def SerialNumber(self, value: int) -> None: ...
    def SnapshotRestored(self, doc: RhinoDoc) -> None: ...
    def SupportsAnimation(self) -> bool: ...
    def SupportsDocument(self) -> bool: ...
    def SupportsObject(self, doc_object: RhinoObject) -> bool: ...
    def SupportsObjects(self) -> bool: ...
    def ViewsCategory() -> str: ...
