from typing import Tuple, Set, Iterable, List


class BitmapTable:
    def AddBitmap(self, bitmapFilename: str, replaceExisting: bool) -> int: ...
    def Delete(self, item: BitmapEntry) -> bool: ...
    def DeleteBitmap(self, bitmapFilename: str) -> bool: ...
    def ExportToFile(self, index: int, path: str) -> bool: ...
    def ExportToFiles(self, directoryPath: str, overwrite: int) -> int: ...
    def Find(self, name: str, createFile: bool) -> Tuple[BitmapEntry, str]: ...
    def FindIndex(self, index: int) -> BitmapEntry: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Item(self, index: int) -> BitmapEntry: ...


class DimStyleTable:
    @overload
    def Add(self, name: str) -> int: ...
    @overload
    def Add(self, dimstyle: DimensionStyle, reference: bool) -> int: ...
    @overload
    def Add(self, name: str, reference: bool) -> int: ...
    @overload
    def Delete(self, item: DimensionStyle) -> bool: ...
    @overload
    def Delete(self, index: int, quiet: bool) -> bool: ...
    def Find(self, styleId: Guid, ignoreDeleted: bool) -> DimensionStyle: ...
    def FindIndex(self, index: int) -> DimensionStyle: ...
    def FindName(self, name: str) -> DimensionStyle: ...
    def FindRoot(self, styleId: Guid, ignoreDeleted: bool) -> DimensionStyle: ...
    @property
    def BuiltInStyles(self) -> Set(DimensionStyle): ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Current(self) -> DimensionStyle: ...
    @property
    def CurrentDimensionStyle(self) -> DimensionStyle: ...
    @property
    def CurrentId(self) -> Guid: ...
    @property
    def CurrentIndex(self) -> int: ...
    @property
    def Item(self, index: int) -> DimensionStyle: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def GetUnusedStyleName(self) -> str: ...
    @overload
    def GetUnusedStyleName(self, rootName: str) -> str: ...
    @overload
    def Modify(self, dimstyle: DimensionStyle, annotation: AnnotationBase) -> ModifyType: ...
    @overload
    def Modify(self, newSettings: DimensionStyle, dimstyleIndex: int, quiet: bool) -> bool: ...
    @overload
    def Modify(self, newSettings: DimensionStyle, dimstyleId: Guid, quiet: bool) -> bool: ...
    def SetCurrent(self, index: int, quiet: bool) -> bool: ...


class DimStyleTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> DimStyleTableEventType: ...
    @property
    def Index(self) -> int: ...
    @property
    def NewState(self) -> DimensionStyle: ...
    @property
    def OldState(self) -> DimensionStyle: ...


class DimStyleTableEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3
    Sorted = 4
    Current = 5


class FontTable:
    @overload
    def FindOrCreate(self, face: str, bold: bool, italic: bool) -> int: ...
    @overload
    def FindOrCreate(self, face: str, bold: bool, italic: bool, template_style: DimensionStyle) -> int: ...
    @property
    def Count(self) -> int: ...
    @property
    def CurrentIndex(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> Font: ...
    def GetEnumerator(self) -> IEnumerator: ...


class GroupTable:
    @overload
    def Add(self) -> int: ...
    @overload
    def Add(self, objectIds: Iterable[Guid]) -> int: ...
    @overload
    def Add(self, groupName: str) -> int: ...
    @overload
    def Add(self, groupName: str, objectIds: Iterable[Guid]) -> int: ...
    @overload
    def AddToGroup(self, groupIndex: int, objectId: Guid) -> bool: ...
    @overload
    def AddToGroup(self, groupIndex: int, objectIds: Iterable[Guid]) -> bool: ...
    def ChangeGroupName(self, groupIndex: int, newName: str) -> bool: ...
    @overload
    def Delete(self, groupIndex: int) -> bool: ...
    @overload
    def Delete(self, item: Group) -> bool: ...
    def Find(self, groupName: str) -> int: ...
    def FindIndex(self, index: int) -> Group: ...
    def FindName(self, name: str) -> Group: ...
    def FindNameHash(self, nameHash: NameHash) -> Group: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    def GroupMembers(self, groupIndex: int) -> Set(RhinoObject): ...
    def GroupName(self, groupIndex: int) -> str: ...
    def GroupNames(self, ignoreDeletedGroups: bool) -> Set(str): ...
    def GroupObjectCount(self, groupIndex: int) -> int: ...
    def Hide(self, groupIndex: int) -> int: ...
    def IsDeleted(self, groupIndex: int) -> bool: ...
    def Lock(self, groupIndex: int) -> int: ...
    def Show(self, groupIndex: int) -> int: ...
    def Undelete(self, groupIndex: int) -> bool: ...
    def Unlock(self, groupIndex: int) -> int: ...


class GroupTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> GroupTableEventType: ...
    @property
    def GroupIndex(self) -> int: ...
    @property
    def NewState(self) -> Group: ...
    @property
    def OldState(self) -> Group: ...


class GroupTableEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3
    Sorted = 4


class HatchPatternTable:
    def Add(self, pattern: HatchPattern) -> int: ...
    @overload
    def Delete(self, hatchPatternIndex: int) -> bool: ...
    @overload
    def Delete(self, item: HatchPattern) -> bool: ...
    @overload
    def Delete(self, item: HatchPattern, quiet: bool) -> bool: ...
    @overload
    def Delete(self, hatchPatternIndex: int, quiet: bool) -> bool: ...
    def FindIndex(self, index: int) -> HatchPattern: ...
    def FindName(self, name: str) -> HatchPattern: ...
    def FindNameHash(self, nameHash: NameHash) -> HatchPattern: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def CurrentHatchPatternIndex(self) -> int: ...
    @property
    def Item(self, index: int) -> HatchPattern: ...
    @overload
    def Rename(self, item: HatchPattern, hatchPatternName: str) -> bool: ...
    @overload
    def Rename(self, hatchPatternIndex: int, hatchPatternName: str) -> bool: ...
    @CurrentHatchPatternIndex.setter
    def CurrentHatchPatternIndex(self, value: int) -> None: ...


class InstanceDefinitionTable:
    @overload
    def Add(self, name: str, description: str, basePoint: Point3d, geometry: Iterable[GeometryBase]) -> int: ...
    @overload
    def Add(self, name: str, description: str, basePoint: Point3d, geometry: GeometryBase, attributes: ObjectAttributes) -> int: ...
    @overload
    def Add(self, name: str, description: str, basePoint: Point3d, geometry: Iterable[GeometryBase], attributes: Iterable[ObjectAttributes]) -> int: ...
    @overload
    def Add(self, name: str, description: str, url: str, urlTag: str, basePoint: Point3d, geometry: Iterable[GeometryBase], attributes: Iterable[ObjectAttributes]) -> int: ...
    def Compact(self, ignoreUndoReferences: bool) -> None: ...
    @overload
    def Delete(self, item: InstanceDefinition) -> bool: ...
    @overload
    def Delete(self, idefIndex: int, deleteReferences: bool, quiet: bool) -> bool: ...
    def DestroySourceArchive(self, definition: InstanceDefinition, quiet: bool) -> bool: ...
    @overload
    def Find(self, instanceDefinitionName: str) -> InstanceDefinition: ...
    @overload
    def Find(self, instanceId: Guid, ignoreDeletedInstanceDefinitions: bool) -> InstanceDefinition: ...
    @property
    def ActiveCount(self) -> int: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> InstanceDefinition: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetList(self, ignoreDeleted: bool) -> Set(InstanceDefinition): ...
    @overload
    def GetUnusedInstanceDefinitionName(self) -> str: ...
    @overload
    def GetUnusedInstanceDefinitionName(self, root: str) -> str: ...
    def InstanceDefinitionIndex(self, instanceId: Guid, ignoreDeletedInstanceDefinitions: bool) -> int: ...
    @overload
    def Modify(self, idefIndex: int, newName: str, newDescription: str, quiet: bool) -> bool: ...
    @overload
    def Modify(self, idef: InstanceDefinition, newName: str, newDescription: str, quiet: bool) -> bool: ...
    @overload
    def ModifyGeometry(self, idefIndex: int, newGeometry: Iterable[GeometryBase]) -> bool: ...
    @overload
    def ModifyGeometry(self, idefIndex: int, newGeometry: GeometryBase, newAttributes: ObjectAttributes) -> bool: ...
    @overload
    def ModifyGeometry(self, idefIndex: int, newGeometry: Iterable[GeometryBase], newAttributes: Iterable[ObjectAttributes]) -> bool: ...
    def ModifySourceArchive(self, idefIndex: int, sourceArchive: FileReference, updateType: InstanceDefinitionUpdateType, quiet: bool) -> bool: ...
    def Purge(self, idefIndex: int) -> bool: ...
    def RefreshLinkedBlock(self, definition: InstanceDefinition) -> bool: ...
    def Undelete(self, idefIndex: int) -> bool: ...
    def UndoModify(self, idefIndex: int) -> bool: ...
    def UpdateLinkedInstanceDefinition(self, idefIndex: int, filename: str, updateNestedLinks: bool, quiet: bool) -> bool: ...


class InstanceDefinitionTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> InstanceDefinitionTableEventType: ...
    @property
    def InstanceDefinitionIndex(self) -> int: ...
    @property
    def NewState(self) -> InstanceDefinition: ...
    @property
    def OldState(self) -> InstanceDefinitionGeometry: ...


class InstanceDefinitionTableEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3
    Sorted = 4


class LayerTable:
    @overload
    def Add(self) -> int: ...
    @overload
    def Add(self, layer: Layer) -> int: ...
    @overload
    def Add(self, layerName: str, layerColor: Color) -> int: ...
    @overload
    def AddReferenceLayer(self) -> int: ...
    @overload
    def AddReferenceLayer(self, layer: Layer) -> int: ...
    @overload
    def Delete(self, layer: Layer) -> bool: ...
    @overload
    def Delete(self, layerId: Guid, quiet: bool) -> bool: ...
    @overload
    def Delete(self, layer: Layer, quiet: bool) -> bool: ...
    @overload
    def Delete(self, layerIndex: int, quiet: bool) -> bool: ...
    @overload
    def Duplicate(self, layerIndices: Iterable[int], duplicateObjects: bool, duplicateSublayers: bool) -> Set(int): ...
    @overload
    def Duplicate(self, layerIndex: int, duplicateObjects: bool, duplicateSublayers: bool) -> Set(int): ...
    @overload
    def Find(self, layerId: Guid, ignoreDeletedLayers: bool, notFoundReturnValue: int) -> int: ...
    @overload
    def Find(self, parentId: Guid, layerName: str, notFoundReturnValue: int) -> int: ...
    def FindByFullPath(self, layerPath: str, notFoundReturnValue: int) -> int: ...
    def FindIndex(self, index: int) -> Layer: ...
    @overload
    def FindName(self, layerName: str) -> Layer: ...
    @overload
    def FindName(self, layerName: str, startIndex: int) -> Layer: ...
    def FindNameHash(self, nameHash: NameHash) -> Layer: ...
    def FindNext(self, index: int, layerName: str) -> Layer: ...
    @overload
    def ForceLayerVisible(self, layerId: Guid) -> bool: ...
    @overload
    def ForceLayerVisible(self, layerIndex: int) -> bool: ...
    @property
    def ActiveCount(self) -> int: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Count(self) -> int: ...
    @property
    def CurrentLayer(self) -> Layer: ...
    @property
    def CurrentLayerIndex(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> Layer: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetSelected(self) -> Tuple[bool, List]: ...
    def GetUnusedLayerName(self) -> str: ...
    @overload
    def Modify(self, newSettings: Layer, layerId: Guid, quiet: bool) -> bool: ...
    @overload
    def Modify(self, newSettings: Layer, layerIndex: int, quiet: bool) -> bool: ...
    @overload
    def Purge(self, layerId: Guid, quiet: bool) -> bool: ...
    @overload
    def Purge(self, layerIndex: int, quiet: bool) -> bool: ...
    def Select(self, layerIndices: Iterable[int], bDeselect: bool) -> bool: ...
    def SetCurrentLayerIndex(self, layerIndex: int, quiet: bool) -> bool: ...
    def Undelete(self, layerIndex: int) -> bool: ...
    @overload
    def UndoModify(self, layerId: Guid) -> bool: ...
    @overload
    def UndoModify(self, layerIndex: int) -> bool: ...
    @overload
    def UndoModify(self, layerId: Guid, undoRecordSerialNumber: UInt32) -> bool: ...
    @overload
    def UndoModify(self, layerIndex: int, undoRecordSerialNumber: UInt32) -> bool: ...


class LayerTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> LayerTableEventType: ...
    @property
    def LayerIndex(self) -> int: ...
    @property
    def NewState(self) -> Layer: ...
    @property
    def OldState(self) -> Layer: ...


class LayerTableEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3
    Sorted = 4
    Current = 5


class LightTable:
    @overload
    def Add(self, light: Light) -> int: ...
    @overload
    def Add(self, light: Light, attributes: ObjectAttributes) -> int: ...
    @overload
    def Delete(self, item: LightObject) -> bool: ...
    @overload
    def Delete(self, index: int, quiet: bool) -> bool: ...
    def Find(self, id: Guid, ignoreDeleted: bool) -> int: ...
    def FindIndex(self, index: int) -> LightObject: ...
    def FindName(self, name: str) -> LightObject: ...
    def FindNameHash(self, nameHash: NameHash) -> LightObject: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> LightObject: ...
    @property
    def Skylight(self) -> Skylight: ...
    @property
    def Sun(self) -> Sun: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def Modify(self, index: int, light: Light) -> bool: ...
    @overload
    def Modify(self, id: Guid, light: Light) -> bool: ...


class LightTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> LightTableEventType: ...
    @property
    def LightIndex(self) -> int: ...
    @property
    def NewState(self) -> LightObject: ...
    @property
    def OldState(self) -> Light: ...


class LightTableEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3
    Sorted = 4


class LinetypeTable:
    @overload
    def Add(self, linetype: Linetype) -> int: ...
    @overload
    def Add(self, name: str, segmentLengths: Iterable[float]) -> int: ...
    def AddReferenceLinetype(self, linetype: Linetype) -> int: ...
    @overload
    def Delete(self, item: Linetype) -> bool: ...
    @overload
    def Delete(self, indices: Iterable[int], quiet: bool) -> bool: ...
    @overload
    def Delete(self, index: int, quiet: bool) -> bool: ...
    @overload
    def Find(self, name: str) -> int: ...
    @overload
    def Find(self, id: Guid, ignoreDeletedLinetypes: bool) -> int: ...
    def FindIndex(self, index: int) -> Linetype: ...
    def FindName(self, name: str) -> Linetype: ...
    @property
    def ActiveCount(self) -> int: ...
    @property
    def ByLayerLinetypeName(self) -> str: ...
    @property
    def ByParentLinetypeName(self) -> str: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def ContinuousLinetypeName(self) -> str: ...
    @property
    def Count(self) -> int: ...
    @property
    def CurrentLinetype(self) -> Linetype: ...
    @property
    def CurrentLinetypeIndex(self) -> int: ...
    @property
    def CurrentLinetypeSource(self) -> ObjectLinetypeSource: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> Linetype: ...
    @property
    def LinetypeScale(self) -> float: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetUnusedLinetypeName(self) -> str: ...
    def LinetypeIndexForObject(self, rhinoObject: RhinoObject) -> int: ...
    def LoadDefaultLinetypes(self) -> int: ...
    def Modify(self, linetype: Linetype, index: int, quiet: bool) -> bool: ...
    @CurrentLinetypeSource.setter
    def CurrentLinetypeSource(self, value: ObjectLinetypeSource) -> None: ...
    @LinetypeScale.setter
    def LinetypeScale(self, value: float) -> None: ...
    def SetCurrentLinetypeIndex(self, linetypeIndex: int, quiet: bool) -> bool: ...
    def Undelete(self, index: int) -> bool: ...
    def UndoModify(self, index: int) -> bool: ...


class MaterialTable:
    @overload
    def Add(self) -> int: ...
    @overload
    def Add(self, material: Material) -> int: ...
    @overload
    def Add(self, material: Material, reference: bool) -> int: ...
    def Delete(self, item: Material) -> bool: ...
    def DeleteAt(self, materialIndex: int) -> bool: ...
    @overload
    def Find(self, materialId: Guid, ignoreDeletedMaterials: bool) -> int: ...
    @overload
    def Find(self, materialName: str, ignoreDeletedMaterials: bool) -> int: ...
    def FindIndex(self, index: int) -> Material: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def CurrentMaterialIndex(self) -> int: ...
    @property
    def CurrentMaterialSource(self) -> ObjectMaterialSource: ...
    @property
    def Item(self, index: int) -> Material: ...
    def Modify(self, newSettings: Material, materialIndex: int, quiet: bool) -> bool: ...
    def ResetMaterial(self, materialIndex: int) -> bool: ...
    @CurrentMaterialIndex.setter
    def CurrentMaterialIndex(self, value: int) -> None: ...
    @CurrentMaterialSource.setter
    def CurrentMaterialSource(self, value: ObjectMaterialSource) -> None: ...


class MaterialTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> MaterialTableEventType: ...
    @property
    def Index(self) -> int: ...
    @property
    def OldSettings(self) -> Material: ...


class MaterialTableEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3
    Sorted = 4
    Current = 5


class ModifyType:
    Modify = 0
    Override = 1
    NotSaved = 2


class NamedConstructionPlaneTable:
    def Add(self, name: str, plane: Plane) -> int: ...
    @overload
    def Delete(self, index: int) -> bool: ...
    @overload
    def Delete(self, name: str) -> bool: ...
    def Find(self, name: str) -> int: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> ConstructionPlane: ...
    def GetEnumerator(self) -> IEnumerator: ...


class NamedLayerStateTable:
    def Delete(self, name: str) -> bool: ...
    def FindName(self, name: str) -> int: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Names(self) -> Set(str): ...
    def Import(self, filename: str) -> int: ...
    def Rename(self, oldName: str, newName: str) -> bool: ...
    @overload
    def Restore(self, name: str, properties: RestoreLayerProperties) -> bool: ...
    @overload
    def Restore(self, name: str, properties: RestoreLayerProperties, viewportId: Guid) -> bool: ...
    @overload
    def Save(self, name: str) -> int: ...
    @overload
    def Save(self, name: str, viewportId: Guid) -> int: ...


class NamedPositionTable:
    @overload
    def Append(self, name: str, objects: Iterable[RhinoObject]) -> bool: ...
    @overload
    def Append(self, id: Guid, objects: Iterable[RhinoObject]) -> bool: ...
    @overload
    def Append(self, name: str, objectIds: Iterable[Guid]) -> bool: ...
    @overload
    def Append(self, id: Guid, objectIds: Iterable[Guid]) -> bool: ...
    @overload
    def Delete(self, name: str) -> bool: ...
    @overload
    def Delete(self, id: Guid) -> bool: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Ids(self) -> Set(Guid): ...
    @property
    def Names(self) -> Set(str): ...
    def Id(self, name: str) -> Guid: ...
    def Name(self, id: Guid) -> str: ...
    @overload
    def ObjectIds(self, name: str) -> Set(Guid): ...
    @overload
    def ObjectIds(self, id: Guid) -> Set(Guid): ...
    @overload
    def Objects(self, name: str) -> Set(RhinoObject): ...
    @overload
    def Objects(self, id: Guid) -> Set(RhinoObject): ...
    @overload
    def ObjectXform(self, id: Guid, objId: Guid, xform: Transform) -> Tuple[bool, Transform]: ...
    @overload
    def ObjectXform(self, id: Guid, obj: RhinoObject, xform: Transform) -> Tuple[bool, Transform]: ...
    @overload
    def Rename(self, id: Guid, name: str) -> bool: ...
    @overload
    def Rename(self, oldName: str, name: str) -> bool: ...
    @overload
    def Restore(self, name: str) -> bool: ...
    @overload
    def Restore(self, id: Guid) -> bool: ...
    @overload
    def Save(self, name: str, objects: Iterable[RhinoObject]) -> Guid: ...
    @overload
    def Save(self, name: str, objectIds: Iterable[Guid]) -> Guid: ...
    @overload
    def Update(self, id: Guid) -> bool: ...
    @overload
    def Update(self, name: str) -> bool: ...


class NamedViewTable:
    @overload
    def Add(self, view: ViewInfo) -> int: ...
    @overload
    def Add(self, name: str, viewportId: Guid) -> int: ...
    @overload
    def Delete(self, index: int) -> bool: ...
    @overload
    def Delete(self, name: str) -> bool: ...
    def FindByName(self, name: str) -> int: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Item(self, index: int) -> ViewInfo: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def Rename(self, index: int, newName: str) -> bool: ...
    @overload
    def Rename(self, oldName: str, newName: str) -> bool: ...
    def Restore(self, index: int, viewport: RhinoViewport) -> bool: ...
    def RestoreAnimatedConstantSpeed(self, index: int, viewport: RhinoViewport, units_per_frame: float, ms_delay: int) -> bool: ...
    def RestoreAnimatedConstantTime(self, index: int, viewport: RhinoViewport, frames: int, ms_delay: int) -> bool: ...
    def RestoreWithAspectRatio(self, index: int, viewport: RhinoViewport) -> bool: ...


class ObjectTable:
    @overload
    def Add(self, geometry: GeometryBase) -> Guid: ...
    @overload
    def Add(self, geometry: GeometryBase, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def Add(self, geometry: GeometryBase, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddAngularDimension(self, dimension: AngularDimension) -> Guid: ...
    @overload
    def AddAngularDimension(self, dimension: AngularDimension, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddAngularDimension(self, dimension: AngularDimension, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddArc(self, arc: Arc) -> Guid: ...
    @overload
    def AddArc(self, arc: Arc, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddArc(self, arc: Arc, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddBox(self, box: Box) -> Guid: ...
    @overload
    def AddBox(self, box: Box, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddBox(self, box: Box, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddBrep(self, brep: Brep) -> Guid: ...
    @overload
    def AddBrep(self, brep: Brep, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddBrep(self, brep: Brep, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddBrep(self, brep: Brep, attributes: ObjectAttributes, history: HistoryRecord, reference: bool, splitKinkySurfaces: bool) -> Guid: ...
    def AddCentermark(self, centermark: Centermark, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddCircle(self, circle: Circle) -> Guid: ...
    @overload
    def AddCircle(self, circle: Circle, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddCircle(self, circle: Circle, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportIds: Iterable[Guid]) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportId: Guid) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportIds: Iterable[Guid], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportId: Guid, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportIds: Iterable[Guid], attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddCurve(self, curve: Curve) -> Guid: ...
    @overload
    def AddCurve(self, curve: Curve, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddCurve(self, curve: Curve, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddEllipse(self, ellipse: Ellipse) -> Guid: ...
    @overload
    def AddEllipse(self, ellipse: Ellipse, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddEllipse(self, ellipse: Ellipse, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    def AddExplodedInstancePieces(self, instance: InstanceObject, explodeNestedInstances: bool, deleteInstance: bool) -> Set(Guid): ...
    @overload
    def AddExtrusion(self, extrusion: Extrusion) -> Guid: ...
    @overload
    def AddExtrusion(self, extrusion: Extrusion, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddExtrusion(self, extrusion: Extrusion, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddHatch(self, hatch: Hatch) -> Guid: ...
    @overload
    def AddHatch(self, hatch: Hatch, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddHatch(self, hatch: Hatch, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceDefinitionIndex: int, instanceXform: Transform) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceDefinitionIndex: int, instanceXform: Transform, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceDefinitionIndex: int, instanceXform: Transform, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddLeader(self, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddLeader(self, leader: Leader) -> Guid: ...
    @overload
    def AddLeader(self, plane: Plane, points: Iterable[Point2d]) -> Guid: ...
    @overload
    def AddLeader(self, leader: Leader, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLeader(self, text: str, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddLeader(self, plane: Plane, points: Iterable[Point2d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLeader(self, text: str, plane: Plane, points: Iterable[Point2d]) -> Guid: ...
    @overload
    def AddLeader(self, leader: Leader, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddLeader(self, text: str, plane: Plane, points: Iterable[Point2d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLeader(self, text: str, plane: Plane, points: Iterable[Point2d], attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddLine(self, line: Line) -> Guid: ...
    @overload
    def AddLine(self, from_: Point3d, to: Point3d) -> Guid: ...
    @overload
    def AddLine(self, line: Line, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLine(self, from_: Point3d, to: Point3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLine(self, from_: Point3d, to: Point3d, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddLinearDimension(self, dimension: LinearDimension) -> Guid: ...
    @overload
    def AddLinearDimension(self, dimension: LinearDimension, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLinearDimension(self, dimension: LinearDimension, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddMesh(self, mesh: Mesh) -> Guid: ...
    @overload
    def AddMesh(self, mesh: Mesh, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddMesh(self, mesh: Mesh, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddMesh(self, mesh: Mesh, attributes: ObjectAttributes, history: HistoryRecord, reference: bool, requireValidMesh: bool) -> Guid: ...
    @overload
    def AddMorphControl(self, morphControl: MorphControl) -> Guid: ...
    @overload
    def AddMorphControl(self, morphControl: MorphControl, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddMorphControl(self, morphControl: MorphControl, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    def AddOrdinateDimension(self, dimordinate: OrdinateDimension, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    def AddPictureFrame(self, plane: Plane, texturePath: str, asMesh: bool, width: float, height: float, selfIllumination: bool, embedBitmap: bool) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3d) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3f) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3f, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPoint(self, x: float, y: float, z: float) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3d, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddPoint(self, point: Point, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddPointCloud(self, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddPointCloud(self, cloud: PointCloud) -> Guid: ...
    @overload
    def AddPointCloud(self, cloud: PointCloud, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPointCloud(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPointCloud(self, cloud: PointCloud, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddPointCloud(self, points: Iterable[Point3d], attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddPoints(self, points: Iterable[Point3d]) -> RhinoList: ...
    @overload
    def AddPoints(self, points: Iterable[Point3f]) -> RhinoList: ...
    @overload
    def AddPoints(self, points: Iterable[Point3f], attributes: ObjectAttributes) -> RhinoList: ...
    @overload
    def AddPoints(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> RhinoList: ...
    @overload
    def AddPolyline(self, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddPolyline(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPolyline(self, points: Iterable[Point3d], attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddRadialDimension(self, dimension: RadialDimension) -> Guid: ...
    @overload
    def AddRadialDimension(self, dimension: RadialDimension, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddRadialDimension(self, dimension: RadialDimension, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddRectangle(self, rectangle: Rectangle3d) -> Guid: ...
    @overload
    def AddRectangle(self, rectangle: Rectangle3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddRectangle(self, rectangle: Rectangle3d, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddRhinoObject(self, meshObject: CustomMeshObject) -> None: ...
    @overload
    def AddRhinoObject(self, brepObject: CustomBrepObject) -> None: ...
    @overload
    def AddRhinoObject(self, pointObject: CustomPointObject) -> None: ...
    @overload
    def AddRhinoObject(self, meshObject: MeshObject, mesh: Mesh) -> None: ...
    @overload
    def AddRhinoObject(self, brepObject: CustomBrepObject, history: HistoryRecord) -> None: ...
    @overload
    def AddRhinoObject(self, brepObject: BrepObject, brep: Brep) -> None: ...
    @overload
    def AddRhinoObject(self, pointObject: CustomPointObject, history: HistoryRecord) -> None: ...
    @overload
    def AddRhinoObject(self, meshObject: CustomMeshObject, history: HistoryRecord) -> None: ...
    @overload
    def AddRhinoObject(self, pointObject: PointObject, point: Point) -> None: ...
    @overload
    def AddRhinoObject(self, curveObject: CurveObject, curve: Curve) -> None: ...
    @overload
    def AddRhinoObject(self, curveObject: CustomCurveObject, history: HistoryRecord) -> None: ...
    @overload
    def AddSphere(self, sphere: Sphere) -> Guid: ...
    @overload
    def AddSphere(self, sphere: Sphere, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddSphere(self, sphere: Sphere, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddSubD(self, subD: SubD) -> Guid: ...
    @overload
    def AddSubD(self, subD: SubD, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddSubD(self, subD: SubD, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddSurface(self, surface: Surface) -> Guid: ...
    @overload
    def AddSurface(self, surface: Surface, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddSurface(self, surface: Surface, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddText(self, text: TextEntity) -> Guid: ...
    @overload
    def AddText(self, text3d: Text3d) -> Guid: ...
    @overload
    def AddText(self, text: TextEntity, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text3d: Text3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text: TextEntity, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, justification: TextJustification) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, justification: TextJustification, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, justification: TextJustification, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    @overload
    def AddTextDot(self, dot: TextDot) -> Guid: ...
    @overload
    def AddTextDot(self, dot: TextDot, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddTextDot(self, text: str, location: Point3d) -> Guid: ...
    @overload
    def AddTextDot(self, text: str, location: Point3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddTextDot(self, dot: TextDot, attributes: ObjectAttributes, history: HistoryRecord, reference: bool) -> Guid: ...
    def AllObjectsSince(self, runtimeSerialNumber: UInt32) -> Set(RhinoObject): ...
    @overload
    def Delete(self, item: RhinoObject) -> bool: ...
    @overload
    def Delete(self, objref: ObjRef, quiet: bool) -> bool: ...
    @overload
    def Delete(self, obj: RhinoObject, quiet: bool) -> bool: ...
    @overload
    def Delete(self, objectId: Guid, quiet: bool) -> bool: ...
    @overload
    def Delete(self, objectIds: Iterable[Guid], quiet: bool) -> int: ...
    @overload
    def Delete(self, objref: ObjRef, quiet: bool, ignoreModes: bool) -> bool: ...
    @overload
    def Delete(self, obj: RhinoObject, quiet: bool, ignoreModes: bool) -> bool: ...
    @overload
    def DeleteGrip(self, gripId: Guid) -> bool: ...
    @overload
    def DeleteGrip(self, grip: GripObject) -> bool: ...
    @overload
    def DeleteGrip(self, gripRef: ObjRef) -> bool: ...
    @overload
    def DeleteGrips(self, gripIds: Iterable[Guid]) -> int: ...
    @overload
    def DeleteGrips(self, gripRefs: Iterable[ObjRef]) -> int: ...
    @overload
    def DeleteGrips(self, grips: Iterable[GripObject]) -> int: ...
    @overload
    def DeleteGrips(self, owner: RhinoObject, gripIndices: Iterable[int]) -> int: ...
    @overload
    def Duplicate(self, objref: ObjRef) -> Guid: ...
    @overload
    def Duplicate(self, objectId: Guid) -> Guid: ...
    @overload
    def Duplicate(self, obj: RhinoObject) -> Guid: ...
    @overload
    def Find(self, objectId: Guid) -> RhinoObject: ...
    @overload
    def Find(self, runtimeSerialNumber: UInt32) -> RhinoObject: ...
    @overload
    def FindByCrossingWindowRegion(self, viewport: RhinoViewport, region: Iterable[Point3d], inside: bool, filter: ObjectType) -> Set(RhinoObject): ...
    @overload
    def FindByCrossingWindowRegion(self, viewport: RhinoViewport, screen1: Point2d, screen2: Point2d, inside: bool, filter: ObjectType) -> Set(RhinoObject): ...
    def FindByDrawColor(self, drawColor: Color, includeLights: bool) -> Set(RhinoObject): ...
    def FindByFilter(self, filter: ObjectEnumeratorSettings) -> Set(RhinoObject): ...
    def FindByGroup(self, groupIndex: int) -> Set(RhinoObject): ...
    @overload
    def FindByLayer(self, layer: Layer) -> Set(RhinoObject): ...
    @overload
    def FindByLayer(self, layerName: str) -> Set(RhinoObject): ...
    def FindByObjectType(self, typeFilter: ObjectType) -> Set(RhinoObject): ...
    @overload
    def FindByUserString(self, key: str, value: str, caseSensitive: bool) -> Set(RhinoObject): ...
    @overload
    def FindByUserString(self, key: str, value: str, caseSensitive: bool, searchGeometry: bool, searchAttributes: bool, filter: ObjectType) -> Set(RhinoObject): ...
    @overload
    def FindByUserString(self, key: str, value: str, caseSensitive: bool, searchGeometry: bool, searchAttributes: bool, filter: ObjectEnumeratorSettings) -> Set(RhinoObject): ...
    @overload
    def FindByWindowRegion(self, viewport: RhinoViewport, region: Iterable[Point3d], inside: bool, filter: ObjectType) -> Set(RhinoObject): ...
    @overload
    def FindByWindowRegion(self, viewport: RhinoViewport, screen1: Point2d, screen2: Point2d, inside: bool, filter: ObjectType) -> Set(RhinoObject): ...
    def FindClippingPlanesForViewport(self, viewport: RhinoViewport) -> Set(ClippingPlaneObject): ...
    def FindGeometry(self, id: Guid) -> GeometryBase: ...
    def FindId(self, id: Guid) -> RhinoObject: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def BoundingBoxVisible(self) -> BoundingBox: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def HistoryRecordCount(self) -> int: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def GetObjectList(self, settings: ObjectEnumeratorSettings) -> Iterable[RhinoObject]: ...
    @overload
    def GetObjectList(self, typeFilter: ObjectType) -> Iterable[RhinoObject]: ...
    @overload
    def GetObjectList(self, typeFilter: Type) -> Iterable[RhinoObject]: ...
    @overload
    def GetObjectsByType(self) -> Iterable[T]: ...
    @overload
    def GetObjectsByType(self, settings: ObjectEnumeratorSettings) -> Iterable[T]: ...
    def GetSelectedObjects(self, includeLights: bool, includeGrips: bool) -> Iterable[RhinoObject]: ...
    def GetSelectedObjectTypes(self) -> ObjectType: ...
    def GripUpdate(self, obj: RhinoObject, deleteOriginal: bool) -> RhinoObject: ...
    @overload
    def Hide(self, objref: ObjRef, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Hide(self, objectId: Guid, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Hide(self, obj: RhinoObject, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Lock(self, objectId: Guid, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Lock(self, obj: RhinoObject, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Lock(self, objref: ObjRef, ignoreLayerMode: bool) -> bool: ...
    @overload
    def ModifyAttributes(self, obj: RhinoObject, newAttributes: ObjectAttributes, quiet: bool) -> bool: ...
    @overload
    def ModifyAttributes(self, objectId: Guid, newAttributes: ObjectAttributes, quiet: bool) -> bool: ...
    @overload
    def ModifyAttributes(self, objref: ObjRef, newAttributes: ObjectAttributes, quiet: bool) -> bool: ...
    @overload
    def ModifyRenderMaterial(self, objectId: Guid, material: RenderMaterial) -> bool: ...
    @overload
    def ModifyRenderMaterial(self, objRef: ObjRef, material: RenderMaterial) -> bool: ...
    @overload
    def ModifyRenderMaterial(self, obj: RhinoObject, material: RenderMaterial) -> bool: ...
    @overload
    def ModifyTextureMapping(self, obj: RhinoObject, channel: int, mapping: TextureMapping) -> bool: ...
    @overload
    def ModifyTextureMapping(self, objId: Guid, channel: int, mapping: TextureMapping) -> bool: ...
    @overload
    def ModifyTextureMapping(self, objRef: ObjRef, channel: int, mapping: TextureMapping) -> bool: ...
    def MostRecentObject(self) -> RhinoObject: ...
    def ObjectCount(self, filter: ObjectEnumeratorSettings) -> int: ...
    def PickObjects(self, pickContext: PickContext) -> Set(ObjRef): ...
    @overload
    def Purge(self, rhinoObject: RhinoObject) -> bool: ...
    @overload
    def Purge(self, runtimeSerialNumber: UInt32) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, pointcloud: PointCloud) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, dot: TextDot) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, point: Point3d) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, subD: SubD) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, mesh: Mesh) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, subD: SubD) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, mesh: Mesh) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, extrusion: Extrusion) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, extrusion: Extrusion) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, brep: Brep) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, brep: Brep) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, surface: Surface) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, surface: Surface) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, curve: Curve) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, curve: Curve) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, polyline: Polyline) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, polyline: Polyline) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, newObject: RhinoObject) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, arc: Arc) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, circle: Circle) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, circle: Circle) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, line: Line) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, line: Line) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, hatch: Hatch) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, hatch: Hatch) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, pointcloud: PointCloud) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, dot: TextDot) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, arc: Arc) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, leader: Leader) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, leader: Leader) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, text: TextEntity) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, text: TextEntity) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, point: Point) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, point: Point) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, point: Point3d) -> bool: ...
    @overload
    def Replace(self, objref: ObjRef, brep: Brep, splitKinkySurfaces: bool) -> bool: ...
    @overload
    def Replace(self, objectId: Guid, brep: Brep, splitKinkySurfaces: bool) -> bool: ...
    @overload
    def ReplaceInstanceObject(self, objectId: Guid, instanceDefinitionIndex: int) -> bool: ...
    @overload
    def ReplaceInstanceObject(self, objref: ObjRef, instanceDefinitionIndex: int) -> bool: ...
    @overload
    def Select(self, objectId: Guid) -> bool: ...
    @overload
    def Select(self, objectIds: Iterable[Guid]) -> int: ...
    @overload
    def Select(self, objref: ObjRef) -> bool: ...
    @overload
    def Select(self, objRefs: Iterable[ObjRef]) -> int: ...
    @overload
    def Select(self, objectIds: Iterable[Guid], select: bool) -> int: ...
    @overload
    def Select(self, objectId: Guid, select: bool) -> bool: ...
    @overload
    def Select(self, objRefs: Iterable[ObjRef], select: bool) -> int: ...
    @overload
    def Select(self, objref: ObjRef, select: bool) -> bool: ...
    @overload
    def Select(self, objectId: Guid, select: bool, syncHighlight: bool) -> bool: ...
    @overload
    def Select(self, objref: ObjRef, select: bool, syncHighlight: bool) -> bool: ...
    @overload
    def Select(self, objectId: Guid, select: bool, syncHighlight: bool, persistentSelect: bool) -> bool: ...
    @overload
    def Select(self, objref: ObjRef, select: bool, syncHighlight: bool, persistentSelect: bool) -> bool: ...
    @overload
    def Select(self, objectId: Guid, select: bool, syncHighlight: bool, persistentSelect: bool, ignoreGripsState: bool, ignoreLayerLocking: bool, ignoreLayerVisibility: bool) -> bool: ...
    @overload
    def Select(self, objref: ObjRef, select: bool, syncHighlight: bool, persistentSelect: bool, ignoreGripsState: bool, ignoreLayerLocking: bool, ignoreLayerVisibility: bool) -> bool: ...
    @overload
    def Show(self, objref: ObjRef, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Show(self, objectId: Guid, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Show(self, obj: RhinoObject, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Transform(self, objectId: Guid, xform: Transform, deleteOriginal: bool) -> Guid: ...
    @overload
    def Transform(self, obj: RhinoObject, xform: Transform, deleteOriginal: bool) -> Guid: ...
    @overload
    def Transform(self, objref: ObjRef, xform: Transform, deleteOriginal: bool) -> Guid: ...
    @overload
    def TransformWithHistory(self, objectId: Guid, xform: Transform) -> Guid: ...
    @overload
    def TransformWithHistory(self, obj: RhinoObject, xform: Transform) -> Guid: ...
    @overload
    def TransformWithHistory(self, objref: ObjRef, xform: Transform) -> Guid: ...
    def TryFindPoint(self, id: Guid) -> Tuple[bool, Point3d]: ...
    @overload
    def Undelete(self, rhinoObject: RhinoObject) -> bool: ...
    @overload
    def Undelete(self, runtimeSerialNumber: UInt32) -> bool: ...
    @overload
    def Unlock(self, objectId: Guid, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Unlock(self, obj: RhinoObject, ignoreLayerMode: bool) -> bool: ...
    @overload
    def Unlock(self, objref: ObjRef, ignoreLayerMode: bool) -> bool: ...
    @overload
    def UnselectAll(self) -> int: ...
    @overload
    def UnselectAll(self, ignorePersistentSelections: bool) -> int: ...


class RestoreLayerProperties:
    #None = 0
    Current = 1
    Visible = 2
    Locked = 4
    Color = 8
    Linetype = 16
    PrintColor = 32
    PrintWidth = 64
    ViewportVisible = 128
    ViewportColor = 256
    ViewportPrintColor = 512
    ViewportPrintWidth = 1024
    RenderMaterial = 2048
    Unused = 4096
    All = 4294967295




class RuntimeDocumentDataTable:
    @property
    def Document(self) -> RhinoDoc: ...
    def GetValue(self, key: Object, newT: Func) -> T: ...
    @overload
    def TryGetValue(self, key: Object) -> T: ...


class SnapshotTable:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Names(self) -> Set(str): ...


class StringTable:
    @overload
    def Delete(self, key: str) -> None: ...
    @overload
    def Delete(self, section: str, entry: str) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def DocumentDataCount(self) -> int: ...
    @property
    def DocumentUserTextCount(self) -> int: ...
    def GetEntryNames(self, section: str) -> Set(str): ...
    def GetKey(self, i: int) -> str: ...
    def GetSectionNames(self) -> Set(str): ...
    @overload
    def GetValue(self, key: str) -> str: ...
    @overload
    def GetValue(self, i: int) -> str: ...
    @overload
    def GetValue(self, section: str, entry: str) -> str: ...
    @overload
    def SetString(self, key: str, value: str) -> str: ...
    @overload
    def SetString(self, section: str, entry: str, value: str) -> str: ...


class ViewTable:
    def Add(self, title: str, projection: DefinedViewportProjection, position: Rectangle, floating: bool) -> RhinoView: ...
    @overload
    def AddPageView(self, title: str) -> RhinoPageView: ...
    @overload
    def AddPageView(self, title: str, pageWidth: float, pageHeight: float) -> RhinoPageView: ...
    def DefaultViewLayout(self) -> None: ...
    def EnableCameraIcon(self, view: RhinoView) -> None: ...
    def EnableRedraw(self, enable: bool, redrawDocument: bool, redrawLayers: bool) -> None: ...
    @overload
    def Find(self, mainViewportId: Guid) -> RhinoView: ...
    @overload
    def Find(self, mainViewportName: str, compareCase: bool) -> RhinoView: ...
    def FlashObjects(self, list: Iterable[RhinoObject], useSelectionColor: bool) -> None: ...
    def FourViewLayout(self, useMatchingViews: bool) -> None: ...
    @property
    def ActiveView(self) -> RhinoView: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def ModelSpaceIsActive(self) -> bool: ...
    @property
    def RedrawEnabled(self) -> bool: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetPageViews(self) -> Set(RhinoPageView): ...
    def GetStandardRhinoViews(self) -> Set(RhinoView): ...
    def GetViewList(self, includeStandardViews: bool, includePageViews: bool) -> Set(RhinoView): ...
    def IsCameraIconVisible(self, view: RhinoView) -> bool: ...
    def Redraw(self) -> None: ...
    @ActiveView.setter
    def ActiveView(self, value: RhinoView) -> None: ...
    @RedrawEnabled.setter
    def RedrawEnabled(self, value: bool) -> None: ...
    def ThreeViewLayout(self, useMatchingViews: bool) -> None: ...
