__all__ = ['Custom','SnapShots','Tables']
from typing import Tuple, Set, Iterable, List


class ActiveSpace:
    #None = 0
    ModelSpace = 1
    PageSpace = 2


class AngleDisplayFormat:
    DecimalDegrees = 0
    DegMinSec = 1
    Radians = 2
    Grads = 3


class AngleDisplayMode:
    Degrees = 0
    DMS = 1
    Grads = 2


class AngularDimensionObject(DimensionObject):
    @property
    def AngularDimensionGeometry(self) -> AngularDimension: ...


class AnimationProperties:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, source: AnimationProperties): ...
    def Dispose(self) -> None: ...
    @property
    def AnimationName(self) -> str: ...
    @property
    def CameraPathId(self) -> Guid: ...
    @property
    def CameraPoints(self) -> Set(Point3d): ...
    @property
    def CaptureMethod(self) -> str: ...
    @property
    def CaptureType(self) -> CaptureTypes: ...
    @property
    def Dates(self) -> Set(str): ...
    @property
    def DaysBetweenFrames(self) -> int: ...
    @property
    def DisplayMode(self) -> Guid: ...
    @property
    def EndDay(self) -> int: ...
    @property
    def EndHour(self) -> int: ...
    @property
    def EndMinutes(self) -> int: ...
    @property
    def EndMonth(self) -> int: ...
    @property
    def EndSeconds(self) -> int: ...
    @property
    def EndYear(self) -> int: ...
    @property
    def FileExtension(self) -> str: ...
    @property
    def FolderName(self) -> str: ...
    @property
    def FrameCount(self) -> int: ...
    @property
    def Images(self) -> Set(str): ...
    @property
    def Latitude(self) -> float: ...
    @property
    def LightIndex(self) -> int: ...
    @property
    def Longitude(self) -> float: ...
    @property
    def MinutesBetweenFrames(self) -> int: ...
    @property
    def NorthAngle(self) -> float: ...
    @property
    def RenderFull(self) -> bool: ...
    @property
    def RenderPreview(self) -> bool: ...
    @property
    def StartDay(self) -> int: ...
    @property
    def StartHour(self) -> int: ...
    @property
    def StartMinutes(self) -> int: ...
    @property
    def StartMonth(self) -> int: ...
    @property
    def StartSeconds(self) -> int: ...
    @property
    def StartYear(self) -> int: ...
    @property
    def TargetPathId(self) -> Guid: ...
    @property
    def TargetPoints(self) -> Set(Point3d): ...
    @property
    def ViewportName(self) -> str: ...
    @AnimationName.setter
    def AnimationName(self, value: str) -> None: ...
    @CameraPathId.setter
    def CameraPathId(self, value: Guid) -> None: ...
    @CameraPoints.setter
    def CameraPoints(self, value: Set(Point3d)) -> None: ...
    @CaptureMethod.setter
    def CaptureMethod(self, value: str) -> None: ...
    @CaptureType.setter
    def CaptureType(self, value: CaptureTypes) -> None: ...
    @Dates.setter
    def Dates(self, value: Set(str)) -> None: ...
    @DaysBetweenFrames.setter
    def DaysBetweenFrames(self, value: int) -> None: ...
    @DisplayMode.setter
    def DisplayMode(self, value: Guid) -> None: ...
    @EndDay.setter
    def EndDay(self, value: int) -> None: ...
    @EndHour.setter
    def EndHour(self, value: int) -> None: ...
    @EndMinutes.setter
    def EndMinutes(self, value: int) -> None: ...
    @EndMonth.setter
    def EndMonth(self, value: int) -> None: ...
    @EndSeconds.setter
    def EndSeconds(self, value: int) -> None: ...
    @EndYear.setter
    def EndYear(self, value: int) -> None: ...
    @FileExtension.setter
    def FileExtension(self, value: str) -> None: ...
    @FolderName.setter
    def FolderName(self, value: str) -> None: ...
    @FrameCount.setter
    def FrameCount(self, value: int) -> None: ...
    @Images.setter
    def Images(self, value: Set(str)) -> None: ...
    @Latitude.setter
    def Latitude(self, value: float) -> None: ...
    @LightIndex.setter
    def LightIndex(self, value: int) -> None: ...
    @Longitude.setter
    def Longitude(self, value: float) -> None: ...
    @MinutesBetweenFrames.setter
    def MinutesBetweenFrames(self, value: int) -> None: ...
    @NorthAngle.setter
    def NorthAngle(self, value: float) -> None: ...
    @RenderFull.setter
    def RenderFull(self, value: bool) -> None: ...
    @RenderPreview.setter
    def RenderPreview(self, value: bool) -> None: ...
    @StartDay.setter
    def StartDay(self, value: int) -> None: ...
    @StartHour.setter
    def StartHour(self, value: int) -> None: ...
    @StartMinutes.setter
    def StartMinutes(self, value: int) -> None: ...
    @StartMonth.setter
    def StartMonth(self, value: int) -> None: ...
    @StartSeconds.setter
    def StartSeconds(self, value: int) -> None: ...
    @StartYear.setter
    def StartYear(self, value: int) -> None: ...
    @TargetPathId.setter
    def TargetPathId(self, value: Guid) -> None: ...
    @TargetPoints.setter
    def TargetPoints(self, value: Set(Point3d)) -> None: ...
    @ViewportName.setter
    def ViewportName(self, value: str) -> None: ...


class AnnotationObjectBase(RhinoObject):
    @property
    def AnnotationGeometry(self) -> AnnotationBase: ...
    @property
    def DisplayText(self) -> str: ...
    @property
    def HasMeasurableTextFields(self) -> bool: ...


class ArrowFit:
    Auto = 0
    ArrowsInside = 1
    ArrowsOutside = 2


class ArrowType:
    #None = 0
    UserBlock = 1
    SolidTriangle = 2
    Dot = 3
    Tick = 4
    ShortTriangle = 5
    OpenArrow = 6
    Rectangle = 7
    LongTriangle = 8
    LongerTriangle = 9


class BasepointZero:
    GroundLevel = 0
    MeanSeaLevel = 1
    CenterOfEarth = 2


class BitmapEntry(ModelComponent):
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def FileName(self) -> str: ...
    @property
    def IsReference(self) -> bool: ...
    def Save(self, fileName: str) -> bool: ...


class BRDFs:
    GGX = 0
    Ward = 1


class BrepObject(RhinoObject):
    def DuplicateBrepGeometry(self) -> Brep: ...
    @property
    def BrepGeometry(self) -> Brep: ...


class CaptureTypes:
    Path = 0
    Turntable = 1
    Flythrough = 2
    DaySunStudy = 3
    SeasonalSunStudy = 4
    #None = 5


class CentermarkObject(DimensionObject):
    @property
    def CentermarkGeometry(self) -> Centermark: ...


class CenterMarkStyle:
    #None = 0
    Mark = 1
    MarkAndLines = 2


class ClippingPlaneObject(RhinoObject):
    def AddClipViewport(self, viewport: RhinoViewport, commit: bool) -> bool: ...
    @property
    def ClippingPlaneGeometry(self) -> ClippingPlaneSurface: ...
    def RemoveClipViewport(self, viewport: RhinoViewport, commit: bool) -> bool: ...


class ConstructionPlane:
    def __init__(self): ...
    @property
    def DepthBuffered(self) -> bool: ...
    @property
    def GridLineCount(self) -> int: ...
    @property
    def GridSpacing(self) -> float: ...
    @property
    def GridXColor(self) -> Color: ...
    @property
    def GridYColor(self) -> Color: ...
    @property
    def GridZColor(self) -> Color: ...
    @property
    def Name(self) -> str: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def ShowAxes(self) -> bool: ...
    @property
    def ShowGrid(self) -> bool: ...
    @property
    def ShowZAxis(self) -> bool: ...
    @property
    def SnapSpacing(self) -> float: ...
    @property
    def ThickLineColor(self) -> Color: ...
    @property
    def ThickLineFrequency(self) -> int: ...
    @property
    def ThinLineColor(self) -> Color: ...
    @DepthBuffered.setter
    def DepthBuffered(self, value: bool) -> None: ...
    @GridLineCount.setter
    def GridLineCount(self, value: int) -> None: ...
    @GridSpacing.setter
    def GridSpacing(self, value: float) -> None: ...
    @GridXColor.setter
    def GridXColor(self, value: Color) -> None: ...
    @GridYColor.setter
    def GridYColor(self, value: Color) -> None: ...
    @GridZColor.setter
    def GridZColor(self, value: Color) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @ShowAxes.setter
    def ShowAxes(self, value: bool) -> None: ...
    @ShowGrid.setter
    def ShowGrid(self, value: bool) -> None: ...
    @ShowZAxis.setter
    def ShowZAxis(self, value: bool) -> None: ...
    @SnapSpacing.setter
    def SnapSpacing(self, value: float) -> None: ...
    @ThickLineColor.setter
    def ThickLineColor(self, value: Color) -> None: ...
    @ThickLineFrequency.setter
    def ThickLineFrequency(self, value: int) -> None: ...
    @ThinLineColor.setter
    def ThinLineColor(self, value: Color) -> None: ...


class CoordinateSystem:
    World = 0
    Camera = 1
    Clip = 2
    Screen = 3


class CurveObject(RhinoObject):
    def DuplicateCurveGeometry(self) -> Curve: ...
    @property
    def CurveGeometry(self) -> Curve: ...


class Defaults:
    @property
    def Dash() -> HatchPattern: ...
    @property
    def Grid() -> HatchPattern: ...
    @property
    def Grid60() -> HatchPattern: ...
    @property
    def Hatch1() -> HatchPattern: ...
    @property
    def Hatch2() -> HatchPattern: ...
    @property
    def Hatch3() -> HatchPattern: ...
    @property
    def Plus() -> HatchPattern: ...
    @property
    def Solid() -> HatchPattern: ...
    @property
    def Squares() -> HatchPattern: ...


class DetailViewObject(RhinoObject):
    def CommitViewportChanges(self) -> bool: ...
    @property
    def DescriptiveTitle(self) -> str: ...
    @property
    def DetailGeometry(self) -> DetailView: ...
    @property
    def IsActive(self) -> bool: ...
    @property
    def PageToWorldTransform(self) -> Transform: ...
    @property
    def Viewport(self) -> RhinoViewport: ...
    @property
    def WorldToPageTransform(self) -> Transform: ...
    def GetFormattedScale(self, format: ScaleFormat) -> Tuple[bool, str]: ...
    @IsActive.setter
    def IsActive(self, value: bool) -> None: ...


class DimensionObject(AnnotationObjectBase):
    @property
    def DimensionStyle(self) -> DimensionStyle: ...


class DimensionStyle(ModelComponent):
    def __init__(self): ...
    def AlternateDimensionLengthDisplayUnit(self, model_serial_number: UInt32) -> UnitSystem: ...
    def ClearAllFieldOverrides(self) -> None: ...
    def ClearFieldOverride(self, field: Field) -> None: ...
    def CopyFrom(self, source: DimensionStyle) -> None: ...
    def CreatePreviewBitmap(self, width: int, height: int) -> Bitmap: ...
    def DimensionLengthDisplayUnit(self, model_serial_number: UInt32) -> UnitSystem: ...
    @overload
    def Duplicate(self) -> DimensionStyle: ...
    @overload
    def Duplicate(self, newName: str, newId: Guid, newParentId: Guid) -> DimensionStyle: ...
    @property
    def AlternateBelowLine(self) -> bool: ...
    @property
    def AlternateDimensionLengthDisplay(self) -> LengthDisplay: ...
    @property
    def AlternateLengthFactor(self) -> float: ...
    @property
    def AlternateLengthResolution(self) -> int: ...
    @property
    def AlternatePrefix(self) -> str: ...
    @property
    def AlternateRoundoff(self) -> float: ...
    @property
    def AlternateSuffix(self) -> str: ...
    @property
    def AlternateToleranceResolution(self) -> int: ...
    @property
    def AlternateUnitsDisplay(self) -> bool: ...
    @property
    def AlternateZeroSuppress(self) -> ZeroSuppression: ...
    @property
    def AngleFormat(self) -> AngleDisplayFormat: ...
    @property
    def AngleResolution(self) -> int: ...
    @property
    def AngleZeroSuppress(self) -> ZeroSuppression: ...
    @property
    def AngularRoundoff(self) -> float: ...
    @property
    def ArcLengthSymbol(self) -> int: ...
    @property
    def ArrowBlockId1(self) -> Guid: ...
    @property
    def ArrowBlockId2(self) -> Guid: ...
    @property
    def ArrowLength(self) -> float: ...
    @property
    def ArrowType1(self) -> ArrowType: ...
    @property
    def ArrowType2(self) -> ArrowType: ...
    @property
    def BaselineSpacing(self) -> float: ...
    @property
    def CentermarkSize(self) -> float: ...
    @property
    def CenterMarkType(self) -> CenterMarkStyle: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def DecimalSeparator(self) -> Char: ...
    @property
    def DimensionLengthDisplay(self) -> LengthDisplay: ...
    @property
    def DimensionLineExtension(self) -> float: ...
    @property
    def DimensionScale(self) -> float: ...
    @property
    def DimensionScaleValue(self) -> ScaleValue: ...
    @property
    def DimRadialTextAngleType(self) -> LeaderContentAngleStyle: ...
    @property
    def DimRadialTextLocation(self) -> TextLocation: ...
    @property
    def DimRadialTextOrientation(self) -> TextOrientation: ...
    @property
    def DimTextAngleType(self) -> LeaderContentAngleStyle: ...
    @property
    def DimTextLocation(self) -> TextLocation: ...
    @property
    def DimTextOrientation(self) -> TextOrientation: ...
    @property
    def DrawForward(self) -> bool: ...
    @property
    def DrawTextMask(self) -> bool: ...
    @property
    def ExtensionLineExtension(self) -> float: ...
    @property
    def ExtensionLineOffset(self) -> float: ...
    @property
    def FitArrow(self) -> ArrowFit: ...
    @property
    def FitText(self) -> TextFit: ...
    @property
    def FixedExtensionLength(self) -> float: ...
    @property
    def FixedExtensionOn(self) -> bool: ...
    @property
    def Font(self) -> Font: ...
    @property
    def ForceDimensionLineBetweenExtensionLines(self) -> bool: ...
    @property
    def HasFieldOverrides(self) -> bool: ...
    @property
    def IsChild(self) -> bool: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    @property
    def LeaderArrowBlockId(self) -> Guid: ...
    @property
    def LeaderArrowLength(self) -> float: ...
    @property
    def LeaderArrowType(self) -> ArrowType: ...
    @property
    def LeaderContentAngleType(self) -> LeaderContentAngleStyle: ...
    @property
    def LeaderCurveType(self) -> LeaderCurveStyle: ...
    @property
    def LeaderHasLanding(self) -> bool: ...
    @property
    def LeaderLandingLength(self) -> float: ...
    @property
    def LeaderTextHorizontalAlignment(self) -> TextHorizontalAlignment: ...
    @property
    def LeaderTextOrientation(self) -> TextOrientation: ...
    @property
    def LeaderTextRotationDegrees(self) -> float: ...
    @property
    def LeaderTextRotationRadians(self) -> float: ...
    @property
    def LeaderTextVerticalAlignment(self) -> TextVerticalAlignment: ...
    @property
    def LengthFactor(self) -> float: ...
    @property
    def LengthResolution(self) -> int: ...
    @property
    def MaskColor(self) -> Color: ...
    @property
    def MaskColorSource(self) -> MaskType: ...
    @property
    def MaskFrameType(self) -> MaskFrame: ...
    @property
    def MaskOffset(self) -> float: ...
    @property
    def ParentId(self) -> Guid: ...
    @property
    def Prefix(self) -> str: ...
    @property
    def Roundoff(self) -> float: ...
    @property
    def ScaleLeftLengthMillimeters(self) -> float: ...
    @property
    def ScaleRightLengthMillimeters(self) -> float: ...
    @property
    def StackFractionFormat(self) -> StackDisplayFormat: ...
    @property
    def StackHeightScale(self) -> float: ...
    @property
    def Suffix(self) -> str: ...
    @property
    def SuppressArrow1(self) -> bool: ...
    @property
    def SuppressArrow2(self) -> bool: ...
    @property
    def SuppressExtension1(self) -> bool: ...
    @property
    def SuppressExtension2(self) -> bool: ...
    @property
    def TextGap(self) -> float: ...
    @property
    def TextHeight(self) -> float: ...
    @property
    def TextHorizontalAlignment(self) -> TextHorizontalAlignment: ...
    @property
    def TextMoveLeader(self) -> int: ...
    @property
    def TextOrientation(self) -> TextOrientation: ...
    @property
    def TextRotation(self) -> float: ...
    @property
    def TextUnderlined(self) -> bool: ...
    @property
    def TextVerticalAlignment(self) -> TextVerticalAlignment: ...
    @property
    def ToleranceFormat(self) -> ToleranceDisplayFormat: ...
    @property
    def ToleranceHeightScale(self) -> float: ...
    @property
    def ToleranceLowerValue(self) -> float: ...
    @property
    def ToleranceResolution(self) -> int: ...
    @property
    def ToleranceUpperValue(self) -> float: ...
    @property
    def ToleranceZeroSuppress(self) -> ZeroSuppression: ...
    @property
    def ZeroSuppress(self) -> ZeroSuppression: ...
    def IsChildOf(self, parentId: Guid) -> bool: ...
    def IsFieldOverriden(self, field: Field) -> bool: ...
    def ScaleLengthValues(self, scale: float) -> None: ...
    @AlternateBelowLine.setter
    def AlternateBelowLine(self, value: bool) -> None: ...
    @AlternateDimensionLengthDisplay.setter
    def AlternateDimensionLengthDisplay(self, value: LengthDisplay) -> None: ...
    @AlternateLengthFactor.setter
    def AlternateLengthFactor(self, value: float) -> None: ...
    @AlternateLengthResolution.setter
    def AlternateLengthResolution(self, value: int) -> None: ...
    @AlternatePrefix.setter
    def AlternatePrefix(self, value: str) -> None: ...
    @AlternateRoundoff.setter
    def AlternateRoundoff(self, value: float) -> None: ...
    @AlternateSuffix.setter
    def AlternateSuffix(self, value: str) -> None: ...
    @AlternateToleranceResolution.setter
    def AlternateToleranceResolution(self, value: int) -> None: ...
    @AlternateUnitsDisplay.setter
    def AlternateUnitsDisplay(self, value: bool) -> None: ...
    @AlternateZeroSuppress.setter
    def AlternateZeroSuppress(self, value: ZeroSuppression) -> None: ...
    @AngleFormat.setter
    def AngleFormat(self, value: AngleDisplayFormat) -> None: ...
    @AngleResolution.setter
    def AngleResolution(self, value: int) -> None: ...
    @AngleZeroSuppress.setter
    def AngleZeroSuppress(self, value: ZeroSuppression) -> None: ...
    @AngularRoundoff.setter
    def AngularRoundoff(self, value: float) -> None: ...
    @ArcLengthSymbol.setter
    def ArcLengthSymbol(self, value: int) -> None: ...
    @ArrowBlockId1.setter
    def ArrowBlockId1(self, value: Guid) -> None: ...
    @ArrowBlockId2.setter
    def ArrowBlockId2(self, value: Guid) -> None: ...
    @ArrowLength.setter
    def ArrowLength(self, value: float) -> None: ...
    @ArrowType1.setter
    def ArrowType1(self, value: ArrowType) -> None: ...
    @ArrowType2.setter
    def ArrowType2(self, value: ArrowType) -> None: ...
    @BaselineSpacing.setter
    def BaselineSpacing(self, value: float) -> None: ...
    @CentermarkSize.setter
    def CentermarkSize(self, value: float) -> None: ...
    @CenterMarkType.setter
    def CenterMarkType(self, value: CenterMarkStyle) -> None: ...
    @DecimalSeparator.setter
    def DecimalSeparator(self, value: Char) -> None: ...
    @DimensionLengthDisplay.setter
    def DimensionLengthDisplay(self, value: LengthDisplay) -> None: ...
    @DimensionLineExtension.setter
    def DimensionLineExtension(self, value: float) -> None: ...
    @DimensionScale.setter
    def DimensionScale(self, value: float) -> None: ...
    @DimensionScaleValue.setter
    def DimensionScaleValue(self, value: ScaleValue) -> None: ...
    @DimRadialTextAngleType.setter
    def DimRadialTextAngleType(self, value: LeaderContentAngleStyle) -> None: ...
    @DimRadialTextLocation.setter
    def DimRadialTextLocation(self, value: TextLocation) -> None: ...
    @DimRadialTextOrientation.setter
    def DimRadialTextOrientation(self, value: TextOrientation) -> None: ...
    @DimTextAngleType.setter
    def DimTextAngleType(self, value: LeaderContentAngleStyle) -> None: ...
    @DimTextLocation.setter
    def DimTextLocation(self, value: TextLocation) -> None: ...
    @DimTextOrientation.setter
    def DimTextOrientation(self, value: TextOrientation) -> None: ...
    @DrawForward.setter
    def DrawForward(self, value: bool) -> None: ...
    @DrawTextMask.setter
    def DrawTextMask(self, value: bool) -> None: ...
    @ExtensionLineExtension.setter
    def ExtensionLineExtension(self, value: float) -> None: ...
    @ExtensionLineOffset.setter
    def ExtensionLineOffset(self, value: float) -> None: ...
    @FitArrow.setter
    def FitArrow(self, value: ArrowFit) -> None: ...
    @FitText.setter
    def FitText(self, value: TextFit) -> None: ...
    @FixedExtensionLength.setter
    def FixedExtensionLength(self, value: float) -> None: ...
    @FixedExtensionOn.setter
    def FixedExtensionOn(self, value: bool) -> None: ...
    @Font.setter
    def Font(self, value: Font) -> None: ...
    @ForceDimensionLineBetweenExtensionLines.setter
    def ForceDimensionLineBetweenExtensionLines(self, value: bool) -> None: ...
    @LeaderArrowBlockId.setter
    def LeaderArrowBlockId(self, value: Guid) -> None: ...
    @LeaderArrowLength.setter
    def LeaderArrowLength(self, value: float) -> None: ...
    @LeaderArrowType.setter
    def LeaderArrowType(self, value: ArrowType) -> None: ...
    @LeaderContentAngleType.setter
    def LeaderContentAngleType(self, value: LeaderContentAngleStyle) -> None: ...
    @LeaderCurveType.setter
    def LeaderCurveType(self, value: LeaderCurveStyle) -> None: ...
    @LeaderHasLanding.setter
    def LeaderHasLanding(self, value: bool) -> None: ...
    @LeaderLandingLength.setter
    def LeaderLandingLength(self, value: float) -> None: ...
    @LeaderTextHorizontalAlignment.setter
    def LeaderTextHorizontalAlignment(self, value: TextHorizontalAlignment) -> None: ...
    @LeaderTextOrientation.setter
    def LeaderTextOrientation(self, value: TextOrientation) -> None: ...
    @LeaderTextRotationDegrees.setter
    def LeaderTextRotationDegrees(self, value: float) -> None: ...
    @LeaderTextRotationRadians.setter
    def LeaderTextRotationRadians(self, value: float) -> None: ...
    @LeaderTextVerticalAlignment.setter
    def LeaderTextVerticalAlignment(self, value: TextVerticalAlignment) -> None: ...
    @LengthFactor.setter
    def LengthFactor(self, value: float) -> None: ...
    @LengthResolution.setter
    def LengthResolution(self, value: int) -> None: ...
    @MaskColor.setter
    def MaskColor(self, value: Color) -> None: ...
    @MaskColorSource.setter
    def MaskColorSource(self, value: MaskType) -> None: ...
    @MaskFrameType.setter
    def MaskFrameType(self, value: MaskFrame) -> None: ...
    @MaskOffset.setter
    def MaskOffset(self, value: float) -> None: ...
    @ParentId.setter
    def ParentId(self, value: Guid) -> None: ...
    @Prefix.setter
    def Prefix(self, value: str) -> None: ...
    @Roundoff.setter
    def Roundoff(self, value: float) -> None: ...
    @ScaleLeftLengthMillimeters.setter
    def ScaleLeftLengthMillimeters(self, value: float) -> None: ...
    @ScaleRightLengthMillimeters.setter
    def ScaleRightLengthMillimeters(self, value: float) -> None: ...
    @StackFractionFormat.setter
    def StackFractionFormat(self, value: StackDisplayFormat) -> None: ...
    @StackHeightScale.setter
    def StackHeightScale(self, value: float) -> None: ...
    @Suffix.setter
    def Suffix(self, value: str) -> None: ...
    @SuppressArrow1.setter
    def SuppressArrow1(self, value: bool) -> None: ...
    @SuppressArrow2.setter
    def SuppressArrow2(self, value: bool) -> None: ...
    @SuppressExtension1.setter
    def SuppressExtension1(self, value: bool) -> None: ...
    @SuppressExtension2.setter
    def SuppressExtension2(self, value: bool) -> None: ...
    @TextGap.setter
    def TextGap(self, value: float) -> None: ...
    @TextHeight.setter
    def TextHeight(self, value: float) -> None: ...
    @TextHorizontalAlignment.setter
    def TextHorizontalAlignment(self, value: TextHorizontalAlignment) -> None: ...
    @TextMoveLeader.setter
    def TextMoveLeader(self, value: int) -> None: ...
    @TextOrientation.setter
    def TextOrientation(self, value: TextOrientation) -> None: ...
    @TextRotation.setter
    def TextRotation(self, value: float) -> None: ...
    @TextUnderlined.setter
    def TextUnderlined(self, value: bool) -> None: ...
    @TextVerticalAlignment.setter
    def TextVerticalAlignment(self, value: TextVerticalAlignment) -> None: ...
    @ToleranceFormat.setter
    def ToleranceFormat(self, value: ToleranceDisplayFormat) -> None: ...
    @ToleranceHeightScale.setter
    def ToleranceHeightScale(self, value: float) -> None: ...
    @ToleranceLowerValue.setter
    def ToleranceLowerValue(self, value: float) -> None: ...
    @ToleranceResolution.setter
    def ToleranceResolution(self, value: int) -> None: ...
    @ToleranceUpperValue.setter
    def ToleranceUpperValue(self, value: float) -> None: ...
    @ToleranceZeroSuppress.setter
    def ToleranceZeroSuppress(self, value: ZeroSuppression) -> None: ...
    @ZeroSuppress.setter
    def ZeroSuppress(self, value: ZeroSuppression) -> None: ...
    def SetFieldOverride(self, field: Field) -> None: ...


class DisplayMode:
    Default = 0
    Wireframe = 1
    Shaded = 2
    RenderPreview = 3


class DistanceDisplayMode:
    Decimal = 0
    Feet = 1
    FeetAndInches = 2


class EarthAnchorPoint:
    def __init__(self): ...
    def Dispose(self) -> None: ...
    def EarthLocationIsSet(self) -> bool: ...
    @property
    def Description(self) -> str: ...
    @property
    def EarthBasepointElevation(self) -> float: ...
    @property
    def EarthBasepointElevationZero(self) -> BasepointZero: ...
    @property
    def EarthBasepointLatitude(self) -> float: ...
    @property
    def EarthBasepointLongitude(self) -> float: ...
    @property
    def ModelBasePoint(self) -> Point3d: ...
    @property
    def ModelEast(self) -> Vector3d: ...
    @property
    def ModelNorth(self) -> Vector3d: ...
    @property
    def Name(self) -> str: ...
    def GetEarthAnchorPlane(self) -> Tuple[Plane, Vector3d]: ...
    def GetModelCompass(self) -> Plane: ...
    def GetModelToEarthTransform(self, modelUnitSystem: UnitSystem) -> Transform: ...
    @Description.setter
    def Description(self, value: str) -> None: ...
    @EarthBasepointElevation.setter
    def EarthBasepointElevation(self, value: float) -> None: ...
    @EarthBasepointElevationZero.setter
    def EarthBasepointElevationZero(self, value: BasepointZero) -> None: ...
    @EarthBasepointLatitude.setter
    def EarthBasepointLatitude(self, value: float) -> None: ...
    @EarthBasepointLongitude.setter
    def EarthBasepointLongitude(self, value: float) -> None: ...
    @ModelBasePoint.setter
    def ModelBasePoint(self, value: Point3d) -> None: ...
    @ModelEast.setter
    def ModelEast(self, value: Vector3d) -> None: ...
    @ModelNorth.setter
    def ModelNorth(self, value: Vector3d) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...


class ExtrusionObject(RhinoObject):
    def DuplicateExtrusionGeometry(self) -> Extrusion: ...
    @property
    def ExtrusionGeometry(self) -> Extrusion: ...


class Field:
    Unset = 0
    Name = 1
    Index = 2
    ExtensionLineExtension = 3
    ExtensionLineOffset = 4
    Arrowsize = 5
    LeaderArrowsize = 6
    Centermark = 7
    TextGap = 8
    TextHeight = 9
    DimTextLocation = 10
    MaskFrameType = 11
    LengthResolution = 12
    AngleFormat = 13
    AngleResolution = 14
    Font = 15
    LengthFactor = 16
    Alternate = 17
    AlternateLengthFactor = 18
    AlternateLengthResolution = 20
    Prefix = 21
    Suffix = 22
    AlternatePrefix = 23
    AlternateSuffix = 24
    DimensionLineExtension = 25
    SuppressExtension1 = 26
    SuppressExtension2 = 27
    ExtLineColorSource = 28
    DimLineColorSource = 29
    ArrowColorSource = 30
    TextColorSource = 31
    ExtLineColor = 32
    DimLineColor = 33
    ArrowColor = 34
    TextColor = 35
    ExtLinePlotColorSource = 36
    DimLinePlotColorSource = 37
    ArrowPlotColorSource = 38
    TextPlotColorSource = 39
    ExtLinePlotColor = 40
    DimLinePlotColor = 41
    ArrowPlotColor = 42
    TextPlotColor = 43
    ExtLinePlotWeightSource = 44
    DimLinePlotWeightSource = 45
    ExtLinePlotWeight_mm = 46
    DimLinePlotWeight_mm = 47
    ToleranceFormat = 48
    ToleranceResolution = 49
    ToleranceUpperValue = 50
    ToleranceLowerValue = 51
    AltToleranceResolution = 52
    ToleranceHeightScale = 53
    BaselineSpacing = 54
    DrawMask = 55
    MaskColorSource = 56
    MaskColor = 57
    MaskBorder = 58
    DimensionScale = 59
    DimscaleSource = 60
    FixedExtensionLength = 61
    FixedExtensionOn = 62
    TextRotation = 63
    SuppressArrow1 = 64
    SuppressArrow2 = 65
    TextmoveLeader = 66
    ArclengthSymbol = 67
    StackTextheightScale = 68
    StackFormat = 69
    AltRound = 70
    Round = 71
    AngularRound = 72
    AltZeroSuppress = 73
    AngleZeroSuppress = 75
    ZeroSuppress = 76
    AltBelow = 77
    ArrowType1 = 78
    ArrowType2 = 79
    LeaderArrowType = 80
    ArrowBlockId1 = 81
    ArrowBlockId2 = 82
    LeaderArrowBlock = 83
    DimRadialTextLocation = 84
    TextVerticalAlignment = 85
    LeaderTextVerticalAlignment = 86
    LeaderContentAngleStyle = 87
    LeaderCurveType = 88
    LeaderContentAngle = 89
    LeaderHasLanding = 90
    LeaderLandingLength = 91
    MaskFlags = 92
    CentermarkStyle = 93
    TextHorizontalAlignment = 94
    LeaderTextHorizontalAlignment = 95
    DrawForward = 96
    SignedOrdinate = 97
    UnitSystem = 98
    TextMask = 99
    TextOrientation = 100
    LeaderTextOrientation = 101
    DimTextOrientation = 102
    DimRadialTextOrientation = 103
    DimTextAngleStyle = 104
    DimRadialTextAngleStyle = 105
    TextUnderlined = 106
    DimensionLengthDisplay = 109
    AlternateDimensionLengthDisplay = 110
    ForceDimLine = 111
    ArrowFit = 112
    TextFit = 113
    DecimalSeparator = 114
    Count = 115


class Font:
    @overload
    def __init__(self, familyName: str): ...
    @overload
    def __init__(self, familyName: str, weight: FontWeight, style: FontStyle, underlined: bool, strikethrough: bool): ...
    def AvailableFontFaceNames() -> Set(str): ...
    def FromQuartetProperties(quartetName: str, bold: bool, italic: bool) -> Font: ...
    @property
    def Bold(self) -> bool: ...
    @property
    def Description(self) -> str: ...
    @property
    def EnglishFaceName(self) -> str: ...
    @property
    def EnglishFamilyName(self) -> str: ...
    @property
    def EnglishQuartetName(self) -> str: ...
    @property
    def FaceName(self) -> str: ...
    @property
    def FamilyName(self) -> str: ...
    @property
    def FamilyPlusFaceName(self) -> str: ...
    @property
    def IsEngravingFont(self) -> bool: ...
    @property
    def IsSimulated(self) -> bool: ...
    @property
    def IsSingleStrokeFont(self) -> bool: ...
    @property
    def IsSymbolFont(self) -> bool: ...
    @property
    def Italic(self) -> bool: ...
    @property
    def LogfontName(self) -> str: ...
    @property
    def PointSize(self) -> float: ...
    @property
    def PostScriptName(self) -> str: ...
    @property
    def QuartetName(self) -> str: ...
    @property
    def RichTextFontName(self) -> str: ...
    @property
    def Strikeout(self) -> bool: ...
    @property
    def Style(self) -> FontStyle: ...
    @property
    def Underlined(self) -> bool: ...
    @property
    def Weight(self) -> FontWeight: ...
    @overload
    def InstalledFonts() -> Set(Font): ...
    @overload
    def InstalledFonts(familyName: str) -> Set(Font): ...
    def InstalledFontsAsQuartets() -> Set(FontQuartet): ...


class FontOrigin:
    Unset = 0
    Unknown = 1
    WindowsFont = 2
    AppleFont = 3


class FontQuartet:
    def __init__(self, name: str, supportsRegular: bool, supportsBold: bool, supportsItalic: bool, supportsBoldItalic: bool): ...
    @property
    def HasBoldFont(self) -> bool: ...
    @property
    def HasBoldItalicFont(self) -> bool: ...
    @property
    def HasItalicFont(self) -> bool: ...
    @property
    def HasRegularFont(self) -> bool: ...
    @property
    def QuartetName(self) -> str: ...
    def ToString(self) -> str: ...


class FontStretch:
    Unset = 0
    Ultracondensed = 1
    Extracondensed = 2
    Condensed = 3
    Semicondensed = 4
    Medium = 5
    Semiexpanded = 6
    Expanded = 7
    Extraexpanded = 8
    Ultraexpanded = 9


class FontStyle:
    Unset = 0
    Upright = 1
    Italic = 2
    Oblique = 3


class FontType:
    Unset = 0
    ManagedFont = 1
    InstalledFont = 2


class FontWeight:
    Unset = 0
    Thin = 1
    Ultralight = 2
    Light = 3
    Normal = 4
    Medium = 5
    Semibold = 6
    Bold = 7
    Ultrabold = 8
    Heavy = 9


class GripObject(RhinoObject):
    @property
    def CurrentLocation(self) -> Point3d: ...
    @property
    def Index(self) -> int: ...
    @property
    def Moved(self) -> bool: ...
    @property
    def OriginalLocation(self) -> Point3d: ...
    @property
    def OwnerId(self) -> Guid: ...
    @property
    def Weight(self) -> float: ...
    def GetCageParameters(self) -> Tuple[bool, float, float, float]: ...
    def GetCurveParameters(self) -> Tuple[bool, float]: ...
    def GetGripDirections(self) -> Tuple[bool, Vector3d, Vector3d, Vector3d]: ...
    def GetSurfaceParameters(self) -> Tuple[bool, float, float]: ...
    @overload
    def Move(self, delta: Vector3d) -> None: ...
    @overload
    def Move(self, xform: Transform) -> None: ...
    @overload
    def Move(self, newLocation: Point3d) -> None: ...
    def NeighborGrip(self, directionR: int, directionS: int, directionT: int, wrap: bool) -> GripObject: ...
    @CurrentLocation.setter
    def CurrentLocation(self, value: Point3d) -> None: ...
    @Index.setter
    def Index(self, value: int) -> None: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...
    def UndoMove(self) -> None: ...


class Group(ModelComponent):
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def UserStringCount(self) -> int: ...
    def GetUserString(self, key: str) -> str: ...
    def GetUserStrings(self) -> NameValueCollection: ...
    def SetUserString(self, key: str, value: str) -> bool: ...


class HatchObject(RhinoObject):
    @property
    def HatchGeometry(self) -> Hatch: ...


class HatchPattern(ModelComponent):
    def __init__(self): ...
    def CreatePreviewGeometry(self, width: int, height: int, angle: float) -> Set(Line): ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Description(self) -> str: ...
    @property
    def FillType(self) -> HatchPatternFillType: ...
    @property
    def Index(self) -> int: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    def ReadFromFile(filename: str, quiet: bool) -> Set(HatchPattern): ...
    @Description.setter
    def Description(self, value: str) -> None: ...
    @FillType.setter
    def FillType(self, value: HatchPatternFillType) -> None: ...
    @Index.setter
    def Index(self, value: int) -> None: ...


class HatchPatternFillType:
    Solid = 0
    Lines = 1
    Gradient = 2


class HistoryRecord:
    def __init__(self, command: Command, version: int): ...
    def Dispose(self) -> None: ...
    @property
    def CopyOnReplaceObject(self) -> bool: ...
    @property
    def Handle(self) -> IntPtr: ...
    @CopyOnReplaceObject.setter
    def CopyOnReplaceObject(self, value: bool) -> None: ...
    def SetBool(self, id: int, value: bool) -> bool: ...
    def SetBools(self, id: int, values: Iterable[bool]) -> bool: ...
    def SetBrep(self, id: int, value: Brep) -> bool: ...
    def SetColor(self, id: int, value: Color) -> bool: ...
    def SetColors(self, id: int, values: Iterable[Color]) -> bool: ...
    def SetCurve(self, id: int, value: Curve) -> bool: ...
    def SetDouble(self, id: int, value: float) -> bool: ...
    def SetDoubles(self, id: int, values: Iterable[float]) -> bool: ...
    def SetGuid(self, id: int, value: Guid) -> bool: ...
    def SetGuids(self, id: int, values: Iterable[Guid]) -> bool: ...
    def SetHistoryVersion(self, historyVersion: int) -> bool: ...
    def SetInt(self, id: int, value: int) -> bool: ...
    def SetInts(self, id: int, values: Iterable[int]) -> bool: ...
    def SetMesh(self, id: int, value: Mesh) -> bool: ...
    def SetObjRef(self, id: int, value: ObjRef) -> bool: ...
    def SetPoint3d(self, id: int, value: Point3d) -> bool: ...
    def SetPoint3dOnObject(self, id: int, objref: ObjRef, value: Point3d) -> bool: ...
    def SetPoint3ds(self, id: int, values: Iterable[Point3d]) -> bool: ...
    def SetString(self, id: int, value: str) -> bool: ...
    def SetStrings(self, id: int, values: Iterable[str]) -> bool: ...
    def SetSurface(self, id: int, value: Surface) -> bool: ...
    def SetTransorm(self, id: int, value: Transform) -> bool: ...
    def SetVector3d(self, id: int, value: Vector3d) -> bool: ...
    def SetVector3ds(self, id: int, values: Iterable[Vector3d]) -> bool: ...


class InstanceDefinition(InstanceDefinitionGeometry):
    @overload
    def CreatePreviewBitmap(self, definedViewportProjection: DefinedViewportProjection, bitmapSize: Size) -> Bitmap: ...
    @overload
    def CreatePreviewBitmap(self, definedViewportProjection: DefinedViewportProjection, bitmapSize: Size, applyDpiScaling: bool) -> Bitmap: ...
    @overload
    def CreatePreviewBitmap(self, definedViewportProjection: DefinedViewportProjection, displayMode: DisplayMode, bitmapSize: Size) -> Bitmap: ...
    @overload
    def CreatePreviewBitmap(self, definedViewportProjection: DefinedViewportProjection, displayMode: DisplayMode, bitmapSize: Size, applyDpiScaling: bool) -> Bitmap: ...
    @overload
    def CreatePreviewBitmap(self, definitionObjectId: Guid, definedViewportProjection: DefinedViewportProjection, displayMode: DisplayMode, bitmapSize: Size, applyDpiScaling: bool) -> Bitmap: ...
    def Equals(self, obj: Object) -> bool: ...
    @property
    def ArchiveFileStatus(self) -> InstanceDefinitionArchiveFileStatus: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Index(self) -> int: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    @property
    def IsTenuous(self) -> bool: ...
    @property
    def LayerStyle(self) -> InstanceDefinitionLayerStyle: ...
    @property
    def ObjectCount(self) -> int: ...
    @property
    def SkipNestedLinkedDefinitions(self) -> bool: ...
    @property
    def SourceArchive(self) -> str: ...
    @property
    def UnitSystem(self) -> UnitSystem: ...
    @property
    def UpdateType(self) -> InstanceDefinitionUpdateType: ...
    def GetContainers(self) -> Set(InstanceDefinition): ...
    def GetHashCode(self) -> int: ...
    def GetObjects(self) -> Set(RhinoObject): ...
    def GetReferences(self, wheretoLook: int) -> Set(InstanceObject): ...
    def InUse(self, wheretoLook: int) -> bool: ...
    def Object(self, index: int) -> RhinoObject: ...
    @overload
    def UseCount(self) -> int: ...
    @overload
    def UseCount(self) -> Tuple[int, int, int]: ...
    def UsesDefinition(self, otherIdefIndex: int) -> int: ...


class InstanceDefinitionArchiveFileStatus:
    LinkedFileIsUpToDate = 0
    LinkedFileIsNewer = 1
    LinkedFileIsOlder = 2
    LinkedFileIsDifferent = 3
    NotALinkedInstanceDefinition = -3
    LinkedFileNotReadable = -2
    LinkedFileNotFound = -1


class InstanceDefinitionLayerStyle:
    #None = 0
    Active = 1
    Reference = 2


class InstanceDefinitionUpdateType:
    Static = 0
    Embedded = 1
    LinkedAndEmbedded = 2
    Linked = 3


class InstanceObject(RhinoObject):
    def Explode(self, explodeNestedInstances: bool) -> Tuple[Set(RhinoObject), Set(ObjectAttributes), Set(Transform)]: ...
    @property
    def InsertionPoint(self) -> Point3d: ...
    @property
    def InstanceDefinition(self) -> InstanceDefinition: ...
    @property
    def InstanceXform(self) -> Transform: ...
    def UsesDefinition(self, definitionIndex: int) -> Tuple[bool, int]: ...


class Layer(ModelComponent):
    def __init__(self): ...
    def CopyAttributesFrom(self, otherLayer: Layer) -> None: ...
    def Default(self) -> None: ...
    def DeletePerViewportColor(self, viewportId: Guid) -> None: ...
    def DeletePerViewportPlotColor(self, viewportId: Guid) -> None: ...
    def DeletePerViewportPlotWeight(self, viewportId: Guid) -> None: ...
    def DeletePerViewportSettings(self, viewportId: Guid) -> None: ...
    def DeletePerViewportVisible(self, viewportId: Guid) -> None: ...
    @overload
    def Equals(self, other: Layer) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def Color(self) -> Color: ...
    @property
    def ComponentStatus(self) -> ComponentStatus: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def FullPath(self) -> str: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IgesLevel(self) -> int: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsExpanded(self) -> bool: ...
    @property
    def IsLocked(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    @property
    def IsVisible(self) -> bool: ...
    @property
    def LayerIndex(self) -> int: ...
    @property
    def LinetypeIndex(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @property
    def ParentLayerId(self) -> Guid: ...
    @property
    def PathSeparator() -> str: ...
    @property
    def PlotColor(self) -> Color: ...
    @property
    def PlotWeight(self) -> float: ...
    @property
    def RenderMaterial(self) -> RenderMaterial: ...
    @property
    def RenderMaterialIndex(self) -> int: ...
    @property
    def SortIndex(self) -> int: ...
    @property
    def UserStringCount(self) -> int: ...
    def GetChildren(self) -> Set(Layer): ...
    def GetDefaultLayerProperties() -> Layer: ...
    def GetHashCode(self) -> int: ...
    @overload
    def GetLeafName(fullPath: str) -> str: ...
    @overload
    def GetLeafName(layer: Layer) -> str: ...
    @overload
    def GetParentName(fullPath: str) -> str: ...
    @overload
    def GetParentName(layer: Layer) -> str: ...
    def GetPersistentLocking(self) -> bool: ...
    def GetPersistentVisibility(self) -> bool: ...
    def GetUserString(self, key: str) -> str: ...
    def GetUserStrings(self) -> NameValueCollection: ...
    def HasPerViewportSettings(self, viewportId: Guid) -> bool: ...
    @overload
    def IsChildOf(self, layerIndex: int) -> bool: ...
    @overload
    def IsChildOf(self, otherLayer: Layer) -> bool: ...
    @overload
    def IsChildOf(self, otherlayerId: Guid) -> bool: ...
    @overload
    def IsParentOf(self, layerIndex: int) -> bool: ...
    @overload
    def IsParentOf(self, otherLayer: Layer) -> bool: ...
    @overload
    def IsParentOf(self, otherLayer: Guid) -> bool: ...
    def IsValidName(name: str) -> bool: ...
    def op_Equality(left: Layer, right: Layer) -> bool: ...
    def op_Inequality(left: Layer, right: Layer) -> bool: ...
    def PerViewportColor(self, viewportId: Guid) -> Color: ...
    def PerViewportIsVisible(self, viewportId: Guid) -> bool: ...
    def PerViewportPersistentVisibility(self, viewportId: Guid) -> bool: ...
    def PerViewportPlotColor(self, viewportId: Guid) -> Color: ...
    def PerViewportPlotWeight(self, viewportId: Guid) -> float: ...
    @Color.setter
    def Color(self, value: Color) -> None: ...
    @ComponentStatus.setter
    def ComponentStatus(self, value: ComponentStatus) -> None: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @IgesLevel.setter
    def IgesLevel(self, value: int) -> None: ...
    @IsExpanded.setter
    def IsExpanded(self, value: bool) -> None: ...
    @IsLocked.setter
    def IsLocked(self, value: bool) -> None: ...
    @IsVisible.setter
    def IsVisible(self, value: bool) -> None: ...
    @LayerIndex.setter
    def LayerIndex(self, value: int) -> None: ...
    @LinetypeIndex.setter
    def LinetypeIndex(self, value: int) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @ParentLayerId.setter
    def ParentLayerId(self, value: Guid) -> None: ...
    @PlotColor.setter
    def PlotColor(self, value: Color) -> None: ...
    @PlotWeight.setter
    def PlotWeight(self, value: float) -> None: ...
    @RenderMaterial.setter
    def RenderMaterial(self, value: RenderMaterial) -> None: ...
    @RenderMaterialIndex.setter
    def RenderMaterialIndex(self, value: int) -> None: ...
    def SetPersistentLocking(self, persistentLocking: bool) -> None: ...
    def SetPersistentVisibility(self, persistentVisibility: bool) -> None: ...
    def SetPerViewportColor(self, viewportId: Guid, color: Color) -> None: ...
    def SetPerViewportPersistentVisibility(self, viewportId: Guid, persistentVisibility: bool) -> None: ...
    def SetPerViewportPlotColor(self, viewportId: Guid, color: Color) -> None: ...
    def SetPerViewportPlotWeight(self, viewportId: Guid, plotWeight: float) -> None: ...
    def SetPerViewportVisible(self, viewportId: Guid, visible: bool) -> None: ...
    def SetUserString(self, key: str, value: str) -> bool: ...
    def ToString(self) -> str: ...
    def UnsetPersistentLocking(self) -> None: ...
    def UnsetPersistentVisibility(self) -> None: ...
    def UnsetPerViewportPersistentVisibility(self, viewportId: Guid) -> None: ...


class LeaderContentAngleStyle:
    Horizontal = 0
    Aligned = 1
    Rotated = 2


class LeaderCurveStyle:
    #None = 0
    Polyline = 1
    Spline = 2


class LeaderObject(AnnotationObjectBase):
    @property
    def LeaderGeometry(self) -> Leader: ...


class LengthDisplay:
    ModelUnits = 0
    InchesFractional = 1
    FeetAndInches = 2
    Millmeters = 3
    Centimeters = 4
    Meters = 5
    Kilometers = 6
    InchesDecimal = 7
    FeetDecimal = 8
    Miles = 9


class LengthDisplayFormat:
    Decimal = 0
    Fractional = 1
    FeetInches = 2
    FeetDecimalInches = 3


class LightObject(RhinoObject):
    def DuplicateLightGeometry(self) -> Light: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def LightGeometry(self) -> Light: ...


class LinearDimensionObject(DimensionObject):
    @property
    def LinearDimensionGeometry(self) -> LinearDimension: ...


class Linetype(ModelComponent):
    def __init__(self): ...
    def AppendSegment(self, length: float, isSolid: bool) -> int: ...
    def CommitChanges(self) -> bool: ...
    def CreateFromPatternString(patternString: str, millimeters: bool) -> Linetype: ...
    def Default(self) -> None: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsModified(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    @property
    def LinetypeIndex(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @property
    def PatternLength(self) -> float: ...
    @property
    def SegmentCount(self) -> int: ...
    def GetSegment(self, index: int) -> Tuple[float, bool]: ...
    def PatternString(self, millimeters: bool) -> str: ...
    def ReadFromFile(path: str) -> Set(Linetype): ...
    def RemoveSegment(self, index: int) -> bool: ...
    @LinetypeIndex.setter
    def LinetypeIndex(self, value: int) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    def SetSegment(self, index: int, length: float, isSolid: bool) -> bool: ...
    def SetSegments(self, segments: Iterable[float]) -> bool: ...


class MaskFrame:
    NoFrame = 0
    RectFrame = 1


class MaskType:
    BackgroundColor = 0
    MaskColor = 1


class Material(ModelComponent):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: Material): ...
    def ClearMaterialChannels(self) -> None: ...
    def CommitChanges(self) -> bool: ...
    def CopyFrom(self, other: Material) -> None: ...
    def Default(self) -> None: ...
    @property
    def AlphaTransparency(self) -> bool: ...
    @property
    def AmbientColor(self) -> Color: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def DefaultMaterial() -> Material: ...
    @property
    def DiffuseColor(self) -> Color: ...
    @property
    def DisableLighting(self) -> bool: ...
    @property
    def EmissionColor(self) -> Color: ...
    @property
    def FresnelIndexOfRefraction(self) -> float: ...
    @property
    def FresnelReflections(self) -> bool: ...
    @property
    def IndexOfRefraction(self) -> float: ...
    @property
    def IsDefaultMaterial(self) -> bool: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsDocumentControlled(self) -> bool: ...
    @property
    def IsPhysicallyBased(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    @property
    def MaterialIndex(self) -> int: ...
    @property
    def MaxShine() -> float: ...
    @property
    def Name(self) -> str: ...
    @property
    def PhysicallyBased(self) -> PhysicallyBasedMaterial: ...
    @property
    def PreviewColor(self) -> Color: ...
    @property
    def ReflectionColor(self) -> Color: ...
    @property
    def ReflectionGlossiness(self) -> float: ...
    @property
    def Reflectivity(self) -> float: ...
    @property
    def RefractionGlossiness(self) -> float: ...
    @property
    def RenderMaterial(self) -> RenderMaterial: ...
    @property
    def RenderMaterialInstanceId(self) -> Guid: ...
    @property
    def RenderPlugInId(self) -> Guid: ...
    @property
    def Shine(self) -> float: ...
    @property
    def SpecularColor(self) -> Color: ...
    @property
    def Transparency(self) -> float: ...
    @property
    def TransparentColor(self) -> Color: ...
    @property
    def UseCount(self) -> int: ...
    @property
    def UserStringCount(self) -> int: ...
    def GetBitmapTexture(self) -> Texture: ...
    def GetBumpTexture(self) -> Texture: ...
    def GetEnvironmentTexture(self) -> Texture: ...
    def GetTexture(self, which: TextureType) -> Texture: ...
    def GetTextures(self) -> Set(Texture): ...
    def GetTransparencyTexture(self) -> Texture: ...
    def GetUserString(self, key: str) -> str: ...
    def GetUserStrings(self) -> NameValueCollection: ...
    def MaterialChannelIdFromIndex(self, material_channel_index: int) -> Guid: ...
    def MaterialChannelIndexFromId(self, material_channel_id: Guid, bAddIdIfNotPresent: bool) -> int: ...
    @AlphaTransparency.setter
    def AlphaTransparency(self, value: bool) -> None: ...
    @AmbientColor.setter
    def AmbientColor(self, value: Color) -> None: ...
    @DiffuseColor.setter
    def DiffuseColor(self, value: Color) -> None: ...
    @DisableLighting.setter
    def DisableLighting(self, value: bool) -> None: ...
    @EmissionColor.setter
    def EmissionColor(self, value: Color) -> None: ...
    @FresnelIndexOfRefraction.setter
    def FresnelIndexOfRefraction(self, value: float) -> None: ...
    @FresnelReflections.setter
    def FresnelReflections(self, value: bool) -> None: ...
    @IndexOfRefraction.setter
    def IndexOfRefraction(self, value: float) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @ReflectionColor.setter
    def ReflectionColor(self, value: Color) -> None: ...
    @ReflectionGlossiness.setter
    def ReflectionGlossiness(self, value: float) -> None: ...
    @Reflectivity.setter
    def Reflectivity(self, value: float) -> None: ...
    @RefractionGlossiness.setter
    def RefractionGlossiness(self, value: float) -> None: ...
    @RenderMaterialInstanceId.setter
    def RenderMaterialInstanceId(self, value: Guid) -> None: ...
    @RenderPlugInId.setter
    def RenderPlugInId(self, value: Guid) -> None: ...
    @Shine.setter
    def Shine(self, value: float) -> None: ...
    @SpecularColor.setter
    def SpecularColor(self, value: Color) -> None: ...
    @Transparency.setter
    def Transparency(self, value: float) -> None: ...
    @TransparentColor.setter
    def TransparentColor(self, value: Color) -> None: ...
    @overload
    def SetBitmapTexture(self, filename: str) -> bool: ...
    @overload
    def SetBitmapTexture(self, texture: Texture) -> bool: ...
    @overload
    def SetBumpTexture(self, filename: str) -> bool: ...
    @overload
    def SetBumpTexture(self, texture: Texture) -> bool: ...
    @overload
    def SetEnvironmentTexture(self, texture: Texture) -> bool: ...
    @overload
    def SetEnvironmentTexture(self, filename: str) -> bool: ...
    def SetTexture(self, texture: Texture, which: TextureType) -> bool: ...
    @overload
    def SetTransparencyTexture(self, filename: str) -> bool: ...
    @overload
    def SetTransparencyTexture(self, texture: Texture) -> bool: ...
    def SetUserString(self, key: str, value: str) -> bool: ...
    def ToPhysicallyBased(self) -> None: ...


class MaterialRef:
    def Dispose(self) -> None: ...
    @property
    def BackFaceMaterialId(self) -> Guid: ...
    @property
    def BackFaceMaterialIndex(self) -> int: ...
    @property
    def FrontFaceMaterialId(self) -> Guid: ...
    @property
    def FrontFaceMaterialIndex(self) -> int: ...
    @property
    def MaterialSource(self) -> ObjectMaterialSource: ...
    @property
    def PlugInId(self) -> Guid: ...


class MaterialRefCreateParams:
    def __init__(self): ...
    @property
    def BackFaceMaterialId(self) -> Guid: ...
    @property
    def BackFaceMaterialIndex(self) -> int: ...
    @property
    def FrontFaceMaterialId(self) -> Guid: ...
    @property
    def FrontFaceMaterialIndex(self) -> int: ...
    @property
    def MaterialSource(self) -> ObjectMaterialSource: ...
    @property
    def PlugInId(self) -> Guid: ...
    @BackFaceMaterialId.setter
    def BackFaceMaterialId(self, value: Guid) -> None: ...
    @BackFaceMaterialIndex.setter
    def BackFaceMaterialIndex(self, value: int) -> None: ...
    @FrontFaceMaterialId.setter
    def FrontFaceMaterialId(self, value: Guid) -> None: ...
    @FrontFaceMaterialIndex.setter
    def FrontFaceMaterialIndex(self, value: int) -> None: ...
    @MaterialSource.setter
    def MaterialSource(self, value: ObjectMaterialSource) -> None: ...
    @PlugInId.setter
    def PlugInId(self, value: Guid) -> None: ...


class MaterialRefs:
    @overload
    def Add(self, item: KeyValuePair) -> None: ...
    @overload
    def Add(self, key: Guid, value: MaterialRef) -> None: ...
    def Clear(self) -> None: ...
    def Contains(self, item: KeyValuePair) -> bool: ...
    def ContainsKey(self, key: Guid) -> bool: ...
    def CopyTo(self, array: Set(KeyValuePair), arrayIndex: int) -> None: ...
    def Create(self, createParams: MaterialRefCreateParams) -> MaterialRef: ...
    @property
    def Count(self) -> int: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Item(self, key: Guid) -> MaterialRef: ...
    @property
    def Keys(self) -> ICollection: ...
    @property
    def Values(self) -> ICollection: ...
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def Remove(self, item: KeyValuePair) -> bool: ...
    @overload
    def Remove(self, key: Guid) -> bool: ...
    @Item.setter
    def Item(self, key: Guid, value: MaterialRef) -> None: ...
    def TryGetValue(self, key: Guid) -> Tuple[bool, MaterialRef]: ...


class MeshObject(RhinoObject):
    def CheckMeshes(meshObjects: Iterable[MeshObject], textLog: TextLog, parameters: MeshCheckParameters) -> Tuple[bool, MeshCheckParameters]: ...
    def DuplicateMeshGeometry(self) -> Mesh: ...
    @property
    def IsCustomObject(self) -> bool: ...
    @property
    def MeshGeometry(self) -> Mesh: ...


class ModelComponent(CommonObject):
    def ClearId(self) -> None: ...
    def ClearIndex(self) -> None: ...
    def ClearName(self) -> None: ...
    def DataCRC(self, currentRemainder: UInt32) -> UInt32: ...
    @property
    def ComponentStatus(self) -> ComponentStatus: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def DeletedName(self) -> str: ...
    @property
    def HasId(self) -> bool: ...
    @property
    def HasIndex(self) -> bool: ...
    @property
    def HasName(self) -> bool: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IdIsLocked(self) -> bool: ...
    @property
    def Index(self) -> int: ...
    @property
    def IndexIsLocked(self) -> bool: ...
    @property
    def InstanceDefinitionModelSerialNumber(self) -> UInt32: ...
    @property
    def IsComponentStatusLocked(self) -> bool: ...
    @property
    def IsSystemComponent(self) -> bool: ...
    @property
    def ModelSerialNumber(self) -> UInt32: ...
    @property
    def Name(self) -> str: ...
    @property
    def NameIsLocked(self) -> bool: ...
    @property
    def ReferenceModelSerialNumber(self) -> UInt32: ...
    def IsValidComponentName(name: str) -> bool: ...
    def LockId(self) -> None: ...
    def LockIndex(self) -> None: ...
    def LockName(self) -> None: ...
    def ModelComponentTypeIgnoresCase(type: ModelComponentType) -> bool: ...
    def ModelComponentTypeIncludesParent(type: ModelComponentType) -> bool: ...
    def ModelComponentTypeRequiresUniqueName(type: ModelComponentType) -> bool: ...
    @ComponentStatus.setter
    def ComponentStatus(self, value: ComponentStatus) -> None: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @Index.setter
    def Index(self, value: int) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    def ToString(self) -> str: ...


class ModelComponentType:
    Unset = 0
    Image = 1
    TextureMapping = 2
    RenderMaterial = 3
    LinePattern = 4
    Layer = 5
    Group = 6
    TextStyle = 7
    DimStyle = 8
    RenderLight = 9
    HatchPattern = 10
    InstanceDefinition = 11
    ModelGeometry = 12
    HistoryRecord = 13
    Mixed = 254


class MorphControlObject(RhinoObject):
    pass


class NamedViewWidgetObject(RhinoObject):
    @property
    def AssociatedNamedView(self) -> str: ...


class ObjectAttributes(CommonObject):
    def __init__(self): ...
    def AddHideInDetailOverride(self, detailId: Guid) -> bool: ...
    def AddToGroup(self, groupIndex: int) -> None: ...
    @overload
    def ComputedPlotColor(self, document: RhinoDoc) -> Color: ...
    @overload
    def ComputedPlotColor(self, document: RhinoDoc, viewportId: Guid) -> Color: ...
    @overload
    def ComputedPlotWeight(self, document: RhinoDoc) -> float: ...
    @overload
    def ComputedPlotWeight(self, document: RhinoDoc, viewportId: Guid) -> float: ...
    def DeleteAllUserStrings(self) -> None: ...
    def DeleteUserString(self, key: str) -> bool: ...
    @overload
    def DrawColor(self, document: RhinoDoc) -> Color: ...
    @overload
    def DrawColor(self, document: RhinoDoc, viewportId: Guid) -> Color: ...
    def Duplicate(self) -> ObjectAttributes: ...
    @property
    def CastsShadows(self) -> bool: ...
    @property
    def ColorSource(self) -> ObjectColorSource: ...
    @property
    def CustomMeshingParameters(self) -> MeshingParameters: ...
    @property
    def Decals(self) -> Decals: ...
    @property
    def DisplayOrder(self) -> int: ...
    @property
    def GroupCount(self) -> int: ...
    @property
    def HasMapping(self) -> bool: ...
    @property
    def IsDocumentControlled(self) -> bool: ...
    @property
    def IsInstanceDefinitionObject(self) -> bool: ...
    @property
    def LayerIndex(self) -> int: ...
    @property
    def LinetypeIndex(self) -> int: ...
    @property
    def LinetypeSource(self) -> ObjectLinetypeSource: ...
    @property
    def MaterialIndex(self) -> int: ...
    @property
    def MaterialRefs(self) -> MaterialRefs: ...
    @property
    def MaterialSource(self) -> ObjectMaterialSource: ...
    @property
    def Mode(self) -> ObjectMode: ...
    @property
    def Name(self) -> str: ...
    @property
    def ObjectColor(self) -> Color: ...
    @property
    def ObjectDecoration(self) -> ObjectDecoration: ...
    @property
    def ObjectId(self) -> Guid: ...
    @property
    def PlotColor(self) -> Color: ...
    @property
    def PlotColorSource(self) -> ObjectPlotColorSource: ...
    @property
    def PlotWeight(self) -> float: ...
    @property
    def PlotWeightSource(self) -> ObjectPlotWeightSource: ...
    @property
    def ReceivesShadows(self) -> bool: ...
    @property
    def Space(self) -> ActiveSpace: ...
    @property
    def Url(self) -> str: ...
    @property
    def UserStringCount(self) -> int: ...
    @property
    def ViewportId(self) -> Guid: ...
    @property
    def Visible(self) -> bool: ...
    @property
    def WireDensity(self) -> int: ...
    def GetDisplayModeOverride(self, viewportId: Guid) -> Guid: ...
    def GetGroupList(self) -> Set(int): ...
    def GetHideInDetailOverrides(self) -> Set(Guid): ...
    def GetUserString(self, key: str) -> str: ...
    def GetUserStrings(self) -> NameValueCollection: ...
    def HasDisplayModeOverride(self, viewportId: Guid) -> bool: ...
    def HasHideInDetailOverrideSet(self, detailId: Guid) -> bool: ...
    @overload
    def RemoveDisplayModeOverride(self) -> None: ...
    @overload
    def RemoveDisplayModeOverride(self, rhinoViewportId: Guid) -> None: ...
    def RemoveFromAllGroups(self) -> None: ...
    def RemoveFromGroup(self, groupIndex: int) -> None: ...
    def RemoveHideInDetailOverride(self, detailId: Guid) -> bool: ...
    @CastsShadows.setter
    def CastsShadows(self, value: bool) -> None: ...
    @ColorSource.setter
    def ColorSource(self, value: ObjectColorSource) -> None: ...
    @CustomMeshingParameters.setter
    def CustomMeshingParameters(self, value: MeshingParameters) -> None: ...
    @DisplayOrder.setter
    def DisplayOrder(self, value: int) -> None: ...
    @LayerIndex.setter
    def LayerIndex(self, value: int) -> None: ...
    @LinetypeIndex.setter
    def LinetypeIndex(self, value: int) -> None: ...
    @LinetypeSource.setter
    def LinetypeSource(self, value: ObjectLinetypeSource) -> None: ...
    @MaterialIndex.setter
    def MaterialIndex(self, value: int) -> None: ...
    @MaterialSource.setter
    def MaterialSource(self, value: ObjectMaterialSource) -> None: ...
    @Mode.setter
    def Mode(self, value: ObjectMode) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @ObjectColor.setter
    def ObjectColor(self, value: Color) -> None: ...
    @ObjectDecoration.setter
    def ObjectDecoration(self, value: ObjectDecoration) -> None: ...
    @ObjectId.setter
    def ObjectId(self, value: Guid) -> None: ...
    @PlotColor.setter
    def PlotColor(self, value: Color) -> None: ...
    @PlotColorSource.setter
    def PlotColorSource(self, value: ObjectPlotColorSource) -> None: ...
    @PlotWeight.setter
    def PlotWeight(self, value: float) -> None: ...
    @PlotWeightSource.setter
    def PlotWeightSource(self, value: ObjectPlotWeightSource) -> None: ...
    @ReceivesShadows.setter
    def ReceivesShadows(self, value: bool) -> None: ...
    @Space.setter
    def Space(self, value: ActiveSpace) -> None: ...
    @Url.setter
    def Url(self, value: str) -> None: ...
    @ViewportId.setter
    def ViewportId(self, value: Guid) -> None: ...
    @Visible.setter
    def Visible(self, value: bool) -> None: ...
    @WireDensity.setter
    def WireDensity(self, value: int) -> None: ...
    @overload
    def SetDisplayModeOverride(self, mode: DisplayModeDescription) -> bool: ...
    @overload
    def SetDisplayModeOverride(self, mode: DisplayModeDescription, rhinoViewportId: Guid) -> bool: ...
    def SetUserString(self, key: str, value: str) -> bool: ...
    def Transform(self, xform: Transform) -> bool: ...


class ObjectColorSource:
    ColorFromLayer = 0
    ColorFromObject = 1
    ColorFromMaterial = 2
    ColorFromParent = 3


class ObjectDecoration:
    #None = 0
    StartArrowhead = 8
    EndArrowhead = 16
    BothArrowhead = 24


class ObjectEnumeratorSettings:
    def __init__(self): ...
    @property
    def ActiveObjects(self) -> bool: ...
    @property
    def ClassTypeFilter(self) -> Type: ...
    @property
    def DeletedObjects(self) -> bool: ...
    @property
    def HiddenObjects(self) -> bool: ...
    @property
    def IdefObjects(self) -> bool: ...
    @property
    def IncludeGrips(self) -> bool: ...
    @property
    def IncludeLights(self) -> bool: ...
    @property
    def IncludePhantoms(self) -> bool: ...
    @property
    def LayerIndexFilter(self) -> int: ...
    @property
    def LockedObjects(self) -> bool: ...
    @property
    def NameFilter(self) -> str: ...
    @property
    def NormalObjects(self) -> bool: ...
    @property
    def ObjectTypeFilter(self) -> ObjectType: ...
    @property
    def ReferenceObjects(self) -> bool: ...
    @property
    def SelectedObjectsFilter(self) -> bool: ...
    @property
    def SubObjectSelected(self) -> bool: ...
    @property
    def ViewportFilter(self) -> RhinoViewport: ...
    @property
    def VisibleFilter(self) -> bool: ...
    @ActiveObjects.setter
    def ActiveObjects(self, value: bool) -> None: ...
    @ClassTypeFilter.setter
    def ClassTypeFilter(self, value: Type) -> None: ...
    @DeletedObjects.setter
    def DeletedObjects(self, value: bool) -> None: ...
    @HiddenObjects.setter
    def HiddenObjects(self, value: bool) -> None: ...
    @IdefObjects.setter
    def IdefObjects(self, value: bool) -> None: ...
    @IncludeGrips.setter
    def IncludeGrips(self, value: bool) -> None: ...
    @IncludeLights.setter
    def IncludeLights(self, value: bool) -> None: ...
    @IncludePhantoms.setter
    def IncludePhantoms(self, value: bool) -> None: ...
    @LayerIndexFilter.setter
    def LayerIndexFilter(self, value: int) -> None: ...
    @LockedObjects.setter
    def LockedObjects(self, value: bool) -> None: ...
    @NameFilter.setter
    def NameFilter(self, value: str) -> None: ...
    @NormalObjects.setter
    def NormalObjects(self, value: bool) -> None: ...
    @ObjectTypeFilter.setter
    def ObjectTypeFilter(self, value: ObjectType) -> None: ...
    @ReferenceObjects.setter
    def ReferenceObjects(self, value: bool) -> None: ...
    @SelectedObjectsFilter.setter
    def SelectedObjectsFilter(self, value: bool) -> None: ...
    @SubObjectSelected.setter
    def SubObjectSelected(self, value: bool) -> None: ...
    @ViewportFilter.setter
    def ViewportFilter(self, value: RhinoViewport) -> None: ...
    @VisibleFilter.setter
    def VisibleFilter(self, value: bool) -> None: ...


class ObjectLinetypeSource:
    LinetypeFromLayer = 0
    LinetypeFromObject = 1
    LinetypeFromParent = 3


class ObjectMaterialSource:
    MaterialFromLayer = 0
    MaterialFromObject = 1
    MaterialFromParent = 3


class ObjectMode:
    Normal = 0
    Hidden = 1
    Locked = 2
    InstanceDefinitionObject = 3


class ObjectPlotColorSource:
    PlotColorFromLayer = 0
    PlotColorFromObject = 1
    PlotColorFromDisplay = 2
    PlotColorFromParent = 3


class ObjectPlotWeightSource:
    PlotWeightFromLayer = 0
    PlotWeightFromObject = 1
    PlotWeightFromParent = 3


class ObjectType:
    #None = 0
    Point = 1
    PointSet = 2
    Curve = 4
    Surface = 8
    Brep = 16
    Mesh = 32
    Light = 256
    Annotation = 512
    InstanceDefinition = 2048
    InstanceReference = 4096
    TextDot = 8192
    Grip = 16384
    Detail = 32768
    Hatch = 65536
    MorphControl = 131072
    SubD = 262144
    BrepLoop = 524288
    BrepVertex = 1048576
    PolysrfFilter = 2097152
    EdgeFilter = 4194304
    PolyedgeFilter = 8388608
    MeshVertex = 16777216
    MeshEdge = 33554432
    MeshFace = 67108864
    Cage = 134217728
    Phantom = 268435456
    ClipPlane = 536870912
    Extrusion = 1073741824
    AnyObject = 4294967295


class ObjRef:
    @overload
    def __init__(self, other: ObjRef): ...
    @overload
    def __init__(self, id: Guid): ...
    @overload
    def __init__(self, rhinoObject: RhinoObject): ...
    @overload
    def __init__(self, doc: RhinoDoc, id: Guid): ...
    @overload
    def __init__(self, id: Guid, ci: ComponentIndex): ...
    @overload
    def __init__(self, rhinoObject: RhinoObject, pickContext: PickContext): ...
    @overload
    def __init__(self, doc: RhinoDoc, id: Guid, ci: ComponentIndex): ...
    def Brep(self) -> Brep: ...
    def ClippingPlaneSurface(self) -> ClippingPlaneSurface: ...
    def Curve(self) -> Curve: ...
    def CurveParameter(self) -> Tuple[Curve, float]: ...
    def Dispose(self) -> None: ...
    def Edge(self) -> BrepEdge: ...
    def Face(self) -> BrepFace: ...
    def Geometry(self) -> GeometryBase: ...
    @property
    def GeometryComponentIndex(self) -> ComponentIndex: ...
    @property
    def ObjectId(self) -> Guid: ...
    @property
    def RuntimeSerialNumber(self) -> UInt32: ...
    def Hatch(self) -> Hatch: ...
    def InstanceDefinitionPart(self) -> RhinoObject: ...
    def Light(self) -> Light: ...
    def Mesh(self) -> Mesh: ...
    def Object(self) -> RhinoObject: ...
    def Point(self) -> Point: ...
    def PointCloud(self) -> PointCloud: ...
    def SelectionMethod(self) -> SelectionMethod: ...
    def SelectionPoint(self) -> Point3d: ...
    def SelectionView(self) -> RhinoView: ...
    def SelectionViewDetailSerialNumber(self) -> UInt32: ...
    def SetSelectionComponent(self, componentIndex: ComponentIndex) -> None: ...
    def SubD(self) -> SubD: ...
    def SubDFace(self) -> SubDFace: ...
    def Surface(self) -> Surface: ...
    def SurfaceParameter(self) -> Tuple[Surface, float, float]: ...
    def TextDot(self) -> TextDot: ...
    def TextEntity(self) -> TextEntity: ...
    def Trim(self) -> BrepTrim: ...


class OrdinateDimensionObject(DimensionObject):
    @property
    def OrdinateDimensionGeometry(self) -> OrdinateDimension: ...


class PhysicallyBasedMaterial:
    @property
    def Alpha(self) -> float: ...
    @property
    def Anisotropic(self) -> float: ...
    @property
    def AnisotropicRotation(self) -> float: ...
    @property
    def BaseColor(self) -> Color4f: ...
    @property
    def BRDF(self) -> BRDFs: ...
    @property
    def Clearcoat(self) -> float: ...
    @property
    def ClearcoatRoughness(self) -> float: ...
    @property
    def Emission(self) -> Color4f: ...
    @property
    def Material(self) -> Material: ...
    @property
    def Metallic(self) -> float: ...
    @property
    def Opacity(self) -> float: ...
    @property
    def OpacityIOR(self) -> float: ...
    @property
    def OpacityRoughness(self) -> float: ...
    @property
    def ReflectiveIOR(self) -> float: ...
    @property
    def Roughness(self) -> float: ...
    @property
    def Sheen(self) -> float: ...
    @property
    def SheenTint(self) -> float: ...
    @property
    def Specular(self) -> float: ...
    @property
    def SpecularTint(self) -> float: ...
    @property
    def Subsurface(self) -> float: ...
    @property
    def SubsurfaceScatteringColor(self) -> Color4f: ...
    @property
    def SubsurfaceScatteringRadius(self) -> float: ...
    @property
    def UseBaseColorTextureAlphaForObjectAlphaTransparencyTexture(self) -> bool: ...
    def GetTexture(self, which: TextureType) -> Texture: ...
    def GetTextures(self) -> Set(Texture): ...
    @Alpha.setter
    def Alpha(self, value: float) -> None: ...
    @Anisotropic.setter
    def Anisotropic(self, value: float) -> None: ...
    @AnisotropicRotation.setter
    def AnisotropicRotation(self, value: float) -> None: ...
    @BaseColor.setter
    def BaseColor(self, value: Color4f) -> None: ...
    @BRDF.setter
    def BRDF(self, value: BRDFs) -> None: ...
    @Clearcoat.setter
    def Clearcoat(self, value: float) -> None: ...
    @ClearcoatRoughness.setter
    def ClearcoatRoughness(self, value: float) -> None: ...
    @Emission.setter
    def Emission(self, value: Color4f) -> None: ...
    @Metallic.setter
    def Metallic(self, value: float) -> None: ...
    @Opacity.setter
    def Opacity(self, value: float) -> None: ...
    @OpacityIOR.setter
    def OpacityIOR(self, value: float) -> None: ...
    @OpacityRoughness.setter
    def OpacityRoughness(self, value: float) -> None: ...
    @ReflectiveIOR.setter
    def ReflectiveIOR(self, value: float) -> None: ...
    @Roughness.setter
    def Roughness(self, value: float) -> None: ...
    @Sheen.setter
    def Sheen(self, value: float) -> None: ...
    @SheenTint.setter
    def SheenTint(self, value: float) -> None: ...
    @Specular.setter
    def Specular(self, value: float) -> None: ...
    @SpecularTint.setter
    def SpecularTint(self, value: float) -> None: ...
    @Subsurface.setter
    def Subsurface(self, value: float) -> None: ...
    @SubsurfaceScatteringColor.setter
    def SubsurfaceScatteringColor(self, value: Color4f) -> None: ...
    @SubsurfaceScatteringRadius.setter
    def SubsurfaceScatteringRadius(self, value: float) -> None: ...
    @UseBaseColorTextureAlphaForObjectAlphaTransparencyTexture.setter
    def UseBaseColorTextureAlphaForObjectAlphaTransparencyTexture(self, value: bool) -> None: ...
    def SetTexture(self, texture: Texture, which: TextureType) -> bool: ...
    def SynchronizeLegacyMaterial(self) -> None: ...


class PointCloudObject(RhinoObject):
    def DuplicatePointCloudGeometry(self) -> PointCloud: ...
    @property
    def PointCloudGeometry(self) -> PointCloud: ...


class PointObject(RhinoObject):
    def DuplicatePointGeometry(self) -> Point: ...
    @property
    def PointGeometry(self) -> Point: ...


class ProxyObject(RhinoObject):
    def CreateMeshes(self, meshType: MeshType, parameters: MeshingParameters, ignoreCustomParameters: bool) -> int: ...
    def GetMeshes(self, meshType: MeshType) -> Set(Mesh): ...


class RadialDimensionObject(DimensionObject):
    @property
    def RadialDimensionGeometry(self) -> RadialDimension: ...


class ReplayHistoryData:
    def Dispose(self) -> None: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def HistoryVersion(self) -> int: ...
    @property
    def RecordId(self) -> Guid: ...
    @property
    def Results(self) -> Set(ReplayHistoryResult): ...
    def GetRhinoObjRef(self, id: int) -> ObjRef: ...
    def TryGetBool(self, id: int) -> Tuple[bool, bool]: ...
    def TryGetColor(self, id: int) -> Tuple[bool, Color]: ...
    def TryGetDouble(self, id: int) -> Tuple[bool, float]: ...
    def TryGetDoubles(self, id: int) -> Tuple[bool, Set(float)]: ...
    def TryGetGuid(self, id: int) -> Tuple[bool, Guid]: ...
    def TryGetInt(self, id: int) -> Tuple[bool, int]: ...
    def TryGetPoint3d(self, id: int) -> Tuple[bool, Point3d]: ...
    def TryGetPoint3dOnObject(self, id: int) -> Tuple[bool, Point3d]: ...
    def TryGetString(self, id: int) -> Tuple[bool, str]: ...
    def TryGetTransform(self, id: int) -> Tuple[bool, Transform]: ...
    def TryGetVector3d(self, id: int) -> Tuple[bool, Vector3d]: ...


class ReplayHistoryResult:
    @property
    def ExistingObject(self) -> RhinoObject: ...
    def UpdateToAngularDimension(self, dimension: AngularDimension, attributes: ObjectAttributes) -> bool: ...
    def UpdateToArc(self, arc: Arc, attributes: ObjectAttributes) -> bool: ...
    def UpdateToBrep(self, brep: Brep, attributes: ObjectAttributes) -> bool: ...
    def UpdateToCircle(self, circle: Circle, attributes: ObjectAttributes) -> bool: ...
    @overload
    def UpdateToClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportIds: Iterable[Guid], attributes: ObjectAttributes) -> bool: ...
    @overload
    def UpdateToClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportId: Guid, attributes: ObjectAttributes) -> bool: ...
    def UpdateToCurve(self, curve: Curve, attributes: ObjectAttributes) -> bool: ...
    def UpdateToEllipse(self, ellipse: Ellipse, attributes: ObjectAttributes) -> bool: ...
    def UpdateToExtrusion(self, extrusion: Extrusion, attributes: ObjectAttributes) -> bool: ...
    def UpdateToHatch(self, hatch: Hatch, attributes: ObjectAttributes) -> bool: ...
    def UpdateToLeader(self, leader: Leader, attributes: ObjectAttributes) -> bool: ...
    def UpdateToLine(self, from_: Point3d, to: Point3d, attributes: ObjectAttributes) -> bool: ...
    def UpdateToLinearDimension(self, dimension: LinearDimension, attributes: ObjectAttributes) -> bool: ...
    def UpdateToMesh(self, mesh: Mesh, attributes: ObjectAttributes) -> bool: ...
    def UpdateToPoint(self, point: Point3d, attributes: ObjectAttributes) -> bool: ...
    @overload
    def UpdateToPointCloud(self, cloud: PointCloud, attributes: ObjectAttributes) -> bool: ...
    @overload
    def UpdateToPointCloud(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> bool: ...
    def UpdateToPolyline(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> bool: ...
    def UpdateToRadialDimension(self, dimension: RadialDimension, attributes: ObjectAttributes) -> bool: ...
    def UpdateToSphere(self, sphere: Sphere, attributes: ObjectAttributes) -> bool: ...
    def UpdateToSurface(self, surface: Surface, attributes: ObjectAttributes) -> bool: ...
    @overload
    def UpdateToText(self, text: TextEntity, attributes: ObjectAttributes) -> bool: ...
    @overload
    def UpdateToText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, justification: TextJustification, attributes: ObjectAttributes) -> bool: ...
    def UpdateToTextDot(self, dot: TextDot, attributes: ObjectAttributes) -> bool: ...


class RhinoDeselectAllObjectsEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def ObjectCount(self) -> int: ...


class RhinoModifyObjectAttributesEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def NewAttributes(self) -> ObjectAttributes: ...
    @property
    def OldAttributes(self) -> ObjectAttributes: ...
    @property
    def RhinoObject(self) -> RhinoObject: ...


class RhinoObject(ModelComponent):
    def CommitChanges(self) -> bool: ...
    def CopyHistoryOnReplace(self) -> bool: ...
    def CreateMeshes(self, meshType: MeshType, parameters: MeshingParameters, ignoreCustomParameters: bool) -> int: ...
    def Description(self, textLog: TextLog) -> None: ...
    def DuplicateGeometry(self) -> GeometryBase: ...
    def EnableCustomGrips(self, customGrips: CustomObjectGrips) -> bool: ...
    def EnableVisualAnalysisMode(self, mode: VisualAnalysisMode, enable: bool) -> bool: ...
    def FromRuntimeSerialNumber(serialNumber: UInt32) -> RhinoObject: ...
    @property
    def Attributes(self) -> ObjectAttributes: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Geometry(self) -> GeometryBase: ...
    @property
    def GripsOn(self) -> bool: ...
    @property
    def GripsSelected(self) -> bool: ...
    @property
    def GroupCount(self) -> int: ...
    @property
    def HasDynamicTransform(self) -> bool: ...
    @property
    def HasSubobjectMaterials(self) -> bool: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def InstanceDefinitionModelSerialNumber(self) -> UInt32: ...
    @property
    def IsDeletable(self) -> bool: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsHidden(self) -> bool: ...
    @property
    def IsInstanceDefinitionGeometry(self) -> bool: ...
    @property
    def IsLocked(self) -> bool: ...
    @property
    def IsNormal(self) -> bool: ...
    @property
    def IsReference(self) -> bool: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def Name(self) -> str: ...
    @property
    def NextRuntimeSerialNumber() -> UInt32: ...
    @property
    def ObjectType(self) -> ObjectType: ...
    @property
    def ReferenceModelSerialNumber(self) -> UInt32: ...
    @property
    def RenderMaterial(self) -> RenderMaterial: ...
    @property
    def RuntimeSerialNumber(self) -> UInt32: ...
    @property
    def SubobjectMaterialComponents(self) -> Set(ComponentIndex): ...
    @property
    def Visible(self) -> bool: ...
    @property
    def WorksessionReferenceSerialNumber(self) -> UInt32: ...
    def GetActiveVisualAnalysisModes(self) -> Set(VisualAnalysisMode): ...
    def GetCustomRenderMeshParameter(self, providerId: Guid, parameterName: str) -> IConvertible: ...
    def GetDynamicTransform(self) -> Tuple[bool, Transform]: ...
    @overload
    def GetFillSurfaces(rhinoObject: RhinoObject, clippingPlaneObject: ClippingPlaneObject) -> Set(Brep): ...
    @overload
    def GetFillSurfaces(rhinoObject: RhinoObject, clippingPlaneObjects: Iterable[ClippingPlaneObject]) -> Set(Brep): ...
    @overload
    def GetFillSurfaces(rhinoObject: RhinoObject, clippingPlaneObjects: Iterable[ClippingPlaneObject], unclippedFills: bool) -> Set(Brep): ...
    def GetGrips(self) -> Set(GripObject): ...
    def GetGroupList(self) -> Set(int): ...
    def GetHighlightedSubObjects(self) -> Set(ComponentIndex): ...
    @overload
    def GetMaterial(self, componentIndex: ComponentIndex) -> Material: ...
    @overload
    def GetMaterial(self, frontMaterial: bool) -> Material: ...
    @overload
    def GetMaterial(self, componentIndex: ComponentIndex, plugInId: Guid) -> Material: ...
    @overload
    def GetMaterial(self, componentIndex: ComponentIndex, plugInId: Guid, attributes: ObjectAttributes) -> Material: ...
    def GetMeshes(self, meshType: MeshType) -> Set(Mesh): ...
    @overload
    def GetRenderMaterial(self, componentIndex: ComponentIndex) -> RenderMaterial: ...
    @overload
    def GetRenderMaterial(self, frontMaterial: bool) -> RenderMaterial: ...
    @overload
    def GetRenderMaterial(self, componentIndex: ComponentIndex, plugInId: Guid) -> RenderMaterial: ...
    @overload
    def GetRenderMaterial(self, componentIndex: ComponentIndex, plugInId: Guid, attributes: ObjectAttributes) -> RenderMaterial: ...
    def GetRenderMeshes(rhinoObjects: Iterable[RhinoObject], okToCreate: bool, returnAllObjects: bool) -> Set(ObjRef): ...
    def GetRenderMeshesWithUpdatedTCs(rhinoObjects: Iterable[RhinoObject], okToCreate: bool, returnAllObjects: bool, skipHiddenObjects: bool, updateMeshTCs: bool) -> Set(ObjRef): ...
    @overload
    def GetRenderMeshParameters(self) -> MeshingParameters: ...
    @overload
    def GetRenderMeshParameters(self, returnDocumentParametersIfUnset: bool) -> MeshingParameters: ...
    def GetRenderPrimitiveList(self, viewport: ViewportInfo, attrs: DisplayPipelineAttributes) -> RenderPrimitiveList: ...
    def GetSelectedSubObjects(self) -> Set(ComponentIndex): ...
    def GetSubObjects(self) -> Set(RhinoObject): ...
    def GetTextureChannels(self) -> Set(int): ...
    @overload
    def GetTextureMapping(self, channel: int) -> TextureMapping: ...
    @overload
    def GetTextureMapping(self, channel: int) -> Tuple[TextureMapping, Transform]: ...
    @overload
    def GetTightBoundingBox(rhinoObjects: Iterable[RhinoObject]) -> Tuple[bool, BoundingBox]: ...
    @overload
    def GetTightBoundingBox(rhinoObjects: Iterable[RhinoObject], plane: Plane) -> Tuple[bool, BoundingBox]: ...
    def HasHistoryRecord(self) -> bool: ...
    def HasTextureMapping(self) -> bool: ...
    def Highlight(self, enable: bool) -> bool: ...
    def HighlightSubObject(self, componentIndex: ComponentIndex, highlight: bool) -> bool: ...
    @overload
    def InVisualAnalysisMode(self) -> bool: ...
    @overload
    def InVisualAnalysisMode(self, mode: VisualAnalysisMode) -> bool: ...
    def IsActiveInViewport(self, viewport: RhinoViewport) -> bool: ...
    def IsHighlighted(self, checkSubObjects: bool) -> int: ...
    def IsMeshable(self, meshType: MeshType) -> bool: ...
    @overload
    def IsSelectable(self) -> bool: ...
    @overload
    def IsSelectable(self, ignoreSelectionState: bool, ignoreGripsState: bool, ignoreLayerLocking: bool, ignoreLayerVisibility: bool) -> bool: ...
    def IsSelected(self, checkSubObjects: bool) -> int: ...
    def IsSubObjectHighlighted(self, componentIndex: ComponentIndex) -> bool: ...
    def IsSubObjectSelectable(self, componentIndex: ComponentIndex, ignoreSelectionState: bool) -> bool: ...
    def IsSubObjectSelected(self, componentIndex: ComponentIndex) -> bool: ...
    def MemoryEstimate(self) -> UInt32: ...
    def MeshCount(self, meshType: MeshType, parameters: MeshingParameters) -> int: ...
    @overload
    def MeshObjects(rhinoObjects: Iterable[RhinoObject], parameters: MeshingParameters) -> Tuple[Result, Set(Mesh), Set(ObjectAttributes)]: ...
    @overload
    def MeshObjects(rhinoObjects: Iterable[RhinoObject], parameters: MeshingParameters, simpleDialog: bool) -> Tuple[Result, MeshingParameters, bool, Set(Mesh), Set(ObjectAttributes)]: ...
    @overload
    def MeshObjects(rhinoObjects: Iterable[RhinoObject], parameters: MeshingParameters, uiStyle: int, xform: Transform) -> Tuple[Result, MeshingParameters, int, Set(Mesh), Set(ObjectAttributes)]: ...
    @overload
    def Select(self, on: bool) -> int: ...
    @overload
    def Select(self, on: bool, syncHighlight: bool) -> int: ...
    @overload
    def Select(self, on: bool, syncHighlight: bool, persistentSelect: bool, ignoreGripsState: bool, ignoreLayerLocking: bool, ignoreLayerVisibility: bool) -> int: ...
    @overload
    def SelectSubObject(self, componentIndex: ComponentIndex, select: bool, syncHighlight: bool) -> int: ...
    @overload
    def SelectSubObject(self, componentIndex: ComponentIndex, select: bool, syncHighlight: bool, persistentSelect: bool) -> int: ...
    @Attributes.setter
    def Attributes(self, value: ObjectAttributes) -> None: ...
    @GripsOn.setter
    def GripsOn(self, value: bool) -> None: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @RenderMaterial.setter
    def RenderMaterial(self, value: RenderMaterial) -> None: ...
    def SetCopyHistoryOnReplace(self, bCopy: bool) -> None: ...
    def SetCustomRenderMeshParameter(self, providerId: Guid, parameterName: str, value: Object) -> None: ...
    def SetRenderMeshParameters(self, mp: MeshingParameters) -> bool: ...
    @overload
    def SetTextureMapping(self, channel: int, tm: TextureMapping) -> int: ...
    @overload
    def SetTextureMapping(self, channel: int, tm: TextureMapping, objectTransform: Transform) -> int: ...
    def ShortDescription(self, plural: bool) -> str: ...
    def SupportsRenderPrimitiveList(self, viewport: ViewportInfo, attrs: DisplayPipelineAttributes) -> bool: ...
    def TryGetGumballFrame(self) -> Tuple[bool, GumballFrame]: ...
    def TryGetRenderPrimitiveBoundingBox(self, viewport: ViewportInfo, attrs: DisplayPipelineAttributes) -> Tuple[bool, BoundingBox]: ...
    def UnhighlightAllSubObjects(self) -> int: ...
    def UnselectAllSubObjects(self) -> int: ...


class RhinoObjectEventArgs:
    @property
    def ObjectId(self) -> Guid: ...
    @property
    def TheObject(self) -> RhinoObject: ...


class RhinoObjectSelectionEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def RhinoObjects(self) -> Set(RhinoObject): ...
    @property
    def Selected(self) -> bool: ...


class RhinoReplaceObjectEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def NewRhinoObject(self) -> RhinoObject: ...
    @property
    def ObjectId(self) -> Guid: ...
    @property
    def OldRhinoObject(self) -> RhinoObject: ...


class RhinoTransformObjectsEventArgs:
    @property
    def GripCount(self) -> int: ...
    @property
    def GripOwnerCount(self) -> int: ...
    @property
    def GripOwners(self) -> Set(RhinoObject): ...
    @property
    def Grips(self) -> Set(GripObject): ...
    @property
    def ObjectCount(self) -> int: ...
    @property
    def Objects(self) -> Set(RhinoObject): ...
    @property
    def ObjectsWillBeCopied(self) -> bool: ...
    @property
    def Transform(self) -> Transform: ...


class ScaleFormat:
    #None = 0
    PageLengthToOne = 1
    OneToModelLength = 2
    OneInchToModelLengthFeet = 3
    ModelLengthInchToOneFoot = 4
    ModelLengthInchToOneFootInch = 5


class SelectionMethod:
    Other = 0
    MousePick = 1
    WindowBox = 2
    CrossingBox = 3


class StackDisplayFormat:
    #None = 0
    StackHorizontal = 1
    StackDiagonal = 2


class SubDObject(RhinoObject):
    pass


class SurfaceObject(RhinoObject):
    def DuplicateSurfaceGeometry(self) -> Surface: ...
    @property
    def SurfaceGeometry(self) -> Surface: ...


class TextDisplayAlignment:
    Normal = 0
    Horizontal = 1
    AboveLine = 2
    InLine = 3


class TextDotObject(RhinoObject):
    pass


class TextFit:
    Auto = 0
    TextInside = 1
    TextRight = 2
    TextLeft = 3
    TextHintRight = 4
    TextHintLeft = 5


class TextHorizontalAlignment:
    Left = 0
    Center = 1
    Right = 2
    Auto = 3


class TextLocation:
    AboveDimLine = 0
    InDimLine = 1
    BelowDimLine = 2


class TextObject(AnnotationObjectBase):
    @property
    def TextGeometry(self) -> TextEntity: ...


class TextOrientation:
    InPlane = 0
    InView = 1


class Texture(CommonObject):
    def __init__(self): ...
    @property
    def ApplyUvwTransform(self) -> bool: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def FileName(self) -> str: ...
    @property
    def FileReference(self) -> FileReference: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def MappingChannelId(self) -> int: ...
    @property
    def TextureCombineMode(self) -> TextureCombineMode: ...
    @property
    def TextureType(self) -> TextureType: ...
    @property
    def UvwTransform(self) -> Transform: ...
    @property
    def WrapU(self) -> TextureUvwWrapping: ...
    @property
    def WrapV(self) -> TextureUvwWrapping: ...
    @property
    def WrapW(self) -> TextureUvwWrapping: ...
    def GetAlphaBlendValues(self) -> Tuple[float, float, float, float, float]: ...
    @ApplyUvwTransform.setter
    def ApplyUvwTransform(self, value: bool) -> None: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @FileName.setter
    def FileName(self, value: str) -> None: ...
    @FileReference.setter
    def FileReference(self, value: FileReference) -> None: ...
    @TextureCombineMode.setter
    def TextureCombineMode(self, value: TextureCombineMode) -> None: ...
    @TextureType.setter
    def TextureType(self, value: TextureType) -> None: ...
    @UvwTransform.setter
    def UvwTransform(self, value: Transform) -> None: ...
    @WrapU.setter
    def WrapU(self, value: TextureUvwWrapping) -> None: ...
    @WrapV.setter
    def WrapV(self, value: TextureUvwWrapping) -> None: ...
    @WrapW.setter
    def WrapW(self, value: TextureUvwWrapping) -> None: ...
    def SetAlphaBlendValues(self, constant: float, a0: float, a1: float, a2: float, a3: float) -> None: ...
    def SetRGBBlendValues(self, color: Color, a0: float, a1: float, a2: float, a3: float) -> None: ...


class TextureCombineMode:
    #None = 0
    Modulate = 1
    Decal = 2
    Blend = 3


class TextureType:
    #None = 0
    Diffuse = 1
    Bitmap = 1
    PBR_BaseColor = 1
    Bump = 2
    Opacity = 3
    Transparency = 3
    PBR_Subsurface = 10
    PBR_SubsurfaceScattering = 11
    PBR_SubsurfaceScatteringRadius = 12
    PBR_Metallic = 13
    PBR_Specular = 14
    PBR_SpecularTint = 15
    PBR_Roughness = 16
    PBR_Anisotropic = 17
    PBR_Anisotropic_Rotation = 18
    PBR_Sheen = 19
    PBR_SheenTint = 20
    PBR_Clearcoat = 21
    PBR_ClearcoatRoughness = 22
    PBR_OpacityIor = 23
    PBR_OpacityRoughness = 24
    PBR_Emission = 25
    PBR_AmbientOcclusion = 26
    PBR_Displacement = 28
    PBR_ClearcoatBump = 29
    PBR_Alpha = 30
    Emap = 86


class TextureUvwWrapping:
    Repeat = 0
    Clamp = 1


class TextVerticalAlignment:
    Top = 0
    MiddleOfTop = 1
    BottomOfTop = 2
    Middle = 3
    MiddleOfBottom = 4
    Bottom = 5
    BottomOfBoundingBox = 6


class ToleranceDisplayFormat:
    #None = 0
    Symmetrical = 1
    Deviation = 2
    Limits = 3


class ViewInfo:
    @overload
    def __init__(self, rhinoViewPort: RhinoViewport): ...
    @overload
    def __init__(self, docRuntimeSerialNumber: UInt32): ...
    def Dispose(self) -> None: ...
    @property
    def FocalBlurAperture(self) -> float: ...
    @property
    def FocalBlurDistance(self) -> float: ...
    @property
    def FocalBlurJitter(self) -> float: ...
    @property
    def FocalBlurMode(self) -> ViewInfoFocalBlurModes: ...
    @property
    def FocalBlurSampleCount(self) -> UInt32: ...
    @property
    def Name(self) -> str: ...
    @property
    def ShowWallpaperInGrayScale(self) -> bool: ...
    @property
    def Viewport(self) -> ViewportInfo: ...
    @property
    def WallpaperFilename(self) -> str: ...
    @property
    def WallpaperHidden(self) -> bool: ...
    @FocalBlurAperture.setter
    def FocalBlurAperture(self, value: float) -> None: ...
    @FocalBlurDistance.setter
    def FocalBlurDistance(self, value: float) -> None: ...
    @FocalBlurJitter.setter
    def FocalBlurJitter(self, value: float) -> None: ...
    @FocalBlurMode.setter
    def FocalBlurMode(self, value: ViewInfoFocalBlurModes) -> None: ...
    @FocalBlurSampleCount.setter
    def FocalBlurSampleCount(self, value: UInt32) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...


class ViewInfoFocalBlurModes:
    #None = 0
    Automatic = 1
    Manual = 2


class ViewportInfo(CommonObject):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: ViewportInfo): ...
    @overload
    def __init__(self, rhinoViewport: RhinoViewport): ...
    def CalculateCameraRotationAngle(direction: Vector3d, up: Vector3d) -> float: ...
    def CalculateCameraUpDirection(location: Point3d, direction: Vector3d, angle: float) -> Vector3d: ...
    def ChangeToParallelProjection(self, symmetricFrustum: bool) -> bool: ...
    def ChangeToPerspectiveProjection(self, targetDistance: float, symmetricFrustum: bool, lensLength: float) -> bool: ...
    def ChangeToSymmetricFrustum(self, isLeftRightSymmetric: bool, isTopBottomSymmetric: bool, targetDistance: float) -> bool: ...
    def ChangeToTwoPointPerspectiveProjection(self, targetDistance: float, up: Vector3d, lensLength: float) -> bool: ...
    def DollyCamera(self, dollyVector: Vector3d) -> bool: ...
    @overload
    def DollyExtents(self, cameraCoordinateBoundingBox: BoundingBox, border: float) -> bool: ...
    @overload
    def DollyExtents(self, geometry: Iterable[GeometryBase], border: float) -> bool: ...
    def DollyFrustum(self, dollyDistance: float) -> bool: ...
    @overload
    def Extents(self, halfViewAngleRadians: float, bbox: BoundingBox) -> bool: ...
    @overload
    def Extents(self, halfViewAngleRadians: float, sphere: Sphere) -> bool: ...
    def FrustumCenterPoint(self, targetDistance: float) -> Point3d: ...
    @property
    def Camera35mmLensLength(self) -> float: ...
    @property
    def CameraAngle(self) -> float: ...
    @property
    def CameraDirection(self) -> Vector3d: ...
    @property
    def CameraLocation(self) -> Point3d: ...
    @property
    def CameraUp(self) -> Vector3d: ...
    @property
    def CameraX(self) -> Vector3d: ...
    @property
    def CameraY(self) -> Vector3d: ...
    @property
    def CameraZ(self) -> Vector3d: ...
    @property
    def DefaultCameraDirection() -> Vector3d: ...
    @property
    def FrustumAspect(self) -> float: ...
    @property
    def FrustumBottom(self) -> float: ...
    @property
    def FrustumBottomPlane(self) -> Plane: ...
    @property
    def FrustumCenter(self) -> Point3d: ...
    @property
    def FrustumFar(self) -> float: ...
    @property
    def FrustumFarPlane(self) -> Plane: ...
    @property
    def FrustumHeight(self) -> float: ...
    @property
    def FrustumLeft(self) -> float: ...
    @property
    def FrustumLeftPlane(self) -> Plane: ...
    @property
    def FrustumMaximumDiameter(self) -> float: ...
    @property
    def FrustumMinimumDiameter(self) -> float: ...
    @property
    def FrustumNear(self) -> float: ...
    @property
    def FrustumNearPlane(self) -> Plane: ...
    @property
    def FrustumRight(self) -> float: ...
    @property
    def FrustumRightPlane(self) -> Plane: ...
    @property
    def FrustumTop(self) -> float: ...
    @property
    def FrustumTopPlane(self) -> Plane: ...
    @property
    def FrustumWidth(self) -> float: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IsCameraDirectionLocked(self) -> bool: ...
    @property
    def IsCameraLocationLocked(self) -> bool: ...
    @property
    def IsCameraUpLocked(self) -> bool: ...
    @property
    def IsFrustumLeftRightSymmetric(self) -> bool: ...
    @property
    def IsFrustumTopBottomSymmetric(self) -> bool: ...
    @property
    def IsParallelProjection(self) -> bool: ...
    @property
    def IsPerspectiveProjection(self) -> bool: ...
    @property
    def IsTwoPointPerspectiveProjection(self) -> bool: ...
    @property
    def IsValidCamera(self) -> bool: ...
    @property
    def IsValidFrustum(self) -> bool: ...
    @property
    def PerspectiveMinNearDist(self) -> float: ...
    @property
    def PerspectiveMinNearOverFar(self) -> float: ...
    @property
    def ScreenPort(self) -> Rectangle: ...
    @property
    def ScreenPortAspect(self) -> float: ...
    @property
    def TargetPoint(self) -> Point3d: ...
    @property
    def ViewScale(self) -> SizeF: ...
    def GetBoundingBoxDepth(self, bbox: BoundingBox) -> Tuple[bool, float, float]: ...
    def GetCameraAngles(self) -> Tuple[bool, float, float, float]: ...
    def GetCameraFrame(self) -> Tuple[bool, Point3d, Vector3d, Vector3d, Vector3d]: ...
    @overload
    def GetDollyCameraVector(self, screen0: Point, screen1: Point, projectionPlaneDistance: float) -> Vector3d: ...
    @overload
    def GetDollyCameraVector(self, screenX0: int, screenY0: int, screenX1: int, screenY1: int, projectionPlaneDistance: float) -> Vector3d: ...
    def GetFarPlaneCorners(self) -> Set(Point3d): ...
    def GetFrustum(self) -> Tuple[bool, float, float, float, float, float, float]: ...
    @overload
    def GetFrustumLine(self, screenPoint: PointF) -> Line: ...
    @overload
    def GetFrustumLine(self, screenPoint: Point) -> Line: ...
    @overload
    def GetFrustumLine(self, screenX: float, screenY: float) -> Line: ...
    def GetNearPlaneCorners(self) -> Set(Point3d): ...
    def GetPointDepth(self, point: Point3d) -> Tuple[bool, float]: ...
    @overload
    def GetScreenPort(self) -> Rectangle: ...
    @overload
    def GetScreenPort(self) -> Tuple[Rectangle, int, int]: ...
    def GetScreenPortLocation(self) -> Tuple[int, int, int, int]: ...
    def GetSphereDepth(self, sphere: Sphere) -> Tuple[bool, float, float]: ...
    def GetWorldToScreenScale(self, pointInFrustum: Point3d) -> float: ...
    def GetXform(self, sourceSystem: CoordinateSystem, destinationSystem: CoordinateSystem) -> Transform: ...
    def RotateCamera(self, rotationAngleRadians: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> bool: ...
    @Camera35mmLensLength.setter
    def Camera35mmLensLength(self, value: float) -> None: ...
    @CameraAngle.setter
    def CameraAngle(self, value: float) -> None: ...
    @FrustumAspect.setter
    def FrustumAspect(self, value: float) -> None: ...
    @IsCameraDirectionLocked.setter
    def IsCameraDirectionLocked(self, value: bool) -> None: ...
    @IsCameraLocationLocked.setter
    def IsCameraLocationLocked(self, value: bool) -> None: ...
    @IsCameraUpLocked.setter
    def IsCameraUpLocked(self, value: bool) -> None: ...
    @IsFrustumLeftRightSymmetric.setter
    def IsFrustumLeftRightSymmetric(self, value: bool) -> None: ...
    @IsFrustumTopBottomSymmetric.setter
    def IsFrustumTopBottomSymmetric(self, value: bool) -> None: ...
    @IsParallelProjection.setter
    def IsParallelProjection(self, value: bool) -> None: ...
    @IsPerspectiveProjection.setter
    def IsPerspectiveProjection(self, value: bool) -> None: ...
    @PerspectiveMinNearDist.setter
    def PerspectiveMinNearDist(self, value: float) -> None: ...
    @PerspectiveMinNearOverFar.setter
    def PerspectiveMinNearOverFar(self, value: float) -> None: ...
    @ScreenPort.setter
    def ScreenPort(self, value: Rectangle) -> None: ...
    @TargetPoint.setter
    def TargetPoint(self, value: Point3d) -> None: ...
    @ViewScale.setter
    def ViewScale(self, value: SizeF) -> None: ...
    def SetCameraDirection(self, direction: Vector3d) -> bool: ...
    def SetCameraLocation(self, location: Point3d) -> bool: ...
    def SetCameraUp(self, up: Vector3d) -> bool: ...
    def SetFrustum(self, left: float, right: float, bottom: float, top: float, nearDistance: float, farDistance: float) -> bool: ...
    @overload
    def SetFrustumNearFar(self, boundingBox: BoundingBox) -> bool: ...
    @overload
    def SetFrustumNearFar(self, center: Point3d, radius: float) -> bool: ...
    @overload
    def SetFrustumNearFar(self, nearDistance: float, farDistance: float) -> bool: ...
    @overload
    def SetFrustumNearFar(self, nearDistance: float, farDistance: float, minNearDistance: float, minNearOverFar: float, targetDistance: float) -> bool: ...
    @overload
    def SetScreenPort(self, windowRectangle: Rectangle) -> bool: ...
    @overload
    def SetScreenPort(self, windowRectangle: Rectangle, near: int, far: int) -> bool: ...
    @overload
    def SetScreenPort(self, left: int, right: int, bottom: int, top: int, near: int, far: int) -> bool: ...
    def TargetDistance(self, useFrustumCenterFallback: bool) -> float: ...
    def TransformCamera(self, xform: Transform) -> bool: ...
    def UnlockCamera(self) -> None: ...
    def UnlockFrustumSymmetry(self) -> None: ...
    @overload
    def ZoomToScreenRect(self, windowRectangle: Rectangle) -> bool: ...
    @overload
    def ZoomToScreenRect(self, left: int, top: int, right: int, bottom: int) -> bool: ...


class Worksession:
    def FileNameFromRuntimeSerialNumber(runtimeSerialNumber: UInt32) -> str: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def FileName(self) -> str: ...
    @property
    def ModelCount(self) -> int: ...
    @property
    def ModelPaths(self) -> Set(str): ...
    @property
    def RuntimeSerialNumber(self) -> UInt32: ...
    def ModelPathFromSerialNumber(self, modelSerialNumber: UInt32) -> str: ...


class ZeroSuppression:
    #None = 0
    SuppressLeading = 1
    SuppressTrailing = 2
    SuppressLeadingAndTrailing = 3
    SuppressZeroFeet = 4
    SuppressZeroInches = 8
    SuppressZeroFeetAndZeroInches = 12
