from typing import Tuple, Set, Iterable, List


class AsciiEol:
    Crlf = 0
    Lf = 1
    Cr = 2


class BinaryArchiveException:
    def __init__(self, message: str): ...


class BinaryArchiveFile:
    def __init__(self, filename: str, mode: BinaryArchiveMode): ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Reader(self) -> BinaryArchiveReader: ...
    @property
    def Writer(self) -> BinaryArchiveWriter: ...
    def Open(self) -> bool: ...


class BinaryArchiveMode:
    Unknown = 0
    Read = 1
    Write = 2
    ReadWrite = 3
    Read3dm = 5
    Write3dm = 6


class BinaryArchiveReader:
    def AtEnd(self) -> bool: ...
    @overload
    def BeginRead3dmChunk(self) -> Tuple[bool, UInt32, Int64]: ...
    @overload
    def BeginRead3dmChunk(self, expectedTypeCode: UInt32) -> Tuple[bool, int, int]: ...
    def Dump3dmChunk(self, log: TextLog) -> UInt32: ...
    def EnableCRCCalculation(self, enable: bool) -> bool: ...
    def EndRead3dmChunk(self, suppressPartiallyReadChunkWarning: bool) -> bool: ...
    @property
    def Archive3dmVersion(self) -> int: ...
    @property
    def CurrentPosition(self) -> UInt64: ...
    @property
    def ReadErrorOccured(self) -> bool: ...
    def Read3dmChunkVersion(self) -> Tuple[int, int]: ...
    def Read3dmStartSection(self) -> Tuple[bool, int, str]: ...
    def ReadBool(self) -> bool: ...
    def ReadBoolArray(self) -> Set(bool): ...
    def ReadBoundingBox(self) -> BoundingBox: ...
    def ReadByte(self) -> Byte: ...
    def ReadByteArray(self) -> Set(Byte): ...
    def ReadColor(self) -> Color: ...
    def ReadCompressedBuffer(self) -> Set(Byte): ...
    def ReadDictionary(self) -> ArchivableDictionary: ...
    def ReadDouble(self) -> float: ...
    def ReadDoubleArray(self) -> Set(float): ...
    def ReadFont(self) -> Font: ...
    def ReadGeometry(self) -> GeometryBase: ...
    def ReadGeometryArray(self) -> Set(GeometryBase): ...
    def ReadGuid(self) -> Guid: ...
    def ReadGuidArray(self) -> Set(Guid): ...
    def ReadInt(self) -> int: ...
    def ReadInt64(self) -> Int64: ...
    def ReadIntArray(self) -> Set(int): ...
    def ReadInterval(self) -> Interval: ...
    def ReadLine(self) -> Line: ...
    def ReadMeshingParameters(self) -> MeshingParameters: ...
    def ReadObjRef(self) -> ObjRef: ...
    def ReadObjRefArray(self) -> Set(ObjRef): ...
    def ReadPlane(self) -> Plane: ...
    def ReadPoint(self) -> Point: ...
    def ReadPoint2d(self) -> Point2d: ...
    def ReadPoint3d(self) -> Point3d: ...
    def ReadPoint3f(self) -> Point3f: ...
    def ReadPoint4d(self) -> Point4d: ...
    def ReadPointF(self) -> PointF: ...
    def ReadRay3d(self) -> Ray3d: ...
    def ReadRectangle(self) -> Rectangle: ...
    def ReadRectangleF(self) -> RectangleF: ...
    def ReadRenderSettings(self) -> RenderSettings: ...
    def ReadSByte(self) -> SByte: ...
    def ReadSByteArray(self) -> Set(SByte): ...
    def ReadShort(self) -> Int16: ...
    def ReadShortArray(self) -> Set(Int16): ...
    def ReadSingle(self) -> Single: ...
    def ReadSingleArray(self) -> Set(Single): ...
    def ReadSize(self) -> Size: ...
    def ReadSizeF(self) -> SizeF: ...
    def ReadString(self) -> str: ...
    def ReadStringArray(self) -> Set(str): ...
    def ReadTransform(self) -> Transform: ...
    def ReadUInt(self) -> UInt32: ...
    def ReadUShort(self) -> UInt16: ...
    def ReadUtf8String(self) -> str: ...
    def ReadVector2d(self) -> Vector2d: ...
    def ReadVector3d(self) -> Vector3d: ...
    def ReadVector3f(self) -> Vector3f: ...
    @overload
    def SeekFromCurrentPosition(self, byteOffset: Int64) -> bool: ...
    @overload
    def SeekFromCurrentPosition(self, byteOffset: UInt64, forward: bool) -> bool: ...
    def SeekFromStart(self, byteOffset: UInt64) -> bool: ...
    @ReadErrorOccured.setter
    def ReadErrorOccured(self, value: bool) -> None: ...


class BinaryArchiveWriter:
    @overload
    def BeginWrite3dmChunk(self, typecode: UInt32, value: Int64) -> bool: ...
    @overload
    def BeginWrite3dmChunk(self, typecode: UInt32, majorVersion: int, minorVersion: int) -> bool: ...
    def EnableCRCCalculation(self, enable: bool) -> bool: ...
    def EndWrite3dmChunk(self) -> bool: ...
    @property
    def Archive3dmVersion(self) -> int: ...
    @property
    def WriteErrorOccured(self) -> bool: ...
    @WriteErrorOccured.setter
    def WriteErrorOccured(self, value: bool) -> None: ...
    def Write3dmChunkVersion(self, major: int, minor: int) -> None: ...
    def WriteBool(self, value: bool) -> None: ...
    def WriteBoolArray(self, value: Iterable[bool]) -> None: ...
    def WriteBoundingBox(self, value: BoundingBox) -> None: ...
    def WriteByte(self, value: Byte) -> None: ...
    def WriteByteArray(self, value: Iterable[Byte]) -> None: ...
    def WriteColor(self, value: Color) -> None: ...
    def WriteCompressedBuffer(self, value: Iterable[Byte]) -> None: ...
    def WriteDictionary(self, dictionary: ArchivableDictionary) -> None: ...
    def WriteDouble(self, value: float) -> None: ...
    def WriteDoubleArray(self, value: Iterable[float]) -> None: ...
    def WriteFont(self, value: Font) -> None: ...
    def WriteGeometry(self, value: GeometryBase) -> None: ...
    def WriteGeometryArray(self, geometry: Iterable[GeometryBase]) -> None: ...
    def WriteGuid(self, value: Guid) -> None: ...
    def WriteGuidArray(self, value: Iterable[Guid]) -> None: ...
    def WriteInt(self, value: int) -> None: ...
    def WriteInt64(self, value: Int64) -> None: ...
    def WriteIntArray(self, value: Iterable[int]) -> None: ...
    def WriteInterval(self, value: Interval) -> None: ...
    def WriteLine(self, value: Line) -> None: ...
    def WriteMeshingParameters(self, value: MeshingParameters) -> None: ...
    def WriteObjRef(self, objref: ObjRef) -> None: ...
    def WriteObjRefArray(self, objrefs: Iterable[ObjRef]) -> None: ...
    def WritePlane(self, value: Plane) -> None: ...
    def WritePoint(self, value: Point) -> None: ...
    def WritePoint2d(self, value: Point2d) -> None: ...
    def WritePoint3d(self, value: Point3d) -> None: ...
    def WritePoint3f(self, value: Point3f) -> None: ...
    def WritePoint4d(self, value: Point4d) -> None: ...
    def WritePointF(self, value: PointF) -> None: ...
    def WriteRay3d(self, value: Ray3d) -> None: ...
    def WriteRectangle(self, value: Rectangle) -> None: ...
    def WriteRectangleF(self, value: RectangleF) -> None: ...
    def WriteRenderSettings(self, value: RenderSettings) -> None: ...
    def WriteSByte(self, value: SByte) -> None: ...
    def WriteSByteArray(self, value: Iterable[SByte]) -> None: ...
    def WriteShort(self, value: Int16) -> None: ...
    def WriteShortArray(self, value: Iterable[Int16]) -> None: ...
    def WriteSingle(self, value: Single) -> None: ...
    def WriteSingleArray(self, value: Iterable[Single]) -> None: ...
    def WriteSize(self, value: Size) -> None: ...
    def WriteSizeF(self, value: SizeF) -> None: ...
    def WriteString(self, value: str) -> None: ...
    def WriteStringArray(self, value: Iterable[str]) -> None: ...
    def WriteTransform(self, value: Transform) -> None: ...
    def WriteUInt(self, value: UInt32) -> None: ...
    def WriteUShort(self, value: UInt16) -> None: ...
    def WriteUtf8String(self, value: str) -> None: ...
    def WriteVector2d(self, value: Vector2d) -> None: ...
    def WriteVector3d(self, value: Vector3d) -> None: ...
    def WriteVector3f(self, value: Vector3f) -> None: ...




class ContentHash:
    def Clone(self) -> ContentHash: ...
    def CreateFromFile(path: str) -> ContentHash: ...
    @overload
    def Equals(self, other: ContentHash) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def ByteCount(self) -> UInt64: ...
    @property
    def HashTime(self) -> DateTime: ...
    @property
    def Sha1ContentHash(self) -> Set(Byte): ...
    @property
    def Sha1NameHash(self) -> Set(Byte): ...
    def GetHashCode(self) -> int: ...
    def op_Equality(left: ContentHash, right: ContentHash) -> bool: ...
    def op_Inequality(left: ContentHash, right: ContentHash) -> bool: ...


class CurveType:
    Polyline = 0
    Nurbs = 1


class DracoColorFormat:
    ARGB = 0
    RGBA = 1


class DracoCompression:
    @overload
    def Compress(mesh: Mesh) -> DracoCompression: ...
    @overload
    def Compress(mesh: Mesh, options: DracoCompressionOptions) -> DracoCompression: ...
    def DecompressBase64String(encoded: str) -> GeometryBase: ...
    def DecompressByteArray(bytes: Set(Byte)) -> GeometryBase: ...
    def DecompressFile(path: str) -> GeometryBase: ...
    def Dispose(self) -> None: ...
    @property
    def NormalAttributePosition(self) -> int: ...
    @property
    def TextureCoordinatesAttributePosition(self) -> int: ...
    @property
    def VertexAttributePosition(self) -> int: ...
    @property
    def VertexColorAttributePosition(self) -> int: ...
    def ToBase64String(self) -> str: ...
    def Write(self, path: str) -> bool: ...


class DracoCompressionOptions:
    def __init__(self): ...
    @property
    def CompressionLevel(self) -> int: ...
    @property
    def NormalQuantizationBits(self) -> int: ...
    @property
    def PositionQuantizationBits(self) -> int: ...
    @property
    def TextureCoordintateQuantizationBits(self) -> int: ...
    @CompressionLevel.setter
    def CompressionLevel(self, value: int) -> None: ...
    @NormalQuantizationBits.setter
    def NormalQuantizationBits(self, value: int) -> None: ...
    @PositionQuantizationBits.setter
    def PositionQuantizationBits(self, value: int) -> None: ...
    @TextureCoordintateQuantizationBits.setter
    def TextureCoordintateQuantizationBits(self, value: int) -> None: ...


class File3dm:
    def __init__(self): ...
    def Dispose(self) -> None: ...
    def Dump(self) -> str: ...
    def DumpSummary(self) -> str: ...
    def DumpToTextLog(self, log: TextLog) -> None: ...
    def FromByteArray(bytes: Set(Byte)) -> File3dm: ...
    @property
    def AllDimStyles(self) -> File3dmDimStyleTable: ...
    @property
    def AllGroups(self) -> File3dmGroupTable: ...
    @property
    def AllHatchPatterns(self) -> File3dmHatchPatternTable: ...
    @property
    def AllInstanceDefinitions(self) -> File3dmInstanceDefinitionTable: ...
    @property
    def AllLayers(self) -> File3dmLayerTable: ...
    @property
    def AllLinetypes(self) -> File3dmLinetypeTable: ...
    @property
    def AllMaterials(self) -> File3dmMaterialTable: ...
    @property
    def AllNamedConstructionPlanes(self) -> File3dmNamedConstructionPlanes: ...
    @property
    def AllNamedViews(self) -> File3dmViewTable: ...
    @property
    def AllViews(self) -> File3dmViewTable: ...
    @property
    def ApplicationDetails(self) -> str: ...
    @property
    def ApplicationName(self) -> str: ...
    @property
    def ApplicationUrl(self) -> str: ...
    @property
    def Created(self) -> DateTime: ...
    @property
    def CreatedBy(self) -> str: ...
    @property
    def DimStyles(self) -> List[DimensionStyle]: ...
    @property
    def HatchPatterns(self) -> List[HatchPattern]: ...
    @property
    def InstanceDefinitions(self) -> List[InstanceDefinitionGeometry]: ...
    @property
    def LastEdited(self) -> DateTime: ...
    @property
    def LastEditedBy(self) -> str: ...
    @property
    def Layers(self) -> List[Layer]: ...
    @property
    def Linetypes(self) -> List[Linetype]: ...
    @property
    def Manifest(self) -> ManifestTable: ...
    @property
    def Materials(self) -> List[Material]: ...
    @property
    def NamedConstructionPlanes(self) -> List[ConstructionPlane]: ...
    @property
    def NamedViews(self) -> List[ViewInfo]: ...
    @property
    def Notes(self) -> File3dmNotes: ...
    @property
    def Objects(self) -> File3dmObjectTable: ...
    @property
    def PlugInData(self) -> File3dmPlugInDataTable: ...
    @property
    def Revision(self) -> int: ...
    @property
    def Settings(self) -> File3dmSettings: ...
    @property
    def StartSectionComments(self) -> str: ...
    @property
    def Strings(self) -> File3dmStringTable: ...
    @property
    def Views(self) -> List[ViewInfo]: ...
    def GetPreviewImage(self) -> Bitmap: ...
    @overload
    def Read(path: str) -> File3dm: ...
    @overload
    def Read(path: str, tableTypeFilterFilter: TableTypeFilter, objectTypeFilter: ObjectTypeFilter) -> File3dm: ...
    def ReadApplicationData(path: str) -> Tuple[str, str, str]: ...
    def ReadArchiveVersion(path: str) -> int: ...
    def ReadDimensionStyles(path: str) -> Set(DimensionStyle): ...
    def ReadNotes(path: str) -> str: ...
    def ReadPreviewImage(path: str) -> Bitmap: ...
    def ReadRevisionHistory(path: str) -> Tuple[bool, str, str, int, DateTime, DateTime]: ...
    @overload
    def ReadWithLog(path: str) -> Tuple[File3dm, str]: ...
    @overload
    def ReadWithLog(path: str, tableTypeFilterFilter: TableTypeFilter, objectTypeFilter: ObjectTypeFilter) -> Tuple[File3dm, str]: ...
    @ApplicationDetails.setter
    def ApplicationDetails(self, value: str) -> None: ...
    @ApplicationName.setter
    def ApplicationName(self, value: str) -> None: ...
    @ApplicationUrl.setter
    def ApplicationUrl(self, value: str) -> None: ...
    @Notes.setter
    def Notes(self, value: File3dmNotes) -> None: ...
    @Revision.setter
    def Revision(self, value: int) -> None: ...
    @StartSectionComments.setter
    def StartSectionComments(self, value: str) -> None: ...
    def SetPreviewImage(self, image: Bitmap) -> None: ...
    @overload
    def ToByteArray(self) -> Set(Byte): ...
    @overload
    def ToByteArray(self, options: File3dmWriteOptions) -> Set(Byte): ...
    @overload
    def Write(self, path: str, version: int) -> bool: ...
    @overload
    def Write(self, path: str, options: File3dmWriteOptions) -> bool: ...
    def WriteMultipleObjects(path: str, geometry: Iterable[GeometryBase]) -> bool: ...
    def WriteOneObject(path: str, geometry: GeometryBase) -> bool: ...
    @overload
    def WriteWithLog(self, path: str, version: int) -> Tuple[bool, str]: ...
    @overload
    def WriteWithLog(self, path: str, options: File3dmWriteOptions) -> Tuple[bool, str]: ...




class File3dmDimStyleTable:
    def FindIndex(self, index: int) -> DimensionStyle: ...
    def FindName(self, name: str) -> DimensionStyle: ...
    def FindNameHash(self, nameHash: NameHash) -> DimensionStyle: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...


class File3dmGroupTable:
    def FindIndex(self, groupIndex: int) -> Group: ...
    def FindName(self, name: str) -> Group: ...
    def FindNameHash(self, nameHash: NameHash) -> Group: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    def GroupMembers(self, groupIndex: int) -> Set(File3dmObject): ...


class File3dmHatchPatternTable:
    def FindIndex(self, index: int) -> HatchPattern: ...
    def FindName(self, name: str) -> HatchPattern: ...
    def FindNameHash(self, nameHash: NameHash) -> HatchPattern: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...


class File3dmInstanceDefinitionTable:
    @overload
    def Add(self, name: str, description: str, basePoint: Point3d, geometry: Iterable[GeometryBase]) -> int: ...
    @overload
    def Add(self, name: str, description: str, basePoint: Point3d, geometry: Iterable[GeometryBase], attributes: Iterable[ObjectAttributes]) -> int: ...
    @overload
    def Add(self, name: str, description: str, basePoint: Point3d, geometry: GeometryBase, attributes: ObjectAttributes) -> int: ...
    @overload
    def Add(self, name: str, description: str, url: str, urlTag: str, basePoint: Point3d, geometry: Iterable[GeometryBase], attributes: Iterable[ObjectAttributes]) -> int: ...
    def AddLinked(self, filename: str, name: str, description: str) -> int: ...
    def FindName(self, name: str) -> InstanceDefinitionGeometry: ...
    def FindNameHash(self, nameHash: NameHash) -> InstanceDefinitionGeometry: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...


class File3dmLayerTable:
    def AddLayer(self, name: str, color: Color) -> int: ...
    def FindIndex(self, index: int) -> Layer: ...
    def FindName(self, name: str, parentId: Guid) -> Layer: ...
    def FindNameHash(self, nameHash: NameHash) -> Layer: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...


class File3dmLinetypeTable:
    def FindIndex(self, index: int) -> Linetype: ...
    def FindName(self, name: str) -> Linetype: ...
    def FindNameHash(self, nameHash: NameHash) -> Linetype: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...


class File3dmMaterialTable:
    def FindIndex(self, index: int) -> Material: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...


class File3dmNamedConstructionPlanes:
    @overload
    def Add(self, cplane: ConstructionPlane) -> None: ...
    @overload
    def Add(self, name: str, plane: Plane) -> int: ...
    def Clear(self) -> None: ...
    def Contains(self, cplane: ConstructionPlane) -> bool: ...
    def CopyTo(self, array: Set(ConstructionPlane), arrayIndex: int) -> None: ...
    @overload
    def Delete(self, index: int) -> bool: ...
    @overload
    def Delete(self, cplane: ConstructionPlane) -> bool: ...
    def FindName(self, name: str) -> ConstructionPlane: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> ConstructionPlane: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def IndexOf(self, cplane: ConstructionPlane) -> int: ...


class File3dmNotes:
    def __init__(self): ...
    @property
    def IsHtml(self) -> bool: ...
    @property
    def IsVisible(self) -> bool: ...
    @property
    def Notes(self) -> str: ...
    @property
    def WindowRectangle(self) -> Rectangle: ...
    @IsHtml.setter
    def IsHtml(self, value: bool) -> None: ...
    @IsVisible.setter
    def IsVisible(self, value: bool) -> None: ...
    @Notes.setter
    def Notes(self, value: str) -> None: ...
    @WindowRectangle.setter
    def WindowRectangle(self, value: Rectangle) -> None: ...


class File3dmObject(ModelComponent):
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, other: File3dmObject) -> bool: ...
    @property
    def Attributes(self) -> ObjectAttributes: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Geometry(self) -> GeometryBase: ...
    @property
    def Name(self) -> str: ...
    def GetHashCode(self) -> int: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    def TryReadUserData(self, userDataId: Guid, readFromAttributes: bool, dataReader: Func`3) -> bool: ...


class File3dmObjectTable:
    def Add(self, item: File3dmObject) -> None: ...
    @overload
    def AddAngularDimension(self, dimension: AngularDimension) -> Guid: ...
    @overload
    def AddAngularDimension(self, dimension: AngularDimension, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddArc(self, arc: Arc) -> Guid: ...
    @overload
    def AddArc(self, arc: Arc, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddBrep(self, brep: Brep) -> Guid: ...
    @overload
    def AddBrep(self, brep: Brep, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddCircle(self, circle: Circle) -> Guid: ...
    @overload
    def AddCircle(self, circle: Circle, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportIds: Iterable[Guid]) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportId: Guid) -> Guid: ...
    @overload
    def AddClippingPlane(self, plane: Plane, uMagnitude: float, vMagnitude: float, clippedViewportIds: Iterable[Guid], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddCurve(self, curve: Curve) -> Guid: ...
    @overload
    def AddCurve(self, curve: Curve, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddEllipse(self, ellipse: Ellipse) -> Guid: ...
    @overload
    def AddEllipse(self, ellipse: Ellipse, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddExtrusion(self, extrusion: Extrusion) -> Guid: ...
    @overload
    def AddExtrusion(self, extrusion: Extrusion, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddHatch(self, hatch: Hatch) -> Guid: ...
    @overload
    def AddHatch(self, hatch: Hatch, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceReference: InstanceReferenceGeometry) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceReference: InstanceReferenceGeometry, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceDefinitionIndex: int, instanceXform: Transform) -> Guid: ...
    @overload
    def AddInstanceObject(self, instanceDefinitionIndex: int, instanceXform: Transform, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLeader(self, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddLeader(self, text: str, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddLeader(self, plane: Plane, points: Iterable[Point2d]) -> Guid: ...
    @overload
    def AddLeader(self, plane: Plane, points: Iterable[Point2d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLeader(self, text: str, plane: Plane, points: Iterable[Point2d]) -> Guid: ...
    @overload
    def AddLeader(self, text: str, plane: Plane, points: Iterable[Point2d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLine(self, line: Line) -> Guid: ...
    @overload
    def AddLine(self, from_: Point3d, to: Point3d) -> Guid: ...
    @overload
    def AddLine(self, line: Line, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLine(self, from_: Point3d, to: Point3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddLinearDimension(self, dimension: LinearDimension) -> Guid: ...
    @overload
    def AddLinearDimension(self, dimension: LinearDimension, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddMesh(self, mesh: Mesh) -> Guid: ...
    @overload
    def AddMesh(self, mesh: Mesh, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3d) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3f) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3f, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPoint(self, point: Point3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPoint(self, x: float, y: float, z: float) -> Guid: ...
    @overload
    def AddPointCloud(self, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddPointCloud(self, cloud: PointCloud) -> Guid: ...
    @overload
    def AddPointCloud(self, cloud: PointCloud, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPointCloud(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddPoints(self, points: Iterable[Point3d]) -> Set(Guid): ...
    @overload
    def AddPoints(self, points: Iterable[Point3f]) -> Set(Guid): ...
    @overload
    def AddPoints(self, points: Iterable[Point3f], attributes: ObjectAttributes) -> Set(Guid): ...
    @overload
    def AddPoints(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> Set(Guid): ...
    @overload
    def AddPolyline(self, points: Iterable[Point3d]) -> Guid: ...
    @overload
    def AddPolyline(self, points: Iterable[Point3d], attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddSphere(self, sphere: Sphere) -> Guid: ...
    @overload
    def AddSphere(self, sphere: Sphere, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddSubD(self, subd: SubD) -> Guid: ...
    @overload
    def AddSubD(self, subd: SubD, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddSurface(self, surface: Surface) -> Guid: ...
    @overload
    def AddSurface(self, surface: Surface, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text3d: Text3d) -> Guid: ...
    @overload
    def AddText(self, text3d: Text3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, justification: TextJustification) -> Guid: ...
    @overload
    def AddText(self, text: str, plane: Plane, height: float, fontName: str, bold: bool, italic: bool, justification: TextJustification, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddTextDot(self, dot: TextDot) -> Guid: ...
    @overload
    def AddTextDot(self, text: str, location: Point3d) -> Guid: ...
    @overload
    def AddTextDot(self, dot: TextDot, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def AddTextDot(self, text: str, location: Point3d, attributes: ObjectAttributes) -> Guid: ...
    @overload
    def Delete(self, objectId: Guid) -> bool: ...
    @overload
    def Delete(self, objectIds: Iterable[Guid]) -> int: ...
    def FindByGroup(self, group: Group) -> Set(File3dmObject): ...
    @overload
    def FindByLayer(self, layer: Layer) -> Set(File3dmObject): ...
    @overload
    def FindByLayer(self, layer: str) -> Set(File3dmObject): ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Count(self) -> int: ...
    def GetBoundingBox(self) -> BoundingBox: ...
    def GetEnumerator(self) -> IEnumerator: ...


class File3dmPlugInData:
    @property
    def PlugInId(self) -> Guid: ...


class File3dmPlugInDataTable:
    def Clear(self) -> None: ...
    def Dump(self) -> str: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> File3dmPlugInData: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def TryRead(self, pluginData: File3dmPlugInData, dataReader: Func`3) -> bool: ...


class File3dmSettings:
    @property
    def ModelAbsoluteTolerance(self) -> float: ...
    @property
    def ModelAngleToleranceDegrees(self) -> float: ...
    @property
    def ModelAngleToleranceRadians(self) -> float: ...
    @property
    def ModelBasepoint(self) -> Point3d: ...
    @property
    def ModelRelativeTolerance(self) -> float: ...
    @property
    def ModelUnitSystem(self) -> UnitSystem: ...
    @property
    def ModelUrl(self) -> str: ...
    @property
    def PageAbsoluteTolerance(self) -> float: ...
    @property
    def PageAngleToleranceDegrees(self) -> float: ...
    @property
    def PageAngleToleranceRadians(self) -> float: ...
    @property
    def PageRelativeTolerance(self) -> float: ...
    @property
    def PageUnitSystem(self) -> UnitSystem: ...
    @ModelAbsoluteTolerance.setter
    def ModelAbsoluteTolerance(self, value: float) -> None: ...
    @ModelAngleToleranceDegrees.setter
    def ModelAngleToleranceDegrees(self, value: float) -> None: ...
    @ModelAngleToleranceRadians.setter
    def ModelAngleToleranceRadians(self, value: float) -> None: ...
    @ModelBasepoint.setter
    def ModelBasepoint(self, value: Point3d) -> None: ...
    @ModelRelativeTolerance.setter
    def ModelRelativeTolerance(self, value: float) -> None: ...
    @ModelUnitSystem.setter
    def ModelUnitSystem(self, value: UnitSystem) -> None: ...
    @ModelUrl.setter
    def ModelUrl(self, value: str) -> None: ...
    @PageAbsoluteTolerance.setter
    def PageAbsoluteTolerance(self, value: float) -> None: ...
    @PageAngleToleranceDegrees.setter
    def PageAngleToleranceDegrees(self, value: float) -> None: ...
    @PageAngleToleranceRadians.setter
    def PageAngleToleranceRadians(self, value: float) -> None: ...
    @PageRelativeTolerance.setter
    def PageRelativeTolerance(self, value: float) -> None: ...
    @PageUnitSystem.setter
    def PageUnitSystem(self, value: UnitSystem) -> None: ...


class File3dmStringTable:
    @overload
    def Delete(self, key: str) -> None: ...
    @overload
    def Delete(self, section: str, entry: str) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def DocumentUserTextCount(self) -> int: ...
    def GetEntryNames(self, section: str) -> Set(str): ...
    def GetKey(self, i: int) -> str: ...
    def GetSectionNames(self) -> Set(str): ...
    @overload
    def GetValue(self, i: int) -> str: ...
    @overload
    def GetValue(self, key: str) -> str: ...
    @overload
    def GetValue(self, section: str, entry: str) -> str: ...
    @overload
    def SetString(self, key: str, value: str) -> str: ...
    @overload
    def SetString(self, section: str, entry: str, value: str) -> str: ...


class File3dmTypeCodes:
    pass


class File3dmViewTable:
    def Add(self, item: ViewInfo) -> None: ...
    def Clear(self) -> None: ...
    def Contains(self, item: ViewInfo) -> bool: ...
    def CopyTo(self, array: Set(ViewInfo), arrayIndex: int) -> None: ...
    @overload
    def Delete(self, index: int) -> bool: ...
    @overload
    def Delete(self, item: ViewInfo) -> bool: ...
    def FindName(self, name: str) -> ViewInfo: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> ViewInfo: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def IndexOf(self, item: ViewInfo) -> int: ...


class File3dmWriteOptions:
    def __init__(self): ...
    def EnableAnalysisMeshes(self, objectType: ObjectType, enable: bool) -> None: ...
    def EnableRenderMeshes(self, objectType: ObjectType, enable: bool) -> None: ...
    @property
    def SaveAnalysisMeshes(self) -> bool: ...
    @property
    def SaveRenderMeshes(self) -> bool: ...
    @property
    def SaveUserData(self) -> bool: ...
    @property
    def Version(self) -> int: ...
    @SaveAnalysisMeshes.setter
    def SaveAnalysisMeshes(self, value: bool) -> None: ...
    @SaveRenderMeshes.setter
    def SaveRenderMeshes(self, value: bool) -> None: ...
    @SaveUserData.setter
    def SaveUserData(self, value: bool) -> None: ...
    @Version.setter
    def Version(self, value: int) -> None: ...


class FileFindPreference:
    #None = 0
    FullPath = 1
    RelativePath = 2
    BasePath = 3
    ContentMatch = 4
    MostRecent = 5


class FileObj:
    def Read(filename: str, doc: RhinoDoc, options: FileObjReadOptions) -> bool: ...
    @overload
    def Write(filename: str, doc: RhinoDoc, options: FileObjWriteOptions) -> WriteFileResult: ...
    @overload
    def Write(stream: StreamWriter, doc: RhinoDoc, options: FileObjWriteOptions) -> WriteFileResult: ...
    @overload
    def Write(filename: str, meshes: Set(Mesh), options: FileObjWriteOptions) -> WriteFileResult: ...


class FileObjReadOptions:
    def __init__(self, readOptions: FileReadOptions): ...
    @property
    def DisplayColorFromObjMaterial(self) -> bool: ...
    @property
    def IgnoreTextures(self) -> bool: ...
    @property
    def MapYtoZ(self) -> bool: ...
    @property
    def MorphTargetOnly(self) -> bool: ...
    @property
    def ReverseGroupOrder(self) -> bool: ...
    @property
    def Split32BitTextures(self) -> bool: ...
    @property
    def UseObjGroupsAs(self) -> UseObjGsAs: ...
    @property
    def UseObjObjects(self) -> bool: ...
    def GetTransform(self) -> Transform: ...
    @DisplayColorFromObjMaterial.setter
    def DisplayColorFromObjMaterial(self, value: bool) -> None: ...
    @IgnoreTextures.setter
    def IgnoreTextures(self, value: bool) -> None: ...
    @MapYtoZ.setter
    def MapYtoZ(self, value: bool) -> None: ...
    @MorphTargetOnly.setter
    def MorphTargetOnly(self, value: bool) -> None: ...
    @ReverseGroupOrder.setter
    def ReverseGroupOrder(self, value: bool) -> None: ...
    @Split32BitTextures.setter
    def Split32BitTextures(self, value: bool) -> None: ...
    @UseObjGroupsAs.setter
    def UseObjGroupsAs(self, value: UseObjGsAs) -> None: ...
    @UseObjObjects.setter
    def UseObjObjects(self, value: bool) -> None: ...


class FileObjWriteOptions:
    def __init__(self, writeOptions: FileWriteOptions): ...
    @property
    def ActualFilePathOnMac(self) -> str: ...
    @property
    def CreateNgons(self) -> bool: ...
    @property
    def CullUnnecessaryVertexesInNgons(self) -> bool: ...
    @property
    def EolType(self) -> AsciiEol: ...
    @property
    def ExportAsTriangles(self) -> bool: ...
    @property
    def ExportGroupNameLayerNames(self) -> ObjGroupNames: ...
    @property
    def ExportMaterialDefinitions(self) -> bool: ...
    @property
    def ExportNormals(self) -> bool: ...
    @property
    def ExportObjectNames(self) -> ObjObjectNames: ...
    @property
    def ExportOpenMeshes(self) -> bool: ...
    @property
    def ExportTcs(self) -> bool: ...
    @property
    def ExportVcs(self) -> bool: ...
    @property
    def IncludeUnweldedEdgesInNgons(self) -> bool: ...
    @property
    def MapZtoY(self) -> bool: ...
    @property
    def MergeNestedGroupingNames(self) -> bool: ...
    @property
    def MeshParameters(self) -> MeshingParameters: ...
    @property
    def MeshType(self) -> VertexWelding: ...
    @property
    def MinNgonFaceCount(self) -> int: ...
    @property
    def NgonMode(self) -> NGons: ...
    @property
    def ObjectType(self) -> GeometryType: ...
    @property
    def SignificantDigits(self) -> int: ...
    @property
    def SortObjGroups(self) -> bool: ...
    @property
    def SubDMeshType(self) -> SubDMeshing: ...
    @property
    def SubDSurfaceMeshingDensity(self) -> int: ...
    @property
    def TrimCurveType(self) -> CurveType: ...
    @property
    def UnderbarMaterialNames(self) -> bool: ...
    @property
    def UseDisplayColorForMaterial(self) -> bool: ...
    @property
    def UseRelativeIndexing(self) -> bool: ...
    @property
    def UseRenderMeshes(self) -> bool: ...
    @property
    def UseSimpleDialog(self) -> bool: ...
    @property
    def WrapLongLines(self) -> bool: ...
    def GetTransform(self) -> Transform: ...
    @ActualFilePathOnMac.setter
    def ActualFilePathOnMac(self, value: str) -> None: ...
    @CreateNgons.setter
    def CreateNgons(self, value: bool) -> None: ...
    @CullUnnecessaryVertexesInNgons.setter
    def CullUnnecessaryVertexesInNgons(self, value: bool) -> None: ...
    @EolType.setter
    def EolType(self, value: AsciiEol) -> None: ...
    @ExportAsTriangles.setter
    def ExportAsTriangles(self, value: bool) -> None: ...
    @ExportGroupNameLayerNames.setter
    def ExportGroupNameLayerNames(self, value: ObjGroupNames) -> None: ...
    @ExportMaterialDefinitions.setter
    def ExportMaterialDefinitions(self, value: bool) -> None: ...
    @ExportNormals.setter
    def ExportNormals(self, value: bool) -> None: ...
    @ExportObjectNames.setter
    def ExportObjectNames(self, value: ObjObjectNames) -> None: ...
    @ExportOpenMeshes.setter
    def ExportOpenMeshes(self, value: bool) -> None: ...
    @ExportTcs.setter
    def ExportTcs(self, value: bool) -> None: ...
    @ExportVcs.setter
    def ExportVcs(self, value: bool) -> None: ...
    @IncludeUnweldedEdgesInNgons.setter
    def IncludeUnweldedEdgesInNgons(self, value: bool) -> None: ...
    @MapZtoY.setter
    def MapZtoY(self, value: bool) -> None: ...
    @MergeNestedGroupingNames.setter
    def MergeNestedGroupingNames(self, value: bool) -> None: ...
    @MeshParameters.setter
    def MeshParameters(self, value: MeshingParameters) -> None: ...
    @MeshType.setter
    def MeshType(self, value: VertexWelding) -> None: ...
    @MinNgonFaceCount.setter
    def MinNgonFaceCount(self, value: int) -> None: ...
    @NgonMode.setter
    def NgonMode(self, value: NGons) -> None: ...
    @ObjectType.setter
    def ObjectType(self, value: GeometryType) -> None: ...
    @SignificantDigits.setter
    def SignificantDigits(self, value: int) -> None: ...
    @SortObjGroups.setter
    def SortObjGroups(self, value: bool) -> None: ...
    @SubDMeshType.setter
    def SubDMeshType(self, value: SubDMeshing) -> None: ...
    @SubDSurfaceMeshingDensity.setter
    def SubDSurfaceMeshingDensity(self, value: int) -> None: ...
    @TrimCurveType.setter
    def TrimCurveType(self, value: CurveType) -> None: ...
    @UnderbarMaterialNames.setter
    def UnderbarMaterialNames(self, value: bool) -> None: ...
    @UseDisplayColorForMaterial.setter
    def UseDisplayColorForMaterial(self, value: bool) -> None: ...
    @UseRelativeIndexing.setter
    def UseRelativeIndexing(self, value: bool) -> None: ...
    @UseRenderMeshes.setter
    def UseRenderMeshes(self, value: bool) -> None: ...
    @UseSimpleDialog.setter
    def UseSimpleDialog(self, value: bool) -> None: ...
    @WrapLongLines.setter
    def WrapLongLines(self, value: bool) -> None: ...


class FilePdf:
    def add_PreWrite(value: EventHandler) -> None: ...
    @overload
    def AddPage(self, settings: ViewCaptureSettings) -> int: ...
    @overload
    def AddPage(self, widthInDots: int, heightInDots: int, dotsPerInch: int) -> int: ...
    def Create() -> FilePdf: ...
    def DrawBitmap(self, pageNumber: int, bitmap: Bitmap, left: Single, top: Single, width: Single, height: Single, rotationInDegrees: Single) -> None: ...
    def DrawLine(self, pageNumber: int, from_: PointF, to: PointF, strokeColor: Color, strokeWidth: Single) -> None: ...
    def DrawPolyline(self, pageNumber: int, polyline: Set(PointF), fillColor: Color, strokeColor: Color, strokeWidth: Single) -> None: ...
    def DrawText(self, pageNumber: int, text: str, x: float, y: float, heightPoints: Single, onfont: Font, fillColor: Color, strokeColor: Color, strokeWidth: Single, angleDegrees: Single, horizontalAlignment: TextHorizontalAlignment, verticalAlignment: TextVerticalAlignment) -> None: ...
    @property
    def LayersAsOptionalContentGroups(self) -> bool: ...
    def PdfDocumentImplementation(self) -> Object: ...
    def remove_PreWrite(value: EventHandler) -> None: ...
    @LayersAsOptionalContentGroups.setter
    def LayersAsOptionalContentGroups(self, value: bool) -> None: ...
    @overload
    def Write(self, filename: str) -> None: ...
    @overload
    def Write(self, stream: Stream) -> None: ...


class FilePdfEventArgs:
    @property
    def Pdf(self) -> FilePdf: ...


class FilePly:
    def Write(filename: str, doc: RhinoDoc, options: FilePlyWriteOptions) -> WriteFileResult: ...


class FilePlyWriteOptions:
    def __init__(self, writeOptions: FileWriteOptions): ...
    @property
    def ExportASCII(self) -> bool: ...
    @property
    def ExportColors(self) -> bool: ...
    @property
    def ExportDoubles(self) -> bool: ...
    @property
    def ExportMaterial(self) -> bool: ...
    @property
    def ExportNormals(self) -> bool: ...
    @property
    def MeshingParameters(self) -> MeshingParameters: ...
    @property
    def UseSimpleDialog(self) -> bool: ...
    @ExportASCII.setter
    def ExportASCII(self, value: bool) -> None: ...
    @ExportColors.setter
    def ExportColors(self, value: bool) -> None: ...
    @ExportDoubles.setter
    def ExportDoubles(self, value: bool) -> None: ...
    @ExportMaterial.setter
    def ExportMaterial(self, value: bool) -> None: ...
    @ExportNormals.setter
    def ExportNormals(self, value: bool) -> None: ...
    @MeshingParameters.setter
    def MeshingParameters(self, value: MeshingParameters) -> None: ...
    @UseSimpleDialog.setter
    def UseSimpleDialog(self, value: bool) -> None: ...


class FileReadOptions:
    def __init__(self): ...
    def Dispose(self) -> None: ...
    @property
    def BatchMode(self) -> bool: ...
    @property
    def ImportMode(self) -> bool: ...
    @property
    def ImportReferenceMode(self) -> bool: ...
    @property
    def InsertMode(self) -> bool: ...
    @property
    def NewMode(self) -> bool: ...
    @property
    def OpenMode(self) -> bool: ...
    @property
    def ScaleGeometry(self) -> bool: ...
    @property
    def UseScaleGeometry(self) -> bool: ...
    @BatchMode.setter
    def BatchMode(self, value: bool) -> None: ...
    @ImportMode.setter
    def ImportMode(self, value: bool) -> None: ...
    @ImportReferenceMode.setter
    def ImportReferenceMode(self, value: bool) -> None: ...
    @InsertMode.setter
    def InsertMode(self, value: bool) -> None: ...
    @NewMode.setter
    def NewMode(self, value: bool) -> None: ...
    @OpenMode.setter
    def OpenMode(self, value: bool) -> None: ...
    @ScaleGeometry.setter
    def ScaleGeometry(self, value: bool) -> None: ...
    @UseScaleGeometry.setter
    def UseScaleGeometry(self, value: bool) -> None: ...


class FileReference:
    def __init__(self, fullPath: str, relativePath: str, hash: ContentHash, status: FileReferenceStatus): ...
    def CreateFromFullAndRelativePaths(fullPath: str, relativePath: str) -> FileReference: ...
    def CreateFromFullPath(fullPath: str) -> FileReference: ...
    def Dispose(self) -> None: ...
    @property
    def ContentHash(self) -> ContentHash: ...
    @property
    def FullPath(self) -> str: ...
    @property
    def FullPathStatus(self) -> FileReferenceStatus: ...
    @property
    def IsSet(self) -> bool: ...
    @property
    def RelativePath(self) -> str: ...


class FileReferenceStatus:
    Unknown = 0
    FullPathValid = 1
    FileNotFound = 2


class FileSlc:
    def Write(filename: str, doc: RhinoDoc, options: FileSlcWriteOptions) -> bool: ...


class FileSlcWriteOptions:
    def __init__(self): ...
    @property
    def AngleBetweenSegmentsDegrees(self) -> float: ...
    @property
    def EndPoint(self) -> Point3d: ...
    @property
    def SliceDistance(self) -> float: ...
    @property
    def StartPoint(self) -> Point3d: ...
    @property
    def UseMeshes(self) -> bool: ...
    @AngleBetweenSegmentsDegrees.setter
    def AngleBetweenSegmentsDegrees(self, value: float) -> None: ...
    @EndPoint.setter
    def EndPoint(self, value: Point3d) -> None: ...
    @SliceDistance.setter
    def SliceDistance(self, value: float) -> None: ...
    @StartPoint.setter
    def StartPoint(self, value: Point3d) -> None: ...
    @UseMeshes.setter
    def UseMeshes(self, value: bool) -> None: ...


class FileStp:
    def Write(filename: str, doc: RhinoDoc, options: FileStpWriteOptions) -> bool: ...


class FileStpWriteOptions:
    def __init__(self): ...
    @property
    def Export2dCurves(self) -> bool: ...
    @property
    def ExportBlack(self) -> bool: ...
    @property
    def SplitClosedSurfaces(self) -> bool: ...
    @Export2dCurves.setter
    def Export2dCurves(self, value: bool) -> None: ...
    @ExportBlack.setter
    def ExportBlack(self, value: bool) -> None: ...
    @SplitClosedSurfaces.setter
    def SplitClosedSurfaces(self, value: bool) -> None: ...


class FileType:
    def __init__(self, extension: str, description: str): ...
    @property
    def Description(self) -> str: ...
    @property
    def Extension(self) -> str: ...


class FileWriteOptions:
    def __init__(self): ...
    def Dispose(self) -> None: ...
    @property
    def DestinationFileName(self) -> str: ...
    @property
    def FileVersion(self) -> int: ...
    @property
    def IncludeBitmapTable(self) -> bool: ...
    @property
    def IncludeHistory(self) -> bool: ...
    @property
    def IncludePreviewImage(self) -> bool: ...
    @property
    def IncludeRenderMeshes(self) -> bool: ...
    @property
    def RhinoDoc(self) -> RhinoDoc: ...
    @property
    def SuppressAllInput(self) -> bool: ...
    @property
    def SuppressDialogBoxes(self) -> bool: ...
    @property
    def UpdateDocumentPath(self) -> bool: ...
    @property
    def WriteAsTemplate(self) -> bool: ...
    @property
    def WriteGeometryOnly(self) -> bool: ...
    @property
    def WriteSelectedObjectsOnly(self) -> bool: ...
    @property
    def WriteUserData(self) -> bool: ...
    @property
    def Xform(self) -> Transform: ...
    @FileVersion.setter
    def FileVersion(self, value: int) -> None: ...
    @IncludeBitmapTable.setter
    def IncludeBitmapTable(self, value: bool) -> None: ...
    @IncludeHistory.setter
    def IncludeHistory(self, value: bool) -> None: ...
    @IncludePreviewImage.setter
    def IncludePreviewImage(self, value: bool) -> None: ...
    @IncludeRenderMeshes.setter
    def IncludeRenderMeshes(self, value: bool) -> None: ...
    @SuppressAllInput.setter
    def SuppressAllInput(self, value: bool) -> None: ...
    @SuppressDialogBoxes.setter
    def SuppressDialogBoxes(self, value: bool) -> None: ...
    @UpdateDocumentPath.setter
    def UpdateDocumentPath(self, value: bool) -> None: ...
    @WriteGeometryOnly.setter
    def WriteGeometryOnly(self, value: bool) -> None: ...
    @WriteSelectedObjectsOnly.setter
    def WriteSelectedObjectsOnly(self, value: bool) -> None: ...
    @WriteUserData.setter
    def WriteUserData(self, value: bool) -> None: ...
    @Xform.setter
    def Xform(self, value: Transform) -> None: ...


class GeometryType:
    Nurbs = 0
    Mesh = 1




class ImageFile:
    def SupportsAlphaChannel(filename: str) -> bool: ...


class ManifestTable:
    def ActiveObjectCount(self, type: ModelComponentType) -> int: ...
    def Clear(self) -> None: ...
    def Contains(self, item: ModelComponent) -> bool: ...
    def CopyTo(self, array: Set(ModelComponent), arrayIndex: int) -> None: ...
    @overload
    def FindId(self, id: Guid) -> ModelComponent: ...
    @overload
    def FindId(self, id: Guid) -> T: ...
    @overload
    def FindId(self, id: Guid, type: ModelComponentType) -> ModelComponent: ...
    @overload
    def FindIndex(self, index: int) -> T: ...
    @overload
    def FindIndex(self, index: int, type: ModelComponentType) -> ModelComponent: ...
    @overload
    def FindName(self, name: str, parent: Guid) -> T: ...
    @overload
    def FindName(self, name: str, type: ModelComponentType, parent: Guid) -> ModelComponent: ...
    @overload
    def FindNameHash(self, nameHash: NameHash) -> T: ...
    @overload
    def FindNameHash(self, nameHash: NameHash, type: ModelComponentType) -> ModelComponent: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Count(self) -> int: ...
    @property
    def LongCount(self) -> Int64: ...
    @property
    def Parent(self) -> Object: ...
    @overload
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def GetEnumerator(self) -> IEnumerator: ...
    @overload
    def GetEnumerator(self, type: ModelComponentType) -> IEnumerator: ...
    def GetModelComponentTypeFromGenericType() -> ModelComponentType: ...


class NameHash:
    @overload
    def __init__(self, name: str): ...
    @overload
    def __init__(self, name: str, parentId: Guid): ...
    @overload
    def __init__(self, name: str, parentId: Guid, type: ModelComponentType): ...
    @overload
    def __init__(self, name: str, parentId: Guid, ignoreCase: bool): ...
    def Clone(self) -> NameHash: ...
    def CreateFilePathHash(path: str) -> NameHash: ...
    @overload
    def Equals(self, other: NameHash) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def MappedCodePoints(self) -> UInt32: ...
    @property
    def ParentId(self) -> Guid: ...
    @property
    def Sha1Hash(self) -> Set(Byte): ...
    def GetHashCode(self) -> int: ...
    def op_Equality(left: NameHash, right: NameHash) -> bool: ...
    def op_Inequality(left: NameHash, right: NameHash) -> bool: ...


class NGons:
    #None = 0
    Preserve = 1
    Create = 2


class ObjectTypeFilter:
    #None = 0
    Point = 1
    Pointset = 2
    Curve = 4
    Surface = 8
    Brep = 16
    Mesh = 32
    Annotation = 512
    InstanceDefinition = 2048
    InstanceReference = 4096
    TextDot = 8192
    DetailView = 32768
    Hatch = 65536
    Extrusion = 1073741824
    Any = 4294967295


class ObjGroupNames:
    NoGroups = 0
    LayerAsGroup = 1
    GroupAsGroup = 2


class ObjObjectNames:
    NoObjects = 0
    ObjectAsGroup = 1
    ObjectAsObject = 2


class SerializationOptions:
    def __init__(self): ...
    @property
    def RhinoVersion(self) -> int: ...
    @property
    def WriteUserData(self) -> bool: ...
    @RhinoVersion.setter
    def RhinoVersion(self, value: int) -> None: ...
    @WriteUserData.setter
    def WriteUserData(self, value: bool) -> None: ...


class SHA1OpenNURBS:
    def __init__(self): ...
    def FileSystemPathHash(path: str, ignoreCase: Nullable) -> Set(Byte): ...
    def Initialize(self) -> None: ...
    def StringHash(input: str) -> Set(Byte): ...


class SubDMeshing:
    Surface = 0
    ControlNet = 1


class TableTypeFilter:
    #None = 0
    Properties = 1
    Settings = 2
    Bitmap = 4
    TextureMapping = 8
    Material = 16
    Linetype = 32
    Layer = 64
    Group = 128
    Font = 256
    FutureFont = 512
    Dimstyle = 1024
    Light = 2048
    Hatchpattern = 4096
    InstanceDefinition = 8192
    ObjectTable = 16384
    Historyrecord = 32768
    UserTable = 65536


class TextLog:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, filename: str): ...
    @overload
    def __init__(self, ptr: IntPtr): ...
    def Dispose(self) -> None: ...
    @property
    def IndentSize(self) -> int: ...
    def NewCommandLine() -> TextLog: ...
    def PopIndent(self) -> None: ...
    @overload
    def Print(self, text: str) -> None: ...
    @overload
    def Print(self, format: str, arg0: Object) -> None: ...
    @overload
    def Print(self, format: str, arg0: Object, arg1: Object) -> None: ...
    def PrintWrappedText(self, text: str, lineLength: int) -> None: ...
    def PushIndent(self) -> None: ...
    @IndentSize.setter
    def IndentSize(self, value: int) -> None: ...
    def ToString(self) -> str: ...


class UseObjGsAs:
    IgnoreObjGroups = 0
    ObjGroupsAsLayers = 1
    ObjGroupsAsGroups = 2
    ObjGroupsAsObjects = 3


class VertexWelding:
    Normal = 0
    Welded = 1
    Unwelded = 2
