from typing import Tuple, Set, Iterable, List


class CurveIntersections:
    def CopyTo(self, array: Set(IntersectionEvent), arrayIndex: int) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> IntersectionEvent: ...
    def GetEnumerator(self) -> IEnumerator: ...


class Intersection:
    def BrepBrep(brepA: Brep, brepB: Brep, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d)]: ...
    def BrepPlane(brep: Brep, plane: Plane, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d)]: ...
    def BrepSurface(brep: Brep, surface: Surface, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d)]: ...
    @overload
    def CurveBrep(curve: Curve, brep: Brep, tolerance: float, angleTolerance: float) -> Tuple[bool, Set(float)]: ...
    @overload
    def CurveBrep(curve: Curve, brep: Brep, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d)]: ...
    @overload
    def CurveBrep(curve: Curve, brep: Brep, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d), Set(float)]: ...
    def CurveBrepFace(curve: Curve, face: BrepFace, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d)]: ...
    def CurveCurve(curveA: Curve, curveB: Curve, tolerance: float, overlapTolerance: float) -> CurveIntersections: ...
    def CurveCurveValidate(curveA: Curve, curveB: Curve, tolerance: float, overlapTolerance: float) -> Tuple[CurveIntersections, Set(int), TextLog]: ...
    def CurveLine(curve: Curve, line: Line, tolerance: float, overlapTolerance: float) -> CurveIntersections: ...
    def CurvePlane(curve: Curve, plane: Plane, tolerance: float) -> CurveIntersections: ...
    def CurveSelf(curve: Curve, tolerance: float) -> CurveIntersections: ...
    @overload
    def CurveSurface(curve: Curve, surface: Surface, tolerance: float, overlapTolerance: float) -> CurveIntersections: ...
    @overload
    def CurveSurface(curve: Curve, curveDomain: Interval, surface: Surface, tolerance: float, overlapTolerance: float) -> CurveIntersections: ...
    @overload
    def CurveSurfaceValidate(curve: Curve, surface: Surface, tolerance: float, overlapTolerance: float) -> Tuple[CurveIntersections, Set(int), TextLog]: ...
    @overload
    def CurveSurfaceValidate(curve: Curve, curveDomain: Interval, surface: Surface, tolerance: float, overlapTolerance: float) -> Tuple[CurveIntersections, Set(int), TextLog]: ...
    @property
    def MeshIntersectionsTolerancesCoefficient() -> float: ...
    @overload
    def LineBox(line: Line, box: BoundingBox, tolerance: float) -> Tuple[bool, Interval]: ...
    @overload
    def LineBox(line: Line, box: Box, tolerance: float) -> Tuple[bool, Interval]: ...
    def LineCircle(line: Line, circle: Circle) -> Tuple[LineCircleIntersection, float, Point3d, float, Point3d]: ...
    def LineCylinder(line: Line, cylinder: Cylinder) -> Tuple[LineCylinderIntersection, Point3d, Point3d]: ...
    @overload
    def LineLine(lineA: Line, lineB: Line) -> Tuple[bool, float, float]: ...
    @overload
    def LineLine(lineA: Line, lineB: Line, tolerance: float, finiteSegments: bool) -> Tuple[bool, float, float]: ...
    def LinePlane(line: Line, plane: Plane) -> Tuple[bool, float]: ...
    def LineSphere(line: Line, sphere: Sphere) -> Tuple[LineSphereIntersection, Point3d, Point3d]: ...
    @overload
    def MeshLine(mesh: Mesh, line: Line) -> Set(Point3d): ...
    @overload
    def MeshLine(mesh: Mesh, line: Line) -> Tuple[Set(Point3d), Set(int)]: ...
    def MeshLineSorted(mesh: Mesh, line: Line) -> Tuple[Set(Point3d), Set(int)]: ...
    def MeshMesh(meshes: Iterable[Mesh], tolerance: float, overlapsPolylines: bool, overlapsMesh: bool, textLog: TextLog, cancel: CancellationToken, progress: IProgress) -> Tuple[bool, Set(Polyline), Set(Polyline), Mesh]: ...
    def MeshMeshAccurate(meshA: Mesh, meshB: Mesh, tolerance: float) -> Set(Polyline): ...
    @overload
    def MeshPlane(mesh: Mesh, plane: Plane) -> Set(Polyline): ...
    @overload
    def MeshPlane(mesh: Mesh, planes: Iterable[Plane]) -> Set(Polyline): ...
    def MeshPolyline(mesh: Mesh, curve: PolylineCurve) -> Tuple[Set(Point3d), Set(int)]: ...
    def MeshPolylineSorted(mesh: Mesh, curve: PolylineCurve) -> Tuple[Set(Point3d), Set(int)]: ...
    @overload
    def MeshRay(mesh: Mesh, ray: Ray3d) -> float: ...
    @overload
    def MeshRay(mesh: Mesh, ray: Ray3d) -> Tuple[float, Set(int)]: ...
    def PlaneCircle(plane: Plane, circle: Circle) -> Tuple[PlaneCircleIntersection, float, float]: ...
    def PlanePlane(planeA: Plane, planeB: Plane) -> Tuple[bool, Line]: ...
    def PlanePlanePlane(planeA: Plane, planeB: Plane, planeC: Plane) -> Tuple[bool, Point3d]: ...
    def PlaneSphere(plane: Plane, sphere: Sphere) -> Tuple[PlaneSphereIntersection, Circle]: ...
    def ProjectPointsToBreps(breps: Iterable[Brep], points: Iterable[Point3d], direction: Vector3d, tolerance: float) -> Set(Point3d): ...
    def ProjectPointsToBrepsEx(breps: Iterable[Brep], points: Iterable[Point3d], direction: Vector3d, tolerance: float) -> Tuple[Set(Point3d), Set(int)]: ...
    def ProjectPointsToMeshes(meshes: Iterable[Mesh], points: Iterable[Point3d], direction: Vector3d, tolerance: float) -> Set(Point3d): ...
    def ProjectPointsToMeshesEx(meshes: Iterable[Mesh], points: Iterable[Point3d], direction: Vector3d, tolerance: float) -> Tuple[Set(Point3d), Set(int)]: ...
    @overload
    def RayShoot(ray: Ray3d, geometry: Iterable[GeometryBase], maxReflections: int) -> Set(Point3d): ...
    @overload
    def RayShoot(geometry: Iterable[GeometryBase], ray: Ray3d, maxReflections: int) -> Set(RayShootEvent): ...
    def SphereSphere(sphereA: Sphere, sphereB: Sphere) -> Tuple[SphereSphereIntersection, Circle]: ...
    def SurfaceSurface(surfaceA: Surface, surfaceB: Surface, tolerance: float) -> Tuple[bool, Set(Curve), Set(Point3d)]: ...


class IntersectionEvent:
    def __init__(self): ...
    @overload
    def CompareEquivalent(eventA: IntersectionEvent, eventB: IntersectionEvent, relativePointTolerance: float) -> bool: ...
    @overload
    def CompareEquivalent(eventA: IntersectionEvent, eventB: IntersectionEvent, relativePointTolerance: float, log: TextLog) -> bool: ...
    @property
    def IsOverlap(self) -> bool: ...
    @property
    def IsPoint(self) -> bool: ...
    @property
    def OverlapA(self) -> Interval: ...
    @property
    def OverlapB(self) -> Interval: ...
    @property
    def ParameterA(self) -> float: ...
    @property
    def ParameterB(self) -> float: ...
    @property
    def PointA(self) -> Point3d: ...
    @property
    def PointA2(self) -> Point3d: ...
    @property
    def PointB(self) -> Point3d: ...
    @property
    def PointB2(self) -> Point3d: ...
    def SurfaceOverlapParameter(self) -> Tuple[Interval, Interval]: ...
    def SurfacePointParameter(self) -> Tuple[float, float]: ...


class LineCircleIntersection:
    #None = 0
    Single = 1
    Multiple = 2


class LineCylinderIntersection:
    #None = 0
    Single = 1
    Multiple = 2
    Overlap = 3


class LineSphereIntersection:
    #None = 0
    Single = 1
    Multiple = 2


class MeshClash:
    @overload
    def FindDetail(objA: RhinoObject, objB: RhinoObject, distance: float) -> Set(Mesh): ...
    @overload
    def FindDetail(objA: RhinoObject, objB: RhinoObject, distance: float, meshType: MeshType, meshingParameters: MeshingParameters) -> Set(Mesh): ...
    @property
    def ClashPoint(self) -> Point3d: ...
    @property
    def ClashRadius(self) -> float: ...
    @property
    def MeshA(self) -> Mesh: ...
    @property
    def MeshB(self) -> Mesh: ...
    @overload
    def Search(setA: Iterable[RhinoObject], setB: Iterable[RhinoObject], distance: float) -> Set(MeshInterference): ...
    @overload
    def Search(setA: Iterable[Mesh], setB: Iterable[Mesh], distance: float, maxEventCount: int) -> Set(MeshClash): ...
    @overload
    def Search(meshA: Mesh, setB: Iterable[Mesh], distance: float, maxEventCount: int) -> Set(MeshClash): ...
    @overload
    def Search(meshA: Mesh, meshB: Mesh, distance: float, maxEventCount: int) -> Set(MeshClash): ...
    @overload
    def Search(setA: Iterable[RhinoObject], setB: Iterable[RhinoObject], distance: float, meshType: MeshType, meshingParameters: MeshingParameters) -> Set(MeshInterference): ...


class MeshInterference:
    @property
    def HitPoints(self) -> Set(Point3d): ...
    @property
    def IndexA(self) -> int: ...
    @property
    def IndexB(self) -> int: ...
    @HitPoints.setter
    def HitPoints(self, value: Set(Point3d)) -> None: ...
    @IndexA.setter
    def IndexA(self, value: int) -> None: ...
    @IndexB.setter
    def IndexB(self, value: int) -> None: ...


class PlaneCircleIntersection:
    #None = 0
    Tangent = 1
    Secant = 2
    Parallel = 3
    Coincident = 4


class PlaneSphereIntersection:
    #None = 0
    Point = 1
    Circle = 2


class RayShootEvent:
    @property
    def BrepFaceIndex(self) -> int: ...
    @property
    def GeometryIndex(self) -> int: ...
    @property
    def Point(self) -> Point3d: ...
    @BrepFaceIndex.setter
    def BrepFaceIndex(self, value: int) -> None: ...
    @GeometryIndex.setter
    def GeometryIndex(self, value: int) -> None: ...
    @Point.setter
    def Point(self, value: Point3d) -> None: ...


class SphereSphereIntersection:
    #None = 0
    Point = 1
    Circle = 2
    Overlap = 3
