__all__ = ['Collections','Intersect','MeshRefinements','Morphs']
from typing import Tuple, Set, Iterable, List


class AngularDimension(Dimension):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, arc: Arc, offset: float): ...
    @overload
    def AdjustFromPoints(self, plane: Plane, centerpoint: Point3d, defpoint1: Point3d, defpoint2: Point3d, dimlinepoint: Point3d) -> bool: ...
    @overload
    def AdjustFromPoints(self, plane: Plane, extpoint1: Point3d, extpoint2: Point3d, dirpoint1: Point3d, dirpoint2: Point3d, dimlinepoint: Point3d) -> bool: ...
    @overload
    def Create(dimStyle: DimensionStyle, plane: Plane, horizontal: Vector3d, centerpoint: Point3d, defpoint1: Point3d, defpoint2: Point3d, dimlinepoint: Point3d) -> AngularDimension: ...
    @overload
    def Create(styleId: Guid, plane: Plane, extpoint1: Point3d, extpoint2: Point3d, dirpoint1: Point3d, dirpoint2: Point3d, dimlinepoint: Point3d) -> AngularDimension: ...
    @property
    def AngleFormat(self) -> AngleDisplayFormat: ...
    @property
    def AngleResolution(self) -> int: ...
    @property
    def AngleRoundoff(self) -> float: ...
    @property
    def AngleZeroSuppression(self) -> ZeroSuppression: ...
    @property
    def ArrowPoint1(self) -> Point2d: ...
    @property
    def ArrowPoint2(self) -> Point2d: ...
    @property
    def CenterPoint(self) -> Point2d: ...
    @property
    def DefPoint1(self) -> Point2d: ...
    @property
    def DefPoint2(self) -> Point2d: ...
    @property
    def DimlinePoint(self) -> Point2d: ...
    def Get3dPoints(self) -> Tuple[bool, Point3d, Point3d, Point3d, Point3d, Point3d, Point3d, Point3d]: ...
    def GetAngleDisplayText(self, style: DimensionStyle) -> str: ...
    def GetDisplayLines(self, style: DimensionStyle, scale: float) -> Tuple[bool, Set(Line), Set(Arc)]: ...
    def GetTextRectangle(self) -> Tuple[bool, Set(Point3d)]: ...
    @AngleFormat.setter
    def AngleFormat(self, value: AngleDisplayFormat) -> None: ...
    @AngleResolution.setter
    def AngleResolution(self, value: int) -> None: ...
    @AngleRoundoff.setter
    def AngleRoundoff(self, value: float) -> None: ...
    @AngleZeroSuppression.setter
    def AngleZeroSuppression(self, value: ZeroSuppression) -> None: ...
    @CenterPoint.setter
    def CenterPoint(self, value: Point2d) -> None: ...
    @DefPoint1.setter
    def DefPoint1(self, value: Point2d) -> None: ...
    @DefPoint2.setter
    def DefPoint2(self, value: Point2d) -> None: ...
    @DimlinePoint.setter
    def DimlinePoint(self, value: Point2d) -> None: ...


class AnnotationBase(GeometryBase):
    def ClearPropertyOverrides(self) -> bool: ...
    def FirstCharProperties(rtf_str: str, bold: bool, italic: bool, underline: bool, facename: str) -> Tuple[bool, bool, bool, bool, str]: ...
    def FormatRtfString(rtf_in: str, clear_bold: bool, set_bold: bool, clear_italic: bool, set_italic: bool, clear_underline: bool, set_underline: bool, clear_facename: bool, set_facename: bool, facename: str) -> str: ...
    @property
    def AlternateDimensionLengthDisplay(self) -> LengthDisplay: ...
    @property
    def AnnotationType(self) -> AnnotationType: ...
    @property
    def DecimalSeparator(self) -> Char: ...
    @property
    def DimensionLengthDisplay(self) -> LengthDisplay: ...
    @property
    def DimensionScale(self) -> float: ...
    @property
    def DimensionStyle(self) -> DimensionStyle: ...
    @property
    def DimensionStyleId(self) -> Guid: ...
    @property
    def DrawForward(self) -> bool: ...
    @property
    def DrawTextFrame(self) -> bool: ...
    @property
    def FirstCharFont(self) -> Font: ...
    @property
    def Font(self) -> Font: ...
    @property
    def FontIndex(self) -> int: ...
    @property
    def FormatWidth(self) -> float: ...
    @property
    def HasPropertyOverrides(self) -> bool: ...
    @property
    def MaskColor(self) -> Color: ...
    @property
    def MaskColorSource(self) -> MaskType: ...
    @property
    def MaskEnabled(self) -> bool: ...
    @property
    def MaskFrame(self) -> MaskFrame: ...
    @property
    def MaskOffset(self) -> float: ...
    @property
    def MaskUsesViewportColor(self) -> bool: ...
    @property
    def ParentDimensionStyle(self) -> DimensionStyle: ...
    @property
    def PlainText(self) -> str: ...
    @property
    def PlainTextWithFields(self) -> str: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def RichText(self) -> str: ...
    @property
    def Text(self) -> str: ...
    @property
    def TextFormula(self) -> str: ...
    @property
    def TextHasRtfFormatting(self) -> bool: ...
    @property
    def TextHeight(self) -> float: ...
    @property
    def TextIsWrapped(self) -> bool: ...
    @property
    def TextModelWidth(self) -> float: ...
    @property
    def TextRotationDegrees(self) -> float: ...
    @property
    def TextRotationRadians(self) -> float: ...
    @overload
    def GetBoundingBox(self, xform: Transform) -> BoundingBox: ...
    def GetDimensionScale(doc: RhinoDoc, dimstyle: DimensionStyle, vport: RhinoViewport) -> float: ...
    def GetDimensionStyle(self, parentDimStyle: DimensionStyle) -> DimensionStyle: ...
    def GetPlainTextWithRunMap(self, map: Set(int)) -> Tuple[str, Set(int)]: ...
    def IsAllBold(self) -> bool: ...
    def IsAllItalic(self) -> bool: ...
    def IsAllUnderlined(self) -> bool: ...
    def IsPropertyOverridden(self, field: Field) -> bool: ...
    def PlainTextToRtf(str: str) -> str: ...
    def RunReplace(self, replaceString: str, startRunIndex: int, startRunPosition: int, endRunIndex: int, endRunPosition: int) -> bool: ...
    @AlternateDimensionLengthDisplay.setter
    def AlternateDimensionLengthDisplay(self, value: LengthDisplay) -> None: ...
    @DecimalSeparator.setter
    def DecimalSeparator(self, value: Char) -> None: ...
    @DimensionLengthDisplay.setter
    def DimensionLengthDisplay(self, value: LengthDisplay) -> None: ...
    @DimensionScale.setter
    def DimensionScale(self, value: float) -> None: ...
    @DimensionStyleId.setter
    def DimensionStyleId(self, value: Guid) -> None: ...
    @DrawForward.setter
    def DrawForward(self, value: bool) -> None: ...
    @DrawTextFrame.setter
    def DrawTextFrame(self, value: bool) -> None: ...
    @Font.setter
    def Font(self, value: Font) -> None: ...
    @FontIndex.setter
    def FontIndex(self, value: int) -> None: ...
    @FormatWidth.setter
    def FormatWidth(self, value: float) -> None: ...
    @MaskColor.setter
    def MaskColor(self, value: Color) -> None: ...
    @MaskColorSource.setter
    def MaskColorSource(self, value: MaskType) -> None: ...
    @MaskEnabled.setter
    def MaskEnabled(self, value: bool) -> None: ...
    @MaskFrame.setter
    def MaskFrame(self, value: MaskFrame) -> None: ...
    @MaskOffset.setter
    def MaskOffset(self, value: float) -> None: ...
    @MaskUsesViewportColor.setter
    def MaskUsesViewportColor(self, value: bool) -> None: ...
    @ParentDimensionStyle.setter
    def ParentDimensionStyle(self, value: DimensionStyle) -> None: ...
    @PlainText.setter
    def PlainText(self, value: str) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @RichText.setter
    def RichText(self, value: str) -> None: ...
    @Text.setter
    def Text(self, value: str) -> None: ...
    @TextFormula.setter
    def TextFormula(self, value: str) -> None: ...
    @TextHeight.setter
    def TextHeight(self, value: float) -> None: ...
    @TextIsWrapped.setter
    def TextIsWrapped(self, value: bool) -> None: ...
    @TextRotationDegrees.setter
    def TextRotationDegrees(self, value: float) -> None: ...
    @TextRotationRadians.setter
    def TextRotationRadians(self, value: float) -> None: ...
    def SetBold(self, set_on: bool) -> bool: ...
    def SetFacename(self, set_on: bool, facename: str) -> bool: ...
    def SetItalic(self, set_on: bool) -> bool: ...
    def SetOverrideDimStyle(self, OverrideStyle: DimensionStyle) -> bool: ...
    def SetRichText(self, rtfText: str, dimstyle: DimensionStyle) -> None: ...
    def SetUnderline(self, set_on: bool) -> bool: ...
    def WrapText(self) -> None: ...


class AnnotationType:
    Unset = 0
    Aligned = 1
    Angular = 2
    Diameter = 3
    Radius = 4
    Rotated = 5
    Ordinate = 6
    ArcLen = 7
    CenterMark = 8
    Text = 9
    Leader = 10
    Angular3pt = 11


class Arc:
    @overload
    def __init__(self, circle: Circle, angleRadians: float): ...
    @overload
    def __init__(self, circle: Circle, angleIntervalRadians: Interval): ...
    @overload
    def __init__(self, plane: Plane, radius: float, angleRadians: float): ...
    @overload
    def __init__(self, center: Point3d, radius: float, angleRadians: float): ...
    @overload
    def __init__(self, startPoint: Point3d, pointOnInterior: Point3d, endPoint: Point3d): ...
    @overload
    def __init__(self, pointA: Point3d, tangentA: Vector3d, pointB: Point3d): ...
    @overload
    def __init__(self, plane: Plane, center: Point3d, radius: float, angleRadians: float): ...
    def BoundingBox(self) -> BoundingBox: ...
    def ClosestParameter(self, testPoint: Point3d) -> float: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def EpsilonEquals(self, other: Arc, epsilon: float) -> bool: ...
    @overload
    def Equals(self, other: Arc) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def Angle(self) -> float: ...
    @property
    def AngleDegrees(self) -> float: ...
    @property
    def AngleDomain(self) -> Interval: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Circumference(self) -> float: ...
    @property
    def Diameter(self) -> float: ...
    @property
    def EndAngle(self) -> float: ...
    @property
    def EndAngleDegrees(self) -> float: ...
    @property
    def EndPoint(self) -> Point3d: ...
    @property
    def IsCircle(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Length(self) -> float: ...
    @property
    def MidPoint(self) -> Point3d: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Radius(self) -> float: ...
    @property
    def StartAngle(self) -> float: ...
    @property
    def StartAngleDegrees(self) -> float: ...
    @property
    def StartPoint(self) -> Point3d: ...
    @property
    def Unset() -> Arc: ...
    def GetHashCode(self) -> int: ...
    def op_Equality(a: Arc, b: Arc) -> bool: ...
    def op_Inequality(a: Arc, b: Arc) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...
    def Reverse(self) -> None: ...
    @Angle.setter
    def Angle(self, value: float) -> None: ...
    @AngleDegrees.setter
    def AngleDegrees(self, value: float) -> None: ...
    @AngleDomain.setter
    def AngleDomain(self, value: Interval) -> None: ...
    @Center.setter
    def Center(self, value: Point3d) -> None: ...
    @Diameter.setter
    def Diameter(self, value: float) -> None: ...
    @EndAngle.setter
    def EndAngle(self, value: float) -> None: ...
    @EndAngleDegrees.setter
    def EndAngleDegrees(self, value: float) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @StartAngle.setter
    def StartAngle(self, value: float) -> None: ...
    @StartAngleDegrees.setter
    def StartAngleDegrees(self, value: float) -> None: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    @overload
    def ToNurbsCurve(self) -> NurbsCurve: ...
    @overload
    def ToNurbsCurve(self, degree: int, cvCount: int) -> NurbsCurve: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Trim(self, domain: Interval) -> bool: ...


class ArcCurve(Curve):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: ArcCurve): ...
    @overload
    def __init__(self, arc: Arc): ...
    @overload
    def __init__(self, circle: Circle): ...
    @overload
    def __init__(self, arc: Arc, t0: float, t1: float): ...
    @overload
    def __init__(self, circle: Circle, t0: float, t1: float): ...
    @property
    def AngleDegrees(self) -> float: ...
    @property
    def AngleRadians(self) -> float: ...
    @property
    def Arc(self) -> Arc: ...
    @property
    def IsCompleteCircle(self) -> bool: ...
    @property
    def Radius(self) -> float: ...


class AreaMassProperties:
    def CentroidCoordinatesPrincipalMoments(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    def CentroidCoordinatesPrincipalMomentsOfInertia(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    @overload
    def Compute(closedPlanarCurve: Curve) -> AreaMassProperties: ...
    @overload
    def Compute(hatch: Hatch) -> AreaMassProperties: ...
    @overload
    def Compute(mesh: Mesh) -> AreaMassProperties: ...
    @overload
    def Compute(brep: Brep) -> AreaMassProperties: ...
    @overload
    def Compute(surface: Surface) -> AreaMassProperties: ...
    @overload
    def Compute(geometry: Iterable[GeometryBase]) -> AreaMassProperties: ...
    @overload
    def Compute(closedPlanarCurve: Curve, planarTolerance: float) -> AreaMassProperties: ...
    @overload
    def Compute(mesh: Mesh, area: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> AreaMassProperties: ...
    @overload
    def Compute(brep: Brep, area: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> AreaMassProperties: ...
    @overload
    def Compute(surface: Surface, area: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> AreaMassProperties: ...
    @overload
    def Compute(geometry: Iterable[GeometryBase], area: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> AreaMassProperties: ...
    def Dispose(self) -> None: ...
    @property
    def Area(self) -> float: ...
    @property
    def AreaError(self) -> float: ...
    @property
    def Centroid(self) -> Point3d: ...
    @property
    def CentroidCoordinatesMomentsOfInertia(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesMomentsOfInertiaError(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesProductMoments(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesProductMomentsError(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesRadiiOfGyration(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesSecondMoments(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesSecondMomentsError(self) -> Vector3d: ...
    @property
    def CentroidError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesFirstMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesFirstMomentsError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesMomentsOfInertia(self) -> Vector3d: ...
    @property
    def WorldCoordinatesMomentsOfInertiaError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesProductMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesProductMomentsError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesRadiiOfGyration(self) -> Vector3d: ...
    @property
    def WorldCoordinatesSecondMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesSecondMomentsError(self) -> Vector3d: ...
    def WorldCoordinatesPrincipalMoments(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    def WorldCoordinatesPrincipalMomentsOfInertia(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...


class Arrowhead:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, arrowType: ArrowType, blockId: Guid): ...
    @property
    def ArrowType(self) -> ArrowType: ...
    @property
    def BlockId(self) -> Guid: ...


class Attenuation:
    Constant = 0
    Linear = 1
    InverseSquared = 2


class BezierCurve:
    @overload
    def __init__(self, controlPoints: Iterable[Point2d]): ...
    @overload
    def __init__(self, controlPoints: Iterable[Point3d]): ...
    @overload
    def __init__(self, controlPoints: Iterable[Point4d]): ...
    def ChangeDimension(self, desiredDimension: int) -> bool: ...
    def CreateBeziers(sourceCurve: Curve) -> Set(BezierCurve): ...
    def CreateCubicBeziers(sourceCurve: Curve, distanceTolerance: float, kinkTolerance: float) -> Set(BezierCurve): ...
    @overload
    def CreateLoftedBezier(points: Iterable[Point3d]) -> BezierCurve: ...
    @overload
    def CreateLoftedBezier(points: Iterable[Point2d]) -> BezierCurve: ...
    def CurvatureAt(self, t: float) -> Vector3d: ...
    def Dispose(self) -> None: ...
    @property
    def ControlVertexCount(self) -> int: ...
    @property
    def Dimension(self) -> int: ...
    @property
    def IsRational(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    def GetBoundingBox(self, accurate: bool) -> BoundingBox: ...
    def GetControlVertex2d(self, index: int) -> Point2d: ...
    def GetControlVertex3d(self, index: int) -> Point3d: ...
    def GetControlVertex4d(self, index: int) -> Point4d: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def IncreaseDegree(self, desiredDegree: int) -> bool: ...
    def MakeNonRational(self) -> bool: ...
    def MakeRational(self) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...
    def Split(self, t: float) -> Tuple[bool, BezierCurve, BezierCurve]: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...


class BezierSurface:
    def ControlVertexCount(self, direction: int) -> int: ...
    def CreateLoftedBezier(curves: Iterable[BezierCurve]) -> BezierSurface: ...
    def Dispose(self) -> None: ...
    def Domain(self, direction: int) -> Interval: ...
    @property
    def Dimension(self) -> int: ...
    @property
    def IsRational(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    def GetBoundingBox(self, accurate: bool) -> BoundingBox: ...
    def GetControlVertex2d(self, i: int, j: int) -> Point2d: ...
    def GetControlVertex3d(self, i: int, j: int) -> Point3d: ...
    def GetControlVertex4d(self, i: int, j: int) -> Point4d: ...
    def MakeNonRational(self) -> bool: ...
    def MakeRational(self) -> bool: ...
    def PointAt(self, u: float, v: float) -> Point3d: ...
    def Reverse(self, direction: int) -> BezierSurface: ...
    def Split(self, direction: int, t: float) -> Tuple[bool, BezierSurface, BezierSurface]: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Transpose(self) -> BezierSurface: ...


class BlendContinuity:
    Position = 0
    Tangency = 1
    Curvature = 2


class BlendType:
    Chamfer = 0
    Fillet = 1
    Blend = 2


class BoundingBox:
    @overload
    def __init__(self, points: Iterable[Point3d]): ...
    @overload
    def __init__(self, min: Point3d, max: Point3d): ...
    @overload
    def __init__(self, points: Iterable[Point3d], xform: Transform): ...
    @overload
    def __init__(self, minX: float, minY: float, minZ: float, maxX: float, maxY: float, maxZ: float): ...
    @overload
    def ClosestPoint(self, point: Point3d) -> Point3d: ...
    @overload
    def ClosestPoint(self, point: Point3d, includeInterior: bool) -> Point3d: ...
    @overload
    def Contains(self, point: Point3d) -> bool: ...
    @overload
    def Contains(self, box: BoundingBox) -> bool: ...
    @overload
    def Contains(self, box: BoundingBox, strict: bool) -> bool: ...
    @overload
    def Contains(self, point: Point3d, strict: bool) -> bool: ...
    def Corner(self, minX: bool, minY: bool, minZ: bool) -> Point3d: ...
    def FurthestPoint(self, point: Point3d) -> Point3d: ...
    @property
    def Area(self) -> float: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Diagonal(self) -> Vector3d: ...
    @property
    def Empty() -> BoundingBox: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Max(self) -> Point3d: ...
    @property
    def Min(self) -> Point3d: ...
    @property
    def Unset() -> BoundingBox: ...
    @property
    def Volume(self) -> float: ...
    def GetCorners(self) -> Set(Point3d): ...
    def GetEdges(self) -> Set(Line): ...
    @overload
    def Inflate(self, amount: float) -> None: ...
    @overload
    def Inflate(self, xAmount: float, yAmount: float, zAmount: float) -> None: ...
    def Intersection(a: BoundingBox, b: BoundingBox) -> BoundingBox: ...
    def IsDegenerate(self, tolerance: float) -> int: ...
    def MakeValid(self) -> bool: ...
    def PointAt(self, tx: float, ty: float, tz: float) -> Point3d: ...
    @Max.setter
    def Max(self, value: Point3d) -> None: ...
    @Min.setter
    def Min(self, value: Point3d) -> None: ...
    def ToBrep(self) -> Brep: ...
    def ToString(self) -> str: ...
    def Transform(self, xform: Transform) -> bool: ...
    @overload
    def Union(self, other: BoundingBox) -> None: ...
    @overload
    def Union(self, point: Point3d) -> None: ...
    @overload
    def Union(a: BoundingBox, b: BoundingBox) -> BoundingBox: ...
    @overload
    def Union(box: BoundingBox, point: Point3d) -> BoundingBox: ...


class Box:
    @overload
    def __init__(self, other: Box): ...
    @overload
    def __init__(self, bbox: BoundingBox): ...
    @overload
    def __init__(self, basePlane: Plane, points: Iterable[Point3d]): ...
    @overload
    def __init__(self, basePlane: Plane, geometry: GeometryBase): ...
    @overload
    def __init__(self, basePlane: Plane, boundingbox: BoundingBox): ...
    @overload
    def __init__(self, basePlane: Plane, xSize: Interval, ySize: Interval, zSize: Interval): ...
    def ClosestPoint(self, point: Point3d) -> Point3d: ...
    @overload
    def Contains(self, box: BoundingBox) -> bool: ...
    @overload
    def Contains(self, point: Point3d) -> bool: ...
    @overload
    def Contains(self, box: Box) -> bool: ...
    @overload
    def Contains(self, box: BoundingBox, strict: bool) -> bool: ...
    @overload
    def Contains(self, box: Box, strict: bool) -> bool: ...
    @overload
    def Contains(self, point: Point3d, strict: bool) -> bool: ...
    def EpsilonEquals(self, other: Box, epsilon: float) -> bool: ...
    def FurthestPoint(self, point: Point3d) -> Point3d: ...
    @property
    def Area(self) -> float: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Empty() -> Box: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Unset() -> Box: ...
    @property
    def Volume(self) -> float: ...
    @property
    def X(self) -> Interval: ...
    @property
    def Y(self) -> Interval: ...
    @property
    def Z(self) -> Interval: ...
    def GetCorners(self) -> Set(Point3d): ...
    @overload
    def Inflate(self, amount: float) -> None: ...
    @overload
    def Inflate(self, xAmount: float, yAmount: float, zAmount: float) -> None: ...
    def MakeValid(self) -> bool: ...
    def PointAt(self, x: float, y: float, z: float) -> Point3d: ...
    def RepositionBasePlane(self, origin: Point3d) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @X.setter
    def X(self, value: Interval) -> None: ...
    @Y.setter
    def Y(self, value: Interval) -> None: ...
    @Z.setter
    def Z(self, value: Interval) -> None: ...
    def ToBrep(self) -> Brep: ...
    def ToExtrusion(self) -> Extrusion: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Union(self, point: Point3d) -> None: ...


class Brep(GeometryBase):
    def __init__(self): ...
    def AddEdgeCurve(self, curve: Curve) -> int: ...
    def AddSurface(self, surface: Surface) -> int: ...
    def AddTrimCurve(self, curve: Curve) -> int: ...
    def Append(self, other: Brep) -> None: ...
    def CapPlanarHoles(self, tolerance: float) -> Brep: ...
    def ChangeSeam(face: BrepFace, direction: int, parameter: float, tolerance: float) -> Brep: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d, maximumDistance: float) -> Tuple[bool, Point3d, ComponentIndex, float, float, Vector3d]: ...
    def Compact(self) -> None: ...
    def CopyTrimCurves(trimSource: BrepFace, surfaceSource: Surface, tolerance: float) -> Brep: ...
    def CreateBaseballSphere(center: Point3d, radius: float, tolerance: float) -> Brep: ...
    def CreateBlendShape(face0: BrepFace, edge0: BrepEdge, t0: float, rev0: bool, continuity0: BlendContinuity, face1: BrepFace, edge1: BrepEdge, t1: float, rev1: bool, continuity1: BlendContinuity) -> Curve: ...
    def CreateBlendSurface(face0: BrepFace, edge0: BrepEdge, domain0: Interval, rev0: bool, continuity0: BlendContinuity, face1: BrepFace, edge1: BrepEdge, domain1: Interval, rev1: bool, continuity1: BlendContinuity) -> Set(Brep): ...
    @overload
    def CreateBooleanDifference(firstBrep: Brep, secondBrep: Brep, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanDifference(firstSet: Iterable[Brep], secondSet: Iterable[Brep], tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanDifference(firstSet: Iterable[Brep], secondSet: Iterable[Brep], tolerance: float, manifoldOnly: bool) -> Set(Brep): ...
    @overload
    def CreateBooleanDifference(firstBrep: Brep, secondBrep: Brep, tolerance: float, manifoldOnly: bool) -> Set(Brep): ...
    @overload
    def CreateBooleanIntersection(firstBrep: Brep, secondBrep: Brep, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanIntersection(firstSet: Iterable[Brep], secondSet: Iterable[Brep], tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanIntersection(firstBrep: Brep, secondBrep: Brep, tolerance: float, manifoldOnly: bool) -> Set(Brep): ...
    @overload
    def CreateBooleanIntersection(firstSet: Iterable[Brep], secondSet: Iterable[Brep], tolerance: float, manifoldOnly: bool) -> Set(Brep): ...
    @overload
    def CreateBooleanSplit(firstBrep: Brep, secondBrep: Brep, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanSplit(firstSet: Iterable[Brep], secondSet: Iterable[Brep], tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanUnion(breps: Iterable[Brep], tolerance: float) -> Set(Brep): ...
    @overload
    def CreateBooleanUnion(breps: Iterable[Brep], tolerance: float, manifoldOnly: bool) -> Set(Brep): ...
    @overload
    def CreateChamferSurface(face0: BrepFace, uv0: Point2d, radius0: float, face1: BrepFace, uv1: Point2d, radius1: float, extend: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateChamferSurface(face0: BrepFace, uv0: Point2d, radius0: float, face1: BrepFace, uv1: Point2d, radius1: float, trim: bool, extend: bool, tolerance: float) -> Tuple[Set(Brep), Set(Brep), Set(Brep)]: ...
    @overload
    def CreateContourCurves(brepToContour: Brep, sectionPlane: Plane) -> Set(Curve): ...
    @overload
    def CreateContourCurves(brepToContour: Brep, contourStart: Point3d, contourEnd: Point3d, interval: float) -> Set(Curve): ...
    def CreateCurvatureAnalysisMesh(brep: Brep, state: CurvatureAnalysisSettingsState) -> Set(Mesh): ...
    @overload
    def CreateDevelopableLoft(rail0: NurbsCurve, rail1: NurbsCurve, fixedRulings: Iterable[Point2d]) -> Set(Brep): ...
    @overload
    def CreateDevelopableLoft(crv0: Curve, crv1: Curve, reverse0: bool, reverse1: bool, density: int) -> Set(Brep): ...
    def CreateEdgeSurface(curves: Iterable[Curve]) -> Brep: ...
    def CreateFilletEdges(brep: Brep, edgeIndices: Iterable[int], startRadii: Iterable[float], endRadii: Iterable[float], blendType: BlendType, railType: RailType, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFilletSurface(face0: BrepFace, uv0: Point2d, face1: BrepFace, uv1: Point2d, radius: float, extend: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFilletSurface(face0: BrepFace, uv0: Point2d, face1: BrepFace, uv1: Point2d, radius: float, trim: bool, extend: bool, tolerance: float) -> Tuple[Set(Brep), Set(Brep), Set(Brep)]: ...
    @overload
    def CreateFromBox(corners: Iterable[Point3d]) -> Brep: ...
    @overload
    def CreateFromBox(box: Box) -> Brep: ...
    @overload
    def CreateFromBox(box: BoundingBox) -> Brep: ...
    def CreateFromCone(cone: Cone, capBottom: bool) -> Brep: ...
    @overload
    def CreateFromCornerPoints(corner1: Point3d, corner2: Point3d, corner3: Point3d, tolerance: float) -> Brep: ...
    @overload
    def CreateFromCornerPoints(corner1: Point3d, corner2: Point3d, corner3: Point3d, corner4: Point3d, tolerance: float) -> Brep: ...
    def CreateFromCylinder(cylinder: Cylinder, capBottom: bool, capTop: bool) -> Brep: ...
    def CreateFromJoinedEdges(brep0: Brep, edgeIndex0: int, brep1: Brep, edgeIndex1: int, joinTolerance: float) -> Brep: ...
    @overload
    def CreateFromLoft(curves: Iterable[Curve], start: Point3d, end: Point3d, loftType: LoftType, closed: bool) -> Set(Brep): ...
    @overload
    def CreateFromLoft(curves: Iterable[Curve], start: Point3d, end: Point3d, StartTangent: bool, EndTangent: bool, StartTrim: BrepTrim, EndTrim: BrepTrim, loftType: LoftType, closed: bool) -> Set(Brep): ...
    def CreateFromLoftRebuild(curves: Iterable[Curve], start: Point3d, end: Point3d, loftType: LoftType, closed: bool, rebuildPointCount: int) -> Set(Brep): ...
    def CreateFromLoftRefit(curves: Iterable[Curve], start: Point3d, end: Point3d, loftType: LoftType, closed: bool, refitTolerance: float) -> Set(Brep): ...
    def CreateFromMesh(mesh: Mesh, trimmedTriangles: bool) -> Brep: ...
    def CreateFromOffsetFace(face: BrepFace, offsetDistance: float, offsetTolerance: float, bothSides: bool, createSolid: bool) -> Brep: ...
    def CreateFromRevSurface(surface: RevSurface, capStart: bool, capEnd: bool) -> Brep: ...
    def CreateFromSphere(sphere: Sphere) -> Brep: ...
    def CreateFromSurface(surface: Surface) -> Brep: ...
    @overload
    def CreateFromSweep(rail: Curve, shape: Curve, closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweep(rail: Curve, shapes: Iterable[Curve], closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweep(rail1: Curve, rail2: Curve, shape: Curve, closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweep(rail1: Curve, rail2: Curve, shapes: Iterable[Curve], closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweep(rail1: Curve, rail2: Curve, shapes: Iterable[Curve], start: Point3d, end: Point3d, closed: bool, tolerance: float, rebuild: SweepRebuild, rebuildPointCount: int, refitTolerance: float, preserveHeight: bool) -> Set(Brep): ...
    @overload
    def CreateFromSweep(rail: Curve, shapes: Iterable[Curve], startPoint: Point3d, endPoint: Point3d, frameType: SweepFrame, roadlikeNormal: Vector3d, closed: bool, blendType: SweepBlend, miterType: SweepMiter, tolerance: float, rebuildType: SweepRebuild, rebuildPointCount: int, refitTolerance: float) -> Set(Brep): ...
    def CreateFromSweepInParts(rail1: Curve, rail2: Curve, shapes: Iterable[Curve], rail_params: Iterable[Point2d], closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweepSegmented(rail: Curve, shapes: Iterable[Curve], closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweepSegmented(rail: Curve, shape: Curve, closed: bool, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateFromSweepSegmented(rail: Curve, shapes: Iterable[Curve], startPoint: Point3d, endPoint: Point3d, frameType: SweepFrame, roadlikeNormal: Vector3d, closed: bool, blendType: SweepBlend, miterType: SweepMiter, tolerance: float, rebuildType: SweepRebuild, rebuildPointCount: int, refitTolerance: float) -> Set(Brep): ...
    def CreateFromTaperedExtrude(curveToExtrude: Curve, distance: float, direction: Vector3d, basePoint: Point3d, draftAngleRadians: float, cornerType: ExtrudeCornerType, tolerance: float, angleToleranceRadians: float) -> Set(Brep): ...
    def CreateFromTaperedExtrudeWithRef(curve: Curve, direction: Vector3d, distance: float, draftAngle: float, plane: Plane, tolerance: float) -> Set(Brep): ...
    @overload
    def CreateOffsetBrep(brep: Brep, distance: float, solid: bool, extend: bool, tolerance: float) -> Tuple[Set(Brep), Set(Brep), Set(Brep)]: ...
    @overload
    def CreateOffsetBrep(brep: Brep, distance: float, solid: bool, extend: bool, shrink: bool, tolerance: float) -> Tuple[Set(Brep), Set(Brep), Set(Brep)]: ...
    @overload
    def CreatePatch(geometry: Iterable[GeometryBase], startingSurface: Surface, tolerance: float) -> Brep: ...
    @overload
    def CreatePatch(geometry: Iterable[GeometryBase], uSpans: int, vSpans: int, tolerance: float) -> Brep: ...
    @overload
    def CreatePatch(geometry: Iterable[GeometryBase], startingSurface: Surface, uSpans: int, vSpans: int, trim: bool, tangency: bool, pointSpacing: float, flexibility: float, surfacePull: float, fixEdges: Set(bool), tolerance: float) -> Brep: ...
    @overload
    def CreatePipe(rail: Curve, radius: float, localBlending: bool, cap: PipeCapMode, fitRail: bool, absoluteTolerance: float, angleToleranceRadians: float) -> Set(Brep): ...
    @overload
    def CreatePipe(rail: Curve, railRadiiParameters: Iterable[float], radii: Iterable[float], localBlending: bool, cap: PipeCapMode, fitRail: bool, absoluteTolerance: float, angleToleranceRadians: float) -> Set(Brep): ...
    @overload
    def CreatePlanarBreps(inputLoops: Iterable[Curve], tolerance: float) -> Set(Brep): ...
    @overload
    def CreatePlanarBreps(inputLoop: Curve, tolerance: float) -> Set(Brep): ...
    @overload
    def CreatePlanarBreps(inputLoops: CurveList, tolerance: float) -> Set(Brep): ...
    def CreatePlanarDifference(b0: Brep, b1: Brep, plane: Plane, tolerance: float) -> Set(Brep): ...
    def CreatePlanarIntersection(b0: Brep, b1: Brep, plane: Plane, tolerance: float) -> Set(Brep): ...
    @overload
    def CreatePlanarUnion(breps: Iterable[Brep], plane: Plane, tolerance: float) -> Set(Brep): ...
    @overload
    def CreatePlanarUnion(b0: Brep, b1: Brep, plane: Plane, tolerance: float) -> Set(Brep): ...
    def CreateQuadSphere(sphere: Sphere) -> Brep: ...
    def CreateShell(brep: Brep, facesToRemove: Iterable[int], distance: float, tolerance: float) -> Set(Brep): ...
    def CreateSolid(breps: Iterable[Brep], tolerance: float) -> Set(Brep): ...
    @overload
    def CreateThickPipe(rail: Curve, radius0: float, radius1: float, localBlending: bool, cap: PipeCapMode, fitRail: bool, absoluteTolerance: float, angleToleranceRadians: float) -> Set(Brep): ...
    @overload
    def CreateThickPipe(rail: Curve, railRadiiParameters: Iterable[float], radii0: Iterable[float], radii1: Iterable[float], localBlending: bool, cap: PipeCapMode, fitRail: bool, absoluteTolerance: float, angleToleranceRadians: float) -> Set(Brep): ...
    @overload
    def CreateTrimmedPlane(plane: Plane, curves: Iterable[Curve]) -> Brep: ...
    @overload
    def CreateTrimmedPlane(plane: Plane, curve: Curve) -> Brep: ...
    def CreateTrimmedSurface(trimSource: BrepFace, surfaceSource: Surface, tolerance: float) -> Brep: ...
    def CullUnused2dCurves(self) -> bool: ...
    def CullUnused3dCurves(self) -> bool: ...
    def CullUnusedEdges(self) -> bool: ...
    def CullUnusedFaces(self) -> bool: ...
    def CullUnusedLoops(self) -> bool: ...
    def CullUnusedSurfaces(self) -> bool: ...
    def CullUnusedTrims(self) -> bool: ...
    def CullUnusedVertices(self) -> bool: ...
    def Duplicate(self) -> GeometryBase: ...
    def DuplicateBrep(self) -> Brep: ...
    @overload
    def DuplicateEdgeCurves(self) -> Set(Curve): ...
    @overload
    def DuplicateEdgeCurves(self, nakedOnly: bool) -> Set(Curve): ...
    def DuplicateNakedEdgeCurves(self, outer: bool, inner: bool) -> Set(Curve): ...
    def DuplicateSubBrep(self, faceIndices: Iterable[int]) -> Brep: ...
    def DuplicateVertices(self) -> Set(Point3d): ...
    def FindCoincidentBrepComponents(self, point: Point3d, tolerance: float) -> Tuple[Set(int), Set(int), Set(int)]: ...
    def Flip(self) -> None: ...
    @property
    def Curves2D(self) -> BrepCurveList: ...
    @property
    def Curves3D(self) -> BrepCurveList: ...
    @property
    def Edges(self) -> BrepEdgeList: ...
    @property
    def Faces(self) -> BrepFaceList: ...
    @property
    def IsManifold(self) -> bool: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def IsSurface(self) -> bool: ...
    @property
    def Loops(self) -> BrepLoopList: ...
    @property
    def SolidOrientation(self) -> BrepSolidOrientation: ...
    @property
    def Surfaces(self) -> BrepSurfaceList: ...
    @property
    def Trims(self) -> BrepTrimList: ...
    @property
    def Vertices(self) -> BrepVertexList: ...
    @overload
    def GetArea(self) -> float: ...
    @overload
    def GetArea(self, relativeTolerance: float, absoluteTolerance: float) -> float: ...
    def GetPointInside(self, tolerance: float) -> Tuple[bool, Point3d]: ...
    def GetRegions(self) -> Set(BrepRegion): ...
    @overload
    def GetVolume(self) -> float: ...
    @overload
    def GetVolume(self, relativeTolerance: float, absoluteTolerance: float) -> float: ...
    def GetWireframe(self, density: int) -> Set(Curve): ...
    def IsDuplicate(self, other: Brep, tolerance: float) -> bool: ...
    def IsPointInside(self, point: Point3d, tolerance: float, strictlyIn: bool) -> bool: ...
    def IsValidGeometry(self) -> Tuple[bool, str]: ...
    def IsValidTolerancesAndFlags(self) -> Tuple[bool, str]: ...
    def IsValidTopology(self) -> Tuple[bool, str]: ...
    def Join(self, otherBrep: Brep, tolerance: float, compact: bool) -> bool: ...
    def JoinBreps(brepsToJoin: Iterable[Brep], tolerance: float) -> Set(Brep): ...
    def JoinEdges(self, edgeIndex0: int, edgeIndex1: int, joinTolerance: float, compact: bool) -> bool: ...
    def JoinNakedEdges(self, tolerance: float) -> int: ...
    def MakeValidForV2(self) -> bool: ...
    def MergeBreps(brepsToMerge: Iterable[Brep], tolerance: float) -> Brep: ...
    @overload
    def MergeCoplanarFaces(self, tolerance: float) -> bool: ...
    @overload
    def MergeCoplanarFaces(self, tolerance: float, angleTolerance: float) -> bool: ...
    @overload
    def MergeSurfaces(surface0: Surface, surface1: Surface, tolerance: float, angleToleranceRadians: float) -> Brep: ...
    @overload
    def MergeSurfaces(brep0: Brep, brep1: Brep, tolerance: float, angleToleranceRadians: float) -> Brep: ...
    @overload
    def MergeSurfaces(brep0: Brep, brep1: Brep, tolerance: float, angleToleranceRadians: float, point0: Point2d, point1: Point2d, roundness: float, smooth: bool) -> Brep: ...
    def RebuildTrimsForV2(self, face: BrepFace, nurbsSurface: NurbsSurface) -> None: ...
    def RemoveFins(self) -> bool: ...
    @overload
    def RemoveHoles(self, tolerance: float) -> Brep: ...
    @overload
    def RemoveHoles(self, loops: Iterable[ComponentIndex], tolerance: float) -> Brep: ...
    def Repair(self, tolerance: float) -> bool: ...
    @overload
    def SetTolerancesBoxesAndFlags(self) -> None: ...
    @overload
    def SetTolerancesBoxesAndFlags(self, bLazy: bool, bSetVertexTolerances: bool, bSetEdgeTolerances: bool, bSetTrimTolerances: bool, bSetTrimIsoFlags: bool, bSetTrimTypeFlags: bool, bSetLoopTypeFlags: bool, bSetTrimBoxes: bool) -> None: ...
    def SetTrimIsoFlags(self) -> None: ...
    def SetVertices(self) -> None: ...
    @overload
    def Split(self, cutters: Iterable[Curve], intersectionTolerance: float) -> Set(Brep): ...
    @overload
    def Split(self, cutters: Iterable[Brep], intersectionTolerance: float) -> Set(Brep): ...
    @overload
    def Split(self, cutter: Brep, intersectionTolerance: float) -> Set(Brep): ...
    @overload
    def Split(self, cutter: Brep, intersectionTolerance: float) -> Tuple[Set(Brep), bool]: ...
    @overload
    def Split(self, cutters: Iterable[GeometryBase], normal: Vector3d, planView: bool, intersectionTolerance: float) -> Set(Brep): ...
    def Standardize(self) -> None: ...
    def TransformComponent(self, components: Iterable[ComponentIndex], xform: Transform, tolerance: float, timeLimit: float, useMultipleThreads: bool) -> bool: ...
    @overload
    def Trim(self, cutter: Plane, intersectionTolerance: float) -> Set(Brep): ...
    @overload
    def Trim(self, cutter: Brep, intersectionTolerance: float) -> Set(Brep): ...
    def TryConvertBrep(geometry: GeometryBase) -> Brep: ...
    def UnjoinEdges(self, edgesToUnjoin: Iterable[int]) -> Set(Brep): ...


class BrepEdge(CurveProxy):
    def AdjacentFaces(self) -> Set(int): ...
    def ConcavityAt(self, t: float, tolerance: float) -> Concavity: ...
    @property
    def Brep(self) -> Brep: ...
    @property
    def EdgeCurve(self) -> Curve: ...
    @property
    def EdgeCurveIndex(self) -> int: ...
    @property
    def EdgeIndex(self) -> int: ...
    @property
    def EndVertex(self) -> BrepVertex: ...
    @property
    def StartVertex(self) -> BrepVertex: ...
    @property
    def Tolerance(self) -> float: ...
    @property
    def TrimCount(self) -> int: ...
    @property
    def Valence(self) -> EdgeAdjacency: ...
    def GetEdgeParameter(self, trimIndex: int, trimParameter: float) -> Tuple[bool, float]: ...
    def IsSmoothManifoldEdge(self, angleToleranceRadians: float) -> bool: ...
    @Tolerance.setter
    def Tolerance(self, value: float) -> None: ...
    @overload
    def SetEdgeCurve(self, curve3dIndex: int) -> bool: ...
    @overload
    def SetEdgeCurve(self, curve3dIndex: int, subDomain: Interval) -> bool: ...
    def TrimIndices(self) -> Set(int): ...


class BrepFace(SurfaceProxy):
    def AdjacentEdges(self) -> Set(int): ...
    def AdjacentFaces(self) -> Set(int): ...
    def ChangeSurface(self, surfaceIndex: int) -> bool: ...
    def ClearMaterialChannelIndex(self) -> None: ...
    def CreateExtrusion(self, pathCurve: Curve, cap: bool) -> Brep: ...
    def DraftAnglePoint(self, testPoint: Point2d, testAngle: float, pullDirection: Vector3d, edge: bool) -> Tuple[bool, Point3d, float]: ...
    def DuplicateFace(self, duplicateMeshes: bool) -> Brep: ...
    def DuplicateSurface(self) -> Surface: ...
    @property
    def Brep(self) -> Brep: ...
    @property
    def FaceIndex(self) -> int: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IsSurface(self) -> bool: ...
    @property
    def Loops(self) -> BrepLoopList: ...
    @property
    def MaterialChannelIndex(self) -> int: ...
    @property
    def OrientationIsReversed(self) -> bool: ...
    @property
    def OuterLoop(self) -> BrepLoop: ...
    @property
    def PerFaceColor(self) -> Color: ...
    @property
    def SurfaceIndex(self) -> int: ...
    def GetMesh(self, meshType: MeshType) -> Mesh: ...
    @overload
    def IsPointOnFace(self, u: float, v: float) -> PointFaceRelation: ...
    @overload
    def IsPointOnFace(self, u: float, v: float, tolerance: float) -> PointFaceRelation: ...
    def PullPointsToFace(self, points: Iterable[Point3d], tolerance: float) -> Set(Point3d): ...
    def RebuildEdges(self, tolerance: float, rebuildSharedEdges: bool, rebuildVertices: bool) -> bool: ...
    def RefitTrim(self, edge: BrepEdge, knots: Iterable[float], tolerance: float, bSections: bool, fitQuality: float) -> Tuple[Set(Surface), float]: ...
    def RemoveHoles(self, tolerance: float) -> Brep: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @MaterialChannelIndex.setter
    def MaterialChannelIndex(self, value: int) -> None: ...
    @OrientationIsReversed.setter
    def OrientationIsReversed(self, value: bool) -> None: ...
    @PerFaceColor.setter
    def PerFaceColor(self, value: Color) -> None: ...
    def SetDomain(self, direction: int, domain: Interval) -> bool: ...
    def SetMesh(self, meshType: MeshType, mesh: Mesh) -> bool: ...
    def ShrinkFace(self, disableSide: ShrinkDisableSide) -> bool: ...
    def ShrinkSurfaceToEdge(self) -> bool: ...
    @overload
    def Split(self, curves: Iterable[Curve], tolerance: float) -> Brep: ...
    def TrimAwareIsoCurve(self, direction: int, constantParameter: float) -> Set(Curve): ...
    def TrimAwareIsoIntervals(self, direction: int, constantParameter: float) -> Set(Interval): ...
    def UnderlyingSurface(self) -> Surface: ...


class BrepLoop(GeometryBase):
    @property
    def Brep(self) -> Brep: ...
    @property
    def Face(self) -> BrepFace: ...
    @property
    def LoopIndex(self) -> int: ...
    @property
    def LoopType(self) -> BrepLoopType: ...
    @property
    def Trims(self) -> BrepTrimList: ...
    def To2dCurve(self) -> Curve: ...
    def To3dCurve(self) -> Curve: ...


class BrepLoopType:
    Unknown = 0
    Outer = 1
    Inner = 2
    Slit = 3
    CurveOnSurface = 4
    PointOnSurface = 5


class BrepRegion(CommonObject):
    def BoundaryBrep(self) -> Brep: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def Brep(self) -> Brep: ...
    @property
    def Index(self) -> int: ...
    @property
    def IsFinite(self) -> bool: ...
    def GetFaceSides(self) -> Set(BrepRegionFaceSide): ...


class BrepRegionFaceSide(CommonObject):
    @property
    def Brep(self) -> Brep: ...
    @property
    def Face(self) -> BrepFace: ...
    @property
    def Region(self) -> BrepRegion: ...
    @property
    def SurfaceNormalPointsIntoRegion(self) -> bool: ...


class BrepSolidOrientation:
    #None = 0
    Outward = 1
    Unknown = 2
    Inward = -1


class BrepTrim(CurveProxy):
    @property
    def Brep(self) -> Brep: ...
    @property
    def Edge(self) -> BrepEdge: ...
    @property
    def EndVertex(self) -> BrepVertex: ...
    @property
    def Face(self) -> BrepFace: ...
    @property
    def IsoStatus(self) -> IsoStatus: ...
    @property
    def Loop(self) -> BrepLoop: ...
    @property
    def StartVertex(self) -> BrepVertex: ...
    @property
    def TrimCurve(self) -> Curve: ...
    @property
    def TrimCurveIndex(self) -> int: ...
    @property
    def TrimIndex(self) -> int: ...
    @property
    def TrimType(self) -> BrepTrimType: ...
    def GetTolerances(self) -> Tuple[float, float]: ...
    def GetTrimParameter(self, edgeParameter: float) -> Tuple[bool, float]: ...
    def IsReversed(self) -> bool: ...
    @IsoStatus.setter
    def IsoStatus(self, value: IsoStatus) -> None: ...
    @TrimType.setter
    def TrimType(self, value: BrepTrimType) -> None: ...
    def SetTolerances(self, toleranceU: float, toleranceV: float) -> None: ...
    @overload
    def SetTrimCurve(self, curve2dIndex: int) -> bool: ...
    @overload
    def SetTrimCurve(self, curve2dIndex: int, subDomain: Interval) -> bool: ...


class BrepTrimType:
    Unknown = 0
    Boundary = 1
    Mated = 2
    Seam = 3
    Singular = 4
    CurveOnSurface = 5
    PointOnSurface = 6
    Slit = 7


class BrepVertex(Point):
    def EdgeIndices(self) -> Set(int): ...
    @property
    def Brep(self) -> Brep: ...
    @property
    def VertexIndex(self) -> int: ...


class Centermark(Dimension):
    def __init__(self): ...
    def Create(dimStyle: DimensionStyle, plane: Plane, centerpoint: Point3d, radius: float) -> Centermark: ...


class Circle:
    @overload
    def __init__(self, radius: float): ...
    @overload
    def __init__(self, arc: Arc): ...
    @overload
    def __init__(self, plane: Plane, radius: float): ...
    @overload
    def __init__(self, center: Point3d, radius: float): ...
    @overload
    def __init__(self, point1: Point3d, point2: Point3d, point3: Point3d): ...
    @overload
    def __init__(self, plane: Plane, center: Point3d, radius: float): ...
    @overload
    def __init__(self, startPoint: Point3d, tangentAtP: Vector3d, pointOnCircle: Point3d): ...
    def ClosestParameter(self, testPoint: Point3d) -> Tuple[bool, float]: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def DerivativeAt(self, derivative: int, t: float) -> Vector3d: ...
    def EpsilonEquals(self, other: Circle, epsilon: float) -> bool: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Circumference(self) -> float: ...
    @property
    def Diameter(self) -> float: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Normal(self) -> Vector3d: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Radius(self) -> float: ...
    @property
    def Unset() -> Circle: ...
    def IsInPlane(self, plane: Plane, tolerance: float) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...
    def Reverse(self) -> None: ...
    @overload
    def Rotate(self, angle: float, axis: Vector3d) -> bool: ...
    @overload
    def Rotate(self, angle: float, axis: Vector3d, point: Point3d) -> bool: ...
    @overload
    def Rotate(self, sinAngle: float, cosAngle: float, axis: Vector3d) -> bool: ...
    @overload
    def Rotate(self, sinAngle: float, cosAngle: float, axis: Vector3d, point: Point3d) -> bool: ...
    @Center.setter
    def Center(self, value: Point3d) -> None: ...
    @Circumference.setter
    def Circumference(self, value: float) -> None: ...
    @Diameter.setter
    def Diameter(self, value: float) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    @overload
    def ToNurbsCurve(self) -> NurbsCurve: ...
    @overload
    def ToNurbsCurve(self, degree: int, cvCount: int) -> NurbsCurve: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Translate(self, delta: Vector3d) -> bool: ...
    def TryFitCircleToPoints(points: Iterable[Point3d]) -> Tuple[bool, Circle]: ...
    def TryFitCircleTT(c1: Curve, c2: Curve, t1: float, t2: float) -> Circle: ...
    def TryFitCircleTTT(c1: Curve, c2: Curve, c3: Curve, t1: float, t2: float, t3: float) -> Circle: ...


class ClippingPlaneSurface(PlaneSurface):
    def AddClipViewportId(self, viewportId: Guid) -> bool: ...
    @property
    def Plane(self) -> Plane: ...
    def RemoveClipViewportId(self, viewportId: Guid) -> bool: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    def ViewportIds(self) -> Set(Guid): ...


class ComponentIndex:
    def __init__(self, type: ComponentIndexType, index: int): ...
    @property
    def ComponentIndexType(self) -> ComponentIndexType: ...
    @property
    def Index(self) -> int: ...
    @property
    def Unset() -> ComponentIndex: ...
    def IsUnset(self) -> bool: ...


class ComponentIndexType:
    InvalidType = 0
    BrepVertex = 1
    BrepEdge = 2
    BrepFace = 3
    BrepTrim = 4
    BrepLoop = 5
    MeshVertex = 11
    MeshTopologyVertex = 12
    MeshTopologyEdge = 13
    MeshFace = 14
    MeshNgon = 15
    InstanceDefinitionPart = 21
    PolycurveSegment = 31
    PointCloudPoint = 41
    GroupMember = 51
    ExtrusionBottomProfile = 61
    ExtrusionTopProfile = 62
    ExtrusionWallEdge = 63
    ExtrusionWallSurface = 64
    ExtrusionCapSurface = 65
    ExtrusionPath = 66
    SubdVertex = 71
    SubdEdge = 72
    SubdFace = 73
    DimLinearPoint = 100
    DimRadialPoint = 101
    DimAngularPoint = 102
    DimOrdinatePoint = 103
    DimTextPoint = 104
    NoType = 268435455


class ComponentStatus:
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, other: ComponentStatus) -> bool: ...
    @property
    def AllSet() -> ComponentStatus: ...
    @property
    def Clear() -> ComponentStatus: ...
    @property
    def Damaged() -> ComponentStatus: ...
    @property
    def Hidden() -> ComponentStatus: ...
    @property
    def Highlighted() -> ComponentStatus: ...
    @property
    def IsClear(self) -> bool: ...
    @property
    def IsDamaged(self) -> bool: ...
    @property
    def IsHidden(self) -> bool: ...
    @property
    def IsHighlighted(self) -> bool: ...
    @property
    def IsLocked(self) -> bool: ...
    @property
    def IsSelected(self) -> bool: ...
    @property
    def IsSelectedPersistent(self) -> bool: ...
    @property
    def Locked() -> ComponentStatus: ...
    @property
    def Selected() -> ComponentStatus: ...
    @property
    def SelectedPersistent() -> ComponentStatus: ...
    def GetHashCode(self) -> int: ...
    def HasAllEqualStates(self, statesFilter: ComponentStatus, comparand: ComponentStatus) -> bool: ...
    def HasNoEqualStates(self, statesFilter: ComponentStatus, comparand: ComponentStatus) -> bool: ...
    def HasSomeEqualStates(self, statesFilter: ComponentStatus, comparand: ComponentStatus) -> bool: ...
    def op_Addition(a: ComponentStatus, b: ComponentStatus) -> ComponentStatus: ...
    def op_Equality(a: ComponentStatus, b: ComponentStatus) -> bool: ...
    def op_Inequality(a: ComponentStatus, b: ComponentStatus) -> bool: ...
    def ToString(self) -> str: ...
    def WithStates(self, additionalStatus: ComponentStatus) -> ComponentStatus: ...


class ConcaveCornerOption:
    Unset = 0
    #None = 1
    AtMeshCorner = 2


class Concavity:
    Tangent = 0
    Convex = 1
    Concave = 2
    #None = -1


class Cone:
    def __init__(self, plane: Plane, height: float, radius: float): ...
    def AngleInDegrees(self) -> float: ...
    def AngleInRadians(self) -> float: ...
    def EpsilonEquals(self, other: Cone, epsilon: float) -> bool: ...
    @property
    def ApexPoint(self) -> Point3d: ...
    @property
    def Axis(self) -> Vector3d: ...
    @property
    def BasePoint(self) -> Point3d: ...
    @property
    def Height(self) -> float: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Radius(self) -> float: ...
    @property
    def Unset() -> Cone: ...
    @Height.setter
    def Height(self, value: float) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def ToBrep(self, capBottom: bool) -> Brep: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def ToRevSurface(self) -> RevSurface: ...


class ConicSectionType:
    Unknown = 0
    Circle = 1
    Ellipse = 2
    Hyperbola = 3
    Parabola = 4


class Continuity:
    #None = 0
    C0_continuous = 1
    C1_continuous = 2
    C2_continuous = 3
    G1_continuous = 4
    G2_continuous = 5
    C0_locus_continuous = 6
    C1_locus_continuous = 7
    C2_locus_continuous = 8
    G1_locus_continuous = 9
    G2_locus_continuous = 10
    Cinfinity_continuous = 11
    Gsmooth_continuous = 12


class ControlPoint:
    @overload
    def __init__(self, pt: Point3d): ...
    @overload
    def __init__(self, pt: Point4d): ...
    @overload
    def __init__(self, euclideanPt: Point3d, weight: float): ...
    @overload
    def __init__(self, x: float, y: float, z: float): ...
    @overload
    def __init__(self, x: float, y: float, z: float, weight: float): ...
    def EpsilonEquals(self, other: ControlPoint, epsilon: float) -> bool: ...
    @overload
    def Equals(self, other: ControlPoint) -> bool: ...
    @property
    def Location(self) -> Point3d: ...
    @property
    def Unset() -> ControlPoint: ...
    @property
    def Weight(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @Location.setter
    def Location(self, value: Point3d) -> None: ...
    @Weight.setter
    def Weight(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...


class ConvexCornerOption:
    Unset = 0
    #None = 1
    AtMeshCorner = 2


class Curve(GeometryBase):
    def ChangeClosedCurveSeam(self, t: float) -> bool: ...
    def ChangeDimension(self, desiredDimension: int) -> bool: ...
    @overload
    def ClosedCurveOrientation(self) -> CurveOrientation: ...
    @overload
    def ClosedCurveOrientation(self, upDirection: Vector3d) -> CurveOrientation: ...
    @overload
    def ClosedCurveOrientation(self, plane: Plane) -> CurveOrientation: ...
    @overload
    def ClosedCurveOrientation(self, xform: Transform) -> CurveOrientation: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d) -> Tuple[bool, float]: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d, maximumDistance: float) -> Tuple[bool, float]: ...
    @overload
    def ClosestPoints(self, otherCurve: Curve) -> Tuple[bool, Point3d, Point3d]: ...
    @overload
    def ClosestPoints(self, geometry: Iterable[GeometryBase]) -> Tuple[bool, Point3d, Point3d, int]: ...
    @overload
    def ClosestPoints(self, geometry: Iterable[GeometryBase], maximumDistance: float) -> Tuple[bool, Point3d, Point3d, int]: ...
    def Contains(self, testPoint: Point3d, plane: Plane, tolerance: float) -> PointContainment: ...
    def CreateArcBlend(startPt: Point3d, startDir: Vector3d, endPt: Point3d, endDir: Vector3d, controlPointLengthRatio: float) -> Curve: ...
    @overload
    def CreateBlendCurve(curveA: Curve, curveB: Curve, continuity: BlendContinuity) -> Curve: ...
    @overload
    def CreateBlendCurve(curveA: Curve, curveB: Curve, continuity: BlendContinuity, bulgeA: float, bulgeB: float) -> Curve: ...
    @overload
    def CreateBlendCurve(curve0: Curve, t0: float, reverse0: bool, continuity0: BlendContinuity, curve1: Curve, t1: float, reverse1: bool, continuity1: BlendContinuity) -> Curve: ...
    @overload
    def CreateBooleanDifference(curveA: Curve, subtractors: Iterable[Curve], tolerance: float) -> Set(Curve): ...
    @overload
    def CreateBooleanDifference(curveA: Curve, curveB: Curve, tolerance: float) -> Set(Curve): ...
    def CreateBooleanIntersection(curveA: Curve, curveB: Curve, tolerance: float) -> Set(Curve): ...
    @overload
    def CreateBooleanRegions(curves: Iterable[Curve], plane: Plane, combineRegions: bool, tolerance: float) -> CurveBooleanRegions: ...
    @overload
    def CreateBooleanRegions(curves: Iterable[Curve], plane: Plane, points: Iterable[Point3d], combineRegions: bool, tolerance: float) -> CurveBooleanRegions: ...
    def CreateBooleanUnion(curves: Iterable[Curve], tolerance: float) -> Set(Curve): ...
    @overload
    def CreateControlPointCurve(points: Iterable[Point3d]) -> Curve: ...
    @overload
    def CreateControlPointCurve(points: Iterable[Point3d], degree: int) -> Curve: ...
    def CreateCurve2View(curveA: Curve, curveB: Curve, vectorA: Vector3d, vectorB: Vector3d, tolerance: float, angleTolerance: float) -> Set(Curve): ...
    def CreateFillet(curve0: Curve, curve1: Curve, radius: float, t0Base: float, t1Base: float) -> Arc: ...
    def CreateFilletCornersCurve(curve: Curve, radius: float, tolerance: float, angleTolerance: float) -> Curve: ...
    def CreateFilletCurves(curve0: Curve, point0: Point3d, curve1: Curve, point1: Point3d, radius: float, join: bool, trim: bool, arcExtension: bool, tolerance: float, angleTolerance: float) -> Set(Curve): ...
    @overload
    def CreateInterpolatedCurve(points: Iterable[Point3d], degree: int) -> Curve: ...
    @overload
    def CreateInterpolatedCurve(points: Iterable[Point3d], degree: int, knots: CurveKnotStyle) -> Curve: ...
    @overload
    def CreateInterpolatedCurve(points: Iterable[Point3d], degree: int, knots: CurveKnotStyle, startTangent: Vector3d, endTangent: Vector3d) -> Curve: ...
    def CreateMatchCurve(curve0: Curve, reverse0: bool, continuity: BlendContinuity, curve1: Curve, reverse1: bool, preserve: PreserveEnd, average: bool) -> Set(Curve): ...
    @overload
    def CreateMeanCurve(curveA: Curve, curveB: Curve) -> Curve: ...
    @overload
    def CreateMeanCurve(curveA: Curve, curveB: Curve, angleToleranceRadians: float) -> Curve: ...
    @overload
    def CreatePeriodicCurve(curve: Curve) -> Curve: ...
    @overload
    def CreatePeriodicCurve(curve: Curve, smooth: bool) -> Curve: ...
    def CreateSoftEditCurve(curve: Curve, t: float, delta: Vector3d, length: float, fixEnds: bool) -> Curve: ...
    def CreateTextOutlines(text: str, font: str, textHeight: float, textStyle: int, closeLoops: bool, plane: Plane, smallCapsScale: float, tolerance: float) -> Set(Curve): ...
    def CreateTweenCurves(curve0: Curve, curve1: Curve, numCurves: int, tolerance: float) -> Set(Curve): ...
    def CreateTweenCurvesWithMatching(curve0: Curve, curve1: Curve, numCurves: int, tolerance: float) -> Set(Curve): ...
    def CreateTweenCurvesWithSampling(curve0: Curve, curve1: Curve, numCurves: int, numSamples: int, tolerance: float) -> Set(Curve): ...
    def CurvatureAt(self, t: float) -> Vector3d: ...
    @overload
    def DerivativeAt(self, t: float, derivativeCount: int) -> Set(Vector3d): ...
    @overload
    def DerivativeAt(self, t: float, derivativeCount: int, side: CurveEvaluationSide) -> Set(Vector3d): ...
    def DivideAsContour(self, contourStart: Point3d, contourEnd: Point3d, interval: float) -> Set(Point3d): ...
    @overload
    def DivideByCount(self, segmentCount: int, includeEnds: bool) -> Set(float): ...
    @overload
    def DivideByCount(self, segmentCount: int, includeEnds: bool) -> Tuple[Set(float), Set(Point3d)]: ...
    @overload
    def DivideByLength(self, segmentLength: float, includeEnds: bool) -> Set(float): ...
    @overload
    def DivideByLength(self, segmentLength: float, includeEnds: bool) -> Tuple[Set(float), Set(Point3d)]: ...
    @overload
    def DivideByLength(self, segmentLength: float, includeEnds: bool, reverse: bool) -> Set(float): ...
    @overload
    def DivideByLength(self, segmentLength: float, includeEnds: bool, reverse: bool) -> Tuple[Set(float), Set(Point3d)]: ...
    def DivideEquidistant(self, distance: float) -> Set(Point3d): ...
    def DoDirectionsMatch(curveA: Curve, curveB: Curve) -> bool: ...
    def Duplicate(self) -> GeometryBase: ...
    def DuplicateCurve(self) -> Curve: ...
    def DuplicateSegments(self) -> Set(Curve): ...
    @overload
    def Extend(self, domain: Interval) -> Curve: ...
    @overload
    def Extend(self, t0: float, t1: float) -> Curve: ...
    @overload
    def Extend(self, side: CurveEnd, style: CurveExtensionStyle, endPoint: Point3d) -> Curve: ...
    @overload
    def Extend(self, side: CurveEnd, length: float, style: CurveExtensionStyle) -> Curve: ...
    @overload
    def Extend(self, side: CurveEnd, style: CurveExtensionStyle, geometry: Iterable[GeometryBase]) -> Curve: ...
    def ExtendByArc(self, side: CurveEnd, geometry: Iterable[GeometryBase]) -> Curve: ...
    def ExtendByLine(self, side: CurveEnd, geometry: Iterable[GeometryBase]) -> Curve: ...
    @overload
    def ExtendOnSurface(self, side: CurveEnd, surface: Surface) -> Curve: ...
    @overload
    def ExtendOnSurface(self, side: CurveEnd, face: BrepFace) -> Curve: ...
    def ExtremeParameters(self, direction: Vector3d) -> Set(float): ...
    def Fair(self, distanceTolerance: float, angleTolerance: float, clampStart: int, clampEnd: int, iterations: int) -> Curve: ...
    def Fit(self, degree: int, fitTolerance: float, angleTolerance: float) -> Curve: ...
    def FrameAt(self, t: float) -> Tuple[bool, Plane]: ...
    @property
    def Degree(self) -> int: ...
    @property
    def Dimension(self) -> int: ...
    @property
    def Domain(self) -> Interval: ...
    @property
    def IsClosed(self) -> bool: ...
    @property
    def IsPeriodic(self) -> bool: ...
    @property
    def IsSubDFriendly(self) -> bool: ...
    @property
    def PointAtEnd(self) -> Point3d: ...
    @property
    def PointAtStart(self) -> Point3d: ...
    @property
    def SpanCount(self) -> int: ...
    @property
    def TangentAtEnd(self) -> Vector3d: ...
    @property
    def TangentAtStart(self) -> Vector3d: ...
    @overload
    def GetConicSectionType(self) -> ConicSectionType: ...
    @overload
    def GetConicSectionType(self) -> Tuple[ConicSectionType, Point3d, Point3d, Point3d]: ...
    def GetCurveParameterFromNurbsFormParameter(self, nurbsParameter: float) -> Tuple[bool, float]: ...
    def GetDistancesBetweenCurves(curveA: Curve, curveB: Curve, tolerance: float) -> Tuple[bool, float, float, float, float, float, float]: ...
    def GetFilletPoints(curve0: Curve, curve1: Curve, radius: float, t0Base: float, t1Base: float) -> Tuple[bool, float, float, Plane]: ...
    @overload
    def GetLength(self) -> float: ...
    @overload
    def GetLength(self, fractionalTolerance: float) -> float: ...
    @overload
    def GetLength(self, subdomain: Interval) -> float: ...
    @overload
    def GetLength(self, fractionalTolerance: float, subdomain: Interval) -> float: ...
    @overload
    def GetLocalPerpPoint(self, testPoint: Point3d, seedParmameter: float) -> Tuple[bool, float]: ...
    @overload
    def GetLocalPerpPoint(self, testPoint: Point3d, seedParmameter: float, subDomain: Interval) -> Tuple[bool, float]: ...
    @overload
    def GetLocalTangentPoint(self, testPoint: Point3d, seedParmameter: float) -> Tuple[bool, float]: ...
    @overload
    def GetLocalTangentPoint(self, testPoint: Point3d, seedParmameter: float, subDomain: Interval) -> Tuple[bool, float]: ...
    @overload
    def GetNextDiscontinuity(self, continuityType: Continuity, t0: float, t1: float) -> Tuple[bool, float]: ...
    @overload
    def GetNextDiscontinuity(self, continuityType: Continuity, t0: float, t1: float, cosAngleTolerance: float, curvatureTolerance: float) -> Tuple[bool, float]: ...
    def GetNurbsFormParameterFromCurveParameter(self, curveParameter: float) -> Tuple[bool, float]: ...
    def GetPerpendicularFrames(self, parameters: Iterable[float]) -> Set(Plane): ...
    def HasNurbsForm(self) -> int: ...
    def InflectionPoints(self) -> Set(Point3d): ...
    @overload
    def IsArc(self) -> bool: ...
    @overload
    def IsArc(self, tolerance: float) -> bool: ...
    @overload
    def IsCircle(self) -> bool: ...
    @overload
    def IsCircle(self, tolerance: float) -> bool: ...
    @overload
    def IsClosable(self, tolerance: float) -> bool: ...
    @overload
    def IsClosable(self, tolerance: float, minimumAbsoluteSize: float, minimumRelativeSize: float) -> bool: ...
    def IsContinuous(self, continuityType: Continuity, t: float) -> bool: ...
    @overload
    def IsEllipse(self) -> bool: ...
    @overload
    def IsEllipse(self, tolerance: float) -> bool: ...
    @overload
    def IsInPlane(self, testPlane: Plane) -> bool: ...
    @overload
    def IsInPlane(self, testPlane: Plane, tolerance: float) -> bool: ...
    @overload
    def IsLinear(self) -> bool: ...
    @overload
    def IsLinear(self, tolerance: float) -> bool: ...
    @overload
    def IsPlanar(self) -> bool: ...
    @overload
    def IsPlanar(self, tolerance: float) -> bool: ...
    def IsPolyline(self) -> bool: ...
    @overload
    def IsShort(self, tolerance: float) -> bool: ...
    @overload
    def IsShort(self, tolerance: float, subdomain: Interval) -> bool: ...
    @overload
    def JoinCurves(inputCurves: Iterable[Curve]) -> Set(Curve): ...
    @overload
    def JoinCurves(inputCurves: Iterable[Curve], joinTolerance: float) -> Set(Curve): ...
    @overload
    def JoinCurves(inputCurves: Iterable[Curve], joinTolerance: float, preserveDirection: bool) -> Set(Curve): ...
    @overload
    def LengthParameter(self, segmentLength: float) -> Tuple[bool, float]: ...
    @overload
    def LengthParameter(self, segmentLength: float, fractionalTolerance: float) -> Tuple[bool, float]: ...
    @overload
    def LengthParameter(self, segmentLength: float, subdomain: Interval) -> Tuple[bool, float]: ...
    @overload
    def LengthParameter(self, segmentLength: float, fractionalTolerance: float, subdomain: Interval) -> Tuple[bool, float]: ...
    def LocalClosestPoint(self, testPoint: Point3d, seed: float) -> Tuple[bool, float]: ...
    def MakeClosed(self, tolerance: float) -> bool: ...
    def MakeEndsMeet(curveA: Curve, adjustStartCurveA: bool, curveB: Curve, adjustStartCurveB: bool) -> bool: ...
    def MaxCurvaturePoints(self) -> Set(Point3d): ...
    @overload
    def NormalizedLengthParameter(self, s: float) -> Tuple[bool, float]: ...
    @overload
    def NormalizedLengthParameter(self, s: float, subdomain: Interval) -> Tuple[bool, float]: ...
    @overload
    def NormalizedLengthParameter(self, s: float, fractionalTolerance: float) -> Tuple[bool, float]: ...
    @overload
    def NormalizedLengthParameter(self, s: float, fractionalTolerance: float, subdomain: Interval) -> Tuple[bool, float]: ...
    @overload
    def NormalizedLengthParameters(self, s: Set(float), absoluteTolerance: float) -> Set(float): ...
    @overload
    def NormalizedLengthParameters(self, s: Set(float), absoluteTolerance: float, fractionalTolerance: float) -> Set(float): ...
    @overload
    def NormalizedLengthParameters(self, s: Set(float), absoluteTolerance: float, subdomain: Interval) -> Set(float): ...
    @overload
    def NormalizedLengthParameters(self, s: Set(float), absoluteTolerance: float, fractionalTolerance: float, subdomain: Interval) -> Set(float): ...
    @overload
    def Offset(self, plane: Plane, distance: float, tolerance: float, cornerStyle: CurveOffsetCornerStyle) -> Set(Curve): ...
    @overload
    def Offset(self, directionPoint: Point3d, normal: Vector3d, distance: float, tolerance: float, cornerStyle: CurveOffsetCornerStyle) -> Set(Curve): ...
    @overload
    def Offset(self, directionPoint: Point3d, normal: Vector3d, distance: float, tolerance: float, angleTolerance: float, loose: bool, cornerStyle: CurveOffsetCornerStyle, endStyle: CurveOffsetEndStyle) -> Set(Curve): ...
    def OffsetNormalToSurface(self, surface: Surface, height: float) -> Curve: ...
    @overload
    def OffsetOnSurface(self, face: BrepFace, throughPoint: Point2d, fittingTolerance: float) -> Set(Curve): ...
    @overload
    def OffsetOnSurface(self, face: BrepFace, distance: float, fittingTolerance: float) -> Set(Curve): ...
    @overload
    def OffsetOnSurface(self, surface: Surface, throughPoint: Point2d, fittingTolerance: float) -> Set(Curve): ...
    @overload
    def OffsetOnSurface(self, surface: Surface, distance: float, fittingTolerance: float) -> Set(Curve): ...
    @overload
    def OffsetOnSurface(self, face: BrepFace, curveParameters: Set(float), offsetDistances: Set(float), fittingTolerance: float) -> Set(Curve): ...
    @overload
    def OffsetOnSurface(self, surface: Surface, curveParameters: Set(float), offsetDistances: Set(float), fittingTolerance: float) -> Set(Curve): ...
    def PerpendicularFrameAt(self, t: float) -> Tuple[bool, Plane]: ...
    def PlanarClosedCurveRelationship(curveA: Curve, curveB: Curve, testPlane: Plane, tolerance: float) -> RegionContainment: ...
    def PlanarCurveCollision(curveA: Curve, curveB: Curve, testPlane: Plane, tolerance: float) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...
    def PointAtLength(self, length: float) -> Point3d: ...
    def PointAtNormalizedLength(self, length: float) -> Point3d: ...
    @overload
    def ProjectToBrep(curve: Curve, breps: Iterable[Brep], direction: Vector3d, tolerance: float) -> Set(Curve): ...
    @overload
    def ProjectToBrep(curves: Iterable[Curve], breps: Iterable[Brep], direction: Vector3d, tolerance: float) -> Set(Curve): ...
    @overload
    def ProjectToBrep(curve: Curve, brep: Brep, direction: Vector3d, tolerance: float) -> Set(Curve): ...
    @overload
    def ProjectToBrep(curve: Curve, breps: Iterable[Brep], direction: Vector3d, tolerance: float) -> Tuple[Set(Curve), Set(int)]: ...
    @overload
    def ProjectToBrep(curves: Iterable[Curve], breps: Iterable[Brep], direction: Vector3d, tolerance: float) -> Tuple[Set(Curve), Set(int), Set(int)]: ...
    @overload
    def ProjectToMesh(curves: Iterable[Curve], meshes: Iterable[Mesh], direction: Vector3d, tolerance: float) -> Set(Curve): ...
    @overload
    def ProjectToMesh(curve: Curve, meshes: Iterable[Mesh], direction: Vector3d, tolerance: float) -> Set(Curve): ...
    @overload
    def ProjectToMesh(curve: Curve, mesh: Mesh, direction: Vector3d, tolerance: float) -> Set(Curve): ...
    def ProjectToPlane(curve: Curve, plane: Plane) -> Curve: ...
    @overload
    def PullToBrepFace(self, face: BrepFace, tolerance: float) -> Set(Curve): ...
    @overload
    def PullToBrepFace(curve: Curve, face: BrepFace, tolerance: float) -> Set(Curve): ...
    def PullToMesh(self, mesh: Mesh, tolerance: float) -> PolylineCurve: ...
    def Rebuild(self, pointCount: int, degree: int, preserveTangents: bool) -> NurbsCurve: ...
    def RemoveShortSegments(self, tolerance: float) -> bool: ...
    def Reverse(self) -> bool: ...
    @overload
    def RibbonOffset(self, distance: float, blendRadius: float, directionPoint: Point3d, normal: Vector3d, tolerance: float) -> Curve: ...
    @overload
    def RibbonOffset(self, distance: float, blendRadius: float, directionPoint: Point3d, normal: Vector3d, tolerance: float) -> Tuple[Curve, Set(float), Set(float)]: ...
    @overload
    def RibbonOffset(self, distance: float, blendRadius: float, directionPoint: Point3d, normal: Vector3d, tolerance: float) -> Tuple[Curve, Set(Curve), Set(Surface)]: ...
    @Domain.setter
    def Domain(self, value: Interval) -> None: ...
    def SetEndPoint(self, point: Point3d) -> bool: ...
    def SetStartPoint(self, point: Point3d) -> bool: ...
    def Simplify(self, options: CurveSimplifyOptions, distanceTolerance: float, angleToleranceRadians: float) -> Curve: ...
    def SimplifyEnd(self, end: CurveEnd, options: CurveSimplifyOptions, distanceTolerance: float, angleToleranceRadians: float) -> Curve: ...
    @overload
    def Smooth(self, smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem) -> Curve: ...
    @overload
    def Smooth(self, smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem, plane: Plane) -> Curve: ...
    def SpanDomain(self, spanIndex: int) -> Interval: ...
    @overload
    def Split(self, t: float) -> Set(Curve): ...
    @overload
    def Split(self, t: Iterable[float]) -> Set(Curve): ...
    @overload
    def Split(self, cutter: Surface, tolerance: float, angleToleranceRadians: float) -> Set(Curve): ...
    @overload
    def Split(self, cutter: Brep, tolerance: float, angleToleranceRadians: float) -> Set(Curve): ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def ToArcsAndLines(self, tolerance: float, angleTolerance: float, minimumLength: float, maximumLength: float) -> PolyCurve: ...
    @overload
    def ToNurbsCurve(self) -> NurbsCurve: ...
    @overload
    def ToNurbsCurve(self, subdomain: Interval) -> NurbsCurve: ...
    @overload
    def ToPolyline(self, tolerance: float, angleTolerance: float, minimumLength: float, maximumLength: float) -> PolylineCurve: ...
    @overload
    def ToPolyline(self, mainSegmentCount: int, subSegmentCount: int, maxAngleRadians: float, maxChordLengthRatio: float, maxAspectRatio: float, tolerance: float, minEdgeLength: float, maxEdgeLength: float, keepStartPoint: bool) -> PolylineCurve: ...
    @overload
    def ToPolyline(self, mainSegmentCount: int, subSegmentCount: int, maxAngleRadians: float, maxChordLengthRatio: float, maxAspectRatio: float, tolerance: float, minEdgeLength: float, maxEdgeLength: float, keepStartPoint: bool, curveDomain: Interval) -> PolylineCurve: ...
    @overload
    def Trim(self, domain: Interval) -> Curve: ...
    @overload
    def Trim(self, t0: float, t1: float) -> Curve: ...
    @overload
    def Trim(self, side: CurveEnd, length: float) -> Curve: ...
    @overload
    def TryGetArc(self) -> Tuple[bool, Arc]: ...
    @overload
    def TryGetArc(self, tolerance: float) -> Tuple[bool, Arc]: ...
    @overload
    def TryGetArc(self, plane: Plane) -> Tuple[bool, Arc]: ...
    @overload
    def TryGetArc(self, plane: Plane, tolerance: float) -> Tuple[bool, Arc]: ...
    @overload
    def TryGetCircle(self) -> Tuple[bool, Circle]: ...
    @overload
    def TryGetCircle(self, tolerance: float) -> Tuple[bool, Circle]: ...
    @overload
    def TryGetEllipse(self) -> Tuple[bool, Ellipse]: ...
    @overload
    def TryGetEllipse(self, tolerance: float) -> Tuple[bool, Ellipse]: ...
    @overload
    def TryGetEllipse(self, plane: Plane) -> Tuple[bool, Ellipse]: ...
    @overload
    def TryGetEllipse(self, plane: Plane, tolerance: float) -> Tuple[bool, Ellipse]: ...
    @overload
    def TryGetPlane(self) -> Tuple[bool, Plane]: ...
    @overload
    def TryGetPlane(self, tolerance: float) -> Tuple[bool, Plane]: ...
    @overload
    def TryGetPolyline(self) -> Tuple[bool, Polyline]: ...
    @overload
    def TryGetPolyline(self) -> Tuple[bool, Polyline, Set(float)]: ...


class CurveBooleanRegions:
    def BoundaryCount(self, regionIndex: int) -> int: ...
    def Dispose(self) -> None: ...
    @property
    def PlanarCurveCount(self) -> int: ...
    @property
    def PointCount(self) -> int: ...
    @property
    def RegionCount(self) -> int: ...
    def PlanarCurve(self, planarCurveIndex: int) -> Curve: ...
    def RegionCurves(self, regionIndex: int) -> Set(Curve): ...
    def RegionPointIndex(self, pointIndex: int) -> int: ...
    def SegmentCount(self, regionIndex: int, boundaryIndex: int) -> int: ...
    def SegmentDetails(self, regionIndex: int, boundaryIndex: int, segmmentIndex: int) -> Tuple[int, Interval, bool]: ...


class CurveEnd:
    #None = 0
    Start = 1
    End = 2
    Both = 3


class CurveEvaluationSide:
    Default = 0
    Above = 1
    Below = -1


class CurveExtensionStyle:
    Line = 0
    Arc = 1
    Smooth = 2


class CurveKnotStyle:
    Uniform = 0
    Chord = 1
    ChordSquareRoot = 2
    UniformPeriodic = 3
    ChordPeriodic = 4
    ChordSquareRootPeriodic = 5


class CurveOffsetCornerStyle:
    #None = 0
    Sharp = 1
    Round = 2
    Smooth = 3
    Chamfer = 4


class CurveOffsetEndStyle:
    #None = 0
    Flat = 1
    Round = 2


class CurveOrientation:
    Undefined = 0
    CounterClockwise = 1
    Clockwise = -1


class CurveProxy(Curve):
    @property
    def ProxyCurveIsReversed(self) -> bool: ...


class CurveSimplifyOptions:
    #None = 0
    SplitAtFullyMultipleKnots = 1
    RebuildLines = 2
    RebuildArcs = 4
    RebuildRationals = 8
    AdjustG1 = 16
    Merge = 32
    All = 63


class Cylinder:
    @overload
    def __init__(self, baseCircle: Circle): ...
    @overload
    def __init__(self, baseCircle: Circle, height: float): ...
    def CircleAt(self, linearParameter: float) -> Circle: ...
    def EpsilonEquals(self, other: Cylinder, epsilon: float) -> bool: ...
    @property
    def Axis(self) -> Vector3d: ...
    @property
    def BasePlane(self) -> Plane: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Height1(self) -> float: ...
    @property
    def Height2(self) -> float: ...
    @property
    def IsFinite(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Radius(self) -> float: ...
    @property
    def TotalHeight(self) -> float: ...
    @property
    def Unset() -> Cylinder: ...
    def LineAt(self, angularParameter: float) -> Line: ...
    @BasePlane.setter
    def BasePlane(self, value: Plane) -> None: ...
    @Height1.setter
    def Height1(self, value: float) -> None: ...
    @Height2.setter
    def Height2(self, value: float) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def ToBrep(self, capBottom: bool, capTop: bool) -> Brep: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def ToRevSurface(self) -> RevSurface: ...


class DetailView(GeometryBase):
    @property
    def IsParallelProjection(self) -> bool: ...
    @property
    def IsPerspectiveProjection(self) -> bool: ...
    @property
    def IsProjectionLocked(self) -> bool: ...
    @property
    def PageToModelRatio(self) -> float: ...
    @IsParallelProjection.setter
    def IsParallelProjection(self, value: bool) -> None: ...
    @IsPerspectiveProjection.setter
    def IsPerspectiveProjection(self, value: bool) -> None: ...
    @IsProjectionLocked.setter
    def IsProjectionLocked(self, value: bool) -> None: ...
    def SetScale(self, modelLength: float, modelUnits: UnitSystem, pageLength: float, pageUnits: UnitSystem) -> bool: ...


class DevelopableSrf:
    def __init__(self): ...
    def GetLocalDevopableRuling(rail0: NurbsCurve, t0: float, dom0: Interval, rail1: NurbsCurve, t1: float, dom1: Interval, t0_out: float, t1_out: float) -> Tuple[int, float, float]: ...
    @overload
    def RulingMinTwist(rail0: NurbsCurve, t0: float, rail1: NurbsCurve, t1: float, dom1: Interval, t1_out: float, cos_twist_out: float) -> Tuple[bool, float, float]: ...
    @overload
    def RulingMinTwist(rail0: NurbsCurve, t0: float, dom0: Interval, rail1: NurbsCurve, t1: float, dom1: Interval, t0_out: float, t1_out: float, cos_twist_out: float) -> Tuple[bool, float, float, float]: ...
    def UntwistRulings(rail0: NurbsCurve, rail1: NurbsCurve, rulings: Iterable[Point2d]) -> Tuple[bool, Iterable[Point2d]]: ...


class Dimension(AnnotationBase):
    @property
    def AlternateBelowLine(self) -> bool: ...
    @property
    def AltLengthFactor(self) -> float: ...
    @property
    def AltLengthResolution(self) -> int: ...
    @property
    def AltLengthRoundoff(self) -> float: ...
    @property
    def AltPrefix(self) -> str: ...
    @property
    def AltSuffix(self) -> str: ...
    @property
    def AltToleranceResolution(self) -> int: ...
    @property
    def AltUnitsDisplay(self) -> bool: ...
    @property
    def AltZeroSuppression(self) -> ZeroSuppression: ...
    @property
    def ArrowBlockId1(self) -> Guid: ...
    @property
    def ArrowBlockId2(self) -> Guid: ...
    @property
    def ArrowFit(self) -> ArrowFit: ...
    @property
    def ArrowheadType1(self) -> ArrowType: ...
    @property
    def ArrowheadType2(self) -> ArrowType: ...
    @property
    def ArrowSize(self) -> float: ...
    @property
    def BaselineSpacing(self) -> float: ...
    @property
    def CentermarkSize(self) -> float: ...
    @property
    def CentermarkStyle(self) -> CenterMarkStyle: ...
    @property
    def DetailMeasured(self) -> Guid: ...
    @property
    def DimensionLineExtension(self) -> float: ...
    @property
    def DistanceScale(self) -> float: ...
    @property
    def ExtensionLineExtension(self) -> float: ...
    @property
    def ExtensionLineOffset(self) -> float: ...
    @property
    def FixedExtensionLength(self) -> float: ...
    @property
    def FixedLengthExtensionOn(self) -> bool: ...
    @property
    def ForceArrowPosition(self) -> ForceArrow: ...
    @property
    def ForceDimensionLineBetweenExtensionLines(self) -> bool: ...
    @property
    def ForceDimLine(self) -> bool: ...
    @property
    def ForceTextPosition(self) -> ForceText: ...
    @property
    def LengthFactor(self) -> float: ...
    @property
    def LengthResolution(self) -> int: ...
    @property
    def LengthRoundoff(self) -> float: ...
    @property
    def NumericValue(self) -> float: ...
    @property
    def PlainUserText(self) -> str: ...
    @property
    def Prefix(self) -> str: ...
    @property
    def Suffix(self) -> str: ...
    @property
    def SuppressExtension1(self) -> bool: ...
    @property
    def SuppressExtension2(self) -> bool: ...
    @property
    def TextAngleType(self) -> LeaderContentAngleStyle: ...
    @property
    def TextFit(self) -> TextFit: ...
    @property
    def TextFormula(self) -> str: ...
    @property
    def TextLocation(self) -> TextLocation: ...
    @property
    def TextOrientation(self) -> TextOrientation: ...
    @property
    def TextPosition(self) -> Point2d: ...
    @property
    def TextRotation(self) -> float: ...
    @property
    def ToleranceFormat(self) -> ToleranceDisplayFormat: ...
    @property
    def ToleranceHeightScale(self) -> float: ...
    @property
    def ToleranceLowerValue(self) -> float: ...
    @property
    def ToleranceResolution(self) -> int: ...
    @property
    def ToleranceUpperValue(self) -> float: ...
    @property
    def UseDefaultTextPoint(self) -> bool: ...
    @property
    def ZeroSuppression(self) -> ZeroSuppression: ...
    def GetTextTransform(self, viewport: ViewportInfo, style: DimensionStyle, textScale: float, drawForward: bool) -> Transform: ...
    @AlternateBelowLine.setter
    def AlternateBelowLine(self, value: bool) -> None: ...
    @AltLengthFactor.setter
    def AltLengthFactor(self, value: float) -> None: ...
    @AltLengthResolution.setter
    def AltLengthResolution(self, value: int) -> None: ...
    @AltLengthRoundoff.setter
    def AltLengthRoundoff(self, value: float) -> None: ...
    @AltPrefix.setter
    def AltPrefix(self, value: str) -> None: ...
    @AltSuffix.setter
    def AltSuffix(self, value: str) -> None: ...
    @AltToleranceResolution.setter
    def AltToleranceResolution(self, value: int) -> None: ...
    @AltUnitsDisplay.setter
    def AltUnitsDisplay(self, value: bool) -> None: ...
    @AltZeroSuppression.setter
    def AltZeroSuppression(self, value: ZeroSuppression) -> None: ...
    @ArrowBlockId1.setter
    def ArrowBlockId1(self, value: Guid) -> None: ...
    @ArrowBlockId2.setter
    def ArrowBlockId2(self, value: Guid) -> None: ...
    @ArrowFit.setter
    def ArrowFit(self, value: ArrowFit) -> None: ...
    @ArrowheadType1.setter
    def ArrowheadType1(self, value: ArrowType) -> None: ...
    @ArrowheadType2.setter
    def ArrowheadType2(self, value: ArrowType) -> None: ...
    @ArrowSize.setter
    def ArrowSize(self, value: float) -> None: ...
    @BaselineSpacing.setter
    def BaselineSpacing(self, value: float) -> None: ...
    @CentermarkSize.setter
    def CentermarkSize(self, value: float) -> None: ...
    @CentermarkStyle.setter
    def CentermarkStyle(self, value: CenterMarkStyle) -> None: ...
    @DetailMeasured.setter
    def DetailMeasured(self, value: Guid) -> None: ...
    @DimensionLineExtension.setter
    def DimensionLineExtension(self, value: float) -> None: ...
    @DistanceScale.setter
    def DistanceScale(self, value: float) -> None: ...
    @ExtensionLineExtension.setter
    def ExtensionLineExtension(self, value: float) -> None: ...
    @ExtensionLineOffset.setter
    def ExtensionLineOffset(self, value: float) -> None: ...
    @FixedExtensionLength.setter
    def FixedExtensionLength(self, value: float) -> None: ...
    @FixedLengthExtensionOn.setter
    def FixedLengthExtensionOn(self, value: bool) -> None: ...
    @ForceArrowPosition.setter
    def ForceArrowPosition(self, value: ForceArrow) -> None: ...
    @ForceDimensionLineBetweenExtensionLines.setter
    def ForceDimensionLineBetweenExtensionLines(self, value: bool) -> None: ...
    @ForceDimLine.setter
    def ForceDimLine(self, value: bool) -> None: ...
    @ForceTextPosition.setter
    def ForceTextPosition(self, value: ForceText) -> None: ...
    @LengthFactor.setter
    def LengthFactor(self, value: float) -> None: ...
    @LengthResolution.setter
    def LengthResolution(self, value: int) -> None: ...
    @LengthRoundoff.setter
    def LengthRoundoff(self, value: float) -> None: ...
    @Prefix.setter
    def Prefix(self, value: str) -> None: ...
    @Suffix.setter
    def Suffix(self, value: str) -> None: ...
    @SuppressExtension1.setter
    def SuppressExtension1(self, value: bool) -> None: ...
    @SuppressExtension2.setter
    def SuppressExtension2(self, value: bool) -> None: ...
    @TextAngleType.setter
    def TextAngleType(self, value: LeaderContentAngleStyle) -> None: ...
    @TextFit.setter
    def TextFit(self, value: TextFit) -> None: ...
    @TextFormula.setter
    def TextFormula(self, value: str) -> None: ...
    @TextLocation.setter
    def TextLocation(self, value: TextLocation) -> None: ...
    @TextOrientation.setter
    def TextOrientation(self, value: TextOrientation) -> None: ...
    @TextPosition.setter
    def TextPosition(self, value: Point2d) -> None: ...
    @TextRotation.setter
    def TextRotation(self, value: float) -> None: ...
    @ToleranceFormat.setter
    def ToleranceFormat(self, value: ToleranceDisplayFormat) -> None: ...
    @ToleranceHeightScale.setter
    def ToleranceHeightScale(self, value: float) -> None: ...
    @ToleranceLowerValue.setter
    def ToleranceLowerValue(self, value: float) -> None: ...
    @ToleranceResolution.setter
    def ToleranceResolution(self, value: int) -> None: ...
    @ToleranceUpperValue.setter
    def ToleranceUpperValue(self, value: float) -> None: ...
    @UseDefaultTextPoint.setter
    def UseDefaultTextPoint(self, value: bool) -> None: ...
    @ZeroSuppression.setter
    def ZeroSuppression(self, value: ZeroSuppression) -> None: ...
    def SetAltDimensionLengthDisplayWithZeroSuppressionReset(self, ld: LengthDisplay) -> None: ...
    def SetDimensionLengthDisplayWithZeroSuppressionReset(self, ld: LengthDisplay) -> None: ...


class DistancingMode:
    Undefined = 0
    Linear = 1
    LinearFromEnd = 2
    Ratio = 3
    RatioFromEnd = 4


class EdgeAdjacency:
    #None = 0
    Naked = 1
    Interior = 2
    NonManifold = 3


class Ellipse:
    @overload
    def __init__(self, plane: Plane, radius1: float, radius2: float): ...
    @overload
    def __init__(self, center: Point3d, second: Point3d, third: Point3d): ...
    def EpsilonEquals(self, other: Ellipse, epsilon: float) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Radius1(self) -> float: ...
    @property
    def Radius2(self) -> float: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @Radius1.setter
    def Radius1(self, value: float) -> None: ...
    @Radius2.setter
    def Radius2(self, value: float) -> None: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...


class ExtraordinaryVertexProcessOption:
    #None = 0
    LocalG1 = 1
    LocalG2 = 2
    LocalG1x = 3


class ExtrudeCornerType:
    #None = 0
    Sharp = 1
    Round = 2
    Smooth = 3
    Chamfer = 4


class Extrusion(Surface):
    def __init__(self): ...
    def AddInnerProfile(self, innerProfile: Curve) -> bool: ...
    def Create(planarCurve: Curve, height: float, cap: bool) -> Extrusion: ...
    def CreateBoxExtrusion(box: Box, cap: bool) -> Extrusion: ...
    def CreateCylinderExtrusion(cylinder: Cylinder, capBottom: bool, capTop: bool) -> Extrusion: ...
    def CreatePipeExtrusion(cylinder: Cylinder, otherRadius: float, capTop: bool, capBottom: bool) -> Extrusion: ...
    @property
    def CapCount(self) -> int: ...
    @property
    def IsCappedAtBottom(self) -> bool: ...
    @property
    def IsCappedAtTop(self) -> bool: ...
    @property
    def IsMiteredAtEnd(self) -> bool: ...
    @property
    def IsMiteredAtStart(self) -> bool: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def MiterPlaneNormalAtEnd(self) -> Vector3d: ...
    @property
    def MiterPlaneNormalAtStart(self) -> Vector3d: ...
    @property
    def PathEnd(self) -> Point3d: ...
    @property
    def PathStart(self) -> Point3d: ...
    @property
    def PathTangent(self) -> Vector3d: ...
    @property
    def ProfileCount(self) -> int: ...
    def GetMesh(self, meshType: MeshType) -> Mesh: ...
    def GetPathPlane(self, s: float) -> Plane: ...
    def GetProfilePlane(self, s: float) -> Plane: ...
    def GetProfileTransformation(self, s: float) -> Transform: ...
    def GetWireframe(self) -> Set(Curve): ...
    def PathLineCurve(self) -> LineCurve: ...
    @overload
    def Profile3d(self, ci: ComponentIndex) -> Curve: ...
    @overload
    def Profile3d(self, profileIndex: int, s: float) -> Curve: ...
    def ProfileIndex(self, profileParameter: float) -> int: ...
    @MiterPlaneNormalAtEnd.setter
    def MiterPlaneNormalAtEnd(self, value: Vector3d) -> None: ...
    @MiterPlaneNormalAtStart.setter
    def MiterPlaneNormalAtStart(self, value: Vector3d) -> None: ...
    def SetOuterProfile(self, outerProfile: Curve, cap: bool) -> bool: ...
    def SetPathAndUp(self, a: Point3d, b: Point3d, up: Vector3d) -> bool: ...
    @overload
    def ToBrep(self, splitKinkyFaces: bool) -> Brep: ...
    def WallEdge(self, ci: ComponentIndex) -> Curve: ...
    def WallSurface(self, ci: ComponentIndex) -> Surface: ...


class ForceArrow:
    Auto = 0
    Inside = 1
    Outside = 2


class ForceText:
    Auto = 0
    Inside = 1
    Right = 2
    Left = 3
    HintRight = 4
    HintLeft = 5


class GeometryBase(CommonObject):
    def ComponentIndex(self) -> ComponentIndex: ...
    def Duplicate(self) -> GeometryBase: ...
    def DuplicateShallow(self) -> GeometryBase: ...
    def GeometryEquals(first: GeometryBase, second: GeometryBase) -> bool: ...
    def GeometryReferenceEquals(one: GeometryBase, other: GeometryBase) -> bool: ...
    @property
    def HasBrepForm(self) -> bool: ...
    @property
    def IsDeformable(self) -> bool: ...
    @property
    def IsDocumentControlled(self) -> bool: ...
    @property
    def ObjectType(self) -> ObjectType: ...
    @property
    def UserStringCount(self) -> int: ...
    @overload
    def GetBoundingBox(self, plane: Plane) -> BoundingBox: ...
    @overload
    def GetBoundingBox(self, xform: Transform) -> BoundingBox: ...
    @overload
    def GetBoundingBox(self, accurate: bool) -> BoundingBox: ...
    @overload
    def GetBoundingBox(self, plane: Plane) -> Tuple[BoundingBox, Box]: ...
    def GetUserString(self, key: str) -> str: ...
    def GetUserStrings(self) -> NameValueCollection: ...
    def MakeDeformable(self) -> bool: ...
    def MemoryEstimate(self) -> UInt32: ...
    def Rotate(self, angleRadians: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> bool: ...
    def Scale(self, scaleFactor: float) -> bool: ...
    def SetUserString(self, key: str, value: str) -> bool: ...
    def Transform(self, xform: Transform) -> bool: ...
    @overload
    def Translate(self, translationVector: Vector3d) -> bool: ...
    @overload
    def Translate(self, x: float, y: float, z: float) -> bool: ...


class Hatch(GeometryBase):
    @overload
    def Create(curves: Iterable[Curve], hatchPatternIndex: int, rotationRadians: float, scale: float, tolerance: float) -> Set(Hatch): ...
    @overload
    def Create(curve: Curve, hatchPatternIndex: int, rotationRadians: float, scale: float, tolerance: float) -> Set(Hatch): ...
    def CreateDisplayGeometry(self, pattern: HatchPattern, patternScale: float) -> Tuple[Set(Curve), Set(Line), Brep]: ...
    def Explode(self) -> Set(GeometryBase): ...
    @property
    def BasePoint(self) -> Point3d: ...
    @property
    def PatternIndex(self) -> int: ...
    @property
    def PatternRotation(self) -> float: ...
    @property
    def PatternScale(self) -> float: ...
    @property
    def Plane(self) -> Plane: ...
    def Get3dCurves(self, outer: bool) -> Set(Curve): ...
    def GetGradientFill(self) -> ColorGradient: ...
    def ScalePattern(self, xform: Transform) -> None: ...
    @BasePoint.setter
    def BasePoint(self, value: Point3d) -> None: ...
    @PatternIndex.setter
    def PatternIndex(self, value: int) -> None: ...
    @PatternRotation.setter
    def PatternRotation(self, value: float) -> None: ...
    @PatternScale.setter
    def PatternScale(self, value: float) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    def SetGradientFill(self, fill: ColorGradient) -> None: ...


class HermiteSurface:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, uCount: int, vCount: int): ...
    def Dispose(self) -> None: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def UCount(self) -> int: ...
    @property
    def VCount(self) -> int: ...
    def PointAt(self, uIndex: int, vIndex: int) -> Point3d: ...
    def SetPointAt(self, uIndex: int, vIndex: int, point: Point3d) -> None: ...
    def SetTwistAt(self, uIndex: int, vIndex: int, twist: Vector3d) -> None: ...
    def SetUParameterAt(self, index: int, parameter: float) -> None: ...
    def SetUTangentAt(self, uIndex: int, vIndex: int, tangent: Vector3d) -> None: ...
    def SetVParameterAt(self, index: int, parameter: float) -> None: ...
    def SetVTangentAt(self, uIndex: int, vIndex: int, tangent: Vector3d) -> None: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def TwistAt(self, uIndex: int, vIndex: int) -> Vector3d: ...
    def UParameterAt(self, index: int) -> float: ...
    def UTangentAt(self, uIndex: int, vIndex: int) -> Vector3d: ...
    def VParameterAt(self, index: int) -> float: ...
    def VTangentAt(self, uIndex: int, vIndex: int) -> Vector3d: ...


class HiddenLineDrawing:
    def BoundingBox(self, includeHidden: bool) -> BoundingBox: ...
    @overload
    def Compute(parameters: HiddenLineDrawingParameters, multipleThreads: bool) -> HiddenLineDrawing: ...
    @overload
    def Compute(parameters: HiddenLineDrawingParameters, multipleThreads: bool, progress: IProgress, cancelToken: CancellationToken) -> HiddenLineDrawing: ...
    def Dispose(self) -> None: ...
    @property
    def Points(self) -> Iterable[HiddenLineDrawingPoint]: ...
    @property
    def Segments(self) -> Iterable[HiddenLineDrawingSegment]: ...
    @property
    def Viewport(self) -> ViewportInfo: ...
    @property
    def WorldToHiddenLine(self) -> Transform: ...


class HiddenLineDrawingObject:
    @property
    def Geometry(self) -> GeometryBase: ...
    @property
    def Tag(self) -> Object: ...
    @property
    def Transform(self) -> Transform: ...


class HiddenLineDrawingObjectCurve:
    @overload
    def Curve(self, t: float) -> HiddenLineDrawingSegment: ...
    @overload
    def Curve(self, t: float, side: int) -> HiddenLineDrawingSegment: ...
    @property
    def ClippingPlaneIndex(self) -> int: ...
    @property
    def Index(self) -> int: ...
    @property
    def IsProjecting(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def OriginalDomainStart(self) -> float: ...
    @property
    def Parameters(self) -> Set(float): ...
    @property
    def Segments(self) -> Set(HiddenLineDrawingSegment): ...
    @property
    def SilhouetteType(self) -> SilhouetteType: ...
    @property
    def SourceObject(self) -> HiddenLineDrawingObject: ...
    @property
    def SourceObjectComponentIndex(self) -> ComponentIndex: ...


class HiddenLineDrawingParameters:
    def __init__(self): ...
    def AddClippingPlane(self, plane: Plane) -> None: ...
    @overload
    def AddGeometry(self, geometry: GeometryBase, tag: Object) -> bool: ...
    @overload
    def AddGeometry(self, geometry: GeometryBase, xform: Transform, tag: Object) -> bool: ...
    @property
    def AbsoluteTolerance(self) -> float: ...
    @property
    def Flatten(self) -> bool: ...
    @property
    def IncludeHiddenCurves(self) -> bool: ...
    @property
    def IncludeTangentEdges(self) -> bool: ...
    @property
    def IncludeTangentSeams(self) -> bool: ...
    @AbsoluteTolerance.setter
    def AbsoluteTolerance(self, value: float) -> None: ...
    @Flatten.setter
    def Flatten(self, value: bool) -> None: ...
    @IncludeHiddenCurves.setter
    def IncludeHiddenCurves(self, value: bool) -> None: ...
    @IncludeTangentEdges.setter
    def IncludeTangentEdges(self, value: bool) -> None: ...
    @IncludeTangentSeams.setter
    def IncludeTangentSeams(self, value: bool) -> None: ...
    @overload
    def SetViewport(self, viewport: RhinoViewport) -> None: ...
    @overload
    def SetViewport(self, viewport: ViewportInfo) -> None: ...


class HiddenLineDrawingPoint:
    @property
    def ClippingPlaneIndex(self) -> int: ...
    @property
    def Index(self) -> int: ...
    @property
    def Location(self) -> Point3d: ...
    @property
    def PointVisibility(self) -> Visibility: ...
    @property
    def SourceObject(self) -> HiddenLineDrawingObject: ...
    @property
    def SourceObjectComponentIndex(self) -> ComponentIndex: ...


class HiddenLineDrawingSegment:
    @property
    def CurveGeometry(self) -> Curve: ...
    @property
    def CurveSideFills(self) -> Set(SideFill): ...
    @property
    def Index(self) -> int: ...
    @property
    def IsSceneSilhouette(self) -> bool: ...
    @property
    def ParentCurve(self) -> HiddenLineDrawingObjectCurve: ...
    @property
    def SegmentVisibility(self) -> Visibility: ...


class InstanceDefinitionGeometry(ModelComponent):
    def __init__(self): ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Description(self) -> str: ...
    @property
    def Url(self) -> str: ...
    @property
    def UrlDescription(self) -> str: ...
    def GetObjectIds(self) -> Set(Guid): ...
    @Description.setter
    def Description(self, value: str) -> None: ...
    @Url.setter
    def Url(self, value: str) -> None: ...
    @UrlDescription.setter
    def UrlDescription(self, value: str) -> None: ...


class InstanceReferenceGeometry(GeometryBase):
    def __init__(self, instanceDefinitionId: Guid, transform: Transform): ...
    @property
    def ParentIdefId(self) -> Guid: ...
    @property
    def Xform(self) -> Transform: ...


class InteriorCreaseOption:
    Unset = 0
    #None = 1
    AtMeshDoubleEdge = 2


class Interpolator:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initialCapacity: int): ...
    @overload
    def __init__(self, list: RhinoList): ...
    @overload
    def __init__(self, collection: Iterable[float]): ...
    @overload
    def __init__(self, amount: int, defaultValue: float): ...
    @property
    def Cyclical(self) -> bool: ...
    def InterpolateCatmullRom(self, t: float) -> float: ...
    def InterpolateCosine(self, t: float) -> float: ...
    def InterpolateCubic(self, t: float) -> float: ...
    def InterpolateLinear(self, t: float) -> float: ...
    def InterpolateNearestNeighbour(self, t: float) -> float: ...
    @Cyclical.setter
    def Cyclical(self, value: bool) -> None: ...


class Interval:
    @overload
    def __init__(self, other: Interval): ...
    @overload
    def __init__(self, t0: float, t1: float): ...
    def CompareTo(self, other: Interval) -> int: ...
    def EpsilonEquals(self, other: Interval, epsilon: float) -> bool: ...
    @overload
    def Equals(self, other: Interval) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    def FromIntersection(a: Interval, b: Interval) -> Interval: ...
    def FromUnion(a: Interval, b: Interval) -> Interval: ...
    @property
    def IsDecreasing(self) -> bool: ...
    @property
    def IsIncreasing(self) -> bool: ...
    @property
    def IsSingleton(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Item(self, index: int) -> float: ...
    @property
    def Length(self) -> float: ...
    @property
    def Max(self) -> float: ...
    @property
    def Mid(self) -> float: ...
    @property
    def Min(self) -> float: ...
    @property
    def T0(self) -> float: ...
    @property
    def T1(self) -> float: ...
    @property
    def Unset() -> Interval: ...
    def GetHashCode(self) -> int: ...
    def Grow(self, value: float) -> None: ...
    @overload
    def IncludesInterval(self, interval: Interval) -> bool: ...
    @overload
    def IncludesInterval(self, interval: Interval, strict: bool) -> bool: ...
    @overload
    def IncludesParameter(self, t: float) -> bool: ...
    @overload
    def IncludesParameter(self, t: float, strict: bool) -> bool: ...
    def MakeIncreasing(self) -> None: ...
    def NormalizedIntervalAt(self, intervalParameter: Interval) -> Interval: ...
    def NormalizedParameterAt(self, intervalParameter: float) -> float: ...
    @overload
    def op_Addition(interval: Interval, number: float) -> Interval: ...
    @overload
    def op_Addition(number: float, interval: Interval) -> Interval: ...
    def op_Equality(a: Interval, b: Interval) -> bool: ...
    def op_GreaterThan(a: Interval, b: Interval) -> bool: ...
    def op_GreaterThanOrEqual(a: Interval, b: Interval) -> bool: ...
    def op_Inequality(a: Interval, b: Interval) -> bool: ...
    def op_LessThan(a: Interval, b: Interval) -> bool: ...
    def op_LessThanOrEqual(a: Interval, b: Interval) -> bool: ...
    @overload
    def op_Subtraction(interval: Interval, number: float) -> Interval: ...
    @overload
    def op_Subtraction(number: float, interval: Interval) -> Interval: ...
    def ParameterAt(self, normalizedParameter: float) -> float: ...
    def ParameterIntervalAt(self, normalizedInterval: Interval) -> Interval: ...
    def Reverse(self) -> None: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...
    @T0.setter
    def T0(self, value: float) -> None: ...
    @T1.setter
    def T1(self, value: float) -> None: ...
    def Swap(self) -> None: ...
    def ToString(self) -> str: ...


class InvalidDimensionStyleIdException:
    def __init__(self, msg: str): ...


class IsoStatus:
    #None = 0
    X = 1
    Y = 2
    West = 3
    South = 4
    East = 5
    North = 6


class KnotStyle:
    Unknown = 0
    Uniform = 1
    QuasiUniform = 2
    PiecewiseBezier = 3
    ClampedEnd = 4
    NonUniform = 5


class Leader(AnnotationBase):
    def __init__(self): ...
    def Create(text: str, plane: Plane, dimstyle: DimensionStyle, points: Set(Point3d)) -> Leader: ...
    def CreateWithRichText(richText: str, plane: Plane, dimstyle: DimensionStyle, points: Set(Point3d)) -> Leader: ...
    @property
    def Curve(self) -> NurbsCurve: ...
    @property
    def LeaderArrowBlockId(self) -> Guid: ...
    @property
    def LeaderArrowSize(self) -> float: ...
    @property
    def LeaderArrowType(self) -> ArrowType: ...
    @property
    def LeaderContentAngleStyle(self) -> LeaderContentAngleStyle: ...
    @property
    def LeaderCurveStyle(self) -> LeaderCurveStyle: ...
    @property
    def LeaderHasLanding(self) -> bool: ...
    @property
    def LeaderLandingLength(self) -> float: ...
    @property
    def LeaderTextHorizontalAlignment(self) -> TextHorizontalAlignment: ...
    @property
    def LeaderTextVerticalAlignment(self) -> TextVerticalAlignment: ...
    @property
    def Points2D(self) -> Set(Point2d): ...
    @property
    def Points3D(self) -> Set(Point3d): ...
    @LeaderArrowBlockId.setter
    def LeaderArrowBlockId(self, value: Guid) -> None: ...
    @LeaderArrowSize.setter
    def LeaderArrowSize(self, value: float) -> None: ...
    @LeaderArrowType.setter
    def LeaderArrowType(self, value: ArrowType) -> None: ...
    @LeaderContentAngleStyle.setter
    def LeaderContentAngleStyle(self, value: LeaderContentAngleStyle) -> None: ...
    @LeaderCurveStyle.setter
    def LeaderCurveStyle(self, value: LeaderCurveStyle) -> None: ...
    @LeaderHasLanding.setter
    def LeaderHasLanding(self, value: bool) -> None: ...
    @LeaderLandingLength.setter
    def LeaderLandingLength(self, value: float) -> None: ...
    @LeaderTextHorizontalAlignment.setter
    def LeaderTextHorizontalAlignment(self, value: TextHorizontalAlignment) -> None: ...
    @LeaderTextVerticalAlignment.setter
    def LeaderTextVerticalAlignment(self, value: TextVerticalAlignment) -> None: ...
    @Points2D.setter
    def Points2D(self, value: Set(Point2d)) -> None: ...
    @Points3D.setter
    def Points3D(self, value: Set(Point3d)) -> None: ...


class LengthMassProperties:
    def CentroidCoordinatesPrincipalMoments(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    def CentroidCoordinatesPrincipalMomentsOfInertia(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    @overload
    def Compute(curve: Curve) -> LengthMassProperties: ...
    @overload
    def Compute(curves: Iterable[Curve]) -> LengthMassProperties: ...
    @overload
    def Compute(curve: Curve, length: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> LengthMassProperties: ...
    @overload
    def Compute(curves: Iterable[Curve], length: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> LengthMassProperties: ...
    def Dispose(self) -> None: ...
    @property
    def Centroid(self) -> Point3d: ...
    @property
    def CentroidCoordinatesMomentsOfInertia(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesMomentsOfInertiaError(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesProductMoments(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesProductMomentsError(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesRadiiOfGyration(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesSecondMoments(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesSecondMomentsError(self) -> Vector3d: ...
    @property
    def CentroidError(self) -> Vector3d: ...
    @property
    def Length(self) -> float: ...
    @property
    def LengthError(self) -> float: ...
    @property
    def WorldCoordinatesFirstMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesFirstMomentsError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesMomentsOfInertia(self) -> Vector3d: ...
    @property
    def WorldCoordinatesMomentsOfInertiaError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesProductMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesProductMomentsError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesRadiiOfGyration(self) -> Vector3d: ...
    @property
    def WorldCoordinatesSecondMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesSecondMomentsError(self) -> Vector3d: ...
    def WorldCoordinatesPrincipalMoments(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    def WorldCoordinatesPrincipalMomentsOfInertia(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...


class Light(GeometryBase):
    def __init__(self): ...
    @overload
    def CreateSunLight(sun: Sun) -> Light: ...
    @overload
    def CreateSunLight(northAngleDegrees: float, azimuthDegrees: float, altitudeDegrees: float) -> Light: ...
    @overload
    def CreateSunLight(northAngleDegrees: float, when: DateTime, latitudeDegrees: float, longitudeDegrees: float) -> Light: ...
    @property
    def Ambient(self) -> Color: ...
    @property
    def AttenuationType(self) -> Attenuation: ...
    @property
    def AttenuationVector(self) -> Vector3d: ...
    @property
    def CoordinateSystem(self) -> CoordinateSystem: ...
    @property
    def Diffuse(self) -> Color: ...
    @property
    def Direction(self) -> Vector3d: ...
    @property
    def HotSpot(self) -> float: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def Intensity(self) -> float: ...
    @property
    def IsDirectionalLight(self) -> bool: ...
    @property
    def IsEnabled(self) -> bool: ...
    @property
    def IsLinearLight(self) -> bool: ...
    @property
    def IsPointLight(self) -> bool: ...
    @property
    def IsRectangularLight(self) -> bool: ...
    @property
    def IsSpotLight(self) -> bool: ...
    @property
    def IsSunLight(self) -> bool: ...
    @property
    def Length(self) -> Vector3d: ...
    @property
    def LightStyle(self) -> LightStyle: ...
    @property
    def Location(self) -> Point3d: ...
    @property
    def Name(self) -> str: ...
    @property
    def PerpendicularDirection(self) -> Vector3d: ...
    @property
    def PowerCandela(self) -> float: ...
    @property
    def PowerLumens(self) -> float: ...
    @property
    def PowerWatts(self) -> float: ...
    @property
    def ShadowIntensity(self) -> float: ...
    @property
    def Specular(self) -> Color: ...
    @property
    def SpotAngleRadians(self) -> float: ...
    @property
    def SpotExponent(self) -> float: ...
    @property
    def SpotLightShadowIntensity(self) -> float: ...
    @property
    def Width(self) -> Vector3d: ...
    def GetAttenuation(self, d: float) -> float: ...
    def GetSpotLightRadii(self) -> Tuple[bool, float, float]: ...
    @Ambient.setter
    def Ambient(self, value: Color) -> None: ...
    @AttenuationType.setter
    def AttenuationType(self, value: Attenuation) -> None: ...
    @AttenuationVector.setter
    def AttenuationVector(self, value: Vector3d) -> None: ...
    @Diffuse.setter
    def Diffuse(self, value: Color) -> None: ...
    @Direction.setter
    def Direction(self, value: Vector3d) -> None: ...
    @HotSpot.setter
    def HotSpot(self, value: float) -> None: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @Intensity.setter
    def Intensity(self, value: float) -> None: ...
    @IsEnabled.setter
    def IsEnabled(self, value: bool) -> None: ...
    @Length.setter
    def Length(self, value: Vector3d) -> None: ...
    @LightStyle.setter
    def LightStyle(self, value: LightStyle) -> None: ...
    @Location.setter
    def Location(self, value: Point3d) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @PowerCandela.setter
    def PowerCandela(self, value: float) -> None: ...
    @PowerLumens.setter
    def PowerLumens(self, value: float) -> None: ...
    @PowerWatts.setter
    def PowerWatts(self, value: float) -> None: ...
    @ShadowIntensity.setter
    def ShadowIntensity(self, value: float) -> None: ...
    @Specular.setter
    def Specular(self, value: Color) -> None: ...
    @SpotAngleRadians.setter
    def SpotAngleRadians(self, value: float) -> None: ...
    @SpotExponent.setter
    def SpotExponent(self, value: float) -> None: ...
    @SpotLightShadowIntensity.setter
    def SpotLightShadowIntensity(self, value: float) -> None: ...
    @Width.setter
    def Width(self, value: Vector3d) -> None: ...
    def SetAttenuation(self, a0: float, a1: float, a2: float) -> None: ...


class LightStyle:
    #None = 0
    CameraDirectional = 4
    CameraPoint = 5
    CameraSpot = 6
    WorldDirectional = 7
    WorldPoint = 8
    WorldSpot = 9
    Ambient = 10
    WorldLinear = 11
    WorldRectangular = 12


class Line:
    @overload
    def __init__(self, from_: Point3d, to: Point3d): ...
    @overload
    def __init__(self, start: Point3d, span: Vector3d): ...
    @overload
    def __init__(self, start: Point3d, direction: Vector3d, length: float): ...
    @overload
    def __init__(self, x0: float, y0: float, z0: float, x1: float, y1: float, z1: float): ...
    def ClosestParameter(self, testPoint: Point3d) -> float: ...
    def ClosestPoint(self, testPoint: Point3d, limitToFiniteSegment: bool) -> Point3d: ...
    def DistanceTo(self, testPoint: Point3d, limitToFiniteSegment: bool) -> float: ...
    def EpsilonEquals(self, other: Line, epsilon: float) -> bool: ...
    @overload
    def Equals(self, other: Line) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    def Extend(self, startLength: float, endLength: float) -> bool: ...
    @overload
    def ExtendThroughBox(self, box: BoundingBox) -> bool: ...
    @overload
    def ExtendThroughBox(self, box: Box) -> bool: ...
    @overload
    def ExtendThroughBox(self, box: Box, additionalLength: float) -> bool: ...
    @overload
    def ExtendThroughBox(self, box: BoundingBox, additionalLength: float) -> bool: ...
    def Flip(self) -> None: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def Direction(self) -> Vector3d: ...
    @property
    def From(self) -> Point3d: ...
    @property
    def FromX(self) -> float: ...
    @property
    def FromY(self) -> float: ...
    @property
    def FromZ(self) -> float: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Length(self) -> float: ...
    @property
    def To(self) -> Point3d: ...
    @property
    def ToX(self) -> float: ...
    @property
    def ToY(self) -> float: ...
    @property
    def ToZ(self) -> float: ...
    @property
    def UnitTangent(self) -> Vector3d: ...
    @property
    def Unset() -> Line: ...
    def GetHashCode(self) -> int: ...
    @overload
    def MaximumDistanceTo(self, testLine: Line) -> float: ...
    @overload
    def MaximumDistanceTo(self, testPoint: Point3d) -> float: ...
    @overload
    def MinimumDistanceTo(self, testLine: Line) -> float: ...
    @overload
    def MinimumDistanceTo(self, testPoint: Point3d) -> float: ...
    def op_Equality(a: Line, b: Line) -> bool: ...
    def op_Inequality(a: Line, b: Line) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...
    def PointAtLength(self, distance: float) -> Point3d: ...
    @From.setter
    def From(self, value: Point3d) -> None: ...
    @FromX.setter
    def FromX(self, value: float) -> None: ...
    @FromY.setter
    def FromY(self, value: float) -> None: ...
    @FromZ.setter
    def FromZ(self, value: float) -> None: ...
    @Length.setter
    def Length(self, value: float) -> None: ...
    @To.setter
    def To(self, value: Point3d) -> None: ...
    @ToX.setter
    def ToX(self, value: float) -> None: ...
    @ToY.setter
    def ToY(self, value: float) -> None: ...
    @ToZ.setter
    def ToZ(self, value: float) -> None: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, xform: Transform) -> bool: ...
    def TryCreateBetweenCurves(curve0: Curve, curve1: Curve, t0: float, t1: float, perpendicular0: bool, perpendicular1: bool) -> Tuple[bool, float, float, Line]: ...
    def TryFitLineToPoints(points: Iterable[Point3d]) -> Tuple[bool, Line]: ...
    def TryGetPlane(self) -> Tuple[bool, Plane]: ...


class LinearDimension(Dimension):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, dimensionPlane: Plane, extensionLine1End: Point2d, extensionLine2End: Point2d, pointOnDimensionLine: Point2d): ...
    def Create(dimtype: AnnotationType, dimStyle: DimensionStyle, plane: Plane, horizontal: Vector3d, defpoint1: Point3d, defpoint2: Point3d, dimlinepoint: Point3d, rotationInPlane: float) -> LinearDimension: ...
    def FromPoints(extensionLine1End: Point3d, extensionLine2End: Point3d, pointOnDimensionLine: Point3d) -> LinearDimension: ...
    @property
    def Aligned(self) -> bool: ...
    @property
    def AnnotationType(self) -> AnnotationType: ...
    @property
    def Arrowhead1End(self) -> Point2d: ...
    @property
    def Arrowhead2End(self) -> Point2d: ...
    @property
    def DimensionLinePoint(self) -> Point2d: ...
    @property
    def DistanceBetweenArrowTips(self) -> float: ...
    @property
    def ExtensionLine1End(self) -> Point2d: ...
    @property
    def ExtensionLine2End(self) -> Point2d: ...
    def Get3dPoints(self) -> Tuple[bool, Point3d, Point3d, Point3d, Point3d, Point3d, Point3d]: ...
    def GetDisplayLines(self, style: DimensionStyle, scale: float) -> Tuple[bool, Iterable[Line]]: ...
    def GetDistanceDisplayText(self, unitsystem: UnitSystem, style: DimensionStyle) -> str: ...
    def GetTextRectangle(self) -> Tuple[bool, Set(Point3d)]: ...
    @Aligned.setter
    def Aligned(self, value: bool) -> None: ...
    @AnnotationType.setter
    def AnnotationType(self, value: AnnotationType) -> None: ...
    @DimensionLinePoint.setter
    def DimensionLinePoint(self, value: Point2d) -> None: ...
    @ExtensionLine1End.setter
    def ExtensionLine1End(self, value: Point2d) -> None: ...
    @ExtensionLine2End.setter
    def ExtensionLine2End(self, value: Point2d) -> None: ...
    def SetLocations(self, extensionLine1End: Point2d, extensionLine2End: Point2d, pointOnDimensionLine: Point2d) -> None: ...


class LineCurve(Curve):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: LineCurve): ...
    @overload
    def __init__(self, line: Line): ...
    @overload
    def __init__(self, from_: Point2d, to: Point2d): ...
    @overload
    def __init__(self, from_: Point3d, to: Point3d): ...
    @overload
    def __init__(self, line: Line, t0: float, t1: float): ...
    @property
    def Line(self) -> Line: ...
    @Line.setter
    def Line(self, value: Line) -> None: ...


class LoftType:
    Normal = 0
    Loose = 1
    Tight = 2
    Straight = 3
    Developable = 4
    Uniform = 5


class Matrix:
    @overload
    def __init__(self, xform: Transform): ...
    @overload
    def __init__(self, rowCount: int, columnCount: int): ...
    def BackSolve(self, zeroTolerance: float, b: Set(float)) -> Set(float): ...
    def BackSolvePoints(self, zeroTolerance: float, b: Set(Point3d)) -> Set(Point3d): ...
    def Dispose(self) -> None: ...
    def Duplicate(self) -> Matrix: ...
    @property
    def ColumnCount(self) -> int: ...
    @property
    def IsColumnOrthogonal(self) -> bool: ...
    @property
    def IsColumnOrthoNormal(self) -> bool: ...
    @property
    def IsRowOrthogonal(self) -> bool: ...
    @property
    def IsRowOrthoNormal(self) -> bool: ...
    @property
    def IsSquare(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Item(self, row: int, column: int) -> float: ...
    @property
    def RowCount(self) -> int: ...
    def GetHashCode(self) -> int: ...
    def Invert(self, zeroTolerance: float) -> bool: ...
    def op_Addition(a: Matrix, b: Matrix) -> Matrix: ...
    def op_Multiply(a: Matrix, b: Matrix) -> Matrix: ...
    @overload
    def RowReduce(self, zeroTolerance: float, b: Set(Point3d)) -> Tuple[int, float]: ...
    @overload
    def RowReduce(self, zeroTolerance: float) -> Tuple[int, float, float]: ...
    @overload
    def RowReduce(self, zeroTolerance: float, b: Set(float)) -> Tuple[int, float]: ...
    def Scale(self, s: float) -> None: ...
    @Item.setter
    def Item(self, row: int, column: int, value: float) -> None: ...
    def SetDiagonal(self, d: float) -> None: ...
    def SwapColumns(self, columnA: int, columnB: int) -> bool: ...
    def SwapRows(self, rowA: int, rowB: int) -> bool: ...
    def Transpose(self) -> bool: ...
    def Zero(self) -> None: ...


class MeasuredDirection:
    Unset = 0
    Xaxis = 1
    Yaxis = 2


class Mesh(GeometryBase):
    def __init__(self): ...
    @overload
    def Append(self, meshes: Iterable[Mesh]) -> None: ...
    @overload
    def Append(self, other: Mesh) -> None: ...
    def Check(self, textLog: TextLog, parameters: MeshCheckParameters) -> Tuple[bool, MeshCheckParameters]: ...
    def ClearSurfaceData(self) -> None: ...
    def ClearTextureData(self) -> None: ...
    def ClosestMeshPoint(self, testPoint: Point3d, maximumDistance: float) -> MeshPoint: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d, maximumDistance: float) -> Tuple[int, Point3d]: ...
    @overload
    def ClosestPoint(self, testPoint: Point3d, maximumDistance: float) -> Tuple[int, Point3d, Vector3d]: ...
    def CollapseFacesByArea(self, lessThanArea: float, greaterThanArea: float) -> int: ...
    def CollapseFacesByByAspectRatio(self, aspectRatio: float) -> int: ...
    def CollapseFacesByEdgeLength(self, bGreaterThan: bool, edgeLength: float) -> int: ...
    @overload
    def ColorAt(self, meshPoint: MeshPoint) -> Color: ...
    @overload
    def ColorAt(self, faceIndex: int, t0: float, t1: float, t2: float, t3: float) -> Color: ...
    def Compact(self) -> bool: ...
    def ComputeAutoCreaseInformation(self) -> Set(Byte): ...
    @overload
    def ComputeThickness(meshes: Iterable[Mesh], maximumThickness: float) -> Set(MeshThicknessMeasurement): ...
    @overload
    def ComputeThickness(meshes: Iterable[Mesh], maximumThickness: float, cancelToken: CancellationToken) -> Set(MeshThicknessMeasurement): ...
    @overload
    def ComputeThickness(meshes: Iterable[Mesh], maximumThickness: float, sharpAngle: float, cancelToken: CancellationToken) -> Set(MeshThicknessMeasurement): ...
    def CopyFrom(self, other: Mesh) -> None: ...
    def CreateBooleanDifference(firstSet: Iterable[Mesh], secondSet: Iterable[Mesh]) -> Set(Mesh): ...
    def CreateBooleanIntersection(firstSet: Iterable[Mesh], secondSet: Iterable[Mesh]) -> Set(Mesh): ...
    def CreateBooleanSplit(meshesToSplit: Iterable[Mesh], meshSplitters: Iterable[Mesh]) -> Set(Mesh): ...
    def CreateBooleanUnion(meshes: Iterable[Mesh]) -> Set(Mesh): ...
    @overload
    def CreateContourCurves(meshToContour: Mesh, sectionPlane: Plane) -> Set(Curve): ...
    @overload
    def CreateContourCurves(meshToContour: Mesh, contourStart: Point3d, contourEnd: Point3d, interval: float) -> Set(Curve): ...
    @overload
    def CreateFromBox(box: Box, xCount: int, yCount: int, zCount: int) -> Mesh: ...
    @overload
    def CreateFromBox(corners: Iterable[Point3d], xCount: int, yCount: int, zCount: int) -> Mesh: ...
    @overload
    def CreateFromBox(box: BoundingBox, xCount: int, yCount: int, zCount: int) -> Mesh: ...
    def CreateFromBrep(brep: Brep, meshingParameters: MeshingParameters) -> Set(Mesh): ...
    def CreateFromClosedPolyline(polyline: Polyline) -> Mesh: ...
    @overload
    def CreateFromCone(cone: Cone, vertical: int, around: int) -> Mesh: ...
    @overload
    def CreateFromCone(cone: Cone, vertical: int, around: int, solid: bool) -> Mesh: ...
    @overload
    def CreateFromCone(cone: Cone, vertical: int, around: int, solid: bool, quadCaps: bool) -> Mesh: ...
    def CreateFromCurveExtrusion(curve: Curve, direction: Vector3d, parameters: MeshingParameters, boundingBox: BoundingBox) -> Mesh: ...
    def CreateFromCurvePipe(curve: Curve, radius: float, segments: int, accuracy: int, capType: MeshPipeCapStyle, faceted: bool, intervals: Iterable[Interval]) -> Mesh: ...
    @overload
    def CreateFromCylinder(cylinder: Cylinder, vertical: int, around: int) -> Mesh: ...
    @overload
    def CreateFromCylinder(cylinder: Cylinder, vertical: int, around: int, capBottom: bool, capTop: bool) -> Mesh: ...
    @overload
    def CreateFromCylinder(cylinder: Cylinder, vertical: int, around: int, capBottom: bool, capTop: bool, quadCaps: bool) -> Mesh: ...
    @overload
    def CreateFromCylinder(cylinder: Cylinder, vertical: int, around: int, capBottom: bool, capTop: bool, circumscribe: bool, quadCaps: bool) -> Mesh: ...
    def CreateFromFilteredFaceList(original: Mesh, inclusion: Iterable[bool]) -> Mesh: ...
    def CreateFromIterativeCleanup(meshes: Iterable[Mesh], tolerance: float) -> Set(Mesh): ...
    def CreateFromLines(lines: Set(Curve), maxFaceValence: int, tolerance: float) -> Mesh: ...
    def CreateFromPlanarBoundary(boundary: Curve, parameters: MeshingParameters, tolerance: float) -> Mesh: ...
    def CreateFromPlane(plane: Plane, xInterval: Interval, yInterval: Interval, xCount: int, yCount: int) -> Mesh: ...
    def CreateFromSphere(sphere: Sphere, xCount: int, yCount: int) -> Mesh: ...
    def CreateFromSubD(subd: SubD, displayDensity: int) -> Mesh: ...
    def CreateFromSubDControlNet(subd: SubD) -> Mesh: ...
    @overload
    def CreateFromSurface(surface: Surface) -> Mesh: ...
    @overload
    def CreateFromSurface(surface: Surface, meshingParameters: MeshingParameters) -> Mesh: ...
    def CreateFromTessellation(points: Iterable[Point3d], edges: Iterable[Iterable[Point3d]], plane: Plane, allowNewVertices: bool) -> Mesh: ...
    def CreateFromTorus(torus: Torus, vertical: int, around: int) -> Mesh: ...
    def CreateIcoSphere(sphere: Sphere, subdivisions: int) -> Mesh: ...
    def CreatePartitions(self, maximumVertexCount: int, maximumTriangleCount: int) -> bool: ...
    def CreatePatch(outerBoundary: Polyline, angleToleranceRadians: float, pullbackSurface: Surface, innerBoundaryCurves: Iterable[Curve], innerBothSideCurves: Iterable[Curve], innerPoints: Iterable[Point3d], trimback: bool, divisions: int) -> Mesh: ...
    def CreateQuadSphere(sphere: Sphere, subdivisions: int) -> Mesh: ...
    def CreateRefinedCatmullClarkMesh(mesh: Mesh, settings: RefinementSettings) -> Mesh: ...
    def CreateRefinedLoopMesh(mesh: Mesh, formula: LoopFormula, settings: RefinementSettings) -> Mesh: ...
    def DestroyPartition(self) -> None: ...
    def DestroyTopology(self) -> None: ...
    def DestroyTree(self) -> None: ...
    def Duplicate(self) -> GeometryBase: ...
    def DuplicateMesh(self) -> Mesh: ...
    def EvaluateMeshGeometry(self, surface: Surface) -> bool: ...
    def ExplodeAtUnweldedEdges(self) -> Set(Mesh): ...
    def ExtendSelectionByEdgeRidge(self, preselectedEdges: Set(int), newEdge: int, iterative: bool) -> Set(int): ...
    def ExtendSelectionByFaceLoop(self, preselectedFaces: Set(int), newFace: int, iterative: bool) -> Set(int): ...
    def ExtractNonManifoldEdges(self, selective: bool) -> Mesh: ...
    def FileHole(self, topologyEdgeIndex: int) -> bool: ...
    def FillHoles(self) -> bool: ...
    @overload
    def Flip(self, vertexNormals: bool, faceNormals: bool, faceOrientation: bool) -> None: ...
    @overload
    def Flip(self, vertexNormals: bool, faceNormals: bool, faceOrientation: bool, ngonsBoundaryDirection: bool) -> None: ...
    @property
    def ComponentStates(self) -> MeshVertexStatusList: ...
    @property
    def DisjointMeshCount(self) -> int: ...
    @property
    def FaceNormals(self) -> MeshFaceNormalList: ...
    @property
    def Faces(self) -> MeshFaceList: ...
    @property
    def HasCachedTextureCoordinates(self) -> bool: ...
    @property
    def HasPrincipalCurvatures(self) -> bool: ...
    @property
    def IsClosed(self) -> bool: ...
    @property
    def IsOriented(self) -> bool: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def Ngons(self) -> MeshNgonList: ...
    @property
    def Normals(self) -> MeshVertexNormalList: ...
    @property
    def PartitionCount(self) -> int: ...
    @property
    def TextureCoordinates(self) -> MeshTextureCoordinateList: ...
    @property
    def TopologyEdges(self) -> MeshTopologyEdgeList: ...
    @property
    def TopologyVertices(self) -> MeshTopologyVertexList: ...
    @property
    def VertexColors(self) -> MeshVertexColorList: ...
    @property
    def Vertices(self) -> MeshVertexList: ...
    def GetCachedTextureCoordinates(self, textureMappingId: Guid) -> CachedTextureCoordinates: ...
    def GetNakedEdgePointStatus(self) -> Set(bool): ...
    def GetNakedEdges(self) -> Set(Polyline): ...
    def GetNgonAndFacesCount(self) -> int: ...
    def GetNgonAndFacesEnumerable(self) -> Iterable[MeshNgon]: ...
    @overload
    def GetOutlines(self, viewport: RhinoViewport) -> Set(Polyline): ...
    @overload
    def GetOutlines(self, plane: Plane) -> Set(Polyline): ...
    @overload
    def GetOutlines(self, viewportInfo: ViewportInfo, plane: Plane) -> Set(Polyline): ...
    def GetPartition(self, which: int) -> MeshPart: ...
    def GetSelfIntersections(self, tolerance: float, overlapsPolylines: bool, overlapsMesh: bool, textLog: TextLog, cancel: CancellationToken, progress: IProgress) -> Tuple[bool, Set(Polyline), Set(Polyline), Mesh]: ...
    def GetUnsafeLock(self, writable: bool) -> MeshUnsafeLock: ...
    def HealNakedEdges(self, distance: float) -> bool: ...
    @overload
    def IsManifold(self) -> bool: ...
    @overload
    def IsManifold(self, topologicalTest: bool) -> Tuple[bool, bool, bool]: ...
    def IsPointInside(self, point: Point3d, tolerance: float, strictlyIn: bool) -> bool: ...
    def MatchEdges(self, distance: float, rachet: bool) -> bool: ...
    @overload
    def NormalAt(self, meshPoint: MeshPoint) -> Vector3d: ...
    @overload
    def NormalAt(self, faceIndex: int, t0: float, t1: float, t2: float, t3: float) -> Vector3d: ...
    @overload
    def Offset(self, distance: float) -> Mesh: ...
    @overload
    def Offset(self, distance: float, solidify: bool) -> Mesh: ...
    @overload
    def Offset(self, distance: float, solidify: bool, direction: Vector3d) -> Mesh: ...
    @overload
    def Offset(self, distance: float, solidify: bool, direction: Vector3d) -> Tuple[Mesh, List]: ...
    @overload
    def PointAt(self, meshPoint: MeshPoint) -> Point3d: ...
    @overload
    def PointAt(self, faceIndex: int, t0: float, t1: float, t2: float, t3: float) -> Point3d: ...
    def PullCurve(self, curve: Curve, tolerance: float) -> PolylineCurve: ...
    def PullPointsToMesh(self, points: Iterable[Point3d]) -> Set(Point3d): ...
    @overload
    def QuadRemesh(self, parameters: QuadRemeshParameters) -> Mesh: ...
    @overload
    def QuadRemesh(self, parameters: QuadRemeshParameters, guideCurves: Iterable[Curve]) -> Mesh: ...
    @overload
    def QuadRemeshAsync(self, parameters: QuadRemeshParameters, progress: IProgress, cancelToken: CancellationToken) -> Task: ...
    @overload
    def QuadRemeshAsync(self, parameters: QuadRemeshParameters, guideCurves: Iterable[Curve], progress: IProgress, cancelToken: CancellationToken) -> Task: ...
    @overload
    def QuadRemeshAsync(self, faceBlocks: Iterable[int], parameters: QuadRemeshParameters, guideCurves: Iterable[Curve], progress: IProgress, cancelToken: CancellationToken) -> Task: ...
    @overload
    def QuadRemeshBrep(brep: Brep, parameters: QuadRemeshParameters) -> Mesh: ...
    @overload
    def QuadRemeshBrep(brep: Brep, parameters: QuadRemeshParameters, guideCurves: Iterable[Curve]) -> Mesh: ...
    @overload
    def QuadRemeshBrepAsync(brep: Brep, parameters: QuadRemeshParameters, progress: IProgress, cancelToken: CancellationToken) -> Task: ...
    @overload
    def QuadRemeshBrepAsync(brep: Brep, parameters: QuadRemeshParameters, guideCurves: Iterable[Curve], progress: IProgress, cancelToken: CancellationToken) -> Task: ...
    def RebuildNormals(self) -> None: ...
    @overload
    def Reduce(self, parameters: ReduceMeshParameters) -> bool: ...
    @overload
    def Reduce(self, parameters: ReduceMeshParameters, threaded: bool) -> bool: ...
    @overload
    def Reduce(self, desiredPolygonCount: int, allowDistortion: bool, accuracy: int, normalizeSize: bool) -> bool: ...
    @overload
    def Reduce(self, desiredPolygonCount: int, allowDistortion: bool, accuracy: int, normalizeSize: bool, threaded: bool) -> bool: ...
    @overload
    def Reduce(self, desiredPolygonCount: int, allowDistortion: bool, accuracy: int, normalizeSize: bool, cancelToken: CancellationToken, progress: IProgress) -> Tuple[bool, str]: ...
    @overload
    def Reduce(self, desiredPolygonCount: int, allowDistortion: bool, accuracy: int, normalizeSize: bool, cancelToken: CancellationToken, progress: IProgress, threaded: bool) -> Tuple[bool, str]: ...
    def ReleaseUnsafeLock(self, meshData: MeshUnsafeLock) -> None: ...
    def RequireIterativeCleanup(meshes: Iterable[Mesh], tolerance: float) -> bool: ...
    def SetCachedTextureCoordinates(self, tm: TextureMapping, xf: Transform) -> Tuple[Transform]: ...
    @overload
    def SetTextureCoordinates(self, tm: TextureMapping, xf: Transform, lazy: bool) -> None: ...
    @overload
    def SetTextureCoordinates(self, tm: TextureMapping, xf: Transform, lazy: bool, seamCheck: bool) -> None: ...
    @overload
    def Smooth(self, smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem) -> bool: ...
    @overload
    def Smooth(self, smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem, plane: Plane) -> bool: ...
    @overload
    def Smooth(self, vertexIndices: Iterable[int], smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem, plane: Plane) -> bool: ...
    def SolidOrientation(self) -> int: ...
    @overload
    def Split(self, mesh: Mesh) -> Set(Mesh): ...
    @overload
    def Split(self, meshes: Iterable[Mesh]) -> Set(Mesh): ...
    @overload
    def Split(self, plane: Plane) -> Set(Mesh): ...
    @overload
    def Split(self, meshes: Iterable[Mesh], tolerance: float, splitAtCoplanar: bool, textLog: TextLog, cancel: CancellationToken, progress: IProgress) -> Set(Mesh): ...
    @overload
    def Split(self, meshes: Iterable[Mesh], tolerance: float, splitAtCoplanar: bool, createNgons: bool, textLog: TextLog, cancel: CancellationToken, progress: IProgress) -> Set(Mesh): ...
    def SplitDisjointPieces(self) -> Set(Mesh): ...
    @overload
    def SplitWithProjectedPolylines(self, curves: Iterable[PolylineCurve], tolerance: float) -> Set(Mesh): ...
    @overload
    def SplitWithProjectedPolylines(self, curves: Iterable[PolylineCurve], tolerance: float, textLog: TextLog, cancel: CancellationToken, progress: IProgress) -> Set(Mesh): ...
    @overload
    def UnifyNormals(self) -> int: ...
    @overload
    def UnifyNormals(self, countOnly: bool) -> int: ...
    def Unweld(self, angleToleranceRadians: float, modifyNormals: bool) -> None: ...
    def UnweldEdge(self, edgeIndices: Iterable[int], modifyNormals: bool) -> bool: ...
    def UnweldVertices(self, topologyVertexIndices: Iterable[int], modifyNormals: bool) -> bool: ...
    def Volume(self) -> float: ...
    def Weld(self, angleToleranceRadians: float) -> None: ...
    def WithDisplacement(self, displacement: MeshDisplacementInfo) -> Mesh: ...
    def WithEdgeSoftening(self, softeningRadius: float, chamfer: bool, faceted: bool, force: bool, angleThreshold: float) -> Mesh: ...
    def WithShutLining(self, faceted: bool, tolerance: float, curves: Iterable[ShutLiningCurveInfo]) -> Mesh: ...


class MeshCheckParameters:
    def Defaults() -> MeshCheckParameters: ...
    @property
    def CheckForBadNormals(self) -> bool: ...
    @property
    def CheckForDegenerateFaces(self) -> bool: ...
    @property
    def CheckForDisjointMeshes(self) -> bool: ...
    @property
    def CheckForDuplicateFaces(self) -> bool: ...
    @property
    def CheckForExtremelyShortEdges(self) -> bool: ...
    @property
    def CheckForInvalidNgons(self) -> bool: ...
    @property
    def CheckForNakedEdges(self) -> bool: ...
    @property
    def CheckForNonManifoldEdges(self) -> bool: ...
    @property
    def CheckForRandomFaceNormals(self) -> bool: ...
    @property
    def CheckForSelfIntersection(self) -> bool: ...
    @property
    def CheckForUnusedVertices(self) -> bool: ...
    @property
    def DegenerateFaceCount(self) -> int: ...
    @property
    def DisjointMeshCount(self) -> int: ...
    @property
    def DuplicateFaceCount(self) -> int: ...
    @property
    def ExtremelyShortEdgeCount(self) -> int: ...
    @property
    def InvalidNgonCount(self) -> int: ...
    @property
    def NakedEdgeCount(self) -> int: ...
    @property
    def NonManifoldEdgeCount(self) -> int: ...
    @property
    def NonUnitVectorNormalCount(self) -> int: ...
    @property
    def RandomFaceNormalCount(self) -> int: ...
    @property
    def SelfIntersectingPairsCount(self) -> int: ...
    @property
    def UnusedVertexCount(self) -> int: ...
    @property
    def VertexFaceNormalsDifferCount(self) -> int: ...
    @property
    def ZeroLengthNormalCount(self) -> int: ...
    @CheckForBadNormals.setter
    def CheckForBadNormals(self, value: bool) -> None: ...
    @CheckForDegenerateFaces.setter
    def CheckForDegenerateFaces(self, value: bool) -> None: ...
    @CheckForDisjointMeshes.setter
    def CheckForDisjointMeshes(self, value: bool) -> None: ...
    @CheckForDuplicateFaces.setter
    def CheckForDuplicateFaces(self, value: bool) -> None: ...
    @CheckForExtremelyShortEdges.setter
    def CheckForExtremelyShortEdges(self, value: bool) -> None: ...
    @CheckForInvalidNgons.setter
    def CheckForInvalidNgons(self, value: bool) -> None: ...
    @CheckForNakedEdges.setter
    def CheckForNakedEdges(self, value: bool) -> None: ...
    @CheckForNonManifoldEdges.setter
    def CheckForNonManifoldEdges(self, value: bool) -> None: ...
    @CheckForRandomFaceNormals.setter
    def CheckForRandomFaceNormals(self, value: bool) -> None: ...
    @CheckForSelfIntersection.setter
    def CheckForSelfIntersection(self, value: bool) -> None: ...
    @CheckForUnusedVertices.setter
    def CheckForUnusedVertices(self, value: bool) -> None: ...


class MeshDisplacementInfo:
    def __init__(self, texture: RenderTexture, mapping: TextureMapping): ...
    @property
    def Black(self) -> float: ...
    @property
    def BlackMove(self) -> float: ...
    @property
    def ChannelNumber(self) -> int: ...
    @property
    def FaceLimit(self) -> int: ...
    @property
    def FairingAmount(self) -> int: ...
    @property
    def InstanceTransform(self) -> Transform: ...
    @property
    def Mapping(self) -> TextureMapping: ...
    @property
    def MappingTransform(self) -> Transform: ...
    @property
    def MemoryLimit(self) -> int: ...
    @property
    def PostWeldAngle(self) -> float: ...
    @property
    def RefineSensitivity(self) -> float: ...
    @property
    def RefineStepCount(self) -> int: ...
    @property
    def SweepPitch(self) -> float: ...
    @property
    def Texture(self) -> RenderTexture: ...
    @property
    def White(self) -> float: ...
    @property
    def WhiteMove(self) -> float: ...
    @Black.setter
    def Black(self, value: float) -> None: ...
    @BlackMove.setter
    def BlackMove(self, value: float) -> None: ...
    @ChannelNumber.setter
    def ChannelNumber(self, value: int) -> None: ...
    @FaceLimit.setter
    def FaceLimit(self, value: int) -> None: ...
    @FairingAmount.setter
    def FairingAmount(self, value: int) -> None: ...
    @InstanceTransform.setter
    def InstanceTransform(self, value: Transform) -> None: ...
    @MappingTransform.setter
    def MappingTransform(self, value: Transform) -> None: ...
    @MemoryLimit.setter
    def MemoryLimit(self, value: int) -> None: ...
    @PostWeldAngle.setter
    def PostWeldAngle(self, value: float) -> None: ...
    @RefineSensitivity.setter
    def RefineSensitivity(self, value: float) -> None: ...
    @RefineStepCount.setter
    def RefineStepCount(self, value: int) -> None: ...
    @SweepPitch.setter
    def SweepPitch(self, value: float) -> None: ...
    @White.setter
    def White(self, value: float) -> None: ...
    @WhiteMove.setter
    def WhiteMove(self, value: float) -> None: ...


class MeshExtruder:
    def __init__(self, inputMesh: Mesh, componentIndices: Iterable[ComponentIndex]): ...
    def Dispose(self) -> None: ...
    @overload
    def ExtrudedMesh(self) -> Tuple[bool, Mesh]: ...
    @overload
    def ExtrudedMesh(self) -> Tuple[bool, Mesh, List]: ...
    @property
    def EdgeBasedUVN(self) -> bool: ...
    @property
    def FaceDirectionMode(self) -> MeshExtruderFaceDirectionMode: ...
    @property
    def KeepOriginalFaces(self) -> bool: ...
    @property
    def PreviewLines(self) -> Set(Line): ...
    @property
    def SurfaceParameterMode(self) -> MeshExtruderParameterMode: ...
    @property
    def TextureCoordinateMode(self) -> MeshExtruderParameterMode: ...
    @property
    def Transform(self) -> Transform: ...
    @property
    def UVN(self) -> bool: ...
    def GetWallFaces(self) -> List: ...
    @EdgeBasedUVN.setter
    def EdgeBasedUVN(self, value: bool) -> None: ...
    @FaceDirectionMode.setter
    def FaceDirectionMode(self, value: MeshExtruderFaceDirectionMode) -> None: ...
    @KeepOriginalFaces.setter
    def KeepOriginalFaces(self, value: bool) -> None: ...
    @SurfaceParameterMode.setter
    def SurfaceParameterMode(self, value: MeshExtruderParameterMode) -> None: ...
    @TextureCoordinateMode.setter
    def TextureCoordinateMode(self, value: MeshExtruderParameterMode) -> None: ...
    @Transform.setter
    def Transform(self, value: Transform) -> None: ...
    @UVN.setter
    def UVN(self, value: bool) -> None: ...


class MeshExtruderFaceDirectionMode:
    Keep = 0
    OrientClosedFrontOut = 1


class MeshExtruderParameterMode:
    CoverWalls = 0
    KeepAndStretch = 1


class MeshFace:
    @overload
    def __init__(self, a: int, b: int, c: int): ...
    @overload
    def __init__(self, a: int, b: int, c: int, d: int): ...
    def CompareTo(self, other: MeshFace) -> int: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, other: MeshFace) -> bool: ...
    def Flip(self) -> MeshFace: ...
    @property
    def A(self) -> int: ...
    @property
    def B(self) -> int: ...
    @property
    def C(self) -> int: ...
    @property
    def D(self) -> int: ...
    @property
    def IsQuad(self) -> bool: ...
    @property
    def IsTriangle(self) -> bool: ...
    @property
    def Item(self, index: int) -> int: ...
    @property
    def Unset() -> MeshFace: ...
    def GetHashCode(self) -> int: ...
    @overload
    def IsValid(self) -> bool: ...
    @overload
    def IsValid(self, vertexCount: int) -> bool: ...
    @overload
    def IsValid(self, points: Set(Point3d)) -> bool: ...
    def IsValidEx(self, points: Set(Point3d)) -> Tuple[bool, Set(Point3d)]: ...
    def op_Equality(a: MeshFace, b: MeshFace) -> bool: ...
    def op_Inequality(a: MeshFace, b: MeshFace) -> bool: ...
    def Repair(self, points: Set(Point3d)) -> bool: ...
    def RepairEx(self, points: Set(Point3d)) -> Tuple[bool, Set(Point3d)]: ...
    @A.setter
    def A(self, value: int) -> None: ...
    @B.setter
    def B(self, value: int) -> None: ...
    @C.setter
    def C(self, value: int) -> None: ...
    @D.setter
    def D(self, value: int) -> None: ...
    @Item.setter
    def Item(self, index: int, value: int) -> None: ...
    @overload
    def Set(self, a: int, b: int, c: int) -> None: ...
    @overload
    def Set(self, a: int, b: int, c: int, d: int) -> None: ...
    def ToString(self) -> str: ...


class MeshingParameters:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, density: float): ...
    @overload
    def __init__(self, density: float, minimumEdgeLength: float): ...
    def Dispose(self) -> None: ...
    def DocumentCurrentSetting(doc: RhinoDoc) -> MeshingParameters: ...
    @property
    def ClosedObjectPostProcess(self) -> bool: ...
    @property
    def Coarse() -> MeshingParameters: ...
    @property
    def ComputeCurvature(self) -> bool: ...
    @property
    def Default() -> MeshingParameters: ...
    @property
    def DefaultAnalysisMesh() -> MeshingParameters: ...
    @property
    def FastRenderMesh() -> MeshingParameters: ...
    @property
    def GridAmplification(self) -> float: ...
    @property
    def GridAngle(self) -> float: ...
    @property
    def GridAspectRatio(self) -> float: ...
    @property
    def GridMaxCount(self) -> int: ...
    @property
    def GridMinCount(self) -> int: ...
    @property
    def JaggedSeams(self) -> bool: ...
    @property
    def MaximumEdgeLength(self) -> float: ...
    @property
    def Minimal() -> MeshingParameters: ...
    @property
    def MinimumEdgeLength(self) -> float: ...
    @property
    def MinimumTolerance(self) -> float: ...
    @property
    def QualityRenderMesh() -> MeshingParameters: ...
    @property
    def RefineAngle(self) -> float: ...
    @property
    def RefineGrid(self) -> bool: ...
    @property
    def RelativeTolerance(self) -> float: ...
    @property
    def SimplePlanes(self) -> bool: ...
    @property
    def Smooth() -> MeshingParameters: ...
    @property
    def TextureRange(self) -> MeshingParameterTextureRange: ...
    @property
    def Tolerance(self) -> float: ...
    @ClosedObjectPostProcess.setter
    def ClosedObjectPostProcess(self, value: bool) -> None: ...
    @ComputeCurvature.setter
    def ComputeCurvature(self, value: bool) -> None: ...
    @GridAmplification.setter
    def GridAmplification(self, value: float) -> None: ...
    @GridAngle.setter
    def GridAngle(self, value: float) -> None: ...
    @GridAspectRatio.setter
    def GridAspectRatio(self, value: float) -> None: ...
    @GridMaxCount.setter
    def GridMaxCount(self, value: int) -> None: ...
    @GridMinCount.setter
    def GridMinCount(self, value: int) -> None: ...
    @JaggedSeams.setter
    def JaggedSeams(self, value: bool) -> None: ...
    @MaximumEdgeLength.setter
    def MaximumEdgeLength(self, value: float) -> None: ...
    @MinimumEdgeLength.setter
    def MinimumEdgeLength(self, value: float) -> None: ...
    @MinimumTolerance.setter
    def MinimumTolerance(self, value: float) -> None: ...
    @RefineAngle.setter
    def RefineAngle(self, value: float) -> None: ...
    @RefineGrid.setter
    def RefineGrid(self, value: bool) -> None: ...
    @RelativeTolerance.setter
    def RelativeTolerance(self, value: float) -> None: ...
    @SimplePlanes.setter
    def SimplePlanes(self, value: bool) -> None: ...
    @TextureRange.setter
    def TextureRange(self, value: MeshingParameterTextureRange) -> None: ...
    @Tolerance.setter
    def Tolerance(self, value: float) -> None: ...


class MeshingParameterStyle:
    #None = 0
    Fast = 1
    Quality = 2
    Custom = 9
    PerObject = 10


class MeshingParameterTextureRange:
    Unset = 0
    UnpackedUnscaledNormalized = 1
    PackedScaledNormalized = 2


class MeshNgon:
    def BoundaryVertexIndexList(self) -> Set(UInt32): ...
    def CompareTo(self, otherNgon: MeshNgon) -> int: ...
    def Create(meshVertexIndexList: List[int], meshFaceIndexList: List[int]) -> MeshNgon: ...
    @overload
    def Equals(self, otherNgon: MeshNgon) -> bool: ...
    @overload
    def Equals(self, otherObj: Object) -> bool: ...
    def FaceIndexList(self) -> Set(UInt32): ...
    @property
    def BoundaryVertexCount(self) -> int: ...
    @property
    def Empty() -> MeshNgon: ...
    @property
    def FaceCount(self) -> int: ...
    @property
    def Item(self, index: int) -> int: ...
    def GetHashCode(self) -> int: ...
    def op_Equality(a: MeshNgon, b: MeshNgon) -> bool: ...
    def op_Inequality(a: MeshNgon, b: MeshNgon) -> bool: ...
    def Set(self, meshVertexIndexList: List[int], meshFaceIndexList: List[int]) -> None: ...
    def ToString(self) -> str: ...


class MeshPart:
    @property
    def EndFaceIndex(self) -> int: ...
    @property
    def EndVertexIndex(self) -> int: ...
    @property
    def StartFaceIndex(self) -> int: ...
    @property
    def StartVertexIndex(self) -> int: ...
    @property
    def TriangleCount(self) -> int: ...
    @property
    def VertexCount(self) -> int: ...


class MeshPipeCapStyle:
    #None = 0
    Flat = 1
    Box = 2
    Dome = 3


class MeshPoint:
    @property
    def ComponentIndex(self) -> ComponentIndex: ...
    @property
    def EdgeIndex(self) -> int: ...
    @property
    def EdgeParameter(self) -> float: ...
    @property
    def FaceIndex(self) -> int: ...
    @property
    def Mesh(self) -> Mesh: ...
    @property
    def Point(self) -> Point3d: ...
    @property
    def T(self) -> Set(float): ...
    @property
    def Triangle(self) -> Char: ...
    def GetTriangle(self) -> Tuple[bool, int, int, int]: ...


class MeshThicknessMeasurement:
    def __init__(self, meshIndex: int, vertexIndex: int, thickness: float, point: Point3d, oppositePoint: Point3d): ...
    @property
    def MeshIndex(self) -> int: ...
    @property
    def OppositePoint(self) -> Point3d: ...
    @property
    def Point(self) -> Point3d: ...
    @property
    def Thickness(self) -> float: ...
    @property
    def VertexIndex(self) -> int: ...


class MeshType:
    Default = 0
    Render = 1
    Analysis = 2
    Preview = 3
    Any = 4


class MeshUnsafeLock:
    def FacesArray(self) -> Tuple[MeshFace, int]: ...
    def NormalVector3fArray(self) -> Tuple[Vector3f, int]: ...
    def Release(self) -> None: ...
    def VertexPoint3dArray(self) -> Tuple[Point3d, int]: ...
    def VertexPoint3fArray(self) -> Tuple[Point3f, int]: ...


class MorphControl(GeometryBase):
    def __init__(self, originCurve: NurbsCurve, targetCurve: NurbsCurve): ...
    @property
    def Curve(self) -> NurbsCurve: ...
    @property
    def PreserveStructure(self) -> bool: ...
    @property
    def QuickPreview(self) -> bool: ...
    @property
    def SpaceMorphTolerance(self) -> float: ...
    @property
    def Surface(self) -> NurbsSurface: ...
    def Morph(self, geometry: GeometryBase) -> bool: ...
    @PreserveStructure.setter
    def PreserveStructure(self, value: bool) -> None: ...
    @QuickPreview.setter
    def QuickPreview(self, value: bool) -> None: ...
    @SpaceMorphTolerance.setter
    def SpaceMorphTolerance(self, value: float) -> None: ...


class NurbsCurve(Curve):
    @overload
    def __init__(self, other: NurbsCurve): ...
    @overload
    def __init__(self, degree: int, pointCount: int): ...
    @overload
    def __init__(self, dimension: int, rational: bool, order: int, pointCount: int): ...
    def Create(periodic: bool, degree: int, points: Iterable[Point3d]) -> NurbsCurve: ...
    @overload
    def CreateFromArc(arc: Arc) -> NurbsCurve: ...
    @overload
    def CreateFromArc(arc: Arc, degree: int, cvCount: int) -> NurbsCurve: ...
    @overload
    def CreateFromCircle(circle: Circle) -> NurbsCurve: ...
    @overload
    def CreateFromCircle(circle: Circle, degree: int, cvCount: int) -> NurbsCurve: ...
    def CreateFromEllipse(ellipse: Ellipse) -> NurbsCurve: ...
    def CreateFromLine(line: Line) -> NurbsCurve: ...
    @overload
    def CreateHSpline(points: Iterable[Point3d]) -> NurbsCurve: ...
    @overload
    def CreateHSpline(points: Iterable[Point3d], startTangent: Vector3d, endTangent: Vector3d) -> NurbsCurve: ...
    def CreateParabolaFromFocus(focus: Point3d, startPoint: Point3d, endPoint: Point3d) -> NurbsCurve: ...
    def CreateParabolaFromVertex(vertex: Point3d, startPoint: Point3d, endPoint: Point3d) -> NurbsCurve: ...
    def CreatePlanarRailFrames(self, parameters: Iterable[float], normal: Vector3d) -> Set(Plane): ...
    def CreateRailFrames(self, parameters: Iterable[float]) -> Set(Plane): ...
    @overload
    def CreateSpiral(axisStart: Point3d, axisDir: Vector3d, radiusPoint: Point3d, pitch: float, turnCount: float, radius0: float, radius1: float) -> NurbsCurve: ...
    @overload
    def CreateSpiral(railCurve: Curve, t0: float, t1: float, radiusPoint: Point3d, pitch: float, turnCount: float, radius0: float, radius1: float, pointsPerTurn: int) -> NurbsCurve: ...
    @overload
    def CreateSubDFriendly(curve: Curve) -> NurbsCurve: ...
    @overload
    def CreateSubDFriendly(points: Iterable[Point3d], interpolatePoints: bool, periodicClosedCurve: bool) -> NurbsCurve: ...
    @overload
    def CreateSubDFriendly(curve: Curve, pointCount: int, periodicClosedCurve: bool) -> NurbsCurve: ...
    def EpsilonEquals(self, other: NurbsCurve, epsilon: float) -> bool: ...
    @property
    def HasBezierSpans(self) -> bool: ...
    @property
    def IsRational(self) -> bool: ...
    @property
    def Knots(self) -> NurbsCurveKnotList: ...
    @property
    def Order(self) -> int: ...
    @property
    def Points(self) -> NurbsCurvePointList: ...
    def GrevilleParameter(self, index: int) -> float: ...
    def GrevilleParameters(self) -> Set(float): ...
    def GrevillePoint(self, index: int) -> Point3d: ...
    @overload
    def GrevillePoints(self) -> Point3dList: ...
    @overload
    def GrevillePoints(self, all: bool) -> Point3dList: ...
    def IncreaseDegree(self, desiredDegree: int) -> bool: ...
    def IsDuplicate(curveA: NurbsCurve, curveB: NurbsCurve, ignoreParameterization: bool, tolerance: float) -> bool: ...
    def MakeCompatible(curves: Iterable[Curve], startPt: Point3d, endPt: Point3d, simplifyMethod: int, numPoints: int, refitTolerance: float, angleTolerance: float) -> Set(NurbsCurve): ...
    def MakePiecewiseBezier(self, setEndWeightsToOne: bool) -> bool: ...
    def Reparameterize(self, c: float) -> bool: ...
    @overload
    def SetEndCondition(self, bSetEnd: bool, continuity: NurbsCurveEndConditionType, point: Point3d, tangent: Vector3d) -> bool: ...
    @overload
    def SetEndCondition(self, bSetEnd: bool, continuity: NurbsCurveEndConditionType, point: Point3d, tangent: Vector3d, curvature: Vector3d) -> bool: ...
    def SetGrevillePoints(self, points: Iterable[Point3d]) -> bool: ...
    def UVNDirectionsAt(self, t: float) -> Tuple[bool, Vector3d, Vector3d, Vector3d]: ...


class NurbsCurveEndConditionType:
    Nothing = 0
    Position = 1
    Tangency = 2
    Curvature = 3


class NurbsSurface(Surface):
    def __init__(self, other: NurbsSurface): ...
    def ConvertSpanToBezier(self, spanIndex0: int, spanIndex1: int) -> BezierSurface: ...
    def CopyFrom(self, other: NurbsSurface) -> None: ...
    def Create(dimension: int, isRational: bool, order0: int, order1: int, controlPointCount0: int, controlPointCount1: int) -> NurbsSurface: ...
    def CreateCurveOnSurface(surface: Surface, points: Iterable[Point2d], tolerance: float, periodic: bool) -> NurbsCurve: ...
    def CreateCurveOnSurfacePoints(surface: Surface, fixedPoints: Iterable[Point2d], tolerance: float, periodic: bool, initCount: int, levels: int) -> Set(Point2d): ...
    def CreateFromCone(cone: Cone) -> NurbsSurface: ...
    @overload
    def CreateFromCorners(corner1: Point3d, corner2: Point3d, corner3: Point3d) -> NurbsSurface: ...
    @overload
    def CreateFromCorners(corner1: Point3d, corner2: Point3d, corner3: Point3d, corner4: Point3d) -> NurbsSurface: ...
    @overload
    def CreateFromCorners(corner1: Point3d, corner2: Point3d, corner3: Point3d, corner4: Point3d, tolerance: float) -> NurbsSurface: ...
    def CreateFromCylinder(cylinder: Cylinder) -> NurbsSurface: ...
    def CreateFromPlane(plane: Plane, uInterval: Interval, vInterval: Interval, uDegree: int, vDegree: int, uPointCount: int, vPointCount: int) -> NurbsSurface: ...
    def CreateFromPoints(points: Iterable[Point3d], uCount: int, vCount: int, uDegree: int, vDegree: int) -> NurbsSurface: ...
    def CreateFromSphere(sphere: Sphere) -> NurbsSurface: ...
    def CreateFromTorus(torus: Torus) -> NurbsSurface: ...
    @overload
    def CreateNetworkSurface(curves: Iterable[Curve], continuity: int, edgeTolerance: float, interiorTolerance: float, angleTolerance: float) -> Tuple[NurbsSurface, int]: ...
    @overload
    def CreateNetworkSurface(uCurves: Iterable[Curve], uContinuityStart: int, uContinuityEnd: int, vCurves: Iterable[Curve], vContinuityStart: int, vContinuityEnd: int, edgeTolerance: float, interiorTolerance: float, angleTolerance: float) -> Tuple[NurbsSurface, int]: ...
    def CreateRailRevolvedSurface(profile: Curve, rail: Curve, axis: Line, scaleHeight: bool) -> NurbsSurface: ...
    def CreateRuledSurface(curveA: Curve, curveB: Curve) -> NurbsSurface: ...
    def CreateSubDFriendly(surface: Surface) -> NurbsSurface: ...
    def CreateThroughPoints(points: Iterable[Point3d], uCount: int, vCount: int, uDegree: int, vDegree: int, uClosed: bool, vClosed: bool) -> NurbsSurface: ...
    def EpsilonEquals(self, other: NurbsSurface, epsilon: float) -> bool: ...
    @property
    def IsRational(self) -> bool: ...
    @property
    def KnotsU(self) -> NurbsSurfaceKnotList: ...
    @property
    def KnotsV(self) -> NurbsSurfaceKnotList: ...
    @property
    def OrderU(self) -> int: ...
    @property
    def OrderV(self) -> int: ...
    @property
    def Points(self) -> NurbsSurfacePointList: ...
    def IncreaseDegreeU(self, desiredDegree: int) -> bool: ...
    def IncreaseDegreeV(self, desiredDegree: int) -> bool: ...
    def MakeCompatible(surface0: Surface, surface1: Surface) -> Tuple[bool, NurbsSurface, NurbsSurface]: ...
    def MakeNonRational(self) -> bool: ...
    def MakeRational(self) -> bool: ...
    def UVNDirectionsAt(self, u: float, v: float) -> Tuple[bool, Vector3d, Vector3d, Vector3d]: ...


class NurbsSurfaceType:
    Unset = 0
    Large = 1
    Medium = 2
    Small = 3
    Unprocessed = 4


class OrdinateDimension(Dimension):
    def __init__(self): ...
    def AdjustFromPoints(self, plane: Plane, direction: MeasuredDirection, basepoint: Point3d, defpoint: Point3d, leaderpoint: Point3d, kinkoffset1: float, kinkoffset2: float) -> bool: ...
    def Create(dimStyle: DimensionStyle, plane: Plane, direction: MeasuredDirection, basepoint: Point3d, defpoint: Point3d, leaderpoint: Point3d, kinkoffset1: float, kinkoffset2: float) -> OrdinateDimension: ...
    @property
    def DefPoint(self) -> Point2d: ...
    @property
    def KinkOffset1(self) -> float: ...
    @property
    def KinkOffset2(self) -> float: ...
    @property
    def KinkPoint1(self) -> Point2d: ...
    @property
    def KinkPoint2(self) -> Point2d: ...
    @property
    def LeaderPoint(self) -> Point2d: ...
    def Get3dPoints(self) -> Tuple[bool, Point3d, Point3d, Point3d, Point3d, Point3d]: ...
    def GetDisplayLines(self, style: DimensionStyle, scale: float) -> Tuple[bool, Iterable[Line]]: ...
    def GetDistanceDisplayText(self, unitsystem: UnitSystem, style: DimensionStyle) -> str: ...
    def GetTextRectangle(self) -> Tuple[bool, Set(Point3d)]: ...
    @DefPoint.setter
    def DefPoint(self, value: Point2d) -> None: ...
    @KinkOffset1.setter
    def KinkOffset1(self, value: float) -> None: ...
    @KinkOffset2.setter
    def KinkOffset2(self, value: float) -> None: ...
    @LeaderPoint.setter
    def LeaderPoint(self, value: Point2d) -> None: ...


class Particle:
    def __init__(self): ...
    @property
    def Color(self) -> Color: ...
    @property
    def DisplayBitmapIndex(self) -> int: ...
    @property
    def Index(self) -> int: ...
    @property
    def Location(self) -> Point3d: ...
    @property
    def ParentSystem(self) -> ParticleSystem: ...
    @property
    def Size(self) -> Single: ...
    @Color.setter
    def Color(self, value: Color) -> None: ...
    @DisplayBitmapIndex.setter
    def DisplayBitmapIndex(self, value: int) -> None: ...
    @Location.setter
    def Location(self, value: Point3d) -> None: ...
    @Size.setter
    def Size(self, value: Single) -> None: ...
    def Update(self) -> None: ...


class ParticleSystem:
    def __init__(self): ...
    def Add(self, particle: Particle) -> bool: ...
    def Clear(self) -> None: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def DisplaySizesInWorldUnits(self) -> bool: ...
    @property
    def DrawRequiresDepthSorting(self) -> bool: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def Remove(self, particle: Particle) -> None: ...
    @DisplaySizesInWorldUnits.setter
    def DisplaySizesInWorldUnits(self, value: bool) -> None: ...
    @DrawRequiresDepthSorting.setter
    def DrawRequiresDepthSorting(self, value: bool) -> None: ...
    def Update(self) -> None: ...


class PipeCapMode:
    #None = 0
    Flat = 1
    Round = 2


class Plane:
    @overload
    def __init__(self, other: Plane): ...
    @overload
    def __init__(self, origin: Point3d, normal: Vector3d): ...
    @overload
    def __init__(self, origin: Point3d, xDirection: Vector3d, yDirection: Vector3d): ...
    @overload
    def __init__(self, origin: Point3d, xPoint: Point3d, yPoint: Point3d): ...
    @overload
    def __init__(self, a: float, b: float, c: float, d: float): ...
    def Clone(self) -> Plane: ...
    def ClosestParameter(self, testPoint: Point3d) -> Tuple[bool, float, float]: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    @overload
    def DistanceTo(self, testPoint: Point3d) -> float: ...
    @overload
    def DistanceTo(self, bbox: BoundingBox) -> Tuple[bool, float, float]: ...
    def EpsilonEquals(self, other: Plane, epsilon: float) -> bool: ...
    @overload
    def Equals(self, plane: Plane) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def ExtendThroughBox(self, box: Box) -> Tuple[bool, Interval, Interval]: ...
    @overload
    def ExtendThroughBox(self, box: BoundingBox) -> Tuple[bool, Interval, Interval]: ...
    @overload
    def FitPlaneToPoints(points: Iterable[Point3d]) -> Tuple[PlaneFitResult, Plane]: ...
    @overload
    def FitPlaneToPoints(points: Iterable[Point3d]) -> Tuple[PlaneFitResult, Plane, float]: ...
    def Flip(self) -> None: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Normal(self) -> Vector3d: ...
    @property
    def Origin(self) -> Point3d: ...
    @property
    def OriginX(self) -> float: ...
    @property
    def OriginY(self) -> float: ...
    @property
    def OriginZ(self) -> float: ...
    @property
    def Unset() -> Plane: ...
    @property
    def WorldXY() -> Plane: ...
    @property
    def WorldYZ() -> Plane: ...
    @property
    def WorldZX() -> Plane: ...
    @property
    def XAxis(self) -> Vector3d: ...
    @property
    def YAxis(self) -> Vector3d: ...
    @property
    def ZAxis(self) -> Vector3d: ...
    def GetHashCode(self) -> int: ...
    def GetPlaneEquation(self) -> Set(float): ...
    def op_Equality(a: Plane, b: Plane) -> bool: ...
    def op_Inequality(a: Plane, b: Plane) -> bool: ...
    @overload
    def PointAt(self, u: float, v: float) -> Point3d: ...
    @overload
    def PointAt(self, u: float, v: float, w: float) -> Point3d: ...
    def RemapToPlaneSpace(self, ptSample: Point3d) -> Tuple[bool, Point3d]: ...
    @overload
    def Rotate(self, angle: float, axis: Vector3d) -> bool: ...
    @overload
    def Rotate(self, angle: float, axis: Vector3d, centerOfRotation: Point3d) -> bool: ...
    @overload
    def Rotate(self, sinAngle: float, cosAngle: float, axis: Vector3d) -> bool: ...
    @overload
    def Rotate(self, sinAngle: float, cosAngle: float, axis: Vector3d, centerOfRotation: Point3d) -> bool: ...
    @Origin.setter
    def Origin(self, value: Point3d) -> None: ...
    @OriginX.setter
    def OriginX(self, value: float) -> None: ...
    @OriginY.setter
    def OriginY(self, value: float) -> None: ...
    @OriginZ.setter
    def OriginZ(self, value: float) -> None: ...
    @XAxis.setter
    def XAxis(self, value: Vector3d) -> None: ...
    @YAxis.setter
    def YAxis(self, value: Vector3d) -> None: ...
    @ZAxis.setter
    def ZAxis(self, value: Vector3d) -> None: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Translate(self, delta: Vector3d) -> bool: ...
    def UpdateEquation(self) -> bool: ...
    def ValueAt(self, p: Point3d) -> float: ...


class PlaneFitResult:
    Success = 0
    Inconclusive = 1
    Failure = -1


class PlaneSurface(Surface):
    def __init__(self, plane: Plane, xExtents: Interval, yExtents: Interval): ...
    @overload
    def CreateThroughBox(plane: Plane, box: BoundingBox) -> PlaneSurface: ...
    @overload
    def CreateThroughBox(lineInPlane: Line, vectorInPlane: Vector3d, box: BoundingBox) -> PlaneSurface: ...


class Point(GeometryBase):
    def __init__(self, location: Point3d): ...
    @property
    def Location(self) -> Point3d: ...
    @Location.setter
    def Location(self, value: Point3d) -> None: ...


class Point2d:
    @overload
    def __init__(self, vector: Vector2d): ...
    @overload
    def __init__(self, point: Point2d): ...
    @overload
    def __init__(self, point: Point3d): ...
    @overload
    def __init__(self, x: float, y: float): ...
    @overload
    def Add(point1: Point2d, point2: Point2d) -> Point2d: ...
    @overload
    def Add(vector: Vector2d, point: Point2d) -> Point2d: ...
    @overload
    def Add(point: Point2d, vector: Vector2d) -> Point2d: ...
    def CompareTo(self, other: Point2d) -> int: ...
    def DistanceTo(self, other: Point2d) -> float: ...
    def Divide(point: Point2d, t: float) -> Point2d: ...
    def EpsilonEquals(self, other: Point2d, epsilon: float) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, point: Point2d) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Item(self, index: int) -> float: ...
    @property
    def MaximumCoordinate(self) -> float: ...
    @property
    def MinimumCoordinate(self) -> float: ...
    @property
    def Origin() -> Point2d: ...
    @property
    def Unset() -> Point2d: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    def GetHashCode(self) -> int: ...
    @overload
    def Multiply(point: Point2d, t: float) -> Point2d: ...
    @overload
    def Multiply(t: float, point: Point2d) -> Point2d: ...
    @overload
    def op_Addition(point: Point2d, vector: Vector2d) -> Point2d: ...
    @overload
    def op_Addition(vector: Vector2d, point: Point2d) -> Point2d: ...
    @overload
    def op_Addition(point1: Point2d, point2: Point2d) -> Point2d: ...
    def op_Division(point: Point2d, t: float) -> Point2d: ...
    def op_Equality(a: Point2d, b: Point2d) -> bool: ...
    def op_GreaterThan(a: Point2d, b: Point2d) -> bool: ...
    def op_GreaterThanOrEqual(a: Point2d, b: Point2d) -> bool: ...
    def op_Inequality(a: Point2d, b: Point2d) -> bool: ...
    def op_LessThan(a: Point2d, b: Point2d) -> bool: ...
    def op_LessThanOrEqual(a: Point2d, b: Point2d) -> bool: ...
    @overload
    def op_Multiply(t: float, point: Point2d) -> Point2d: ...
    @overload
    def op_Multiply(point: Point2d, t: float) -> Point2d: ...
    @overload
    def op_Subtraction(point1: Point2d, point2: Point2d) -> Vector2d: ...
    @overload
    def op_Subtraction(point: Point2d, vector: Vector2d) -> Point2d: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @overload
    def Subtract(point: Point2d, vector: Vector2d) -> Point2d: ...
    @overload
    def Subtract(point1: Point2d, point2: Point2d) -> Vector2d: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, xform: Transform) -> None: ...


class Point2f:
    @overload
    def __init__(self, x: Single, y: Single): ...
    @overload
    def __init__(self, x: float, y: float): ...
    def CompareTo(self, other: Point2f) -> int: ...
    def EpsilonEquals(self, other: Point2f, epsilon: Single) -> bool: ...
    @overload
    def Equals(self, point: Point2f) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Item(self, index: int) -> Single: ...
    @property
    def Unset() -> Point2f: ...
    @property
    def X(self) -> Single: ...
    @property
    def Y(self) -> Single: ...
    def GetHashCode(self) -> int: ...
    def op_Addition(a: Point2f, b: Point2f) -> Vector2f: ...
    def op_Division(a: Point2f, b: Single) -> Point2f: ...
    def op_Equality(a: Point2f, b: Point2f) -> bool: ...
    def op_Explicit(point: Point2d) -> Point2f: ...
    def op_GreaterThan(a: Point2f, b: Point2f) -> bool: ...
    def op_GreaterThanOrEqual(a: Point2f, b: Point2f) -> bool: ...
    def op_Inequality(a: Point2f, b: Point2f) -> bool: ...
    def op_LessThan(a: Point2f, b: Point2f) -> bool: ...
    def op_LessThanOrEqual(a: Point2f, b: Point2f) -> bool: ...
    def op_Multiply(a: Point2f, b: Single) -> Point2f: ...
    def op_Subtraction(a: Point2f, b: Point2f) -> Vector2f: ...
    @Item.setter
    def Item(self, index: int, value: Single) -> None: ...
    @X.setter
    def X(self, value: Single) -> None: ...
    @Y.setter
    def Y(self, value: Single) -> None: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...


class Point3d:
    @overload
    def __init__(self, vector: Vector3d): ...
    @overload
    def __init__(self, point: Point3f): ...
    @overload
    def __init__(self, point: Point3d): ...
    @overload
    def __init__(self, point: Point4d): ...
    @overload
    def __init__(self, x: float, y: float, z: float): ...
    @overload
    def Add(point: Point3d, vector: Vector3d) -> Point3d: ...
    @overload
    def Add(vector: Vector3d, point: Point3d) -> Point3d: ...
    @overload
    def Add(point1: Point3d, point2: Point3d) -> Point3d: ...
    @overload
    def Add(point: Point3d, vector: Vector3f) -> Point3d: ...
    def ArePointsCoplanar(points: Iterable[Point3d], tolerance: float) -> bool: ...
    def CompareTo(self, other: Point3d) -> int: ...
    def CullDuplicates(points: Iterable[Point3d], tolerance: float) -> Set(Point3d): ...
    def DistanceTo(self, other: Point3d) -> float: ...
    def DistanceToSquared(self, other: Point3d) -> float: ...
    def Divide(point: Point3d, t: float) -> Point3d: ...
    def EpsilonEquals(self, other: Point3d, epsilon: float) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, point: Point3d) -> bool: ...
    def FromPoint3f(point: Point3f) -> Point3d: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Item(self, index: int) -> float: ...
    @property
    def MaximumCoordinate(self) -> float: ...
    @property
    def MinimumCoordinate(self) -> float: ...
    @property
    def Origin() -> Point3d: ...
    @property
    def Unset() -> Point3d: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    def GetHashCode(self) -> int: ...
    def Interpolate(self, pA: Point3d, pB: Point3d, t: float) -> None: ...
    @overload
    def Multiply(t: float, point: Point3d) -> Point3d: ...
    @overload
    def Multiply(point: Point3d, t: float) -> Point3d: ...
    @overload
    def op_Addition(point: Point3d, vector: Vector3f) -> Point3d: ...
    @overload
    def op_Addition(point: Point3d, vector: Vector3d) -> Point3d: ...
    @overload
    def op_Addition(point1: Point3d, point2: Point3d) -> Point3d: ...
    @overload
    def op_Addition(vector: Vector3d, point: Point3d) -> Point3d: ...
    def op_Division(point: Point3d, t: float) -> Point3d: ...
    def op_Equality(a: Point3d, b: Point3d) -> bool: ...
    @overload
    def op_Explicit(vector: Vector3d) -> Point3d: ...
    @overload
    def op_Explicit(point: Point3d) -> Vector3d: ...
    def op_GreaterThan(a: Point3d, b: Point3d) -> bool: ...
    def op_GreaterThanOrEqual(a: Point3d, b: Point3d) -> bool: ...
    @overload
    def op_Implicit(pt: Point3d) -> ControlPoint: ...
    @overload
    def op_Implicit(point: Point3f) -> Point3d: ...
    def op_Inequality(a: Point3d, b: Point3d) -> bool: ...
    def op_LessThan(a: Point3d, b: Point3d) -> bool: ...
    def op_LessThanOrEqual(a: Point3d, b: Point3d) -> bool: ...
    @overload
    def op_Multiply(t: float, point: Point3d) -> Point3d: ...
    @overload
    def op_Multiply(point: Point3d, t: float) -> Point3d: ...
    @overload
    def op_Subtraction(point1: Point3d, point2: Point3d) -> Vector3d: ...
    @overload
    def op_Subtraction(point: Point3d, vector: Vector3d) -> Point3d: ...
    def op_UnaryNegation(point: Point3d) -> Point3d: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    def SortAndCullPointList(points: Iterable[Point3d], minimumDistance: float) -> Set(Point3d): ...
    @overload
    def Subtract(point1: Point3d, point2: Point3d) -> Vector3d: ...
    @overload
    def Subtract(point: Point3d, vector: Vector3d) -> Point3d: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, xform: Transform) -> None: ...
    def TryParse(input: str) -> Tuple[bool, Point3d]: ...


class Point3dGrid(GeometryBase):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, rows: int, columns: int): ...


class Point3f:
    def __init__(self, x: Single, y: Single, z: Single): ...
    def CompareTo(self, other: Point3f) -> int: ...
    def DistanceTo(self, other: Point3f) -> float: ...
    def EpsilonEquals(self, other: Point3f, epsilon: Single) -> bool: ...
    @overload
    def Equals(self, point: Point3f) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Origin() -> Point3f: ...
    @property
    def Unset() -> Point3f: ...
    @property
    def X(self) -> Single: ...
    @property
    def Y(self) -> Single: ...
    @property
    def Z(self) -> Single: ...
    def GetHashCode(self) -> int: ...
    def op_Addition(point1: Point3f, point2: Point3f) -> Point3f: ...
    def op_Equality(a: Point3f, b: Point3f) -> bool: ...
    @overload
    def op_Explicit(point: Point3f) -> Vector3f: ...
    @overload
    def op_Explicit(point: Point3d) -> Point3f: ...
    def op_GreaterThan(a: Point3f, b: Point3f) -> bool: ...
    def op_GreaterThanOrEqual(a: Point3f, b: Point3f) -> bool: ...
    def op_Inequality(a: Point3f, b: Point3f) -> bool: ...
    def op_LessThan(a: Point3f, b: Point3f) -> bool: ...
    def op_LessThanOrEqual(a: Point3f, b: Point3f) -> bool: ...
    @overload
    def op_Multiply(value: Single, point: Point3f) -> Point3f: ...
    @overload
    def op_Multiply(point: Point3f, value: Single) -> Point3f: ...
    def op_Subtraction(point1: Point3f, point2: Point3f) -> Vector3f: ...
    @X.setter
    def X(self, value: Single) -> None: ...
    @Y.setter
    def Y(self, value: Single) -> None: ...
    @Z.setter
    def Z(self, value: Single) -> None: ...
    def Subtract(point1: Point3f, point2: Point3f) -> Vector3f: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, xform: Transform) -> None: ...


class Point4d:
    @overload
    def __init__(self, point: Point3d): ...
    @overload
    def __init__(self, point: Point4d): ...
    @overload
    def __init__(self, x: float, y: float, z: float, w: float): ...
    def Add(point1: Point4d, point2: Point4d) -> Point4d: ...
    def EpsilonEquals(self, other: Point4d, epsilon: float) -> bool: ...
    @overload
    def Equals(self, point: Point4d) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Unset() -> Point4d: ...
    @property
    def W(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    def GetHashCode(self) -> int: ...
    def Multiply(point: Point4d, d: float) -> Point4d: ...
    def op_Addition(point1: Point4d, point2: Point4d) -> Point4d: ...
    def op_Equality(a: Point4d, b: Point4d) -> bool: ...
    def op_Inequality(a: Point4d, b: Point4d) -> bool: ...
    @overload
    def op_Multiply(point: Point4d, d: float) -> Point4d: ...
    @overload
    def op_Multiply(point1: Point4d, point2: Point4d) -> float: ...
    def op_Subtraction(point1: Point4d, point2: Point4d) -> Point4d: ...
    @W.setter
    def W(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    def Subtract(point1: Point4d, point2: Point4d) -> Point4d: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, xform: Transform) -> None: ...


class PointCloud(GeometryBase):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: PointCloud): ...
    @overload
    def __init__(self, points: Iterable[Point3d]): ...
    @overload
    def Add(self, point: Point3d) -> None: ...
    @overload
    def Add(self, point: Point3d, color: Color) -> None: ...
    @overload
    def Add(self, point: Point3d, normal: Vector3d) -> None: ...
    @overload
    def Add(self, point: Point3d, normal: Vector3d, color: Color) -> None: ...
    @overload
    def Add(self, point: Point3d, normal: Vector3d, color: Color, value: float) -> None: ...
    @overload
    def AddRange(self, points: Iterable[Point3d]) -> None: ...
    @overload
    def AddRange(self, points: Iterable[Point3d], colors: Iterable[Color]) -> None: ...
    @overload
    def AddRange(self, points: Iterable[Point3d], normals: Iterable[Vector3d]) -> None: ...
    @overload
    def AddRange(self, points: Iterable[Point3d], normals: Iterable[Vector3d], colors: Iterable[Color]) -> None: ...
    @overload
    def AddRange(self, points: Iterable[Point3d], normals: Iterable[Vector3d], colors: Iterable[Color], values: Iterable[float]) -> None: ...
    def AppendNew(self) -> PointCloudItem: ...
    def AsReadOnlyListOfPoints(self) -> IReadOnlyList: ...
    def ClearColors(self) -> None: ...
    def ClearHiddenFlags(self) -> None: ...
    def ClearNormals(self) -> None: ...
    def ClearPointValues(self) -> None: ...
    def ClosestPoint(self, testPoint: Point3d) -> int: ...
    @property
    def ContainsColors(self) -> bool: ...
    @property
    def ContainsHiddenFlags(self) -> bool: ...
    @property
    def ContainsNormals(self) -> bool: ...
    @property
    def ContainsPointValues(self) -> bool: ...
    @property
    def Count(self) -> int: ...
    @property
    def HiddenPointCount(self) -> int: ...
    @property
    def Item(self, index: int) -> PointCloudItem: ...
    def GetColors(self) -> Set(Color): ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetNormals(self) -> Set(Vector3d): ...
    def GetPoints(self) -> Set(Point3d): ...
    def GetPointValues(self) -> Set(float): ...
    @overload
    def GetRandomSubsample(self, numberOfPoints: UInt32) -> PointCloud: ...
    @overload
    def GetRandomSubsample(self, numberOfPoints: UInt32, cancelToken: CancellationToken, progress: IProgress) -> PointCloud: ...
    @overload
    def Insert(self, index: int, point: Point3d) -> None: ...
    @overload
    def Insert(self, index: int, point: Point3d, color: Color) -> None: ...
    @overload
    def Insert(self, index: int, point: Point3d, normal: Vector3d) -> None: ...
    @overload
    def Insert(self, index: int, point: Point3d, normal: Vector3d, color: Color) -> None: ...
    @overload
    def Insert(self, index: int, point: Point3d, normal: Vector3d, color: Color, value: float) -> None: ...
    def InsertNew(self, index: int) -> PointCloudItem: ...
    def InsertRange(self, index: int, points: Iterable[Point3d]) -> None: ...
    def Merge(self, other: PointCloud) -> None: ...
    def PointAt(self, index: int) -> Point3d: ...
    def RemoveAt(self, index: int) -> None: ...
    def RemoveRange(self, indices: Iterable[int]) -> int: ...


class PointCloudItem:
    @property
    def Color(self) -> Color: ...
    @property
    def Hidden(self) -> bool: ...
    @property
    def Index(self) -> int: ...
    @property
    def Location(self) -> Point3d: ...
    @property
    def Normal(self) -> Vector3d: ...
    @property
    def PointValue(self) -> float: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Z(self) -> float: ...
    @Color.setter
    def Color(self, value: Color) -> None: ...
    @Hidden.setter
    def Hidden(self, value: bool) -> None: ...
    @Location.setter
    def Location(self, value: Point3d) -> None: ...
    @Normal.setter
    def Normal(self, value: Vector3d) -> None: ...
    @PointValue.setter
    def PointValue(self, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...


class PointContainment:
    Unset = 0
    Inside = 1
    Outside = 2
    Coincident = 3


class PointFaceRelation:
    Exterior = 0
    Interior = 1
    Boundary = 2


class PolyCurve(Curve):
    def __init__(self): ...
    @overload
    def Append(self, line: Line) -> bool: ...
    @overload
    def Append(self, curve: Curve) -> bool: ...
    @overload
    def Append(self, arc: Arc) -> bool: ...
    def AppendSegment(self, curve: Curve) -> bool: ...
    def CleanUp(self) -> Curve: ...
    def Duplicate(self) -> GeometryBase: ...
    def DuplicatePolyCurve(self) -> PolyCurve: ...
    def Explode(self) -> Set(Curve): ...
    @property
    def HasGap(self) -> bool: ...
    @property
    def IsNested(self) -> bool: ...
    @property
    def SegmentCount(self) -> int: ...
    def PolyCurveParameter(self, segmentIndex: int, segmentCurveParameter: float) -> float: ...
    def RemoveNesting(self) -> bool: ...
    def SegmentCurve(self, index: int) -> Curve: ...
    def SegmentCurveParameter(self, polycurveParameter: float) -> float: ...
    def SegmentDomain(self, segmentIndex: int) -> Interval: ...
    def SegmentIndex(self, polycurveParameter: float) -> int: ...
    def SegmentIndexes(self, subdomain: Interval) -> Tuple[int, int, int]: ...


class Polyline(Point3dList):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initialCapacity: int): ...
    @overload
    def __init__(self, collection: Iterable[Point3d]): ...
    def BreakAtAngles(self, angle: float) -> Set(Polyline): ...
    def CenterPoint(self) -> Point3d: ...
    def ClosestParameter(self, testPoint: Point3d) -> float: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def CollapseShortSegments(self, tolerance: float) -> int: ...
    def CreateCircumscribedPolygon(circle: Circle, sideCount: int) -> Polyline: ...
    def CreateInscribedPolygon(circle: Circle, sideCount: int) -> Polyline: ...
    def CreateStarPolygon(circle: Circle, radius: float, cornerCount: int) -> Polyline: ...
    def DeleteShortSegments(self, tolerance: float) -> int: ...
    @overload
    def Duplicate(self) -> Polyline: ...
    @property
    def IsClosed(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Length(self) -> float: ...
    @property
    def SegmentCount(self) -> int: ...
    def GetSegments(self) -> Set(Line): ...
    def IsClosedWithinTolerance(self, tolerance: float) -> bool: ...
    def MergeColinearSegments(self, angleTolerance: float, includeSeam: bool) -> int: ...
    def PointAt(self, t: float) -> Point3d: ...
    def ReduceSegments(self, tolerance: float) -> int: ...
    def RemoveNearlyEqualSubsequentPoints(self, tolerance: float) -> None: ...
    def SegmentAt(self, index: int) -> Line: ...
    def Smooth(self, amount: float) -> bool: ...
    def TangentAt(self, t: float) -> Vector3d: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...
    def ToPolylineCurve(self) -> PolylineCurve: ...
    def TriangulateClosedPolyline(self) -> Set(MeshFace): ...
    def Trim(self, domain: Interval) -> Polyline: ...


class PolylineCurve(Curve):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, other: PolylineCurve): ...
    @overload
    def __init__(self, points: Iterable[Point3d]): ...
    @property
    def PointCount(self) -> int: ...
    def Parameter(self, index: int) -> float: ...
    def Point(self, index: int) -> Point3d: ...
    def SetParameter(self, index: int, parameter: float) -> None: ...
    def SetPoint(self, index: int, point: Point3d) -> None: ...
    @overload
    def ToPolyline(self) -> Polyline: ...


class PreserveEnd:
    #None = 0
    Position = 1
    Tangency = 2
    Curvature = 3


class QuadRemeshParameters:
    def __init__(self): ...
    @property
    def AdaptiveQuadCount(self) -> bool: ...
    @property
    def AdaptiveSize(self) -> float: ...
    @property
    def DetectHardEdges(self) -> bool: ...
    @property
    def GuideCurveInfluence(self) -> int: ...
    @property
    def PreserveMeshArrayEdgesMode(self) -> int: ...
    @property
    def SymmetryAxis(self) -> QuadRemeshSymmetryAxis: ...
    @property
    def TargetQuadCount(self) -> int: ...
    @AdaptiveQuadCount.setter
    def AdaptiveQuadCount(self, value: bool) -> None: ...
    @AdaptiveSize.setter
    def AdaptiveSize(self, value: float) -> None: ...
    @DetectHardEdges.setter
    def DetectHardEdges(self, value: bool) -> None: ...
    @GuideCurveInfluence.setter
    def GuideCurveInfluence(self, value: int) -> None: ...
    @PreserveMeshArrayEdgesMode.setter
    def PreserveMeshArrayEdgesMode(self, value: int) -> None: ...
    @SymmetryAxis.setter
    def SymmetryAxis(self, value: QuadRemeshSymmetryAxis) -> None: ...
    @TargetQuadCount.setter
    def TargetQuadCount(self, value: int) -> None: ...


class QuadRemeshSymmetryAxis:
    #None = 0
    X = 1
    Y = 2
    Z = 4


class Quaternion:
    def __init__(self, a: float, b: float, c: float, d: float): ...
    def CrossProduct(p: Quaternion, q: Quaternion) -> Quaternion: ...
    def Distance(p: Quaternion, q: Quaternion) -> float: ...
    def DistanceTo(self, q: Quaternion) -> float: ...
    def EpsilonEquals(self, other: Quaternion, epsilon: float) -> bool: ...
    @overload
    def Equals(self, other: Quaternion) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def A(self) -> float: ...
    @property
    def B(self) -> float: ...
    @property
    def C(self) -> float: ...
    @property
    def Conjugate(self) -> Quaternion: ...
    @property
    def D(self) -> float: ...
    @property
    def I() -> Quaternion: ...
    @property
    def Identity() -> Quaternion: ...
    @property
    def Inverse(self) -> Quaternion: ...
    @property
    def IsScalar(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsVector(self) -> bool: ...
    @property
    def IsZero(self) -> bool: ...
    @property
    def J() -> Quaternion: ...
    @property
    def K() -> Quaternion: ...
    @property
    def Length(self) -> float: ...
    @property
    def LengthSquared(self) -> float: ...
    @property
    def Scalar(self) -> float: ...
    @property
    def Vector(self) -> Vector3d: ...
    @property
    def Zero() -> Quaternion: ...
    def GetHashCode(self) -> int: ...
    @overload
    def GetRotation(self) -> Tuple[bool, Plane]: ...
    @overload
    def GetRotation(self) -> Tuple[bool, float, Vector3d]: ...
    def Invert(self) -> bool: ...
    def MatrixForm(self) -> Transform: ...
    def op_Addition(a: Quaternion, b: Quaternion) -> Quaternion: ...
    def op_Division(q: Quaternion, y: float) -> Quaternion: ...
    def op_Equality(a: Quaternion, b: Quaternion) -> bool: ...
    def op_Inequality(a: Quaternion, b: Quaternion) -> bool: ...
    @overload
    def op_Multiply(q: Quaternion, x: int) -> Quaternion: ...
    @overload
    def op_Multiply(a: Quaternion, b: Quaternion) -> Quaternion: ...
    @overload
    def op_Multiply(q: Quaternion, x: Single) -> Quaternion: ...
    @overload
    def op_Multiply(q: Quaternion, x: float) -> Quaternion: ...
    def op_Subtraction(a: Quaternion, b: Quaternion) -> Quaternion: ...
    def Product(p: Quaternion, q: Quaternion) -> Quaternion: ...
    def Rotate(self, v: Vector3d) -> Vector3d: ...
    @overload
    def Rotation(angle: float, axisOfRotation: Vector3d) -> Quaternion: ...
    @overload
    def Rotation(plane0: Plane, plane1: Plane) -> Quaternion: ...
    @A.setter
    def A(self, value: float) -> None: ...
    @B.setter
    def B(self, value: float) -> None: ...
    @C.setter
    def C(self, value: float) -> None: ...
    @D.setter
    def D(self, value: float) -> None: ...
    def Set(self, a: float, b: float, c: float, d: float) -> None: ...
    @overload
    def SetRotation(self, angle: float, axisOfRotation: Vector3d) -> None: ...
    @overload
    def SetRotation(self, plane0: Plane, plane1: Plane) -> None: ...
    def Unitize(self) -> bool: ...


class RadialDimension(Dimension):
    def __init__(self): ...
    def AdjustFromPoints(self, plane: Plane, centerpoint: Point3d, radiuspoint: Point3d, dimlinepoint: Point3d, rotationInPlane: float) -> bool: ...
    def Create(dimStyle: DimensionStyle, dimtype: AnnotationType, plane: Plane, centerpoint: Point3d, radiuspoint: Point3d, dimlinepoint: Point3d) -> RadialDimension: ...
    @property
    def AnnotationType(self) -> AnnotationType: ...
    @property
    def CenterPoint(self) -> Point2d: ...
    @property
    def DimlinePoint(self) -> Point2d: ...
    @property
    def IsDiameterDimension(self) -> bool: ...
    @property
    def KneePoint(self) -> Point2d: ...
    @property
    def LeaderArrowBlockId(self) -> Guid: ...
    @property
    def LeaderArrowSize(self) -> float: ...
    @property
    def LeaderArrowType(self) -> ArrowType: ...
    @property
    def LeaderCurveStyle(self) -> LeaderCurveStyle: ...
    @property
    def LeaderTextHorizontalAlignment(self) -> TextHorizontalAlignment: ...
    @property
    def RadiusPoint(self) -> Point2d: ...
    @property
    def TextAngleType(self) -> LeaderContentAngleStyle: ...
    @property
    def TextLocation(self) -> TextLocation: ...
    @property
    def TextOrientation(self) -> TextOrientation: ...
    def Get3dPoints(self) -> Tuple[bool, Point3d, Point3d, Point3d, Point3d]: ...
    def GetDisplayLines(self, style: DimensionStyle, scale: float) -> Tuple[bool, Iterable[Line]]: ...
    def GetDistanceDisplayText(self, unitsystem: UnitSystem, style: DimensionStyle) -> str: ...
    def GetTextRectangle(self) -> Tuple[bool, Set(Point3d)]: ...
    @AnnotationType.setter
    def AnnotationType(self, value: AnnotationType) -> None: ...
    @CenterPoint.setter
    def CenterPoint(self, value: Point2d) -> None: ...
    @DimlinePoint.setter
    def DimlinePoint(self, value: Point2d) -> None: ...
    @LeaderArrowBlockId.setter
    def LeaderArrowBlockId(self, value: Guid) -> None: ...
    @LeaderArrowSize.setter
    def LeaderArrowSize(self, value: float) -> None: ...
    @LeaderArrowType.setter
    def LeaderArrowType(self, value: ArrowType) -> None: ...
    @LeaderCurveStyle.setter
    def LeaderCurveStyle(self, value: LeaderCurveStyle) -> None: ...
    @LeaderTextHorizontalAlignment.setter
    def LeaderTextHorizontalAlignment(self, value: TextHorizontalAlignment) -> None: ...
    @RadiusPoint.setter
    def RadiusPoint(self, value: Point2d) -> None: ...
    @TextAngleType.setter
    def TextAngleType(self, value: LeaderContentAngleStyle) -> None: ...
    @TextLocation.setter
    def TextLocation(self, value: TextLocation) -> None: ...
    @TextOrientation.setter
    def TextOrientation(self, value: TextOrientation) -> None: ...


class RailType:
    DistanceFromEdge = 0
    RollingBall = 1
    DistanceBetweenRails = 2


class Ray3d:
    def __init__(self, position: Point3d, direction: Vector3d): ...
    def EpsilonEquals(self, other: Ray3d, epsilon: float) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, ray: Ray3d) -> bool: ...
    @property
    def Direction(self) -> Vector3d: ...
    @property
    def Position(self) -> Point3d: ...
    def GetHashCode(self) -> int: ...
    def op_Equality(a: Ray3d, b: Ray3d) -> bool: ...
    def op_Inequality(a: Ray3d, b: Ray3d) -> bool: ...
    def PointAt(self, t: float) -> Point3d: ...


class Rectangle3d:
    @overload
    def __init__(self, plane: Plane, width: float, height: float): ...
    @overload
    def __init__(self, plane: Plane, width: Interval, height: Interval): ...
    @overload
    def __init__(self, plane: Plane, cornerA: Point3d, cornerB: Point3d): ...
    @overload
    def ClosestPoint(self, point: Point3d) -> Point3d: ...
    @overload
    def ClosestPoint(self, point: Point3d, includeInterior: bool) -> Point3d: ...
    @overload
    def Contains(self, pt: Point3d) -> PointContainment: ...
    @overload
    def Contains(self, x: float, y: float) -> PointContainment: ...
    def Corner(self, index: int) -> Point3d: ...
    @overload
    def CreateFromPolyline(polyline: Iterable[Point3d]) -> Rectangle3d: ...
    @overload
    def CreateFromPolyline(polyline: Iterable[Point3d]) -> Tuple[Rectangle3d, float, float]: ...
    def EpsilonEquals(self, other: Rectangle3d, epsilon: float) -> bool: ...
    @property
    def Area(self) -> float: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Circumference(self) -> float: ...
    @property
    def Height(self) -> float: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Unset() -> Rectangle3d: ...
    @property
    def Width(self) -> float: ...
    @property
    def X(self) -> Interval: ...
    @property
    def Y(self) -> Interval: ...
    def MakeIncreasing(self) -> None: ...
    @overload
    def PointAt(self, t: float) -> Point3d: ...
    @overload
    def PointAt(self, x: float, y: float) -> Point3d: ...
    @overload
    def RecenterPlane(self, origin: Point3d) -> None: ...
    @overload
    def RecenterPlane(self, index: int) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    @X.setter
    def X(self, value: Interval) -> None: ...
    @Y.setter
    def Y(self, value: Interval) -> None: ...
    def ToNurbsCurve(self) -> NurbsCurve: ...
    def ToPolyline(self) -> Polyline: ...
    def Transform(self, xform: Transform) -> bool: ...


class ReduceMeshParameters:
    def __init__(self): ...
    @property
    def Accuracy(self) -> int: ...
    @property
    def AllowDistortion(self) -> bool: ...
    @property
    def CancelToken(self) -> CancellationToken: ...
    @property
    def DesiredPolygonCount(self) -> int: ...
    @property
    def Error(self) -> str: ...
    @property
    def FaceTags(self) -> Set(int): ...
    @property
    def LockedComponents(self) -> Set(ComponentIndex): ...
    @property
    def NormalizeMeshSize(self) -> bool: ...
    @property
    def ProgressReporter(self) -> IProgress: ...
    @Accuracy.setter
    def Accuracy(self, value: int) -> None: ...
    @AllowDistortion.setter
    def AllowDistortion(self, value: bool) -> None: ...
    @CancelToken.setter
    def CancelToken(self, value: CancellationToken) -> None: ...
    @DesiredPolygonCount.setter
    def DesiredPolygonCount(self, value: int) -> None: ...
    @FaceTags.setter
    def FaceTags(self, value: Set(int)) -> None: ...
    @LockedComponents.setter
    def LockedComponents(self, value: Set(ComponentIndex)) -> None: ...
    @NormalizeMeshSize.setter
    def NormalizeMeshSize(self, value: bool) -> None: ...
    @ProgressReporter.setter
    def ProgressReporter(self, value: IProgress) -> None: ...


class RegionContainment:
    Disjoint = 0
    MutualIntersection = 1
    AInsideB = 2
    BInsideA = 3


class RevSurface(Surface):
    @overload
    def Create(revoluteCurve: Curve, axisOfRevolution: Line) -> RevSurface: ...
    @overload
    def Create(revoluteLine: Line, axisOfRevolution: Line) -> RevSurface: ...
    @overload
    def Create(revolutePolyline: Polyline, axisOfRevolution: Line) -> RevSurface: ...
    @overload
    def Create(revoluteCurve: Curve, axisOfRevolution: Line, startAngleRadians: float, endAngleRadians: float) -> RevSurface: ...
    @overload
    def Create(revoluteLine: Line, axisOfRevolution: Line, startAngleRadians: float, endAngleRadians: float) -> RevSurface: ...
    @overload
    def Create(revolutePolyline: Polyline, axisOfRevolution: Line, startAngleRadians: float, endAngleRadians: float) -> RevSurface: ...
    def CreateFromCone(cone: Cone) -> RevSurface: ...
    def CreateFromCylinder(cylinder: Cylinder) -> RevSurface: ...
    def CreateFromSphere(sphere: Sphere) -> RevSurface: ...
    def CreateFromTorus(torus: Torus) -> RevSurface: ...
    @property
    def Angle(self) -> Interval: ...
    @property
    def Axis(self) -> Line: ...
    @property
    def Curve(self) -> Curve: ...


class RTree:
    def __init__(self): ...
    def Clear(self) -> None: ...
    def CreateFromPointArray(points: Iterable[Point3d]) -> RTree: ...
    def CreateMeshFaceTree(mesh: Mesh) -> RTree: ...
    def CreatePointCloudTree(cloud: PointCloud) -> RTree: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @overload
    def Insert(self, point: Point3d, elementId: int) -> bool: ...
    @overload
    def Insert(self, point: Point3d, elementId: IntPtr) -> bool: ...
    @overload
    def Insert(self, box: BoundingBox, elementId: int) -> bool: ...
    @overload
    def Insert(self, box: BoundingBox, elementId: IntPtr) -> bool: ...
    @overload
    def Insert(self, point: Point2d, elementId: int) -> bool: ...
    @overload
    def Insert(self, point: Point2d, elementId: IntPtr) -> bool: ...
    def Point3dClosestPoints(hayPoints: Iterable[Point3d], needlePts: Iterable[Point3d], limitDistance: float) -> Iterable[Set(int)]: ...
    def Point3dKNeighbors(hayPoints: Iterable[Point3d], needlePts: Iterable[Point3d], amount: int) -> Iterable[Set(int)]: ...
    def PointCloudClosestPoints(pointcloud: PointCloud, needlePts: Iterable[Point3d], limitDistance: float) -> Iterable[Set(int)]: ...
    def PointCloudKNeighbors(pointcloud: PointCloud, needlePts: Iterable[Point3d], amount: int) -> Iterable[Set(int)]: ...
    @overload
    def Remove(self, box: BoundingBox, elementId: IntPtr) -> bool: ...
    @overload
    def Remove(self, box: BoundingBox, elementId: int) -> bool: ...
    @overload
    def Remove(self, point: Point3d, elementId: IntPtr) -> bool: ...
    @overload
    def Remove(self, point: Point3d, elementId: int) -> bool: ...
    @overload
    def Remove(self, point: Point2d, elementId: int) -> bool: ...
    @overload
    def Search(self, box: BoundingBox, callback: EventHandler) -> bool: ...
    @overload
    def Search(self, sphere: Sphere, callback: EventHandler) -> bool: ...
    @overload
    def Search(self, sphere: Sphere, callback: EventHandler, tag: Object) -> bool: ...
    @overload
    def Search(self, box: BoundingBox, callback: EventHandler, tag: Object) -> bool: ...
    def SearchOverlaps(treeA: RTree, treeB: RTree, tolerance: float, callback: EventHandler) -> bool: ...


class RTreeEventArgs:
    @property
    def Cancel(self) -> bool: ...
    @property
    def Id(self) -> int: ...
    @property
    def IdB(self) -> int: ...
    @property
    def IdBPtr(self) -> IntPtr: ...
    @property
    def IdPtr(self) -> IntPtr: ...
    @property
    def SearchBoundingBox(self) -> BoundingBox: ...
    @property
    def SearchSphere(self) -> Sphere: ...
    @property
    def Tag(self) -> Object: ...
    @Cancel.setter
    def Cancel(self, value: bool) -> None: ...
    @SearchBoundingBox.setter
    def SearchBoundingBox(self, value: BoundingBox) -> None: ...
    @SearchSphere.setter
    def SearchSphere(self, value: Sphere) -> None: ...
    @Tag.setter
    def Tag(self, value: Object) -> None: ...


class ShrinkDisableSide:
    ShrinkAllSides = 0
    DoNotShrinkWestSide = 1
    DoNotShrinkSouthSide = 2
    DoNotShrinkEastSide = 4
    DoNotShrinkNorthSide = 8


class ShutLiningCurveInfo:
    def __init__(self, curve: Curve, radius: float, profile: int, pull: bool, isBump: bool, curveIntervals: Iterable[Interval], enabled: bool): ...
    @property
    def Curve(self) -> Curve: ...
    @property
    def CurveIntervals(self) -> ReadOnlyCollection: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def IsBump(self) -> bool: ...
    @property
    def Profile(self) -> int: ...
    @property
    def Pull(self) -> bool: ...
    @property
    def Radius(self) -> float: ...


class SideFill:
    SideUnset = 0
    SideSurface = 1
    SideVoid = 2
    OtherSurface = 3


class Silhouette:
    @overload
    def Compute(geometry: GeometryBase, silhouetteType: SilhouetteType, perspectiveCameraLocation: Point3d, tolerance: float, angleToleranceRadians: float) -> Set(Silhouette): ...
    @overload
    def Compute(geometry: GeometryBase, silhouetteType: SilhouetteType, parallelCameraDirection: Vector3d, tolerance: float, angleToleranceRadians: float) -> Set(Silhouette): ...
    @overload
    def Compute(geometry: GeometryBase, silhouetteType: SilhouetteType, viewport: ViewportInfo, tolerance: float, angleToleranceRadians: float) -> Set(Silhouette): ...
    @overload
    def Compute(geometry: GeometryBase, silhouetteType: SilhouetteType, perspectiveCameraLocation: Point3d, tolerance: float, angleToleranceRadians: float, clippingPlanes: Iterable[Plane], cancelToken: CancellationToken) -> Set(Silhouette): ...
    @overload
    def Compute(geometry: GeometryBase, silhouetteType: SilhouetteType, parallelCameraDirection: Vector3d, tolerance: float, angleToleranceRadians: float, clippingPlanes: Iterable[Plane], cancelToken: CancellationToken) -> Set(Silhouette): ...
    @overload
    def Compute(geometry: GeometryBase, silhouetteType: SilhouetteType, viewport: ViewportInfo, tolerance: float, angleToleranceRadians: float, clippingPlanes: Iterable[Plane], cancelToken: CancellationToken) -> Set(Silhouette): ...
    @overload
    def ComputeDraftCurve(geometry: GeometryBase, draftAngle: float, pullDirection: Vector3d, tolerance: float, angleToleranceRadians: float) -> Set(Silhouette): ...
    @overload
    def ComputeDraftCurve(geometry: GeometryBase, draftAngle: float, pullDirection: Vector3d, tolerance: float, angleToleranceRadians: float, cancelToken: CancellationToken) -> Set(Silhouette): ...
    @property
    def Curve(self) -> Curve: ...
    @property
    def GeometryComponentIndex(self) -> ComponentIndex: ...
    @property
    def SilhouetteType(self) -> SilhouetteType: ...


class SilhouetteType:
    #None = 0
    Projecting = 1
    TangentProjects = 2
    Tangent = 4
    Crease = 8
    Boundary = 16
    NonSilhouetteCrease = 256
    NonSilhouetteTangent = 512
    NonSilhouetteSeam = 1024
    SectionCut = 4096
    MiscellaneousFeature = 8192
    DraftCurve = 32768


class SmoothingCoordinateSystem:
    World = 0
    CPlane = 1
    Object = 2


class SpaceMorph:
    @property
    def PreserveStructure(self) -> bool: ...
    @property
    def QuickPreview(self) -> bool: ...
    @property
    def Tolerance(self) -> float: ...
    def IsMorphable(geometry: GeometryBase) -> bool: ...
    @overload
    def Morph(self, geometry: GeometryBase) -> bool: ...
    @overload
    def Morph(self, plane: Plane) -> Tuple[bool, Plane]: ...
    def MorphPoint(self, point: Point3d) -> Point3d: ...
    @PreserveStructure.setter
    def PreserveStructure(self, value: bool) -> None: ...
    @QuickPreview.setter
    def QuickPreview(self, value: bool) -> None: ...
    @Tolerance.setter
    def Tolerance(self, value: float) -> None: ...


class Sphere:
    @overload
    def __init__(self, center: Point3d, radius: float): ...
    @overload
    def __init__(self, equatorialPlane: Plane, radius: float): ...
    def ClosestParameter(self, testPoint: Point3d) -> Tuple[bool, float, float]: ...
    def ClosestPoint(self, testPoint: Point3d) -> Point3d: ...
    def EpsilonEquals(self, other: Sphere, epsilon: float) -> bool: ...
    def FitSphereToPoints(points: Iterable[Point3d]) -> Sphere: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def Center(self) -> Point3d: ...
    @property
    def Diameter(self) -> float: ...
    @property
    def EquatorialPlane(self) -> Plane: ...
    @property
    def EquitorialPlane(self) -> Plane: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def NorthPole(self) -> Point3d: ...
    @property
    def Radius(self) -> float: ...
    @property
    def SouthPole(self) -> Point3d: ...
    @property
    def Unset() -> Sphere: ...
    def LatitudeDegrees(self, degrees: float) -> Circle: ...
    def LatitudeRadians(self, radians: float) -> Circle: ...
    def LongitudeDegrees(self, degrees: float) -> Circle: ...
    def LongitudeRadians(self, radians: float) -> Circle: ...
    def NormalAt(self, longitudeRadians: float, latitudeRadians: float) -> Vector3d: ...
    def PointAt(self, longitudeRadians: float, latitudeRadians: float) -> Point3d: ...
    @overload
    def Rotate(self, angleRadians: float, axisOfRotation: Vector3d) -> bool: ...
    @overload
    def Rotate(self, angleRadians: float, axisOfRotation: Vector3d, centerOfRotation: Point3d) -> bool: ...
    @overload
    def Rotate(self, sinAngle: float, cosAngle: float, axisOfRotation: Vector3d) -> bool: ...
    @overload
    def Rotate(self, sinAngle: float, cosAngle: float, axisOfRotation: Vector3d, centerOfRotation: Point3d) -> bool: ...
    @Center.setter
    def Center(self, value: Point3d) -> None: ...
    @Diameter.setter
    def Diameter(self, value: float) -> None: ...
    @EquatorialPlane.setter
    def EquatorialPlane(self, value: Plane) -> None: ...
    @EquitorialPlane.setter
    def EquitorialPlane(self, value: Plane) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    def ToBrep(self) -> Brep: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def ToRevSurface(self) -> RevSurface: ...
    def Transform(self, xform: Transform) -> bool: ...
    def Translate(self, delta: Vector3d) -> bool: ...


class SubD(GeometryBase):
    def __init__(self): ...
    def ClearEvaluationCache(self) -> None: ...
    def ComponentFromComponentIndex(self, componentIndex: ComponentIndex) -> SubDComponent: ...
    def CreateFromCylinder(cylinder: Cylinder, circumferenceFaceCount: UInt32, heightFaceCount: UInt32, endCapStyle: SubDEndCapStyle, endCapEdgeTag: SubDEdgeTag, radiusLocation: SubDComponentLocation) -> SubD: ...
    def CreateFromLoft(curves: Iterable[NurbsCurve], closed: bool, addCorners: bool, addCreases: bool, divisions: int) -> SubD: ...
    @overload
    def CreateFromMesh(mesh: Mesh) -> SubD: ...
    @overload
    def CreateFromMesh(mesh: Mesh, options: SubDCreationOptions) -> SubD: ...
    @overload
    def CreateFromSweep(rail1: NurbsCurve, rail2: NurbsCurve, shapes: Iterable[NurbsCurve], closed: bool, addCorners: bool) -> SubD: ...
    @overload
    def CreateFromSweep(rail1: NurbsCurve, shapes: Iterable[NurbsCurve], closed: bool, addCorners: bool, roadlikeFrame: bool, roadlikeNormal: Vector3d) -> SubD: ...
    @property
    def Edges(self) -> SubDEdgeList: ...
    @property
    def Faces(self) -> SubDFaceList: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def Vertices(self) -> SubDVertexList: ...
    def InterpolateSurfacePoints(self, surfacePoints: Set(Point3d)) -> bool: ...
    def Offset(self, distance: float, solidify: bool) -> SubD: ...
    def Subdivide(self, count: int) -> bool: ...
    @overload
    def ToBrep(self) -> Brep: ...
    @overload
    def ToBrep(self, options: SubDToBrepOptions) -> Brep: ...
    def UpdateAllTagsAndSectorCoefficients(self) -> UInt32: ...


class SubDAutomaticMeshToSubDContext:
    Unset = 0
    Rhino5BoxModeTSpline = 1
    FBXMeshWithDivisionLevels = 2


class SubDChainType:
    Unset = 0
    MixedTag = 1
    EqualEdgeTag = 2
    EqualEdgeAndVertexTag = 3
    EqualEdgeTagAndOrdinary = 4
    EqualEdgeAndVertexTagAndOrdinary = 5


class SubDComponent:
    @property
    def Id(self) -> UInt32: ...
    @property
    def IsDamaged(self) -> bool: ...
    @property
    def IsDeleted(self) -> bool: ...
    @property
    def IsHidden(self) -> bool: ...
    @property
    def IsHighlighted(self) -> bool: ...
    @property
    def IsLocked(self) -> bool: ...
    @property
    def IsSelected(self) -> bool: ...
    @property
    def ParentSubD(self) -> SubD: ...


class SubDComponentLocation:
    Unset = 0
    ControlNet = 1
    Surface = 2


class SubDCreationOptions:
    def __init__(self): ...
    def Dispose(self) -> None: ...
    @property
    def ConcaveCornerTest(self) -> ConcaveCornerOption: ...
    @property
    def ConvexCornersAndInteriorCreases() -> SubDCreationOptions: ...
    @property
    def ConvexCornerTest(self) -> ConvexCornerOption: ...
    @property
    def InteriorCreases() -> SubDCreationOptions: ...
    @property
    def InteriorCreaseTest(self) -> InteriorCreaseOption: ...
    @property
    def InterpolateMeshVertices(self) -> bool: ...
    @property
    def MaximumConvexCornerAngleRadians(self) -> float: ...
    @property
    def MaximumConvexCornerEdgeCount(self) -> UInt32: ...
    @property
    def MinimumConcaveCornerAngleRadians(self) -> float: ...
    @property
    def MinimumConcaveCornerEdgeCount(self) -> UInt32: ...
    @property
    def Smooth() -> SubDCreationOptions: ...
    @ConcaveCornerTest.setter
    def ConcaveCornerTest(self, value: ConcaveCornerOption) -> None: ...
    @ConvexCornerTest.setter
    def ConvexCornerTest(self, value: ConvexCornerOption) -> None: ...
    @InteriorCreaseTest.setter
    def InteriorCreaseTest(self, value: InteriorCreaseOption) -> None: ...
    @InterpolateMeshVertices.setter
    def InterpolateMeshVertices(self, value: bool) -> None: ...
    @MaximumConvexCornerAngleRadians.setter
    def MaximumConvexCornerAngleRadians(self, value: float) -> None: ...
    @MaximumConvexCornerEdgeCount.setter
    def MaximumConvexCornerEdgeCount(self, value: UInt32) -> None: ...
    @MinimumConcaveCornerAngleRadians.setter
    def MinimumConcaveCornerAngleRadians(self, value: float) -> None: ...
    @MinimumConcaveCornerEdgeCount.setter
    def MinimumConcaveCornerEdgeCount(self, value: UInt32) -> None: ...


class SubDEdge(SubDComponent):
    def FaceAt(self, index: int) -> SubDFace: ...
    @property
    def ControlNetLine(self) -> Line: ...
    @property
    def FaceCount(self) -> int: ...
    @property
    def Tag(self) -> SubDEdgeTag: ...
    @property
    def VertexFrom(self) -> SubDVertex: ...
    @property
    def VertexTo(self) -> SubDVertex: ...
    @Tag.setter
    def Tag(self, value: SubDEdgeTag) -> None: ...
    def ToNurbsCurve(self, clampEnds: bool) -> NurbsCurve: ...


class SubDEdgeTag:
    Unset = 0
    Smooth = 1
    Crease = 2
    SmoothX = 4


class SubDEndCapStyle:
    Unset = 0
    #None = 1
    Triangles = 2
    Quads = 3
    Ngon = 4


class SubDFace(SubDComponent):
    def EdgeAt(self, index: int) -> SubDEdge: ...
    def EdgeDirectionMatchesFaceOrientation(self, index: int) -> bool: ...
    @property
    def EdgeCount(self) -> int: ...
    @property
    def LimitSurfaceCenterPoint(self) -> Point3d: ...
    @property
    def PerFaceColor(self) -> Color: ...
    @property
    def VertexCount(self) -> int: ...
    @PerFaceColor.setter
    def PerFaceColor(self, value: Color) -> None: ...
    def VertexAt(self, index: int) -> SubDVertex: ...


class SubDFriendlyKnotType:
    Unset = 0
    UnclampedUniform = 1
    ClampedUniform = 2
    ClampedPiecewiseUniform = 4
    Unfriendly = 127


class SubDFromSurfaceMethods:
    Unset = 0
    SubDFriendlyFit = 1
    FromNurbsControlNet = 2


class SubDHashType:
    Unset = 0
    TopologyAndEdgeCreases = 1
    Geometry = 2
    Topology = 3


class SubDPatchStyle:
    Unset = 0
    Automatic = 1
    SingleFace = 2
    TriangleFan = 3
    QuadOrTriangleFan = 4
    Triangulated = 5


class SubDToBrepOptions:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, packFaces: bool, vertexProcess: ExtraordinaryVertexProcessOption): ...
    def Dispose(self) -> None: ...
    @property
    def Default() -> SubDToBrepOptions: ...
    @property
    def DefaultPacked() -> SubDToBrepOptions: ...
    @property
    def DefaultUnpacked() -> SubDToBrepOptions: ...
    @property
    def ExtraordinaryVertexProcess(self) -> ExtraordinaryVertexProcessOption: ...
    @property
    def PackFaces(self) -> bool: ...
    @ExtraordinaryVertexProcess.setter
    def ExtraordinaryVertexProcess(self, value: ExtraordinaryVertexProcessOption) -> None: ...
    @PackFaces.setter
    def PackFaces(self, value: bool) -> None: ...


class SubDVertex(SubDComponent):
    def EdgeAt(self, index: int) -> SubDEdge: ...
    def FaceAt(self, index: int) -> SubDFace: ...
    @property
    def ControlNetPoint(self) -> Point3d: ...
    @property
    def EdgeCount(self) -> int: ...
    @property
    def Edges(self) -> Iterable[SubDEdge]: ...
    @property
    def FaceCount(self) -> int: ...
    @property
    def Next(self) -> SubDVertex: ...
    @property
    def Previous(self) -> SubDVertex: ...
    @property
    def Tag(self) -> SubDVertexTag: ...
    @ControlNetPoint.setter
    def ControlNetPoint(self, value: Point3d) -> None: ...
    @Tag.setter
    def Tag(self, value: SubDVertexTag) -> None: ...
    def SurfacePoint(self) -> Point3d: ...


class SubDVertexFacetType:
    Unset = 0
    Tri = 3
    Quad = 4
    Ngon = 5
    Mixed = 255


class SubDVertexTag:
    Unset = 0
    Smooth = 1
    Crease = 2
    Corner = 3
    Dart = 4


class SumSurface(Surface):
    def Create(curveA: Curve, curveB: Curve) -> SumSurface: ...


class Surface(GeometryBase):
    def ClosestPoint(self, testPoint: Point3d) -> Tuple[bool, float, float]: ...
    def ClosestSide(self, u: float, v: float) -> IsoStatus: ...
    def CreateExtrusion(profile: Curve, direction: Vector3d) -> Surface: ...
    def CreateExtrusionToPoint(profile: Curve, apexPoint: Point3d) -> Surface: ...
    @overload
    def CreatePeriodicSurface(surface: Surface, direction: int) -> Surface: ...
    @overload
    def CreatePeriodicSurface(surface: Surface, direction: int, bSmooth: bool) -> Surface: ...
    @overload
    def CreateRollingBallFillet(surfaceA: Surface, surfaceB: Surface, radius: float, tolerance: float) -> Set(Surface): ...
    @overload
    def CreateRollingBallFillet(surfaceA: Surface, flipA: bool, surfaceB: Surface, flipB: bool, radius: float, tolerance: float) -> Set(Surface): ...
    @overload
    def CreateRollingBallFillet(surfaceA: Surface, uvA: Point2d, surfaceB: Surface, uvB: Point2d, radius: float, tolerance: float) -> Set(Surface): ...
    def CreateSoftEditSurface(surface: Surface, uv: Point2d, delta: Vector3d, uLength: float, vLength: float, tolerance: float, fixEnds: bool) -> Surface: ...
    def CurvatureAt(self, u: float, v: float) -> SurfaceCurvature: ...
    def Degree(self, direction: int) -> int: ...
    def Domain(self, direction: int) -> Interval: ...
    def Evaluate(self, u: float, v: float, numberDerivatives: int) -> Tuple[bool, Point3d, Set(Vector3d)]: ...
    @overload
    def Extend(self, direction: int, interval: Interval) -> bool: ...
    @overload
    def Extend(self, edge: IsoStatus, extensionLength: float, smooth: bool) -> Surface: ...
    def Fit(self, uDegree: int, vDegree: int, fitTolerance: float) -> Surface: ...
    def FrameAt(self, u: float, v: float) -> Tuple[bool, Plane]: ...
    @property
    def IsSolid(self) -> bool: ...
    @property
    def IsSubDFriendly(self) -> bool: ...
    @overload
    def GetNextDiscontinuity(self, direction: int, continuityType: Continuity, t0: float, t1: float) -> Tuple[bool, float]: ...
    @overload
    def GetNextDiscontinuity(self, direction: int, continuityType: Continuity, t0: float, t1: float, cosAngleTolerance: float, curvatureTolerance: float) -> Tuple[bool, float]: ...
    def GetNurbsFormParameterFromSurfaceParameter(self, surfaceS: float, surfaceT: float) -> Tuple[bool, float, float]: ...
    def GetSpanVector(self, direction: int) -> Set(float): ...
    def GetSurfaceParameterFromNurbsFormParameter(self, nurbsS: float, nurbsT: float) -> Tuple[bool, float, float]: ...
    def GetSurfaceSize(self) -> Tuple[bool, float, float]: ...
    def HasNurbsForm(self) -> int: ...
    def InterpolatedCurveOnSurface(self, points: Iterable[Point3d], tolerance: float) -> NurbsCurve: ...
    @overload
    def InterpolatedCurveOnSurfaceUV(self, points: Iterable[Point2d], tolerance: float) -> NurbsCurve: ...
    @overload
    def InterpolatedCurveOnSurfaceUV(self, points: Iterable[Point2d], tolerance: float, closed: bool, closedSurfaceHandling: int) -> NurbsCurve: ...
    def IsAtSeam(self, u: float, v: float) -> int: ...
    def IsAtSingularity(self, u: float, v: float, exact: bool) -> bool: ...
    def IsClosed(self, direction: int) -> bool: ...
    @overload
    def IsCone(self) -> bool: ...
    @overload
    def IsCone(self, tolerance: float) -> bool: ...
    def IsContinuous(self, continuityType: Continuity, u: float, v: float) -> bool: ...
    @overload
    def IsCylinder(self) -> bool: ...
    @overload
    def IsCylinder(self, tolerance: float) -> bool: ...
    @overload
    def IsIsoparametric(self, curve: Curve) -> IsoStatus: ...
    @overload
    def IsIsoparametric(self, bbox: BoundingBox) -> IsoStatus: ...
    @overload
    def IsIsoparametric(self, curve: Curve, curveDomain: Interval) -> IsoStatus: ...
    def IsoCurve(self, direction: int, constantParameter: float) -> Curve: ...
    def IsPeriodic(self, direction: int) -> bool: ...
    @overload
    def IsPlanar(self) -> bool: ...
    @overload
    def IsPlanar(self, tolerance: float) -> bool: ...
    def IsSingular(self, side: int) -> bool: ...
    @overload
    def IsSphere(self) -> bool: ...
    @overload
    def IsSphere(self, tolerance: float) -> bool: ...
    @overload
    def IsTorus(self) -> bool: ...
    @overload
    def IsTorus(self, tolerance: float) -> bool: ...
    def LocalClosestPoint(self, testPoint: Point3d, seedU: float, seedV: float) -> Tuple[bool, float, float]: ...
    def NormalAt(self, u: float, v: float) -> Vector3d: ...
    def Offset(self, distance: float, tolerance: float) -> Surface: ...
    def PointAt(self, u: float, v: float) -> Point3d: ...
    @overload
    def Pullback(self, curve3d: Curve, tolerance: float) -> Curve: ...
    @overload
    def Pullback(self, curve3d: Curve, tolerance: float, curve3dSubdomain: Interval) -> Curve: ...
    @overload
    def Pushup(self, curve2d: Curve, tolerance: float) -> Curve: ...
    @overload
    def Pushup(self, curve2d: Curve, tolerance: float, curve2dSubdomain: Interval) -> Curve: ...
    def Rebuild(self, uDegree: int, vDegree: int, uPointCount: int, vPointCount: int) -> NurbsSurface: ...
    def RebuildOneDirection(self, direction: int, pointCount: int, loftType: LoftType, refitTolerance: float) -> NurbsSurface: ...
    @overload
    def Reverse(self, direction: int) -> Surface: ...
    @overload
    def Reverse(self, direction: int, inPlace: bool) -> Surface: ...
    def SetDomain(self, direction: int, domain: Interval) -> bool: ...
    def ShortPath(self, start: Point2d, end: Point2d, tolerance: float) -> Curve: ...
    @overload
    def Smooth(self, smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem) -> Surface: ...
    @overload
    def Smooth(self, smoothFactor: float, bXSmooth: bool, bYSmooth: bool, bZSmooth: bool, bFixBoundaries: bool, coordinateSystem: SmoothingCoordinateSystem, plane: Plane) -> Surface: ...
    def SpanCount(self, direction: int) -> int: ...
    def Split(self, direction: int, parameter: float) -> Set(Surface): ...
    def ToBrep(self) -> Brep: ...
    @overload
    def ToNurbsSurface(self) -> NurbsSurface: ...
    @overload
    def ToNurbsSurface(self, tolerance: float) -> Tuple[NurbsSurface, int]: ...
    @overload
    def Transpose(self) -> Surface: ...
    @overload
    def Transpose(self, inPlace: bool) -> Surface: ...
    def Trim(self, u: Interval, v: Interval) -> Surface: ...
    @overload
    def TryGetCone(self) -> Tuple[bool, Cone]: ...
    @overload
    def TryGetCone(self, tolerance: float) -> Tuple[bool, Cone]: ...
    @overload
    def TryGetCylinder(self) -> Tuple[bool, Cylinder]: ...
    @overload
    def TryGetCylinder(self, tolerance: float) -> Tuple[bool, Cylinder]: ...
    def TryGetFiniteCylinder(self, tolerance: float) -> Tuple[bool, Cylinder]: ...
    @overload
    def TryGetPlane(self) -> Tuple[bool, Plane]: ...
    @overload
    def TryGetPlane(self, tolerance: float) -> Tuple[bool, Plane]: ...
    @overload
    def TryGetSphere(self) -> Tuple[bool, Sphere]: ...
    @overload
    def TryGetSphere(self, tolerance: float) -> Tuple[bool, Sphere]: ...
    @overload
    def TryGetTorus(self) -> Tuple[bool, Torus]: ...
    @overload
    def TryGetTorus(self, tolerance: float) -> Tuple[bool, Torus]: ...
    @overload
    def VariableOffset(self, uMinvMin: float, uMinvMax: float, uMaxvMin: float, uMaxvMax: float, tolerance: float) -> Surface: ...
    @overload
    def VariableOffset(self, uMinvMin: float, uMinvMax: float, uMaxvMin: float, uMaxvMax: float, interiorParameters: Iterable[Point2d], interiorDistances: Iterable[float], tolerance: float) -> Surface: ...


class SurfaceCurvature:
    def Direction(self, direction: int) -> Vector3d: ...
    @property
    def Gaussian(self) -> float: ...
    @property
    def Mean(self) -> float: ...
    @property
    def Normal(self) -> Vector3d: ...
    @property
    def Point(self) -> Point3d: ...
    @property
    def UVPoint(self) -> Point2d: ...
    def Kappa(self, direction: int) -> float: ...
    def OsculatingCircle(self, direction: int) -> Circle: ...


class SurfaceProxy(Surface):
    pass


class SweepBlend:
    Local = 0
    Global = 1


class SweepFrame:
    Freeform = 0
    Roadlike = 1


class SweepMiter:
    #None = 0
    Trimmed = 1
    Untrimmed = 2


class SweepOneRail:
    def __init__(self): ...
    @property
    def AngleToleranceRadians(self) -> float: ...
    @property
    def ClosedSweep(self) -> bool: ...
    @property
    def GlobalShapeBlending(self) -> bool: ...
    @property
    def IsFreeform(self) -> bool: ...
    @property
    def IsRoadlike(self) -> bool: ...
    @property
    def IsRoadlikeFront(self) -> bool: ...
    @property
    def IsRoadlikeTop(self) -> bool: ...
    @property
    def IsRoadlineRight(self) -> bool: ...
    @property
    def MiterType(self) -> int: ...
    @property
    def SweepTolerance(self) -> float: ...
    @overload
    def PerformSweep(self, rail: Curve, crossSections: Iterable[Curve]) -> Set(Brep): ...
    @overload
    def PerformSweep(self, rail: Curve, crossSection: Curve) -> Set(Brep): ...
    @overload
    def PerformSweep(self, rail: Curve, crossSection: Curve, crossSectionParameter: float) -> Set(Brep): ...
    @overload
    def PerformSweep(self, rail: Curve, crossSections: Iterable[Curve], crossSectionParameters: Iterable[float]) -> Set(Brep): ...
    @overload
    def PerformSweepRebuild(self, rail: Curve, crossSections: Iterable[Curve], rebuildCount: int) -> Set(Brep): ...
    @overload
    def PerformSweepRebuild(self, rail: Curve, crossSection: Curve, rebuildCount: int) -> Set(Brep): ...
    @overload
    def PerformSweepRebuild(self, rail: Curve, crossSections: Iterable[Curve], crossSectionParameters: Iterable[float], rebuildCount: int) -> Set(Brep): ...
    @overload
    def PerformSweepRebuild(self, rail: Curve, crossSection: Curve, crossSectionParameter: float, rebuildCount: int) -> Set(Brep): ...
    @overload
    def PerformSweepRefit(self, rail: Curve, crossSection: Curve, refitTolerance: float) -> Set(Brep): ...
    @overload
    def PerformSweepRefit(self, rail: Curve, crossSections: Iterable[Curve], refitTolerance: float) -> Set(Brep): ...
    @overload
    def PerformSweepRefit(self, rail: Curve, crossSections: Iterable[Curve], crossSectionParameters: Iterable[float], refitTolerance: float) -> Set(Brep): ...
    @overload
    def PerformSweepRefit(self, rail: Curve, crossSection: Curve, crossSectionParameter: float, refitTolerance: float) -> Set(Brep): ...
    @AngleToleranceRadians.setter
    def AngleToleranceRadians(self, value: float) -> None: ...
    @ClosedSweep.setter
    def ClosedSweep(self, value: bool) -> None: ...
    @GlobalShapeBlending.setter
    def GlobalShapeBlending(self, value: bool) -> None: ...
    @MiterType.setter
    def MiterType(self, value: int) -> None: ...
    @SweepTolerance.setter
    def SweepTolerance(self, value: float) -> None: ...
    def SetRoadlikeUpDirection(self, up: Vector3d) -> None: ...
    def SetToRoadlikeFront(self) -> None: ...
    def SetToRoadlikeRight(self) -> None: ...
    def SetToRoadlikeTop(self) -> None: ...


class SweepRebuild:
    #None = 0
    Rebuild = 1
    Refit = 2


class SweepTwoRail:
    def __init__(self): ...
    @property
    def AngleToleranceRadians(self) -> float: ...
    @property
    def ClosedSweep(self) -> bool: ...
    @property
    def MaintainHeight(self) -> bool: ...
    @property
    def SweepTolerance(self) -> float: ...
    @overload
    def PerformSweep(self, rail1: Curve, rail2: Curve, crossSections: Iterable[Curve]) -> Set(Brep): ...
    @overload
    def PerformSweep(self, rail1: Curve, rail2: Curve, crossSection: Curve) -> Set(Brep): ...
    @overload
    def PerformSweepRebuild(self, rail1: Curve, rail2: Curve, crossSection: Curve, rebuildCount: int) -> Set(Brep): ...
    @overload
    def PerformSweepRebuild(self, rail1: Curve, rail2: Curve, crossSections: Iterable[Curve], rebuildCount: int) -> Set(Brep): ...
    @overload
    def PerformSweepRefit(self, rail1: Curve, rail2: Curve, crossSection: Curve, refitTolerance: float) -> Set(Brep): ...
    @overload
    def PerformSweepRefit(self, rail1: Curve, rail2: Curve, crossSections: Iterable[Curve], refitTolerance: float) -> Set(Brep): ...
    @AngleToleranceRadians.setter
    def AngleToleranceRadians(self, value: float) -> None: ...
    @ClosedSweep.setter
    def ClosedSweep(self, value: bool) -> None: ...
    @MaintainHeight.setter
    def MaintainHeight(self, value: bool) -> None: ...
    @SweepTolerance.setter
    def SweepTolerance(self, value: float) -> None: ...


class TextDot(GeometryBase):
    def __init__(self, text: str, location: Point3d): ...
    @property
    def FontFace(self) -> str: ...
    @property
    def FontHeight(self) -> int: ...
    @property
    def Point(self) -> Point3d: ...
    @property
    def SecondaryText(self) -> str: ...
    @property
    def Text(self) -> str: ...
    @FontFace.setter
    def FontFace(self, value: str) -> None: ...
    @FontHeight.setter
    def FontHeight(self, value: int) -> None: ...
    @Point.setter
    def Point(self, value: Point3d) -> None: ...
    @SecondaryText.setter
    def SecondaryText(self, value: str) -> None: ...
    @Text.setter
    def Text(self, value: str) -> None: ...


class TextEntity(AnnotationBase):
    def __init__(self): ...
    def Create(text: str, plane: Plane, style: DimensionStyle, wrapped: bool, rectWidth: float, rotationRadians: float) -> TextEntity: ...
    def CreateCurves(self, dimstyle: DimensionStyle, bAllowOpen: bool, smallCapsScale: float, spacing: float) -> Set(Curve): ...
    def CreateExtrusions(self, dimstyle: DimensionStyle, height: float, smallCapsScale: float, spacing: float) -> Set(Extrusion): ...
    def CreatePolySurfaces(self, dimstyle: DimensionStyle, height: float, smallCapsScale: float, spacing: float) -> Set(Brep): ...
    def CreateSurfaces(self, dimstyle: DimensionStyle, smallCapsScale: float, spacing: float) -> Set(Brep): ...
    def CreateWithRichText(richTextString: str, plane: Plane, style: DimensionStyle, wrapped: bool, rectWidth: float, rotationRadians: float) -> TextEntity: ...
    def Explode(self) -> Set(Curve): ...
    @property
    def Justification(self) -> TextJustification: ...
    @property
    def TextHorizontalAlignment(self) -> TextHorizontalAlignment: ...
    @property
    def TextOrientation(self) -> TextOrientation: ...
    @property
    def TextVerticalAlignment(self) -> TextVerticalAlignment: ...
    def GetTextTransform(self, textscale: float, dimstyle: DimensionStyle) -> Transform: ...
    @Justification.setter
    def Justification(self, value: TextJustification) -> None: ...
    @TextHorizontalAlignment.setter
    def TextHorizontalAlignment(self, value: TextHorizontalAlignment) -> None: ...
    @TextOrientation.setter
    def TextOrientation(self, value: TextOrientation) -> None: ...
    @TextVerticalAlignment.setter
    def TextVerticalAlignment(self, value: TextVerticalAlignment) -> None: ...
    @overload
    def Transform(self, transform: Transform, style: DimensionStyle) -> bool: ...


class TextJustification:
    #None = 0
    Left = 1
    Center = 2
    Right = 4
    Bottom = 65536
    BottomLeft = 65537
    BottomCenter = 65538
    BottomRight = 65540
    Middle = 131072
    MiddleLeft = 131073
    MiddleCenter = 131074
    MiddleRight = 131076
    Top = 262144
    TopLeft = 262145
    TopCenter = 262146
    TopRight = 262148


class TextRunType:
    #None = 0
    Text = 1
    Newline = 2
    Paragraph = 3
    Column = 4
    Field = 5
    Fontdef = 6
    Header = 7


class TextureCoordinateOption:
    Unset = 0
    #None = 1
    Automatic = 2
    Packed = 3
    CopyMapping = 4
    CopyCoordinates = 5


class Torus:
    def __init__(self, basePlane: Plane, majorRadius: float, minorRadius: float): ...
    def EpsilonEquals(self, other: Torus, epsilon: float) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def MajorRadius(self) -> float: ...
    @property
    def MinorRadius(self) -> float: ...
    @property
    def Plane(self) -> Plane: ...
    @property
    def Unset() -> Torus: ...
    @MajorRadius.setter
    def MajorRadius(self, value: float) -> None: ...
    @MinorRadius.setter
    def MinorRadius(self, value: float) -> None: ...
    @Plane.setter
    def Plane(self, value: Plane) -> None: ...
    def ToNurbsSurface(self) -> NurbsSurface: ...
    def ToRevSurface(self) -> RevSurface: ...


class Transform:
    @overload
    def __init__(self, diagonalValue: float): ...
    @overload
    def __init__(self, value: Transform): ...
    def Affineize(self) -> None: ...
    @overload
    def ChangeBasis(plane0: Plane, plane1: Plane) -> Transform: ...
    @overload
    def ChangeBasis(initialBasisX: Vector3d, initialBasisY: Vector3d, initialBasisZ: Vector3d, finalBasisX: Vector3d, finalBasisY: Vector3d, finalBasisZ: Vector3d) -> Transform: ...
    def Clone(self) -> Transform: ...
    def CompareTo(self, other: Transform) -> int: ...
    @overload
    def DecomposeAffine(self) -> Tuple[bool, Transform, Vector3d]: ...
    @overload
    def DecomposeAffine(self) -> Tuple[bool, Vector3d, Transform]: ...
    @overload
    def DecomposeAffine(self) -> Tuple[bool, Vector3d, Transform, Transform, Vector3d]: ...
    def DecomposeRigid(self, tolerance: float) -> Tuple[TransformRigidType, Vector3d, Transform]: ...
    def DecomposeSimilarity(self, tolerance: float) -> Tuple[TransformSimilarityType, Vector3d, float, Transform]: ...
    def DecomposeSymmetric(self) -> Tuple[bool, Transform, Vector3d]: ...
    @overload
    def Diagonal(diagonal: Vector3d) -> Transform: ...
    @overload
    def Diagonal(d0: float, d1: float, d2: float) -> Transform: ...
    @overload
    def Equals(self, other: Transform) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def Determinant(self) -> float: ...
    @property
    def Identity() -> Transform: ...
    @property
    def IsAffine(self) -> bool: ...
    @property
    def IsIdentity(self) -> bool: ...
    @property
    def IsLinear(self) -> bool: ...
    @property
    def IsRotation(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsZero(self) -> bool: ...
    @property
    def IsZero4x4(self) -> bool: ...
    @property
    def IsZeroTransformation(self) -> bool: ...
    @property
    def Item(self, row: int, column: int) -> float: ...
    @property
    def M00(self) -> float: ...
    @property
    def M01(self) -> float: ...
    @property
    def M02(self) -> float: ...
    @property
    def M03(self) -> float: ...
    @property
    def M10(self) -> float: ...
    @property
    def M11(self) -> float: ...
    @property
    def M12(self) -> float: ...
    @property
    def M13(self) -> float: ...
    @property
    def M20(self) -> float: ...
    @property
    def M21(self) -> float: ...
    @property
    def M22(self) -> float: ...
    @property
    def M23(self) -> float: ...
    @property
    def M30(self) -> float: ...
    @property
    def M31(self) -> float: ...
    @property
    def M32(self) -> float: ...
    @property
    def M33(self) -> float: ...
    @property
    def RigidType(self) -> TransformRigidType: ...
    @property
    def SimilarityType(self) -> TransformSimilarityType: ...
    @property
    def Unset() -> Transform: ...
    @property
    def ZeroTransformation() -> Transform: ...
    def GetEulerZYZ(self) -> Tuple[bool, float, float, float]: ...
    def GetHashCode(self) -> int: ...
    def GetYawPitchRoll(self) -> Tuple[bool, float, float, float]: ...
    def IsRigid(self, tolerance: float) -> TransformRigidType: ...
    def IsSimilarity(self, tolerance: float) -> TransformSimilarityType: ...
    def IsZeroTransformationWithTolerance(self, zeroTolerance: float) -> bool: ...
    def Linearize(self) -> None: ...
    @overload
    def Mirror(mirrorPlane: Plane) -> Transform: ...
    @overload
    def Mirror(pointOnMirrorPlane: Point3d, normalToMirrorPlane: Vector3d) -> Transform: ...
    def Multiply(a: Transform, b: Transform) -> Transform: ...
    def op_Equality(a: Transform, b: Transform) -> bool: ...
    def op_Inequality(a: Transform, b: Transform) -> bool: ...
    @overload
    def op_Multiply(m: Transform, v: Vector3d) -> Vector3d: ...
    @overload
    def op_Multiply(m: Transform, p: Point3d) -> Point3d: ...
    @overload
    def op_Multiply(a: Transform, b: Transform) -> Transform: ...
    def Orthogonalize(self, tolerance: float) -> bool: ...
    def PlanarProjection(plane: Plane) -> Transform: ...
    def PlaneToPlane(plane0: Plane, plane1: Plane) -> Transform: ...
    def ProjectAlong(plane: Plane, direction: Vector3d) -> Transform: ...
    @overload
    def Rotation(angleRadians: float, rotationCenter: Point3d) -> Transform: ...
    @overload
    def Rotation(angleRadians: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> Transform: ...
    @overload
    def Rotation(startDirection: Vector3d, endDirection: Vector3d, rotationCenter: Point3d) -> Transform: ...
    @overload
    def Rotation(sinAngle: float, cosAngle: float, rotationAxis: Vector3d, rotationCenter: Point3d) -> Transform: ...
    @overload
    def Rotation(x0: Vector3d, y0: Vector3d, z0: Vector3d, x1: Vector3d, y1: Vector3d, z1: Vector3d) -> Transform: ...
    def RotationZYX(yaw: float, pitch: float, roll: float) -> Transform: ...
    def RotationZYZ(alpha: float, beta: float, gamma: float) -> Transform: ...
    @overload
    def Scale(anchor: Point3d, scaleFactor: float) -> Transform: ...
    @overload
    def Scale(plane: Plane, xScaleFactor: float, yScaleFactor: float, zScaleFactor: float) -> Transform: ...
    @Item.setter
    def Item(self, row: int, column: int, value: float) -> None: ...
    @M00.setter
    def M00(self, value: float) -> None: ...
    @M01.setter
    def M01(self, value: float) -> None: ...
    @M02.setter
    def M02(self, value: float) -> None: ...
    @M03.setter
    def M03(self, value: float) -> None: ...
    @M10.setter
    def M10(self, value: float) -> None: ...
    @M11.setter
    def M11(self, value: float) -> None: ...
    @M12.setter
    def M12(self, value: float) -> None: ...
    @M13.setter
    def M13(self, value: float) -> None: ...
    @M20.setter
    def M20(self, value: float) -> None: ...
    @M21.setter
    def M21(self, value: float) -> None: ...
    @M22.setter
    def M22(self, value: float) -> None: ...
    @M23.setter
    def M23(self, value: float) -> None: ...
    @M30.setter
    def M30(self, value: float) -> None: ...
    @M31.setter
    def M31(self, value: float) -> None: ...
    @M32.setter
    def M32(self, value: float) -> None: ...
    @M33.setter
    def M33(self, value: float) -> None: ...
    def Shear(plane: Plane, x: Vector3d, y: Vector3d, z: Vector3d) -> Transform: ...
    def ToFloatArray(self, rowDominant: bool) -> Set(Single): ...
    def ToString(self) -> str: ...
    def TransformBoundingBox(self, bbox: BoundingBox) -> BoundingBox: ...
    def TransformList(self, points: Iterable[Point3d]) -> Set(Point3d): ...
    @overload
    def Translation(motion: Vector3d) -> Transform: ...
    @overload
    def Translation(dx: float, dy: float, dz: float) -> Transform: ...
    def Transpose(self) -> Transform: ...
    def TryGetInverse(self) -> Tuple[bool, Transform]: ...


class TransformRigidType:
    NotRigid = 0
    Rigid = 1
    RigidReversing = -1


class TransformSimilarityType:
    NotSimilarity = 0
    OrientationPreserving = 1
    OrientationReversing = -1


class Triangle3d:
    def __init__(self, a: Point3d, b: Point3d, c: Point3d): ...
    def BarycentricCoordsAt(self, point: Point3d) -> Tuple[Point2d, float]: ...
    def ClosestParameterOnBoundary(self, point: Point3d) -> float: ...
    def ClosestPointOnBoundary(self, point: Point3d) -> Point3d: ...
    @property
    def A(self) -> Point3d: ...
    @property
    def AB(self) -> Line: ...
    @property
    def AltitudeA(self) -> Line: ...
    @property
    def AltitudeB(self) -> Line: ...
    @property
    def AltitudeC(self) -> Line: ...
    @property
    def AngleA(self) -> float: ...
    @property
    def AngleB(self) -> float: ...
    @property
    def AngleC(self) -> float: ...
    @property
    def Area(self) -> float: ...
    @property
    def AreaCenter(self) -> Point3d: ...
    @property
    def B(self) -> Point3d: ...
    @property
    def BC(self) -> Line: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def C(self) -> Point3d: ...
    @property
    def CA(self) -> Line: ...
    @property
    def Circumcenter(self) -> Point3d: ...
    @property
    def Circumcircle(self) -> Circle: ...
    @property
    def MedianA(self) -> Line: ...
    @property
    def MedianB(self) -> Line: ...
    @property
    def MedianC(self) -> Line: ...
    @property
    def Orthocenter(self) -> Point3d: ...
    @property
    def Perimeter(self) -> float: ...
    @property
    def PerpendicularAB(self) -> Line: ...
    @property
    def PerpendicularBC(self) -> Line: ...
    @property
    def PerpendicularCA(self) -> Line: ...
    def PointAlongBoundary(self, t: float) -> Point3d: ...
    def PointAtBarycentricCoords(self, coords: Point2d) -> Point3d: ...
    def PointOnInterior(self, u: float, v: float) -> Point3d: ...
    def ToMesh(self) -> Mesh: ...
    def ToPolyline(self) -> Polyline: ...
    def Transform(self, transform: Transform) -> Triangle3d: ...
    def WithA(self, a: Point3d) -> Triangle3d: ...
    def WithB(self, b: Point3d) -> Triangle3d: ...
    def WithC(self, c: Point3d) -> Triangle3d: ...


class Unroller:
    @overload
    def __init__(self, surface: Surface): ...
    @overload
    def __init__(self, brep: Brep): ...
    @overload
    def AddFollowingGeometry(self, curves: Iterable[Curve]) -> None: ...
    @overload
    def AddFollowingGeometry(self, curve: Curve) -> None: ...
    @overload
    def AddFollowingGeometry(self, points: Iterable[Point3d]) -> None: ...
    @overload
    def AddFollowingGeometry(self, point: Point3d) -> None: ...
    @overload
    def AddFollowingGeometry(self, point: Point) -> None: ...
    @overload
    def AddFollowingGeometry(self, dots: Iterable[TextDot]) -> None: ...
    @overload
    def AddFollowingGeometry(self, dot: TextDot) -> None: ...
    @overload
    def AddFollowingGeometry(self, dotLocations: Iterable[Point3d], dotText: Iterable[str]) -> None: ...
    @overload
    def AddFollowingGeometry(self, dotLocation: Point3d, dotText: str) -> None: ...
    @overload
    def FollowingGeometryIndex(self, curve: Curve) -> int: ...
    @overload
    def FollowingGeometryIndex(self, dot: TextDot) -> int: ...
    @property
    def AbsoluteTolerance(self) -> float: ...
    @property
    def ExplodeOutput(self) -> bool: ...
    @property
    def ExplodeSpacing(self) -> float: ...
    @property
    def RelativeTolerance(self) -> float: ...
    @overload
    def PerformUnroll(self, flatbreps: List) -> int: ...
    @overload
    def PerformUnroll(self) -> Tuple[Set(Brep), Set(Curve), Set(Point3d), Set(TextDot)]: ...
    @AbsoluteTolerance.setter
    def AbsoluteTolerance(self, value: float) -> None: ...
    @ExplodeOutput.setter
    def ExplodeOutput(self, value: bool) -> None: ...
    @ExplodeSpacing.setter
    def ExplodeSpacing(self, value: float) -> None: ...
    @RelativeTolerance.setter
    def RelativeTolerance(self, value: float) -> None: ...


class Vector2d:
    def __init__(self, x: float, y: float): ...
    def Add(vector1: Vector2d, vector2: Vector2d) -> Vector2d: ...
    def CompareTo(self, other: Vector2d) -> int: ...
    def Divide(vector: Vector2d, t: float) -> Vector2d: ...
    def EpsilonEquals(self, other: Vector2d, epsilon: float) -> bool: ...
    @overload
    def Equals(self, vector: Vector2d) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def Length(self) -> float: ...
    @property
    def SquareLength(self) -> float: ...
    @property
    def Unset() -> Vector2d: ...
    @property
    def X(self) -> float: ...
    @property
    def Y(self) -> float: ...
    @property
    def Zero() -> Vector2d: ...
    def GetHashCode(self) -> int: ...
    @overload
    def IsTiny(self) -> bool: ...
    @overload
    def IsTiny(self, tolerance: float) -> bool: ...
    @overload
    def Multiply(vector1: Vector2d, vector2: Vector2d) -> float: ...
    @overload
    def Multiply(vector: Vector2d, t: float) -> Vector2d: ...
    @overload
    def Multiply(t: float, vector: Vector2d) -> Vector2d: ...
    def Negate(vector: Vector2d) -> Vector2d: ...
    def op_Addition(vector1: Vector2d, vector2: Vector2d) -> Vector2d: ...
    def op_Division(vector: Vector2d, t: float) -> Vector2d: ...
    def op_Equality(a: Vector2d, b: Vector2d) -> bool: ...
    def op_GreaterThan(a: Vector2d, b: Vector2d) -> bool: ...
    def op_GreaterThanOrEqual(a: Vector2d, b: Vector2d) -> bool: ...
    def op_Inequality(a: Vector2d, b: Vector2d) -> bool: ...
    def op_LessThan(a: Vector2d, b: Vector2d) -> bool: ...
    def op_LessThanOrEqual(a: Vector2d, b: Vector2d) -> bool: ...
    @overload
    def op_Multiply(t: float, vector: Vector2d) -> Vector2d: ...
    @overload
    def op_Multiply(vector: Vector2d, t: float) -> Vector2d: ...
    @overload
    def op_Multiply(vector1: Vector2d, vector2: Vector2d) -> float: ...
    def op_Subtraction(vector1: Vector2d, vector2: Vector2d) -> Vector2d: ...
    def op_UnaryNegation(vector: Vector2d) -> Vector2d: ...
    def Rotate(self, angleRadians: float) -> bool: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    def Subtract(vector1: Vector2d, vector2: Vector2d) -> Vector2d: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Unitize(self) -> bool: ...


class Vector2f:
    def __init__(self, x: Single, y: Single): ...
    def CompareTo(self, other: Vector2f) -> int: ...
    def EpsilonEquals(self, other: Vector2f, epsilon: Single) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @overload
    def Equals(self, vector: Vector2f) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def SquareLength(self) -> Single: ...
    @property
    def X(self) -> Single: ...
    @property
    def Y(self) -> Single: ...
    def GetHashCode(self) -> int: ...
    def Multiply(point1: Vector2f, point2: Vector2f) -> float: ...
    def op_Addition(a: Vector2f, b: Vector2f) -> Vector2f: ...
    def op_Equality(a: Vector2f, b: Vector2f) -> bool: ...
    def op_GreaterThan(a: Vector2f, b: Vector2f) -> bool: ...
    def op_GreaterThanOrEqual(a: Vector2f, b: Vector2f) -> bool: ...
    def op_Inequality(a: Vector2f, b: Vector2f) -> bool: ...
    def op_LessThan(a: Vector2f, b: Vector2f) -> bool: ...
    def op_LessThanOrEqual(a: Vector2f, b: Vector2f) -> bool: ...
    def op_Multiply(point1: Vector2f, point2: Vector2f) -> float: ...
    def op_Subtraction(a: Vector2f, b: Vector2f) -> Vector2f: ...
    @X.setter
    def X(self, value: Single) -> None: ...
    @Y.setter
    def Y(self, value: Single) -> None: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...


class Vector3d:
    @overload
    def __init__(self, point: Point3d): ...
    @overload
    def __init__(self, vector: Vector3f): ...
    @overload
    def __init__(self, vector: Vector3d): ...
    @overload
    def __init__(self, x: float, y: float, z: float): ...
    def Add(vector1: Vector3d, vector2: Vector3d) -> Vector3d: ...
    def AreOrthogonal(x: Vector3d, y: Vector3d, z: Vector3d) -> bool: ...
    def AreOrthonormal(x: Vector3d, y: Vector3d, z: Vector3d) -> bool: ...
    def AreRighthanded(x: Vector3d, y: Vector3d, z: Vector3d) -> bool: ...
    def CompareTo(self, other: Vector3d) -> int: ...
    def CrossProduct(a: Vector3d, b: Vector3d) -> Vector3d: ...
    def Divide(vector: Vector3d, t: float) -> Vector3d: ...
    def EpsilonEquals(self, other: Vector3d, epsilon: float) -> bool: ...
    @overload
    def Equals(self, vector: Vector3d) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def IsUnitVector(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsZero(self) -> bool: ...
    @property
    def Item(self, index: int) -> float: ...
    @property
    def Length(self) -> float: ...
    @property
    def MaximumCoordinate(self) -> float: ...
    @property
    def MinimumCoordinate(self) -> float: ...
    @property
    def SquareLength(self) -> float: ...
    @property
    def Unset() -> Vector3d: ...
    @property
    def X(self) -> float: ...
    @property
    def XAxis() -> Vector3d: ...
    @property
    def Y(self) -> float: ...
    @property
    def YAxis() -> Vector3d: ...
    @property
    def Z(self) -> float: ...
    @property
    def ZAxis() -> Vector3d: ...
    @property
    def Zero() -> Vector3d: ...
    def GetHashCode(self) -> int: ...
    @overload
    def IsParallelTo(self, other: Vector3d) -> int: ...
    @overload
    def IsParallelTo(self, other: Vector3d, angleTolerance: float) -> int: ...
    @overload
    def IsPerpendicularTo(self, other: Vector3d) -> bool: ...
    @overload
    def IsPerpendicularTo(self, other: Vector3d, angleTolerance: float) -> bool: ...
    @overload
    def IsTiny(self) -> bool: ...
    @overload
    def IsTiny(self, tolerance: float) -> bool: ...
    @overload
    def Multiply(vector: Vector3d, t: float) -> Vector3d: ...
    @overload
    def Multiply(t: float, vector: Vector3d) -> Vector3d: ...
    @overload
    def Multiply(vector1: Vector3d, vector2: Vector3d) -> float: ...
    def Negate(vector: Vector3d) -> Vector3d: ...
    def op_Addition(vector1: Vector3d, vector2: Vector3d) -> Vector3d: ...
    def op_Division(vector: Vector3d, t: float) -> Vector3d: ...
    def op_Equality(a: Vector3d, b: Vector3d) -> bool: ...
    def op_GreaterThan(a: Vector3d, b: Vector3d) -> bool: ...
    def op_GreaterThanOrEqual(a: Vector3d, b: Vector3d) -> bool: ...
    def op_Implicit(vector: Vector3f) -> Vector3d: ...
    def op_Inequality(a: Vector3d, b: Vector3d) -> bool: ...
    def op_LessThan(a: Vector3d, b: Vector3d) -> bool: ...
    def op_LessThanOrEqual(a: Vector3d, b: Vector3d) -> bool: ...
    @overload
    def op_Multiply(vector1: Vector3d, vector2: Vector3d) -> float: ...
    @overload
    def op_Multiply(t: float, vector: Vector3d) -> Vector3d: ...
    @overload
    def op_Multiply(vector: Vector3d, t: float) -> Vector3d: ...
    def op_Subtraction(vector1: Vector3d, vector2: Vector3d) -> Vector3d: ...
    def op_UnaryNegation(vector: Vector3d) -> Vector3d: ...
    def PerpendicularTo(self, other: Vector3d) -> bool: ...
    def Reverse(self) -> bool: ...
    def Rotate(self, angleRadians: float, rotationAxis: Vector3d) -> bool: ...
    @Item.setter
    def Item(self, index: int, value: float) -> None: ...
    @X.setter
    def X(self, value: float) -> None: ...
    @Y.setter
    def Y(self, value: float) -> None: ...
    @Z.setter
    def Z(self, value: float) -> None: ...
    def Subtract(vector1: Vector3d, vector2: Vector3d) -> Vector3d: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, transformation: Transform) -> None: ...
    def Unitize(self) -> bool: ...
    @overload
    def VectorAngle(a: Vector3d, b: Vector3d) -> float: ...
    @overload
    def VectorAngle(a: Vector3d, b: Vector3d, plane: Plane) -> float: ...
    @overload
    def VectorAngle(v1: Vector3d, v2: Vector3d, vNormal: Vector3d) -> float: ...


class Vector3f:
    def __init__(self, x: Single, y: Single, z: Single): ...
    @overload
    def Add(vector1: Vector3f, vector2: Vector3f) -> Vector3f: ...
    @overload
    def Add(point: Point3f, vector: Vector3f) -> Point3f: ...
    def CompareTo(self, other: Vector3f) -> int: ...
    def CrossProduct(a: Vector3f, b: Vector3f) -> Vector3f: ...
    @overload
    def Divide(vector: Vector3f, t: float) -> Vector3f: ...
    @overload
    def Divide(vector: Vector3f, t: Single) -> Vector3f: ...
    def EpsilonEquals(self, other: Vector3f, epsilon: Single) -> bool: ...
    @overload
    def Equals(self, vector: Vector3f) -> bool: ...
    @overload
    def Equals(self, obj: Object) -> bool: ...
    @property
    def IsUnitVector(self) -> bool: ...
    @property
    def IsValid(self) -> bool: ...
    @property
    def IsZero(self) -> bool: ...
    @property
    def Length(self) -> Single: ...
    @property
    def SquareLength(self) -> Single: ...
    @property
    def Unset() -> Vector3f: ...
    @property
    def X(self) -> Single: ...
    @property
    def XAxis() -> Vector3f: ...
    @property
    def Y(self) -> Single: ...
    @property
    def YAxis() -> Vector3f: ...
    @property
    def Z(self) -> Single: ...
    @property
    def ZAxis() -> Vector3f: ...
    @property
    def Zero() -> Vector3f: ...
    def GetHashCode(self) -> int: ...
    @overload
    def Multiply(t: Single, vector: Vector3f) -> Vector3f: ...
    @overload
    def Multiply(vector: Vector3f, t: Single) -> Vector3f: ...
    @overload
    def Multiply(point1: Vector3f, point2: Vector3f) -> float: ...
    def Negate(vector: Vector3f) -> Vector3f: ...
    @overload
    def op_Addition(vector1: Vector3f, vector2: Vector3f) -> Vector3f: ...
    @overload
    def op_Addition(point: Point3f, vector: Vector3f) -> Point3f: ...
    @overload
    def op_Division(vector: Vector3f, t: Single) -> Vector3f: ...
    @overload
    def op_Division(vector: Vector3f, t: float) -> Vector3f: ...
    def op_Equality(a: Vector3f, b: Vector3f) -> bool: ...
    def op_Explicit(vector: Vector3d) -> Vector3f: ...
    def op_GreaterThan(a: Vector3f, b: Vector3f) -> bool: ...
    def op_GreaterThanOrEqual(a: Vector3f, b: Vector3f) -> bool: ...
    def op_Inequality(a: Vector3f, b: Vector3f) -> bool: ...
    def op_LessThan(a: Vector3f, b: Vector3f) -> bool: ...
    def op_LessThanOrEqual(a: Vector3f, b: Vector3f) -> bool: ...
    @overload
    def op_Multiply(t: Single, vector: Vector3f) -> Vector3f: ...
    @overload
    def op_Multiply(vector: Vector3f, t: Single) -> Vector3f: ...
    @overload
    def op_Multiply(point1: Vector3f, point2: Vector3f) -> float: ...
    def op_Subtraction(vector1: Vector3f, vector2: Vector3f) -> Vector3f: ...
    def op_UnaryNegation(vector: Vector3f) -> Vector3f: ...
    def PerpendicularTo(self, other: Vector3f) -> bool: ...
    def Reverse(self) -> bool: ...
    def Rotate(self, angleRadians: float, rotationAxis: Vector3f) -> bool: ...
    @X.setter
    def X(self, value: Single) -> None: ...
    @Y.setter
    def Y(self, value: Single) -> None: ...
    @Z.setter
    def Z(self, value: Single) -> None: ...
    def Subtract(vector1: Vector3f, vector2: Vector3f) -> Vector3f: ...
    @overload
    def ToString(self) -> str: ...
    @overload
    def ToString(self, format: str, formatProvider: IFormatProvider) -> str: ...
    def Transform(self, transformation: Transform) -> None: ...
    def Unitize(self) -> bool: ...


class Visibility:
    Unset = 0
    Visible = 1
    Hidden = 2
    Duplicate = 3
    Projecting = 4
    Clipped = 5


class Visibility:
    Unset = 0
    Visible = 1
    Hidden = 2
    Duplicate = 3


class VolumeMassProperties:
    def CentroidCoordinatesPrincipalMoments(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    def CentroidCoordinatesPrincipalMomentsOfInertia(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    @overload
    def Compute(mesh: Mesh) -> VolumeMassProperties: ...
    @overload
    def Compute(brep: Brep) -> VolumeMassProperties: ...
    @overload
    def Compute(surface: Surface) -> VolumeMassProperties: ...
    @overload
    def Compute(geometry: Iterable[GeometryBase]) -> VolumeMassProperties: ...
    @overload
    def Compute(mesh: Mesh, volume: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> VolumeMassProperties: ...
    @overload
    def Compute(brep: Brep, volume: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> VolumeMassProperties: ...
    @overload
    def Compute(surface: Surface, volume: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> VolumeMassProperties: ...
    @overload
    def Compute(geometry: Iterable[GeometryBase], volume: bool, firstMoments: bool, secondMoments: bool, productMoments: bool) -> VolumeMassProperties: ...
    def Dispose(self) -> None: ...
    @property
    def Centroid(self) -> Point3d: ...
    @property
    def CentroidCoordinatesMomentsOfInertia(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesMomentsOfInertiaError(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesProductMoments(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesProductMomentsError(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesRadiiOfGyration(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesSecondMoments(self) -> Vector3d: ...
    @property
    def CentroidCoordinatesSecondMomentsError(self) -> Vector3d: ...
    @property
    def CentroidError(self) -> Vector3d: ...
    @property
    def Volume(self) -> float: ...
    @property
    def VolumeError(self) -> float: ...
    @property
    def WorldCoordinatesFirstMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesFirstMomentsError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesMomentsOfInertia(self) -> Vector3d: ...
    @property
    def WorldCoordinatesMomentsOfInertiaError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesProductMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesProductMomentsError(self) -> Vector3d: ...
    @property
    def WorldCoordinatesRadiiOfGyration(self) -> Vector3d: ...
    @property
    def WorldCoordinatesSecondMoments(self) -> Vector3d: ...
    @property
    def WorldCoordinatesSecondMomentsError(self) -> Vector3d: ...
    def Sum(self, summand: VolumeMassProperties) -> bool: ...
    def WorldCoordinatesPrincipalMoments(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
    def WorldCoordinatesPrincipalMomentsOfInertia(self) -> Tuple[bool, float, Vector3d, float, Vector3d, float, Vector3d]: ...
