from typing import Tuple, Set, Iterable, List


class ComponentFunctionInfo:
    def Evaluate(self, args: IEnumerable, keepTree: bool) -> Tuple[Set(Object), Set(str)]: ...
    @property
    def ComponentGuid(self) -> Guid: ...
    @property
    def Delegate(self) -> Delegate: ...
    @property
    def DelegateNoWarnings(self) -> Delegate: ...
    @property
    def DelegateTree(self) -> Delegate: ...
    @property
    def DelegateTreeNoWarnings(self) -> Delegate: ...
    @property
    def Description(self) -> str: ...
    @property
    def FullName(self) -> str: ...
    @property
    def FullScriptingName(self) -> str: ...
    @property
    def InputDescriptions(self) -> IReadOnlyList: ...
    @property
    def InputNames(self) -> IReadOnlyList: ...
    @property
    def InputsOptional(self) -> IReadOnlyList: ...
    @property
    def InputTypeNames(self) -> IReadOnlyList: ...
    @property
    def IsDefault(self) -> bool: ...
    @property
    def Name(self) -> str: ...
    @property
    def Namespace(self) -> str: ...
    @property
    def OutputDescriptions(self) -> IReadOnlyList: ...
    @property
    def OutputNames(self) -> IReadOnlyList: ...
    @property
    def OutputTypeNames(self) -> IReadOnlyList: ...
    def Invoke(self, args: Set(Object)) -> Set(Object): ...
    def InvokeKeepTree(self, args: Set(Object)) -> Set(Object): ...
    def InvokeKeepTreeSilenceWarnings(self, args: Set(Object)) -> Set(Object): ...
    def InvokeSilenceWarnings(self, args: Set(Object)) -> Set(Object): ...
    def ToString(self) -> str: ...


class Components:
    def FindComponent(fullName: str) -> ComponentFunctionInfo: ...
    @property
    def NodeInCodeFunctions() -> NodeInCodeTable: ...


class NodeInCodeTable:
    def __init__(self, items: Iterable[ComponentFunctionInfo]): ...
    def Add(self, item: ComponentFunctionInfo) -> None: ...
    @property
    def Count(self) -> int: ...
    def GetDynamicMemberNames(self) -> Iterable[str]: ...
    def TryGetIndex(self, binder: GetIndexBinder, indexes: Set(Object)) -> Tuple[bool, Object]: ...
    def TryGetMember(self, binder: GetMemberBinder) -> Tuple[bool, Object]: ...
    def TryInvokeMember(self, binder: InvokeMemberBinder, args: Set(Object)) -> Tuple[bool, Object]: ...
