from typing import Tuple, Set, Iterable, List


class BoolField(Field):
    @property
    def Value(self) -> bool: ...
    @Value.setter
    def Value(self, value: bool) -> None: ...
    def ValueAsObject(self) -> Object: ...


class ByteArrayField(Field):
    @property
    def Value(self) -> Set(Byte): ...
    @Value.setter
    def Value(self, value: Set(Byte)) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Color4fField(Field):
    @property
    def SystemColorValue(self) -> Color: ...
    @property
    def Value(self) -> Color4f: ...
    @SystemColorValue.setter
    def SystemColorValue(self, value: Color) -> None: ...
    @Value.setter
    def Value(self, value: Color4f) -> None: ...
    def ValueAsObject(self) -> Object: ...


class DateTimeField(Field):
    @property
    def Value(self) -> DateTime: ...
    @Value.setter
    def Value(self, value: DateTime) -> None: ...
    def ValueAsObject(self) -> Object: ...


class DoubleField(Field):
    @property
    def Value(self) -> float: ...
    @Value.setter
    def Value(self, value: float) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Field:
    @property
    def IsHiddenInAutoUI(self) -> bool: ...
    @property
    def Key(self) -> str: ...
    @property
    def Name(self) -> str: ...
    @property
    def Tag(self) -> Object: ...
    @property
    def TextureAmountMax(self) -> float: ...
    @property
    def TextureAmountMin(self) -> float: ...
    def GetValue(self) -> T: ...
    @IsHiddenInAutoUI.setter
    def IsHiddenInAutoUI(self, value: bool) -> None: ...
    @Tag.setter
    def Tag(self, value: Object) -> None: ...
    @TextureAmountMax.setter
    def TextureAmountMax(self, value: float) -> None: ...
    @TextureAmountMin.setter
    def TextureAmountMin(self, value: float) -> None: ...
    def ValueAsObject(self) -> Object: ...


class FieldDictionary:
    @overload
    def Add(self, key: str, value: Guid) -> GuidField: ...
    @overload
    def Add(self, key: str, value: Point3d) -> Point3dField: ...
    @overload
    def Add(self, key: str, value: DateTime) -> DateTimeField: ...
    @overload
    def Add(self, key: str, value: bool) -> BoolField: ...
    @overload
    def Add(self, key: str, value: int) -> IntField: ...
    @overload
    def Add(self, key: str, value: Vector3d) -> Vector3dField: ...
    @overload
    def Add(self, key: str, value: Transform) -> TransformField: ...
    @overload
    def Add(self, key: str, value: float) -> DoubleField: ...
    @overload
    def Add(self, key: str, value: Set(Byte)) -> ByteArrayField: ...
    @overload
    def Add(self, key: str, value: Vector2d) -> Vector2dField: ...
    @overload
    def Add(self, key: str, value: Color) -> Color4fField: ...
    @overload
    def Add(self, key: str, value: Color4f) -> Color4fField: ...
    @overload
    def Add(self, key: str, value: Single) -> FloatField: ...
    @overload
    def Add(self, key: str, value: str) -> StringField: ...
    @overload
    def Add(self, key: str, value: Point4d) -> Point4dField: ...
    @overload
    def Add(self, key: str, value: Point2d) -> Point2dField: ...
    @overload
    def Add(self, key: str, value: Point3d, prompt: str) -> Point3dField: ...
    @overload
    def Add(self, key: str, value: int, prompt: str) -> IntField: ...
    @overload
    def Add(self, key: str, value: Vector3d, prompt: str) -> Vector3dField: ...
    @overload
    def Add(self, key: str, value: bool, prompt: str) -> BoolField: ...
    @overload
    def Add(self, key: str, value: str, prompt: str) -> StringField: ...
    @overload
    def Add(self, key: str, value: Point2d, prompt: str) -> Point2dField: ...
    @overload
    def Add(self, key: str, value: Vector2d, prompt: str) -> Vector2dField: ...
    @overload
    def Add(self, key: str, value: Single, prompt: str) -> FloatField: ...
    @overload
    def Add(self, key: str, value: Point4d, prompt: str) -> Point4dField: ...
    @overload
    def Add(self, key: str, value: Guid, prompt: str) -> GuidField: ...
    @overload
    def Add(self, key: str, value: Color4f, prompt: str) -> Color4fField: ...
    @overload
    def Add(self, key: str, value: Transform, prompt: str) -> TransformField: ...
    @overload
    def Add(self, key: str, value: float, prompt: str) -> DoubleField: ...
    @overload
    def Add(self, key: str, value: DateTime, prompt: str) -> DateTimeField: ...
    @overload
    def Add(self, key: str, value: Color, prompt: str) -> Color4fField: ...
    @overload
    def Add(self, key: str, value: int, prompt: str, sectionId: int) -> IntField: ...
    @overload
    def Add(self, key: str, value: Single, prompt: str, sectionId: int) -> FloatField: ...
    @overload
    def Add(self, key: str, value: Color4f, prompt: str, sectionId: int) -> Color4fField: ...
    @overload
    def Add(self, key: str, value: float, prompt: str, sectionId: int) -> DoubleField: ...
    @overload
    def Add(self, key: str, value: Vector3d, prompt: str, sectionId: int) -> Vector3dField: ...
    @overload
    def Add(self, key: str, value: str, prompt: str, sectionId: int) -> StringField: ...
    @overload
    def Add(self, key: str, value: bool, prompt: str, sectionId: int) -> BoolField: ...
    @overload
    def Add(self, key: str, value: Transform, prompt: str, sectionId: int) -> TransformField: ...
    @overload
    def Add(self, key: str, value: Guid, prompt: str, sectionId: int) -> GuidField: ...
    @overload
    def Add(self, key: str, value: Point4d, prompt: str, sectionId: int) -> Point4dField: ...
    @overload
    def Add(self, key: str, value: Vector2d, prompt: str, sectionId: int) -> Vector2dField: ...
    @overload
    def Add(self, key: str, value: Point3d, prompt: str, sectionId: int) -> Point3dField: ...
    @overload
    def Add(self, key: str, value: DateTime, prompt: str, sectionId: int) -> DateTimeField: ...
    @overload
    def Add(self, key: str, value: Point2d, prompt: str, sectionId: int) -> Point2dField: ...
    def AddFilename(self, key: str, value: str, prompt: str, sectionId: int) -> StringField: ...
    @overload
    def AddTextured(self, key: str, value: Color, prompt: str) -> Color4fField: ...
    @overload
    def AddTextured(self, key: str, value: Vector3d, prompt: str) -> Vector3dField: ...
    @overload
    def AddTextured(self, key: str, value: Point4d, prompt: str) -> Point4dField: ...
    @overload
    def AddTextured(self, key: str, value: Guid, prompt: str) -> GuidField: ...
    @overload
    def AddTextured(self, key: str, value: Vector2d, prompt: str) -> Vector2dField: ...
    @overload
    def AddTextured(self, key: str, value: Transform, prompt: str) -> TransformField: ...
    @overload
    def AddTextured(self, key: str, value: Point2d, prompt: str) -> Point2dField: ...
    @overload
    def AddTextured(self, key: str, value: Point3d, prompt: str) -> Point3dField: ...
    @overload
    def AddTextured(self, key: str, value: float, prompt: str) -> DoubleField: ...
    @overload
    def AddTextured(self, key: str, value: Single, prompt: str) -> FloatField: ...
    @overload
    def AddTextured(self, key: str, value: DateTime, prompt: str) -> DateTimeField: ...
    @overload
    def AddTextured(self, key: str, value: str, prompt: str) -> StringField: ...
    @overload
    def AddTextured(self, key: str, value: int, prompt: str) -> IntField: ...
    @overload
    def AddTextured(self, key: str, value: bool, prompt: str) -> BoolField: ...
    @overload
    def AddTextured(self, key: str, value: DateTime, prompt: str, treatAsLinear: bool) -> DateTimeField: ...
    @overload
    def AddTextured(self, key: str, value: str, prompt: str, treatAsLinear: bool) -> StringField: ...
    @overload
    def AddTextured(self, key: str, value: Vector2d, prompt: str, treatAsLinear: bool) -> Vector2dField: ...
    @overload
    def AddTextured(self, key: str, value: Point4d, prompt: str, treatAsLinear: bool) -> Point4dField: ...
    @overload
    def AddTextured(self, key: str, value: Point2d, prompt: str, treatAsLinear: bool) -> Point2dField: ...
    @overload
    def AddTextured(self, key: str, value: bool, prompt: str, treatAsLinear: bool) -> BoolField: ...
    @overload
    def AddTextured(self, key: str, value: Guid, prompt: str, treatAsLinear: bool) -> GuidField: ...
    @overload
    def AddTextured(self, key: str, value: Color, prompt: str, treatAsLinear: bool) -> Color4fField: ...
    @overload
    def AddTextured(self, key: str, value: int, prompt: str, treatAsLinear: bool) -> IntField: ...
    @overload
    def AddTextured(self, key: str, value: float, prompt: str, treatAsLinear: bool) -> DoubleField: ...
    @overload
    def AddTextured(self, key: str, value: Color4f, prompt: str, treatAsLinear: bool) -> Color4fField: ...
    @overload
    def AddTextured(self, key: str, value: Transform, prompt: str, treatAsLinear: bool) -> TransformField: ...
    @overload
    def AddTextured(self, key: str, value: Single, prompt: str, treatAsLinear: bool) -> FloatField: ...
    @overload
    def AddTextured(self, key: str, value: Point3d, prompt: str, treatAsLinear: bool) -> Point3dField: ...
    @overload
    def AddTextured(self, key: str, value: Vector3d, prompt: str, treatAsLinear: bool) -> Vector3dField: ...
    @overload
    def AddTextured(self, key: str, value: Guid, prompt: str, treatAsLinear: bool, sectionId: int) -> GuidField: ...
    @overload
    def AddTextured(self, key: str, value: Point4d, prompt: str, treatAsLinear: bool, sectionId: int) -> Point4dField: ...
    @overload
    def AddTextured(self, key: str, value: Transform, prompt: str, treatAsLinear: bool, sectionId: int) -> TransformField: ...
    @overload
    def AddTextured(self, key: str, value: Point3d, prompt: str, treatAsLinear: bool, sectionId: int) -> Point3dField: ...
    @overload
    def AddTextured(self, key: str, value: Point2d, prompt: str, treatAsLinear: bool, sectionId: int) -> Point2dField: ...
    @overload
    def AddTextured(self, key: str, value: float, prompt: str, treatAsLinear: bool, sectionId: int) -> DoubleField: ...
    @overload
    def AddTextured(self, key: str, value: DateTime, prompt: str, treatAsLinear: bool, sectionId: int) -> DateTimeField: ...
    @overload
    def AddTextured(self, key: str, value: Color4f, prompt: str, treatAsLinear: bool, sectionId: int) -> Color4fField: ...
    @overload
    def AddTextured(self, key: str, value: Single, prompt: str, treatAsLinear: bool, sectionId: int) -> FloatField: ...
    @overload
    def AddTextured(self, key: str, value: int, prompt: str, treatAsLinear: bool, sectionId: int) -> IntField: ...
    @overload
    def AddTextured(self, key: str, value: bool, prompt: str, treatAsLinear: bool, sectionId: int) -> BoolField: ...
    @overload
    def AddTextured(self, key: str, value: Vector3d, prompt: str, treatAsLinear: bool, sectionId: int) -> Vector3dField: ...
    @overload
    def AddTextured(self, key: str, value: Vector2d, prompt: str, treatAsLinear: bool, sectionId: int) -> Vector2dField: ...
    @overload
    def AddTextured(self, key: str, value: str, prompt: str, treatAsLinear: bool, sectionId: int) -> StringField: ...
    def ContainsField(self, fieldName: str) -> bool: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetField(self, fieldName: str) -> Field: ...
    def RemoveField(self, fieldName: str) -> None: ...
    @overload
    def Set(self, key: str, value: float) -> None: ...
    @overload
    def Set(self, key: str, value: DateTime) -> None: ...
    @overload
    def Set(self, key: str, value: Transform) -> None: ...
    @overload
    def Set(self, key: str, value: Guid) -> None: ...
    @overload
    def Set(self, key: str, value: Point4d) -> None: ...
    @overload
    def Set(self, key: str, value: Point3d) -> None: ...
    @overload
    def Set(self, key: str, value: str) -> None: ...
    @overload
    def Set(self, key: str, value: bool) -> None: ...
    @overload
    def Set(self, key: str, value: Point2d) -> None: ...
    @overload
    def Set(self, key: str, value: Vector3d) -> None: ...
    @overload
    def Set(self, key: str, value: Color) -> None: ...
    @overload
    def Set(self, key: str, value: int) -> None: ...
    @overload
    def Set(self, key: str, value: Color4f) -> None: ...
    @overload
    def Set(self, key: str, value: Single) -> None: ...
    @overload
    def Set(self, key: str, value: Vector2d) -> None: ...
    @overload
    def Set(self, key: str, value: Set(Byte)) -> None: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Single]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Transform]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Point4d]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Point3d]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, T]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Point2d]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Vector3d]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, bool]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Vector2d]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, int]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Color]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, float]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Color4f]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, Set(Byte)]: ...
    @overload
    def TryGetValue(self, key: str) -> Tuple[bool, DateTime]: ...


class FloatField(Field):
    @property
    def Value(self) -> Single: ...
    @Value.setter
    def Value(self, value: Single) -> None: ...
    def ValueAsObject(self) -> Object: ...


class GuidField(Field):
    @property
    def Value(self) -> Guid: ...
    @Value.setter
    def Value(self, value: Guid) -> None: ...
    def ValueAsObject(self) -> Object: ...


class IntField(Field):
    @property
    def Value(self) -> int: ...
    @Value.setter
    def Value(self, value: int) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Point2dField(Field):
    @property
    def Value(self) -> Point2d: ...
    @Value.setter
    def Value(self, value: Point2d) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Point3dField(Field):
    @property
    def Value(self) -> Point3d: ...
    @Value.setter
    def Value(self, value: Point3d) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Point4dField(Field):
    @property
    def Value(self) -> Point4d: ...
    @Value.setter
    def Value(self, value: Point4d) -> None: ...
    def ValueAsObject(self) -> Object: ...


class StringField(Field):
    @property
    def Value(self) -> str: ...
    @Value.setter
    def Value(self, value: str) -> None: ...
    def ValueAsObject(self) -> Object: ...


class TransformField(Field):
    @property
    def Value(self) -> Transform: ...
    @Value.setter
    def Value(self, value: Transform) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Vector2dField(Field):
    @property
    def Value(self) -> Vector2d: ...
    @Value.setter
    def Value(self, value: Vector2d) -> None: ...
    def ValueAsObject(self) -> Object: ...


class Vector3dField(Field):
    @property
    def Value(self) -> Vector3d: ...
    @Value.setter
    def Value(self, value: Vector3d) -> None: ...
    def ValueAsObject(self) -> Object: ...
