from typing import Tuple, Set, Iterable, List


class CustomPostEffectAttribute:
    def __init__(self, postEffectType: PostEffectType, name: str, styles: PostEffectStyles, executeWhileRenderingOption: PostEffectExecuteWhileRenderingOptions, canDisplayHelp: bool, executeWhileRenderingDelay: int): ...
    @property
    def CanDisplayHelp(self) -> bool: ...
    @property
    def ExecuteWhileRenderingDelay(self) -> int: ...
    @property
    def ExecuteWhileRenderingOption(self) -> PostEffectExecuteWhileRenderingOptions: ...
    @property
    def Name(self) -> str: ...
    @property
    def PostEffectType(self) -> PostEffectType: ...
    @property
    def Styles(self) -> PostEffectStyles: ...
    @CanDisplayHelp.setter
    def CanDisplayHelp(self, value: bool) -> None: ...
    @ExecuteWhileRenderingDelay.setter
    def ExecuteWhileRenderingDelay(self, value: int) -> None: ...
    @ExecuteWhileRenderingOption.setter
    def ExecuteWhileRenderingOption(self, value: PostEffectExecuteWhileRenderingOptions) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @PostEffectType.setter
    def PostEffectType(self, value: PostEffectType) -> None: ...
    @Styles.setter
    def Styles(self, value: PostEffectStyles) -> None: ...


class IPostEffects:
    def GetPostEffects(self, type: PostEffectType) -> Set(PostEffect): ...
    def PostEffectFromId(self, uuid: Guid) -> PostEffect: ...


class PostEffect:
    def __init__(self): ...
    def AddUISections(self, ui: PostEffectUI) -> None: ...
    def BeginChange(self, changeContext: ChangeContexts) -> None: ...
    def CanExecute(self, pipeline: PostEffectPipeline) -> bool: ...
    def Changed(self) -> None: ...
    def DisplayHelp(self) -> bool: ...
    @overload
    def Dispose(self) -> None: ...
    @overload
    def Dispose(self, bDisposing: bool) -> None: ...
    def EndChange(self) -> bool: ...
    def Execute(self, pipeline: PostEffectPipeline, rect: Rectangle) -> bool: ...
    @property
    def CanDisplayHelp(self) -> bool: ...
    @property
    def ExecuteWhileRenderingOption(self) -> PostEffectExecuteWhileRenderingOptions: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IsSelected(self) -> bool: ...
    @property
    def LocalName(self) -> str: ...
    @property
    def On(self) -> bool: ...
    @property
    def PostEffectType(self) -> PostEffectType: ...
    @property
    def RequiredChannels(self) -> Set(Guid): ...
    @property
    def SerialNumber(self) -> int: ...
    @property
    def Shown(self) -> bool: ...
    @property
    def Styles(self) -> PostEffectStyles: ...
    def GetHashCode(self) -> int: ...
    def GetParam(self, param: str, v: Object) -> Tuple[bool, Object]: ...
    def ReadFromDocumentDefaults(self, doc: RhinoDoc) -> bool: ...
    def ReadState(self, state: PostEffectState) -> bool: ...
    @overload
    def RegisterPostEffect(plugin: PlugIn) -> Set(Type): ...
    @overload
    def RegisterPostEffect(assembly: Assembly, pluginId: Guid) -> Set(Type): ...
    def ResetToFactoryDefaults(self) -> None: ...
    @On.setter
    def On(self, value: bool) -> None: ...
    @SerialNumber.setter
    def SerialNumber(self, value: int) -> None: ...
    @Shown.setter
    def Shown(self, value: bool) -> None: ...
    def SetParam(self, param: str, v: Object) -> bool: ...
    def WriteState(self, state: PostEffectState) -> Tuple[bool, PostEffectState]: ...
    def WriteToDocumentDefaults(self, doc: RhinoDoc) -> bool: ...


class PostEffectChannel:
    def Clone(self) -> PostEffectChannel: ...
    def Commit(self) -> None: ...
    def CPU(self) -> Channel: ...
    def Dispose(self) -> None: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def PixelSize(self) -> int: ...
    def GPU(self) -> ChannelGPU: ...


class PostEffectExecuteContexts:
    ProductionRendering = 0
    RealtimeRendering = 1
    ViewportDisplay = 2
    ThumbnailCreation = 3
    ConvertingToHDR = 4


class PostEffectExecuteWhileRenderingOptions:
    #None = 0
    Always = 1
    UseDelay = 2


class PostEffectHistograms:
    #None = 0
    BeforeEarlyEffects = 1
    BeforeToneMapping = 2
    AfterEarlyEffects = 2
    AfterToneMapping = 4
    BeforeLateEffects = 4
    ToneMappingDisplay = 6
    AfterLateEffects = 8
    All = 15


class PostEffectJob:
    def __init__(self): ...
    def Clone(self) -> PostEffectJob: ...
    @overload
    def Dispose(self) -> None: ...
    @overload
    def Dispose(self, bDisposing: bool) -> None: ...
    def Execute(self, rect: Rectangle, access: PostEffectJobChannels) -> bool: ...


class PostEffectJobChannels:
    def Dispose(self) -> None: ...
    def GetChannel(self, channelId: Guid) -> PostEffectChannel: ...


class PostEffectPipeline:
    def Dimensions(self) -> Size: ...
    def Dispose(self) -> None: ...
    def Execute(self, p: Rectangle, renderingInProgress: bool, usageContexts: PostEffectExecuteContexts, histogramsToUpdate: PostEffectHistograms) -> bool: ...
    def ExecutionOrder(self) -> Set(Guid): ...
    @property
    def GPUAllowed(self) -> bool: ...
    @property
    def IsRendering(self) -> bool: ...
    @property
    def RenderingId(self) -> Guid: ...
    def GetChannelForRead(self, id: Guid) -> PostEffectChannel: ...
    def GetChannelForWrite(self, id: Guid) -> PostEffectChannel: ...
    def GetEndTimeInMilliseconds(self) -> UInt64: ...
    def GetMaxLuminance(self) -> Single: ...
    def GetStartTimeInMilliseconds(self) -> UInt64: ...
    def SetStartTimeInMilliseconds(self, ms: UInt64) -> None: ...
    def ThreadEngine(self) -> PostEffectThreadEngine: ...


class PostEffectState:
    def Dispose(self) -> None: ...
    def SetValue(self, name: str, vValue: T) -> bool: ...
    def TryGetValue(self, name: str) -> Tuple[bool, T]: ...


class PostEffectStyles:
    ExecuteForProductionRendering = 1
    ExecuteForRealtimeRendering = 2
    ExecuteForViewportDisplay = 4
    Fixed = 256
    DefaultShown = 512
    DefaultOn = 1024


class PostEffectThreadEngine:
    def Dispose(self) -> None: ...
    def RunPostEffect(self, job: PostEffectJob, pipeline: PostEffectPipeline, plugin: PostEffect, rect: Rectangle, channels: Set(Guid)) -> bool: ...


class PostEffectType:
    Early = 0
    ToneMapping = 1
    Late = 2


class PostEffectUI:
    def AddSection(self, section: ICollapsibleSection) -> None: ...
    def Dispose(self) -> None: ...
