__all__ = ['ChangeQueue','ChildSlotNames','DataSources','Fields','ParameterNames','PostEffects','UI']
from typing import Tuple, Set, Iterable, List


class AsyncRenderContext:
    def Dispose(self) -> None: ...
    @property
    def RenderThread(self) -> Thread: ...
    @property
    def RenderWindow(self) -> RenderWindow: ...
    def JoinRenderThread(self) -> None: ...
    @RenderWindow.setter
    def RenderWindow(self, value: RenderWindow) -> None: ...
    def StartRenderThread(self, threadStart: ThreadStart, threadName: str) -> bool: ...
    def StopRendering(self) -> None: ...


class Axis:
    kU = 0
    kV = 1
    kW = 2


class BackgroundProjections:
    Planar = 0
    Spherical = 1
    Emap = 2
    Box = 3
    Automatic = 4
    Lightprobe = 5
    Cubemap = 6
    VerticalCrossCubemap = 7
    HorizontalCrossCubemap = 8


class BasicMaterialParameterNames:
    def __init__(self): ...


class CachedTextureCoordinates(CommonObject):
    def Contains(self, item: Point3d) -> bool: ...
    def CopyTo(self, array: Set(Point3d), arrayIndex: int) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Dim(self) -> int: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def Item(self, index: int) -> Point3d: ...
    @property
    def MappingId(self) -> Guid: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def IndexOf(self, item: Point3d) -> int: ...
    def TryGetAt(self, index: int) -> Tuple[bool, float, float, float]: ...


class ChangeContexts:
    UI = 0
    Drop = 1
    Program = 2
    Ignore = 3
    Tree = 4
    Undo = 5
    FieldInit = 6
    Serialize = 7
    RealTimeUI = 8


class Channel:
    kRed = 0
    kGrn = 1
    kBlu = 2
    kAlp = 3
    kLum = 4


class Channel:
    def AddValue(self, x: int, y: int, value: Color4f) -> None: ...
    def Clone(self) -> Channel: ...
    def Dispose(self) -> None: ...
    @property
    def Height(self) -> int: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def Width(self) -> int: ...
    def GetMinMaxValues(self) -> Tuple[Single, Single]: ...
    def GetValue(self, x: int, y: int, componentOrder: ComponentOrders, values: Set(Single)) -> Tuple[Set(Single)]: ...
    def GetValues(self, rectangle: Rectangle, stride: int, componentOrder: ComponentOrders, values: Set(Single)) -> Tuple[Set(Single)]: ...
    def PixelSize(self) -> int: ...
    @overload
    def SetValue(self, x: int, y: int, value: Single) -> None: ...
    @overload
    def SetValue(self, x: int, y: int, value: Color4f) -> None: ...
    def SetValues(self, rectangle: Rectangle, bufferResolution: Size, colorBuffer: PixelBuffer) -> None: ...
    def SetValuesFlipped(self, rectangle: Rectangle, bufferResolution: Size, colorBuffer: PixelBuffer) -> None: ...


class ChannelGPU:
    def Clone(self) -> ChannelGPU: ...
    def Close(self) -> None: ...
    def CopyTo(self, channel: Channel) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def DisplayTechnology(self) -> DisplayTechnology: ...
    def Height(self) -> int: ...
    def Id(self) -> Guid: ...
    def PixelSize(self) -> UInt32: ...
    def TextureHandle(self) -> UInt32: ...
    def Width(self) -> int: ...


class City:
    def Cities() -> int: ...
    def CityAt(index: int) -> City: ...
    def FindNearest(latitude: float, longitude: float) -> City: ...
    @property
    def Latitude(self) -> float: ...
    @property
    def Longitude(self) -> float: ...
    @property
    def Name(self) -> str: ...
    @property
    def TimeZone(self) -> float: ...


class ComponentOrders:
    Irrelevant = 0
    RGBA = 1
    ARGB = 2
    RGB = 3
    XYZ = 3
    BGR = 4
    ZYX = 4
    ABGR = 5
    BGRA = 6


class ContentCollectionIterator:
    def __init__(self, pCollection: IntPtr): ...
    def DeleteThis(self) -> None: ...
    def Dispose(self) -> None: ...
    def First(self) -> RenderContent: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def Next(self) -> RenderContent: ...


class ContentUndoBlocker:
    def __init__(self): ...
    def Dispose(self) -> None: ...


class ContentUndoHelper:
    def __init__(self, doc: RhinoDoc, description: str): ...
    def AddContent(self, content: RenderContent, parent: RenderContent) -> bool: ...
    def Dispose(self) -> None: ...
    def ModifyContent(self, content: RenderContent) -> bool: ...
    def TweakContent(self, content: RenderContent, parameterName: str) -> bool: ...


class ContentUuids:
    @property
    def AdvancedDotTextureType() -> Guid: ...
    @property
    def BasicEnvironmentCCI() -> Guid: ...
    @property
    def BasicEnvironmentType() -> Guid: ...
    @property
    def BasicMaterialCCI() -> Guid: ...
    @property
    def BasicMaterialType() -> Guid: ...
    @property
    def BitmapTextureType() -> Guid: ...
    @property
    def BlendMaterialCCI() -> Guid: ...
    @property
    def BlendMaterialType() -> Guid: ...
    @property
    def BlendTextureType() -> Guid: ...
    @property
    def CompositeMaterialCCI() -> Guid: ...
    @property
    def CompositeMaterialType() -> Guid: ...
    @property
    def CrossHatchBumpTexture() -> Guid: ...
    @property
    def CubeMapTextureType() -> Guid: ...
    @property
    def DefaultEnvironmentInstance() -> Guid: ...
    @property
    def DefaultMaterialInstance() -> Guid: ...
    @property
    def DisplayAttributeMaterialType() -> Guid: ...
    @property
    def DotBumpTexture() -> Guid: ...
    @property
    def DoubleSidedMaterialType() -> Guid: ...
    @property
    def EmissionMaterialType() -> Guid: ...
    @property
    def ExposureTextureType() -> Guid: ...
    @property
    def EXRTextureType() -> Guid: ...
    @property
    def FBmTextureType() -> Guid: ...
    @property
    def GemMaterialType() -> Guid: ...
    @property
    def GlassMaterialType() -> Guid: ...
    @property
    def GradientTextureType() -> Guid: ...
    @property
    def GraniteTextureType() -> Guid: ...
    @property
    def GridTextureType() -> Guid: ...
    @property
    def GritBumpTexture() -> Guid: ...
    @property
    def HatchBumpTexture() -> Guid: ...
    @property
    def HDRTextureType() -> Guid: ...
    @property
    def LeatherBumpTexture() -> Guid: ...
    @property
    def MarbleTextureType() -> Guid: ...
    @property
    def MaskTextureType() -> Guid: ...
    @property
    def MetalMaterialType() -> Guid: ...
    @property
    def NoiseTextureType() -> Guid: ...
    @property
    def PaintMaterialType() -> Guid: ...
    @property
    def PerlinMarbleTextureType() -> Guid: ...
    @property
    def PerturbingTextureType() -> Guid: ...
    @property
    def PhysicallyBasedMaterialType() -> Guid: ...
    @property
    def PictureMaterialType() -> Guid: ...
    @property
    def PlasterMaterialType() -> Guid: ...
    @property
    def PlasticMaterialType() -> Guid: ...
    @property
    def ProjectionChangerTextureType() -> Guid: ...
    @property
    def RealtimeDisplayMaterialType() -> Guid: ...
    @property
    def ResampleTextureType() -> Guid: ...
    @property
    def SimpleBitmapTextureType() -> Guid: ...
    @property
    def SingleColorTextureType() -> Guid: ...
    @property
    def SpeckleBumpTexture() -> Guid: ...
    @property
    def StuccoTextureType() -> Guid: ...
    @property
    def Texture2DCheckerTextureType() -> Guid: ...
    @property
    def Texture3DCheckerTextureType() -> Guid: ...
    @property
    def TextureAdjustmentTextureType() -> Guid: ...
    @property
    def TileTextureType() -> Guid: ...
    @property
    def TurbulenceTextureType() -> Guid: ...
    @property
    def WavesTextureType() -> Guid: ...
    @property
    def WoodBumpTexture() -> Guid: ...
    @property
    def WoodTextureType() -> Guid: ...


class ConvertibleExtensions:
    def ToColor4f(variant: IConvertible) -> Color4f: ...
    def ToVector2d(variant: IConvertible) -> Vector2d: ...
    def ToVector3d(variant: IConvertible) -> Vector3d: ...


class CrcRenderHashFlags:
    Normal = 0
    ExcludeLinearWorkflow = 1
    ExcludeLocalMapping = 2
    Reserved1 = 4
    Reserved2 = 8


class CreatePreviewEventArgs:
    @property
    def Cancel(self) -> bool: ...
    @property
    def ContentKind(self) -> RenderContentKind: ...
    @property
    def ContentTypeId(self) -> Guid: ...
    @property
    def Environment(self) -> RenderEnvironment: ...
    @property
    def Id(self) -> int: ...
    @property
    def Lights(self) -> List: ...
    @property
    def Objects(self) -> List: ...
    @property
    def PreviewContent(self) -> RenderContent: ...
    @property
    def PreviewImage(self) -> Bitmap: ...
    @property
    def PreviewImageSize(self) -> Size: ...
    @property
    def PreviewNotifier(self) -> PreviewNotification: ...
    @property
    def Quality(self) -> PreviewSceneQuality: ...
    @property
    def Reason(self) -> CreatePreviewReason: ...
    @property
    def Viewport(self) -> ViewportInfo: ...
    @PreviewImage.setter
    def PreviewImage(self, value: Bitmap) -> None: ...
    def SkipInitialisation(self) -> None: ...


class CreatePreviewReason:
    ContentChanged = 0
    ViewChanged = 1
    RefreshDisplay = 2
    UpdateBitmap = 3
    Other = 99


class CreateTexture2dPreviewEventArgs:
    @property
    def PreviewImage(self) -> Bitmap: ...
    @property
    def PreviewImageSize(self) -> Size: ...
    @PreviewImage.setter
    def PreviewImage(self, value: Bitmap) -> None: ...


class CustomRenderContentAttribute:
    @overload
    def __init__(self, renderEngineGuid: str, imageBased: bool, category: str, is_elevated: bool, is_built_in: bool, is_private: bool): ...
    @overload
    def __init__(self, renderEngineGuid: str, imageBased: bool, category: str, is_elevated: bool, is_built_in: bool, is_private: bool, is_linear: bool, is_hdrcapable: bool, is_normalmap: bool): ...
    @property
    def Category(self) -> str: ...
    @property
    def ImageBased(self) -> bool: ...
    @property
    def IsBuiltIn(self) -> bool: ...
    @property
    def IsElevated(self) -> bool: ...
    @property
    def IsHdrCapable(self) -> bool: ...
    @property
    def IsLinear(self) -> bool: ...
    @property
    def IsNormalMap(self) -> bool: ...
    @property
    def IsPrivate(self) -> bool: ...
    @property
    def RenderEngineId(self) -> Guid: ...
    @Category.setter
    def Category(self, value: str) -> None: ...
    @ImageBased.setter
    def ImageBased(self, value: bool) -> None: ...
    @IsBuiltIn.setter
    def IsBuiltIn(self, value: bool) -> None: ...
    @IsElevated.setter
    def IsElevated(self, value: bool) -> None: ...
    @IsHdrCapable.setter
    def IsHdrCapable(self, value: bool) -> None: ...
    @IsLinear.setter
    def IsLinear(self, value: bool) -> None: ...
    @IsNormalMap.setter
    def IsNormalMap(self, value: bool) -> None: ...
    @IsPrivate.setter
    def IsPrivate(self, value: bool) -> None: ...


class CustomRenderMeshProvider2(CustomRenderMeshProvider):
    @overload
    def BoundingBox(self, vp: ViewportInfo, obj: RhinoObject, requestingPlugIn: Guid, preview: bool) -> BoundingBox: ...
    @overload
    def BoundingBox(self, vp: ViewportInfo, obj: RhinoObject, doc: RhinoDoc, requestingPlugIn: Guid, attrs: DisplayPipelineAttributes) -> BoundingBox: ...
    @overload
    def BuildCustomMeshes(self, vp: ViewportInfo, objMeshes: RenderPrimitiveList, requestingPlugIn: Guid, preview: bool) -> bool: ...
    @overload
    def BuildCustomMeshes(self, vp: ViewportInfo, doc: RhinoDoc, objMeshes: RenderPrimitiveList, requestingPlugIn: Guid, attrs: DisplayPipelineAttributes) -> bool: ...
    @overload
    def WillBuildCustomMeshes(self, vp: ViewportInfo, obj: RhinoObject, requestingPlugIn: Guid, preview: bool) -> bool: ...
    @overload
    def WillBuildCustomMeshes(self, vp: ViewportInfo, obj: RhinoObject, doc: RhinoDoc, requestingPlugIn: Guid, attrs: DisplayPipelineAttributes) -> bool: ...


class Decal:
    def ConstPointer(self) -> IntPtr: ...
    def Create(createParams: DecalCreateParams) -> Decal: ...
    def CustomData(self) -> List: ...
    @overload
    def Dispose(self) -> None: ...
    @overload
    def Dispose(self, isDisposing: bool) -> None: ...
    @property
    def CRC(self) -> int: ...
    @property
    def DecalMapping(self) -> DecalMapping: ...
    @property
    def DecalProjection(self) -> DecalProjection: ...
    @property
    def EndLatitude(self) -> float: ...
    @property
    def EndLongitude(self) -> float: ...
    @property
    def Height(self) -> float: ...
    @property
    def MapToInside(self) -> bool: ...
    @property
    def Origin(self) -> Point3d: ...
    @property
    def Radius(self) -> float: ...
    @property
    def StartLatitude(self) -> float: ...
    @property
    def StartLongitude(self) -> float: ...
    @property
    def TextureInstanceId(self) -> Guid: ...
    @property
    def Transparency(self) -> float: ...
    @property
    def VectorAcross(self) -> Vector3d: ...
    @property
    def VectorUp(self) -> Vector3d: ...
    def GetTextureMapping(self) -> TextureMapping: ...
    def NonConstPointer(self) -> IntPtr: ...
    @overload
    def TextureRenderCRC(self, rh: TextureRenderHashFlags) -> UInt32: ...
    @overload
    def TextureRenderCRC(self, rh: TextureRenderHashFlags, lw: LinearWorkflow) -> UInt32: ...
    def TryGetColor(self, point: Point3d, normal: Vector3d, colInOut: Color4f, uvOut: Point2d) -> Tuple[bool, Color4f, Point2d]: ...
    def UVBounds(self, minUOut: float, minVOut: float, maxUOut: float, maxVOut: float) -> Tuple[float, float, float, float]: ...


class DecalCreateParams:
    def __init__(self): ...
    @property
    def DecalMapping(self) -> DecalMapping: ...
    @property
    def DecalProjection(self) -> DecalProjection: ...
    @property
    def EndLatitude(self) -> float: ...
    @property
    def EndLongitude(self) -> float: ...
    @property
    def Height(self) -> float: ...
    @property
    def MapToInside(self) -> bool: ...
    @property
    def MaxU(self) -> float: ...
    @property
    def MaxV(self) -> float: ...
    @property
    def MinU(self) -> float: ...
    @property
    def MinV(self) -> float: ...
    @property
    def Origin(self) -> Point3d: ...
    @property
    def Radius(self) -> float: ...
    @property
    def StartLatitude(self) -> float: ...
    @property
    def StartLongitude(self) -> float: ...
    @property
    def TextureInstanceId(self) -> Guid: ...
    @property
    def Transparency(self) -> float: ...
    @property
    def VectorAcross(self) -> Vector3d: ...
    @property
    def VectorUp(self) -> Vector3d: ...
    @DecalMapping.setter
    def DecalMapping(self, value: DecalMapping) -> None: ...
    @DecalProjection.setter
    def DecalProjection(self, value: DecalProjection) -> None: ...
    @EndLatitude.setter
    def EndLatitude(self, value: float) -> None: ...
    @EndLongitude.setter
    def EndLongitude(self, value: float) -> None: ...
    @Height.setter
    def Height(self, value: float) -> None: ...
    @MapToInside.setter
    def MapToInside(self, value: bool) -> None: ...
    @MaxU.setter
    def MaxU(self, value: float) -> None: ...
    @MaxV.setter
    def MaxV(self, value: float) -> None: ...
    @MinU.setter
    def MinU(self, value: float) -> None: ...
    @MinV.setter
    def MinV(self, value: float) -> None: ...
    @Origin.setter
    def Origin(self, value: Point3d) -> None: ...
    @Radius.setter
    def Radius(self, value: float) -> None: ...
    @StartLatitude.setter
    def StartLatitude(self, value: float) -> None: ...
    @StartLongitude.setter
    def StartLongitude(self, value: float) -> None: ...
    @TextureInstanceId.setter
    def TextureInstanceId(self, value: Guid) -> None: ...
    @Transparency.setter
    def Transparency(self, value: float) -> None: ...
    @VectorAcross.setter
    def VectorAcross(self, value: Vector3d) -> None: ...
    @VectorUp.setter
    def VectorUp(self, value: Vector3d) -> None: ...


class DecalMapping:
    Planar = 0
    Cylindrical = 1
    Spherical = 2
    UV = 3


class DecalProjection:
    Forward = 0
    Backward = 1
    Both = 2


class Decals:
    def Add(self, decal: Decal) -> UInt32: ...
    def Clear(self) -> None: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def Remove(self, decal: Decal) -> bool: ...


class DisplayPipelineSettingsChangedEventArgs:
    def __init__(self, dpa: DisplayPipelineAttributes): ...
    @property
    def Attributes(self) -> DisplayPipelineAttributes: ...


class Dithering(DocumentOrFreeFloatingBase):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, d: Dithering): ...
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...
    @property
    def Method(self) -> Methods: ...
    @property
    def On(self) -> bool: ...
    @Method.setter
    def Method(self, value: Methods) -> None: ...
    @On.setter
    def On(self, value: bool) -> None: ...


class DocumentOrFreeFloatingBase(FreeFloatingBase):
    def BeginChange(self, cc: ChangeContexts) -> None: ...
    def EndChange(self) -> bool: ...


class DrawMiddlegroundEventArgs:
    def __init__(self, dp: DisplayPipeline): ...
    @property
    def Pipeline(self) -> DisplayPipeline: ...


class DynamicIconUsage:
    TreeControl = 0
    SubnodeControl = 1
    ContentControl = 2


class eLocalMappingType:
    lmt_none = 0
    lmt_2D = 1
    lmt_3D = 2
    lmt_force32bit = 4294967295


class EnvironmentMappingModes:
    Automatic = 0
    Spherical = 1
    Emap = 2
    Box = 3
    Lightprobe = 5
    Cubemap = 6
    VerticalCrossCubemap = 7
    HorizontalCrossCubemap = 8
    Hemispherical = 9


class ExtraRequirementsSetContexts:
    UI = 0
    Drop = 1
    Program = 2


class FilterContentByUsage:
    #None = 0
    Used = 1
    Unused = 2


class FreeFloatingBase:
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...


class GroundPlane(DocumentOrFreeFloatingBase):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, g: GroundPlane): ...
    def add_Changed(value: EventHandler) -> None: ...
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...
    @property
    def Altitude(self) -> float: ...
    @property
    def AutoAltitude(self) -> bool: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def MaterialInstanceId(self) -> Guid: ...
    @property
    def ShadowOnly(self) -> bool: ...
    @property
    def ShowUnderside(self) -> bool: ...
    @property
    def TextureOffset(self) -> Vector2d: ...
    @property
    def TextureOffsetLocked(self) -> bool: ...
    @property
    def TextureRotation(self) -> float: ...
    @property
    def TextureSize(self) -> Vector2d: ...
    @property
    def TextureSizeLocked(self) -> bool: ...
    def remove_Changed(value: EventHandler) -> None: ...
    @Altitude.setter
    def Altitude(self, value: float) -> None: ...
    @AutoAltitude.setter
    def AutoAltitude(self, value: bool) -> None: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @MaterialInstanceId.setter
    def MaterialInstanceId(self, value: Guid) -> None: ...
    @ShadowOnly.setter
    def ShadowOnly(self, value: bool) -> None: ...
    @ShowUnderside.setter
    def ShowUnderside(self, value: bool) -> None: ...
    @TextureOffset.setter
    def TextureOffset(self, value: Vector2d) -> None: ...
    @TextureOffsetLocked.setter
    def TextureOffsetLocked(self, value: bool) -> None: ...
    @TextureRotation.setter
    def TextureRotation(self, value: float) -> None: ...
    @TextureSize.setter
    def TextureSize(self, value: Vector2d) -> None: ...
    @TextureSizeLocked.setter
    def TextureSizeLocked(self, value: bool) -> None: ...


class HudMaxPassesChangedEventArgs:
    def __init__(self, mp: int): ...
    @property
    def MaxPasses(self) -> int: ...


class ICurrentEnvironment:
    @property
    def ForBackground(self) -> RenderEnvironment: ...
    @property
    def ForBackground_CheckMode(self) -> RenderEnvironment: ...
    @property
    def ForLighting(self) -> RenderEnvironment: ...
    @property
    def ForReflectionAndRefraction(self) -> RenderEnvironment: ...
    @ForAnyUsage.setter
    def ForAnyUsage(self, value: RenderEnvironment) -> None: ...
    @ForBackground_CheckMode.setter
    def ForBackground_CheckMode(self, value: RenderEnvironment) -> None: ...
    @ForBackground.setter
    def ForBackground(self, value: RenderEnvironment) -> None: ...
    @ForLighting.setter
    def ForLighting(self, value: RenderEnvironment) -> None: ...
    @ForReflectionAndRefraction.setter
    def ForReflectionAndRefraction(self, value: RenderEnvironment) -> None: ...


class ICurrentEnvironment_Get:
    @property
    def ForBackground(self) -> RenderEnvironment: ...
    @property
    def ForBackground_CheckMode(self) -> RenderEnvironment: ...
    @property
    def ForLighting(self) -> RenderEnvironment: ...
    @property
    def ForReflectionAndRefraction(self) -> RenderEnvironment: ...


class ImageAdjust:
    @property
    def Dither(self) -> Methods: ...
    @property
    def Gamma(self) -> Single: ...
    @Dither.setter
    def Dither(self, value: Methods) -> None: ...
    @Gamma.setter
    def Gamma(self, value: Single) -> None: ...


class ImageFile:
    def add_Deleted(value: EventHandler) -> None: ...
    def add_Loaded(value: EventHandler) -> None: ...
    def add_Saved(value: EventHandler) -> None: ...
    def remove_Deleted(value: EventHandler) -> None: ...
    def remove_Loaded(value: EventHandler) -> None: ...
    def remove_Saved(value: EventHandler) -> None: ...


class ImageFileEvent:
    Saved = 0
    Loaded = 1
    Deleted = 2


class ImageFileEventArgs:
    @property
    def EllapsedTime(self) -> int: ...
    @property
    def Event(self) -> ImageFileEvent: ...
    @property
    def FileName(self) -> str: ...
    @property
    def RenderEngine(self) -> str: ...
    @property
    def RenderEngineId(self) -> Guid: ...
    @property
    def SessionId(self) -> Guid: ...


class InitFramebufferEventArgs:
    def __init__(self, dp: DisplayPipeline): ...
    @property
    def Pipeline(self) -> DisplayPipeline: ...


class IRhRdkPreviewSceneServer_eRotationType:
    Camera = 0
    Object = 1


class it_strategy:
    ContentDataBase = 0
    ContentSelection = 1


class LightArray:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, pLightArray: IntPtr): ...
    def Append(self, light: Light) -> None: ...
    def Count(self) -> int: ...
    def Dispose(self) -> None: ...
    def ElementAt(self, index: int) -> Light: ...
    @property
    def CppPointer(self) -> IntPtr: ...


class LightManagerSupport:
    def DeleteLight(self, doc: RhinoDoc, light: Light, bUndelete: bool) -> bool: ...
    def GetLights(self, doc: RhinoDoc, light_array: LightArray) -> Tuple[LightArray]: ...
    def GetLightSolo(self, doc: RhinoDoc, uuid_light: Guid) -> bool: ...
    def GroupLights(self, doc: RhinoDoc, light_array: LightArray) -> Tuple[LightArray]: ...
    def LightDescription(self, doc: RhinoDoc, light: Light) -> Tuple[str, Light]: ...
    def LightFromId(self, doc: RhinoDoc, uuid: Guid, light: Light) -> Tuple[bool, Light]: ...
    def LightsInSoloStorage(self, doc: RhinoDoc) -> int: ...
    def ModifyLight(self, doc: RhinoDoc, light: Light) -> None: ...
    def ObjectSerialNumberFromLight(self, doc: RhinoDoc, light: Light) -> Tuple[int, Light]: ...
    def OnCustomLightEvent(self, doc: RhinoDoc, le: LightMangerSupportCustomEvent, light: Light) -> Tuple[Light]: ...
    def OnEditLight(self, doc: RhinoDoc, light_array: LightArray) -> Tuple[bool, LightArray]: ...
    def PluginId(self) -> Guid: ...
    def RegisterLightManager(plugin: PlugIn) -> None: ...
    def RegisterProviders(assembly: Assembly, pluginId: Guid) -> None: ...
    def RenderEngineId(self) -> Guid: ...
    def SetLightSolo(self, doc: RhinoDoc, uuid_light: Guid, bSolo: bool) -> bool: ...
    def UnGroup(self, doc: RhinoDoc, light_array: LightArray) -> Tuple[LightArray]: ...


class LightManagerSupportClient:
    def __init__(self, doc_uuid: UInt32): ...
    def DeleteLight(self, light: Light) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def GetLightFromId(self, uuid: Guid) -> Light: ...
    def GetLights(self) -> LightArray: ...
    def GetLightSolo(self, light: Light) -> bool: ...
    def GroupLights(self, lights: LightArray) -> None: ...
    def LightDescription(self, light: Light) -> str: ...
    def LightsInSoloStorage(self) -> int: ...
    def ModifyLight(self, light: Light) -> None: ...
    def ObjectFromLight(self, light: Light) -> RhinoObject: ...
    def OnEditLight(self, lights: LightArray) -> None: ...
    def SetLightSolo(self, light: Light, bSolo: bool) -> bool: ...
    def UnGroup(self, lights: LightArray) -> None: ...


class LightMangerSupportCustomEvent:
    light_added = 0
    light_deleted = 1
    light_undeleted = 2
    light_modified = 3
    light_sorted = 4


class LinearWorkflow(DocumentOrFreeFloatingBase):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, src: LinearWorkflow): ...
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...
    def Equals(self, obj: Object) -> bool: ...
    @property
    def Hash(self) -> UInt32: ...
    @property
    def PostProcessFrameBuffer(self) -> bool: ...
    @property
    def PostProcessGamma(self) -> Single: ...
    @property
    def PostProcessGammaOn(self) -> bool: ...
    @property
    def PostProcessGammaReciprocal(self) -> Single: ...
    @property
    def PreProcessColors(self) -> bool: ...
    @property
    def PreProcessGamma(self) -> Single: ...
    @property
    def PreProcessTextures(self) -> bool: ...
    def GetHashCode(self) -> int: ...
    @PostProcessFrameBuffer.setter
    def PostProcessFrameBuffer(self, value: bool) -> None: ...
    @PostProcessGamma.setter
    def PostProcessGamma(self, value: Single) -> None: ...
    @PostProcessGammaOn.setter
    def PostProcessGammaOn(self, value: bool) -> None: ...
    @PreProcessColors.setter
    def PreProcessColors(self, value: bool) -> None: ...
    @PreProcessGamma.setter
    def PreProcessGamma(self, value: Single) -> None: ...
    @PreProcessTextures.setter
    def PreProcessTextures(self, value: bool) -> None: ...


class LoadMultipleFlags:
    Normal = 0
    Preload = 1


class MappingTag:
    def __init__(self): ...
    @property
    def Id(self) -> Guid: ...
    @property
    def MappingCRC(self) -> UInt32: ...
    @property
    def MappingType(self) -> TextureMappingType: ...
    @property
    def MeshTransform(self) -> Transform: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @MappingCRC.setter
    def MappingCRC(self, value: UInt32) -> None: ...
    @MappingType.setter
    def MappingType(self, value: TextureMappingType) -> None: ...
    @MeshTransform.setter
    def MeshTransform(self, value: Transform) -> None: ...


class MatchDataResult:
    #None = 0
    Some = 1
    All = 2


class MetaDataProxy:
    def __init__(self): ...
    def Dispose(self) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SetContentInstanceId(self, uuid: Guid) -> None: ...


class Methods:
    #None = 0
    FloydSteinberg = 1
    SimpleNoise = 2


class Modes:
    Automatic = 0
    Custom = 1


class NamedValue:
    def __init__(self, name: str, value: Object): ...
    @property
    def Name(self) -> str: ...
    @property
    def Value(self) -> Object: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @Value.setter
    def Value(self, value: Object) -> None: ...


class PixelBuffer:
    def __init__(self, bufferPointer: IntPtr): ...
    @property
    def Buffer(self) -> IntPtr: ...


class PreviewAppearance:
    def __init__(self, pRenderContent: IntPtr): ...
    def Background(self) -> PreviewBackground: ...
    def Dispose(self) -> None: ...
    def FromMetaData(self, md: MetaData) -> None: ...
    def Geometry(self) -> PreviewGeometry: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    @property
    def MetaData(self) -> MetaData: ...
    @property
    def Scale(self) -> float: ...
    @property
    def SceneScale(self) -> float: ...
    def Lighting(self) -> PreviewLighting: ...
    def RotationType(self) -> IRhRdkPreviewSceneServer_eRotationType: ...
    def RotationX(self) -> float: ...
    def RotationY(self) -> float: ...
    @Scale.setter
    def Scale(self, value: float) -> None: ...
    def SetRotationType(self, type: IRhRdkPreviewSceneServer_eRotationType) -> None: ...
    def SetRotationX(self, d: float) -> None: ...
    def SetRotationY(self, d: float) -> None: ...
    @overload
    def ToMetaData(self) -> None: ...
    @overload
    def ToMetaData(self, mdp: MetaDataProxy) -> None: ...


class PreviewBackground:
    def __init__(self, pPreviewBackground: IntPtr): ...
    def ElementKind(self) -> str: ...
    def EnvironmentInstanceId(self) -> Guid: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SetEnvironmentInstanceId(self, guid: Guid) -> None: ...
    def SetUpPreview(self, sceneServerPointer: IntPtr, guid: Guid) -> None: ...


class PreviewBackgroundType:
    #None = 1
    Checkered = 2
    Scene = 4


class PreviewGeometry:
    def __init__(self, pPreviewGeometry: IntPtr): ...
    def ElementKind(self) -> str: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SetUpPreview(self, sceneServerPointer: IntPtr, pRenderContent: IntPtr, bCopy: bool) -> None: ...


class PreviewGeometryType:
    Sphere = 0
    Cube = 1
    Cone = 2
    Pyramid = 3
    Torus = 4
    Plane = 5
    Scene = 7


class PreviewLighting:
    def __init__(self, pPreviewLighting: IntPtr): ...
    def ElementKind(self) -> str: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SetUpPreview(self, sceneServerPointer: IntPtr) -> None: ...


class PreviewSceneQuality:
    #None = 0
    RealtimeQuick = 1
    Low = 1
    RefineFirstPass = 1
    RefineSecondPass = 2
    Medium = 2
    IntermediateProgressive = 3
    RefineThirdPass = 4
    Full = 4


class PreviewSceneServer:
    def __init__(self, pPreviewSceneServer: IntPtr): ...
    def ApplyRotation(self, X: float, Y: float, type: IRhRdkPreviewSceneServer_eRotationType) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SetSceneScale(self, scale: float) -> None: ...


class ProjectionModes:
    MappingChannel = 0
    View = 1
    Wcs = 2
    Emap = 3
    WcsBox = 4
    Screen = 5


class ProxyTypes:
    #None = 0
    Single = 1
    Multi = 2
    Texture = 3


class RdkInitialLocation:
    RenderContent = 0
    LastOpenedFolder = 1
    CustomFolder = 2


class RdkTextureSize:
    Size1 = 128
    Size2 = 256
    Size3 = 512
    Size4 = 1024
    Size5 = 2048


class RdkUndo:
    def __init__(self, pUndoRecord: IntPtr): ...
    def Dispose(self) -> None: ...
    def NewUndoRecord(self) -> RdkUndoRecord: ...


class RdkUndoRecord:
    def __init__(self, pUndoRecord: IntPtr): ...
    def Dispose(self) -> None: ...
    def SetDescription(self, description: str) -> None: ...


class RealtimeDisplayMode:
    def add_HudLockButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudLockButtonLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudLockButtonPressed(self, value: EventHandler) -> None: ...
    def add_HudLockButtonRightClicked(self, value: EventHandler) -> None: ...
    def add_HudPauseButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudPauseButtonLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudPauseButtonPressed(self, value: EventHandler) -> None: ...
    def add_HudPauseButtonRightClicked(self, value: EventHandler) -> None: ...
    def add_HudPlayButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudPlayButtonLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudPlayButtonPressed(self, value: EventHandler) -> None: ...
    def add_HudPlayButtonRightClicked(self, value: EventHandler) -> None: ...
    def add_HudPostEffectsOffButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudPostEffectsOffButtonLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudPostEffectsOffButtonRightClicked(self, value: EventHandler) -> None: ...
    def add_HudPostEffectsOnButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudPostEffectsOnButtonLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudPostEffectsOnButtonRightClicked(self, value: EventHandler) -> None: ...
    def add_HudProductNameDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudProductNameLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudProductNamePressed(self, value: EventHandler) -> None: ...
    def add_HudProductNameRightClicked(self, value: EventHandler) -> None: ...
    def add_HudStatusTextDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudStatusTextLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudStatusTextPressed(self, value: EventHandler) -> None: ...
    def add_HudStatusTextRightClicked(self, value: EventHandler) -> None: ...
    def add_HudTimeDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudTimeLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudTimePressed(self, value: EventHandler) -> None: ...
    def add_HudTimeRightClicked(self, value: EventHandler) -> None: ...
    def add_HudUnlockButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def add_HudUnlockButtonLeftClicked(self, value: EventHandler) -> None: ...
    def add_HudUnlockButtonPressed(self, value: EventHandler) -> None: ...
    def add_HudUnlockButtonRightClicked(self, value: EventHandler) -> None: ...
    def add_MaxPassesChanged(self, value: EventHandler) -> None: ...
    def add_OnDisplayPipelineSettingsChanged(self, value: EventHandler) -> None: ...
    def add_OnDrawMiddleground(self, value: EventHandler) -> None: ...
    def add_OnInitFramebuffer(self, value: EventHandler) -> None: ...
    def CaptureProgress(self) -> float: ...
    def ComputeViewportCrc(self, view: ViewInfo) -> UInt32: ...
    def CreateWorld(self, doc: RhinoDoc, viewInfo: ViewInfo, displayPipelineAttributes: DisplayPipelineAttributes) -> None: ...
    def DrawOpenGl(self) -> bool: ...
    @property
    def LinearWorkflow(self) -> LinearWorkflow: ...
    @property
    def Locked(self) -> bool: ...
    @property
    def MaxPasses(self) -> int: ...
    @property
    def Paused(self) -> bool: ...
    @property
    def PostEffectsOn(self) -> bool: ...
    @overload
    def GetRealtimeViewport(realtimeViewport: IntPtr) -> RealtimeDisplayMode: ...
    @overload
    def GetRealtimeViewport(realtimeViewport: IntPtr, create: bool) -> RealtimeDisplayMode: ...
    def GetRenderSize(self) -> Tuple[int, int]: ...
    def GetView(self) -> ViewInfo: ...
    def HudAllowEditMaxPasses(self) -> bool: ...
    def HudCustomStatusText(self) -> str: ...
    def HudLastRenderedPass(self) -> int: ...
    def HudMaximumPasses(self) -> int: ...
    def HudProductName(self) -> str: ...
    def HudRendererLocked(self) -> bool: ...
    def HudRendererPaused(self) -> bool: ...
    def HudShow(self) -> bool: ...
    def HudShowControls(self) -> bool: ...
    def HudShowCustomStatusText(self) -> bool: ...
    def HudShowMaxPasses(self) -> bool: ...
    def HudShowPasses(self) -> bool: ...
    def HudStartTime(self) -> DateTime: ...
    def IsCompleted(self) -> bool: ...
    def IsFrameBufferAvailable(self, view: ViewInfo) -> bool: ...
    def IsRendererStarted(self) -> bool: ...
    def LastRenderedPass(self) -> int: ...
    def OnRenderSizeChanged(self, width: int, height: int) -> bool: ...
    def OpenGlVersion(self) -> int: ...
    def PostConstruct(self) -> None: ...
    @overload
    def RegisterDisplayModes(plugin: PlugIn) -> Set(RealtimeDisplayModeClassInfo): ...
    @overload
    def RegisterDisplayModes(assembly: Assembly, pluginId: Guid) -> Set(RealtimeDisplayModeClassInfo): ...
    def remove_HudLockButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudLockButtonLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudLockButtonPressed(self, value: EventHandler) -> None: ...
    def remove_HudLockButtonRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudPauseButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudPauseButtonLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudPauseButtonPressed(self, value: EventHandler) -> None: ...
    def remove_HudPauseButtonRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudPlayButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudPlayButtonLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudPlayButtonPressed(self, value: EventHandler) -> None: ...
    def remove_HudPlayButtonRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudPostEffectsOffButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudPostEffectsOffButtonLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudPostEffectsOffButtonRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudPostEffectsOnButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudPostEffectsOnButtonLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudPostEffectsOnButtonRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudProductNameDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudProductNameLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudProductNamePressed(self, value: EventHandler) -> None: ...
    def remove_HudProductNameRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudStatusTextDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudStatusTextLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudStatusTextPressed(self, value: EventHandler) -> None: ...
    def remove_HudStatusTextRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudTimeDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudTimeLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudTimePressed(self, value: EventHandler) -> None: ...
    def remove_HudTimeRightClicked(self, value: EventHandler) -> None: ...
    def remove_HudUnlockButtonDoubleClicked(self, value: EventHandler) -> None: ...
    def remove_HudUnlockButtonLeftClicked(self, value: EventHandler) -> None: ...
    def remove_HudUnlockButtonPressed(self, value: EventHandler) -> None: ...
    def remove_HudUnlockButtonRightClicked(self, value: EventHandler) -> None: ...
    def remove_MaxPassesChanged(self, value: EventHandler) -> None: ...
    def remove_OnDisplayPipelineSettingsChanged(self, value: EventHandler) -> None: ...
    def remove_OnDrawMiddleground(self, value: EventHandler) -> None: ...
    def remove_OnInitFramebuffer(self, value: EventHandler) -> None: ...
    def RemoveRealtimeViewport(realtimeViewport: IntPtr) -> None: ...
    @Locked.setter
    def Locked(self, value: bool) -> None: ...
    @MaxPasses.setter
    def MaxPasses(self, value: int) -> None: ...
    @Paused.setter
    def Paused(self, value: bool) -> None: ...
    @PostEffectsOn.setter
    def PostEffectsOn(self, value: bool) -> None: ...
    def SetUseDrawOpenGl(self, use: bool) -> None: ...
    def SetView(self, view: ViewInfo) -> None: ...
    def ShowCaptureProgress(self) -> bool: ...
    def ShutdownRenderer(self) -> None: ...
    def SignalRedraw(self) -> None: ...
    def StartRenderer(self, w: int, h: int, doc: RhinoDoc, view: ViewInfo, viewportInfo: ViewportInfo, forCapture: bool, renderWindow: RenderWindow) -> bool: ...
    @overload
    def UnregisterDisplayModes(plugin: PlugIn) -> None: ...
    @overload
    def UnregisterDisplayModes(assembly: Assembly, pluginId: Guid) -> None: ...
    def UseFastDraw(self) -> bool: ...


class RealtimeDisplayModeClassInfo:
    @property
    def DontRegisterAttributesOnStart(self) -> bool: ...
    @property
    def DrawOpenGl(self) -> bool: ...
    @property
    def GUID(self) -> Guid: ...
    @property
    def Name(self) -> str: ...
    @property
    def RealtimeDisplayModeType(self) -> Type: ...


class RenderChannels(DocumentOrFreeFloatingBase):
    def add_Changed(value: EventHandler) -> None: ...
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...
    @property
    def CustomList(self) -> Set(Guid): ...
    @property
    def Mode(self) -> Modes: ...
    def remove_Changed(value: EventHandler) -> None: ...
    @CustomList.setter
    def CustomList(self, value: Set(Guid)) -> None: ...
    @Mode.setter
    def Mode(self, value: Modes) -> None: ...


class RenderContent:
    def add_ContentAdded(value: EventHandler) -> None: ...
    def add_ContentChanged(value: EventHandler) -> None: ...
    def add_ContentDeleted(value: EventHandler) -> None: ...
    def add_ContentDeleting(value: EventHandler) -> None: ...
    def add_ContentFieldChanged(value: EventHandler) -> None: ...
    def add_ContentRenamed(value: EventHandler) -> None: ...
    def add_ContentReplaced(value: EventHandler) -> None: ...
    def add_ContentReplacing(value: EventHandler) -> None: ...
    def add_ContentUpdatePreview(value: EventHandler) -> None: ...
    def add_CurrentEnvironmentChanged(value: EventHandler) -> None: ...
    def AddAutomaticUserInterfaceSection(self, caption: str, id: int) -> bool: ...
    def AddUserInterfaceSection(self, section: ICollapsibleSection) -> bool: ...
    def BeginChange(self, changeContext: ChangeContexts) -> None: ...
    def BeginCreateDynamicFields(self, automatic: bool) -> None: ...
    @overload
    def BindParameterToField(self, parameterName: str, field: Field, setEvent: ChangeContexts) -> None: ...
    @overload
    def BindParameterToField(self, parameterName: str, childSlotName: str, field: Field, setEvent: ChangeContexts) -> None: ...
    def ChildSlotAmount(self, childSlotName: str) -> float: ...
    def ChildSlotNameFromParamName(self, paramName: str) -> str: ...
    def ChildSlotOn(self, childSlotName: str) -> bool: ...
    def ConvertUnits(self, from_: UnitSystem, to: UnitSystem) -> None: ...
    @overload
    def Create(type: Guid, flags: ShowContentChooserFlags, doc: RhinoDoc) -> RenderContent: ...
    @overload
    def Create(type: Type, flags: ShowContentChooserFlags, doc: RhinoDoc) -> RenderContent: ...
    @overload
    def Create(type: Type, parent: RenderContent, childSlotName: str, flags: ShowContentChooserFlags, doc: RhinoDoc) -> RenderContent: ...
    @overload
    def Create(type: Guid, parent: RenderContent, childSlotName: str, flags: ShowContentChooserFlags, doc: RhinoDoc) -> RenderContent: ...
    def CreateDynamicField(self, internalName: str, localName: str, englishName: str, value: Object, minValue: Object, maxValue: Object, sectionId: int) -> bool: ...
    def DeleteAllChildren(self, changeContexts: ChangeContexts) -> None: ...
    def DeleteChild(self, childSlotName: str, changeContexts: ChangeContexts) -> bool: ...
    def Dispose(self) -> None: ...
    def DynamicIcon(self, size: Size, usage: DynamicIconUsage) -> Tuple[bool, Bitmap]: ...
    def Edit(self) -> RenderContent: ...
    def EndChange(self) -> None: ...
    def EndCreateDynamicFields(self) -> None: ...
    def Factory(self) -> ContentFactory: ...
    def FindChild(self, childSlotName: str) -> RenderContent: ...
    def ForDisplay(self) -> RenderContent: ...
    def FromId(document: RhinoDoc, id: Guid) -> RenderContent: ...
    def FromXml(xml: str, doc: RhinoDoc) -> RenderContent: ...
    @property
    def CanBeEdited(self) -> bool: ...
    @property
    def Category(self) -> str: ...
    @property
    def ChildSlotDisplayName(self) -> str: ...
    @property
    def ChildSlotName(self) -> str: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def DocumentAssoc(self) -> RhinoDoc: ...
    @property
    def DocumentRegistered(self) -> RhinoDoc: ...
    @property
    def Fields(self) -> FieldDictionary: ...
    @property
    def Filename(self) -> str: ...
    @property
    def FilesToEmbed(self) -> Iterable[str]: ...
    @property
    def FirstChild(self) -> RenderContent: ...
    @property
    def GroupId(self) -> Guid: ...
    @property
    def Hidden(self) -> bool: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def IsDefaultInstance(self) -> bool: ...
    @property
    def IsHiddenByAutoDelete(self) -> bool: ...
    @property
    def IsLocked(self) -> bool: ...
    @property
    def Name(self) -> str: ...
    @property
    def NextSibling(self) -> RenderContent: ...
    @property
    def Notes(self) -> str: ...
    @property
    def Parent(self) -> RenderContent: ...
    @property
    def ProxyType(self) -> ProxyTypes: ...
    @property
    def RenderHash(self) -> UInt32: ...
    @property
    def Styles(self) -> RenderContentStyles: ...
    @property
    def Tags(self) -> str: ...
    @property
    def TopLevel(self) -> bool: ...
    @property
    def TopLevelParent(self) -> RenderContent: ...
    @property
    def TypeDescription(self) -> str: ...
    @property
    def TypeId(self) -> Guid: ...
    @property
    def TypeName(self) -> str: ...
    @property
    def Xml(self) -> str: ...
    def GetChildSlotParameter(self, contentParameterName: str, extraRequirementParameter: str) -> Object: ...
    def GetEmbeddedFilesList(self) -> Set(str): ...
    def GetParameter(self, parameterName: str) -> Object: ...
    def GetUiHash(self) -> UInt64: ...
    def GetUnderlyingInstances(self, collection: RenderContentCollection) -> Tuple[bool, RenderContentCollection]: ...
    def Icon(self, size: Size) -> Tuple[bool, Bitmap]: ...
    def IsCompatible(self, renderEngineId: Guid) -> bool: ...
    def IsContentTypeAcceptableAsChild(self, type: Guid, childSlotName: str) -> bool: ...
    @overload
    def IsFactoryProductAcceptableAsChild(self, factory: ContentFactory, childSlotName: str) -> bool: ...
    @overload
    def IsFactoryProductAcceptableAsChild(self, kindId: Guid, factoryKind: str, childSlotName: str) -> bool: ...
    def IsReference(self) -> bool: ...
    def LoadFromFile(filename: str) -> RenderContent: ...
    def MakeCopy(self) -> RenderContent: ...
    def MakeGroupInstance(self) -> RenderContent: ...
    def MatchData(self, oldContent: RenderContent) -> MatchDataResult: ...
    def NewPreviewSceneServer(self, ssd: SceneServerData) -> PreviewSceneServer: ...
    def OpenInEditor(self) -> bool: ...
    def ParamNameFromChildSlotName(self, childSlotName: str) -> str: ...
    @overload
    def RegisterContent(plugin: PlugIn) -> Set(Type): ...
    @overload
    def RegisterContent(assembly: Assembly, pluginId: Guid) -> Set(Type): ...
    def remove_ContentAdded(value: EventHandler) -> None: ...
    def remove_ContentChanged(value: EventHandler) -> None: ...
    def remove_ContentDeleted(value: EventHandler) -> None: ...
    def remove_ContentDeleting(value: EventHandler) -> None: ...
    def remove_ContentFieldChanged(value: EventHandler) -> None: ...
    def remove_ContentRenamed(value: EventHandler) -> None: ...
    def remove_ContentReplaced(value: EventHandler) -> None: ...
    def remove_ContentReplacing(value: EventHandler) -> None: ...
    def remove_ContentUpdatePreview(value: EventHandler) -> None: ...
    def remove_CurrentEnvironmentChanged(value: EventHandler) -> None: ...
    @overload
    def RenderHashExclude(self, flags: TextureRenderHashFlags, excludeParameterNames: str) -> UInt32: ...
    @overload
    def RenderHashExclude(self, flags: CrcRenderHashFlags, excludeParameterNames: str) -> UInt32: ...
    @overload
    def RenderHashExclude(self, flags: CrcRenderHashFlags, excludeParameterNames: str, lw: LinearWorkflow) -> UInt32: ...
    def Replace(self, newcontent: RenderContent) -> bool: ...
    @ChildSlotName.setter
    def ChildSlotName(self, value: str) -> None: ...
    @DocumentAssoc.setter
    def DocumentAssoc(self, value: RhinoDoc) -> None: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...
    @GroupId.setter
    def GroupId(self, value: Guid) -> None: ...
    @Hidden.setter
    def Hidden(self, value: bool) -> None: ...
    @Id.setter
    def Id(self, value: Guid) -> None: ...
    @IsLocked.setter
    def IsLocked(self, value: bool) -> None: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @Notes.setter
    def Notes(self, value: str) -> None: ...
    @Tags.setter
    def Tags(self, value: str) -> None: ...
    def SetChild(self, renderContent: RenderContent, childSlotName: str) -> bool: ...
    def SetChildSlotAmount(self, childSlotName: str, amount: float, cc: ChangeContexts) -> None: ...
    def SetChildSlotOn(self, childSlotName: str, bOn: bool, cc: ChangeContexts) -> None: ...
    def SetChildSlotParameter(self, contentParameterName: str, extraRequirementParameter: str, value: Object, sc: ExtraRequirementsSetContexts) -> bool: ...
    def SetIsRenderHashRecursive(self, recursive: bool) -> None: ...
    def SetName(self, name: str, renameEvents: bool, ensureNameUnique: bool) -> None: ...
    def SetParameter(self, parameterName: str, value: Object) -> bool: ...
    def SmartUngroupRecursive(self) -> bool: ...
    def Ungroup(self) -> bool: ...
    def UngroupRecursive(self) -> bool: ...
    def UseCount(self) -> int: ...
    def VirtualIcon(self, size: Size) -> Tuple[bool, Bitmap]: ...


class RenderContentChangedEventArgs(RenderContentEventArgs):
    @property
    def ChangeContext(self) -> ChangeContexts: ...
    @property
    def OldContent(self) -> RenderContent: ...


class RenderContentChangeReason:
    #None = 0
    Attach = 1
    Detach = 2
    ChangeAttach = 3
    ChangeDetach = 4
    AttachUndo = 5
    DetachUndo = 6
    Open = 7
    Delete = 8


class RenderContentCollection:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, nativePtr: IntPtr): ...
    def Add(self, collection: RenderContentCollection) -> None: ...
    def Append(self, content: RenderContent) -> None: ...
    def Clear(self) -> None: ...
    def ContentAt(self, index: int) -> RenderContent: ...
    def ContentNeedsPreviewThumbnail(self, c: RenderContent, includeChildren: bool) -> bool: ...
    def Count(self) -> int: ...
    def Dispose(self) -> None: ...
    def Find_Sel(self, uuid: Guid) -> RenderContent: ...
    def FirstTag(self) -> str: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def GetFilterContentByUsage(self) -> FilterContentByUsage: ...
    def GetForcedVaries(self) -> bool: ...
    def GetSearchPattern(self) -> str: ...
    def Iterator(self) -> ContentCollectionIterator: ...
    def NextTag(self) -> str: ...
    def Remove(self, collection: RenderContentCollection) -> None: ...
    def Set(self, collection: RenderContentCollection) -> None: ...
    def SetForcedVaries(self, b: bool) -> None: ...
    def SetSearchPattern(self, pattern: str) -> None: ...


class RenderContentEventArgs:
    @property
    def Content(self) -> RenderContent: ...
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EnvironmentUsage(self) -> Usage: ...
    @property
    def Reason(self) -> RenderContentChangeReason: ...


class RenderContentFieldChangedEventArgs(RenderContentChangedEventArgs):
    @property
    def FieldName(self) -> str: ...


class RenderContentKind:
    #None = 0
    Material = 1
    Environment = 2
    Texture = 4


class RenderContentKindList:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, kind_list: RenderContentKindList): ...
    @overload
    def __init__(self, pRdkRenderContentKindList: IntPtr): ...
    def Add(self, kind: RenderContentKind) -> None: ...
    def Contains(self, kind: RenderContentKind) -> bool: ...
    def Count(self) -> int: ...
    def Dispose(self) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SingleKind(self) -> RenderContentKind: ...


class RenderContentManager:
    @property
    def UserRenderContentPath() -> str: ...
    def RestoreRenderContent() -> bool: ...


class RenderContentSerializer:
    def CanLoadMultiple(self) -> bool: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def ContentKind(self) -> RenderContentKind: ...
    @property
    def ContentType(self) -> RenderContentKind: ...
    @property
    def EnglishDescription(self) -> str: ...
    @property
    def FileExtension(self) -> str: ...
    @property
    def LocalDescription(self) -> str: ...
    def LoadMultiple(self, doc: RhinoDoc, fileNames: Iterable[str], contentKind: RenderContentKind, flags: LoadMultipleFlags) -> bool: ...
    def Read(self, pathToFile: str) -> RenderContent: ...
    def RegisterSerializer(self, id: Guid) -> bool: ...
    def ReportContentAndFile(self, renderContent: RenderContent, pathToFile: str, flags: int) -> None: ...
    def ReportDeferredContentAndFile(self, renderContent: RenderContent, pathToFile: str, flags: int) -> None: ...
    def Write(self, pathToFile: str, renderContent: RenderContent, previewArgs: CreatePreviewEventArgs) -> bool: ...


class RenderContentStyles:
    #None = 0
    TextureSummary = 1
    QuickPreview = 2
    PreviewCache = 4
    ProgressivePreview = 8
    LocalTextureMapping = 16
    GraphDisplay = 32
    SharedUI = 64
    Adjustment = 128
    Fields = 256
    ModalEditing = 512
    DynamicFields = 1024
    NameTypeSection = 2048


class RenderContentType:
    def __init__(self, typeId: Guid): ...
    def Dispose(self) -> None: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def InternalName(self) -> str: ...
    @property
    def PlugInId(self) -> Guid: ...
    @property
    def RenderEngineId(self) -> Guid: ...
    def GetAllAvailableTypes() -> Set(RenderContentType): ...
    @overload
    def NewContentFromTypeId(typeId: Guid) -> RenderContent: ...
    @overload
    def NewContentFromTypeId(typeId: Guid, doc: RhinoDoc) -> RenderContent: ...
    def NewRenderContent(self) -> RenderContent: ...


class RenderEndEventArgs:
    def __init__(self): ...


class RenderEnvironment(RenderContent):
    @property
    def CurrentEnvironment() -> RenderEnvironment: ...
    @property
    def TextureChildSlotName(self) -> str: ...
    @overload
    def NewBasicEnvironment(environment: SimulatedEnvironment) -> RenderEnvironment: ...
    @overload
    def NewBasicEnvironment(environment: SimulatedEnvironment, doc: RhinoDoc) -> RenderEnvironment: ...
    @CurrentEnvironment.setter
    def CurrentEnvironment(value: RenderEnvironment) -> None: ...
    @overload
    def SimulateEnvironment(self, isForDataOnly: bool) -> SimulatedEnvironment: ...
    @overload
    def SimulateEnvironment(self, simulation: SimulatedEnvironment, isForDataOnly: bool) -> Tuple[SimulatedEnvironment]: ...


class RenderEnvironmentTable:
    def Add(self, c: RenderEnvironment) -> bool: ...
    def BeginChange(self, changeContext: ChangeContexts) -> None: ...
    def EndChange(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> RenderEnvironment: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def Remove(self, c: RenderEnvironment) -> bool: ...


class RenderingSources:
    ActiveViewport = 0
    SpecificViewport = 1
    NamedView = 2
    SnapShot = 3


class RenderMaterial(RenderContent):
    def ConvertToPhysicallyBased(self, tg: TextureGeneration) -> PhysicallyBasedMaterial: ...
    def CreateBasicMaterial(material: Material, doc: RhinoDoc) -> RenderMaterial: ...
    def CreateImportedMaterial(material: Material, doc: RhinoDoc, reference: bool) -> RenderMaterial: ...
    def FromMaterial(material: Material, doc: RhinoDoc) -> RenderMaterial: ...
    @property
    def DefaultPreviewBackgroundType(self) -> PreviewBackgroundType: ...
    @property
    def DefaultPreviewGeometryType(self) -> PreviewGeometryType: ...
    @property
    def DefaultPreviewSize(self) -> float: ...
    @property
    def GemMaterialGuid() -> Guid: ...
    @property
    def GlassMaterialGuid() -> Guid: ...
    @property
    def MetalMaterialGuid() -> Guid: ...
    @property
    def PaintMaterialGuid() -> Guid: ...
    @property
    def PictureMaterialGuid() -> Guid: ...
    @property
    def PlasterMaterialGuid() -> Guid: ...
    @property
    def PlasticMaterialGuid() -> Guid: ...
    @property
    def SmellsLikeGem(self) -> bool: ...
    @property
    def SmellsLikeGlass(self) -> bool: ...
    @property
    def SmellsLikeMetal(self) -> bool: ...
    @property
    def SmellsLikePaint(self) -> bool: ...
    @property
    def SmellsLikePlaster(self) -> bool: ...
    @property
    def SmellsLikePlastic(self) -> bool: ...
    @property
    def SmellsLikeTexturedGem(self) -> bool: ...
    @property
    def SmellsLikeTexturedGlass(self) -> bool: ...
    @property
    def SmellsLikeTexturedMetal(self) -> bool: ...
    @property
    def SmellsLikeTexturedPaint(self) -> bool: ...
    @property
    def SmellsLikeTexturedPlaster(self) -> bool: ...
    @property
    def SmellsLikeTexturedPlastic(self) -> bool: ...
    def GetTextureAmountFromUsage(self, slot: StandardChildSlots) -> float: ...
    def GetTextureFromUsage(self, slot: StandardChildSlots) -> RenderTexture: ...
    def GetTextureOnFromUsage(self, slot: StandardChildSlots) -> bool: ...
    def HandleTexturedValue(self, slotname: str, tc: TexturedValue) -> bool: ...
    @DefaultPreviewBackgroundType.setter
    def DefaultPreviewBackgroundType(self, value: PreviewBackgroundType) -> None: ...
    @DefaultPreviewGeometryType.setter
    def DefaultPreviewGeometryType(self, value: PreviewGeometryType) -> None: ...
    @DefaultPreviewSize.setter
    def DefaultPreviewSize(self, value: float) -> None: ...
    def SimulatedMaterial(self, tg: TextureGeneration) -> Material: ...
    @overload
    def SimulateMaterial(self, simulation: Material, isForDataOnly: bool) -> Tuple[Material]: ...
    @overload
    def SimulateMaterial(self, simulation: Material, tg: TextureGeneration) -> Tuple[Material]: ...
    def SlotFromTextureType(tt: TextureType) -> StandardChildSlots: ...
    def TextureChildSlotName(self, slot: StandardChildSlots) -> str: ...
    def TextureTypeFromSlot(slot: StandardChildSlots) -> TextureType: ...


class RenderMaterialTable:
    def Add(self, c: RenderMaterial) -> bool: ...
    def BeginChange(self, changeContext: ChangeContexts) -> None: ...
    def EndChange(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> RenderMaterial: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def Remove(self, c: RenderMaterial) -> bool: ...


class RenderPanels:
    def FromRenderSessionId(plugIn: PlugIn, panelType: Type, renderSessionId: Guid) -> Object: ...
    def RegisterPanel(self, plugin: PlugIn, renderPanelType: RenderPanelType, panelType: Type, renderEngineId: Guid, caption: str, alwaysShow: bool, initialShow: bool) -> None: ...


class RenderPanelType:
    RenderWindow = 0


class RenderPipeline:
    def CloseWindow(self) -> bool: ...
    def CommandResult(self) -> Result: ...
    def Dispose(self) -> None: ...
    @property
    def PlugIn(self) -> PlugIn: ...
    @property
    def RenderSessionId(self) -> Guid: ...
    @overload
    def GetRenderWindow(self) -> RenderWindow: ...
    @overload
    def GetRenderWindow(self, withWireframeChannel: bool) -> RenderWindow: ...
    @overload
    def GetRenderWindow(self, withWireframeChannel: bool, fromRenderViewSource: bool) -> RenderWindow: ...
    def GetRenderWindowFromRenderViewSource(self, fromRenderViewSource: bool) -> RenderWindow: ...
    def LocalizeRenderReturnCode(rc: RenderReturnCode) -> str: ...
    def PauseRendering(self) -> None: ...
    def Render(self) -> RenderReturnCode: ...
    @overload
    def RenderSize(doc: RhinoDoc) -> Size: ...
    @overload
    def RenderSize(doc: RhinoDoc, fromRenderSources: bool) -> Size: ...
    def RenderWindow(self, view: RhinoView, rect: Rectangle, inWindow: bool) -> RenderReturnCode: ...
    def ResumeRendering(self) -> None: ...
    def SaveImage(self, fileName: str, saveAlpha: bool) -> bool: ...
    @ConfirmationSeconds.setter
    def ConfirmationSeconds(self, value: int) -> None: ...
    def SetAsyncRenderContext(self, aRC: AsyncRenderContext) -> Tuple[AsyncRenderContext]: ...
    def SupportsPause(self) -> bool: ...


class RenderPlugInInfo:
    @property
    def Name(self) -> str: ...
    @property
    def PlugInId(self) -> Guid: ...
    @Name.setter
    def Name(self, value: str) -> None: ...
    @PlugInId.setter
    def PlugInId(self, value: Guid) -> None: ...


class RenderPlugInList:
    def __init__(self): ...


class RenderPrimitive:
    def Dispose(self) -> None: ...
    @property
    def BoundingBox(self) -> BoundingBox: ...
    @property
    def InstanceTransform(self) -> Transform: ...
    @property
    def PrimitiveType(self) -> RenderPrimitiveType: ...
    @property
    def RenderMaterial(self) -> RenderMaterial: ...
    @property
    def RhinoObject(self) -> RhinoObject: ...
    def Mesh(self) -> Mesh: ...
    def TryGetBox(self) -> Tuple[bool, Box]: ...
    def TryGetCone(self) -> Tuple[bool, Cone, Plane]: ...
    def TryGetPlane(self) -> Tuple[bool, PlaneSurface]: ...
    def TryGetSphere(self) -> Tuple[bool, Sphere]: ...


class RenderPrimitiveList:
    @overload
    def Add(self, mesh: Mesh, material: RenderMaterial) -> None: ...
    @overload
    def Add(self, meshes: Iterable[Mesh], material: RenderMaterial) -> None: ...
    @overload
    def Add(self, sphere: Sphere, material: RenderMaterial) -> None: ...
    @overload
    def Add(self, plane: PlaneSurface, material: RenderMaterial) -> None: ...
    @overload
    def Add(self, box: Box, material: RenderMaterial) -> None: ...
    @overload
    def Add(self, mesh: Mesh, material: RenderMaterial, t: Transform) -> None: ...
    @overload
    def Add(self, cone: Cone, truncation: Plane, material: RenderMaterial) -> None: ...
    def AutoDeleteMaterialsOn(self) -> bool: ...
    def AutoDeleteMeshesOn(self) -> bool: ...
    def Clear(self) -> None: ...
    def ConvertMeshesToTriangles(self) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def RhinoObject(self) -> RhinoObject: ...
    @property
    def UseObjectsMappingChannels(self) -> bool: ...
    def GetInstanceTransform(self, index: int) -> Transform: ...
    def Material(self, index: int) -> RenderMaterial: ...
    def Mesh(self, index: int) -> Mesh: ...
    def MeshInstance(self, index: int) -> Tuple[Mesh, Transform]: ...
    def PrimitiveType(self, index: int) -> RenderPrimitiveType: ...
    @UseObjectsMappingChannels.setter
    def UseObjectsMappingChannels(self, value: bool) -> None: ...
    def SetInstanceTransform(self, index: int, xform: Transform) -> None: ...
    def ToMaterialArray(self) -> Set(RenderMaterial): ...
    def ToMeshArray(self) -> Set(Mesh): ...
    def TryGetBox(self, index: int) -> Tuple[bool, Box]: ...
    def TryGetCone(self, index: int) -> Tuple[bool, Cone, Plane]: ...
    def TryGetPlane(self, index: int) -> Tuple[bool, PlaneSurface]: ...
    def TryGetSphere(self, index: int) -> Tuple[bool, Sphere]: ...


class RenderPrimitiveType:
    #None = 0
    Mesh = 1
    Sphere = 2
    Plane = 3
    Box = 4
    Cone = 5


class RenderPropertyChangedEvent:
    @property
    def Context(self) -> int: ...
    @property
    def Document(self) -> RhinoDoc: ...


class RenderReturnCode:
    Ok = 0
    EmptyScene = 1
    Cancel = 2
    NoActiveView = 3
    OnPreCreateWindow = 4
    NoFrameWndPointer = 5
    ErrorCreatingWindow = 6
    ErrorStartingRender = 7
    EnterModalLoop = 8
    ExitModalLoop = 9
    ExitRhino = 10
    InternalError = 11


class RenderSettings(CommonObject):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, source: RenderSettings): ...
    @property
    def AmbientLight(self) -> Color: ...
    @property
    def AntialiasLevel(self) -> AntialiasLevel: ...
    @property
    def BackgroundColorBottom(self) -> Color: ...
    @property
    def BackgroundColorTop(self) -> Color: ...
    @property
    def BackgroundStyle(self) -> BackgroundStyle: ...
    @property
    def DepthCue(self) -> bool: ...
    @property
    def Dithering(self) -> Dithering: ...
    @property
    def FlatShade(self) -> bool: ...
    @property
    def ImageDpi(self) -> float: ...
    @property
    def ImageSize(self) -> Size: ...
    @property
    def ImageUnitSystem(self) -> UnitSystem: ...
    @property
    def LinearWorkflow(self) -> LinearWorkflow: ...
    @property
    def NamedView(self) -> str: ...
    @property
    def RenderAnnotations(self) -> bool: ...
    @property
    def RenderBackfaces(self) -> bool: ...
    @property
    def RenderChannels(self) -> RenderChannels: ...
    @property
    def RenderCurves(self) -> bool: ...
    @property
    def RenderIsoparams(self) -> bool: ...
    @property
    def RenderMeshEdges(self) -> bool: ...
    @property
    def RenderPoints(self) -> bool: ...
    @property
    def RenderSource(self) -> RenderingSources: ...
    @property
    def ScaleBackgroundToFit(self) -> bool: ...
    @property
    def ShadowmapLevel(self) -> int: ...
    @property
    def Snapshot(self) -> str: ...
    @property
    def SpecificViewport(self) -> str: ...
    @property
    def TransparentBackground(self) -> bool: ...
    @property
    def UseHiddenLights(self) -> bool: ...
    @property
    def UseViewportSize(self) -> bool: ...
    @AmbientLight.setter
    def AmbientLight(self, value: Color) -> None: ...
    @AntialiasLevel.setter
    def AntialiasLevel(self, value: AntialiasLevel) -> None: ...
    @BackgroundColorBottom.setter
    def BackgroundColorBottom(self, value: Color) -> None: ...
    @BackgroundColorTop.setter
    def BackgroundColorTop(self, value: Color) -> None: ...
    @BackgroundStyle.setter
    def BackgroundStyle(self, value: BackgroundStyle) -> None: ...
    @DepthCue.setter
    def DepthCue(self, value: bool) -> None: ...
    @FlatShade.setter
    def FlatShade(self, value: bool) -> None: ...
    @ImageDpi.setter
    def ImageDpi(self, value: float) -> None: ...
    @ImageSize.setter
    def ImageSize(self, value: Size) -> None: ...
    @ImageUnitSystem.setter
    def ImageUnitSystem(self, value: UnitSystem) -> None: ...
    @NamedView.setter
    def NamedView(self, value: str) -> None: ...
    @RenderAnnotations.setter
    def RenderAnnotations(self, value: bool) -> None: ...
    @RenderBackfaces.setter
    def RenderBackfaces(self, value: bool) -> None: ...
    @RenderCurves.setter
    def RenderCurves(self, value: bool) -> None: ...
    @RenderIsoparams.setter
    def RenderIsoparams(self, value: bool) -> None: ...
    @RenderMeshEdges.setter
    def RenderMeshEdges(self, value: bool) -> None: ...
    @RenderPoints.setter
    def RenderPoints(self, value: bool) -> None: ...
    @RenderSource.setter
    def RenderSource(self, value: RenderingSources) -> None: ...
    @ScaleBackgroundToFit.setter
    def ScaleBackgroundToFit(self, value: bool) -> None: ...
    @ShadowmapLevel.setter
    def ShadowmapLevel(self, value: int) -> None: ...
    @Snapshot.setter
    def Snapshot(self, value: str) -> None: ...
    @SpecificViewport.setter
    def SpecificViewport(self, value: str) -> None: ...
    @TransparentBackground.setter
    def TransparentBackground(self, value: bool) -> None: ...
    @UseHiddenLights.setter
    def UseHiddenLights(self, value: bool) -> None: ...
    @UseViewportSize.setter
    def UseViewportSize(self, value: bool) -> None: ...


class RenderSourceView:
    def __init__(self, doc: RhinoDoc): ...
    def Dispose(self) -> None: ...
    def GetViewInfo(self) -> ViewInfo: ...


class RenderSuccessCode:
    Completed = 0
    Failed = 1


class RenderTabs:
    def FromRenderSessionId(plugIn: PlugIn, tabType: Type, renderSessionId: Guid) -> Object: ...
    def RegisterTab(self, plugin: PlugIn, tabType: Type, renderEngineId: Guid, caption: str, icon: Icon) -> None: ...
    def SessionIdFromTab(tab: Object) -> Guid: ...


class RenderTexture(RenderContent):
    def CreateEvaluator(self, evaluatorFlags: TextureEvaluatorFlags) -> TextureEvaluator: ...
    @property
    def LocalMappingTransform(self) -> Transform: ...
    @property
    def PixelSize2(self) -> Nullable: ...
    @property
    def RenderHashWithoutLocalMapping(self) -> UInt32: ...
    def GetDisplayInViewport(self) -> bool: ...
    def GetEnvironmentMappingMode(self) -> TextureEnvironmentMappingMode: ...
    def GetEnvironmentMappingProjection(mode: TextureEnvironmentMappingMode, reflectionVector: Vector3d) -> Tuple[bool, Single, Single]: ...
    def GetInternalEnvironmentMappingMode(self) -> TextureEnvironmentMappingMode: ...
    def GetLocalMappingType(self) -> eLocalMappingType: ...
    def GetMappingChannel(self) -> int: ...
    def GetOffset(self) -> Vector3d: ...
    def GetOffsetLocked(self) -> bool: ...
    def GetPreviewIn3D(self) -> bool: ...
    def GetPreviewLocalMapping(self) -> bool: ...
    def GetProjectionMode(self) -> TextureProjectionMode: ...
    def GetRepeat(self) -> Vector3d: ...
    def GetRepeatLocked(self) -> bool: ...
    def GetRotation(self) -> Vector3d: ...
    def GetWcsBoxMapping(worldXyz: Point3d, normal: Vector3d) -> Point3d: ...
    def GetWrapType(self) -> TextureWrapType: ...
    def GraphInfo(self, tgi: TextureGraphInfo) -> Tuple[TextureGraphInfo]: ...
    def IsHdrCapable(self) -> bool: ...
    def IsImageBased(self) -> bool: ...
    def IsLinear(self) -> bool: ...
    def IsNormalMap(self) -> bool: ...
    @overload
    def NewBitmapTexture(texture: SimulatedTexture, doc: RhinoDoc) -> RenderTexture: ...
    @overload
    def NewBitmapTexture(bitmap: Bitmap, doc: RhinoDoc) -> RenderTexture: ...
    def PixelSize(self) -> Tuple[int, int, int]: ...
    def SaveAsImage(self, FullPath: str, width: int, height: int, depth: int) -> bool: ...
    @overload
    def SetDisplayInViewport(self, value: bool) -> None: ...
    @overload
    def SetDisplayInViewport(self, value: bool, changeContext: ChangeContexts) -> None: ...
    @overload
    def SetEnvironmentMappingMode(self, value: TextureEnvironmentMappingMode) -> None: ...
    @overload
    def SetEnvironmentMappingMode(self, value: TextureEnvironmentMappingMode, changeContext: ChangeContexts) -> None: ...
    def SetGraphInfo(self, tgi: TextureGraphInfo) -> None: ...
    def SetMappingChannel(self, value: int, changeContext: ChangeContexts) -> None: ...
    def SetOffset(self, value: Vector3d, changeContext: ChangeContexts) -> None: ...
    def SetOffsetLocked(self, value: bool, changeContext: ChangeContexts) -> None: ...
    def SetPreviewIn3D(self, value: bool, changeContext: ChangeContexts) -> None: ...
    @overload
    def SetPreviewLocalMapping(self, value: bool) -> None: ...
    @overload
    def SetPreviewLocalMapping(self, value: bool, changeContext: ChangeContexts) -> None: ...
    def SetProjectionMode(self, value: TextureProjectionMode, changeContext: ChangeContexts) -> None: ...
    def SetRepeat(self, value: Vector3d, changeContext: ChangeContexts) -> None: ...
    def SetRepeatLocked(self, value: bool, changeContext: ChangeContexts) -> None: ...
    def SetRotation(self, value: Vector3d, changeContext: ChangeContexts) -> None: ...
    def SetWrapType(self, value: TextureWrapType, changeContext: ChangeContexts) -> None: ...
    def SimulatedTexture(self, tg: TextureGeneration, size: int, obj: RhinoObject) -> SimulatedTexture: ...
    def SimulateTexture(self, simulation: SimulatedTexture, tg: TextureGeneration, size: int, obj: RhinoObject) -> Tuple[SimulatedTexture]: ...


class RenderTextureTable:
    def Add(self, c: RenderTexture) -> bool: ...
    def BeginChange(self, changeContext: ChangeContexts) -> None: ...
    def EndChange(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> RenderTexture: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def Remove(self, c: RenderTexture) -> bool: ...


class RenderWindow:
    def add_Cloned(value: EventHandler) -> None: ...
    def AddChannel(self, channel: StandardChannels) -> bool: ...
    def AddWireframeChannel(self, doc: RhinoDoc, viewport: ViewportInfo, size: Size, region: Rectangle) -> bool: ...
    def ChannelId(ch: StandardChannels) -> Guid: ...
    def Create(szSize: Size) -> RenderWindow: ...
    def Dispose(self) -> None: ...
    def EndAsyncRender(self, successCode: RenderSuccessCode) -> None: ...
    def FromSessionId(sessionId: Guid) -> RenderWindow: ...
    @property
    def SessionId(self) -> Guid: ...
    def GetBitmap(self) -> Bitmap: ...
    def GetRequestedRenderChannels(self) -> Set(Guid): ...
    def GetRequestedRenderChannelsAsStandardChannels(self) -> Set(StandardChannels): ...
    def Invalidate(self) -> None: ...
    def InvalidateArea(self, rect: Rectangle) -> None: ...
    def IsChannelAvailable(self, id: Guid) -> bool: ...
    def IsChannelShown(self, id: Guid) -> bool: ...
    def OpenChannel(self, id: StandardChannels) -> Channel: ...
    def remove_Cloned(value: EventHandler) -> None: ...
    def SaveDibAsBitmap(self, filename: str) -> None: ...
    @overload
    def SaveRenderImageAs(self, filename: str, saveAlpha: bool) -> None: ...
    @overload
    def SaveRenderImageAs(self, filename: str, renderEngineGuid: Guid, saveAlpha: bool) -> None: ...
    def SetIsRendering(self, is_rendering: bool) -> None: ...
    def SetProgress(self, text: str, progress: Single) -> None: ...
    @overload
    def SetRGBAChannelColors(self, rectangle: Rectangle, colors: Set(Color4f)) -> None: ...
    @overload
    def SetRGBAChannelColors(self, size: Size, colors: Set(Color4f)) -> None: ...
    def SetSize(self, size: Size) -> None: ...
    def SetView(self, view: ViewInfo) -> None: ...
    def Size(self) -> Size: ...
    def StandardChannelForGuid(id: Guid) -> StandardChannels: ...


class RenderWindowClonedEventArgs:
    @property
    def NewRenderWindow(self) -> RenderWindow: ...
    @property
    def NewSessionId(self) -> Guid: ...
    @property
    def OldRenderWindow(self) -> RenderWindow: ...
    @property
    def OldSessionId(self) -> Guid: ...


class SceneObject:
    @property
    def Material(self) -> RenderMaterial: ...
    @property
    def Mesh(self) -> Mesh: ...


class SceneServerData:
    def __init__(self, geo: PreviewGeometry, back: PreviewBackground, light: PreviewLighting, usage: SceneServerDataUsage): ...
    def Dispose(self) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...


class SceneServerDataUsage:
    Synchronous = 0
    Asynchronous = 1


class ShowContentChooserFlags:
    #None = 0
    HideNewTab = 1
    HideExistingTab = 2
    MultipleSelection = 4


class ShowContentChooserResults:
    #None = 0
    New = 1
    Copy = 2
    Instance = 3


class SimulatedEnvironment:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def BackgroundColor(self) -> Color: ...
    @property
    def BackgroundImage(self) -> SimulatedTexture: ...
    @property
    def BackgroundProjection(self) -> BackgroundProjections: ...
    def ProjectionFromString(projection: str) -> BackgroundProjections: ...
    @BackgroundColor.setter
    def BackgroundColor(self, value: Color) -> None: ...
    @BackgroundImage.setter
    def BackgroundImage(self, value: SimulatedTexture) -> None: ...
    @BackgroundProjection.setter
    def BackgroundProjection(self, value: BackgroundProjections) -> None: ...
    def StringFromProjection(projection: BackgroundProjections) -> str: ...


class SimulatedTexture:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, doc: RhinoDoc): ...
    @overload
    def __init__(self, texture: Texture): ...
    @overload
    def __init__(self, doc: RhinoDoc, texture: Texture): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def BitmapSize() -> int: ...
    @property
    def Filename(self) -> str: ...
    @property
    def Filtered(self) -> bool: ...
    @property
    def HasTransparentColor(self) -> bool: ...
    @property
    def LocalMappingTransform(self) -> Transform: ...
    @property
    def MappingChannel(self) -> int: ...
    @property
    def Offset(self) -> Vector2d: ...
    @property
    def OriginalFilename(self) -> str: ...
    @property
    def ProjectionMode(self) -> ProjectionModes: ...
    @property
    def Repeat(self) -> Vector2d: ...
    @property
    def Repeating(self) -> bool: ...
    @property
    def Rotation(self) -> float: ...
    @property
    def TransparentColor(self) -> Color4f: ...
    @property
    def TransparentColorSensitivity(self) -> float: ...
    def MetersToUnits(self, doc: RhinoDoc, units: float) -> float: ...
    @BitmapSize.setter
    def BitmapSize(value: int) -> None: ...
    @Filename.setter
    def Filename(self, value: str) -> None: ...
    @Filtered.setter
    def Filtered(self, value: bool) -> None: ...
    @HasTransparentColor.setter
    def HasTransparentColor(self, value: bool) -> None: ...
    @MappingChannel.setter
    def MappingChannel(self, value: int) -> None: ...
    @Offset.setter
    def Offset(self, value: Vector2d) -> None: ...
    @ProjectionMode.setter
    def ProjectionMode(self, value: ProjectionModes) -> None: ...
    @Repeat.setter
    def Repeat(self, value: Vector2d) -> None: ...
    @Repeating.setter
    def Repeating(self, value: bool) -> None: ...
    @Rotation.setter
    def Rotation(self, value: float) -> None: ...
    @TransparentColor.setter
    def TransparentColor(self, value: Color4f) -> None: ...
    @TransparentColorSensitivity.setter
    def TransparentColorSensitivity(self, value: float) -> None: ...
    def SetMappingChannelAndProjectionMode(self, pm: ProjectionModes, mappingChannel: int, emm: EnvironmentMappingModes) -> None: ...
    def Texture(self) -> Texture: ...
    def UnitsToMeters(self, doc: RhinoDoc, units: float) -> float: ...


class Skylight(DocumentOrFreeFloatingBase):
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, src: Skylight): ...
    def add_Changed(value: EventHandler) -> None: ...
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...
    @property
    def CustomEnvironment(self) -> Guid: ...
    @property
    def CustomEnvironmentOn(self) -> bool: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def ShadowIntensity(self) -> float: ...
    def remove_Changed(value: EventHandler) -> None: ...
    @CustomEnvironment.setter
    def CustomEnvironment(self, value: Guid) -> None: ...
    @CustomEnvironmentOn.setter
    def CustomEnvironmentOn(self, value: bool) -> None: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @ShadowIntensity.setter
    def ShadowIntensity(self, value: float) -> None: ...


class StandardChannels:
    #None = 0
    Red = 1
    Green = 2
    Blue = 4
    Alpha = 8
    RGBA = 14
    RGB = 15
    DistanceFromCamera = 16
    NormalX = 32
    NormalY = 64
    NormalZ = 128
    NormalXYZ = 240
    LuminanceRed = 256
    LuminanceGreen = 512
    LuminanceBlue = 1024
    BackgroundLuminanceRed = 4096
    BackgroundLuminanceGreen = 8192
    BackgroundLuminanceBlue = 16384
    MaterialIds = 65536
    ObjectIds = 131072
    Wireframe = 262144
    AlbedoRed = 1048576
    AlbedoGreen = 2097152
    AlbedoBlue = 4194304
    AlbedoRGB = 7340032
    WireframePointsRGBA = 8388608
    WireframeIsocurvesRGBA = 16777216
    WireframeCurvesRGBA = 33554432
    WireframeAnnotationsRGBA = 67108864


class StandardChildSlots:
    #None = 0
    Diffuse = 100
    PbrBaseColor = 100
    Transparency = 101
    PbrOpacity = 101
    Bump = 102
    Environment = 103
    PbrSubsurface = 104
    PbrSubSurfaceScattering = 105
    PbrSubsurfaceScatteringRadius = 106
    PbrMetallic = 107
    PbrSpecular = 108
    PbrSpecularTint = 109
    PbrRoughness = 110
    PbrAnisotropic = 111
    PbrAnisotropicRotation = 112
    PbrSheen = 113
    PbrSheenTint = 114
    PbrClearcoat = 115
    PbrClearcoatRoughness = 116
    PbrOpacityIor = 117
    PbrOpacityRoughness = 118
    PbrEmission = 119
    PbrAmbientOcclusion = 120
    PbrDisplacement = 121
    PbrClearcoatBump = 122
    PbrAlpha = 123


class Sun(DocumentOrFreeFloatingBase):
    def __init__(self): ...
    def add_Changed(value: EventHandler) -> None: ...
    def AltitudeFromValues(latitude: float, longitude: float, timezoneHours: float, daylightMinutes: int, when: DateTime, hours: float, fast: bool) -> float: ...
    def ColorFromAltitude(altitudeDegrees: float) -> Color: ...
    def CopyFrom(self, src: FreeFloatingBase) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Altitude(self) -> float: ...
    @property
    def Azimuth(self) -> float: ...
    @property
    def DaylightSaving(self) -> bool: ...
    @property
    def DaylightSavingMinutes(self) -> int: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def Intensity(self) -> float: ...
    @property
    def Latitude(self) -> float: ...
    @property
    def Light(self) -> Light: ...
    @property
    def Longitude(self) -> float: ...
    @property
    def ManualControl(self) -> bool: ...
    @property
    def North(self) -> float: ...
    @property
    def SkylightOn(self) -> bool: ...
    @property
    def TimeZone(self) -> float: ...
    @property
    def Vector(self) -> Vector3d: ...
    def GetDateTime(self, kind: DateTimeKind) -> DateTime: ...
    def Here() -> Tuple[bool, float, float]: ...
    def JulianDay(timezoneHours: float, daylightMinutes: int, when: DateTime, hours: float) -> float: ...
    def remove_Changed(value: EventHandler) -> None: ...
    @DaylightSaving.setter
    def DaylightSaving(self, value: bool) -> None: ...
    @DaylightSavingMinutes.setter
    def DaylightSavingMinutes(self, value: int) -> None: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @Intensity.setter
    def Intensity(self, value: float) -> None: ...
    @ManualControl.setter
    def ManualControl(self, value: bool) -> None: ...
    @North.setter
    def North(self, value: float) -> None: ...
    @SkylightOn.setter
    def SkylightOn(self, value: bool) -> None: ...
    @TimeZone.setter
    def TimeZone(self, value: float) -> None: ...
    def SetDateTime(self, time: DateTime, kind: DateTimeKind) -> None: ...
    @overload
    def SetPosition(self, azimuthDegrees: float, altitudeDegrees: float) -> None: ...
    @overload
    def SetPosition(self, when: DateTime, latitudeDegrees: float, longitudeDegrees: float) -> None: ...
    def SunDirection(latitude: float, longitude: float, when: DateTime) -> Vector3d: ...
    def TwilightZone() -> float: ...


class SupportOptions:
    def AlwaysShowSunPreview() -> bool: ...
    def AutoSaveKeepAmount() -> int: ...
    def AutoSaveRenderings() -> bool: ...
    def CheckSupportFilesBeforeRendering() -> bool: ...
    def CombineEditors() -> bool: ...
    def CustomLibraryPath() -> str: ...
    def CustomPaths() -> str: ...
    def DarkPreviewCheckerColor() -> int: ...
    def EnablePreviewJobLog() -> bool: ...
    def HarvestContentParameters() -> bool: ...
    def LabelFormatLoc() -> int: ...
    def LabelFormatUtc() -> int: ...
    def LastNavigatedLocation() -> str: ...
    def LibrariesInitialLocation() -> RdkInitialLocation: ...
    def LibrariesInitialLocationCustomFolder() -> str: ...
    def LightPreviewCheckerColor() -> int: ...
    def MaxPreviewCacheMB() -> int: ...
    def MaxPreviewSeconds() -> int: ...
    def MultithreadedTextureEvaluation() -> bool: ...
    def PreferNativeRenderer() -> bool: ...
    def PreferredUnpackFolder() -> str: ...
    def PreviewCustomRenderMeshes() -> bool: ...
    def SetAlwaysShowSunPreview(b: bool) -> None: ...
    def SetAutoSaveKeepAmount(value: int) -> None: ...
    def SetAutoSaveRenderings(b: bool) -> None: ...
    def SetCheckSupportFilesBeforeRendering(b: bool) -> None: ...
    def SetCombineEditors(b: bool) -> None: ...
    def SetCustomLibraryPath(path: str) -> None: ...
    def SetCustomPaths(path: str) -> None: ...
    def SetHarvestContentParameters(b: bool) -> None: ...
    def SetLabelFormatLoc(value: int) -> None: ...
    def SetLabelFormatUtc(value: int) -> None: ...
    def SetLastNavigatedLocation(folder: str) -> None: ...
    def SetLibrariesInitialLocation(l: RdkInitialLocation) -> None: ...
    def SetLibrariesInitialLocationCustomFolder(path: str) -> None: ...
    def SetMultithreadedTextureEvaluation(b: bool) -> None: ...
    def SetPreferNativeRenderer(b: bool) -> None: ...
    def SetPreferredUnpackFolder(path: str) -> None: ...
    def SetPreviewCustomRenderMeshes(b: bool) -> None: ...
    def SetShowCustom(b: bool) -> None: ...
    def SetShowDetailsPanel(b: bool) -> None: ...
    def SetShowDocuments(b: bool) -> None: ...
    def SetShowRenderContent(b: bool) -> None: ...
    def SetSupportSharedUIs(b: bool) -> None: ...
    def SetUseDefaultLibraryPath(b: bool) -> None: ...
    def SetUsePreviewCache(b: bool) -> None: ...
    def SetUseQuickInitialPreview(b: bool) -> None: ...
    def ShowCustom() -> bool: ...
    def ShowDetailsPanel() -> bool: ...
    def ShowDocuments() -> bool: ...
    def ShowRenderContent() -> bool: ...
    def SupportSharedUIs() -> bool: ...
    def SupportSharedUIsNoCache() -> bool: ...
    def TextureSize() -> int: ...
    def UseDefaultLibraryPath() -> bool: ...
    def UsePreview() -> bool: ...
    def UsePreviewCache() -> bool: ...
    def UseQuickInitialPreview() -> bool: ...
    def UseRenderedPreview() -> bool: ...


class TexturedColor:
    def __init__(self, name: str, value: Color4f, on: bool, amount: Single): ...


class TexturedFloat:
    def __init__(self, name: str, value: Single, on: bool, amount: Single): ...




class TextureEnvironmentMappingMode:
    Automatic = 0
    Spherical = 1
    EnvironmentMap = 2
    Box = 3
    LightProbe = 5
    Cube = 6
    VerticalCrossCube = 7
    HorizontalCrossCube = 8
    Hemispherical = 9


class TextureEvaluator:
    def Dispose(self) -> None: ...
    @overload
    def GetColor(self, uvw: Point3d, duvwdx: Vector3d, duvwdy: Vector3d) -> Color4f: ...
    @overload
    def GetColor(self, uvw: Point3d, duvwdx: Vector3d, duvwdy: Vector3d, color: Color4f) -> Tuple[bool, Color4f]: ...
    def Initialize(self) -> bool: ...
    def WriteToByteArray(self, width: int, height: int) -> SimpleArrayByte: ...
    def WriteToFloatArray(self, width: int, height: int) -> SimpleArrayFloat: ...


class TextureEvaluatorFlags:
    Normal = 0
    DisableFiltering = 1
    DisableLocalMapping = 2
    DisableAdjustment = 4
    DisableProjectionChange = 8


class TextureGeneration:
    Allow = 1
    Disallow = 2
    Skip = 3


class TextureGeneration:
    Allow = 1
    Disallow = 2


class TextureGraphInfo:
    def __init__(self): ...
    def ActiveAxis(self) -> Axis: ...
    def ActiveChannel(self) -> Channel: ...
    def AmountU(self) -> float: ...
    def AmountV(self) -> float: ...
    def AmountW(self) -> float: ...
    def Dispose(self) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def SetActiveAxis(self, axis: Axis) -> None: ...
    def SetActiveChannel(self, channel: Channel) -> None: ...
    def SetAmountU(self, d: float) -> None: ...
    def SetAmountV(self, d: float) -> None: ...
    def SetAmountW(self, d: float) -> None: ...


class TextureMapping(ModelComponent):
    def CreateBoxMapping(plane: Plane, dx: Interval, dy: Interval, dz: Interval, capped: bool) -> TextureMapping: ...
    def CreateCustomMeshMapping(mesh: Mesh) -> TextureMapping: ...
    def CreateCylinderMapping(cylinder: Cylinder, capped: bool) -> TextureMapping: ...
    @overload
    def CreatePlaneMapping(plane: Plane, dx: Interval, dy: Interval, dz: Interval) -> TextureMapping: ...
    @overload
    def CreatePlaneMapping(plane: Plane, dx: Interval, dy: Interval, dz: Interval, capped: bool) -> TextureMapping: ...
    def CreateSphereMapping(sphere: Sphere) -> TextureMapping: ...
    def CreateSurfaceParameterMapping() -> TextureMapping: ...
    @overload
    def Evaluate(self, p: Point3d, n: Vector3d) -> Tuple[int, Point3d]: ...
    @overload
    def Evaluate(self, p: Point3d, n: Vector3d, pXform: Transform, nXform: Transform) -> Tuple[int, Point3d]: ...
    @property
    def ComponentType(self) -> ModelComponentType: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def MappingType(self) -> TextureMappingType: ...
    @property
    def NormalTransform(self) -> Transform: ...
    @property
    def PrimativeTransform(self) -> Transform: ...
    @property
    def PrimitiveTransform(self) -> Transform: ...
    @property
    def UvwTransform(self) -> Transform: ...
    @NormalTransform.setter
    def NormalTransform(self, value: Transform) -> None: ...
    @PrimativeTransform.setter
    def PrimativeTransform(self, value: Transform) -> None: ...
    @PrimitiveTransform.setter
    def PrimitiveTransform(self, value: Transform) -> None: ...
    @UvwTransform.setter
    def UvwTransform(self, value: Transform) -> None: ...
    @overload
    def TryGetMappingBox(self) -> Tuple[bool, Plane, Interval, Interval, Interval]: ...
    @overload
    def TryGetMappingBox(self) -> Tuple[bool, Plane, Interval, Interval, Interval, bool]: ...
    @overload
    def TryGetMappingCylinder(self) -> Tuple[bool, Cylinder]: ...
    @overload
    def TryGetMappingCylinder(self) -> Tuple[bool, Cylinder, bool]: ...
    def TryGetMappingMesh(self) -> Tuple[bool, Mesh]: ...
    @overload
    def TryGetMappingPlane(self) -> Tuple[bool, Plane, Interval, Interval, Interval]: ...
    @overload
    def TryGetMappingPlane(self) -> Tuple[bool, Plane, Interval, Interval, Interval, bool]: ...
    def TryGetMappingSphere(self) -> Tuple[bool, Sphere]: ...


class TextureMappingType:
    #None = 0
    SurfaceParameters = 1
    PlaneMapping = 2
    CylinderMapping = 3
    SphereMapping = 4
    BoxMapping = 5
    MeshMappingPrimitive = 6
    SurfaceMappingPrimitive = 7
    BrepMappingPrimitive = 8
    OcsMapping = 9


class TextureMode:
    PROJECTION_MODE = 0
    MAPPING_CHANNEL_MODE = 1
    WRAP_TYPE_MODE = 2
    REPEAT_LOCKED_MODE = 3
    OFFSET_LOCKED_MODE = 4
    PREVIEW_IN_3D_MODE = 5
    REPEAT_MODE = 6
    OFFSET_MODE = 7
    ROTATION_MODE = 8
    ENVIRONMENT_MAPPING_MODE = 9
    INTERNAL_ENVIRONMENT_MAPPING_MODE = 10
    PREVIEW_LOCAL_MAPPING_MODE = 11
    DISPLAY_IN_VIEWPORT_MODE = 12
    IS_HDR_CAPABLE_MODE = 13
    IS_LINEAR_MODE = 14
    IS_IMAGE_BASED = 15
    IS_NORMALMAP = 16
    PIXELSIZE_AS_3DVECTOR = 17


class TextureProjectionMode:
    MappingChannel = 0
    View = 1
    Wcs = 2
    EnvironmentMap = 3
    WcsBox = 4
    Screen = 5


class TextureRenderHashFlags:
    ExcludeLocalMapping = 1


class TextureWrapType:
    Clamped = 0
    Repeating = 1


class TimeZone:
    @property
    def Hours(self) -> float: ...
    @property
    def Latitude(self) -> float: ...
    @property
    def Longitude(self) -> float: ...
    @property
    def Name(self) -> str: ...
    def TimeZoneAt(index: int) -> TimeZone: ...
    def TimeZones() -> int: ...


class TwoColorRenderTexture(RenderTexture):
    @property
    def Color1(self) -> Color4f: ...
    @property
    def Color2(self) -> Color4f: ...
    @property
    def SuperSample(self) -> bool: ...
    @property
    def SwapColors(self) -> bool: ...
    @property
    def Texture1Amount(self) -> float: ...
    @property
    def Texture1On(self) -> bool: ...
    @property
    def Texture2Amount(self) -> float: ...
    @property
    def Texture2On(self) -> bool: ...
    @Color1.setter
    def Color1(self, value: Color4f) -> None: ...
    @Color2.setter
    def Color2(self, value: Color4f) -> None: ...
    @SuperSample.setter
    def SuperSample(self, value: bool) -> None: ...
    @SwapColors.setter
    def SwapColors(self, value: bool) -> None: ...
    @Texture1Amount.setter
    def Texture1Amount(self, value: float) -> None: ...
    @Texture1On.setter
    def Texture1On(self, value: bool) -> None: ...
    @Texture2Amount.setter
    def Texture2Amount(self, value: float) -> None: ...
    @Texture2On.setter
    def Texture2On(self, value: bool) -> None: ...


class UndoRedo:
    def add_UndoRedoChanged(value: EventHandler) -> None: ...
    def add_UndoRedoEndedChanged(value: EventHandler) -> None: ...
    def remove_UndoRedoChanged(value: EventHandler) -> None: ...
    def remove_UndoRedoEndedChanged(value: EventHandler) -> None: ...


class Usage:
    #None = 0
    Background = 1
    ReflectionAndRefraction = 2
    Skylighting = 4
    AnyUsage = 7


class Utilities:
    def ChangeContentType(oldContent: RenderContent, newType: Guid, harvestParameters: bool) -> RenderContent: ...
    @overload
    def FindFile(doc: RhinoDoc, fullPathToFile: str) -> str: ...
    @overload
    def FindFile(doc: RhinoDoc, fullPathToFile: str, unpackFromBitmapTableIfNecessary: bool) -> str: ...
    @property
    def DefaultRenderPlugInId() -> Guid: ...
    @property
    def ShowIncompatibleEnvironments() -> bool: ...
    @property
    def ShowIncompatibleMaterials() -> bool: ...
    @property
    def ShowIncompatibleTextures() -> bool: ...
    def IsCachedTextureFileInUse(textureFileName: str) -> bool: ...
    def LoadPersistentRenderContentFromFile(docSerialNumber: UInt32, filename: str) -> RenderContent: ...
    def MoveWindow(hwnd: IntPtr, rect: Rectangle, bRepaint: bool, bRepaintNC: bool) -> None: ...
    def PromptForSaveImageFileParameters(filename: str, width: int, height: int, colorDepth: int) -> Tuple[str, int, int, int]: ...
    def SafeFrameEnabled(doc: RhinoDoc) -> bool: ...
    @ShowIncompatibleEnvironments.setter
    def ShowIncompatibleEnvironments(value: bool) -> None: ...
    @ShowIncompatibleMaterials.setter
    def ShowIncompatibleMaterials(value: bool) -> None: ...
    @ShowIncompatibleTextures.setter
    def ShowIncompatibleTextures(value: bool) -> None: ...
    def SetDefaultRenderPlugIn(pluginId: Guid) -> bool: ...
    @overload
    def ShowContentChooser(defaultType: Guid, defaultInstanceId: Guid, kinds: RenderContentKind, instanceIdOut: Guid, flags: ShowContentChooserFlags, doc: RhinoDoc) -> Tuple[ShowContentChooserResults, Guid]: ...
    @overload
    def ShowContentChooser(doc: RhinoDoc, defaultType: Guid, defaultInstanceId: Guid, kinds: RenderContentKind, flags: ShowContentChooserFlags, presetCategory: str, categories: Iterable[str], types: Iterable[Guid]) -> Tuple[ShowContentChooserResults, Set(Guid)]: ...
    def ShowIORMenu(hwnd: IntPtr, pt: Point, outIOR: float, outString: str) -> Tuple[bool, float, str]: ...
