from typing import Tuple, Set, Iterable, List


class ClassArrayObjRef:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, objrefs: Iterable[ObjRef]): ...
    def Add(self, objref: ObjRef) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(ObjRef): ...


class ClassArrayOnObjRef:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, objrefs: Iterable[ObjRef]): ...
    def Add(self, objref: ObjRef) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    @overload
    def ToNonConstArray(self) -> Set(ObjRef): ...
    @overload
    def ToNonConstArray(self, doc: RhinoDoc) -> Set(ObjRef): ...


class ClassArrayString:
    def __init__(self): ...
    def Add(self, s: str) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(str): ...


class CurveSegment:
    @property
    def Index(self) -> int: ...
    @property
    def Reversed(self) -> bool: ...
    @property
    def SubDomain(self) -> Interval: ...


class MeshPointDataStruct:
    pass


class SimpleArray2dex:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, values: Iterable[IndexPair]): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(IndexPair): ...


class SimpleArrayArrayPoint3d:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int, pointIndex: int) -> Point3d: ...
    def NonConstPointer(self) -> IntPtr: ...
    def PointCountAt(self, index: int) -> int: ...


class SimpleArrayBinaryArchiveReader:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, p: IntPtr): ...
    def Add(self, reader: BinaryArchiveReader) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def Get(self, index: int) -> BinaryArchiveReader: ...
    def NonConstPointer(self) -> IntPtr: ...


class SimpleArrayBrepPointer:
    def __init__(self): ...
    def Add(self, brep: Brep, asConst: bool) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(Brep): ...


class SimpleArrayByte:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initialSize: int): ...
    @overload
    def __init__(self, other: SimpleArrayByte): ...
    @overload
    def __init__(self, values: Iterable[Byte]): ...
    def Array(self) -> IntPtr: ...
    def ConstPointer(self) -> IntPtr: ...
    def CopyTo(self, other: SimpleArrayByte) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Byte): ...


class SimpleArrayClippingPlaneObjectPointer:
    def __init__(self): ...
    def Add(self, clippingplane: ClippingPlaneObject, asConst: bool) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...


class SimpleArrayCurvePointer:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, curves: Iterable[Curve]): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(Curve): ...


class SimpleArrayDouble:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, items: Iterable[float]): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(float): ...


class SimpleArrayExtrusionPointer:
    def __init__(self): ...
    def Add(self, extrusion: Extrusion, asConst: bool) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(Extrusion): ...


class SimpleArrayFloat:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, initialSize: int): ...
    @overload
    def __init__(self, other: SimpleArrayFloat): ...
    @overload
    def __init__(self, values: Iterable[Single]): ...
    def Array(self) -> IntPtr: ...
    def ConstPointer(self) -> IntPtr: ...
    def CopyTo(self, other: SimpleArrayFloat) -> None: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Single): ...


class SimpleArrayGeometryPointer:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, geometry: Iterable[GeometryBase]): ...
    @overload
    def __init__(self, geometry: IEnumerable): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(GeometryBase): ...


class SimpleArrayGuid:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, values: Iterable[Guid]): ...
    def Append(self, uuid: Guid) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> Guid: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Guid): ...


class SimpleArrayGuidPointer:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def Item(self, index: int) -> Guid: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Guid): ...


class SimpleArrayInt:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, values: Iterable[int]): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(int): ...


class SimpleArrayInterval:
    def __init__(self): ...
    def Add(self, interval: Interval) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Interval): ...


class SimpleArrayLine:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Line): ...


class SimpleArrayLinetypePointer:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(Linetype): ...


class SimpleArrayMeshPointer:
    def __init__(self): ...
    def Add(self, mesh: Mesh, asConst: bool) -> None: ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(Mesh): ...


class SimpleArrayPlane:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Plane): ...


class SimpleArrayPoint2d:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Point2d): ...


class SimpleArrayPoint3d:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(Point3d): ...


class SimpleArraySurfacePointer:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToNonConstArray(self) -> Set(Surface): ...


class SimpleArrayUint:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, values: Iterable[UInt32]): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def UnsignedCount(self) -> UInt32: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToArray(self) -> Set(UInt32): ...


class StringHolder:
    def __init__(self): ...
    def ConstPointer(self) -> IntPtr: ...
    def Dispose(self) -> None: ...
    def GetString(pStringHolder: IntPtr) -> str: ...
    def NonConstPointer(self) -> IntPtr: ...
    def ToString(self) -> str: ...


class StringWrapper:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, s: str): ...
    def Dispose(self) -> None: ...
    @property
    def ConstPointer(self) -> IntPtr: ...
    @property
    def NonConstPointer(self) -> IntPtr: ...
    def GetStringFromPointer(pConstON_wString: IntPtr) -> str: ...
    def SetString(self, s: str) -> None: ...
    def SetStringOnPointer(pON_wString: IntPtr, s: str) -> None: ...
    def ToString(self) -> str: ...
