from typing import Tuple, Set, Iterable, List


class ButtonType:
    CancelOrClose = 0
    Confirm = 1
    Alternate = 2


class IAssemblyRestrictedObject:
    def Editable(self) -> bool: ...


class Notification:
    @overload
    def __init__(self): ...
    @overload
    def __init__(self, allowedAssemblies: Iterable[Assembly]): ...
    def add_PropertyChanged(self, value: PropertyChangedEventHandler) -> None: ...
    def Editable(self) -> bool: ...
    @overload
    def ExecuteAssemblyProtectedCode(action: Action) -> None: ...
    @overload
    def ExecuteAssemblyProtectedCode(func: Func) -> TResult: ...
    @property
    def AllowedAssemblies(self) -> ICollection: ...
    @property
    def AlternateButtonTitle(self) -> str: ...
    @property
    def ButtonClicked(self) -> Action: ...
    @property
    def CancelButtonTitle(self) -> str: ...
    @property
    def ConfirmButtonTitle(self) -> str: ...
    @property
    def DateUpdated(self) -> DateTime: ...
    @property
    def Description(self) -> str: ...
    @property
    def Item(self, key: str) -> str: ...
    @property
    def Message(self) -> str: ...
    @property
    def MetadataCopy(self) -> IDictionary: ...
    @property
    def SeverityLevel(self) -> Severity: ...
    @property
    def ShowEventId(self) -> Nullable: ...
    @property
    def Title(self) -> str: ...
    def HideModal(self) -> None: ...
    def remove_PropertyChanged(self, value: PropertyChangedEventHandler) -> None: ...
    def RemoveMetadata(self, key: str) -> bool: ...
    @AlternateButtonTitle.setter
    def AlternateButtonTitle(self, value: str) -> None: ...
    @ButtonClicked.setter
    def ButtonClicked(self, value: Action) -> None: ...
    @CancelButtonTitle.setter
    def CancelButtonTitle(self, value: str) -> None: ...
    @ConfirmButtonTitle.setter
    def ConfirmButtonTitle(self, value: str) -> None: ...
    @Description.setter
    def Description(self, value: str) -> None: ...
    @Item.setter
    def Item(self, key: str, value: str) -> None: ...
    @Message.setter
    def Message(self, value: str) -> None: ...
    @SeverityLevel.setter
    def SeverityLevel(self, value: Severity) -> None: ...
    @Title.setter
    def Title(self, value: str) -> None: ...
    def ShowModal(self) -> None: ...
    def ToString(self) -> str: ...


class NotificationButtonClickedArgs:
    def __init__(self, notification: Notification, buttonClicked: ButtonType): ...
    @property
    def ButtonClicked(self) -> ButtonType: ...
    @property
    def Notification(self) -> Notification: ...


class NotificationCenter:
    pass


class Severity:
    Debug = 0
    Info = 1
    Warning = 2
    Serious = 3
    Critical = 4


