__all__ = ['DataSource','ThumbnailUI']
from typing import Tuple, Set, Iterable, List


class CollapsibleSectionHolderImpl:
    def __init__(self, client: ICollapsibleSectionHolder): ...
    def Dispose(self) -> None: ...
    def Find(cpp: IntPtr) -> ICollapsibleSectionHolder: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def IsSameObject(self, cpp: IntPtr) -> bool: ...
    def NewNativeWrapper(cpp: IntPtr) -> ICollapsibleSectionHolder: ...


class CollapsibleSectionImpl:
    def __init__(self, section: ICollapsibleSection): ...
    def __InternalSetParent(self, parent: IntPtr) -> None: ...
    def add_DataChanged(self, value: EventHandler) -> None: ...
    def add_ViewModelActivated(self, value: EventHandler) -> None: ...
    def CreateHostedSection(section: ICollapsibleSection) -> None: ...
    def Dispose(self) -> None: ...
    def Find(cpp: IntPtr) -> ICollapsibleSection: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    @property
    def ViewModel(self) -> IRdkViewModel: ...
    def GetSibling(section: ICollapsibleSection, siblingSectionId: Guid) -> ICollapsibleSection: ...
    def GetSiblings(section: ICollapsibleSection) -> Set(ICollapsibleSection): ...
    def IsSameObject(self, cpp: IntPtr) -> bool: ...
    def NewNativeWrapper(cpp: IntPtr) -> ICollapsibleSection: ...
    def remove_DataChanged(self, value: EventHandler) -> None: ...
    def remove_ViewModelActivated(self, value: EventHandler) -> None: ...
    def ReplaceClient(self, client: ICollapsibleSection) -> None: ...
    @ViewModel.setter
    def ViewModel(self, value: IRdkViewModel) -> None: ...


class CollapsibleSectionViewModel:
    def __init__(self, section: ICollapsibleSection): ...
    def Commit(self, uuidDataType: Guid) -> None: ...
    def Discard(self, uuidDataType: Guid) -> None: ...
    @property
    def CppPointer(self) -> IntPtr: ...
    def GetData(self, uuidDataType: Guid, bForWrite: bool, bAutoChangeBracket: bool) -> Object: ...
    def UndoHelper(self, description: str) -> UndoRecord: ...


class CREATEFROMCPPPROC:
    def __init__(self, object: Object, method: IntPtr): ...
    def BeginInvoke(self, hwndParent: IntPtr, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> IntPtr: ...
    def Invoke(self, hwndParent: IntPtr) -> IntPtr: ...


class CREATEHOSTFROMCPPPROC:
    def __init__(self, object: Object, method: IntPtr): ...
    def BeginInvoke(self, client: IntPtr, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> IntPtr: ...
    def Invoke(self, client: IntPtr) -> IntPtr: ...


class Delegates:
    def __init__(self): ...


class Factory(FactoryBase):
    def __init__(self): ...


class FactoryBase:
    def Get(self, id: Guid) -> IntPtr: ...
    @overload
    def Register() -> Set(Type): ...
    @overload
    def Register(plugin: PlugIn) -> Set(Type): ...


class ICollapsibleSection:
    @property
    def BackgroundColor(self) -> Color: ...
    @property
    def Collapsible(self) -> bool: ...
    @property
    def CommandOptionName(self) -> LocalizeStringPair: ...
    @property
    def Height(self) -> int: ...
    @property
    def Hidden(self) -> bool: ...
    @property
    def Id(self) -> Guid: ...
    @property
    def InitiallyExpanded(self) -> bool: ...
    @property
    def PlugInId(self) -> Guid: ...
    @property
    def SettingsTag(self) -> str: ...
    @property
    def ViewModel(self) -> IRdkViewModel: ...
    @property
    def ViewModelId(self) -> Guid: ...
    def RunScript(self, vm: IRdkViewModel) -> int: ...
    @BackgroundColor.setter
    def BackgroundColor(self, value: Color) -> None: ...


class ICollapsibleSection2:
    def EnableHeaderButton(self, index: int, bEnable: bool) -> bool: ...
    def NewHeaderButtonHandler(self) -> IHeaderButtonHandler: ...
    def OnAttachedToHolder(self, holder: ICollapsibleSectionHolder2) -> None: ...
    def OnAttachingToHolder(self, holder: ICollapsibleSectionHolder2) -> None: ...
    def OnDetachedFromHolder(self, holder: ICollapsibleSectionHolder2) -> None: ...
    def OnDetachingFromHolder(self, holder: ICollapsibleSectionHolder2) -> None: ...
    def ShowHeaderButton(self, index: int, bShow: bool) -> bool: ...


class ICollapsibleSection3:
    def UpdateView(self, flags: UInt32) -> None: ...


class ICollapsibleSectionHolder:
    def Add(self, section: ICollapsibleSection) -> None: ...
    def ExpandSection(self, section: ICollapsibleSection, expand: bool, ensureVisible: bool) -> None: ...
    @property
    def BottomMargin(self) -> int: ...
    @property
    def LeftMargin(self) -> int: ...
    @property
    def RightMargin(self) -> int: ...
    @property
    def ScrollPosition(self) -> int: ...
    @property
    def SectionCount(self) -> int: ...
    @property
    def Sections(self) -> Iterable[ICollapsibleSection]: ...
    @property
    def TopMargin(self) -> int: ...
    def IsSectionExpanded(self, section: ICollapsibleSection) -> bool: ...
    def Remove(self, section: ICollapsibleSection) -> None: ...
    def SectionAt(self, index: int) -> ICollapsibleSection: ...
    @BackgroundColor.setter
    def BackgroundColor(self, value: Color) -> None: ...
    @BottomMargin.setter
    def BottomMargin(self, value: int) -> None: ...
    @EmptyText.setter
    def EmptyText(self, value: str) -> None: ...
    @LeftMargin.setter
    def LeftMargin(self, value: int) -> None: ...
    @RightMargin.setter
    def RightMargin(self, value: int) -> None: ...
    @ScrollPosition.setter
    def ScrollPosition(self, value: int) -> None: ...
    @SettingsPathSubKey.setter
    def SettingsPathSubKey(self, value: str) -> None: ...
    @TopMargin.setter
    def TopMargin(self, value: int) -> None: ...
    def UpdateAllViews(self, flags: int) -> None: ...


class ICollapsibleSectionHolder2:
    def EnableHeaderButton(self, s: ICollapsibleSection, index: int, bEnable: bool) -> bool: ...
    def SetFullHeightSection(self, sec: ICollapsibleSection) -> None: ...
    def ShowHeaderButton(self, s: ICollapsibleSection, index: int, bShow: bool) -> bool: ...


class IHasCppImplementation:
    @property
    def CppPointer(self) -> IntPtr: ...


class IHeaderButtonHandler:
    def ButtonDetails(self, index: int, iconOut: Bitmap, sToolTipOut: str) -> Tuple[bool, Bitmap, str]: ...
    def ButtonRect(self, index: int, rectHeader: Rectangle) -> Rectangle: ...
    def DeleteThis(self) -> None: ...
    def OnButtonClicked(self, index: int) -> bool: ...


class InternalRdkViewModelFactory(FactoryBase):
    def __init__(self): ...


class IRdkViewModel:
    def Commit(self, uuidDataType: Guid) -> None: ...
    def Discard(self, uuidDataType: Guid) -> None: ...
    def GetData(self, uuidDataType: Guid, bForWrite: bool, bAutoChangeBracket: bool) -> Object: ...


class IWindow:
    @property
    def Caption(self) -> LocalizeStringPair: ...
    @property
    def Created(self) -> bool: ...
    @property
    def Enabled(self) -> bool: ...
    @property
    def Parent(self) -> IntPtr: ...
    @property
    def Shown(self) -> bool: ...
    @property
    def Window(self) -> IntPtr: ...
    def Move(self, pos: Rectangle, bRepaint: bool, bRepaintBorder: bool) -> None: ...
    @Enabled.setter
    def Enabled(self, value: bool) -> None: ...
    @Parent.setter
    def Parent(self, value: IntPtr) -> None: ...
    @Shown.setter
    def Shown(self, value: bool) -> None: ...


class UndoRecord:
    def __init__(self, description: str, viewModel: IRdkViewModel): ...
    def Dispose(self) -> None: ...
