__all__ = ['ApplicationSettings','Collections','Commands','Display','DocObjects','FileIO','Geometry','Input','NodeInCode','PlugIns','Render','Runtime','UI']
from typing import Tuple, Set, Iterable, List


class AngleUnitSystem:
    #None = 0
    Turns = 1
    Radians = 2
    Degrees = 3
    Minutes = 4
    Seconds = 5
    Gradians = 6
    Unset = 255


class AntialiasLevel:
    #None = 0
    Draft = 1
    Good = 2
    High = 3


class BitmapExtensions:
    def BitmapAsTextureFileReference(bitmap: Bitmap, crc: UInt32) -> FileReference: ...
    def ConvertToNormalMap(bitmap: Bitmap, bLossyCompressionSource: bool) -> Tuple[Bitmap, bool]: ...
    def IsNormalMap(bitmap: Bitmap, bLossyCompressionSource: bool) -> Tuple[bool, bool]: ...


class CommandLineTextWriter:
    def __init__(self): ...
    @property
    def Encoding(self) -> Encoding: ...
    def write(self, str: str) -> None: ...
    @overload
    def Write(self, value: Char) -> None: ...
    @overload
    def Write(self, value: str) -> None: ...
    @overload
    def Write(self, buffer: Set(Char), index: int, count: int) -> None: ...


class DisplayDeviceInfo:
    def __init__(self): ...
    def GpuDeviceInfos() -> List: ...
    def GpuNames() -> List: ...


class DocumentEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def DocumentId(self) -> int: ...
    @property
    def DocumentSerialNumber(self) -> UInt32: ...


class DocumentOpenEventArgs(DocumentEventArgs):
    @property
    def FileName(self) -> str: ...
    @property
    def Merge(self) -> bool: ...
    @property
    def Reference(self) -> bool: ...


class DocumentSaveEventArgs(DocumentEventArgs):
    @property
    def ExportSelected(self) -> bool: ...
    @property
    def FileName(self) -> str: ...


class GpuDeviceInfo:
    @property
    def DriverDateAsString(self) -> str: ...
    @property
    def Memory(self) -> UInt64: ...
    @property
    def MemoryAsString(self) -> str: ...
    @property
    def Name(self) -> str: ...
    @property
    def Vendor(self) -> str: ...






class IndexPair:
    def __init__(self, i: int, j: int): ...
    def Contains(self, item: int) -> bool: ...
    def CopyTo(self, array: Set(int), arrayIndex: int) -> None: ...
    @property
    def Count(self) -> int: ...
    @property
    def I(self) -> int: ...
    @property
    def Item(self, index: int) -> int: ...
    @property
    def J(self) -> int: ...
    def GetEnumerator(self) -> IEnumerator: ...
    def IndexOf(self, item: int) -> int: ...
    @I.setter
    def I(self, value: int) -> None: ...
    @Item.setter
    def Item(self, index: int, value: int) -> None: ...
    @J.setter
    def J(self, value: int) -> None: ...


class IRhinoDocObserver:
    def ActiveRhinoDocChanged(self, e: RhinoDocObserverArgs) -> None: ...
    def RhinoDocClosed(self, e: RhinoDocObserverArgs) -> None: ...


class KeyboardHookEvent:
    def __init__(self, object: Object, method: IntPtr): ...
    def BeginInvoke(self, key: int, callback: AsyncCallback, object: Object) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, key: int) -> None: ...


class LengthValue:
    def ChangeLength(self, newLength: float) -> LengthValue: ...
    def ChangeUnitSystem(self, newUnits: UnitSystem) -> LengthValue: ...
    @overload
    def Create(s: str, ps: StringParserSettings) -> Tuple[LengthValue, bool]: ...
    @overload
    def Create(length: float, us: UnitSystem, format: StringFormat) -> LengthValue: ...
    @overload
    def Create(length: float, us: UnitSystem, format: StringFormat, localeId: UInt32) -> LengthValue: ...
    def Dispose(self) -> None: ...
    @property
    def ContextAngleUnitSystem(self) -> AngleUnitSystem: ...
    @property
    def ContextLocaleId(self) -> UInt32: ...
    @property
    def LengthString(self) -> str: ...
    @property
    def LengthStringFormat(self) -> StringFormat: ...
    @property
    def ParseSettings(self) -> StringParserSettings: ...
    @property
    def UnitSystem(self) -> UnitSystem: ...
    def IsUnset(self) -> bool: ...
    @overload
    def Length(self) -> float: ...
    @overload
    def Length(self, units: UnitSystem) -> float: ...


class PersistentSettings:
    def AddChild(self, key: str) -> PersistentSettings: ...
    def ClearChangedFlag(self) -> None: ...
    def ContainsChangedValues(self) -> bool: ...
    def ContainsModifiedValues(self, allUserSettings: PersistentSettings) -> bool: ...
    def DeleteChild(self, key: str) -> None: ...
    def DeleteItem(self, key: str) -> None: ...
    def FromPlugInId(pluginId: Guid) -> PersistentSettings: ...
    @property
    def ChildKeys(self) -> ICollection: ...
    @property
    def HiddenFromUserInterface(self) -> bool: ...
    @property
    def Keys(self) -> ICollection: ...
    @property
    def RhinoAppSettings() -> PersistentSettings: ...
    @property
    def StringListRootKey() -> str: ...
    @overload
    def GetBool(self, key: str) -> bool: ...
    @overload
    def GetBool(self, key: str, defaultValue: bool) -> bool: ...
    @overload
    def GetBool(self, key: str, defaultValue: bool, legacyKeyList: Iterable[str]) -> bool: ...
    @overload
    def GetByte(self, key: str) -> Byte: ...
    @overload
    def GetByte(self, key: str, defaultValue: Byte) -> Byte: ...
    @overload
    def GetByte(self, key: str, defaultValue: Byte, legacyKeyList: Iterable[str]) -> Byte: ...
    @overload
    def GetChar(self, key: str) -> Char: ...
    @overload
    def GetChar(self, key: str, defaultValue: Char) -> Char: ...
    @overload
    def GetChar(self, key: str, defaultValue: Char, legacyKeyList: Iterable[str]) -> Char: ...
    def GetChild(self, key: str) -> PersistentSettings: ...
    @overload
    def GetColor(self, key: str) -> Color: ...
    @overload
    def GetColor(self, key: str, defaultValue: Color) -> Color: ...
    @overload
    def GetColor(self, key: str, defaultValue: Color, legacyKeyList: Iterable[str]) -> Color: ...
    @overload
    def GetDate(self, key: str) -> DateTime: ...
    @overload
    def GetDate(self, key: str, defaultValue: DateTime) -> DateTime: ...
    @overload
    def GetDate(self, key: str, defaultValue: DateTime, legacyKeyList: Iterable[str]) -> DateTime: ...
    @overload
    def GetDouble(self, key: str) -> float: ...
    @overload
    def GetDouble(self, key: str, defaultValue: float) -> float: ...
    @overload
    def GetDouble(self, key: str, defaultValue: float, legacyKeyList: Iterable[str]) -> float: ...
    @overload
    def GetEnumValue(self, key: str) -> T: ...
    @overload
    def GetEnumValue(self, defaultValue: T) -> T: ...
    @overload
    def GetEnumValue(self, key: str, defaultValue: T) -> T: ...
    @overload
    def GetGuid(self, key: str) -> Guid: ...
    @overload
    def GetGuid(self, key: str, defaultValue: Guid) -> Guid: ...
    @overload
    def GetGuid(self, key: str, defaultValue: Guid, legacyKeyList: Iterable[str]) -> Guid: ...
    @overload
    def GetInteger(self, key: str) -> int: ...
    @overload
    def GetInteger(self, key: str, defaultValue: int) -> int: ...
    @overload
    def GetInteger(self, key: str, defaultValue: int, legacyKeyList: Iterable[str]) -> int: ...
    @overload
    def GetInteger(self, key: str, defaultValue: int, bound: int, boundIsLower: bool) -> int: ...
    @overload
    def GetInteger(self, key: str, defaultValue: int, lowerBound: int, upperBound: int) -> int: ...
    @overload
    def GetPoint(self, key: str) -> Point: ...
    @overload
    def GetPoint(self, key: str, defaultValue: Point) -> Point: ...
    @overload
    def GetPoint(self, key: str, defaultValue: Point, legacyKeyList: Iterable[str]) -> Point: ...
    @overload
    def GetPoint3d(self, key: str) -> Point3d: ...
    @overload
    def GetPoint3d(self, key: str, defaultValue: Point3d) -> Point3d: ...
    @overload
    def GetPoint3d(self, key: str, defaultValue: Point3d, legacyKeyList: Iterable[str]) -> Point3d: ...
    @overload
    def GetRectangle(self, key: str) -> Rectangle: ...
    @overload
    def GetRectangle(self, key: str, defaultValue: Rectangle) -> Rectangle: ...
    @overload
    def GetRectangle(self, key: str, defaultValue: Rectangle, legacyKeyList: Iterable[str]) -> Rectangle: ...
    @overload
    def GetSettingIsHiddenFromUserInterface(self, key: str) -> bool: ...
    @overload
    def GetSettingIsHiddenFromUserInterface(self, key: str, legacyKeyList: Iterable[str]) -> bool: ...
    def GetSettingIsReadOnly(self, key: str) -> bool: ...
    def GetSettingType(self, key: str) -> Type: ...
    @overload
    def GetSize(self, key: str) -> Size: ...
    @overload
    def GetSize(self, key: str, defaultValue: Size) -> Size: ...
    @overload
    def GetSize(self, key: str, defaultValue: Size, legacyKeyList: Iterable[str]) -> Size: ...
    @overload
    def GetString(self, key: str) -> str: ...
    @overload
    def GetString(self, key: str, defaultValue: str) -> str: ...
    @overload
    def GetString(self, key: str, defaultValue: str, legacyKeyList: Iterable[str]) -> str: ...
    @overload
    def GetStringDictionary(self, key: str) -> Set(KeyValuePair): ...
    @overload
    def GetStringDictionary(self, key: str, defaultValue: Set(KeyValuePair)) -> Set(KeyValuePair): ...
    @overload
    def GetStringDictionary(self, key: str, defaultValue: Set(KeyValuePair), legacyKeyList: Iterable[str]) -> Set(KeyValuePair): ...
    @overload
    def GetStringList(self, key: str) -> Set(str): ...
    @overload
    def GetStringList(self, key: str, defaultValue: Set(str)) -> Set(str): ...
    @overload
    def GetStringList(self, key: str, defaultValue: Set(str), legacyKeyList: Iterable[str]) -> Set(str): ...
    @overload
    def GetUnsignedInteger(self, key: str) -> UInt32: ...
    @overload
    def GetUnsignedInteger(self, key: str, defaultValue: UInt32) -> UInt32: ...
    @overload
    def GetUnsignedInteger(self, key: str, defaultValue: UInt32, legacyKeyList: Iterable[str]) -> UInt32: ...
    def GetValidator(self, key: str) -> EventHandler: ...
    def HideSettingFromUserInterface(self, key: str) -> None: ...
    def RegisterSettingsValidator(self, key: str, validator: EventHandler) -> None: ...
    @HiddenFromUserInterface.setter
    def HiddenFromUserInterface(self, value: bool) -> None: ...
    def SetBool(self, key: str, value: bool) -> None: ...
    def SetByte(self, key: str, value: Byte) -> None: ...
    def SetChar(self, key: str, value: Char) -> None: ...
    def SetColor(self, key: str, value: Color) -> None: ...
    def SetDate(self, key: str, value: DateTime) -> None: ...
    @overload
    def SetDefault(self, key: str, value: int) -> None: ...
    @overload
    def SetDefault(self, key: str, value: float) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Guid) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Color) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Rectangle) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Size) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Point) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Point3d) -> None: ...
    @overload
    def SetDefault(self, key: str, value: DateTime) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Set(str)) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Byte) -> None: ...
    @overload
    def SetDefault(self, key: str, value: bool) -> None: ...
    @overload
    def SetDefault(self, key: str, value: str) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Char) -> None: ...
    @overload
    def SetDefault(self, key: str, value: Set(KeyValuePair)) -> None: ...
    def SetDouble(self, key: str, value: float) -> None: ...
    @overload
    def SetEnumValue(self, enumValue: T) -> None: ...
    @overload
    def SetEnumValue(self, key: str, value: T) -> None: ...
    def SetGuid(self, key: str, value: Guid) -> None: ...
    def SetInteger(self, key: str, value: int) -> None: ...
    def SetPoint(self, key: str, value: Point) -> None: ...
    def SetPoint3d(self, key: str, value: Point3d) -> None: ...
    def SetRectangle(self, key: str, value: Rectangle) -> None: ...
    def SetSize(self, key: str, value: Size) -> None: ...
    def SetString(self, key: str, value: str) -> None: ...
    def SetStringDictionary(self, key: str, value: Set(KeyValuePair)) -> None: ...
    def SetStringList(self, key: str, value: Set(str)) -> None: ...
    def SetUnsignedInteger(self, key: str, value: UInt32) -> None: ...
    @overload
    def TryGetBool(self, key: str) -> Tuple[bool, bool]: ...
    @overload
    def TryGetBool(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, bool]: ...
    @overload
    def TryGetByte(self, key: str) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetByte(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetChar(self, key: str) -> Tuple[bool, Char]: ...
    @overload
    def TryGetChar(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Char]: ...
    def TryGetChild(self, key: str) -> Tuple[bool, PersistentSettings]: ...
    @overload
    def TryGetColor(self, key: str) -> Tuple[bool, Color]: ...
    @overload
    def TryGetColor(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Color]: ...
    @overload
    def TryGetDate(self, key: str) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDate(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, bool]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Byte]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, int]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, float]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Point3d]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Color]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, DateTime]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Set(str)]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Char]: ...
    @overload
    def TryGetDefault(self, key: str) -> Tuple[bool, Size]: ...
    @overload
    def TryGetDouble(self, key: str) -> Tuple[bool, float]: ...
    @overload
    def TryGetDouble(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, float]: ...
    def TryGetEnumValue(self, key: str) -> Tuple[bool, T]: ...
    @overload
    def TryGetGuid(self, key: str) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetGuid(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Guid]: ...
    @overload
    def TryGetInteger(self, key: str) -> Tuple[bool, int]: ...
    @overload
    def TryGetInteger(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, int]: ...
    @overload
    def TryGetPoint(self, key: str) -> Tuple[bool, Point]: ...
    @overload
    def TryGetPoint(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Point]: ...
    @overload
    def TryGetPoint3d(self, key: str) -> Tuple[bool, Point3d]: ...
    @overload
    def TryGetPoint3d(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Point3d]: ...
    @overload
    def TryGetRectangle(self, key: str) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetRectangle(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Rectangle]: ...
    @overload
    def TryGetSettingIsHiddenFromUserInterface(self, key: str) -> Tuple[bool, bool]: ...
    @overload
    def TryGetSettingIsHiddenFromUserInterface(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, bool]: ...
    def TryGetSettingIsReadOnly(self, key: str) -> Tuple[bool, bool]: ...
    def TryGetSettingType(self, key: str) -> Tuple[bool, Type]: ...
    @overload
    def TryGetSize(self, key: str) -> Tuple[bool, Size]: ...
    @overload
    def TryGetSize(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Size]: ...
    @overload
    def TryGetString(self, key: str) -> Tuple[bool, str]: ...
    @overload
    def TryGetString(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, str]: ...
    @overload
    def TryGetStringDictionary(self, key: str) -> Tuple[bool, Set(KeyValuePair)]: ...
    @overload
    def TryGetStringDictionary(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Set(KeyValuePair)]: ...
    @overload
    def TryGetStringList(self, key: str) -> Tuple[bool, Set(str)]: ...
    @overload
    def TryGetStringList(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, Set(str)]: ...
    @overload
    def TryGetUnsignedInteger(self, key: str) -> Tuple[bool, UInt32]: ...
    @overload
    def TryGetUnsignedInteger(self, key: str, legacyKeyList: Iterable[str]) -> Tuple[bool, UInt32]: ...


class PersistentSettingsConverter:
    def IsStringDictionary(s: str) -> bool: ...
    def IsStringList(s: str) -> bool: ...
    @overload
    def ToString(values: Set(str)) -> str: ...
    @overload
    def ToString(value: Set(KeyValuePair)) -> str: ...
    @overload
    def ToString(value: float) -> str: ...
    def TryParseDouble(s: str) -> Tuple[bool, float]: ...
    @overload
    def TryParseEnum(type: Type, intValueAsString: str) -> Tuple[bool, str]: ...
    @overload
    def TryParseEnum(type: Type, enumValueName: str) -> Tuple[bool, int]: ...
    def TryParseStringDictionary(s: str) -> Tuple[bool, Set(KeyValuePair)]: ...
    def TryParseStringList(s: str) -> Tuple[bool, Set(str)]: ...


class PersistentSettingsEventArgs:
    @property
    def Cancel(self) -> bool: ...
    @Cancel.setter
    def Cancel(self, value: bool) -> None: ...




class PersistentSettingsSavedEventArgs:
    def CommandSettings(self, englishCommandName: str) -> PersistentSettings: ...
    @property
    def PlugInSettings(self) -> PersistentSettings: ...
    @property
    def SavedByThisRhino(self) -> bool: ...


class ReadFileResult:
    Unset = 0
    Completed = 1
    CompletedWithErrors = 2
    Failed = 3


class RenderContentTableEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> RenderContentTableEventType: ...


class RenderContentTableEventType:
    Loaded = 0
    Clearing = 1
    Cleared = 2
    MaterialAssignmentChanged = 3


class RenderMaterialAssignmentChangedEventArgs:
    @property
    def IsLayer(self) -> bool: ...
    @property
    def IsObject(self) -> bool: ...
    @property
    def LayerId(self) -> Guid: ...
    @property
    def NewRenderMaterial(self) -> Guid: ...
    @property
    def ObjectId(self) -> Guid: ...
    @property
    def OldRenderMaterial(self) -> Guid: ...


class RhinoApp:
    def add_AppSettingsChanged(value: EventHandler) -> None: ...
    def add_Closing(value: EventHandler) -> None: ...
    def add_EscapeKeyPressed(value: EventHandler) -> None: ...
    def add_Idle(value: EventHandler) -> None: ...
    def add_Initialized(value: EventHandler) -> None: ...
    def add_KeyboardEvent(value: KeyboardHookEvent) -> None: ...
    def add_LicenseStateChanged(value: EventHandler) -> None: ...
    def add_MainLoop(value: EventHandler) -> None: ...
    def add_RdkCacheImageChanged(value: EventHandler) -> None: ...
    def add_RdkGlobalSettingsChanged(value: EventHandler) -> None: ...
    def add_RdkNewDocument(value: EventHandler) -> None: ...
    def add_RdkPlugInUnloading(value: EventHandler) -> None: ...
    def add_RdkUpdateAllPreviews(value: EventHandler) -> None: ...
    def add_RendererChanged(value: EventHandler) -> None: ...
    def AskUserForRhinoLicense(standAlone: bool, parentWindow: Object) -> bool: ...
    def CapturedCommandWindowStrings(clearBuffer: bool) -> Set(str): ...
    def ChangeLicenseKey(pluginId: Guid) -> bool: ...
    def ClearCommandHistoryWindow() -> None: ...
    def ExecuteCommand(document: RhinoDoc, commandName: str) -> Result: ...
    @overload
    def Exit() -> None: ...
    @overload
    def Exit(forceExit: bool) -> None: ...
    @property
    def BuildDate() -> DateTime: ...
    @property
    def CanSave() -> bool: ...
    @property
    def CommandHistoryWindowText() -> str: ...
    @property
    def CommandLineOut() -> CommandLineTextWriter: ...
    @property
    def CommandPrompt() -> str: ...
    @property
    def CommandWindowCaptureEnabled() -> bool: ...
    @property
    def CurrentRhinoId() -> Guid: ...
    @property
    def DaysUntilExpiration() -> int: ...
    @property
    def DefaultUiFont() -> Font: ...
    @property
    def ExeServiceRelease() -> int: ...
    @property
    def ExeVersion() -> int: ...
    @property
    def InstallationType() -> Installation: ...
    @property
    def InstallationTypeString() -> str: ...
    @property
    def InvokeRequired() -> bool: ...
    @property
    def IsClosing() -> bool: ...
    @property
    def IsCloudZooNode() -> bool: ...
    @property
    def IsExiting() -> bool: ...
    @property
    def IsInternetAccessAllowed() -> bool: ...
    @property
    def IsLicenseValidated() -> bool: ...
    @property
    def IsPreRelease() -> bool: ...
    @property
    def IsRunningAutomated() -> bool: ...
    @property
    def IsRunningHeadless() -> bool: ...
    @property
    def IsSkinned() -> bool: ...
    @property
    def LicenseExpires() -> bool: ...
    @property
    def LicenseUserName() -> str: ...
    @property
    def LicenseUserOrganization() -> str: ...
    @property
    def LoggedInUserAvatar() -> Image: ...
    @property
    def LoggedInUserName() -> str: ...
    @property
    def MainApplicationWindow() -> RhinoWindow: ...
    @property
    def Name() -> str: ...
    @property
    def NodeType() -> LicenseNode: ...
    @property
    def Rhino2Id() -> Guid: ...
    @property
    def Rhino3Id() -> Guid: ...
    @property
    def Rhino4Id() -> Guid: ...
    @property
    def Rhino5Id() -> Guid: ...
    @property
    def Rhino6Id() -> Guid: ...
    @property
    def Rhino7Id() -> Guid: ...
    @property
    def SchemeName() -> str: ...
    @property
    def SdkServiceRelease() -> int: ...
    @property
    def SdkVersion() -> int: ...
    @property
    def SendWriteToConsole() -> bool: ...
    @property
    def SerialNumber() -> str: ...
    @property
    def ToolbarFiles() -> ToolbarFileCollection: ...
    @property
    def UpdatesAndStatisticsStatus() -> int: ...
    @property
    def UserIsLoggedIn() -> bool: ...
    @property
    def ValidationGracePeriodDaysLeft() -> int: ...
    @property
    def Version() -> Version: ...
    @property
    def VersionControlRevision() -> str: ...
    @overload
    def GetDataDirectory(localUser: bool, forceDirectoryCreation: bool) -> str: ...
    @overload
    def GetDataDirectory(localUser: bool, forceDirectoryCreation: bool, subDirectory: str) -> str: ...
    def GetExecutableDirectory() -> DirectoryInfo: ...
    @overload
    def GetPlugInObject(plugin: str) -> Object: ...
    @overload
    def GetPlugInObject(pluginId: Guid) -> Object: ...
    def InFullScreen() -> bool: ...
    def InvokeAndWait(action: Action) -> None: ...
    def InvokeOnUiThread(method: Delegate, args: Set(Object)) -> None: ...
    def IsInstallationBeta(licenseType: Installation) -> bool: ...
    def IsInstallationCommercial(licenseType: Installation) -> bool: ...
    def IsInstallationEvaluation(licenseType: Installation) -> bool: ...
    def LoginToCloudZoo() -> bool: ...
    def MainWindowHandle() -> IntPtr: ...
    def OutputDebugString(str: str) -> None: ...
    def ParseTextField(formula: str, obj: RhinoObject, topParentObject: RhinoObject) -> str: ...
    def RefreshRhinoLicense() -> bool: ...
    def ReleaseMouseCapture() -> bool: ...
    def remove_AppSettingsChanged(value: EventHandler) -> None: ...
    def remove_Closing(value: EventHandler) -> None: ...
    def remove_EscapeKeyPressed(value: EventHandler) -> None: ...
    def remove_Idle(value: EventHandler) -> None: ...
    def remove_Initialized(value: EventHandler) -> None: ...
    def remove_KeyboardEvent(value: KeyboardHookEvent) -> None: ...
    def remove_LicenseStateChanged(value: EventHandler) -> None: ...
    def remove_MainLoop(value: EventHandler) -> None: ...
    def remove_RdkCacheImageChanged(value: EventHandler) -> None: ...
    def remove_RdkGlobalSettingsChanged(value: EventHandler) -> None: ...
    def remove_RdkNewDocument(value: EventHandler) -> None: ...
    def remove_RdkPlugInUnloading(value: EventHandler) -> None: ...
    def remove_RdkUpdateAllPreviews(value: EventHandler) -> None: ...
    def remove_RendererChanged(value: EventHandler) -> None: ...
    def RunMenuScript(script: str) -> bool: ...
    def RunningInRdp() -> bool: ...
    def RunningOnVMWare() -> bool: ...
    @overload
    def RunScript(script: str, echo: bool) -> bool: ...
    @overload
    def RunScript(script: str, mruDisplayString: str, echo: bool) -> bool: ...
    def SendKeystrokes(characters: str, appendReturn: bool) -> None: ...
    @CommandPrompt.setter
    def CommandPrompt(value: str) -> None: ...
    @CommandWindowCaptureEnabled.setter
    def CommandWindowCaptureEnabled(value: bool) -> None: ...
    @SendWriteToConsole.setter
    def SendWriteToConsole(value: bool) -> None: ...
    @overload
    def SetCommandPrompt(prompt: str) -> None: ...
    @overload
    def SetCommandPrompt(prompt: str, promptDefault: str) -> None: ...
    def SetCommandPromptMessage(prompt: str) -> None: ...
    @overload
    def SetFocusToMainWindow() -> None: ...
    @overload
    def SetFocusToMainWindow(doc: RhinoDoc) -> None: ...
    def Wait() -> None: ...
    @overload
    def Write(message: str) -> None: ...
    @overload
    def Write(format: str, arg0: Object) -> None: ...
    @overload
    def Write(format: str, arg0: Object, arg1: Object) -> None: ...
    @overload
    def Write(format: str, arg0: Object, arg1: Object, arg2: Object) -> None: ...
    @overload
    def WriteLine() -> None: ...
    @overload
    def WriteLine(message: str) -> None: ...
    @overload
    def WriteLine(format: str, arg0: Object) -> None: ...
    @overload
    def WriteLine(format: str, arg0: Object, arg1: Object) -> None: ...
    @overload
    def WriteLine(format: str, arg0: Object, arg1: Object, arg2: Object) -> None: ...


class RhinoDoc:
    def add_ActiveDocumentChanged(value: EventHandler) -> None: ...
    def add_AddRhinoObject(value: EventHandler) -> None: ...
    def add_BeforeTransformObjects(value: EventHandler) -> None: ...
    def add_BeginOpenDocument(value: EventHandler) -> None: ...
    def add_BeginSaveDocument(value: EventHandler) -> None: ...
    def add_CloseDocument(value: EventHandler) -> None: ...
    def add_DeleteRhinoObject(value: EventHandler) -> None: ...
    def add_DeselectAllObjects(value: EventHandler) -> None: ...
    def add_DeselectObjects(value: EventHandler) -> None: ...
    def add_DimensionStyleTableEvent(value: EventHandler) -> None: ...
    def add_DocumentPropertiesChanged(value: EventHandler) -> None: ...
    def add_EndOpenDocument(value: EventHandler) -> None: ...
    def add_EndOpenDocumentInitialiViewUpdate(value: EventHandler) -> None: ...
    def add_EndOpenDocumentInitialViewUpdate(value: EventHandler) -> None: ...
    def add_EndSaveDocument(value: EventHandler) -> None: ...
    def add_GroupTableEvent(value: EventHandler) -> None: ...
    def add_InstanceDefinitionTableEvent(value: EventHandler) -> None: ...
    def add_LayerTableEvent(value: EventHandler) -> None: ...
    def add_LightTableEvent(value: EventHandler) -> None: ...
    def add_MaterialTableEvent(value: EventHandler) -> None: ...
    def add_ModifyObjectAttributes(value: EventHandler) -> None: ...
    def add_NewDocument(value: EventHandler) -> None: ...
    def add_PurgeRhinoObject(value: EventHandler) -> None: ...
    def add_RenderEnvironmentTableEvent(value: EventHandler) -> None: ...
    def add_RenderMaterialsTableEvent(value: EventHandler) -> None: ...
    def add_RenderTextureTableEvent(value: EventHandler) -> None: ...
    def add_ReplaceRhinoObject(value: EventHandler) -> None: ...
    def add_SelectObjects(value: EventHandler) -> None: ...
    def add_TextureMappingEvent(value: EventHandler) -> None: ...
    def add_UndeleteRhinoObject(value: EventHandler) -> None: ...
    def add_UserStringChanged(value: EventHandler) -> None: ...
    @overload
    def AddCustomUndoEvent(self, description: str, handler: EventHandler) -> bool: ...
    @overload
    def AddCustomUndoEvent(self, description: str, handler: EventHandler, tag: Object) -> bool: ...
    def AdjustModelUnitSystem(self, newUnitSystem: UnitSystem, scale: bool) -> None: ...
    def AdjustPageUnitSystem(self, newUnitSystem: UnitSystem, scale: bool) -> None: ...
    def BeginUndoRecord(self, description: str) -> UInt32: ...
    def ClearRedoRecords(self) -> None: ...
    @overload
    def ClearUndoRecords(self, purgeDeletedObjects: bool) -> None: ...
    @overload
    def ClearUndoRecords(self, undoSerialNumber: UInt32, purgeDeletedObjects: bool) -> None: ...
    def Create(modelTemplateFileName: str) -> RhinoDoc: ...
    def CreateDefaultAttributes(self) -> ObjectAttributes: ...
    def CreateHeadless(file3dmTemplatePath: str) -> RhinoDoc: ...
    def Dispose(self) -> None: ...
    def EndUndoRecord(self, undoRecordSerialNumber: UInt32) -> bool: ...
    def Equals(self, obj: Object) -> bool: ...
    def Export(self, filePath: str) -> bool: ...
    def ExportSelected(self, filePath: str) -> bool: ...
    def ExtractPreviewImage(path: str) -> Bitmap: ...
    def FindFile(self, filename: str) -> str: ...
    def FromFilePath(filePath: str) -> RhinoDoc: ...
    def FromRuntimeSerialNumber(serialNumber: UInt32) -> RhinoDoc: ...
    @property
    def ActiveDoc() -> RhinoDoc: ...
    @property
    def AnimationProperties(self) -> AnimationProperties: ...
    @property
    def Bitmaps(self) -> BitmapTable: ...
    @property
    def CurrentEnvironment(self) -> ICurrentEnvironment: ...
    @property
    def CurrentUndoRecordSerialNumber(self) -> UInt32: ...
    @property
    def CustomRenderSizes(self) -> List: ...
    @property
    def DateCreated(self) -> DateTime: ...
    @property
    def DateLastEdited(self) -> DateTime: ...
    @property
    def DimStyles(self) -> DimStyleTable: ...
    @property
    def DistanceDisplayPrecision(self) -> int: ...
    @property
    def DocumentId(self) -> int: ...
    @property
    def EarthAnchorPoint(self) -> EarthAnchorPoint: ...
    @property
    def Fonts(self) -> FontTable: ...
    @property
    def GroundPlane(self) -> GroundPlane: ...
    @property
    def Groups(self) -> GroupTable: ...
    @property
    def HatchPatterns(self) -> HatchPatternTable: ...
    @property
    def InstanceDefinitions(self) -> InstanceDefinitionTable: ...
    @property
    def IsAvailable(self) -> bool: ...
    @property
    def IsClosing(self) -> bool: ...
    @property
    def IsCommandRunning(self) -> bool: ...
    @property
    def IsCreating(self) -> bool: ...
    @property
    def IsHeadless(self) -> bool: ...
    @property
    def IsInitializing(self) -> bool: ...
    @property
    def IsLocked(self) -> bool: ...
    @property
    def IsOpening(self) -> bool: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @property
    def IsSendingMail(self) -> bool: ...
    @property
    def Layers(self) -> LayerTable: ...
    @property
    def LayoutSpaceAnnotationScalingEnabled(self) -> bool: ...
    @property
    def Lights(self) -> LightTable: ...
    @property
    def Linetypes(self) -> LinetypeTable: ...
    @property
    def Manifest(self) -> ManifestTable: ...
    @property
    def Materials(self) -> MaterialTable: ...
    @property
    def MeshingParameterStyle(self) -> MeshingParameterStyle: ...
    @property
    def ModelAbsoluteTolerance(self) -> float: ...
    @property
    def ModelAngleToleranceDegrees(self) -> float: ...
    @property
    def ModelAngleToleranceRadians(self) -> float: ...
    @property
    def ModelBasepoint(self) -> Point3d: ...
    @property
    def ModelDistanceDisplayPrecision(self) -> int: ...
    @property
    def ModelRelativeTolerance(self) -> float: ...
    @property
    def ModelSpaceAnnotationScalingEnabled(self) -> bool: ...
    @property
    def ModelSpaceHatchScale(self) -> float: ...
    @property
    def ModelSpaceHatchScalingEnabled(self) -> bool: ...
    @property
    def ModelSpaceTextScale(self) -> float: ...
    @property
    def ModelUnitSystem(self) -> UnitSystem: ...
    @property
    def Modified(self) -> bool: ...
    @property
    def Name(self) -> str: ...
    @property
    def NamedConstructionPlanes(self) -> NamedConstructionPlaneTable: ...
    @property
    def NamedLayerStates(self) -> NamedLayerStateTable: ...
    @property
    def NamedPositions(self) -> NamedPositionTable: ...
    @property
    def NamedViews(self) -> NamedViewTable: ...
    @property
    def NextUndoRecordSerialNumber(self) -> UInt32: ...
    @property
    def Notes(self) -> str: ...
    @property
    def Objects(self) -> ObjectTable: ...
    @property
    def PageAbsoluteTolerance(self) -> float: ...
    @property
    def PageAngleToleranceDegrees(self) -> float: ...
    @property
    def PageAngleToleranceRadians(self) -> float: ...
    @property
    def PageDistanceDisplayPrecision(self) -> int: ...
    @property
    def PageRelativeTolerance(self) -> float: ...
    @property
    def PageUnitSystem(self) -> UnitSystem: ...
    @property
    def Path(self) -> str: ...
    @property
    def PostEffects(self) -> IPostEffects: ...
    @property
    def RedoActive(self) -> bool: ...
    @property
    def RenderEnvironments(self) -> RenderEnvironmentTable: ...
    @property
    def RenderMaterials(self) -> RenderMaterialTable: ...
    @property
    def RenderSettings(self) -> RenderSettings: ...
    @property
    def RenderTextures(self) -> RenderTextureTable: ...
    @property
    def RuntimeData(self) -> RuntimeDocumentDataTable: ...
    @property
    def RuntimeSerialNumber(self) -> UInt32: ...
    @property
    def Snapshots(self) -> SnapshotTable: ...
    @property
    def Strings(self) -> StringTable: ...
    @property
    def SubDAppearance(self) -> SubDComponentLocation: ...
    @property
    def TemplateFileUsed(self) -> str: ...
    @property
    def UndoActive(self) -> bool: ...
    @property
    def UndoRecordingEnabled(self) -> bool: ...
    @property
    def UndoRecordingIsActive(self) -> bool: ...
    @property
    def Views(self) -> ViewTable: ...
    @property
    def Worksession(self) -> Worksession: ...
    def GetAnalysisMeshingParameters(self) -> MeshingParameters: ...
    def GetCurrentMeshingParameters(self) -> MeshingParameters: ...
    def GetEmbeddedFilesList(self, missingOnly: bool) -> Set(str): ...
    def GetGumballPlane(self) -> Tuple[bool, Plane]: ...
    def GetHashCode(self) -> int: ...
    def GetMeshingParameters(self, style: MeshingParameterStyle) -> MeshingParameters: ...
    def GetRenderPrimitiveList(self, viewport: ViewportInfo, attrs: DisplayPipelineAttributes) -> RenderPrimitiveList: ...
    @overload
    def GetRenderPrimitives(self, forceTriangleMeshes: bool, quietly: bool) -> Iterable[RenderPrimitive]: ...
    @overload
    def GetRenderPrimitives(self, viewport: ViewportInfo, forceTriangleMeshes: bool, quietly: bool) -> Iterable[RenderPrimitive]: ...
    @overload
    def GetRenderPrimitives(self, plugInId: Guid, viewport: ViewportInfo, forceTriangleMeshes: bool, quietly: bool) -> Iterable[RenderPrimitive]: ...
    def GetUnitSystemName(self, modelUnits: bool, capitalize: bool, singular: bool, abbreviate: bool) -> str: ...
    def Import(self, filePath: str) -> bool: ...
    def Open(filePath: str) -> Tuple[RhinoDoc, bool]: ...
    @overload
    def OpenDocuments() -> Set(RhinoDoc): ...
    @overload
    def OpenDocuments(includeHeadless: bool) -> Set(RhinoDoc): ...
    def OpenHeadless(file3dmPath: str) -> RhinoDoc: ...
    def ReadFile(path: str, options: FileReadOptions) -> bool: ...
    def ReadFileVersion(self) -> int: ...
    def Redo(self) -> bool: ...
    def remove_ActiveDocumentChanged(value: EventHandler) -> None: ...
    def remove_AddRhinoObject(value: EventHandler) -> None: ...
    def remove_BeforeTransformObjects(value: EventHandler) -> None: ...
    def remove_BeginOpenDocument(value: EventHandler) -> None: ...
    def remove_BeginSaveDocument(value: EventHandler) -> None: ...
    def remove_CloseDocument(value: EventHandler) -> None: ...
    def remove_DeleteRhinoObject(value: EventHandler) -> None: ...
    def remove_DeselectAllObjects(value: EventHandler) -> None: ...
    def remove_DeselectObjects(value: EventHandler) -> None: ...
    def remove_DimensionStyleTableEvent(value: EventHandler) -> None: ...
    def remove_DocumentPropertiesChanged(value: EventHandler) -> None: ...
    def remove_EndOpenDocument(value: EventHandler) -> None: ...
    def remove_EndOpenDocumentInitialiViewUpdate(value: EventHandler) -> None: ...
    def remove_EndOpenDocumentInitialViewUpdate(value: EventHandler) -> None: ...
    def remove_EndSaveDocument(value: EventHandler) -> None: ...
    def remove_GroupTableEvent(value: EventHandler) -> None: ...
    def remove_InstanceDefinitionTableEvent(value: EventHandler) -> None: ...
    def remove_LayerTableEvent(value: EventHandler) -> None: ...
    def remove_LightTableEvent(value: EventHandler) -> None: ...
    def remove_MaterialTableEvent(value: EventHandler) -> None: ...
    def remove_ModifyObjectAttributes(value: EventHandler) -> None: ...
    def remove_NewDocument(value: EventHandler) -> None: ...
    def remove_PurgeRhinoObject(value: EventHandler) -> None: ...
    def remove_RenderEnvironmentTableEvent(value: EventHandler) -> None: ...
    def remove_RenderMaterialsTableEvent(value: EventHandler) -> None: ...
    def remove_RenderTextureTableEvent(value: EventHandler) -> None: ...
    def remove_ReplaceRhinoObject(value: EventHandler) -> None: ...
    def remove_SelectObjects(value: EventHandler) -> None: ...
    def remove_TextureMappingEvent(value: EventHandler) -> None: ...
    def remove_UndeleteRhinoObject(value: EventHandler) -> None: ...
    def remove_UserStringChanged(value: EventHandler) -> None: ...
    def Save(self) -> bool: ...
    @overload
    def SaveAs(self, file3dmPath: str) -> bool: ...
    @overload
    def SaveAs(self, file3dmPath: str, version: int) -> bool: ...
    @overload
    def SaveAsTemplate(self, file3dmTemplatePath: str) -> bool: ...
    @overload
    def SaveAsTemplate(self, file3dmTemplatePath: str, version: int) -> bool: ...
    @ActiveDoc.setter
    def ActiveDoc(value: RhinoDoc) -> None: ...
    @AnimationProperties.setter
    def AnimationProperties(self, value: AnimationProperties) -> None: ...
    @EarthAnchorPoint.setter
    def EarthAnchorPoint(self, value: EarthAnchorPoint) -> None: ...
    @LayoutSpaceAnnotationScalingEnabled.setter
    def LayoutSpaceAnnotationScalingEnabled(self, value: bool) -> None: ...
    @MeshingParameterStyle.setter
    def MeshingParameterStyle(self, value: MeshingParameterStyle) -> None: ...
    @ModelAbsoluteTolerance.setter
    def ModelAbsoluteTolerance(self, value: float) -> None: ...
    @ModelAngleToleranceDegrees.setter
    def ModelAngleToleranceDegrees(self, value: float) -> None: ...
    @ModelAngleToleranceRadians.setter
    def ModelAngleToleranceRadians(self, value: float) -> None: ...
    @ModelBasepoint.setter
    def ModelBasepoint(self, value: Point3d) -> None: ...
    @ModelDistanceDisplayPrecision.setter
    def ModelDistanceDisplayPrecision(self, value: int) -> None: ...
    @ModelRelativeTolerance.setter
    def ModelRelativeTolerance(self, value: float) -> None: ...
    @ModelSpaceAnnotationScalingEnabled.setter
    def ModelSpaceAnnotationScalingEnabled(self, value: bool) -> None: ...
    @ModelSpaceHatchScale.setter
    def ModelSpaceHatchScale(self, value: float) -> None: ...
    @ModelSpaceHatchScalingEnabled.setter
    def ModelSpaceHatchScalingEnabled(self, value: bool) -> None: ...
    @ModelSpaceTextScale.setter
    def ModelSpaceTextScale(self, value: float) -> None: ...
    @ModelUnitSystem.setter
    def ModelUnitSystem(self, value: UnitSystem) -> None: ...
    @Modified.setter
    def Modified(self, value: bool) -> None: ...
    @Notes.setter
    def Notes(self, value: str) -> None: ...
    @PageAbsoluteTolerance.setter
    def PageAbsoluteTolerance(self, value: float) -> None: ...
    @PageAngleToleranceDegrees.setter
    def PageAngleToleranceDegrees(self, value: float) -> None: ...
    @PageAngleToleranceRadians.setter
    def PageAngleToleranceRadians(self, value: float) -> None: ...
    @PageDistanceDisplayPrecision.setter
    def PageDistanceDisplayPrecision(self, value: int) -> None: ...
    @PageRelativeTolerance.setter
    def PageRelativeTolerance(self, value: float) -> None: ...
    @PageUnitSystem.setter
    def PageUnitSystem(self, value: UnitSystem) -> None: ...
    @RenderSettings.setter
    def RenderSettings(self, value: RenderSettings) -> None: ...
    @SubDAppearance.setter
    def SubDAppearance(self, value: SubDComponentLocation) -> None: ...
    @UndoRecordingEnabled.setter
    def UndoRecordingEnabled(self, value: bool) -> None: ...
    def SetCustomMeshingParameters(self, mp: MeshingParameters) -> None: ...
    def SupportsRenderPrimitiveList(self, viewport: ViewportInfo, attrs: DisplayPipelineAttributes) -> bool: ...
    def TryGetRenderPrimitiveBoundingBox(self, viewport: ViewportInfo, attrs: DisplayPipelineAttributes) -> Tuple[bool, BoundingBox]: ...
    def Undo(self) -> bool: ...
    def Write3dmFile(self, path: str, options: FileWriteOptions) -> bool: ...
    def WriteFile(self, path: str, options: FileWriteOptions) -> bool: ...


class RhinoDocObserverArgs:
    def __init__(self, doc: RhinoDoc): ...
    @property
    def Doc(self) -> RhinoDoc: ...
    @property
    def RuntimeSerialNumber(self) -> UInt32: ...


class RhinoFileWatcherChangeReason:
    Created = 1
    Deleted = 2
    Changed = 4
    Renamed = 5


class RhinoMath:
    @overload
    def Clamp(value: float, bound1: float, bound2: float) -> float: ...
    @overload
    def Clamp(value: int, bound1: int, bound2: int) -> int: ...
    @overload
    def CRC32(currentRemainder: UInt32, value: int) -> UInt32: ...
    @overload
    def CRC32(currentRemainder: UInt32, buffer: Set(Byte)) -> UInt32: ...
    @overload
    def CRC32(currentRemainder: UInt32, value: float) -> UInt32: ...
    @overload
    def EpsilonEquals(x: Single, y: Single, epsilon: Single) -> bool: ...
    @overload
    def EpsilonEquals(x: float, y: float, epsilon: float) -> bool: ...
    def EvaluateNormal(limitDirection: int, ds: Vector3d, dt: Vector3d, dss: Vector3d, dst: Vector3d, dtt: Vector3d) -> Tuple[bool, Vector3d]: ...
    def EvaluateNormalPartials(ds: Vector3d, dt: Vector3d, dss: Vector3d, dst: Vector3d, dtt: Vector3d) -> Tuple[bool, Vector3d, Vector3d]: ...
    def IntIndexToString(index: int) -> str: ...
    def IsValidDouble(x: float) -> bool: ...
    def IsValidSingle(x: Single) -> bool: ...
    def MetersPerUnit(units: UnitSystem) -> float: ...
    def ParseNumber(expression: str) -> float: ...
    def ToDegrees(radians: float) -> float: ...
    def ToRadians(degrees: float) -> float: ...
    def TryParseNumber(expression: str) -> Tuple[bool, float]: ...
    def UnitScale(from_: UnitSystem, to: UnitSystem) -> float: ...
    def Wrap(value: float, bound1: float, bound2: float) -> float: ...


class RhinoWindow:
    @property
    def Handle(self) -> IntPtr: ...
    @property
    def InvokeRequired(self) -> bool: ...
    def Invoke(self, method: Delegate) -> None: ...


class RuntimeEnvironment:
    Unset = 0
    #None = 1
    Windows = 2
    Apple = 3
    Android = 4
    Linux = 5


class ScaleStringFormat:
    #None = 0
    RatioFormat = 1
    EquationFormat = 2
    FractionFormat = 3
    Unset = 255


class ScaleValue:
    def __init__(self): ...
    @overload
    def Create(s: str, ps: StringParserSettings) -> ScaleValue: ...
    @overload
    def Create(left: LengthValue, right: LengthValue, format: ScaleStringFormat) -> ScaleValue: ...
    def Dispose(self) -> None: ...
    @property
    def LeftToRightScale(self) -> float: ...
    @property
    def RightToLeftScale(self) -> float: ...
    def IsUnset(self) -> bool: ...
    def LeftLengthValue(self) -> LengthValue: ...
    def OneToOne() -> ScaleValue: ...
    def RightLengthValue(self) -> LengthValue: ...


class StringFormat:
    ExactDecimal = 0
    ExactProperFraction = 1
    ExactImproperFraction = 2
    CleanDecimal = 3
    CleanProperFraction = 4
    CleanImproperFraction = 5


class Symbols:
    @property
    def DegreeSymbol() -> Char: ...
    @property
    def DiameterSymbol() -> Char: ...
    @property
    def PlusMinusSymbol() -> Char: ...
    @property
    def RadiusSymbol() -> Char: ...


class TextureMappingEventArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def EventType(self) -> TextureMappingEventType: ...
    @property
    def NewMapping(self) -> TextureMapping: ...
    @property
    def OldMapping(self) -> TextureMapping: ...


class TextureMappingEventType:
    Added = 0
    Deleted = 1
    Undeleted = 2
    Modified = 3


class UnitSystem:
    #None = 0
    Microns = 1
    Millimeters = 2
    Centimeters = 3
    Meters = 4
    Kilometers = 5
    Microinches = 6
    Mils = 7
    Inches = 8
    Feet = 9
    Miles = 10
    CustomUnits = 11
    Angstroms = 12
    Nanometers = 13
    Decimeters = 14
    Dekameters = 15
    Hectometers = 16
    Megameters = 17
    Gigameters = 18
    Yards = 19
    PrinterPoints = 20
    PrinterPicas = 21
    NauticalMiles = 22
    AstronomicalUnits = 23
    LightYears = 24
    Parsecs = 25
    Unset = 255


class UserStringChangedArgs:
    @property
    def Document(self) -> RhinoDoc: ...
    @property
    def Key(self) -> str: ...
