import datetime as dt

na_metadata = {
    "ind_con_nsa":
        {"Rows": 12, "Inf. Adj.": "Const. 2005", "Unit": "Miles",
         "Seas": "NSA",
         "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/cuadro_101t.xls",
         "Colnames": ["Actividades primarias",
                      "Act. prim.: Agricultura, ganadería, caza y silvicultura",
                      "Industrias manufactureras",
                      "Suministro de electricidad, gas y agua",
                      "Construcción",
                      "Comercio, reparaciones, restaurantes y hoteles",
                      "Transporte, almacenamiento y comunicaciones",
                      "Otras actividades",
                      "Otras actividades: SIFMI",
                      "Impuestos menos subvenciones",
                      "Producto bruto interno"]},
    "ind_cur_nsa":
        {"Rows": 12, "Inf. Adj.": "No", "Unit": "Miles", "Seas": "NSA",
         "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/cuadro_100t.xls",
         "Colnames": ["Actividades primarias",
                      "Act. prim.: Agricultura, ganadería, caza y silvicultura",
                      "Industrias manufactureras",
                      "Suministro de electricidad, gas y agua",
                      "Construcción",
                      "Comercio, reparaciones, restaurantes y hoteles",
                      "Transporte, almacenamiento y comunicaciones",
                      "Otras actividades",
                      "Otras actividades: SIFMI",
                      "Impuestos menos subvenciones",
                      "Producto bruto interno"]},
    "gas_con_nsa":
        {"Rows": 10, "Inf. Adj.": "Const. 2005", "Unit": "Miles",
         "Seas": "NSA",
         "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/cuadro_104t.xls",
         "Colnames": ["Gasto: total", "Gasto: privado",
                      "Gasto: público",
                      "Formación bruta de capital",
                      "Formación bruta de capital: fijo",
                      "Formación bruta de capital: fijo - pública",
                      "Formación bruta de capital: fijo - privada",
                      "Exportaciones",
                      "Importaciones", "Producto bruto interno"]},
    "ind_con_idx_nsa":
        {"Rows": 12, "Inf. Adj.": "Const. 2005", "Unit": "2005=100",
         "Seas": "NSA",
         "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/cuadro_132t.xls",
         "Colnames": ["Actividades primarias",
                      "Act. prim.: Agricultura, ganadería, caza y silvicultura",
                      "Industrias manufactureras",
                      "Suministro de electricidad, gas y agua",
                      "Construcción",
                      "Comercio, reparaciones, restaurantes y hoteles",
                      "Transporte, almacenamiento y comunicaciones",
                      "Otras actividades",
                      "Otras actividades: SIFMI",
                      "Impuestos menos subvenciones",
                      "Producto bruto interno"]},
    "ind_con_idx_sa":
        {"Rows": 12, "Inf. Adj.": "Const. 2005", "Unit": "2005=100",
         "Seas": "SA",
         "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/cuadro_133t.xls",
         "Colnames": ["Actividades primarias",
                      "Act. prim.: Agricultura, ganadería, caza y silvicultura",
                      "Industrias manufactureras",
                      "Suministro de electricidad, gas y agua",
                      "Construcción",
                      "Comercio, reparaciones, restaurantes y hoteles",
                      "Transporte, almacenamiento y comunicaciones",
                      "Otras actividades",
                      "Otras actividades: SIFMI",
                      "Impuestos menos subvenciones",
                      "Producto bruto interno"]},
    "gdp_cur_nsa":
        {"Rows": 2, "Inf. Adj.": "No", "Unit": "Miles", "Seas": "NSA",
         "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/cuadro_130t.xls",
         "Colnames": ["Producto bruto interno"]}}

trade_metadata = {
    "x_prod_val": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/exp_ciiu_val.xls",
        "cols": "D:ZZZ", "currency": "USD", "unit": "Millones",
        "old_colnames": ['TOTAL EXPORTACIONES ', 'ACTIVIDADES PRIMARIAS',
                         'Agricultura, Ganadería, Caza y actividades de servicios conexas',
                         'Cultivos en general; horticultura; servicios agrícolas aplicados a estos cultivos',
                         'Cría de animales; caza ordinaria y servicios conexos; producción de pieles finas mediante actividades de caza ordinaria y con trampas; servicios ganaderos',
                         'Silvicultura, extracción de madera y actividades de servicios conexas',
                         'INDUSTRIAS MANUFACTURERAS',
                         'Elaboración de productos alimenticios y bebidas',
                         'Producción, procesamiento y conservación de carne y productos cárnicos',
                         'Elaboración y conservación de pescado y productos de pescado',
                         'Elaboración de productos lácteos',
                         'Elaboración de arroz y productos derivados del arroz',
                         'Elaboración de bebidas malteadas y de malta',
                         'Elaboración de productos alimenticios y bebidas - Resto ',
                         'Elaboración de Productos de Tabaco',
                         'Fabricación de productos textiles',
                         'Preparación, hilandería, tejeduría y acabado de productos textiles',
                         'Fabricación de prendas de vestir; adobo y  teñido de pieles',
                         'Curtido y adobo de cueros; fabricación de maletas, bolsos de mano, artículos de talabartería y guarnicionería, y calzado',
                         'Curtido y adobo de cueros; fabricación de maletas, bolsos de mano y artículos de talabartería y guarnicionería',
                         'Producción de madera y fabricación de productos de madera y corcho excepto muebles; fabricación de artículos de paja y de materiales trenzables',
                         'Fabricación de papel y de productos de papel; Actividades de edición e impresión y de reproducción de grabaciones',
                         'Fabricación de coque, productos de la refinación del petróleo y combustible nuclear',
                         'Fabricación de sustancias y productos químicos',
                         'Fabricación de sustancias químicas básicas, excepto abonos y compuestos de nitrógeno; fabricación de plásticos en formas primarias y de caucho sintético',
                         'Fabricación de abonos y compuestos de nitrógeno; Fabricación de plaguicidas y otros productos químicos de uso agropecuario',
                         'Fabricación de productos farmaceúticos, sustancias químicas medicinales y productos botánicos',
                         'Fabricación de jabones y detergentes, preparados para limpiar y pulir, perfumes y preparados de tocador',
                         'Fabricación de productos de caucho y plástico',
                         'Fabricación de metales comunes; Fabricación de otros productos minerales no metálicos',
                         'Fabricación de vehículos automotores, remolques y semirremolques; Fabricación de otros tipos de equipo de transporte',
                         'INDUSTRIAS MANUFACTURERAS - Resto',
                         'ELECTRICIDAD, GAS Y AGUA'],
        "new_colnames": ["Total exportaciones",
                         "Actividades primarias: total",
                         "Act. primarias: agricultura, ganadería y caza",
                         "Act. primarias: agricultura",
                         "Act. primarias: ganadería y caza",
                         "Act. primarias: silvicultura",
                         "Industrias manufactureras: total",
                         "Ind. manufacturera: alimentos y bebidas",
                         "Ind. manufacturera: alimentos y bebidas - carnes",
                         "Ind. manufacturera: alimentos y bebidas - pescado",
                         "Ind. manufacturera: alimentos y bebidas - lácteos",
                         "Ind. manufacturera: alimentos y bebidas - arroz",
                         "Ind. manufacturera: alimentos y bebidas - malta",
                         "Ind. manufacturera: alimentos y bebidas - otros",
                         "Ind. manufacturera: tabaco",
                         "Ind. manufacturera: textiles",
                         "Ind. manufacturera: textiles - hilandería y tejeduria",
                         "Ind. manufacturera: prendas de vestir",
                         "Ind. manufacturera: cueros",
                         "Ind. manufacturera: cueros - curtidos, adobos, derivados",
                         "Ind. manufacturera: madera",
                         "Ind. manufacturera: papel",
                         "Ind. manufacturera: refinación de petróleo",
                         "Ind. manufacturera: químicos",
                         "Ind. manufacturera: químicos - básicos excepto abonos",
                         "Ind. manufacturera: químicos - abonos",
                         "Ind. manufacturera: químicos - farmacéuticos",
                         "Ind. manufacturera: químicos - jabones y detergentes",
                         "Ind. manufacturera: caucho y plástico",
                         "Ind. manufacturera: metales y minerales no metálicos",
                         "Ind. manufacturera: automotores",
                         "Ind. manufacturera: otros",
                         "Electricidad, gas y agua: total"]},
    "x_prod_vol": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_exp_ciiu_ivf.xls",
        "cols": "D:ZZZ", "currency": "-", "unit": "2005=100",
        "old_colnames": ['TOTAL EXPORTACIONES ',
                         'AGRICULTURA, GANADERIA, CAZA Y SILVICULTURA',
                         'Trigo; servicios agrícolas aplicados al cultivo de trigo',
                         'Soja; girasol; servicios agrícolas aplicados al cultivo de soja y girasol',
                         'Productos de árboles frutales, uvas, y plantas cuyas hojas o frutas se utilizan para preparar bebidas o especias; servicios agrícolas aplicados a estos cultivos',
                         'Productos de la cría de ganado vacuno, ovino, caprino, caballar, excepto producción de leche, lana y cueros; servicios ganaderos aplicados a esta actividad',
                         'Madera y otros productos de la silvicultura. Servicios conexos',
                         'INDUSTRIAS MANUFACTURERAS',
                         'Carnes y productos del procesamiento y conservación de carne',
                         'Productos de la elaboración y conservación de pescado',
                         'Productos lácteos',
                         'Arroz elaborado y otros productos derivados del arroz',
                         'Productos de la elaboración de cacao, chocolate, productos de confitería y otros productos alimenticios n.c.p.\n',
                         'Bebidas malteadas y malta',
                         'Productos de lavaderos; hilados y tejidos; otros productos de la hilandería, tejeduría y acabado de productos textiles',
                         'Prendas de vestir; adobo y teñido de pieles',
                         'Cueros elaborados; artículos de talabartería y guarnicionería',
                         'Productos de aserrado y otros artículos de madera, excepto muebles',
                         'Papel, cartón y subproductos',
                         'Productos de la refinación del petróleo y combustible nuclear',
                         'Abonos y compuestos de nitrógeno',
                         'Sustancias químicas básicas, excepto abonos',
                         'Productos farmacéuticos, sustancias químicas medicinales y productos botánicos, de uso humano y animal',
                         'Productos de limpieza y tocador, primarias y de caucho sintético',
                         'Productos de caucho y plástico',
                         'Productos de fundición de hierro y acero; aluminio y otros metales no ferrosos',
                         'Vehículos automotores, remolques, semiremolques y contenedores; partes y piezas elaboradas para los mismos'],
        "new_colnames": ["Total exportaciones",
                         "Actividades primarias: total",
                         "Actividades primarias: trigo",
                         "Actividades primarias: soja y girasol",
                         "Actividades primarias: prod. árboles frutales",
                         "Actividades primarias: ganadería",
                         "Actividades primarias: silvicultura",
                         "Industrias manufactureras: total",
                         "Ind. manufacturera: alimentos y bebidas - carnes",
                         "Ind. manufacturera: alimentos y bebidas - pescado",
                         "Ind. manufacturera: alimentos y bebidas - lácteos",
                         "Ind. manufacturera: alimentos y bebidas - arroz",
                         "Ind. manufacturera: alimentos y bebidas - cacao",
                         "Ind. manufacturera: alimentos y bebidas - malta",
                         "Ind. manufacturera: textiles",
                         "Ind. manufacturera: prendas de vestir",
                         "Ind. manufacturera: cueros - curtidos, adobos, derivados",
                         "Ind. manufacturera: madera",
                         "Ind. manufacturera: papel",
                         "Ind. manufacturera: refinación de petróleo",
                         "Ind. manufacturera: químicos - abonos",
                         "Ind. manufacturera: químicos - básicos excepto abonos",
                         "Ind. manufacturera: químicos - farmacéuticos",
                         "Ind. manufacturera: químicos - jabones y detergentes",
                         "Ind. manufacturera: caucho y plástico",
                         "Ind. manufacturera: metales y minerales no metálicos",
                         "Ind. manufacturera: automotores"]},
    "x_prod_pri": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_exp_ciiu_ip.xls",
        "cols": "D:ZZZ", "currency": "USD", "unit": "2005=100",
        "old_colnames": ['TOTAL EXPORTACIONES ',
                         'AGRICULTURA, GANADERIA, CAZA Y SILVICULTURA',
                         'Trigo; servicios agrícolas aplicados al cultivo de trigo',
                         'Soja; girasol; servicios agrícolas aplicados al cultivo de soja y girasol',
                         'Productos de árboles frutales, uvas, y plantas cuyas hojas o frutas se utilizan para preparar bebidas o especias; servicios agrícolas aplicados a estos cultivos',
                         'Productos de la cría de ganado vacuno, ovino, caprino, caballar, excepto producción de leche, lana y cueros; servicios ganaderos aplicados a esta actividad',
                         'Madera y otros productos de la silvicultura. Servicios conexos',
                         'INDUSTRIAS MANUFACTURERAS',
                         'Carnes y productos del procesamiento y conservación de carne',
                         'Productos de la elaboración y conservación de pescado',
                         'Productos lácteos',
                         'Arroz elaborado y otros productos derivados del arroz',
                         'Productos de la elaboración de cacao, chocolate, productos de confitería y otros productos alimenticios n.c.p.',
                         'Bebidas malteadas y malta',
                         'Productos de lavaderos; hilados y tejidos; otros productos de la hilandería, tejeduría y acabado de productos textiles',
                         'Prendas de vestir; adobo y teñido de pieles',
                         'Cueros elaborados; artículos de talabartería y guarnicionería',
                         'Productos de aserrado y otros artículos de madera, excepto muebles',
                         'Papel, cartón y subproductos',
                         'Productos de la refinación del petróleo y combustible nuclear',
                         'Abonos y compuestos de nitrógeno',
                         'Sustancias químicas básicas, excepto abonos',
                         'Productos farmacéuticos, sustancias químicas medicinales y productos botánicos, de uso humano y animal',
                         'Productos de limpieza y tocador, primarias y de caucho sintético',
                         'Productos de caucho y plástico',
                         'Productos de fundición de hierro y acero; aluminio y otros metales no ferrosos',
                         'Vehículos automotores, remolques, semiremolques y contenedores; partes y piezas elaboradas para los mismos'],
        "new_colnames": ["Total exportaciones",
                         "Actividades primarias: total",
                         "Actividades primarias: trigo",
                         "Actividades primarias: soja y girasol",
                         "Actividades primarias: prod. árboles frutales",
                         "Actividades primarias: ganadería",
                         "Actividades primarias: silvicultura",
                         "Industrias manufactureras: total",
                         "Ind. manufacturera: alimentos y bebidas - carnes",
                         "Ind. manufacturera: alimentos y bebidas - pescado",
                         "Ind. manufacturera: alimentos y bebidas - lácteos",
                         "Ind. manufacturera: alimentos y bebidas - arroz",
                         "Ind. manufacturera: alimentos y bebidas - cacao",
                         "Ind. manufacturera: alimentos y bebidas - malta",
                         "Ind. manufacturera: textiles",
                         "Ind. manufacturera: prendas de vestir",
                         "Ind. manufacturera: cueros - curtidos, adobos, derivados",
                         "Ind. manufacturera: madera",
                         "Ind. manufacturera: papel",
                         "Ind. manufacturera: refinación de petróleo",
                         "Ind. manufacturera: químicos - abonos",
                         "Ind. manufacturera: químicos - básicos excepto abonos",
                         "Ind. manufacturera: químicos - farmacéuticos",
                         "Ind. manufacturera: químicos - jabones y detergentes",
                         "Ind. manufacturera: caucho y plástico",
                         "Ind. manufacturera: metales y minerales no metálicos",
                         "Ind. manufacturera: automotores"]},
    "x_dest_val": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/exp_pais_val.xls",
        "cols": "B:ZZZ", "currency": "USD", "unit": "Millones",
        "old_colnames": ['TOTAL EXPORTACIONES', 'AMERICA', 'ALADI 2/',
                         'Argentina', 'Brasil', 'Paraguay',
                         'Sub-total MERCOSUR (4 PAISES)', 'Venezuela',
                         'Sub-total MERCOSUR (5 PAISES)', 'Bolivia', 'Chile',
                         'México', 'Otros de Aladi', 'CANADA',
                         'ESTADOS UNIDOS', 'RESTO DE AMERICA', 'EUROPA',
                         'U.E. (UNION EUROPEA)', 'Alemania', 'España',
                         'Francia', 'Italia', 'Países Bajos', 'Reino Unido',
                         'Otros de la U.E.', 'AELC (EFTA)1/',
                         'RESTO DE EUROPA', 'Rusia', 'RESTO DEL MUNDO',
                         'AFRICA', 'ASIA (excl. M. Oriente)',
                         'China (Continental)', 'Corea del Sur', 'Taiwán',
                         'Hong Kong', 'Japón', 'Otros de Asia',
                         'MEDIO ORIENTE', 'Arabia', 'Irán', 'Israel',
                         'Otros del Medio Oriente', 'OTROS PAISES'],
        "new_colnames": ["Total exportaciones",
                         "América: total",
                         "América: ALADI",
                         "América: Argentina",
                         "América: Brasil",
                         "América: Paraguay",
                         "América: MERCOSUR 4 países",
                         "América: Venezuela",
                         "América: MERCOSUR 5 países",
                         "América: Bolivia",
                         "América: Chile",
                         "América: México",
                         "América: otros ALADI",
                         "América: Canadá",
                         "América: Estados Unidos",
                         "América: otros",
                         "Europa: total",
                         "Europa: Unión Europea - total",
                         "Europa: UE - Alemania",
                         "Europa: UE - España",
                         "Europa: UE - Francia",
                         "Europa: UE - Italia",
                         "Europa: UE - Países Bajos",
                         "Europa: UE - Reino Unido",
                         "Europa: UE - otros",
                         "Europa: EFTA",
                         "Europa: otros",
                         "Europa: otros - Rusia",
                         "Resto del mundo: total",
                         "Resto del mundo: África",
                         "Resto del mundo: Asia - total",
                         "Resto del mundo: Asia - China",
                         "Resto del mundo: Asia - Corea del Sur",
                         "Resto del mundo: Asia - Taiwán",
                         "Resto del mundo: Asia - Hong Kong",
                         "Resto del mundo: Asia - Japón",
                         "Resto del mundo: Asia - otros",
                         "Resto del mundo: Medio Oriente - total",
                         "Resto del mundo: Medio Oriente - Arabia",
                         "Resto del mundo: Medio Oriente - Irán",
                         "Resto del mundo: Medio Oriente - Israel",
                         "Resto del mundo: Medio Oriente - otros",
                         "Resto del mundo: otros"]},
    "x_dest_vol": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_exp_pais_ivf.xls",
        "cols": "B:ZZZ", "currency": "-", "unit": "2005=100",
        "old_colnames": ['TOTAL EXPORTACIONES', 'AMERICA', 'ALADI 1/',
                         'Argentina', 'Brasil', 'Paraguay',
                         'SUB-TOTAL  MERCOSUR (4 PAISES)', 'Venezuela',
                         'SUB-TOTAL  MERCOSUR (5 PAISES)', 'Chile', 'México',
                         'CANADA', 'ESTADOS UNIDOS', 'EUROPA',
                         'U.E. (UNION EUROPEA)', 'Alemania', 'España',
                         'Francia', 'Italia', 'Países Bajos', 'Reino Unido',
                         'RESTO DE EUROPA', 'Rusia', 'RESTO DEL MUNDO'],
        "new_colnames": ["Total exportaciones",
                         "América: total",
                         "América: ALADI",
                         "América: Argentina",
                         "América: Brasil",
                         "América: Paraguay",
                         "América: MERCOSUR 4 países",
                         "América: Venezuela",
                         "América: MERCOSUR 5 países",
                         "América: Chile",
                         "América: México",
                         "América: Canadá",
                         "América: Estados Unidos",
                         "Europa: total",
                         "Europa: Unión Europea - total",
                         "Europa: UE - Alemania",
                         "Europa: UE - España",
                         "Europa: UE - Francia",
                         "Europa: UE - Italia",
                         "Europa: UE - Países Bajos",
                         "Europa: UE - Reino Unido",
                         "Europa: otros",
                         "Europa: otros - Rusia",
                         "Resto del mundo: total"]},
    "x_dest_pri": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_exp_pais_ip.xls",
        "cols": "B:ZZZ", "currency": "USD", "unit": "2005=100",
        "old_colnames": ['TOTAL EXPORTACIONES', 'AMERICA', 'ALADI 1/',
                         'Argentina', 'Brasil', 'Paraguay',
                         'Sub-total MERCOSUR (4 PAISES)', 'Venezuela',
                         'SUB-TOTAL  MERCOSUR (5 PAISES)', 'Chile', 'México',
                         'CANADA', 'ESTADOS UNIDOS', 'EUROPA',
                         'U.E. (UNION EUROPEA)', 'Alemania', 'España',
                         'Francia', 'Italia', 'Países Bajos', 'Reino Unido',
                         'RESTO DE EUROPA', 'Rusia', 'RESTO DEL MUNDO'],
        "new_colnames": ["Total exportaciones",
                         "América: total",
                         "América: ALADI",
                         "América: Argentina",
                         "América: Brasil",
                         "América: Paraguay",
                         "América: MERCOSUR 4 países",
                         "América: Venezuela",
                         "América: MERCOSUR 5 países",
                         "América: Chile",
                         "América: México",
                         "América: Canadá",
                         "América: Estados Unidos",
                         "Europa: total",
                         "Europa: Unión Europea - total",
                         "Europa: UE - Alemania",
                         "Europa: UE - España",
                         "Europa: UE - Francia",
                         "Europa: UE - Italia",
                         "Europa: UE - Países Bajos",
                         "Europa: UE - Reino Unido",
                         "Europa: otros",
                         "Europa: otros - Rusia",
                         "Resto del mundo: total"]},
    "m_sect_val": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/imp_gce_val.xls",
        "cols": "C:ZZZ", "currency": "USD", "unit": "Millones",
        "old_colnames": ['TOTAL IMPORTACIONES FOB ',
                         'TOTAL IMPORTACIONES CIF ',
                         'TOTAL IMPORTACIONES CIF SIN PETRÓLEO, DESTILADOS Y ENERGÍA ELÉCTRICA',
                         'CONSUMO', 'Alimentos y bebidas',
                         'Automotores y otros de transporte', 'Duraderos',
                         'Otros de consumo', 'CAPITAL', 'Maquinaria y equipos',
                         'Público', 'Privado', 'Equipos de transporte',
                         'Público', 'Privado', 'INTERMEDIOS ',
                         'Petróleo y destilados ', 'Energía eléctrica',
                         'Intermedios sin petróleo, destilados y energía eléctrica',
                         'Alimentos y bebidas',
                         'Piezas y accesorios de transporte',
                         'Otros insumos intermedios',
                         'Suministros industriales básicos',
                         'Suministros industriales elaborados', 'Resto'],
        "new_colnames": ["Total importaciones: FOB",
                         "Total importaciones: CIF ",
                         "Total importaciones: CIF sin petróleo y energía eléct.",
                         "Consumo: total",
                         "Consumo: alimentos y bebidas",
                         "Consumo: automotores",
                         "Consumo: duraderos",
                         "Consumo: otros",
                         "Capital: total",
                         "Capital: maquinaria y equipos",
                         "Capital: maquinaria y equipos - público",
                         "Capital: maquinaria y equipos - privado",
                         "Capital: equipos de transporte",
                         "Capital: equipos de transporte - público",
                         "Capital: equipos de transporte - privado",
                         "Intermedios: total",
                         "Intermedios: petróleo y destilados",
                         "Intermedios: energía eléctrica",
                         "Intermedios: total sin petróleo y energía eléctrica",
                         "Intermedios: alimentos y bebidas",
                         "Intermedios: piezas de transporte",
                         "Intermedios: otros",
                         "Intermedios: otros - industriales básicos",
                         "Intermedios: otros - industriales elaborados",
                         "Intermedios: otros - resto"]},
    "m_sect_vol": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_imp_gce_ivf.xls",
        "cols": "B:ZZZ", "currency": "-", "unit": "2005=100",
        "old_colnames": ['TOTAL IMPORTACIONES', 'CONSUMO',
                         'ALIMENTOS Y BEBIDAS PARA LOS HOGARES',
                         'AUTOMOTORES Y OTROS DE TRANSPORTE',
                         'CONSUMO DURADERO', 'OTROS DE CONSUMO', 'CAPITAL',
                         'INTERMEDIOS', 'PETROLEO Y DESTILADOS',
                         'INTERMEDIOS SIN PETROLEO, DESTILADOS Y ENERGIA ELECTRICA',
                         'ALIMENTOS Y BEBIDAS PARA LA INDUSTRIA',
                         'PIEZAS Y ACCESORIOS DE TRANSPORTE',
                         'OTROS INSUMOS INTERMEDIOS'],
        "new_colnames": ["Total importaciones",
                         "Consumo: total",
                         "Consumo: alimentos y bebidas",
                         "Consumo: automotores",
                         "Consumo: duraderos",
                         "Consumo: otros",
                         "Capital: total",
                         "Intermedios: total",
                         "Intermedios: petróleo",
                         "Intermedios: total sin petróleo y energía eléctrica",
                         "Intermedios: alimentos y bebidas",
                         "Intermedios: transporte",
                         "Intermedios: otros"]},
    "m_sect_pri": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_imp_gce_ip.xls",
        "cols": "B:ZZZ", "currency": "USD", "unit": "2005=100",
        "old_colnames": ['TOTAL IMPORTACIONES', 'CONSUMO',
                         'ALIMENTOS Y BEBIDAS PARA LOS HOGARES',
                         'AUTOMOTORES Y OTROS DE TRANSPORTE',
                         'CONSUMO DURADERO', 'OTROS DE CONSUMO', 'CAPITAL',
                         'INTERMEDIOS', 'PETROLEO Y DESTILADOS',
                         'INTERMEDIOS SIN PETROLEO, DESTILADOS Y ENERGIA ELECTRICA',
                         'ALIMENTOS Y BEBIDAS PARA LA INDUSTRIA',
                         'PIEZAS Y ACCESORIOS DE TRANSPORTE',
                         'OTROS INSUMOS INTERMEDIOS'],
        "new_colnames": ["Total importaciones",
                         "Consumo: total",
                         "Consumo: alimentos y bebidas",
                         "Consumo: automotores",
                         "Consumo: duraderos",
                         "Consumo: otros",
                         "Capital: total",
                         "Intermedios: total",
                         "Intermedios: petróleo",
                         "Intermedios: total sin petróleo y energía eléctrica",
                         "Intermedios: alimentos y bebidas",
                         "Intermedios: transporte",
                         "Intermedios: otros"]},
    "m_orig_val": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/imp_pais_val.xls",
        "cols": "B:ZZZ", "currency": "USD", "unit": "Millones",
        "old_colnames": ['TOTAL IMPORTACIONES CIF ', 'AMERICA', 'ALADI 2/',
                         'Argentina', 'Brasil', 'Paraguay',
                         'Sub-total MERCOSUR (4 PAISES)', 'Venezuela',
                         'Sub-total MERCOSUR (5 PAISES)', 'Bolivia', 'Chile',
                         'México', 'Otros de Aladi', 'CANADA',
                         'ESTADOS UNIDOS', 'RESTO DE AMERICA', 'EUROPA',
                         'U.E. (UNION EUROPEA)', 'Alemania', 'España',
                         'Francia', 'Italia', 'Países Bajos', 'Reino Unido',
                         'Otros de la U.E.', 'AELC (EFTA)1/',
                         'RESTO DE EUROPA', 'Rusia', 'RESTO DEL MUNDO',
                         'AFRICA', 'ASIA (excl. M. Oriente)',
                         'China (Continental)', 'Corea del Sur', 'Taiwán',
                         'Hong Kong', 'Japón', 'Otros de Asia',
                         'MEDIO ORIENTE', 'Arabia', 'Irán', 'Israel',
                         'Otros del Medio Oriente', 'OTROS PAISES'],
        "new_colnames": ["Total importaciones",
                         "América: total",
                         "América: ALADI",
                         "América: Argentina",
                         "América: Brasil",
                         "América: Paraguay",
                         "América: MERCOSUR 4 países",
                         "América: Venezuela",
                         "América: MERCOSUR 5 países",
                         "América: Bolivia",
                         "América: Chile",
                         "América: México",
                         "América: otros ALADI",
                         "América: Canadá",
                         "América: Estados Unidos",
                         "América: otros",
                         "Europa: total",
                         "Europa: Unión Europea - total",
                         "Europa: UE - Alemania",
                         "Europa: UE - España",
                         "Europa: UE - Francia",
                         "Europa: UE - Italia",
                         "Europa: UE - Países Bajos",
                         "Europa: UE - Reino Unido",
                         "Europa: UE - otros",
                         "Europa: EFTA",
                         "Europa: otros",
                         "Europa: otros - Rusia",
                         "Resto del mundo: total",
                         "Resto del mundo: África",
                         "Resto del mundo: Asia - total",
                         "Resto del mundo: Asia - China",
                         "Resto del mundo: Asia - Corea del Sur",
                         "Resto del mundo: Asia - Taiwán",
                         "Resto del mundo: Asia - Hong Kong",
                         "Resto del mundo: Asia - Japón",
                         "Resto del mundo: Asia - otros",
                         "Resto del mundo: Medio Oriente - total",
                         "Resto del mundo: Medio Oriente - Arabia",
                         "Resto del mundo: Medio Oriente - Irán",
                         "Resto del mundo: Medio Oriente - Israel",
                         "Resto del mundo: Medio Oriente - otros",
                         "Resto del mundo: otros"]},
    "m_orig_vol": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_imp_pais_ivf.xls",
        "cols": "B:ZZZ", "currency": "-", "unit": "2005=100",
        "old_colnames": ['TOTAL IMPORTACIONES', 'AMERICA', 'ALADI 1/',
                         'Argentina', 'Brasil', 'Paraguay',
                         'Sub-total MERCOSUR (4 PAISES)', 'Venezuela',
                         'SUB-TOTAL  MERCOSUR (5 PAISES)', 'Chile', 'México',
                         'CANADA', 'ESTADOS UNIDOS', 'EUROPA',
                         'U.E. (UNION EUROPEA)', 'Alemania', 'España',
                         'Francia', 'Italia', 'Países Bajos', 'Reino Unido',
                         'RUSIA', 'RESTO DEL MUNDO', 'China (Continental)'],
        "new_colnames": ["Total importaciones",
                         "América: total",
                         "América: ALADI",
                         "América: Argentina",
                         "América: Brasil",
                         "América: Paraguay",
                         "América: MERCOSUR 4 países",
                         "América: Venezuela",
                         "América: MERCOSUR 5 países",
                         "América: Chile",
                         "América: México",
                         "América: Canadá",
                         "América: Estados Unidos",
                         "Europa: total",
                         "Europa: Unión Europea - total",
                         "Europa: UE - Alemania",
                         "Europa: UE - España",
                         "Europa: UE - Francia",
                         "Europa: UE - Italia",
                         "Europa: UE - Países Bajos",
                         "Europa: UE - Reino Unido",
                         "Europa: Rusia",
                         "Resto del mundo: total",
                         "Resto del mundo: China"]},
    "m_orig_pri": {
        "url": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/ComercioExterior_ICB/web_imp_pais_ip.xls",
        "cols": "B:ZZZ", "currency": "USD", "unit": "2005=100",
        "old_colnames": ['TOTAL IMPORTACIONES', 'AMERICA', 'ALADI 1/',
                         'Argentina', 'Brasil', 'Paraguay',
                         'Sub-total MERCOSUR (4 PAISES)', 'Venezuela',
                         'SUB-TOTAL  MERCOSUR (5 PAISES)', 'Chile', 'México',
                         'CANADA', 'ESTADOS UNIDOS', 'EUROPA',
                         'U.E. (UNION EUROPEA)', 'Alemania', 'España',
                         'Francia', 'Italia', 'Países Bajos', 'Reino Unido',
                         'RUSIA', 'RESTO DEL MUNDO', 'China (Continental)'],
        "new_colnames": ["Total importaciones",
                         "América: total",
                         "América: ALADI",
                         "América: Argentina",
                         "América: Brasil",
                         "América: Paraguay",
                         "América: MERCOSUR 4 países",
                         "América: Venezuela",
                         "América: MERCOSUR 5 países",
                         "América: Chile",
                         "América: México",
                         "América: Canadá",
                         "América: Estados Unidos",
                         "Europa: total",
                         "Europa: Unión Europea - total",
                         "Europa: UE - Alemania",
                         "Europa: UE - España",
                         "Europa: UE - Francia",
                         "Europa: UE - Italia",
                         "Europa: UE - Países Bajos",
                         "Europa: UE - Reino Unido",
                         "Europa: Rusia",
                         "Resto del mundo: total",
                         "Resto del mundo: China"]}
}

urls = {"call":
        {"dl": {
            "main": "https://web.bevsa.com.uy/Mercado/MercadoDinero/CallHistoricoDiario.aspx"},
            "source": {"direct": [],
                       "indirect": [
                "https://web.bevsa.com.uy/Mercado/MercadoDinero/CallHistoricoDiario.aspx"],
                "provider": ["BEVSA"]}},
        "bonds":
            {"dl": {
                "usd": "https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/Indices/IndiceITBGL.aspx",
                "ui": "https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/Indices/IndiceINDUI.aspx",
                "uyu": "https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/Indices/IndiceITLUP.aspx"},
                "source": {"direct": [],
                           "indirect": [
                               "https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/Indices/IndiceITBGL.aspx",
                               "https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/Indices/IndiceINDUI.aspx",
                               "https://web.bevsa.com.uy/CurvasVectorPrecios/CurvasIndices/Indices/IndiceITLUP.aspx"],
                           "provider": ["BEVSA"]}},
        "deposits":
            {"dl": {
                "main": "https://www.bcu.gub.uy/Servicios-Financieros-SSF/Series%20IF/Depositos.xls"},
                "source": {"direct": ["https://www.bcu.gub.uy/Servicios-Financieros-SSF/Series%20IF/Depositos.xls"],
                           "indirect": [
                               "https://www.bcu.gub.uy/Servicios-Financieros-SSF/Paginas/Series-estadisticas-Depositos.aspx"],
                           "provider": ["BCU"]}},
        "credit":
            {"dl": {
                "main": "https://www.bcu.gub.uy/Servicios-Financieros-SSF/Series%20IF/Creditos.xls"},
                "source": {"direct": ["https://www.bcu.gub.uy/Servicios-Financieros-SSF/Series%20IF/Creditos.xls"],
                           "indirect": [
                               "https://www.bcu.gub.uy/Servicios-Financieros-SSF/Paginas/Series-Estadisticas-Creditos.aspx"],
                           "provider": ["BCU"]}},
        "interest_rates":
            {"dl": {
                "main": "https://www.bcu.gub.uy/Servicios-Financieros-SSF/Series%20IF/tasas.xls"},
                "source": {"direct": ["https://www.bcu.gub.uy/Servicios-Financieros-SSF/Series%20IF/tasas.xls"],
                           "indirect": [
                               "https://www.bcu.gub.uy/Servicios-Financieros-SSF/Paginas/Series-Estadisticas-Tasas.aspx"],
                           "provider": ["BCU"]}},
        "cpi":
            {"dl": {
                "main": "http://ine.gub.uy/c/document_library/get_file?uuid=2e92084a-94ec-4fec-b5ca-42b40d5d2826&groupId=10181"},
             "source": {"direct": [
                 "http://ine.gub.uy/c/document_library/get_file?uuid=2e92084a-94ec-4fec-b5ca-42b40d5d2826&groupId=10181"],
                "indirect": [
                 "http://www.ine.gub.uy/web/guest/ipc-indice-de-precios-del-consumo"],
                "provider": ["INE"]}},
        "nxr_monthly":
            {"dl": {
                "main": "http://ine.gub.uy/c/document_library/get_file?uuid=3fbf4ffd-a829-420c-aca9-9f01ecd7919a&groupId=10181"},
             "source": {"direct": [
                 "http://ine.gub.uy/c/document_library/get_file?uuid=3fbf4ffd-a829-420c-aca9-9f01ecd7919a&groupId=10181"],
                "indirect": [
                 "http://www.ine.gub.uy/web/guest/cotizacion-de-monedas2"],
                "provider": ["INE"]}},
        "nxr_daily":
            {"dl": {
                "main": "https://www.bcu.gub.uy/_layouts/BCU.Cotizaciones/handler/FileHandler.ashx?op=downloadcotizacionesexcel&KeyValuePairs={%22KeyValuePairs%22:{%22Monedas%22:[{%22Val%22:%222224%22,%22Text%22:%22DLS.%20USA%20CABLE%22}],"},
             "source": {"direct": [],
                        "indirect": [
                            "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Cotizaciones.aspx"],
                        "provider": ["BCU"]}},
        "commodity_index":
            {"dl": {
                "beef": "https://www.inac.uy/innovaportal/v/9799/10/innova.front/serie-semanal-ingreso-medio-de-exportacion---bovino-ovino-y-otros-productos",
                "pulp": f"https://www.insee.fr/en/statistiques/serie/telecharger/010600339?ordre=antechronologique&"
                        f"transposition=donneescolonne&periodeDebut=1&anneeDebut=1990&periodeFin=11&anneeFin="
                        f"{dt.datetime.now().year}",
                "soybean": "https://www.quandl.com/api/v3/datasets/CHRIS/CME_S1.csv?api_key=3TPxACcrxy9WsE871Lqe",
                "wheat": "https://www.quandl.com/api/v3/datasets/CHRIS/CME_W1.csv?api_key=3TPxACcrxy9WsE871Lqe",
                "milk1": "https://www.inale.org/estadisticas/",
                "milk2": "https://ec.europa.eu/info/sites/info/files/food-farming-fisheries/farming/documents/eu-milk-historical-price-series_en.xls",
                "imf": "https://www.imf.org/~/media/Files/Research/CommodityPrices/Monthly/ExternalData.ashx"},
             "source": {"direct": [
                 "https://www.inac.uy/innovaportal/v/9799/10/innova.front/serie-semanal-ingreso-medio-de-exportacion---bovino-ovino-y-otros-productos",
                 f"https://www.insee.fr/en/statistiques/serie/telecharger/010600339?ordre=antechronologique&"
                 f"transposition=donneescolonne&periodeDebut=1&anneeDebut=1990&periodeFin=11&anneeFin="
                 f"{dt.datetime.now().year}",
                 "https://www.quandl.com/api/v3/datasets/CHRIS/CME_S1.csv?api_key=3TPxACcrxy9WsE871Lqe",
                 "https://www.quandl.com/api/v3/datasets/CHRIS/CME_W1.csv?api_key=3TPxACcrxy9WsE871Lqe",
                 "https://ec.europa.eu/info/sites/info/files/food-farming-fisheries/farming/documents/eu-milk-historical-price-series_en.xls",
                 "https://www.imf.org/~/media/Files/Research/CommodityPrices/Monthly/ExternalData.ashx"],
                "indirect": [
                 "https://www.inac.uy/innovaportal/v/5541/10/innova.front/precios",
                 "https://www.insee.fr/fr/statistiques/serie/010600339",
                 "https://www.quandl.com/data/CHRIS/CME_S1-Soybean-Futures-Continuous-Contract-1-S1-Front-Month",
                 "https://www.quandl.com/data/CHRIS/CME_W1-Wheat-Futures-Continuous-Contract-1-W1-Front-Month",
                 "https://www.inale.org/estadisticas/",
                 "https://ec.europa.eu/info/food-farming-fisheries/farming/facts-and-figures/markets/overviews/market-observatories/milk",
                 "https://www.imf.org/en/Research/commodity-prices",
                 "https://comtrade.un.org/"],
                "provider": [
                 "Estimaciones de econuy en base a INAC, INSEE, Quandl, INALE, Comisión Europea, FMI y Naciones Unidas"]}},
        "balance": {"dl": {
            "main": "https://www.gub.uy/ministerio-economia-finanzas/datos-y-estadisticas/datos/informacion-resultados-del-sector-publico"},
            "source": {"direct": [],
                       "indirect": [
                "https://www.gub.uy/ministerio-economia-finanzas/datos-y-estadisticas/datos/informacion-resultados-del-sector-publico"],
            "provider": ["MEF"]}},
        "taxes": {"dl": {
            "main": "https://www.dgi.gub.uy/wdgi/afiledownload?2,4,865,O,S,0,19353%3BS%3B100%3B108,",
            "report": "https://www.dgi.gub.uy/wdgi/page?2,principal,dgi--datos-y-series-estadisticas--informes-mensuales-de-la-recaudacion-"},
            "source": {"direct": ["https://www.dgi.gub.uy/wdgi/afiledownload?2,4,865,O,S,0,19353%3BS%3B100%3B108,"],
                       "indirect": [
                           "https://www.dgi.gub.uy/wdgi/page?2,principal,dgi--datos-y-series-estadisticas--serie-de-datos--recaudacion-anual-y-mensual-por-impuesto,O,es,0,",
                           f"https://www.dgi.gub.uy/wdgi/page?2,principal,dgi--datos-y-series-estadisticas--informes-mensuales-de-la-recaudacion-{dt.datetime.now().year},O,es,0,"],
                       "provider": ["DGI"]}},
        "public_debt": {"dl": {
            "main": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Endeudamiento%20Pblico/resdspg.xls"},
            "source": {"direct": [
                "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Endeudamiento%20Pblico/resdspg.xls"],
            "indirect": [
                "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Default.aspx"],
            "provider": ["BCU"]}},
        "diesel": {"dl": {
            "main": "https://www.gub.uy/ministerio-industria-energia-mineria/datos-y-estadisticas/datos/series-estadisticas-petroleo-derivados"},
            "source": {"direct": [],
                       "indirect": [
                "https://www.gub.uy/ministerio-industria-energia-mineria/datos-y-estadisticas/datos/series-estadisticas-petroleo-derivados"],
                "provider": ["MIEM"]}},
        "gasoline": {"dl": {
            "main": "https://www.gub.uy/ministerio-industria-energia-mineria/datos-y-estadisticas/datos/series-estadisticas-petroleo-derivados"},
            "source": {"direct": [],
                       "indirect": [
                           "https://www.gub.uy/ministerio-industria-energia-mineria/datos-y-estadisticas/datos/series-estadisticas-petroleo-derivados"],
                       "provider": ["MIEM"]}},
        "electricity": {"dl": {
            "main": "https://www.gub.uy/ministerio-industria-energia-mineria/datos-y-estadisticas/datos/series-estadisticas-energia-electrica"},
            "source": {"direct": [],
                       "indirect": [
                           "https://www.gub.uy/ministerio-industria-energia-mineria/datos-y-estadisticas/datos/series-estadisticas-energia-electrica"],
                       "provider": ["MIEM"]}},
        "labor": {"dl": {
            "main": "http://ine.gub.uy/c/document_library/get_file?uuid=50ae926c-1ddc-4409-afc6-1fecf641e3d0&groupId=10181",
            "missing": "https://docs.google.com/spreadsheets/d/1amqU3fUSok0kDB_LYvCZlBtVpkZeTK5vW5O8bShlOtw/export?format=xlsx&authuser=0"},
            "source": {"direct": [
                "http://ine.gub.uy/c/document_library/get_file?uuid=50ae926c-1ddc-4409-afc6-1fecf641e3d0&groupId=10181"],
            "indirect": [
                "http://www.ine.gub.uy/web/guest/actividad-empleo-y-desempleo"],
            "provider": ["INE"]}},
        "wages": {"dl": {
            "historical": "http://www.ine.gub.uy/c/document_library/get_file?uuid=a76433b7-5fba-40fc-9958-dd913338e989&groupId=10181",
            "current": "http://www.ine.gub.uy/c/document_library/get_file?uuid=97f07fd8-9410-476e-bf81-e6b1c11467ef&groupId=10181"},
            "source": {"direct": [
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=a76433b7-5fba-40fc-9958-dd913338e989&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=97f07fd8-9410-476e-bf81-e6b1c11467ef&groupId=10181"],
            "indirect": [
                "http://www.ine.gub.uy/web/guest/ims-indice-medio-de-salarios"],
            "provider": ["INE"]}},
        "hours": {"dl": {
            "main": "http://www.ine.gub.uy/c/document_library/get_file?uuid=167e0db0-95ca-45d2-8e81-3b8c5bb8f9ee&groupId=10181",
            "historical": "http://www.ine.gub.uy/c/document_library/get_file?uuid=73ac6ede-8452-48b8-ad32-993d3b047091&groupId=10181",
            "missing": "https://docs.google.com/spreadsheets/d/1amqU3fUSok0kDB_LYvCZlBtVpkZeTK5vW5O8bShlOtw/export?format=xlsx&authuser=0"},
            "source": {"direct": [
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=73ac6ede-8452-48b8-ad32-993d3b047091&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=167e0db0-95ca-45d2-8e81-3b8c5bb8f9ee&groupId=10181"],
                "indirect": [
                    "http://www.ine.gub.uy/web/guest/actividad-empleo-y-desempleo"],
                "provider": ["INE"]}},
        "household_income": {"dl": {
            "main": "http://www.ine.gub.uy/c/document_library/get_file?uuid=40bd0267-3922-478d-8bc0-252f508a72fe&groupId=10181",
            "missing": "https://docs.google.com/spreadsheets/d/1amqU3fUSok0kDB_LYvCZlBtVpkZeTK5vW5O8bShlOtw/export?format=xlsx&authuser=0"},
            "source": {"direct": [
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=40bd0267-3922-478d-8bc0-252f508a72fe&groupId=10181"],
                "indirect": [
                    "http://www.ine.gub.uy/web/guest/gastos-e-ingresos-de-las-personas-y-los-hogares"],
                "provider": ["INE"]}},
        "capita_income": {"dl": {
            "main": "http://www.ine.gub.uy/c/document_library/get_file?uuid=ca57dafa-8091-4c2f-8df8-7b8445859b93&groupId=10181",
            "missing": "https://docs.google.com/spreadsheets/d/1amqU3fUSok0kDB_LYvCZlBtVpkZeTK5vW5O8bShlOtw/export?format=xlsx&authuser=0"},
            "source": {"direct": [
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=ca57dafa-8091-4c2f-8df8-7b8445859b93&groupId=10181"],
                "indirect": [
                    "http://www.ine.gub.uy/web/guest/gastos-e-ingresos-de-las-personas-y-los-hogares"],
                "provider": ["INE"]}},
        "naccounts_ind_con_nsa": {
            "dl": {"main": na_metadata["ind_con_nsa"]["url"]},
            "source": {"direct": [na_metadata["ind_con_nsa"]["url"]],
                       "indirect": [
                           "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/presentacion05t.htm"],
                       "provider": ["BCU"]}},
        "naccounts_ind_cur_nsa": {
            "dl": {"main": na_metadata["ind_cur_nsa"]["url"]},
            "source": {"direct": [na_metadata["ind_cur_nsa"]["url"]],
                       "indirect": [
                           "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/presentacion05t.htm"],
                       "provider": ["BCU"]}},
        "naccounts_gas_con_nsa": {
            "dl": {"main": na_metadata["gas_con_nsa"]["url"]},
            "source": {"direct": [na_metadata["gas_con_nsa"]["url"]],
                       "indirect": [
                           "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/presentacion05t.htm"],
                       "provider": ["BCU"]}},
        "naccounts_ind_con_idx_nsa": {
            "dl": {"main": na_metadata["ind_con_idx_nsa"]["url"]},
            "source": {"direct": [na_metadata["ind_con_idx_nsa"]["url"]],
                       "indirect": [
                           "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/presentacion05t.htm"],
                       "provider": ["BCU"]}},
        "naccounts_ind_con_idx_sa": {
            "dl": {"main": na_metadata["ind_con_idx_sa"]["url"]},
            "source": {"direct": [na_metadata["ind_con_idx_sa"]["url"]],
                       "indirect": [
                           "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/presentacion05t.htm"],
                       "provider": ["BCU"]}},
        "naccounts_gdp_cur_nsa": {
            "dl": {"main": na_metadata["gdp_cur_nsa"]["url"]},
            "source": {"direct": [na_metadata["gdp_cur_nsa"]["url"]],
                       "indirect": [
                           "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Cuentas%20Nacionales/presentacion05t.htm"],
                       "provider": ["BCU"]}},
        "reserves": {"dl": {
            "main": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/MonedayCredito/Activos-de-Reserva/reservas.xls"},
            "source": {"direct": [
                "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/MonedayCredito/Activos-de-Reserva/reservas.xls"],
            "indirect": [
                "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Default.aspx"],
            "provider": ["BCU"]}},
        "industrial_production": {"dl": {
            "main": "http://www.ine.gub.uy/c/document_library/get_file?uuid=8e08c0dc-acc2-44f7-b302-daa32e0b978b&groupId=10181"},
            "source": {"direct": [
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=8e08c0dc-acc2-44f7-b302-daa32e0b978b&groupId=10181"],
                "indirect": [
                    "http://www.ine.gub.uy/web/guest/industria-manufacturera"],
                "provider": ["INE"]}},
        "cattle": {"dl": {
            "main": "https://www.inac.uy/innovaportal/v/11998/10/innova.front/serie-semanal-faena---bovinos-y-ovinos"},
            "source": {"direct": [
                "https://www.inac.uy/innovaportal/v/11998/10/innova.front/serie-semanal-faena---bovinos-y-ovinos"],
                "indirect": [
                    "https://www.inac.uy/innovaportal/v/5539/10/innova.front/faena"],
                "provider": ["INAC"]}},
        "milk": {"dl": {
            "main": "https://www.inale.org/estadisticas/remision-a-planta/"},
            "source": {"direct": [],
                       "indirect": [
                "https://www.inale.org/estadisticas/remision-a-planta/"],
                "provider": ["INALE"]}},
        "cement": {"dl": {
            "main": "http://www.ciu.com.uy/innovaportal/file/83062/1/cemento-web.xlsx"},
            "source": {"direct": ["http://www.ciu.com.uy/innovaportal/file/83062/1/cemento-web.xlsx"],
                       "indirect": [
                           "http://www.ciu.com.uy/innovaportal/v/83062/9/innova.front/series-de-ventas-mensuales-por-destino.html"],
                       "provider": ["AFCPU y CIU"]}},
        "consumer_confidence": {"dl": {
            "main": "https://ucu.edu.uy/sites/default/files/facultad/fce/i_competitividad/serie_icc_-_agosto_20.xlsx"},
            "source": {"direct": ["https://ucu.edu.uy/sites/default/files/facultad/fce/i_competitividad/serie_icc_-_agosto_20.xlsx"],
                       "indirect": [
                           "https://ucu.edu.uy/es/icc"],
                       "provider": ["UCU"]}},
        "sovereign_risk": {"dl": {
            "historical": "https://www4.rafap.com.uy/internet/images/indicadores/UBI_Historico.xls",
            "current": "https://www4.rafap.com.uy/internet/servlet/hextubicd"},
            "source": {"direct": [],
                       "indirect": [
                           "https://www.rafap.com.uy/mvdcms/Institucional/UBI-uc89"],
                       "provider": ["República AFAP"]}},
        "reserves_changes": {"dl": {
            "main": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Informe%20Diario%20Pasivos%20Monetarios/infd_",
            "missing": "https://docs.google.com/spreadsheets/d/1tXwv8SaigbBrfBSSCVGBjSs88f3dgTq4nIANPn7vjYI/export?format=xlsx&authuser=0"},
            "source": {"direct": [],
                       "indirect": [
                "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Informe-Diario-Pasivos-Monetarios.aspx"],
            "provider": ["BCU"]}},
        "rxr_official": {"dl": {
            "main": "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Cambio-Real-Efectivo.aspx"},
            "source": {"direct": [],
                       "indirect": [
                "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Cambio-Real-Efectivo.aspx"],
            "provider": ["BCU"]}},
        "rxr_custom": {"dl": {
            "ar_cpi": "http://www.bcra.gov.ar/PublicacionesEstadisticas/Principales_variables_datos.asp",
            "ar_cpi_payload": f"fecha_desde=1970-01-01&fecha_hasta={dt.datetime.now().strftime('%Y-%m-%d')}&B1=Enviar&primeravez=1&fecha_desde=19600101&fecha_hasta={dt.datetime.now().strftime('%Y%m%d')}&serie=7931&serie1=0&serie2=0&serie3=0&serie4=0&detalle=Inflaci%F3n+mensual%A0%28variaci%F3n+en+%29",
            "ar_black": f"https://mercados.ambito.com/dolar/informal/historico-general/11-01-2002/{dt.datetime.now().strftime('%d-%m-%Y')}",
            "inf_black": "http://www.inflacionverdadera.com/Argentina_inflation.xls"},
            "source": {"direct": [],
                       "indirect": [
                "https://data.imf.org/?sk=4c514d48-b6ba-49ed-8ab9-52b0c1a0179b",
                "http://www.ine.gub.uy/web/guest/ipc-indice-de-precios-del-consumo",
                "http://www.ine.gub.uy/web/guest/cotizacion-de-monedas2",
                "https://www.ambito.com/contenidos/dolar-informal.html",
                "http://www.bcra.gov.ar/PublicacionesEstadisticas/Principales_variables_datos.asp?serie=7931&detalle=Inflaci%F3n%20mensual%A0(variaci%F3n%20en%20%)",
                "http://www.inflacionverdadera.com/argentina/"],
            "provider": [
                "Estimaciones de econuy en base a BCU, INE, BCRA, FMI, Ámbito e Inflación Verdadera"]}},
        "trade_x_prod_val": {"dl": {"main": trade_metadata["x_prod_val"]["url"]},
                          "source": {
                              "direct": [trade_metadata["x_prod_val"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_x_prod_vol": {"dl": {"main": trade_metadata["x_prod_vol"]["url"]},
                          "source": {
                              "direct": [trade_metadata["x_prod_vol"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_x_prod_pri": {"dl": {"main": trade_metadata["x_prod_pri"]["url"]},
                          "source": {
                              "direct": [trade_metadata["x_prod_pri"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_x_dest_val": {"dl": {"main": trade_metadata["x_dest_val"]["url"]},
                          "source": {
                              "direct": [trade_metadata["x_dest_val"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_x_dest_vol": {"dl": {"main": trade_metadata["x_dest_vol"]["url"]},
                          "source": {
                              "direct": [trade_metadata["x_dest_vol"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_x_dest_pri": {"dl": {"main": trade_metadata["x_dest_pri"]["url"]},
                          "source": {
                              "direct": [trade_metadata["x_dest_pri"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_m_sect_val": {"dl": {"main": trade_metadata["m_sect_val"]["url"]},
                          "source": {
                              "direct": [trade_metadata["m_sect_val"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_m_sect_vol": {"dl": {"main": trade_metadata["m_sect_vol"]["url"]},
                          "source": {
                              "direct": [trade_metadata["m_sect_vol"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_m_sect_pri": {"dl": {"main": trade_metadata["m_sect_pri"]["url"]},
                          "source": {
                              "direct": [trade_metadata["m_sect_pri"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_m_orig_val": {"dl": {"main": trade_metadata["m_orig_val"]["url"]},
                          "source": {
                              "direct": [trade_metadata["m_orig_val"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_m_orig_vol": {"dl": {"main": trade_metadata["m_orig_vol"]["url"]},
                          "source": {
                              "direct": [trade_metadata["m_orig_vol"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "trade_m_orig_pri": {"dl": {"main": trade_metadata["m_orig_pri"]["url"]},
                          "source": {
                              "direct": [trade_metadata["m_orig_pri"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": ["BCU"]}},
        "cpi_measures":
            {"dl": {
                "2010": "http://www.ine.gub.uy/c/document_library/get_file?uuid=668d4f77-74d8-46ba-8360-77bd867996df&groupId=10181",
                "1997": "http://www.ine.gub.uy/c/document_library/get_file?uuid=1cd81500-420a-44d0-ae4d-0add9d913107&groupId=10181",
                "1997_weights": "https://docs.google.com/spreadsheets/d/1gSQdp6b97udmki0DZBndhLajLv6uGDX7kYb66BUswj8/export#gid=0"},
             "source": {"direct": [
                 "http://www.ine.gub.uy/c/document_library/get_file?uuid=668d4f77-74d8-46ba-8360-77bd867996df&groupId=10181",
                 "http://www.ine.gub.uy/c/document_library/get_file?uuid=1cd81500-420a-44d0-ae4d-0add9d913107&groupId=10181",
                 "http://www.ine.gub.uy/c/document_library/get_file?uuid=5f2e75d2-5df6-48da-978d-e7930d47c037&groupId=10181"],
                "indirect": [
                 "http://www.ine.gub.uy/web/guest/ipc-indice-de-precios-del-consumo"],
                "provider": ["Estimaciones de econuy en base a INE"]}},
        "balance_fss": {"dl": {},
                       "source": {"direct": [],
                                  "indirect": [
                                      "https://www.gub.uy/ministerio-economia-finanzas/datos-y-estadisticas/datos"],
                                  "provider": [
                                      "Estimaciones de econuy en base a MEF"]}},
        "rates_people": {"dl": {
            "act_5000": "http://www.ine.gub.uy/c/document_library/get_file?uuid=b51d8104-d367-4d0f-828b-189eefc29de2&groupId=10181",
            "emp_5000": "http://www.ine.gub.uy/c/document_library/get_file?uuid=0902797e-e588-4da3-91cd-153c4d1d28a5&groupId=10181",
            "des_5000": "http://www.ine.gub.uy/c/document_library/get_file?uuid=d1434567-3da4-4321-9341-4fb3d8b6a09c&groupId=10181",
            "population": "http://www.ine.gub.uy/c/document_library/get_file?uuid=2a5c1e6e-b02f-4a63-963f-925edea7c17e&groupId=10181"},
            "source": {"direct": [
                "http://ine.gub.uy/c/document_library/get_file?uuid=50ae926c-1ddc-4409-afc6-1fecf641e3d0&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=b51d8104-d367-4d0f-828b-189eefc29de2&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=0902797e-e588-4da3-91cd-153c4d1d28a5&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=d1434567-3da4-4321-9341-4fb3d8b6a09c&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=2a5c1e6e-b02f-4a63-963f-925edea7c17e&groupId=10181"],
            "indirect": [
                "http://www.ine.gub.uy/web/guest/actividad-empleo-y-desempleo",
                "http://www.ine.gub.uy/estimaciones-y-proyecciones"],
            "provider": [
                "Estimaciones de econuy en base a INE"]}},
        "real_wages": {"dl": {},
                      "source": {"direct": [
                          "http://www.ine.gub.uy/c/document_library/get_file?uuid=a76433b7-5fba-40fc-9958-dd913338e989&groupId=10181",
                          "http://www.ine.gub.uy/c/document_library/get_file?uuid=97f07fd8-9410-476e-bf81-e6b1c11467ef&groupId=10181",
                          "http://www.ine.gub.uy/c/document_library/get_file?uuid=2e92084a-94ec-4fec-b5ca-42b40d5d2826&groupId=10181"],
            "indirect": [
                          "http://www.ine.gub.uy/web/guest/ims-indice-medio-de-salarios",
                          "http://www.ine.gub.uy/web/guest/ipc-indice-de-precios-del-consumo"],
            "provider": [
                          "Estimaciones de econuy en base a INE"]}},
        "net_trade": {"dl": {},
                   "source": {"direct": [trade_metadata["x_dest_val"]["url"],
                                         trade_metadata["m_orig_val"]["url"]],
                              "indirect": [
                                  "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                              "provider": [
                                  "Estimaciones de econuy en base a BCU"]}},
        "terms_of_trade": {"dl": {},
                    "source": {"direct": [trade_metadata["x_dest_pri"]["url"],
                                          trade_metadata["m_orig_pri"]["url"]],
                               "indirect": [
                                   "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Intercambio-Comercial-.aspx"],
                               "provider": [
                                   "Estimaciones de econuy en base a BCU"]}},
        "net_public_debt": {"dl": {},
                        "source": {"direct": [
                            "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Endeudamiento%20Pblico/resdspg.xls",
                            "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/MonedayCredito/Activos-de-Reserva/reservas.xls"],
            "indirect": [
                            "https://www.bcu.gub.uy/Estadisticas-e-Indicadores/Paginas/Default.aspx"],
            "provider": [
                            "Estimaciones de econuy en base a BCU"]}},
        "core_industrial": {"dl": {
            "main": "http://www.ine.gub.uy/c/document_library/get_file?uuid=8e08c0dc-acc2-44f7-b302-daa32e0b978b&groupId=10181",
            "weights": "http://www.ine.gub.uy/c/document_library/get_file?uuid=864b4bc2-626d-49ab-82ef-1bcf08360da1&groupId=10181"},
            "source": {"direct": [
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=8e08c0dc-acc2-44f7-b302-daa32e0b978b&groupId=10181",
                "http://www.ine.gub.uy/c/document_library/get_file?uuid=1768051c-5b85-42ea-8340-b8b44ee2948c&groupId=10181"],
            "indirect": [
                "http://www.ine.gub.uy/web/guest/industria-manufacturera"],
            "provider": [
                "Estimaciones de econuy en base a INE"]}}}

fiscal_sheets = {
    "Sector Público No Monetario":
        {"Name": "nfps",
         "Colnames": ["Ingresos: SPNF",
                      "Ingresos: Gobierno central",
                      "Ingresos: DGI", "Ingresos: IRP",
                      "Ingresos: Comercio ext.",
                      "Ingresos: Otros", "Ingresos: BPS",
                      "Ingresos: Res. primario corriente EEPP",
                      "Egresos: Primarios SPNF",
                      "Egresos: Primarios corrientes GC-BPS",
                      "Egresos: Remuneraciones",
                      "Egresos: No personales",
                      "Egresos: Pasividades",
                      "Egresos: Transferencias",
                      "Egresos: Inversiones",
                      "Resultado: Primario intendencias",
                      "Resultado: Primario BSE",
                      "Resultado: Primario SPNF",
                      "Intereses: Totales", "Intereses: GC-BPS",
                      "Intereses: EEPP",
                      "Intereses: Intendencias",
                      "Intereses: BSE",
                      "Resultado: Global SPNF"]},
    "Sector Público Consolidado":
        {"Name": "gps",
         "Colnames": ["Resultado: Primario SPNF",
                      "Intereses: SPNF", "Resultado: Global SPNF",
                      "Resultado: Primario BCU", "Intereses: BCU",
                      "Resultado: Global BCU",
                      "Resultado: Primario SPC",
                      "Resultado: Global SPC"]},
    "Gobierno Central - BPS":
        {"Name": "gc-bps",
         "Colnames": ["Ingresos: GC-BPS", "Ingresos: GC",
                      "Ingresos: Comercio ext.", "Ingresos: DGI",
                      "Ingresos: DGI bruto", "Ingresos: DGI CDI",
                      "Ingresos: Loterías",
                      "Ingresos: Venta energía",
                      "Ingresos: TGN/otros", "Ingresos: FIMTOP",
                      "Ingresos: Aportes EEPP", "Ingresos: IRP",
                      "Ingresos: Rec. Lib. Disp",
                      "Ingresos: BPS neto", "Ingresos: BPS bruto",
                      "Ingresos: FSS",
                      "Ingresos: BPS CDI", "Ingresos: BPS otros",
                      "Egresos: GC-BPS",
                      "Egresos: Remuneraciones",
                      "Egresos: Remuneraciones adm. central",
                      "Egresos: Remuneraciones org. docentes",
                      "Egresos: Remuneraciones retenc./otros",
                      "Egresos: Remuneraciones BPS",
                      "Egresos: Pasividades",
                      "Egresos: Pasividades Caja Policial",
                      "Egresos: Pasividades Caja Militar",
                      "Egresos: Pasividades BPS",
                      "Egresos: No personales",
                      "Egresos: No personales adm. central",
                      "Egresos: No personales org. docentes",
                      "Egresos: No personales suministros",
                      "Egresos: No personales plan emergencia",
                      "Egresos: No personales BPS",
                      "Egresos: Transferencias",
                      "Egresos: Transferencias GC",
                      "Egresos: Transferencias GC Entes",
                      "Egresos: Transferencias GC deuda",
                      "Egresos: Transferencias GC otros org.",
                      "Egresos: Transferencias GC rentas afectadas",
                      "Egresos: Transferencias BPS",
                      "Egresos: Transferencias BPS enfermedad",
                      "Egresos: Transferencias BPS AFAM y otras prestaciones",
                      "Egresos: Transferencias BPS desempleo",
                      "Egresos: Transferencias BPS 2",
                      "Egresos: Transferencias BPS -IRP/IRPF",
                      "Egresos: Transferencias BPS AFAP",
                      "Egresos: Transferencias BPS otros",
                      "Egresos: Transferencias otros",
                      "Egresos: Inversión",
                      "Egresos: Inversión MTOP",
                      "Egresos: Inversión MVOTMA",
                      "Egresos: Inversión Presidencia",
                      "Egresos: Inversión org. docentes",
                      "Egresos: Inversión resto",
                      "Intereses: Total", "Intereses: GC",
                      "Intereses: BPS-FSS",
                      "Resultado: Global GC-BPS"]},
    "Empresas Públicas Consolidado":
        {"Name": "pe",
         "Colnames": ["Ingresos",
                      "Ingresos: Venta bienes y servicios",
                      "Ingresos: Otros",
                      "Ingresos: Transferencias GC", "Egresos",
                      "Egresos: Corrientes",
                      "Egresos: Remuneraciones",
                      "Egresos: Compras bienes y servicios",
                      "Egresos: Intereses", "Egresos: DGI",
                      "Egresos: BPS",
                      "Egresos: No corrientes",
                      "Egresos: Inversiones",
                      "Egresos: Dividendo",
                      "Resultado: Global"]},
    "ANCAP":
        {"Name": "ancap",
         "Colnames": ["Ingresos",
                      "Ingresos: Venta bienes y servicios",
                      "Ingresos: Otros",
                      "Ingresos: Transferencias GC", "Egresos",
                      "Egresos: Corrientes",
                      "Egresos: Remuneraciones",
                      "Egresos: Compras bienes y servicios",
                      "Egresos: Intereses", "Egresos: DGI",
                      "Egresos: BPS",
                      "Egresos: No corrientes",
                      "Egresos: Inversiones",
                      "Egresos: Var. stock petróleo",
                      "Egresos: Otros", "Egresos: Dividendo",
                      "Resultado: Global"]},
    "ANTEL":
        {"Name": "antel",
         "Colnames": ["Ingresos",
                      "Ingresos: Venta bienes y servicios",
                      "Ingresos: Otros",
                      "Ingresos: Transferencias GC", "Egresos",
                      "Egresos: Corrientes",
                      "Egresos: Remuneraciones",
                      "Egresos: Compras bienes y servicios",
                      "Egresos: Intereses", "Egresos: DGI",
                      "Egresos: BPS",
                      "Egresos: No corrientes",
                      "Egresos: Inversiones",
                      "Egresos: Dividendo", "Resultado: Global"]},
    "OSE":
        {"Name": "ose",
         "Colnames": ["Ingresos",
                      "Ingresos: Venta bienes y servicios",
                      "Ingresos: Otros",
                      "Ingresos: Transferencias GC", "Egresos",
                      "Egresos: Corrientes",
                      "Egresos: Remuneraciones",
                      "Egresos: Compras bienes y servicios",
                      "Egresos: Intereses", "Egresos: DGI",
                      "Egresos: BPS",
                      "Egresos: No corrientes",
                      "Egresos: Inversiones",
                      "Egresos: Dividendo",
                      "Resultado: Global"]},
    "UTE":
        {"Name": "ute",
         "Colnames": ["Ingresos",
                      "Ingresos: Venta bienes y servicios",
                      "Ingresos: Otros",
                      "Ingresos: Transferencias GC", "Egresos",
                      "Egresos: Corrientes",
                      "Egresos: Remuneraciones",
                      "Egresos: Compras bienes y servicios",
                      "Egresos: Intereses", "Egresos: DGI",
                      "Egresos: BPS",
                      "Egresos: No corrientes",
                      "Egresos: Inversiones",
                      "Egresos: Dividendo",
                      "Resultado: Global"]}
}

reserves_cols = [
    'Saldo al inicio del período', '1. Compras netas de moneda extranjera',
    '1.1. Compras netas en el mercado',
    '1.2. Integración en dólares de valores del BCU',
    '1.3. Prefinanciación de exportaciones',
    '1.4. Cancelación de contratos forward', '1.5. Gobierno Central',
    '1.5.1. Utilizaciones de préstamos internacionales',
    '1.5.2. Otras compras netas al Gobierno Central',
    '1.6. Otros', '2. Depósitos del Sistema Bancario en el Banco Central',
    '2.1. Banca pública',
    '2.2. Banca privada', '3. Otros Depósitos en el Banco Central',
    '3.1. Depósitos de otras empresas de intermediación fin.',
    '3.2. Depósitos de casas de cambio y otras inst.',
    '3.3. Depósitos de empresas públicas y gob. dptales.',
    '4. Divisas de exportación a liquidar',
    '5. Obligaciones netas en ME con gob. central',
    '5.1. Colocación neta de bonos y letras', '5.1.1. Colocación bruta',
    '5.1.2. Amortizaciones',
    '5.1.3. Intereses y comisiones',
    '5.2. Otras obligaciones netas en ME',
    '5.2.1. Desembolsos de préstamos internacionales',
    '5.2.2. Servicio neto de préstamos internacionales',
    '5.3.3. Utilizaciones de préstamos internacionales',
    '5.4.5. Aporte de entes a cuenta de resultados',
    '5.4.6.  Compras de moneda extranjera',
    '5.4.7. Giros hacia y desde el BROU',
    '5.4.8. Integración en USD de títulos en UI y pesos-neto',
    '5.4.9. Otros', '6. Intereses netos',
    '6.1.Intereses pagados sobre depósitos del sist. fin.',
    '6.2. Intereses cobrados sobre fondos en el exterior',
    '6.3. Otros intereses y comisiones netos',
    '7. Otros', '7.1.  Préstamos y financiamientos EEPP',
    '7.2. Cuentas con organismos internacionales',
    '7.3. Fondos administrados', '7.4. Diferencias de arbitraje',
    '7.5. Diferencias de cotización e intereses devengados',
    '7.6. Depósitos especiales Clearstream Banking',
    '7.7. Solicitudes de giro al exterior en trámite', '7.8. Otros',
    'Variación total del período - 1+2+3+4+5+6+7',
    'Saldo al final del período'
]

fiscal_metadata = {
    "gps": {True: ["Ingresos: SPNF-SPC aj. FSS", "Egresos: Primarios SPNF-SPC",
                   "Egresos: Inversiones SPNF-SPC", "Intereses: SPC aj. FSS",
                   "Egresos: Totales SPC aj. FSS",
                   "Resultado: Primario intendencias",
                   "Resultado: Primario BSE", "Resultado: Primario BCU",
                   "Resultado: Primario SPC aj. FSS",
                   "Resultado: Global SPC aj. FSS"],
            False: ["Ingresos: SPNF-SPC", "Egresos: Primarios SPNF-SPC",
                    "Egresos: Inversiones SPNF-SPC",
                    "Intereses: SPC", "Egresos: Totales SPC",
                    "Resultado: Primario intendencias",
                    "Resultado: Primario BSE", "Resultado: Primario BCU",
                    "Resultado: Primario SPC",
                    "Resultado: Global SPC"]},
    "nfps": {
        True: ["Ingresos: SPNF-SPC aj. FSS", "Egresos: Primarios SPNF-SPC",
               "Egresos: Inversiones SPNF-SPC", "Intereses: SPNF aj. FSS",
               "Egresos: Totales SPNF aj. FSS",
               "Resultado: Primario intendencias",
               "Resultado: Primario BSE", "Resultado: Primario SPNF aj. FSS",
               "Resultado: Global SPNF aj. FSS"],
        False: ["Ingresos: SPNF-SPC", "Egresos: Primarios SPNF-SPC",
                "Egresos: Inversiones SPNF-SPC",
                "Intereses: SPNF", "Egresos: Totales SPNF",
                "Resultado: Primario intendencias",
                "Resultado: Primario BSE", "Resultado: Primario SPNF",
                "Resultado: Global SPNF"]},
    "gc": {True: ["Ingresos: GC-BPS aj. FSS", "Egresos: Primarios GC-BPS",
                  "Egresos: Inversiones GC-BPS",
                  "Intereses: GC-BPS aj. FSS",
                  "Egresos: Totales GC-BPS aj. FSS",
                  "Resultado: Primario GC-BPS aj. FSS",
                  "Resultado: Global GC-BPS aj. FSS"],
           False: ["Ingresos: GC-BPS", "Egresos: Primarios GC-BPS",
                   "Egresos: Inversiones GC-BPS",
                   "Intereses: GC-BPS", "Egresos: Totales GC-BPS",
                   "Resultado: Primario GC-BPS",
                   "Resultado: Global GC-BPS"]}
}

cpi_details = {"2010_base": {
    'Pan y cereales': {"Tradable": True, "Core": True},
    'Carne': {"Tradable": True, "Core": False},
    'Pescado': {"Tradable": True, "Core": True},
    'Leche, queso y huevos': {"Tradable": True, "Core": True},
    'Aceites y grasas': {"Tradable": True, "Core": True},
    'Frutas': {"Tradable": True, "Core": False},
    'Legumbres y Hortalizas': {"Tradable": True, "Core": False},
    'Azúcar, mermelada, miel, chocolate y dulces de azúcar': {"Tradable": True,
                                                              "Core": True},
    'Productos alimenticios n.e.p.': {"Tradable": True, "Core": True},
    'Bebidas no alcohólicas': {"Tradable": True, "Core": True},
    'Bebidas alcohólicas': {"Tradable": True, "Core": True},
    'Tabaco': {"Tradable": True, "Core": False},
    'PRENDAS DE VESTIR Y CALZADO': {"Tradable": True, "Core": True},
    'Alquileres efectivos del alojamiento': {"Tradable": False, "Core": True},
    'Conservación y reparación de la vivienda': {"Tradable": False,
                                                 "Core": True},
    'Suministro de agua y servicios diversos relacionados con la vivienda': {
        "Tradable": False, "Core": False},
    'Electricidad, gas y otros combustibles': {"Tradable": False,
                                               "Core": False},
    'Muebles y accesorios, alfombras y otros materiales para pisos': {
        "Tradable": True, "Core": True},
    'Productos textiles para el hogar': {"Tradable": True, "Core": True},
    'Artefactos para el hogar grandes, eléctricos o no': {"Tradable": True,
                                                          "Core": True},
    'Reparación de artefactos para el hogar': {"Tradable": False,
                                               "Core": True},
    'Artículos de vidrio y cristal, vajilla y utensilios para el hogar': {
        "Tradable": True, "Core": True},
    'Herramientas y equipo para el hogar y el jardín': {"Tradable": True,
                                                        "Core": True},
    'Bienes para el hogar no duraderos': {"Tradable": True, "Core": True},
    'Servicios domésticos y para el hogar': {"Tradable": False, "Core": True},
    'Productos, artefactos y equipo médicos': {"Tradable": True, "Core": True},
    'Servicios para pacientes externos': {"Tradable": False, "Core": False},
    'Servicios de hospital': {"Tradable": False, "Core": False},
    'Servicios médicos mutuales y colectivos': {"Tradable": False,
                                                "Core": False},
    'Adquisición de vehículos': {"Tradable": True, "Core": True},
    'Funcionamiento de equipo de transporte personal': {"Tradable": False,
                                                        "Core": True},
    'Servicios de transporte': {"Tradable": False, "Core": False},
    'Servicios postales': {"Tradable": False, "Core": False},
    'Equipo telefónico y de facsímile': {"Tradable": True, "Core": True},
    'Servicios telefónicos y de facsímile': {"Tradable": False, "Core": False},
    'Equipo audiovisual, fotográfico y de procesamiento de información': {
        "Tradable": True, "Core": True},
    'Otros artículos y equipo para recreación, jardines y animales domésticos': {
        "Tradable": True, "Core": True},
    'Servicios de recreación y culturales': {"Tradable": False, "Core": False},
    'Periódicos, libros y papeles y útiles de oficina': {"Tradable": True,
                                                         "Core": True},
    'Paquetes turísticos': {"Tradable": True, "Core": True},
    'EDUCACIÓN': {"Tradable": False, "Core": True},
    'Servicios de alojamiento': {"Tradable": False, "Core": True},
    'Servicios de suministro de comidas por contrato': {"Tradable": False,
                                                        "Core": True},
    'Cuidado personal': {"Tradable": False, "Core": True},
    'Efectos personales n.e.p.': {"Tradable": False, "Core": True},
    'Seguros': {"Tradable": False, "Core": True},
    'Otros servicios n.e.p.': {"Tradable": False, "Core": True}
},
    "1997_base": {
        '    Panes Y Cereales': {"Tradable": True, "Core": True},
        '    Carnes Y Derivados': {"Tradable": True, "Core": False},
        '    Lacteos Y Huevos': {"Tradable": True, "Core": True},
        '    Aceites Y Grasas': {"Tradable": True, "Core": True},
        '    Frutas': {"Tradable": True, "Core": False},
        '    Verduras, Legumbres Y Tuberculos': {"Tradable": True,
                                                 "Core": False},
        '    Azucar, Cafe, Te, Yerba Y Cacao': {"Tradable": True, "Core": True},
        '    Otros Alimentos': {"Tradable": True, "Core": True},
        '    Bebidas No Alcoholicas': {"Tradable": True, "Core": True},
        '    Bebidas Alcoholicas': {"Tradable": True, "Core": True},
        '  Comidas Semielaboradas, Elaboradas': {"Tradable": True,
                                                 "Core": True},
        'Vestimenta Y Calzado': {"Tradable": True, "Core": True},
        '  Alquileres, Mantenimiento, Gastos Comunes': {"Tradable": False,
                                                        "Core": True},
        '  Combustible, Alumbrado Y Agua Corriente': {"Tradable": False,
                                                      "Core": False},
        '  Muebles, Acc. Fijos Y Reparaciones': {"Tradable": True,
                                                 "Core": True},
        '  Tejidos Para El Hogar Y Otros Accesorios': {"Tradable": True,
                                                       "Core": True},
        '  Artefactos, Electrodomesticos, Cristaleria': {"Tradable": True,
                                                         "Core": True},
        '  Servicios Para El Hogar Exc. Servicio Domestico': {
            "Tradable": False, "Core": True},
        '  Servicio Domestico Y Reparaciones ': {"Tradable": False,
                                                 "Core": True},
        '  Productos Medicinales Y Farmaceuticos': {"Tradable": True,
                                                    "Core": True},
        '  Aparatos Y Equipos Terapeuticos': {"Tradable": True, "Core": True},
        '  Servicios Medicos': {"Tradable": False, "Core": False},
        '  Equipo De Transporte Personal': {"Tradable": True, "Core": True},
        '  Mantenimiento Y Utilizacion De Equipo Tpte.': {"Tradable": False,
                                                          "Core": True},
        '  Servicios De Transporte': {"Tradable": False, "Core": False},
        '  Comunicaciones': {"Tradable": False, "Core": False},
        '  Equipos Accesorios Y Reparaciones': {"Tradable": True,
                                                "Core": True},
        '  Servicios De Esparcimiento': {"Tradable": False, "Core": True},
        '  Libros, Periodicos Y Revistas': {"Tradable": True, "Core": True},
        '  Turismo Y Alojamiento': {"Tradable": True, "Core": True},
        'Enseñanza': {"Tradable": False, "Core": False},
        '  Cuidados Y Efectos Personales': {"Tradable": False, "Core": True},
        '  Tabaco': {"Tradable": True, "Core": False},
        '  Servicios Diversos': {"Tradable": False, "Core": True}
},
    "1997_weights": ['PAN Y CEREALES',
                     'CARNES Y DERIVADOS',
                     'LÁCTEOS Y HUEVOS',
                     'ACEITES Y GRASAS',
                     'FRUTAS',
                     'VERDURAS, LEGUMBRES Y TUBÉRCULOS',
                     'AZÚCAR, CAFÉ, TÉ, YERBA MATE Y CACAO',
                     'OTROS ALIMENTOS',
                     'BEBIDAS NO ALCOHÓLICAS',
                     'BEBIDAS ALCOHÓLICAS',
                     'COMIDAS SEMIELABORADAS, ELABORADAS Y FUERA DEL HOGAR',
                     'VESTIMENTA Y CALZADO',
                     'ALQUILER, MANTENIMIENTO, GASTOS COMUNES E IMPUESTOS',
                     'COMBUSTIBLE, ALUMBRADO Y AGUA CORRIENTE',
                     'MUEBLES, ACCESORIOS FIJOS Y REPARACIONES',
                     'TEJIDOS PARA EL HOGAR Y OTROS ACCESORIOS',
                     'ELECTRODOMÉSTICOS, CRISTALERÍA, VAJILLA Y UTENSILIOS DOMÉSTICOS',
                     'SERVICIOS PARA EL HOGAR (EXCEPTO SERVICIO DOMÉSTICO)',
                     'SERVICIO DOMÉSTICO Y REPARACIONES DEL HOGAR',
                     'PRODUCTOS MEDICINALES Y FARMACÉUTICOS',
                     'APARATOS Y EQUIPOS TERAPÉUTICOS',
                     'SERVICIOS MÉDICOS',
                     'EQUIPO DE TRANSPORTE PERSONAL',
                     'MANTENIMIENTO Y UTILIZACIÓN DE EQUIPO DE TRANSPORTE PERSONAL',
                     'SERVICIOS DE TRANSPORTE',
                     'COMUNICACIONES',
                     'EQUIPOS, ACCESORIOS Y REPARACIONES',
                     'SERVICIO DE ESPARCIMIENTO',
                     'LIBROS, PERIÓDICOS Y REVISTAS',
                     'TURISMO Y ALOJAMIENTO',
                     'ENSEÑANZA',
                     'CUIDADOS Y EFECTOS PERSONALES',
                     'TABACO',
                     'SERVICIOS DIVERSOS']}

taxes_columns = ['IRAE - Rentas de Actividades Económicas',
                 'IMEBA - Enajenación de Bienes Agropecuarios',
                 'IRPF Cat I - Renta de las Personas Físicas',
                 'IRPF Cat II - Rentas de las Personas Físicas',
                 'IRNR - Rentas de No Residentes',
                 'IASS - Asistencia a la Seguridad Social',
                 'ISAFI - SA Financieras de Inversión',
                 'IP Personas Jurídicas - Patrimonio',
                 'IP Explotaciones Agropecuarias - Patrimonio',
                 'IP Sobretasa - IP',
                 'ICOSA - Control de las SA',
                 'IP Personas Físicas - Patrimonio',
                 'ITP - Transferencias Patrimoniales',
                 'ITP Adicional - Transferencias Patrimoniales',
                 'IVA - Valor Agregado',
                 'IVA Mínimo - Pequeña Empresa',
                 'IMESI - Específico Interno',
                 'IMEBA Ad. MEVIR - Enajernación de Bienes Agropecuarios',
                 'IMEBA Ad. INIA - Enajernación de Bienes Agropecuarios',
                 'Impuesto a los Ingresos de las Compañías de Seguros',
                 'FIS - Fondo de Inspección Sanitaria',
                 'IRIC - Rentas de Industria Comercio',
                 'COFIS - Contribución al Financiamiento Seguridad Social',
                 'IMESSA - Específico a los Servicios de Salud',
                 'Impuesto a las Comisiones',
                 'Impuesto a las Ventas Forzadas',
                 'Impuesto a las Tarjetas de Crédito',
                 'ITEL - Telecomunicaciones',
                 'Impuesto a los Ingresos le Los Organizadores de Sorteos',
                 'ICOME - Compra de Moneda Extranjera',
                 'Impuesto a la Compra - Venta de Bienes Remate Público',
                 'Impuesto a las Cesiones de Derechos sobre Deportistas',
                 'IMABA - Activos de las Empresas Bancarias',
                 'ICOSIFI - Control del Sistema Financiero',
                 'IRA - Rentas Agropecuarias',
                 'IMAGRO - Actividades Agropecuaria',
                 'Impuesto de Educación Primaria',
                 'Recaudación Total de la DGI']
