from pandas._libs.interval import Interval as Interval
from pandas._libs.tslibs import  Period as Period, Timestamp as Timestamp, timezones as timezones
from pandas._typing import Ordered as Ordered
from pandas.core.dtypes.base import ExtensionDtype as ExtensionDtype
from pandas.core.dtypes.generic import ABCCategoricalIndex as ABCCategoricalIndex, ABCDateOffset as ABCDateOffset, ABCIndexClass as ABCIndexClass
from pandas.core.dtypes.inference import is_bool as is_bool, is_list_like as is_list_like
from typing import Any, Optional, Tuple, Type, Union

str_type = str

def register_extension_dtype(cls: Type[ExtensionDtype]) -> Type[ExtensionDtype]: ...

class Registry:
    dtypes: Any = ...
    def __init__(self) -> None: ...
    def register(self, dtype: Type[ExtensionDtype]) -> None: ...
    def find(self, dtype: Union[Type[ExtensionDtype], str]) -> Optional[Type[ExtensionDtype]]: ...

registry: Any

class PandasExtensionDtype(ExtensionDtype):
    type: Any
    kind: Any
    subdtype: Any = ...
    str: Optional[str_type] = ...
    num: int = ...
    shape: Tuple[int, ...] = ...
    itemsize: int = ...
    base: Any = ...
    isbuiltin: int = ...
    isnative: int = ...
    def __hash__(self) -> int: ...
    @classmethod
    def reset_cache(cls: Any) -> None: ...

class CategoricalDtypeType(type): ...

class CategoricalDtype(PandasExtensionDtype, ExtensionDtype):
    name: str = ...
    type: Type[CategoricalDtypeType] = ...
    kind: str_type = ...
    str: str = ...
    base: Any = ...
    def __init__(self, categories: Any = ..., ordered: Ordered=...) -> None: ...
    @classmethod
    def construct_from_string(cls: Any, string: str_type) -> CategoricalDtype: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    @classmethod
    def construct_array_type(cls) -> Any: ...
    @staticmethod
    def validate_ordered(ordered: Ordered) -> None: ...
    @staticmethod
    def validate_categories(categories: Any, fastpath: bool=...) -> Any: ...
    def update_dtype(self, dtype: Union[str_type, CategoricalDtype]) -> CategoricalDtype: ...
    @property
    def categories(self) -> Any: ...
    @property
    def ordered(self) -> Ordered: ...

class DatetimeTZDtype(PandasExtensionDtype):
    type: Type[Timestamp] = ...
    kind: str_type = ...
    str: str = ...
    num: int = ...
    base: Any = ...
    na_value: Any = ...
    def __init__(self, unit: str_type = ..., tz: Optional[Any] = ...) -> None: ...
    @property
    def unit(self) -> Any: ...
    @property
    def tz(self) -> Any: ...
    @classmethod
    def construct_array_type(cls) -> Any: ...
    @classmethod
    def construct_from_string(cls: Any, string: str_type) -> Any: ...
    @property
    def name(self) -> str_type: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...

class PeriodDtype(PandasExtensionDtype):
    type: Type[Period] = ...
    kind: str_type = ...
    str: str = ...
    base: Any = ...
    num: int = ...
    def __new__(cls, freq: Optional[Any] = ...) -> Any: ...
    @property
    def freq(self) -> Any: ...
    @classmethod
    def construct_from_string(cls, string: Any) -> Any: ...
    @property
    def name(self) -> str_type: ...
    @property
    def na_value(self) -> Any: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    @classmethod
    def is_dtype(cls: Any, dtype: Any) -> bool: ...
    @classmethod
    def construct_array_type(cls) -> Any: ...
    def __from_arrow__(self, array: Any) -> Any: ...

class IntervalDtype(PandasExtensionDtype):
    name: str = ...
    kind: str_type = ...
    str: str = ...
    base: Any = ...
    num: int = ...
    def __new__(cls, subtype: Optional[Any] = ...) -> Any: ...
    @property
    def subtype(self) -> Any: ...
    @classmethod
    def construct_array_type(cls) -> Any: ...
    @classmethod
    def construct_from_string(cls, string: Any) -> Any: ...
    @property
    def type(self) -> Any: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    @classmethod
    def is_dtype(cls: Any, dtype: Any) -> bool: ...
    def __from_arrow__(self, array: Any) -> Any: ...
