# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'AccountIamBindingCondition',
    'AccountIamMemberCondition',
    'BudgetAllUpdatesRule',
    'BudgetAmount',
    'BudgetAmountSpecifiedAmount',
    'BudgetBudgetFilter',
    'BudgetThresholdRule',
]

@pulumi.output_type
class AccountIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AccountIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BudgetAllUpdatesRule(dict):
    def __init__(__self__, *,
                 monitoring_notification_channels: Optional[List[str]] = None,
                 pubsub_topic: Optional[str] = None,
                 schema_version: Optional[str] = None):
        """
        :param List[str] monitoring_notification_channels: The full resource name of a monitoring notification
               channel in the form
               projects/{project_id}/notificationChannels/{channel_id}.
               A maximum of 5 channels are allowed.
        :param str pubsub_topic: The name of the Cloud Pub/Sub topic where budget related
               messages will be published, in the form
               projects/{project_id}/topics/{topic_id}. Updates are sent
               at regular intervals to the topic.
        :param str schema_version: The schema version of the notification. Only "1.0" is
               accepted. It represents the JSON schema as defined in
               https://cloud.google.com/billing/docs/how-to/budgets#notification_format.
        """
        if monitoring_notification_channels is not None:
            pulumi.set(__self__, "monitoring_notification_channels", monitoring_notification_channels)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if schema_version is not None:
            pulumi.set(__self__, "schema_version", schema_version)

    @property
    @pulumi.getter(name="monitoringNotificationChannels")
    def monitoring_notification_channels(self) -> Optional[List[str]]:
        """
        The full resource name of a monitoring notification
        channel in the form
        projects/{project_id}/notificationChannels/{channel_id}.
        A maximum of 5 channels are allowed.
        """
        return pulumi.get(self, "monitoring_notification_channels")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[str]:
        """
        The name of the Cloud Pub/Sub topic where budget related
        messages will be published, in the form
        projects/{project_id}/topics/{topic_id}. Updates are sent
        at regular intervals to the topic.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="schemaVersion")
    def schema_version(self) -> Optional[str]:
        """
        The schema version of the notification. Only "1.0" is
        accepted. It represents the JSON schema as defined in
        https://cloud.google.com/billing/docs/how-to/budgets#notification_format.
        """
        return pulumi.get(self, "schema_version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BudgetAmount(dict):
    def __init__(__self__, *,
                 specified_amount: 'outputs.BudgetAmountSpecifiedAmount'):
        """
        :param 'BudgetAmountSpecifiedAmountArgs' specified_amount: A specified amount to use as the budget. currencyCode is
               optional. If specified, it must match the currency of the
               billing account. The currencyCode is provided on output.
               Structure is documented below.
        """
        pulumi.set(__self__, "specified_amount", specified_amount)

    @property
    @pulumi.getter(name="specifiedAmount")
    def specified_amount(self) -> 'outputs.BudgetAmountSpecifiedAmount':
        """
        A specified amount to use as the budget. currencyCode is
        optional. If specified, it must match the currency of the
        billing account. The currencyCode is provided on output.
        Structure is documented below.
        """
        return pulumi.get(self, "specified_amount")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BudgetAmountSpecifiedAmount(dict):
    def __init__(__self__, *,
                 currency_code: Optional[str] = None,
                 nanos: Optional[float] = None,
                 units: Optional[str] = None):
        """
        :param str currency_code: The 3-letter currency code defined in ISO 4217.
        :param float nanos: Number of nano (10^-9) units of the amount.
               The value must be between -999,999,999 and +999,999,999
               inclusive. If units is positive, nanos must be positive or
               zero. If units is zero, nanos can be positive, zero, or
               negative. If units is negative, nanos must be negative or
               zero. For example $-1.75 is represented as units=-1 and
               nanos=-750,000,000.
        :param str units: The whole units of the amount. For example if currencyCode
               is "USD", then 1 unit is one US dollar.
        """
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[str]:
        """
        The 3-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def nanos(self) -> Optional[float]:
        """
        Number of nano (10^-9) units of the amount.
        The value must be between -999,999,999 and +999,999,999
        inclusive. If units is positive, nanos must be positive or
        zero. If units is zero, nanos can be positive, zero, or
        negative. If units is negative, nanos must be negative or
        zero. For example $-1.75 is represented as units=-1 and
        nanos=-750,000,000.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def units(self) -> Optional[str]:
        """
        The whole units of the amount. For example if currencyCode
        is "USD", then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BudgetBudgetFilter(dict):
    def __init__(__self__, *,
                 credit_types_treatment: Optional[str] = None,
                 projects: Optional[List[str]] = None,
                 services: Optional[List[str]] = None):
        """
        :param str credit_types_treatment: Specifies how credits should be treated when determining spend
               for threshold calculations.
               Default value is `INCLUDE_ALL_CREDITS`.
               Possible values are `INCLUDE_ALL_CREDITS` and `EXCLUDE_ALL_CREDITS`.
        :param List[str] projects: A set of projects of the form projects/{project_id},
               specifying that usage from only this set of projects should be
               included in the budget. If omitted, the report will include
               all usage for the billing account, regardless of which project
               the usage occurred on. Only zero or one project can be
               specified currently.
        :param List[str] services: A set of services of the form services/{service_id},
               specifying that usage from only this set of services should be
               included in the budget. If omitted, the report will include
               usage for all the services. The service names are available
               through the Catalog API:
               https://cloud.google.com/billing/v1/how-tos/catalog-api.
        """
        if credit_types_treatment is not None:
            pulumi.set(__self__, "credit_types_treatment", credit_types_treatment)
        if projects is not None:
            pulumi.set(__self__, "projects", projects)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="creditTypesTreatment")
    def credit_types_treatment(self) -> Optional[str]:
        """
        Specifies how credits should be treated when determining spend
        for threshold calculations.
        Default value is `INCLUDE_ALL_CREDITS`.
        Possible values are `INCLUDE_ALL_CREDITS` and `EXCLUDE_ALL_CREDITS`.
        """
        return pulumi.get(self, "credit_types_treatment")

    @property
    @pulumi.getter
    def projects(self) -> Optional[List[str]]:
        """
        A set of projects of the form projects/{project_id},
        specifying that usage from only this set of projects should be
        included in the budget. If omitted, the report will include
        all usage for the billing account, regardless of which project
        the usage occurred on. Only zero or one project can be
        specified currently.
        """
        return pulumi.get(self, "projects")

    @property
    @pulumi.getter
    def services(self) -> Optional[List[str]]:
        """
        A set of services of the form services/{service_id},
        specifying that usage from only this set of services should be
        included in the budget. If omitted, the report will include
        usage for all the services. The service names are available
        through the Catalog API:
        https://cloud.google.com/billing/v1/how-tos/catalog-api.
        """
        return pulumi.get(self, "services")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BudgetThresholdRule(dict):
    def __init__(__self__, *,
                 threshold_percent: float,
                 spend_basis: Optional[str] = None):
        """
        :param float threshold_percent: Send an alert when this threshold is exceeded. This is a
               1.0-based percentage, so 0.5 = 50%. Must be >= 0.
        :param str spend_basis: The type of basis used to determine if spend has passed
               the threshold.
               Default value is `CURRENT_SPEND`.
               Possible values are `CURRENT_SPEND` and `FORECASTED_SPEND`.
        """
        pulumi.set(__self__, "threshold_percent", threshold_percent)
        if spend_basis is not None:
            pulumi.set(__self__, "spend_basis", spend_basis)

    @property
    @pulumi.getter(name="thresholdPercent")
    def threshold_percent(self) -> float:
        """
        Send an alert when this threshold is exceeded. This is a
        1.0-based percentage, so 0.5 = 50%. Must be >= 0.
        """
        return pulumi.get(self, "threshold_percent")

    @property
    @pulumi.getter(name="spendBasis")
    def spend_basis(self) -> Optional[str]:
        """
        The type of basis used to determine if spend has passed
        the threshold.
        Default value is `CURRENT_SPEND`.
        Possible values are `CURRENT_SPEND` and `FORECASTED_SPEND`.
        """
        return pulumi.get(self, "spend_basis")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


