# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['RegionUrlMap']


class RegionUrlMap(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_service: Optional[pulumi.Input[str]] = None,
                 default_url_redirect: Optional[pulumi.Input[pulumi.InputType['RegionUrlMapDefaultUrlRedirectArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 host_rules: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapHostRuleArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path_matchers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapPathMatcherArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tests: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapTestArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        UrlMaps are used to route requests to a backend service based on rules
        that you define for the host and path of an incoming URL.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_service: A reference to a RegionBackendService resource. This will be used if
               none of the pathRules defined by this PathMatcher is matched by
               the URL's path portion.
        :param pulumi.Input[pulumi.InputType['RegionUrlMapDefaultUrlRedirectArgs']] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[str] description: Description of this test case.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapHostRuleArgs']]]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the
               request, in the absence of which the request match fails.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapPathMatcherArgs']]]] path_matchers: The name of the PathMatcher to use to match the path portion of
               the URL if the hostRule matches the URL's host portion.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The Region in which the url map should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapTestArgs']]]] tests: The list of expected URL mappings. Requests to update this UrlMap will
               succeed only if all of the test cases pass.
               Structure is documented below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['default_service'] = default_service
            __props__['default_url_redirect'] = default_url_redirect
            __props__['description'] = description
            __props__['host_rules'] = host_rules
            __props__['name'] = name
            __props__['path_matchers'] = path_matchers
            __props__['project'] = project
            __props__['region'] = region
            __props__['tests'] = tests
            __props__['creation_timestamp'] = None
            __props__['fingerprint'] = None
            __props__['map_id'] = None
            __props__['self_link'] = None
        super(RegionUrlMap, __self__).__init__(
            'gcp:compute/regionUrlMap:RegionUrlMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            default_service: Optional[pulumi.Input[str]] = None,
            default_url_redirect: Optional[pulumi.Input[pulumi.InputType['RegionUrlMapDefaultUrlRedirectArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            host_rules: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapHostRuleArgs']]]]] = None,
            map_id: Optional[pulumi.Input[float]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path_matchers: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapPathMatcherArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            tests: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapTestArgs']]]]] = None) -> 'RegionUrlMap':
        """
        Get an existing RegionUrlMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] default_service: A reference to a RegionBackendService resource. This will be used if
               none of the pathRules defined by this PathMatcher is matched by
               the URL's path portion.
        :param pulumi.Input[pulumi.InputType['RegionUrlMapDefaultUrlRedirectArgs']] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[str] description: Description of this test case.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. This field is used internally during updates of this resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapHostRuleArgs']]]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[float] map_id: The unique identifier for the resource.
        :param pulumi.Input[str] name: The name of the query parameter to match. The query parameter must exist in the
               request, in the absence of which the request match fails.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapPathMatcherArgs']]]] path_matchers: The name of the PathMatcher to use to match the path portion of
               the URL if the hostRule matches the URL's host portion.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The Region in which the url map should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['RegionUrlMapTestArgs']]]] tests: The list of expected URL mappings. Requests to update this UrlMap will
               succeed only if all of the test cases pass.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["creation_timestamp"] = creation_timestamp
        __props__["default_service"] = default_service
        __props__["default_url_redirect"] = default_url_redirect
        __props__["description"] = description
        __props__["fingerprint"] = fingerprint
        __props__["host_rules"] = host_rules
        __props__["map_id"] = map_id
        __props__["name"] = name
        __props__["path_matchers"] = path_matchers
        __props__["project"] = project
        __props__["region"] = region
        __props__["self_link"] = self_link
        __props__["tests"] = tests
        return RegionUrlMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> Optional[str]:
        """
        A reference to a RegionBackendService resource. This will be used if
        none of the pathRules defined by this PathMatcher is matched by
        the URL's path portion.
        """
        return pulumi.get(self, "default_service")

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> Optional['outputs.RegionUrlMapDefaultUrlRedirect']:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of this test case.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Fingerprint of this resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Optional[List['outputs.RegionUrlMapHostRule']]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @property
    @pulumi.getter(name="mapId")
    def map_id(self) -> float:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "map_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the query parameter to match. The query parameter must exist in the
        request, in the absence of which the request match fails.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Optional[List['outputs.RegionUrlMapPathMatcher']]:
        """
        The name of the PathMatcher to use to match the path portion of
        the URL if the hostRule matches the URL's host portion.
        """
        return pulumi.get(self, "path_matchers")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The Region in which the url map should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tests(self) -> Optional[List['outputs.RegionUrlMapTest']]:
        """
        The list of expected URL mappings. Requests to update this UrlMap will
        succeed only if all of the test cases pass.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

