# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Entry']


class Entry(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entry_group: Optional[pulumi.Input[str]] = None,
                 entry_id: Optional[pulumi.Input[str]] = None,
                 gcs_fileset_spec: Optional[pulumi.Input[pulumi.InputType['EntryGcsFilesetSpecArgs']]] = None,
                 linked_resource: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_specified_system: Optional[pulumi.Input[str]] = None,
                 user_specified_type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Entry Metadata. A Data Catalog Entry resource represents another resource in Google Cloud Platform
        (such as a BigQuery dataset or a Pub/Sub topic) or outside of Google Cloud Platform. Clients can use
        the linkedResource field in the Entry resource to refer to the original resource ID of the source system.

        An Entry resource contains resource details, such as its schema. An Entry can also be used to attach
        flexible metadata, such as a Tag.

        To get more information about Entry, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Entry description, which can consist of several sentences or paragraphs that describe entry contents.
        :param pulumi.Input[str] display_name: Display information such as title and description. A short name to identify the entry,
               for example, "Analytics Data - Jan 2011".
        :param pulumi.Input[str] entry_group: The name of the entry group this entry is in.
        :param pulumi.Input[str] entry_id: The id of the entry to create.
        :param pulumi.Input[pulumi.InputType['EntryGcsFilesetSpecArgs']] gcs_fileset_spec: Specification that applies to a Cloud Storage fileset. This is only valid on entries of type FILESET.
               Structure is documented below.
        :param pulumi.Input[str] linked_resource: The resource this metadata entry refers to.
               For Google Cloud Platform resources, linkedResource is the full name of the resource.
               For example, the linkedResource for a table resource from BigQuery is:
               //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
               Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
               this field is optional and defaults to an empty string.
        :param pulumi.Input[str] schema: Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema
               attached to it. See
               https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema
               for what fields this schema can contain.
        :param pulumi.Input[str] type: The type of the entry. Only used for Entries with types in the EntryType enum.
               Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType.
               Possible values are `FILESET`.
        :param pulumi.Input[str] user_specified_system: This field indicates the entry's source system that Data Catalog does not integrate with.
               userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
               and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
        :param pulumi.Input[str] user_specified_type: Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
               When creating an entry, users should check the enum values first, if nothing matches the entry
               to be created, then provide a custom value, for example "my_special_type".
               userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
               numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['display_name'] = display_name
            if entry_group is None:
                raise TypeError("Missing required property 'entry_group'")
            __props__['entry_group'] = entry_group
            if entry_id is None:
                raise TypeError("Missing required property 'entry_id'")
            __props__['entry_id'] = entry_id
            __props__['gcs_fileset_spec'] = gcs_fileset_spec
            __props__['linked_resource'] = linked_resource
            __props__['schema'] = schema
            __props__['type'] = type
            __props__['user_specified_system'] = user_specified_system
            __props__['user_specified_type'] = user_specified_type
            __props__['bigquery_date_sharded_spec'] = None
            __props__['bigquery_table_spec'] = None
            __props__['integrated_system'] = None
            __props__['name'] = None
        super(Entry, __self__).__init__(
            'gcp:datacatalog/entry:Entry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigquery_date_sharded_spec: Optional[pulumi.Input[pulumi.InputType['EntryBigqueryDateShardedSpecArgs']]] = None,
            bigquery_table_spec: Optional[pulumi.Input[pulumi.InputType['EntryBigqueryTableSpecArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            entry_group: Optional[pulumi.Input[str]] = None,
            entry_id: Optional[pulumi.Input[str]] = None,
            gcs_fileset_spec: Optional[pulumi.Input[pulumi.InputType['EntryGcsFilesetSpecArgs']]] = None,
            integrated_system: Optional[pulumi.Input[str]] = None,
            linked_resource: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            schema: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_specified_system: Optional[pulumi.Input[str]] = None,
            user_specified_type: Optional[pulumi.Input[str]] = None) -> 'Entry':
        """
        Get an existing Entry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EntryBigqueryDateShardedSpecArgs']] bigquery_date_sharded_spec: Specification for a group of BigQuery tables with name pattern [prefix]YYYYMMDD. Context:
               https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
        :param pulumi.Input[pulumi.InputType['EntryBigqueryTableSpecArgs']] bigquery_table_spec: Specification that applies to a BigQuery table. This is only valid on entries of type TABLE.
        :param pulumi.Input[str] description: Entry description, which can consist of several sentences or paragraphs that describe entry contents.
        :param pulumi.Input[str] display_name: Display information such as title and description. A short name to identify the entry,
               for example, "Analytics Data - Jan 2011".
        :param pulumi.Input[str] entry_group: The name of the entry group this entry is in.
        :param pulumi.Input[str] entry_id: The id of the entry to create.
        :param pulumi.Input[pulumi.InputType['EntryGcsFilesetSpecArgs']] gcs_fileset_spec: Specification that applies to a Cloud Storage fileset. This is only valid on entries of type FILESET.
               Structure is documented below.
        :param pulumi.Input[str] integrated_system: This field indicates the entry's source system that Data Catalog integrates with, such as BigQuery or Pub/Sub.
        :param pulumi.Input[str] linked_resource: The resource this metadata entry refers to.
               For Google Cloud Platform resources, linkedResource is the full name of the resource.
               For example, the linkedResource for a table resource from BigQuery is:
               //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
               Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
               this field is optional and defaults to an empty string.
        :param pulumi.Input[str] name: The Data Catalog resource name of the entry in URL format. Example:
               projects/{project_id}/locations/{location}/entryGroups/{entryGroupId}/entries/{entryId}. Note that this Entry and its
               child resources may not actually be stored in the location in this name.
        :param pulumi.Input[str] schema: Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema
               attached to it. See
               https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema
               for what fields this schema can contain.
        :param pulumi.Input[str] type: The type of the entry. Only used for Entries with types in the EntryType enum.
               Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType.
               Possible values are `FILESET`.
        :param pulumi.Input[str] user_specified_system: This field indicates the entry's source system that Data Catalog does not integrate with.
               userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
               and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
        :param pulumi.Input[str] user_specified_type: Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
               When creating an entry, users should check the enum values first, if nothing matches the entry
               to be created, then provide a custom value, for example "my_special_type".
               userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
               numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["bigquery_date_sharded_spec"] = bigquery_date_sharded_spec
        __props__["bigquery_table_spec"] = bigquery_table_spec
        __props__["description"] = description
        __props__["display_name"] = display_name
        __props__["entry_group"] = entry_group
        __props__["entry_id"] = entry_id
        __props__["gcs_fileset_spec"] = gcs_fileset_spec
        __props__["integrated_system"] = integrated_system
        __props__["linked_resource"] = linked_resource
        __props__["name"] = name
        __props__["schema"] = schema
        __props__["type"] = type
        __props__["user_specified_system"] = user_specified_system
        __props__["user_specified_type"] = user_specified_type
        return Entry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigqueryDateShardedSpec")
    def bigquery_date_sharded_spec(self) -> 'outputs.EntryBigqueryDateShardedSpec':
        """
        Specification for a group of BigQuery tables with name pattern [prefix]YYYYMMDD. Context:
        https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
        """
        return pulumi.get(self, "bigquery_date_sharded_spec")

    @property
    @pulumi.getter(name="bigqueryTableSpec")
    def bigquery_table_spec(self) -> 'outputs.EntryBigqueryTableSpec':
        """
        Specification that applies to a BigQuery table. This is only valid on entries of type TABLE.
        """
        return pulumi.get(self, "bigquery_table_spec")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Entry description, which can consist of several sentences or paragraphs that describe entry contents.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display information such as title and description. A short name to identify the entry,
        for example, "Analytics Data - Jan 2011".
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entryGroup")
    def entry_group(self) -> str:
        """
        The name of the entry group this entry is in.
        """
        return pulumi.get(self, "entry_group")

    @property
    @pulumi.getter(name="entryId")
    def entry_id(self) -> str:
        """
        The id of the entry to create.
        """
        return pulumi.get(self, "entry_id")

    @property
    @pulumi.getter(name="gcsFilesetSpec")
    def gcs_fileset_spec(self) -> Optional['outputs.EntryGcsFilesetSpec']:
        """
        Specification that applies to a Cloud Storage fileset. This is only valid on entries of type FILESET.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_fileset_spec")

    @property
    @pulumi.getter(name="integratedSystem")
    def integrated_system(self) -> str:
        """
        This field indicates the entry's source system that Data Catalog integrates with, such as BigQuery or Pub/Sub.
        """
        return pulumi.get(self, "integrated_system")

    @property
    @pulumi.getter(name="linkedResource")
    def linked_resource(self) -> str:
        """
        The resource this metadata entry refers to.
        For Google Cloud Platform resources, linkedResource is the full name of the resource.
        For example, the linkedResource for a table resource from BigQuery is:
        //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
        Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
        this field is optional and defaults to an empty string.
        """
        return pulumi.get(self, "linked_resource")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The Data Catalog resource name of the entry in URL format. Example:
        projects/{project_id}/locations/{location}/entryGroups/{entryGroupId}/entries/{entryId}. Note that this Entry and its
        child resources may not actually be stored in the location in this name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> Optional[str]:
        """
        Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema
        attached to it. See
        https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema
        for what fields this schema can contain.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the entry. Only used for Entries with types in the EntryType enum.
        Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType.
        Possible values are `FILESET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userSpecifiedSystem")
    def user_specified_system(self) -> Optional[str]:
        """
        This field indicates the entry's source system that Data Catalog does not integrate with.
        userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
        and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
        """
        return pulumi.get(self, "user_specified_system")

    @property
    @pulumi.getter(name="userSpecifiedType")
    def user_specified_type(self) -> Optional[str]:
        """
        Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
        When creating an entry, users should check the enum values first, if nothing matches the entry
        to be created, then provide a custom value, for example "my_special_type".
        userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
        numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
        """
        return pulumi.get(self, "user_specified_type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

