# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Tag']


class Tag(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 column: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['TagFieldArgs']]]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Tags are used to attach custom metadata to Data Catalog resources. Tags conform to the specifications within their tag template.

        See [Data Catalog IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for information on the permissions needed to create or view tags.

        To get more information about Tag, see:

        * [API documentation](https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.tags)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-catalog/docs)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column: Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
               individual column based on that schema.
               For attaching a tag to a nested column, use `.` to separate the column names. Example:
               `outer_column.inner_column`
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['TagFieldArgs']]]] fields: This maps the ID of a tag field to the value of and additional information about that field.
               Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.
               Structure is documented below.
        :param pulumi.Input[str] parent: The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
               all entries in that group.
        :param pulumi.Input[str] template: The resource name of the tag template that this tag uses. Example:
               projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
               This field cannot be modified after creation.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['column'] = column
            if fields is None:
                raise TypeError("Missing required property 'fields'")
            __props__['fields'] = fields
            __props__['parent'] = parent
            if template is None:
                raise TypeError("Missing required property 'template'")
            __props__['template'] = template
            __props__['name'] = None
            __props__['template_displayname'] = None
        super(Tag, __self__).__init__(
            'gcp:datacatalog/tag:Tag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            column: Optional[pulumi.Input[str]] = None,
            fields: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['TagFieldArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[str]] = None,
            template_displayname: Optional[pulumi.Input[str]] = None) -> 'Tag':
        """
        Get an existing Tag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] column: Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
               individual column based on that schema.
               For attaching a tag to a nested column, use `.` to separate the column names. Example:
               `outer_column.inner_column`
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['TagFieldArgs']]]] fields: This maps the ID of a tag field to the value of and additional information about that field.
               Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.
               Structure is documented below.
        :param pulumi.Input[str] name: The resource name of the tag in URL format. Example:
               projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/entries/{entryId}/tags/{tag_id} or
               projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/tags/{tag_id} where tag_id is a system-generated
               identifier. Note that this Tag may not actually be stored in the location in this name.
        :param pulumi.Input[str] parent: The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
               all entries in that group.
        :param pulumi.Input[str] template: The resource name of the tag template that this tag uses. Example:
               projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
               This field cannot be modified after creation.
        :param pulumi.Input[str] template_displayname: The display name of the tag template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["column"] = column
        __props__["fields"] = fields
        __props__["name"] = name
        __props__["parent"] = parent
        __props__["template"] = template
        __props__["template_displayname"] = template_displayname
        return Tag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def column(self) -> Optional[str]:
        """
        Resources like Entry can have schemas associated with them. This scope allows users to attach tags to an
        individual column based on that schema.
        For attaching a tag to a nested column, use `.` to separate the column names. Example:
        `outer_column.inner_column`
        """
        return pulumi.get(self, "column")

    @property
    @pulumi.getter
    def fields(self) -> List['outputs.TagField']:
        """
        This maps the ID of a tag field to the value of and additional information about that field.
        Valid field IDs are defined by the tag's template. A tag must have at least 1 field and at most 500 fields.
        Structure is documented below.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the tag in URL format. Example:
        projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/entries/{entryId}/tags/{tag_id} or
        projects/{project_id}/locations/{location}/entrygroups/{entryGroupId}/tags/{tag_id} where tag_id is a system-generated
        identifier. Note that this Tag may not actually be stored in the location in this name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> Optional[str]:
        """
        The name of the parent this tag is attached to. This can be the name of an entry or an entry group. If an entry group, the tag will be attached to
        all entries in that group.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        The resource name of the tag template that this tag uses. Example:
        projects/{project_id}/locations/{location}/tagTemplates/{tagTemplateId}
        This field cannot be modified after creation.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="templateDisplayname")
    def template_displayname(self) -> str:
        """
        The display name of the tag template.
        """
        return pulumi.get(self, "template_displayname")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

