# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Subscription']


class Subscription(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ack_deadline_seconds: Optional[pulumi.Input[float]] = None,
                 dead_letter_policy: Optional[pulumi.Input[pulumi.InputType['SubscriptionDeadLetterPolicyArgs']]] = None,
                 expiration_policy: Optional[pulumi.Input[pulumi.InputType['SubscriptionExpirationPolicyArgs']]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 message_retention_duration: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 push_config: Optional[pulumi.Input[pulumi.InputType['SubscriptionPushConfigArgs']]] = None,
                 retain_acked_messages: Optional[pulumi.Input[bool]] = None,
                 topic: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A named resource representing the stream of messages from a single,
        specific topic, to be delivered to the subscribing application.

        To get more information about Subscription, see:

        * [API documentation](https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.subscriptions)
        * How-to Guides
            * [Managing Subscriptions](https://cloud.google.com/pubsub/docs/admin#managing_subscriptions)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] ack_deadline_seconds: This value is the maximum time after a subscriber receives a message
               before the subscriber should acknowledge the message. After message
               delivery but before the ack deadline expires and before the message is
               acknowledged, it is an outstanding message and will not be delivered
               again during that time (on a best-effort basis).
               For pull subscriptions, this value is used as the initial value for
               the ack deadline. To override this value for a given message, call
               subscriptions.modifyAckDeadline with the corresponding ackId if using
               pull. The minimum custom deadline you can specify is 10 seconds. The
               maximum custom deadline you can specify is 600 seconds (10 minutes).
               If this parameter is 0, a default value of 10 seconds is used.
               For push delivery, this value is also used to set the request timeout
               for the call to the push endpoint.
               If the subscriber never acknowledges the message, the Pub/Sub system
               will eventually redeliver the message.
        :param pulumi.Input[pulumi.InputType['SubscriptionDeadLetterPolicyArgs']] dead_letter_policy: A policy that specifies the conditions for dead lettering messages in
               this subscription. If dead_letter_policy is not set, dead lettering
               is disabled.
               The Cloud Pub/Sub service account associated with this subscriptions's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Acknowledge() messages on this subscription.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['SubscriptionExpirationPolicyArgs']] expiration_policy: A policy that specifies the conditions for this subscription's expiration.
               A subscription is considered active as long as any connected subscriber
               is successfully consuming messages from the subscription or is issuing
               operations on the subscription. If expirationPolicy is not set, a default
               policy with ttl of 31 days will be used.  If it is set but ttl is "", the
               resource never expires.  The minimum allowed value for expirationPolicy.ttl
               is 1 day.
               Structure is documented below.
        :param pulumi.Input[str] filter: The subscription only delivers the messages that match the filter.
               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
               you can't modify the filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to this Subscription.
        :param pulumi.Input[str] message_retention_duration: How long to retain unacknowledged messages in the subscription's
               backlog, from the moment a message is published. If
               retainAckedMessages is true, then this also configures the retention
               of acknowledged messages, and thus configures how far back in time a
               subscriptions.seek can be done. Defaults to 7 days. Cannot be more
               than 7 days (`"604800s"`) or less than 10 minutes (`"600s"`).
               A duration in seconds with up to nine fractional digits, terminated
               by 's'. Example: `"600.5s"`.
        :param pulumi.Input[str] name: Name of the subscription.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['SubscriptionPushConfigArgs']] push_config: If push delivery is used with this subscription, this field is used to
               configure it. An empty pushConfig signifies that the subscriber will
               pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[bool] retain_acked_messages: Indicates whether to retain acknowledged messages. If `true`, then
               messages are not expunged from the subscription's backlog, even if
               they are acknowledged, until they fall out of the
               messageRetentionDuration window.
        :param pulumi.Input[str] topic: A reference to a Topic resource.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['ack_deadline_seconds'] = ack_deadline_seconds
            __props__['dead_letter_policy'] = dead_letter_policy
            __props__['expiration_policy'] = expiration_policy
            __props__['filter'] = filter
            __props__['labels'] = labels
            __props__['message_retention_duration'] = message_retention_duration
            __props__['name'] = name
            __props__['project'] = project
            __props__['push_config'] = push_config
            __props__['retain_acked_messages'] = retain_acked_messages
            if topic is None:
                raise TypeError("Missing required property 'topic'")
            __props__['topic'] = topic
            __props__['path'] = None
        super(Subscription, __self__).__init__(
            'gcp:pubsub/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ack_deadline_seconds: Optional[pulumi.Input[float]] = None,
            dead_letter_policy: Optional[pulumi.Input[pulumi.InputType['SubscriptionDeadLetterPolicyArgs']]] = None,
            expiration_policy: Optional[pulumi.Input[pulumi.InputType['SubscriptionExpirationPolicyArgs']]] = None,
            filter: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            message_retention_duration: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            push_config: Optional[pulumi.Input[pulumi.InputType['SubscriptionPushConfigArgs']]] = None,
            retain_acked_messages: Optional[pulumi.Input[bool]] = None,
            topic: Optional[pulumi.Input[str]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] ack_deadline_seconds: This value is the maximum time after a subscriber receives a message
               before the subscriber should acknowledge the message. After message
               delivery but before the ack deadline expires and before the message is
               acknowledged, it is an outstanding message and will not be delivered
               again during that time (on a best-effort basis).
               For pull subscriptions, this value is used as the initial value for
               the ack deadline. To override this value for a given message, call
               subscriptions.modifyAckDeadline with the corresponding ackId if using
               pull. The minimum custom deadline you can specify is 10 seconds. The
               maximum custom deadline you can specify is 600 seconds (10 minutes).
               If this parameter is 0, a default value of 10 seconds is used.
               For push delivery, this value is also used to set the request timeout
               for the call to the push endpoint.
               If the subscriber never acknowledges the message, the Pub/Sub system
               will eventually redeliver the message.
        :param pulumi.Input[pulumi.InputType['SubscriptionDeadLetterPolicyArgs']] dead_letter_policy: A policy that specifies the conditions for dead lettering messages in
               this subscription. If dead_letter_policy is not set, dead lettering
               is disabled.
               The Cloud Pub/Sub service account associated with this subscriptions's
               parent project (i.e.,
               service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
               permission to Acknowledge() messages on this subscription.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['SubscriptionExpirationPolicyArgs']] expiration_policy: A policy that specifies the conditions for this subscription's expiration.
               A subscription is considered active as long as any connected subscriber
               is successfully consuming messages from the subscription or is issuing
               operations on the subscription. If expirationPolicy is not set, a default
               policy with ttl of 31 days will be used.  If it is set but ttl is "", the
               resource never expires.  The minimum allowed value for expirationPolicy.ttl
               is 1 day.
               Structure is documented below.
        :param pulumi.Input[str] filter: The subscription only delivers the messages that match the filter.
               Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
               by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
               you can't modify the filter.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to this Subscription.
        :param pulumi.Input[str] message_retention_duration: How long to retain unacknowledged messages in the subscription's
               backlog, from the moment a message is published. If
               retainAckedMessages is true, then this also configures the retention
               of acknowledged messages, and thus configures how far back in time a
               subscriptions.seek can be done. Defaults to 7 days. Cannot be more
               than 7 days (`"604800s"`) or less than 10 minutes (`"600s"`).
               A duration in seconds with up to nine fractional digits, terminated
               by 's'. Example: `"600.5s"`.
        :param pulumi.Input[str] name: Name of the subscription.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['SubscriptionPushConfigArgs']] push_config: If push delivery is used with this subscription, this field is used to
               configure it. An empty pushConfig signifies that the subscriber will
               pull and ack messages using API methods.
               Structure is documented below.
        :param pulumi.Input[bool] retain_acked_messages: Indicates whether to retain acknowledged messages. If `true`, then
               messages are not expunged from the subscription's backlog, even if
               they are acknowledged, until they fall out of the
               messageRetentionDuration window.
        :param pulumi.Input[str] topic: A reference to a Topic resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["ack_deadline_seconds"] = ack_deadline_seconds
        __props__["dead_letter_policy"] = dead_letter_policy
        __props__["expiration_policy"] = expiration_policy
        __props__["filter"] = filter
        __props__["labels"] = labels
        __props__["message_retention_duration"] = message_retention_duration
        __props__["name"] = name
        __props__["path"] = path
        __props__["project"] = project
        __props__["push_config"] = push_config
        __props__["retain_acked_messages"] = retain_acked_messages
        __props__["topic"] = topic
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ackDeadlineSeconds")
    def ack_deadline_seconds(self) -> float:
        """
        This value is the maximum time after a subscriber receives a message
        before the subscriber should acknowledge the message. After message
        delivery but before the ack deadline expires and before the message is
        acknowledged, it is an outstanding message and will not be delivered
        again during that time (on a best-effort basis).
        For pull subscriptions, this value is used as the initial value for
        the ack deadline. To override this value for a given message, call
        subscriptions.modifyAckDeadline with the corresponding ackId if using
        pull. The minimum custom deadline you can specify is 10 seconds. The
        maximum custom deadline you can specify is 600 seconds (10 minutes).
        If this parameter is 0, a default value of 10 seconds is used.
        For push delivery, this value is also used to set the request timeout
        for the call to the push endpoint.
        If the subscriber never acknowledges the message, the Pub/Sub system
        will eventually redeliver the message.
        """
        return pulumi.get(self, "ack_deadline_seconds")

    @property
    @pulumi.getter(name="deadLetterPolicy")
    def dead_letter_policy(self) -> Optional['outputs.SubscriptionDeadLetterPolicy']:
        """
        A policy that specifies the conditions for dead lettering messages in
        this subscription. If dead_letter_policy is not set, dead lettering
        is disabled.
        The Cloud Pub/Sub service account associated with this subscriptions's
        parent project (i.e.,
        service-{project_number}@gcp-sa-pubsub.iam.gserviceaccount.com) must have
        permission to Acknowledge() messages on this subscription.
        Structure is documented below.
        """
        return pulumi.get(self, "dead_letter_policy")

    @property
    @pulumi.getter(name="expirationPolicy")
    def expiration_policy(self) -> 'outputs.SubscriptionExpirationPolicy':
        """
        A policy that specifies the conditions for this subscription's expiration.
        A subscription is considered active as long as any connected subscriber
        is successfully consuming messages from the subscription or is issuing
        operations on the subscription. If expirationPolicy is not set, a default
        policy with ttl of 31 days will be used.  If it is set but ttl is "", the
        resource never expires.  The minimum allowed value for expirationPolicy.ttl
        is 1 day.
        Structure is documented below.
        """
        return pulumi.get(self, "expiration_policy")

    @property
    @pulumi.getter
    def filter(self) -> Optional[str]:
        """
        The subscription only delivers the messages that match the filter.
        Pub/Sub automatically acknowledges the messages that don't match the filter. You can filter messages
        by their attributes. The maximum length of a filter is 256 bytes. After creating the subscription,
        you can't modify the filter.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        A set of key/value label pairs to assign to this Subscription.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="messageRetentionDuration")
    def message_retention_duration(self) -> Optional[str]:
        """
        How long to retain unacknowledged messages in the subscription's
        backlog, from the moment a message is published. If
        retainAckedMessages is true, then this also configures the retention
        of acknowledged messages, and thus configures how far back in time a
        subscriptions.seek can be done. Defaults to 7 days. Cannot be more
        than 7 days (`"604800s"`) or less than 10 minutes (`"600s"`).
        A duration in seconds with up to nine fractional digits, terminated
        by 's'. Example: `"600.5s"`.
        """
        return pulumi.get(self, "message_retention_duration")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the subscription.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pushConfig")
    def push_config(self) -> Optional['outputs.SubscriptionPushConfig']:
        """
        If push delivery is used with this subscription, this field is used to
        configure it. An empty pushConfig signifies that the subscriber will
        pull and ack messages using API methods.
        Structure is documented below.
        """
        return pulumi.get(self, "push_config")

    @property
    @pulumi.getter(name="retainAckedMessages")
    def retain_acked_messages(self) -> Optional[bool]:
        """
        Indicates whether to retain acknowledged messages. If `true`, then
        messages are not expunged from the subscription's backlog, even if
        they are acknowledged, until they fall out of the
        messageRetentionDuration window.
        """
        return pulumi.get(self, "retain_acked_messages")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        A reference to a Topic resource.
        """
        return pulumi.get(self, "topic")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

