# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'SecretIamBindingCondition',
    'SecretIamMemberCondition',
    'SecretReplication',
    'SecretReplicationUserManaged',
    'SecretReplicationUserManagedReplica',
]

@pulumi.output_type
class SecretIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretReplication(dict):
    def __init__(__self__, *,
                 automatic: Optional[bool] = None,
                 user_managed: Optional['outputs.SecretReplicationUserManaged'] = None):
        """
        :param bool automatic: The Secret will automatically be replicated without any restrictions.
        :param 'SecretReplicationUserManagedArgs' user_managed: The Secret will automatically be replicated without any restrictions.
               Structure is documented below.
        """
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if user_managed is not None:
            pulumi.set(__self__, "user_managed", user_managed)

    @property
    @pulumi.getter
    def automatic(self) -> Optional[bool]:
        """
        The Secret will automatically be replicated without any restrictions.
        """
        return pulumi.get(self, "automatic")

    @property
    @pulumi.getter(name="userManaged")
    def user_managed(self) -> Optional['outputs.SecretReplicationUserManaged']:
        """
        The Secret will automatically be replicated without any restrictions.
        Structure is documented below.
        """
        return pulumi.get(self, "user_managed")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretReplicationUserManaged(dict):
    def __init__(__self__, *,
                 replicas: List['outputs.SecretReplicationUserManagedReplica']):
        """
        :param List['SecretReplicationUserManagedReplicaArgs'] replicas: The list of Replicas for this Secret. Cannot be empty.
               Structure is documented below.
        """
        pulumi.set(__self__, "replicas", replicas)

    @property
    @pulumi.getter
    def replicas(self) -> List['outputs.SecretReplicationUserManagedReplica']:
        """
        The list of Replicas for this Secret. Cannot be empty.
        Structure is documented below.
        """
        return pulumi.get(self, "replicas")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretReplicationUserManagedReplica(dict):
    def __init__(__self__, *,
                 location: str):
        """
        :param str location: The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The canonical IDs of the location to replicate data. For example: "us-east1".
        """
        return pulumi.get(self, "location")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


