# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'BucketCor',
    'BucketEncryption',
    'BucketIAMBindingCondition',
    'BucketIAMMemberCondition',
    'BucketLifecycleRule',
    'BucketLifecycleRuleAction',
    'BucketLifecycleRuleCondition',
    'BucketLogging',
    'BucketRetentionPolicy',
    'BucketVersioning',
    'BucketWebsite',
    'DefaultObjectAccessControlProjectTeam',
    'ObjectAccessControlProjectTeam',
    'TransferJobSchedule',
    'TransferJobScheduleScheduleEndDate',
    'TransferJobScheduleScheduleStartDate',
    'TransferJobScheduleStartTimeOfDay',
    'TransferJobTransferSpec',
    'TransferJobTransferSpecAwsS3DataSource',
    'TransferJobTransferSpecAwsS3DataSourceAwsAccessKey',
    'TransferJobTransferSpecGcsDataSink',
    'TransferJobTransferSpecGcsDataSource',
    'TransferJobTransferSpecHttpDataSource',
    'TransferJobTransferSpecObjectConditions',
    'TransferJobTransferSpecTransferOptions',
]

@pulumi.output_type
class BucketCor(dict):
    def __init__(__self__, *,
                 max_age_seconds: Optional[float] = None,
                 methods: Optional[List[str]] = None,
                 origins: Optional[List[str]] = None,
                 response_headers: Optional[List[str]] = None):
        """
        :param float max_age_seconds: The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        :param List[str] methods: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param List[str] origins: The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param List[str] response_headers: The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[float]:
        """
        The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @property
    @pulumi.getter
    def methods(self) -> Optional[List[str]]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def origins(self) -> Optional[List[str]]:
        """
        The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[List[str]]:
        """
        The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_headers")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketEncryption(dict):
    def __init__(__self__, *,
                 default_kms_key_name: str):
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> str:
        return pulumi.get(self, "default_kms_key_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        :param str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        """
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str title: A title for the expression, i.e. a short string describing its purpose.
        :param str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketLifecycleRule(dict):
    def __init__(__self__, *,
                 action: 'outputs.BucketLifecycleRuleAction',
                 condition: 'outputs.BucketLifecycleRuleCondition'):
        """
        :param 'BucketLifecycleRuleActionArgs' action: The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        :param 'BucketLifecycleRuleConditionArgs' condition: The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)

    @property
    @pulumi.getter
    def action(self) -> 'outputs.BucketLifecycleRuleAction':
        """
        The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.BucketLifecycleRuleCondition':
        """
        The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketLifecycleRuleAction(dict):
    def __init__(__self__, *,
                 type: str,
                 storage_class: Optional[str] = None):
        """
        :param str type: The type of the action of this Lifecycle Rule. Supported values include: `Delete` and `SetStorageClass`.
        :param str storage_class: The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`.
        """
        pulumi.set(__self__, "type", type)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the action of this Lifecycle Rule. Supported values include: `Delete` and `SetStorageClass`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[str]:
        """
        The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`.
        """
        return pulumi.get(self, "storage_class")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketLifecycleRuleCondition(dict):
    def __init__(__self__, *,
                 age: Optional[float] = None,
                 created_before: Optional[str] = None,
                 matches_storage_classes: Optional[List[str]] = None,
                 num_newer_versions: Optional[float] = None,
                 with_state: Optional[str] = None):
        """
        :param float age: Minimum age of an object in days to satisfy this condition.
        :param str created_before: Creation date of an object in RFC 3339 (e.g. `2017-06-13`) to satisfy this condition.
        :param List[str] matches_storage_classes: [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, `DURABLE_REDUCED_AVAILABILITY`.
        :param float num_newer_versions: Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        :param str with_state: Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        if age is not None:
            pulumi.set(__self__, "age", age)
        if created_before is not None:
            pulumi.set(__self__, "created_before", created_before)
        if matches_storage_classes is not None:
            pulumi.set(__self__, "matches_storage_classes", matches_storage_classes)
        if num_newer_versions is not None:
            pulumi.set(__self__, "num_newer_versions", num_newer_versions)
        if with_state is not None:
            pulumi.set(__self__, "with_state", with_state)

    @property
    @pulumi.getter
    def age(self) -> Optional[float]:
        """
        Minimum age of an object in days to satisfy this condition.
        """
        return pulumi.get(self, "age")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[str]:
        """
        Creation date of an object in RFC 3339 (e.g. `2017-06-13`) to satisfy this condition.
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter(name="matchesStorageClasses")
    def matches_storage_classes(self) -> Optional[List[str]]:
        """
        [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `STANDARD`, `DURABLE_REDUCED_AVAILABILITY`.
        """
        return pulumi.get(self, "matches_storage_classes")

    @property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> Optional[float]:
        """
        Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        """
        return pulumi.get(self, "num_newer_versions")

    @property
    @pulumi.getter(name="withState")
    def with_state(self) -> Optional[str]:
        """
        Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        return pulumi.get(self, "with_state")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketLogging(dict):
    def __init__(__self__, *,
                 log_bucket: str,
                 log_object_prefix: Optional[str] = None):
        """
        :param str log_bucket: The bucket that will receive log objects.
        :param str log_object_prefix: The object prefix for log objects. If it's not provided,
               by default GCS sets this to this bucket's name.
        """
        pulumi.set(__self__, "log_bucket", log_bucket)
        if log_object_prefix is not None:
            pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> str:
        """
        The bucket that will receive log objects.
        """
        return pulumi.get(self, "log_bucket")

    @property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> Optional[str]:
        """
        The object prefix for log objects. If it's not provided,
        by default GCS sets this to this bucket's name.
        """
        return pulumi.get(self, "log_object_prefix")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketRetentionPolicy(dict):
    def __init__(__self__, *,
                 retention_period: float,
                 is_locked: Optional[bool] = None):
        """
        :param float retention_period: The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        :param bool is_locked: If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        pulumi.set(__self__, "retention_period", retention_period)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> float:
        """
        The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        """
        return pulumi.get(self, "retention_period")

    @property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[bool]:
        """
        If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        return pulumi.get(self, "is_locked")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: While set to `true`, versioning is fully enabled for this bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        While set to `true`, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BucketWebsite(dict):
    def __init__(__self__, *,
                 main_page_suffix: Optional[str] = None,
                 not_found_page: Optional[str] = None):
        """
        :param str main_page_suffix: Behaves as the bucket's directory index where
               missing objects are treated as potential directories.
        :param str not_found_page: The custom object to return when a requested
               resource is not found.
        """
        if main_page_suffix is not None:
            pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        if not_found_page is not None:
            pulumi.set(__self__, "not_found_page", not_found_page)

    @property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> Optional[str]:
        """
        Behaves as the bucket's directory index where
        missing objects are treated as potential directories.
        """
        return pulumi.get(self, "main_page_suffix")

    @property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> Optional[str]:
        """
        The custom object to return when a requested
        resource is not found.
        """
        return pulumi.get(self, "not_found_page")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DefaultObjectAccessControlProjectTeam(dict):
    def __init__(__self__, *,
                 project_number: Optional[str] = None,
                 team: Optional[str] = None):
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[str]:
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> Optional[str]:
        return pulumi.get(self, "team")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ObjectAccessControlProjectTeam(dict):
    def __init__(__self__, *,
                 project_number: Optional[str] = None,
                 team: Optional[str] = None):
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[str]:
        return pulumi.get(self, "project_number")

    @property
    @pulumi.getter
    def team(self) -> Optional[str]:
        return pulumi.get(self, "team")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobSchedule(dict):
    def __init__(__self__, *,
                 schedule_start_date: 'outputs.TransferJobScheduleScheduleStartDate',
                 schedule_end_date: Optional['outputs.TransferJobScheduleScheduleEndDate'] = None,
                 start_time_of_day: Optional['outputs.TransferJobScheduleStartTimeOfDay'] = None):
        """
        :param 'TransferJobScheduleScheduleStartDateArgs' schedule_start_date: The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        :param 'TransferJobScheduleScheduleEndDateArgs' schedule_end_date: The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        :param 'TransferJobScheduleStartTimeOfDayArgs' start_time_of_day: The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        if schedule_end_date is not None:
            pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        if start_time_of_day is not None:
            pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> 'outputs.TransferJobScheduleScheduleStartDate':
        """
        The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        """
        return pulumi.get(self, "schedule_start_date")

    @property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> Optional['outputs.TransferJobScheduleScheduleEndDate']:
        """
        The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        """
        return pulumi.get(self, "schedule_end_date")

    @property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> Optional['outputs.TransferJobScheduleStartTimeOfDay']:
        """
        The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        return pulumi.get(self, "start_time_of_day")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobScheduleScheduleEndDate(dict):
    def __init__(__self__, *,
                 day: float,
                 month: float,
                 year: float):
        """
        :param float day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param float month: Month of year. Must be from 1 to 12.
        :param float year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> float:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> float:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> float:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobScheduleScheduleStartDate(dict):
    def __init__(__self__, *,
                 day: float,
                 month: float,
                 year: float):
        """
        :param float day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param float month: Month of year. Must be from 1 to 12.
        :param float year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> float:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> float:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> float:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobScheduleStartTimeOfDay(dict):
    def __init__(__self__, *,
                 hours: float,
                 minutes: float,
                 nanos: float,
                 seconds: float):
        """
        :param float hours: Hours of day in 24 hour format. Should be from 0 to 23
        :param float minutes: Minutes of hour of day. Must be from 0 to 59.
        :param float nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param float seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @property
    @pulumi.getter
    def hours(self) -> float:
        """
        Hours of day in 24 hour format. Should be from 0 to 23
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> float:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def nanos(self) -> float:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> float:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        return pulumi.get(self, "seconds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpec(dict):
    def __init__(__self__, *,
                 aws_s3_data_source: Optional['outputs.TransferJobTransferSpecAwsS3DataSource'] = None,
                 gcs_data_sink: Optional['outputs.TransferJobTransferSpecGcsDataSink'] = None,
                 gcs_data_source: Optional['outputs.TransferJobTransferSpecGcsDataSource'] = None,
                 http_data_source: Optional['outputs.TransferJobTransferSpecHttpDataSource'] = None,
                 object_conditions: Optional['outputs.TransferJobTransferSpecObjectConditions'] = None,
                 transfer_options: Optional['outputs.TransferJobTransferSpecTransferOptions'] = None):
        """
        :param 'TransferJobTransferSpecAwsS3DataSourceArgs' aws_s3_data_source: An AWS S3 data source. Structure documented below.
        :param 'TransferJobTransferSpecGcsDataSinkArgs' gcs_data_sink: A Google Cloud Storage data sink. Structure documented below.
        :param 'TransferJobTransferSpecGcsDataSourceArgs' gcs_data_source: A Google Cloud Storage data source. Structure documented below.
        :param 'TransferJobTransferSpecHttpDataSourceArgs' http_data_source: An HTTP URL data source. Structure documented below.
        :param 'TransferJobTransferSpecObjectConditionsArgs' object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        :param 'TransferJobTransferSpecTransferOptionsArgs' transfer_options: Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        if aws_s3_data_source is not None:
            pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        if gcs_data_sink is not None:
            pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        if gcs_data_source is not None:
            pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        if http_data_source is not None:
            pulumi.set(__self__, "http_data_source", http_data_source)
        if object_conditions is not None:
            pulumi.set(__self__, "object_conditions", object_conditions)
        if transfer_options is not None:
            pulumi.set(__self__, "transfer_options", transfer_options)

    @property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> Optional['outputs.TransferJobTransferSpecAwsS3DataSource']:
        """
        An AWS S3 data source. Structure documented below.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> Optional['outputs.TransferJobTransferSpecGcsDataSink']:
        """
        A Google Cloud Storage data sink. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_sink")

    @property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> Optional['outputs.TransferJobTransferSpecGcsDataSource']:
        """
        A Google Cloud Storage data source. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_source")

    @property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> Optional['outputs.TransferJobTransferSpecHttpDataSource']:
        """
        An HTTP URL data source. Structure documented below.
        """
        return pulumi.get(self, "http_data_source")

    @property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> Optional['outputs.TransferJobTransferSpecObjectConditions']:
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        """
        return pulumi.get(self, "object_conditions")

    @property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> Optional['outputs.TransferJobTransferSpecTransferOptions']:
        """
        Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        return pulumi.get(self, "transfer_options")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecAwsS3DataSource(dict):
    def __init__(__self__, *,
                 aws_access_key: 'outputs.TransferJobTransferSpecAwsS3DataSourceAwsAccessKey',
                 bucket_name: str):
        """
        :param 'TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs' aws_access_key: AWS credentials block.
        :param str bucket_name: S3 Bucket name.
        """
        pulumi.set(__self__, "aws_access_key", aws_access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> 'outputs.TransferJobTransferSpecAwsS3DataSourceAwsAccessKey':
        """
        AWS credentials block.
        """
        return pulumi.get(self, "aws_access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecAwsS3DataSourceAwsAccessKey(dict):
    def __init__(__self__, *,
                 access_key_id: str,
                 secret_access_key: str):
        """
        :param str access_key_id: AWS Key ID.
        :param str secret_access_key: AWS Secret Access Key.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> str:
        """
        AWS Key ID.
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> str:
        """
        AWS Secret Access Key.
        """
        return pulumi.get(self, "secret_access_key")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecGcsDataSink(dict):
    def __init__(__self__, *,
                 bucket_name: str):
        """
        :param str bucket_name: S3 Bucket name.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecGcsDataSource(dict):
    def __init__(__self__, *,
                 bucket_name: str):
        """
        :param str bucket_name: S3 Bucket name.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecHttpDataSource(dict):
    def __init__(__self__, *,
                 list_url: str):
        """
        :param str list_url: The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> str:
        """
        The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecObjectConditions(dict):
    def __init__(__self__, *,
                 exclude_prefixes: Optional[List[str]] = None,
                 include_prefixes: Optional[List[str]] = None,
                 max_time_elapsed_since_last_modification: Optional[str] = None,
                 min_time_elapsed_since_last_modification: Optional[str] = None):
        """
        :param List[str] exclude_prefixes: `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param List[str] include_prefixes: If `include_refixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param str max_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str min_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_prefixes is not None:
            pulumi.set(__self__, "include_prefixes", include_prefixes)
        if max_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        if min_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[List[str]]:
        """
        `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "exclude_prefixes")

    @property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Optional[List[str]]:
        """
        If `include_refixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "include_prefixes")

    @property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> Optional[str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> Optional[str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TransferJobTransferSpecTransferOptions(dict):
    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: Optional[bool] = None,
                 delete_objects_unique_in_sink: Optional[bool] = None,
                 overwrite_objects_already_existing_in_sink: Optional[bool] = None):
        """
        :param bool delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        :param bool delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. Note that this option and
               `delete_objects_from_source_after_transfer` are mutually exclusive.
        :param bool overwrite_objects_already_existing_in_sink: Whether overwriting objects that already exist in the sink is allowed.
        """
        if delete_objects_from_source_after_transfer is not None:
            pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        if delete_objects_unique_in_sink is not None:
            pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        if overwrite_objects_already_existing_in_sink is not None:
            pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)

    @property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> Optional[bool]:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> Optional[bool]:
        """
        Whether objects that exist only in the sink should be deleted. Note that this option and
        `delete_objects_from_source_after_transfer` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> Optional[bool]:
        """
        Whether overwriting objects that already exist in the sink is allowed.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


