# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['ConnectionAwsArgs']] = None,
                 azure: Optional[pulumi.Input['ConnectionAzureArgs']] = None,
                 cloud_resource: Optional[pulumi.Input['ConnectionCloudResourceArgs']] = None,
                 cloud_spanner: Optional[pulumi.Input['ConnectionCloudSpannerArgs']] = None,
                 cloud_sql: Optional[pulumi.Input['ConnectionCloudSqlArgs']] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input['ConnectionAwsArgs'] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input['ConnectionAzureArgs'] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudResourceArgs'] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSpannerArgs'] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSqlArgs'] cloud_sql: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[str] description: A descriptive description for the connection
        :param pulumi.Input[str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if cloud_resource is not None:
            pulumi.set(__self__, "cloud_resource", cloud_resource)
        if cloud_spanner is not None:
            pulumi.set(__self__, "cloud_spanner", cloud_spanner)
        if cloud_sql is not None:
            pulumi.set(__self__, "cloud_sql", cloud_sql)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['ConnectionAwsArgs']]:
        """
        Connection properties specific to Amazon Web Services.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['ConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['ConnectionAzureArgs']]:
        """
        Container for connection properties specific to Azure.
        Structure is documented below.
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['ConnectionAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="cloudResource")
    def cloud_resource(self) -> Optional[pulumi.Input['ConnectionCloudResourceArgs']]:
        """
        Container for connection properties for delegation of access to GCP resources.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_resource")

    @cloud_resource.setter
    def cloud_resource(self, value: Optional[pulumi.Input['ConnectionCloudResourceArgs']]):
        pulumi.set(self, "cloud_resource", value)

    @property
    @pulumi.getter(name="cloudSpanner")
    def cloud_spanner(self) -> Optional[pulumi.Input['ConnectionCloudSpannerArgs']]:
        """
        Connection properties specific to Cloud Spanner
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_spanner")

    @cloud_spanner.setter
    def cloud_spanner(self, value: Optional[pulumi.Input['ConnectionCloudSpannerArgs']]):
        pulumi.set(self, "cloud_spanner", value)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> Optional[pulumi.Input['ConnectionCloudSqlArgs']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql")

    @cloud_sql.setter
    def cloud_sql(self, value: Optional[pulumi.Input['ConnectionCloudSqlArgs']]):
        pulumi.set(self, "cloud_sql", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional connection id that should be assigned to the created connection.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive description for the connection
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the connection
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geographic location where the connection should reside.
        Cloud SQL instance must be in the same location as the connection
        with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
        Examples: US, EU, asia-northeast1, us-central1, europe-west1.
        Spanner Connections same as spanner region
        AWS allowed regions are aws-us-east-1
        Azure allowed regions are azure-eastus2
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['ConnectionAwsArgs']] = None,
                 azure: Optional[pulumi.Input['ConnectionAzureArgs']] = None,
                 cloud_resource: Optional[pulumi.Input['ConnectionCloudResourceArgs']] = None,
                 cloud_spanner: Optional[pulumi.Input['ConnectionCloudSpannerArgs']] = None,
                 cloud_sql: Optional[pulumi.Input['ConnectionCloudSqlArgs']] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 has_credential: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input['ConnectionAwsArgs'] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input['ConnectionAzureArgs'] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudResourceArgs'] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSpannerArgs'] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input['ConnectionCloudSqlArgs'] cloud_sql: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[str] description: A descriptive description for the connection
        :param pulumi.Input[str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[bool] has_credential: True if the connection has credential assigned.
        :param pulumi.Input[str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[str] name: The resource name of the connection in the form of:
               "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if cloud_resource is not None:
            pulumi.set(__self__, "cloud_resource", cloud_resource)
        if cloud_spanner is not None:
            pulumi.set(__self__, "cloud_spanner", cloud_spanner)
        if cloud_sql is not None:
            pulumi.set(__self__, "cloud_sql", cloud_sql)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if has_credential is not None:
            pulumi.set(__self__, "has_credential", has_credential)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['ConnectionAwsArgs']]:
        """
        Connection properties specific to Amazon Web Services.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['ConnectionAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['ConnectionAzureArgs']]:
        """
        Container for connection properties specific to Azure.
        Structure is documented below.
        """
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['ConnectionAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="cloudResource")
    def cloud_resource(self) -> Optional[pulumi.Input['ConnectionCloudResourceArgs']]:
        """
        Container for connection properties for delegation of access to GCP resources.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_resource")

    @cloud_resource.setter
    def cloud_resource(self, value: Optional[pulumi.Input['ConnectionCloudResourceArgs']]):
        pulumi.set(self, "cloud_resource", value)

    @property
    @pulumi.getter(name="cloudSpanner")
    def cloud_spanner(self) -> Optional[pulumi.Input['ConnectionCloudSpannerArgs']]:
        """
        Connection properties specific to Cloud Spanner
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_spanner")

    @cloud_spanner.setter
    def cloud_spanner(self, value: Optional[pulumi.Input['ConnectionCloudSpannerArgs']]):
        pulumi.set(self, "cloud_spanner", value)

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> Optional[pulumi.Input['ConnectionCloudSqlArgs']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql")

    @cloud_sql.setter
    def cloud_sql(self, value: Optional[pulumi.Input['ConnectionCloudSqlArgs']]):
        pulumi.set(self, "cloud_sql", value)

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional connection id that should be assigned to the created connection.
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive description for the connection
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the connection
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the connection has credential assigned.
        """
        return pulumi.get(self, "has_credential")

    @has_credential.setter
    def has_credential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "has_credential", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The geographic location where the connection should reside.
        Cloud SQL instance must be in the same location as the connection
        with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
        Examples: US, EU, asia-northeast1, us-central1, europe-west1.
        Spanner Connections same as spanner region
        AWS allowed regions are aws-us-east-1
        Azure allowed regions are azure-eastus2
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the connection in the form of:
        "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[pulumi.InputType['ConnectionAwsArgs']]] = None,
                 azure: Optional[pulumi.Input[pulumi.InputType['ConnectionAzureArgs']]] = None,
                 cloud_resource: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudResourceArgs']]] = None,
                 cloud_spanner: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudSpannerArgs']]] = None,
                 cloud_sql: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudSqlArgs']]] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Bigquery Connection Cloud Resource

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            cloud_resource=gcp.bigquery.ConnectionCloudResourceArgs(),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="US")
        ```
        ### Bigquery Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            friendly_name="👋",
            description="a riveting description",
            location="US",
            cloud_sql=gcp.bigquery.ConnectionCloudSqlArgs(
                instance_id=instance.connection_name,
                database=db.name,
                type="POSTGRES",
                credential=gcp.bigquery.ConnectionCloudSqlCredentialArgs(
                    username=user.name,
                    password=user.password,
                ),
            ))
        ```
        ### Bigquery Connection Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_sql=gcp.bigquery.ConnectionCloudSqlArgs(
                instance_id=instance.connection_name,
                database=db.name,
                type="POSTGRES",
                credential=gcp.bigquery.ConnectionCloudSqlCredentialArgs(
                    username=user.name,
                    password=user.password,
                ),
            ))
        ```
        ### Bigquery Connection Aws

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            aws=gcp.bigquery.ConnectionAwsArgs(
                access_role=gcp.bigquery.ConnectionAwsAccessRoleArgs(
                    iam_role_id="arn:aws:iam::999999999999:role/omnirole",
                ),
            ),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="aws-us-east-1")
        ```
        ### Bigquery Connection Azure

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            azure=gcp.bigquery.ConnectionAzureArgs(
                customer_tenant_id="customer-tenant-id",
            ),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="azure-eastus2")
        ```
        ### Bigquery Connection Cloudspanner

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            cloud_spanner=gcp.bigquery.ConnectionCloudSpannerArgs(
                database="projects/project/instances/instance/databases/database",
            ),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="US")
        ```

        ## Import

        Connection can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigquery/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{connection_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/connection:Connection default {{project}}/{{location}}/{{connection_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/connection:Connection default {{location}}/{{connection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionAwsArgs']] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionAzureArgs']] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionCloudResourceArgs']] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionCloudSpannerArgs']] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionCloudSqlArgs']] cloud_sql: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[str] description: A descriptive description for the connection
        :param pulumi.Input[str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ConnectionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Bigquery Connection Cloud Resource

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            cloud_resource=gcp.bigquery.ConnectionCloudResourceArgs(),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="US")
        ```
        ### Bigquery Connection Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            friendly_name="👋",
            description="a riveting description",
            location="US",
            cloud_sql=gcp.bigquery.ConnectionCloudSqlArgs(
                instance_id=instance.connection_name,
                database=db.name,
                type="POSTGRES",
                credential=gcp.bigquery.ConnectionCloudSqlCredentialArgs(
                    username=user.name,
                    password=user.password,
                ),
            ))
        ```
        ### Bigquery Connection Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        instance = gcp.sql.DatabaseInstance("instance",
            database_version="POSTGRES_11",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            password=pwd.result)
        connection = gcp.bigquery.Connection("connection",
            connection_id="my-connection",
            location="US",
            friendly_name="👋",
            description="a riveting description",
            cloud_sql=gcp.bigquery.ConnectionCloudSqlArgs(
                instance_id=instance.connection_name,
                database=db.name,
                type="POSTGRES",
                credential=gcp.bigquery.ConnectionCloudSqlCredentialArgs(
                    username=user.name,
                    password=user.password,
                ),
            ))
        ```
        ### Bigquery Connection Aws

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            aws=gcp.bigquery.ConnectionAwsArgs(
                access_role=gcp.bigquery.ConnectionAwsAccessRoleArgs(
                    iam_role_id="arn:aws:iam::999999999999:role/omnirole",
                ),
            ),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="aws-us-east-1")
        ```
        ### Bigquery Connection Azure

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            azure=gcp.bigquery.ConnectionAzureArgs(
                customer_tenant_id="customer-tenant-id",
            ),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="azure-eastus2")
        ```
        ### Bigquery Connection Cloudspanner

        ```python
        import pulumi
        import pulumi_gcp as gcp

        connection = gcp.bigquery.Connection("connection",
            cloud_spanner=gcp.bigquery.ConnectionCloudSpannerArgs(
                database="projects/project/instances/instance/databases/database",
            ),
            connection_id="my-connection",
            description="a riveting description",
            friendly_name="👋",
            location="US")
        ```

        ## Import

        Connection can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigquery/connection:Connection default projects/{{project}}/locations/{{location}}/connections/{{connection_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/connection:Connection default {{project}}/{{location}}/{{connection_id}}
        ```

        ```sh
         $ pulumi import gcp:bigquery/connection:Connection default {{location}}/{{connection_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[pulumi.InputType['ConnectionAwsArgs']]] = None,
                 azure: Optional[pulumi.Input[pulumi.InputType['ConnectionAzureArgs']]] = None,
                 cloud_resource: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudResourceArgs']]] = None,
                 cloud_spanner: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudSpannerArgs']]] = None,
                 cloud_sql: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudSqlArgs']]] = None,
                 connection_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azure"] = azure
            __props__.__dict__["cloud_resource"] = cloud_resource
            __props__.__dict__["cloud_spanner"] = cloud_spanner
            __props__.__dict__["cloud_sql"] = cloud_sql
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["description"] = description
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["has_credential"] = None
            __props__.__dict__["name"] = None
        super(Connection, __self__).__init__(
            'gcp:bigquery/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[pulumi.InputType['ConnectionAwsArgs']]] = None,
            azure: Optional[pulumi.Input[pulumi.InputType['ConnectionAzureArgs']]] = None,
            cloud_resource: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudResourceArgs']]] = None,
            cloud_spanner: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudSpannerArgs']]] = None,
            cloud_sql: Optional[pulumi.Input[pulumi.InputType['ConnectionCloudSqlArgs']]] = None,
            connection_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            has_credential: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ConnectionAwsArgs']] aws: Connection properties specific to Amazon Web Services.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionAzureArgs']] azure: Container for connection properties specific to Azure.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionCloudResourceArgs']] cloud_resource: Container for connection properties for delegation of access to GCP resources.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionCloudSpannerArgs']] cloud_spanner: Connection properties specific to Cloud Spanner
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['ConnectionCloudSqlArgs']] cloud_sql: A nested object resource
               Structure is documented below.
        :param pulumi.Input[str] connection_id: Optional connection id that should be assigned to the created connection.
        :param pulumi.Input[str] description: A descriptive description for the connection
        :param pulumi.Input[str] friendly_name: A descriptive name for the connection
        :param pulumi.Input[bool] has_credential: True if the connection has credential assigned.
        :param pulumi.Input[str] location: The geographic location where the connection should reside.
               Cloud SQL instance must be in the same location as the connection
               with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
               Examples: US, EU, asia-northeast1, us-central1, europe-west1.
               Spanner Connections same as spanner region
               AWS allowed regions are aws-us-east-1
               Azure allowed regions are azure-eastus2
        :param pulumi.Input[str] name: The resource name of the connection in the form of:
               "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azure"] = azure
        __props__.__dict__["cloud_resource"] = cloud_resource
        __props__.__dict__["cloud_spanner"] = cloud_spanner
        __props__.__dict__["cloud_sql"] = cloud_sql
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["description"] = description
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["has_credential"] = has_credential
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.ConnectionAws']]:
        """
        Connection properties specific to Amazon Web Services.
        Structure is documented below.
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azure(self) -> pulumi.Output[Optional['outputs.ConnectionAzure']]:
        """
        Container for connection properties specific to Azure.
        Structure is documented below.
        """
        return pulumi.get(self, "azure")

    @property
    @pulumi.getter(name="cloudResource")
    def cloud_resource(self) -> pulumi.Output[Optional['outputs.ConnectionCloudResource']]:
        """
        Container for connection properties for delegation of access to GCP resources.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_resource")

    @property
    @pulumi.getter(name="cloudSpanner")
    def cloud_spanner(self) -> pulumi.Output[Optional['outputs.ConnectionCloudSpanner']]:
        """
        Connection properties specific to Cloud Spanner
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_spanner")

    @property
    @pulumi.getter(name="cloudSql")
    def cloud_sql(self) -> pulumi.Output[Optional['outputs.ConnectionCloudSql']]:
        """
        A nested object resource
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[str]:
        """
        Optional connection id that should be assigned to the created connection.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A descriptive description for the connection
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[str]]:
        """
        A descriptive name for the connection
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="hasCredential")
    def has_credential(self) -> pulumi.Output[bool]:
        """
        True if the connection has credential assigned.
        """
        return pulumi.get(self, "has_credential")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The geographic location where the connection should reside.
        Cloud SQL instance must be in the same location as the connection
        with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
        Examples: US, EU, asia-northeast1, us-central1, europe-west1.
        Spanner Connections same as spanner region
        AWS allowed regions are aws-us-east-1
        Azure allowed regions are azure-eastus2
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the connection in the form of:
        "projects/{project_id}/locations/{location_id}/connections/{connectionId}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

