# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'FunctionBuildConfigArgs',
    'FunctionBuildConfigSourceArgs',
    'FunctionBuildConfigSourceRepoSourceArgs',
    'FunctionBuildConfigSourceStorageSourceArgs',
    'FunctionEventTriggerArgs',
    'FunctionIamBindingConditionArgs',
    'FunctionIamMemberConditionArgs',
    'FunctionServiceConfigArgs',
]

@pulumi.input_type
class FunctionBuildConfigArgs:
    def __init__(__self__, *,
                 build: Optional[pulumi.Input[str]] = None,
                 docker_repository: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input['FunctionBuildConfigSourceArgs']] = None,
                 worker_pool: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] build: -
               The Cloud Build name of the latest successful
               deployment of the function.
        :param pulumi.Input[str] docker_repository: User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        :param pulumi.Input[str] entry_point: The name of the function (as defined in source code) that will be executed.
               Defaults to the resource name suffix, if not specified. For backward
               compatibility, if function with given name is not found, then the system
               will try to use function named "function". For Node.js this is name of a
               function exported by the module specified in source_location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables that shall be available during function execution.
        :param pulumi.Input[str] runtime: The runtime in which to run the function. Required when deploying a new
               function, optional when updating an existing function.
        :param pulumi.Input['FunctionBuildConfigSourceArgs'] source: The location of the function source code.
               Structure is documented below.
        :param pulumi.Input[str] worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        if build is not None:
            pulumi.set(__self__, "build", build)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter
    def build(self) -> Optional[pulumi.Input[str]]:
        """
        -
        The Cloud Build name of the latest successful
        deployment of the function.
        """
        return pulumi.get(self, "build")

    @build.setter
    def build(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build", value)

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional[pulumi.Input[str]]:
        """
        User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        """
        return pulumi.get(self, "docker_repository")

    @docker_repository.setter
    def docker_repository(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docker_repository", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the function (as defined in source code) that will be executed.
        Defaults to the resource name suffix, if not specified. For backward
        compatibility, if function with given name is not found, then the system
        will try to use function named "function". For Node.js this is name of a
        function exported by the module specified in source_location.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime in which to run the function. Required when deploying a new
        function, optional when updating an existing function.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['FunctionBuildConfigSourceArgs']]:
        """
        The location of the function source code.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['FunctionBuildConfigSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "worker_pool")

    @worker_pool.setter
    def worker_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_pool", value)


@pulumi.input_type
class FunctionBuildConfigSourceArgs:
    def __init__(__self__, *,
                 repo_source: Optional[pulumi.Input['FunctionBuildConfigSourceRepoSourceArgs']] = None,
                 storage_source: Optional[pulumi.Input['FunctionBuildConfigSourceStorageSourceArgs']] = None):
        """
        :param pulumi.Input['FunctionBuildConfigSourceRepoSourceArgs'] repo_source: If provided, get the source from this location in a Cloud Source Repository.
               Structure is documented below.
        :param pulumi.Input['FunctionBuildConfigSourceStorageSourceArgs'] storage_source: If provided, get the source from this location in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional[pulumi.Input['FunctionBuildConfigSourceRepoSourceArgs']]:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @repo_source.setter
    def repo_source(self, value: Optional[pulumi.Input['FunctionBuildConfigSourceRepoSourceArgs']]):
        pulumi.set(self, "repo_source", value)

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional[pulumi.Input['FunctionBuildConfigSourceStorageSourceArgs']]:
        """
        If provided, get the source from this location in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")

    @storage_source.setter
    def storage_source(self, value: Optional[pulumi.Input['FunctionBuildConfigSourceStorageSourceArgs']]):
        pulumi.set(self, "storage_source", value)


@pulumi.input_type
class FunctionBuildConfigSourceRepoSourceArgs:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch_name: Regex matching branches to build.
        :param pulumi.Input[str] commit_sha: Regex matching tags to build.
        :param pulumi.Input[str] dir: Directory, relative to the source root, in which to run the build.
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does
               NOT match the revision regex.
        :param pulumi.Input[str] project_id: ID of the project that owns the Cloud Source Repository. If omitted, the
               project ID requesting the build is assumed.
        :param pulumi.Input[str] repo_name: Name of the Cloud Source Repository.
        :param pulumi.Input[str] tag_name: Regex matching tags to build.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching branches to build.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Directory, relative to the source root, in which to run the build.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does
        NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the
        project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class FunctionBuildConfigSourceStorageSourceArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[int]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Google Cloud Storage bucket containing the source
        :param pulumi.Input[int] generation: Google Cloud Storage generation for the object. If the generation
               is omitted, the latest generation will be used.
        :param pulumi.Input[str] object: Google Cloud Storage object containing the source.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket containing the source
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[int]]:
        """
        Google Cloud Storage generation for the object. If the generation
        is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage object containing the source.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class FunctionEventTriggerArgs:
    def __init__(__self__, *,
                 event_type: Optional[pulumi.Input[str]] = None,
                 pubsub_topic: Optional[pulumi.Input[str]] = None,
                 retry_policy: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 trigger: Optional[pulumi.Input[str]] = None,
                 trigger_region: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] event_type: Required. The type of event to observe.
        :param pulumi.Input[str] pubsub_topic: The name of a Pub/Sub topic in the same project that will be used
               as the transport topic for the event delivery.
        :param pulumi.Input[str] retry_policy: Describes the retry policy in case of function's execution failure.
               Retried execution is charged as any other execution.
               Possible values are `RETRY_POLICY_UNSPECIFIED`, `RETRY_POLICY_DO_NOT_RETRY`, and `RETRY_POLICY_RETRY`.
        :param pulumi.Input[str] service_account_email: The email of the service account for this function.
        :param pulumi.Input[str] trigger: -
               The resource name of the Eventarc trigger.
        :param pulumi.Input[str] trigger_region: The region that the trigger will be in. The trigger will only receive
               events originating in this region. It can be the same
               region as the function, a different region or multi-region, or the global
               region. If not provided, defaults to the same region as the function.
        """
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if trigger_region is not None:
            pulumi.set(__self__, "trigger_region", trigger_region)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The type of event to observe.
        """
        return pulumi.get(self, "event_type")

    @event_type.setter
    def event_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_type", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a Pub/Sub topic in the same project that will be used
        as the transport topic for the event delivery.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the retry policy in case of function's execution failure.
        Retried execution is charged as any other execution.
        Possible values are `RETRY_POLICY_UNSPECIFIED`, `RETRY_POLICY_DO_NOT_RETRY`, and `RETRY_POLICY_RETRY`.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the service account for this function.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def trigger(self) -> Optional[pulumi.Input[str]]:
        """
        -
        The resource name of the Eventarc trigger.
        """
        return pulumi.get(self, "trigger")

    @trigger.setter
    def trigger(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger", value)

    @property
    @pulumi.getter(name="triggerRegion")
    def trigger_region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that the trigger will be in. The trigger will only receive
        events originating in this region. It can be the same
        region as the function, a different region or multi-region, or the global
        region. If not provided, defaults to the same region as the function.
        """
        return pulumi.get(self, "trigger_region")

    @trigger_region.setter
    def trigger_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_region", value)


@pulumi.input_type
class FunctionIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class FunctionIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class FunctionServiceConfigArgs:
    def __init__(__self__, *,
                 all_traffic_on_latest_revision: Optional[pulumi.Input[bool]] = None,
                 available_memory: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 gcf_uri: Optional[pulumi.Input[str]] = None,
                 ingress_settings: Optional[pulumi.Input[str]] = None,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 vpc_connector: Optional[pulumi.Input[str]] = None,
                 vpc_connector_egress_settings: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] all_traffic_on_latest_revision: Whether 100% of traffic is routed to the latest revision. Defaults to true.
        :param pulumi.Input[str] available_memory: The amount of memory available for a function.
               Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
               supplied the value is interpreted as bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment_variables: Environment variables that shall be available during function execution.
        :param pulumi.Input[str] gcf_uri: -
               URIs of the Service deployed
        :param pulumi.Input[str] ingress_settings: Available ingress settings. Defaults to "ALLOW_ALL" if unspecified.
               Default value is `ALLOW_ALL`.
               Possible values are `ALLOW_ALL`, `ALLOW_INTERNAL_ONLY`, and `ALLOW_INTERNAL_AND_GCLB`.
        :param pulumi.Input[int] max_instance_count: The limit on the maximum number of function instances that may coexist at a
               given time.
        :param pulumi.Input[int] min_instance_count: The limit on the minimum number of function instances that may coexist at a
               given time.
        :param pulumi.Input[str] service: Name of the service associated with a Function.
        :param pulumi.Input[str] service_account_email: The email of the service account for this function.
        :param pulumi.Input[int] timeout_seconds: The function execution timeout. Execution is considered failed and
               can be terminated if the function is not completed at the end of the
               timeout period. Defaults to 60 seconds.
        :param pulumi.Input[str] uri: -
               URI of the Service deployed.
        :param pulumi.Input[str] vpc_connector: The Serverless VPC Access connector that this cloud function can connect to.
        :param pulumi.Input[str] vpc_connector_egress_settings: Available egress settings.
               Possible values are `VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED`, `PRIVATE_RANGES_ONLY`, and `ALL_TRAFFIC`.
        """
        if all_traffic_on_latest_revision is not None:
            pulumi.set(__self__, "all_traffic_on_latest_revision", all_traffic_on_latest_revision)
        if available_memory is not None:
            pulumi.set(__self__, "available_memory", available_memory)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if gcf_uri is not None:
            pulumi.set(__self__, "gcf_uri", gcf_uri)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter(name="allTrafficOnLatestRevision")
    def all_traffic_on_latest_revision(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether 100% of traffic is routed to the latest revision. Defaults to true.
        """
        return pulumi.get(self, "all_traffic_on_latest_revision")

    @all_traffic_on_latest_revision.setter
    def all_traffic_on_latest_revision(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_traffic_on_latest_revision", value)

    @property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> Optional[pulumi.Input[str]]:
        """
        The amount of memory available for a function.
        Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
        supplied the value is interpreted as bytes.
        """
        return pulumi.get(self, "available_memory")

    @available_memory.setter
    def available_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "available_memory", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="gcfUri")
    def gcf_uri(self) -> Optional[pulumi.Input[str]]:
        """
        -
        URIs of the Service deployed
        """
        return pulumi.get(self, "gcf_uri")

    @gcf_uri.setter
    def gcf_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcf_uri", value)

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Available ingress settings. Defaults to "ALLOW_ALL" if unspecified.
        Default value is `ALLOW_ALL`.
        Possible values are `ALLOW_ALL`, `ALLOW_INTERNAL_ONLY`, and `ALLOW_INTERNAL_AND_GCLB`.
        """
        return pulumi.get(self, "ingress_settings")

    @ingress_settings.setter
    def ingress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_settings", value)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the maximum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        The limit on the minimum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the service associated with a Function.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        The email of the service account for this function.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The function execution timeout. Execution is considered failed and
        can be terminated if the function is not completed at the end of the
        timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        -
        URI of the Service deployed.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[pulumi.Input[str]]:
        """
        The Serverless VPC Access connector that this cloud function can connect to.
        """
        return pulumi.get(self, "vpc_connector")

    @vpc_connector.setter
    def vpc_connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector", value)

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Available egress settings.
        Possible values are `VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED`, `PRIVATE_RANGES_ONLY`, and `ALL_TRAFFIC`.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")

    @vpc_connector_egress_settings.setter
    def vpc_connector_egress_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_connector_egress_settings", value)


