# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetKMSSecretAsymmetricResult',
    'AwaitableGetKMSSecretAsymmetricResult',
    'get_kms_secret_asymmetric',
    'get_kms_secret_asymmetric_output',
]

@pulumi.output_type
class GetKMSSecretAsymmetricResult:
    """
    A collection of values returned by getKMSSecretAsymmetric.
    """
    def __init__(__self__, ciphertext=None, crc32=None, crypto_key_version=None, id=None, plaintext=None):
        if ciphertext and not isinstance(ciphertext, str):
            raise TypeError("Expected argument 'ciphertext' to be a str")
        pulumi.set(__self__, "ciphertext", ciphertext)
        if crc32 and not isinstance(crc32, str):
            raise TypeError("Expected argument 'crc32' to be a str")
        pulumi.set(__self__, "crc32", crc32)
        if crypto_key_version and not isinstance(crypto_key_version, str):
            raise TypeError("Expected argument 'crypto_key_version' to be a str")
        pulumi.set(__self__, "crypto_key_version", crypto_key_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)

    @property
    @pulumi.getter
    def ciphertext(self) -> str:
        return pulumi.get(self, "ciphertext")

    @property
    @pulumi.getter
    def crc32(self) -> Optional[str]:
        """
        Contains the crc32 checksum of the provided ciphertext.
        """
        return pulumi.get(self, "crc32")

    @property
    @pulumi.getter(name="cryptoKeyVersion")
    def crypto_key_version(self) -> str:
        return pulumi.get(self, "crypto_key_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def plaintext(self) -> str:
        """
        Contains the result of decrypting the provided ciphertext.
        """
        return pulumi.get(self, "plaintext")


class AwaitableGetKMSSecretAsymmetricResult(GetKMSSecretAsymmetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKMSSecretAsymmetricResult(
            ciphertext=self.ciphertext,
            crc32=self.crc32,
            crypto_key_version=self.crypto_key_version,
            id=self.id,
            plaintext=self.plaintext)


def get_kms_secret_asymmetric(ciphertext: Optional[str] = None,
                              crc32: Optional[str] = None,
                              crypto_key_version: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKMSSecretAsymmetricResult:
    """
    ## get the public key to encrypt the secret with

    $ gcloud kms keys versions get-public-key 1\
      --project my-project\
      --location us-central1\
      --keyring my-key-ring\
      --key my-crypto-key\
      --output-file public-key.pem

    ## encrypt secret with the public key

    $ echo -n my-secret-password |\
      openssl pkeyutl -in -\
        -encrypt\
        -pubin\
        -inkey public-key.pem\
        -pkeyopt rsa_padding_mode:oaep\
        -pkeyopt rsa_oaep_md:sha256\
        -pkeyopt rsa_mgf1_md:sha256 >\
      my-secret-password.enc

    ## base64 encode the ciphertext

    $ openssl base64 -in my-secret-password.enc
    M7nUoba9EGVTu2LjNjBKGdGVBYjyS/i/AY+4yQMQF0Qf/RfUfX31Jw6+VO9OuThq
    ylu/7ihX9XD4bM7yYdXnMv9p1OHQUlorSBSbb/J6n1W9UJhcp6um8Tw8/Isx4f75
    4PskYS6f8Y2ItliGt1/A9iR5BTgGtJBwOxMlgoX2Ggq+Nh4E5SbdoaE5o6CO1nBx
    eIPsPEebQ6qC4JehQM3IGuV/lrm58+hZhaXAqNzX1cEYyAt5GYqJIVCiI585SUYs
    wRToGyTgaN+zthF0HP9IWlR4Am4LmJ/1OcePTnYw11CkU8wNRbDzVAzogwNH+rXr
    LTmf7hxVjBm6bBSVSNFcBKAXFlllubSfIeZ5hgzGqn54OmSf6odO12L5JxllddHc
    yAd54vWKs2kJtnsKV2V4ZdkI0w6y1TeI67baFZDNGo6qsCpFMPnvv7d46Pg2VOp1
    J6Ivner0NnNHE4MzNmpZRk8WXMwqq4P/gTiT7F/aCX6oFCUQ4AWPQhJYh2dkcOmL
    IP+47Veb10aFn61F1CJwpmOOiGNXKdDT1vK8CMnnwhm825K0q/q9Zqpzc1+1ae1z
    mSqol1zCoa88CuSN6nTLQlVnN/dzfrGbc0boJPaM0iGhHtSzHk4SWg84LhiJB1q9
    A9XFJmOVdkvRY9nnz/iVLAdd0Q3vFtLqCdUYsNN2yh4=


    :param str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param str crc32: The crc32 checksum of the `ciphertext` in hexadecimal notation. If not specified, it will be computed.
    :param str crypto_key_version: The id of the CryptoKey version that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}`.
    """
    __args__ = dict()
    __args__['ciphertext'] = ciphertext
    __args__['crc32'] = crc32
    __args__['cryptoKeyVersion'] = crypto_key_version
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKMSSecretAsymmetric:getKMSSecretAsymmetric', __args__, opts=opts, typ=GetKMSSecretAsymmetricResult).value

    return AwaitableGetKMSSecretAsymmetricResult(
        ciphertext=__ret__.ciphertext,
        crc32=__ret__.crc32,
        crypto_key_version=__ret__.crypto_key_version,
        id=__ret__.id,
        plaintext=__ret__.plaintext)


@_utilities.lift_output_func(get_kms_secret_asymmetric)
def get_kms_secret_asymmetric_output(ciphertext: Optional[pulumi.Input[str]] = None,
                                     crc32: Optional[pulumi.Input[Optional[str]]] = None,
                                     crypto_key_version: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKMSSecretAsymmetricResult]:
    """
    ## get the public key to encrypt the secret with

    $ gcloud kms keys versions get-public-key 1\
      --project my-project\
      --location us-central1\
      --keyring my-key-ring\
      --key my-crypto-key\
      --output-file public-key.pem

    ## encrypt secret with the public key

    $ echo -n my-secret-password |\
      openssl pkeyutl -in -\
        -encrypt\
        -pubin\
        -inkey public-key.pem\
        -pkeyopt rsa_padding_mode:oaep\
        -pkeyopt rsa_oaep_md:sha256\
        -pkeyopt rsa_mgf1_md:sha256 >\
      my-secret-password.enc

    ## base64 encode the ciphertext

    $ openssl base64 -in my-secret-password.enc
    M7nUoba9EGVTu2LjNjBKGdGVBYjyS/i/AY+4yQMQF0Qf/RfUfX31Jw6+VO9OuThq
    ylu/7ihX9XD4bM7yYdXnMv9p1OHQUlorSBSbb/J6n1W9UJhcp6um8Tw8/Isx4f75
    4PskYS6f8Y2ItliGt1/A9iR5BTgGtJBwOxMlgoX2Ggq+Nh4E5SbdoaE5o6CO1nBx
    eIPsPEebQ6qC4JehQM3IGuV/lrm58+hZhaXAqNzX1cEYyAt5GYqJIVCiI585SUYs
    wRToGyTgaN+zthF0HP9IWlR4Am4LmJ/1OcePTnYw11CkU8wNRbDzVAzogwNH+rXr
    LTmf7hxVjBm6bBSVSNFcBKAXFlllubSfIeZ5hgzGqn54OmSf6odO12L5JxllddHc
    yAd54vWKs2kJtnsKV2V4ZdkI0w6y1TeI67baFZDNGo6qsCpFMPnvv7d46Pg2VOp1
    J6Ivner0NnNHE4MzNmpZRk8WXMwqq4P/gTiT7F/aCX6oFCUQ4AWPQhJYh2dkcOmL
    IP+47Veb10aFn61F1CJwpmOOiGNXKdDT1vK8CMnnwhm825K0q/q9Zqpzc1+1ae1z
    mSqol1zCoa88CuSN6nTLQlVnN/dzfrGbc0boJPaM0iGhHtSzHk4SWg84LhiJB1q9
    A9XFJmOVdkvRY9nnz/iVLAdd0Q3vFtLqCdUYsNN2yh4=


    :param str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param str crc32: The crc32 checksum of the `ciphertext` in hexadecimal notation. If not specified, it will be computed.
    :param str crypto_key_version: The id of the CryptoKey version that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}`.
    """
    ...
