# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceResult',
    'AwaitableGetInstanceResult',
    'get_instance',
    'get_instance_output',
]

@pulumi.output_type
class GetInstanceResult:
    """
    A collection of values returned by getInstance.
    """
    def __init__(__self__, alternative_location_id=None, auth_enabled=None, auth_string=None, authorized_network=None, connect_mode=None, create_time=None, current_location_id=None, customer_managed_key=None, display_name=None, host=None, id=None, labels=None, location_id=None, maintenance_policies=None, maintenance_schedules=None, memory_size_gb=None, name=None, nodes=None, persistence_iam_identity=None, port=None, project=None, read_endpoint=None, read_endpoint_port=None, read_replicas_mode=None, redis_configs=None, redis_version=None, region=None, replica_count=None, reserved_ip_range=None, secondary_ip_range=None, server_ca_certs=None, tier=None, transit_encryption_mode=None):
        if alternative_location_id and not isinstance(alternative_location_id, str):
            raise TypeError("Expected argument 'alternative_location_id' to be a str")
        pulumi.set(__self__, "alternative_location_id", alternative_location_id)
        if auth_enabled and not isinstance(auth_enabled, bool):
            raise TypeError("Expected argument 'auth_enabled' to be a bool")
        pulumi.set(__self__, "auth_enabled", auth_enabled)
        if auth_string and not isinstance(auth_string, str):
            raise TypeError("Expected argument 'auth_string' to be a str")
        pulumi.set(__self__, "auth_string", auth_string)
        if authorized_network and not isinstance(authorized_network, str):
            raise TypeError("Expected argument 'authorized_network' to be a str")
        pulumi.set(__self__, "authorized_network", authorized_network)
        if connect_mode and not isinstance(connect_mode, str):
            raise TypeError("Expected argument 'connect_mode' to be a str")
        pulumi.set(__self__, "connect_mode", connect_mode)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if current_location_id and not isinstance(current_location_id, str):
            raise TypeError("Expected argument 'current_location_id' to be a str")
        pulumi.set(__self__, "current_location_id", current_location_id)
        if customer_managed_key and not isinstance(customer_managed_key, str):
            raise TypeError("Expected argument 'customer_managed_key' to be a str")
        pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if host and not isinstance(host, str):
            raise TypeError("Expected argument 'host' to be a str")
        pulumi.set(__self__, "host", host)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location_id and not isinstance(location_id, str):
            raise TypeError("Expected argument 'location_id' to be a str")
        pulumi.set(__self__, "location_id", location_id)
        if maintenance_policies and not isinstance(maintenance_policies, list):
            raise TypeError("Expected argument 'maintenance_policies' to be a list")
        pulumi.set(__self__, "maintenance_policies", maintenance_policies)
        if maintenance_schedules and not isinstance(maintenance_schedules, list):
            raise TypeError("Expected argument 'maintenance_schedules' to be a list")
        pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if memory_size_gb and not isinstance(memory_size_gb, int):
            raise TypeError("Expected argument 'memory_size_gb' to be a int")
        pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nodes and not isinstance(nodes, list):
            raise TypeError("Expected argument 'nodes' to be a list")
        pulumi.set(__self__, "nodes", nodes)
        if persistence_iam_identity and not isinstance(persistence_iam_identity, str):
            raise TypeError("Expected argument 'persistence_iam_identity' to be a str")
        pulumi.set(__self__, "persistence_iam_identity", persistence_iam_identity)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if read_endpoint and not isinstance(read_endpoint, str):
            raise TypeError("Expected argument 'read_endpoint' to be a str")
        pulumi.set(__self__, "read_endpoint", read_endpoint)
        if read_endpoint_port and not isinstance(read_endpoint_port, int):
            raise TypeError("Expected argument 'read_endpoint_port' to be a int")
        pulumi.set(__self__, "read_endpoint_port", read_endpoint_port)
        if read_replicas_mode and not isinstance(read_replicas_mode, str):
            raise TypeError("Expected argument 'read_replicas_mode' to be a str")
        pulumi.set(__self__, "read_replicas_mode", read_replicas_mode)
        if redis_configs and not isinstance(redis_configs, dict):
            raise TypeError("Expected argument 'redis_configs' to be a dict")
        pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version and not isinstance(redis_version, str):
            raise TypeError("Expected argument 'redis_version' to be a str")
        pulumi.set(__self__, "redis_version", redis_version)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if replica_count and not isinstance(replica_count, int):
            raise TypeError("Expected argument 'replica_count' to be a int")
        pulumi.set(__self__, "replica_count", replica_count)
        if reserved_ip_range and not isinstance(reserved_ip_range, str):
            raise TypeError("Expected argument 'reserved_ip_range' to be a str")
        pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if secondary_ip_range and not isinstance(secondary_ip_range, str):
            raise TypeError("Expected argument 'secondary_ip_range' to be a str")
        pulumi.set(__self__, "secondary_ip_range", secondary_ip_range)
        if server_ca_certs and not isinstance(server_ca_certs, list):
            raise TypeError("Expected argument 'server_ca_certs' to be a list")
        pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if transit_encryption_mode and not isinstance(transit_encryption_mode, str):
            raise TypeError("Expected argument 'transit_encryption_mode' to be a str")
        pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)

    @property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> str:
        return pulumi.get(self, "alternative_location_id")

    @property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> bool:
        return pulumi.get(self, "auth_enabled")

    @property
    @pulumi.getter(name="authString")
    def auth_string(self) -> str:
        return pulumi.get(self, "auth_string")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> str:
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> str:
        return pulumi.get(self, "connect_mode")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentLocationId")
    def current_location_id(self) -> str:
        return pulumi.get(self, "current_location_id")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> str:
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def host(self) -> str:
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> str:
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter(name="maintenancePolicies")
    def maintenance_policies(self) -> Sequence['outputs.GetInstanceMaintenancePolicyResult']:
        return pulumi.get(self, "maintenance_policies")

    @property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Sequence['outputs.GetInstanceMaintenanceScheduleResult']:
        return pulumi.get(self, "maintenance_schedules")

    @property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> int:
        return pulumi.get(self, "memory_size_gb")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetInstanceNodeResult']:
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="persistenceIamIdentity")
    def persistence_iam_identity(self) -> str:
        return pulumi.get(self, "persistence_iam_identity")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> str:
        return pulumi.get(self, "read_endpoint")

    @property
    @pulumi.getter(name="readEndpointPort")
    def read_endpoint_port(self) -> int:
        return pulumi.get(self, "read_endpoint_port")

    @property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> str:
        return pulumi.get(self, "read_replicas_mode")

    @property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Mapping[str, str]:
        return pulumi.get(self, "redis_configs")

    @property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> str:
        return pulumi.get(self, "redis_version")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> int:
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> str:
        return pulumi.get(self, "reserved_ip_range")

    @property
    @pulumi.getter(name="secondaryIpRange")
    def secondary_ip_range(self) -> str:
        return pulumi.get(self, "secondary_ip_range")

    @property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Sequence['outputs.GetInstanceServerCaCertResult']:
        return pulumi.get(self, "server_ca_certs")

    @property
    @pulumi.getter
    def tier(self) -> str:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> str:
        return pulumi.get(self, "transit_encryption_mode")


class AwaitableGetInstanceResult(GetInstanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceResult(
            alternative_location_id=self.alternative_location_id,
            auth_enabled=self.auth_enabled,
            auth_string=self.auth_string,
            authorized_network=self.authorized_network,
            connect_mode=self.connect_mode,
            create_time=self.create_time,
            current_location_id=self.current_location_id,
            customer_managed_key=self.customer_managed_key,
            display_name=self.display_name,
            host=self.host,
            id=self.id,
            labels=self.labels,
            location_id=self.location_id,
            maintenance_policies=self.maintenance_policies,
            maintenance_schedules=self.maintenance_schedules,
            memory_size_gb=self.memory_size_gb,
            name=self.name,
            nodes=self.nodes,
            persistence_iam_identity=self.persistence_iam_identity,
            port=self.port,
            project=self.project,
            read_endpoint=self.read_endpoint,
            read_endpoint_port=self.read_endpoint_port,
            read_replicas_mode=self.read_replicas_mode,
            redis_configs=self.redis_configs,
            redis_version=self.redis_version,
            region=self.region,
            replica_count=self.replica_count,
            reserved_ip_range=self.reserved_ip_range,
            secondary_ip_range=self.secondary_ip_range,
            server_ca_certs=self.server_ca_certs,
            tier=self.tier,
            transit_encryption_mode=self.transit_encryption_mode)


def get_instance(name: Optional[str] = None,
                 project: Optional[str] = None,
                 region: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceResult:
    """
    Get info about a Google Cloud Redis instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_instance = gcp.redis.get_instance(name="my-redis-instance")
    pulumi.export("instanceMemorySizeGb", my_instance.memory_size_gb)
    pulumi.export("instanceConnectMode", my_instance.connect_mode)
    pulumi.export("instanceAuthorizedNetwork", my_instance.authorized_network)
    ```


    :param str name: The name of a Redis instance.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('gcp:redis/getInstance:getInstance', __args__, opts=opts, typ=GetInstanceResult).value

    return AwaitableGetInstanceResult(
        alternative_location_id=__ret__.alternative_location_id,
        auth_enabled=__ret__.auth_enabled,
        auth_string=__ret__.auth_string,
        authorized_network=__ret__.authorized_network,
        connect_mode=__ret__.connect_mode,
        create_time=__ret__.create_time,
        current_location_id=__ret__.current_location_id,
        customer_managed_key=__ret__.customer_managed_key,
        display_name=__ret__.display_name,
        host=__ret__.host,
        id=__ret__.id,
        labels=__ret__.labels,
        location_id=__ret__.location_id,
        maintenance_policies=__ret__.maintenance_policies,
        maintenance_schedules=__ret__.maintenance_schedules,
        memory_size_gb=__ret__.memory_size_gb,
        name=__ret__.name,
        nodes=__ret__.nodes,
        persistence_iam_identity=__ret__.persistence_iam_identity,
        port=__ret__.port,
        project=__ret__.project,
        read_endpoint=__ret__.read_endpoint,
        read_endpoint_port=__ret__.read_endpoint_port,
        read_replicas_mode=__ret__.read_replicas_mode,
        redis_configs=__ret__.redis_configs,
        redis_version=__ret__.redis_version,
        region=__ret__.region,
        replica_count=__ret__.replica_count,
        reserved_ip_range=__ret__.reserved_ip_range,
        secondary_ip_range=__ret__.secondary_ip_range,
        server_ca_certs=__ret__.server_ca_certs,
        tier=__ret__.tier,
        transit_encryption_mode=__ret__.transit_encryption_mode)


@_utilities.lift_output_func(get_instance)
def get_instance_output(name: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        region: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceResult]:
    """
    Get info about a Google Cloud Redis instance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_instance = gcp.redis.get_instance(name="my-redis-instance")
    pulumi.export("instanceMemorySizeGb", my_instance.memory_size_gb)
    pulumi.export("instanceConnectMode", my_instance.connect_mode)
    pulumi.export("instanceAuthorizedNetwork", my_instance.authorized_network)
    ```


    :param str name: The name of a Redis instance.
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    ...
